package freenet.node.states.request;

import freenet.*;
import freenet.node.*;
import freenet.message.*;
import freenet.support.Logger;

/**
 * This is the State pertaining to Insert and Data Requests that
 * are finished at this node.
 */

public class RequestDone extends State {
    
    /** this is in case we get a DataInsert we have to eat */
    final Peer origPeer;
    
    public RequestDone(RequestState ancestor) {
        super(ancestor.id());
        origPeer = ancestor.origPeer;
    }

    public final String getName() {
        return "Request Done";
    }

    // maybe we should have something to eat a DataInsert but by the time
    // we've made it to this state it is probably not needed in practice
    
    // ok, i was wrong, we do get here in practice before they got our
    // DataReply..

    public State received(Node n, MessageObject mo) throws BadStateException {
        if (mo instanceof Accepted) {
            return this;
        }
        else if (mo instanceof DataInsert
                 && (origPeer == null
                     || origPeer.equalsIdent(((DataInsert) mo).peerIdentity()))) {
            n.logger.log(this, "Eating DataInsert during RequestDone", Logger.DEBUG);
            ((DataInsert) mo).eatData(n);
            return this;
        }
        else if (!(mo instanceof Request)) {
            throw new BadStateException("Received " + mo + " for Request " + 
                                        "that was already handled");
        }
        else { // A looped request
            try {
                Request r = (Request) mo;
                if (r.getSource() != null) {
                    n.sendMessage(
                        new QueryRejected(id, r.hopsToLive - 1, "Looped request", r.otherFields),
                        r.getSource(), 0
                    );
                }
            }
            catch (CommunicationException e) {
                n.logger.log(this,
                    "Failed to backtrack on chain " + Long.toHexString(id),
                    e, Logger.DEBUG);
            }
            return this;
        }
    }

    public final int priority() {
        return EXPENDABLE;
    }

    public final void lost(Node n) {
        // good!
    }
}

