package freenet.node.states.request;

import freenet.*;
import freenet.node.*;
import freenet.node.states.data.*;
import freenet.message.*;
import freenet.support.*;
import java.io.*;

/**
 * This is the State pertaining to Data Requests sending data from the
 * node.
 */

public class SendingReply extends RequestState {

    /** the auxiliary chain that is sending the data */
    SendData sendingData;

    SendingReply(Pending ancestor) {
        super(ancestor);
        sendingData = ancestor.sendingData;
	Core.logger.log(this, "Creating SendingReply with "+sendingData+
			" from "+searchKey+" from "+ancestor, 
			new Exception("debug"), Core.logger.DEBUG);
    }

    /**
     * Returns the name.
     * @return "Sending data"
     */
    public final String getName() {
        return "Sending DataReply";
    }

    public State receivedMessage(Node n, DataSent ds) throws BadStateException {
        if (sendingData != ds.source()) {
            throw new BadStateException("Not my DataSent: "+ds);
        }

        int cb = ds.getCB();
        switch (cb) {
            case Presentation.CB_OK:
                n.logger.log(this, "Data sent successfully!: "+this, new Exception("debug"),
			     Logger.MINOR);
                try {
                    // return the noderef we would have routed to
                    // (there is still a chance of DataSource resetting)
                    // -1 means we don't know the rate for that ref.
		    n.diagnostics.occurrenceCounting("storeDataSendingReply",1);
                    ft.storeData(n, n.rt.route(searchKey, false).
				 getNextRoute(), -1, 0);
		    // We are sending from cache, no need to do pcaching
                }
                catch (CommunicationException e) {
                    n.logger.log(this,
                        "Failed to send back StoreData to peer " + e.peer+
				 " for "+this, e, Logger.MINOR);
		    // Not our fault, so still counts
                }
		// Update successful request distribution
		if(origPeer != null)
		{
		    if (n.successDataDistribution != null)
		    {
                        n.successDataDistribution.add(searchKey.getVal());
		    }
		    if(n.inboundRequests != null) 
		       n.inboundRequests.incActive(origPeer.getAddress().toString());
		}
		n.logger.log(this, "Finalizing sendingData: "+this, Logger.DEBUG);
		sendingData.finalize();
		return new RequestDone(this);
		
            case Presentation.CB_CACHE_FAILED:
		n.logger.log(this, "Cache failed: "+this, Logger.DEBUG);
                fail(n, "Cache failed");
                // fall through
            case Presentation.CB_SEND_CONN_DIED:
                n.logger.log(this,
                    "Dropping send on CB "+Presentation.getCBdescription(cb)
			     +", on chain "+Long.toHexString(id)+" for "+this,
			     (cb == Presentation.CB_CACHE_FAILED ? 
			      Logger.ERROR : Logger.MINOR));
                sendingData.finalize();
                return new RequestDone(this);
                
            // the StoreInputStream we were reading from got restarted
            default:
		n.logger.log(this, "Stream was restarted in "+
			     "receivedMessage(DataSent): "+this,
			     Logger.DEBUG);
                scheduleRestart(n, 0);
		sendingData.finalize();
                return new DataPending(this);
        }
    }

    /**
     * This is only needed for InsertRequests on key collisions, so really
     * it shouldn't be here - but the safety added is minimal so I'll
     * fix it another day. It just eats the data.
     */
    public State receivedMessage(Node n, DataInsert dim) throws BadStateException {
        if (!fromOrigPeer(dim)) {
            throw new BadStateException("DataInsert from the wrong peer!");
        }
        n.logger.log(this, "Eating DataInsert during SendingReply: "+this, Logger.DEBUG);
        dim.eatData(n);
        return this;
    }

    // There's not much we can do if the state is lost while sending data.
    // The MessageHandler will log it. 
    public final void lost(Node n) {
	n.logger.log(this, "Lost "+this, Logger.DEBUG);
        Core.diagnostics.occurrenceCounting("lostRequestState", 1);
    }
}



