package freenet.support;

/**
 * An irreversible may be changed once from the state in which it began, 
 * but never again.
 *
 * @author oskar
 */

public class Irreversible {

    private volatile boolean changed = false;
    private volatile boolean state;

    public Irreversible(boolean initialState) {
        this.state = initialState;
    }

    private final void priv_change(boolean newState) throws IrreversibleException {
        if (changed)
            throw new IrreversibleException();
        changed = true;
        state   = newState;
    }

    /**
     * Toggles the state.
     * @throws IrreversibleException  if the state already changed once
     */
    public final void change() throws IrreversibleException {
        priv_change(!state);
    }

    /**
     * @param newState new boolean value for the state
     * @throws IrreversibleException  only if newState != current state, and
     *                                already change once.
     */
    public final void change(boolean newState) throws IrreversibleException {
        if (state != newState)
            priv_change(newState);
    }

    public final boolean state() {
        return state;
    }
}

