package freenet.support;

public abstract class LoggerHook  {

    public int threshold;

    /** These indicate the verbosity levels for calls to log() **/
    
    /** This message indicates an error which prevents correct functionality**/
    public static final int ERROR = 16;
    /** A normal level occurrence **/
    public static final int NORMAL = 8;
    /** A minor occurrence that wouldn't normally be of interest **/
    public static final int MINOR = 4;
    /** An occurrence which would only be of interest during debugging **/
    public static final int DEBUGGING = 2;
    public static final int DEBUG = DEBUGGING;
    /** Internal occurrances used for eg distribution stats **/
    public static final int INTERNAL = 1;

  /**
   * Log a message
   * @param o The object where this message was generated.
   * @param source     The class where this message was generated.
   * @param message A clear and verbose message describing the event
   * @param e        Logs this exception with the message.
   * @param priority The priority of the mesage, one of Logger.ERROR,
   *                 Logger.NORMAL, Logger.MINOR, or Logger.DEBUGGING.
   */
  public abstract void log(Object o, Class source, String message, Throwable e,
			   int priority);

  public abstract long minFlags(); // ignore unless all these bits set
    
  public abstract long notFlags(); // reject if any of these bits set

  public abstract long anyFlags(); // accept if any of these bits set

  public boolean acceptPriority(int prio)
  {
      long mf = minFlags();
      long nf = notFlags();
      long af = anyFlags();
      if ((prio & mf) != mf) return false;
      if ((prio & nf) != 0) return false;
      if ((prio & af) != 0) return true;
      return false;
  }

    /**
     * Changes the priority threshold.
     * @param thresh   The new threshhold
     */
    public void setThreshold(int thresh) {
        this.threshold = thresh;
    }

}
