/* -*- Mode: java; c-basic-indent: 4; tab-width: 4 -*- */
package freenet.transport;
//hope this belongs here

import java.nio.channels.*;
import java.nio.ByteBuffer;
import freenet.SelectorLoop;
import java.net.Socket;
import java.util.*;
import java.io.IOException;
import freenet.NIOListener;

 /**
  * this selector registers ServerSocketChannels, the interfaces
  * listen on it.
  */
  public final class ListenSelectorLoop extends AbstractSelectorLoop {

  	//again, this is arbitrary.
  	private static final int MAX_NEW_CONNECTIONS = 20;
	

  	private HashMap readySockets;

	public ListenSelectorLoop() throws IOException{
		readySockets=new HashMap(MAX_NEW_CONNECTIONS);
	}

	protected final void beforeSelect() {
		readySockets.clear();
	}

	protected final int myKeyOps() {
		return SelectionKey.OP_ACCEPT;
	}

  	protected final boolean inspectChannels() {
		//we're good here, don't need fixkeys
		//currentSet = sel.selectedKeys();
		Iterator i = sel.selectedKeys().iterator();
		boolean noneWorking = true;
		try {
		while (i.hasNext()) {
			SelectionKey current = (SelectionKey)i.next();
			i.remove();
			ServerSocketChannel sc = (ServerSocketChannel)current.channel();

			//if this throws classcast exception it was misused.
			//I'll do the specific catching later
			NIOListener listener = (NIOListener) current.attachment();

			//this may not work - I'm guessing that if accept()
			//returns null, the channel is screwed.
			SocketChannel chan=null;
			try{
			chan = sc.accept();
			}catch (IOException e) {
				if (e.getMessage().indexOf("Too many open files")==-1) throw e;
				freenet.Core.logger.log(this,"too many incoming connections, disabling listener for a while",
						freenet.support.Logger.MINOR);
				sc.keyFor(sel).cancel();
				delayedWaiters.add(new DelayedChannelAttachmentPair(sc,listener, 5*1000));
				//FIXME: totally arbitrary, lets try 5 seconds.

			}

			if (chan == null) {
				sc.close();
				continue;
			}else {
				readySockets.put(chan,listener);
				noneWorking=false;
			}
		}
		}catch(Throwable t) {t.printStackTrace();}
		return noneWorking;

	}
	
    int oomSleep = 1000;
	  
    	//we're ok here
    	protected final void fixKeys() {}
	
	protected final boolean processConnections() {
		boolean success = true;
		oomSleep = 1000;
		try {
			Iterator i = readySockets.keySet().iterator();
			while (i.hasNext()) {
				try {
					SocketChannel chan = (SocketChannel)i.next();
					NIOListener listener = (NIOListener)readySockets.get(chan);
					listener.accept(chan.socket());
				} catch (OutOfMemoryError e) {
					System.gc();
					System.runFinalization();
					Thread.yield();
					System.gc();
					System.runFinalization();
					Thread.sleep(oomSleep);
					System.gc();
					System.runFinalization();
					oomSleep *= 2;
					try {
						String s = "Attempted to recover from OutOfMemoryError";
						freenet.Core.logger.log(this, s, 
												freenet.support.Logger.ERROR);
						System.err.println(s);
					} catch (Throwable t) {};
				} 
			}
		} catch (Throwable t) {
			System.err.println("Caught a "+t+
							   ", LSL.processConnections failing");
			t.printStackTrace();
			success=false;
		}
		
		return success;
		
	}
	
	/**
	 * the run method.  This is the place to add more init stuff
	 * NOTE: perhaps we want to catch exceptions here.  But for now
	 * I like to print everything on stderr.
	 */
	public final void run() {
		loop();
	}
	
	//TODO: need to decide what happens when we close the selector this way.
	public final void close(){}
  }
