/**
 * jline - Java console input library
 * Copyright (c) 2002,2003 Marc Prud'hommeaux marc@apocalypse.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
package jline;

import java.util.*;
import junit.framework.*;


/** 
 *  Tests command history.
 *  
 *  @author  <a href="mailto:marc@apocalypse.org">Marc Prud'hommeaux</a>
 */
public class TestCompletion
	extends JLineTestCase
{
	public TestCompletion (String test)
	{
		super (test);
	}


	public void testSimpleCompletor ()
		throws Exception
	{
		// clear any current completors
		for (Iterator i = console.getCompletors ().iterator ();
			i.hasNext (); console.removeCompletor ((Completor)i.next ()));

 		console.addCompletor (new SimpleCompletor (
			new String [] { "foo", "bar", "baz"}));

		assertBuffer ("foo ", new Buffer ("f").op (ConsoleReader.COMPLETE));
		// single tab completes to unabbiguous "ba"
		assertBuffer ("ba", new Buffer ("b").op (ConsoleReader.COMPLETE));
		assertBuffer ("ba", new Buffer ("ba").op (ConsoleReader.COMPLETE));
		assertBuffer ("baz ", new Buffer ("baz").op (ConsoleReader.COMPLETE));
	}


	public void testArgumentCompletor ()
		throws Exception
	{
		// clear any current completors
		for (Iterator i = console.getCompletors ().iterator ();
			i.hasNext (); console.removeCompletor ((Completor)i.next ()));

 		console.addCompletor (new ArgumentCompletor (
			new SimpleCompletor (new String [] { "foo", "bar", "baz"})));

		assertBuffer ("foo foo ", new Buffer ("foo f")
			.op (ConsoleReader.COMPLETE));
		assertBuffer ("foo ba", new Buffer ("foo b")
			.op (ConsoleReader.COMPLETE));
		assertBuffer ("foo ba", new Buffer ("foo ba")
			.op (ConsoleReader.COMPLETE));
		assertBuffer ("foo baz ", new Buffer ("foo baz")
			.op (ConsoleReader.COMPLETE));

		// test completion in the mid range
		assertBuffer ("foo baz", new Buffer ("f baz")
			.left ().left ().left ().left ()
			.op (ConsoleReader.COMPLETE));
		assertBuffer ("ba foo", new Buffer ("b foo")
			.left ().left ().left ().left ()
			.op (ConsoleReader.COMPLETE));
		assertBuffer ("foo ba baz", new Buffer ("foo b baz")
			.left ().left ().left ().left ()
			.op (ConsoleReader.COMPLETE));
		assertBuffer ("foo foo baz", new Buffer ("foo f baz")
			.left ().left ().left ().left ()
			.op (ConsoleReader.COMPLETE));
	}
}


