/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.helper;

import java.io.IOException;
import org.cyberneko.html.parsers.SAXParser;
import org.outerj.daisy.diff.helper.MergeCharacterEventsHandler;
import org.outerj.daisy.diff.helper.SaxBuffer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class NekoHtmlParser {
    public SaxBuffer parse(InputSource inputSource) throws IOException, SAXException {
        SaxBuffer saxBuffer = new SaxBuffer();
        this.parse(inputSource, saxBuffer);
        return saxBuffer;
    }

    public void parse(InputSource inputSource, ContentHandler contentHandler) throws IOException, SAXException {
        if (inputSource == null) {
            throw new NullPointerException("is argument is required.");
        }
        SAXParser sAXParser = new SAXParser();
        sAXParser.setFeature("http://xml.org/sax/features/namespaces", true);
        sAXParser.setFeature("http://cyberneko.org/html/features/override-namespaces", false);
        sAXParser.setFeature("http://cyberneko.org/html/features/insert-namespaces", false);
        sAXParser.setFeature("http://cyberneko.org/html/features/scanner/ignore-specified-charset", true);
        sAXParser.setProperty("http://cyberneko.org/html/properties/default-encoding", "UTF-8");
        sAXParser.setProperty("http://cyberneko.org/html/properties/names/elems", "lower");
        sAXParser.setProperty("http://cyberneko.org/html/properties/names/attrs", "lower");
        sAXParser.setContentHandler(new RemoveNamespacesHandler(new MergeCharacterEventsHandler(contentHandler)));
        sAXParser.parse(inputSource);
    }

    static class RemoveNamespacesHandler
    implements ContentHandler {
        private ContentHandler consumer;

        public RemoveNamespacesHandler(ContentHandler contentHandler) {
            this.consumer = contentHandler;
        }

        public void endDocument() throws SAXException {
            this.consumer.endDocument();
        }

        public void startDocument() throws SAXException {
            this.consumer.startDocument();
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.consumer.characters(cArray, n, n2);
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.consumer.ignorableWhitespace(cArray, n, n2);
        }

        public void endPrefixMapping(String string) throws SAXException {
        }

        public void skippedEntity(String string) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
            this.consumer.setDocumentLocator(locator);
        }

        public void processingInstruction(String string, String string2) throws SAXException {
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            this.consumer.endElement("", string2, string2);
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            AttributesImpl attributesImpl = new AttributesImpl(attributes);
            for (int i = 0; i < attributes.getLength(); ++i) {
                attributesImpl.setURI(i, "");
                attributesImpl.setQName(i, attributesImpl.getLocalName(i));
            }
            this.consumer.startElement("", string2, string2, attributes);
        }
    }
}

