/*
 * Decompiled with CFR 0.152.
 */
package org.outerj.daisy.diff.tag;

import org.outerj.daisy.diff.tag.Atom;
import org.outerj.daisy.diff.tag.TextAtom;

public class DelimiterAtom
extends TextAtom {
    public DelimiterAtom(char c) {
        super("" + c);
    }

    public static boolean isValidDelimiter(String string) {
        if (string.length() == 1) {
            return DelimiterAtom.isValidDelimiter(string.charAt(0));
        }
        return false;
    }

    public static boolean isValidDelimiter(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': 
            case '!': 
            case '\"': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '=': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '_': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    public boolean isValidAtom(String string) {
        return super.isValidAtom(string) && this.isValidDelimiterAtom(string);
    }

    private boolean isValidDelimiterAtom(String string) {
        return DelimiterAtom.isValidDelimiter(string);
    }

    public String toString() {
        return "DelimiterAtom: " + this.getFullText().replaceAll("\n", "\\\\n").replaceAll("\r", "\\\\r").replaceAll("\t", "\\\\t");
    }

    public boolean equalsIdentifier(Atom atom) {
        return super.equalsIdentifier(atom) || (atom.getIdentifier().equals(" ") || atom.getIdentifier().equals("\n")) && (this.getIdentifier().equals(" ") || this.getIdentifier().equals("\n"));
    }
}

