CREATE DATABASE IF NOT EXISTS `BIBLEDITDATABASE` DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci;

USE `BIBLEDITDATABASE`;

CREATE TABLE IF NOT EXISTS logs (
  id int auto_increment primary key,
  timestamp int,
  event text
);

CREATE TABLE IF NOT EXISTS versions (
  name varchar(50) primary key,
  version int unsigned
);

CREATE TABLE IF NOT EXISTS users (
  username varchar(30) primary key,
  password varchar(32),
  id varchar(32),
  level tinyint(1) unsigned not null,
  email varchar(256),
  timestamp int(11) unsigned not null
);

CREATE TABLE IF NOT EXISTS config_general (
  ident VARCHAR(100) NOT NULL,
  value VARCHAR(1000),
  offset INT NOT NULL
);

CREATE TABLE IF NOT EXISTS mail (
  id int auto_increment primary key,
  username varchar(256),
  timestamp int,
  label varchar(30),
  subject varchar(256),
  body text
);

CREATE TABLE IF NOT EXISTS mailer (
  id int, 
  retry int, 
  delay int
);

CREATE TABLE IF NOT EXISTS confirm (
  id int primary key,
  query text,
  timestamp int,
  mailto varchar(256),
  subject varchar(256),
  body text
);

DROP TABLE IF EXISTS books;

CREATE TABLE IF NOT EXISTS books (
  sequence int auto_increment primary key,
  id int,
  english varchar(256),
  osis varchar(10),
  usfm varchar(3),
  bibleworks varchar(10),
  onlinebible varchar(10),
  type varchar(20),
  onechapter int
) engine = MyISAM;

# The following contains book names as follows:
# ID | English name | OSIS | USFM | BibleWorks | Online Bible | type | chapter
# Clarifications:
# ID: Bibledit's internal book ID.
# English name: 
# OSIS: The OSIS abbreviation.
# USFM: The USFM ID.
# BibleWorks: The BibleWorks abbreviation.
# Online Bible: Online Bible abbreviation.
# type: One of the following
#       frontback - Frontmatter / Backmatter
#       ot        - Old Testament
#       nt        - New Testament
#       other     - Other matter
#       ap        - Apocrypha
# One chapter: If true, this book has only one chapter.              
# The order in which the books are presented is the standard order.

INSERT INTO books VALUES (NULL, 1, 'Genesis', 'Gen', 'GEN', 'Gen', 'Ge', 'ot', 0);
INSERT INTO books VALUES (NULL, 2, 'Exodus', 'Exod', 'EXO', 'Exo', 'Ex', 'ot', 0);
INSERT INTO books VALUES (NULL, 3, 'Leviticus', 'Lev', 'LEV', 'Lev', 'Le', 'ot', 0);
INSERT INTO books VALUES (NULL, 4, 'Numbers', 'Num', 'NUM', 'Num', 'Nu', 'ot', 0);
INSERT INTO books VALUES (NULL, 5, 'Deuteronomy', 'Deut', 'DEU', 'Deu', 'De', 'ot', 0);
INSERT INTO books VALUES (NULL, 6, 'Joshua', 'Josh', 'JOS', 'Jos', 'Jos', 'ot', 0);
INSERT INTO books VALUES (NULL, 7, 'Judges', 'Judg', 'JDG', 'Jdg', 'Jud', 'ot', 0);
INSERT INTO books VALUES (NULL, 8, 'Ruth', 'Ruth', 'RUT', 'Rut', 'Ru', 'ot', 0);
INSERT INTO books VALUES (NULL, 9, '1 Samuel', '1Sam', '1SA', '1Sa', '1Sa', 'ot', 0);
INSERT INTO books VALUES (NULL, 10, '2 Samuel', '2Sam', '2SA', '2Sa', '2Sa', 'ot', 0);
INSERT INTO books VALUES (NULL, 11, '1 Kings', '1Kgs', '1KI', '1Ki', '1Ki', 'ot', 0);
INSERT INTO books VALUES (NULL, 12, '2 Kings', '2Kgs', '2KI', '2Ki', '2Ki', 'ot', 0);
INSERT INTO books VALUES (NULL, 13, '1 Chronicles', '1Chr', '1CH', '1Ch', '1Ch', 'ot', 0);
INSERT INTO books VALUES (NULL, 14, '2 Chronicles', '2Chr', '2CH', '2Ch', '2Ch', 'ot', 0);
INSERT INTO books VALUES (NULL, 15, 'Ezra', 'Ezra', 'EZR', 'Ezr', 'Ezr', 'ot', 0);
INSERT INTO books VALUES (NULL, 16, 'Nehemiah', 'Neh', 'NEH', 'Neh', 'Ne', 'ot', 0);
INSERT INTO books VALUES (NULL, 17, 'Esther', 'Esth', 'EST', 'Est', 'Es', 'ot', 0);
INSERT INTO books VALUES (NULL, 18, 'Job', 'Job', 'JOB', 'Job', 'Job', 'ot', 0);
INSERT INTO books VALUES (NULL, 19, 'Psalms', 'Ps', 'PSA', 'Psa', 'Ps', 'ot', 0);
INSERT INTO books VALUES (NULL, 20, 'Proverbs', 'Prov', 'PRO', 'Pro', 'Pr', 'ot', 0);
INSERT INTO books VALUES (NULL, 21, 'Ecclesiastes', 'Eccl', 'ECC', 'Ecc', 'Ec', 'ot', 0);
INSERT INTO books VALUES (NULL, 22, 'Song of Solomon', 'Song', 'SNG', 'Sol', 'So', 'ot', 0);
INSERT INTO books VALUES (NULL, 23, 'Isaiah', 'Isa', 'ISA', 'Isa', 'Isa', 'ot', 0);
INSERT INTO books VALUES (NULL, 24, 'Jeremiah', 'Jer', 'JER', 'Jer', 'Jer', 'ot', 0);
INSERT INTO books VALUES (NULL, 25, 'Lamentations', 'Lam', 'LAM', 'Lam', 'La', 'ot', 0);
INSERT INTO books VALUES (NULL, 26, 'Ezekiel', 'Ezek', 'EZK', 'Eze', 'Eze', 'ot', 0);
INSERT INTO books VALUES (NULL, 27, 'Daniel', 'Dan', 'DAN', 'Dan', 'Da', 'ot', 0);
INSERT INTO books VALUES (NULL, 28, 'Hosea', 'Hos', 'HOS', 'Hos', 'Ho', 'ot', 0);
INSERT INTO books VALUES (NULL, 29, 'Joel', 'Joel', 'JOL', 'Joe', 'Joe', 'ot', 0);
INSERT INTO books VALUES (NULL, 30, 'Amos', 'Amos', 'AMO', 'Amo', 'Am', 'ot', 0);
INSERT INTO books VALUES (NULL, 31, 'Obadiah', 'Obad', 'OBA', 'Oba', 'Ob', 'ot', 1);
INSERT INTO books VALUES (NULL, 32, 'Jonah', 'Jonah', 'JON', 'Jon', 'Jon', 'ot', 0);
INSERT INTO books VALUES (NULL, 33, 'Micah', 'Mic', 'MIC', 'Mic', 'Mic', 'ot', 0);
INSERT INTO books VALUES (NULL, 34, 'Nahum', 'Nah', 'NAM', 'Nah', 'Na', 'ot', 0);
INSERT INTO books VALUES (NULL, 35, 'Habakkuk', 'Hab', 'HAB', 'Hab', 'Hab', 'ot', 0);
INSERT INTO books VALUES (NULL, 36, 'Zephaniah', 'Zeph', 'ZEP', 'Zep', 'Zep', 'ot', 0);
INSERT INTO books VALUES (NULL, 37, 'Haggai', 'Hag', 'HAG', 'Hag', 'Hag', 'ot', 0);
INSERT INTO books VALUES (NULL, 38, 'Zechariah', 'Zech', 'ZEC', 'Zec', 'Zec', 'ot', 0);
INSERT INTO books VALUES (NULL, 39, 'Malachi', 'Mal', 'MAL', 'Mal', 'Mal', 'ot', 0);
INSERT INTO books VALUES (NULL, 40, 'Matthew', 'Matt', 'MAT', 'Mat', 'Mt', 'nt', 0);
INSERT INTO books VALUES (NULL, 41, 'Mark', 'Mark', 'MRK', 'Mar', 'Mr', 'nt', 0);
INSERT INTO books VALUES (NULL, 42, 'Luke', 'Luke', 'LUK', 'Luk', 'Lu', 'nt', 0);
INSERT INTO books VALUES (NULL, 43, 'John', 'John', 'JHN', 'Joh', 'Joh', 'nt', 0);
INSERT INTO books VALUES (NULL, 44, 'Acts', 'Acts', 'ACT', 'Act', 'Ac', 'nt', 0);
INSERT INTO books VALUES (NULL, 45, 'Romans', 'Rom', 'ROM', 'Rom', 'Ro', 'nt', 0);
INSERT INTO books VALUES (NULL, 46, '1 Corinthians', '1Cor', '1CO', '1Co', '1Co', 'nt', 0);
INSERT INTO books VALUES (NULL, 47, '2 Corinthians', '2Cor', '2CO', '2Co', '2Co', 'nt', 0);
INSERT INTO books VALUES (NULL, 48, 'Galatians', 'Gal', 'GAL', 'Gal', 'Ga', 'nt', 0);
INSERT INTO books VALUES (NULL, 49, 'Ephesians', 'Eph', 'EPH', 'Eph', 'Eph', 'nt', 0);
INSERT INTO books VALUES (NULL, 50, 'Philippians', 'Phil', 'PHP', 'Phi', 'Php', 'nt', 0);
INSERT INTO books VALUES (NULL, 51, 'Colossians', 'Col', 'COL', 'Col', 'Col', 'nt', 0);
INSERT INTO books VALUES (NULL, 52, '1 Thessalonians', '1Thess', '1TH', '1Th', '1Th', 'nt', 0);
INSERT INTO books VALUES (NULL, 53, '2 Thessalonians', '2Thess', '2TH', '2Th', '2Th', 'nt', 0);
INSERT INTO books VALUES (NULL, 54, '1 Timothy', '1Tim', '1TI', '1Ti', '1Ti', 'nt', 0);
INSERT INTO books VALUES (NULL, 55, '2 Timothy', '2Tim', '2TI', '2Ti', '2Ti', 'nt', 0);
INSERT INTO books VALUES (NULL, 56, 'Titus', 'Titus', 'TIT', 'Tit', 'Tit', 'nt', 0);
INSERT INTO books VALUES (NULL, 57, 'Philemon', 'Phlm', 'PHM', 'Phm', 'Phm', 'nt', 1);
INSERT INTO books VALUES (NULL, 58, 'Hebrews', 'Heb', 'HEB', 'Heb', 'Heb', 'nt', 0);
INSERT INTO books VALUES (NULL, 59, 'James', 'Jas', 'JAS', 'Jam', 'Jas', 'nt', 0);
INSERT INTO books VALUES (NULL, 60, '1 Peter', '1Pet', '1PE', '1Pe', '1Pe', 'nt', 0);
INSERT INTO books VALUES (NULL, 61, '2 Peter', '2Pet', '2PE', '2Pe', '2Pe', 'nt', 0);
INSERT INTO books VALUES (NULL, 62, '1 John', '1John', '1JN', '1Jo', '1Jo', 'nt', 0);
INSERT INTO books VALUES (NULL, 63, '2 John', '2John', '2JN', '2Jo', '2Jo', 'nt', 0);
INSERT INTO books VALUES (NULL, 64, '3 John', '3John', '3JN', '3Jo', '3Jo', 'nt', 1);
INSERT INTO books VALUES (NULL, 65, 'Jude', 'Jude', 'JUD', 'Jud', 'Jude', 'nt', 1);
INSERT INTO books VALUES (NULL, 66, 'Revelation', 'Rev', 'REV', 'Rev', 'Re', 'nt', 0);
INSERT INTO books VALUES (NULL, 67, 'Front Matter', '', 'FRT', '', '', 'frontback', 0);
INSERT INTO books VALUES (NULL, 68, 'Back Matter', '', 'BAK', '', '', 'frontback', 0);
INSERT INTO books VALUES (NULL, 69, 'Other Material', '', 'OTH', '', '', 'other', 0);
INSERT INTO books VALUES (NULL, 70, 'Tobit', 'Tob', 'TOB', 'Tob', '', 'ap', 0);
INSERT INTO books VALUES (NULL, 71, 'Judith', 'Jdt', 'JDT', 'Jdt', '', 'ap', 0);
INSERT INTO books VALUES (NULL, 72, 'Esther (Greek)', 'AddEsth', 'ESG', 'EsG', '', 'ap', 0);
INSERT INTO books VALUES (NULL, 73, 'Wisdom of Solomon', 'Wis', 'WIS', 'Wis', '', 'ap', 0);
INSERT INTO books VALUES (NULL, 74, 'Sirach', 'Sir', 'SIR', 'Sir', '', 'ap', 0);
INSERT INTO books VALUES (NULL, 75, 'Baruch', 'Bar', 'BAR', 'Bar', '', 'ap', 0);
INSERT INTO books VALUES (NULL, 76, 'Letter of Jeremiah', 'EpJer', 'LJE', 'LJe', '', 'ap', 1);
INSERT INTO books VALUES (NULL, 77, 'Song of the Three Children', 'PrAzar', 'S3Y', 'S3Y', '', 'ap', 1);
INSERT INTO books VALUES (NULL, 78, 'Susanna', 'Sus', 'SUS', 'Sus', '', 'ap', 1);
INSERT INTO books VALUES (NULL, 79, 'Bel and the Dragon', 'Bel', 'BEL', 'Bel', '', 'ap', 1);
INSERT INTO books VALUES (NULL, 80, '1 Maccabees', '1Macc', '1MA', '1Ma', '', 'ap', 0);
INSERT INTO books VALUES (NULL, 81, '2 Maccabees', '2Macc', '2MA', '2Ma', '', 'ap', 0);
INSERT INTO books VALUES (NULL, 82, '1 Esdras', '1Esd', '1ES', '1Es', '', 'ap', 0);
INSERT INTO books VALUES (NULL, 83, 'Prayer of Manasses', 'PrMan', 'MAN', 'Man', '', 'ap', 1);
INSERT INTO books VALUES (NULL, 84, 'Psalm 151', 'Ps151', 'PS2', 'Ps2', '', 'ap', 1);
INSERT INTO books VALUES (NULL, 85, '3 Maccabees', '3Macc', '3MA', '3Ma', '', 'ap', 0);
INSERT INTO books VALUES (NULL, 86, '2 Esdras', '2Esd', '2ES', '2Es', '', 'ap', 0);
INSERT INTO books VALUES (NULL, 87, '4 Maccabees', '4Macc', '4MA', '4Ma', '', 'ap', 0);
INSERT INTO books VALUES (NULL, 88, 'Daniel (Greek)', 'AddDan', 'DNT', 'Dnt', '', 'ap', 0);

# DROP TABLE IF EXISTS dialog;

# CREATE TABLE IF NOT EXISTS dialog (
#   id int,
#   timestamp int,
#   object varchar(256),
#   method varchar(256),
#   argument varchar(256)
# );

CREATE TABLE IF NOT EXISTS versification_names (
  system int primary key,
  name varchar(256)
) engine = MyISAM;

CREATE TABLE IF NOT EXISTS versification_data (
  id int auto_increment primary key,
  system int,
  book int,
  chapter int,
  verse int
) engine = MyISAM;

DELETE FROM  `versification_names` WHERE system < 1000;

DELETE FROM `versification_data` WHERE system < 1000;

INSERT INTO versification_names VALUES (1, 'Russian Canonical');

INSERT INTO versification_data VALUES (NULL, 1, 1, 1, 31);
INSERT INTO versification_data VALUES (NULL, 1, 1, 2, 25);
INSERT INTO versification_data VALUES (NULL, 1, 1, 3, 24);
INSERT INTO versification_data VALUES (NULL, 1, 1, 4, 26);
INSERT INTO versification_data VALUES (NULL, 1, 1, 5, 32);
INSERT INTO versification_data VALUES (NULL, 1, 1, 6, 22);
INSERT INTO versification_data VALUES (NULL, 1, 1, 7, 24);
INSERT INTO versification_data VALUES (NULL, 1, 1, 8, 22);
INSERT INTO versification_data VALUES (NULL, 1, 1, 9, 29);
INSERT INTO versification_data VALUES (NULL, 1, 1, 10, 32);
INSERT INTO versification_data VALUES (NULL, 1, 1, 11, 32);
INSERT INTO versification_data VALUES (NULL, 1, 1, 12, 20);
INSERT INTO versification_data VALUES (NULL, 1, 1, 13, 18);
INSERT INTO versification_data VALUES (NULL, 1, 1, 14, 24);
INSERT INTO versification_data VALUES (NULL, 1, 1, 15, 21);
INSERT INTO versification_data VALUES (NULL, 1, 1, 16, 16);
INSERT INTO versification_data VALUES (NULL, 1, 1, 17, 27);
INSERT INTO versification_data VALUES (NULL, 1, 1, 18, 33);
INSERT INTO versification_data VALUES (NULL, 1, 1, 19, 38);
INSERT INTO versification_data VALUES (NULL, 1, 1, 20, 18);
INSERT INTO versification_data VALUES (NULL, 1, 1, 21, 34);
INSERT INTO versification_data VALUES (NULL, 1, 1, 22, 24);
INSERT INTO versification_data VALUES (NULL, 1, 1, 23, 20);
INSERT INTO versification_data VALUES (NULL, 1, 1, 24, 67);
INSERT INTO versification_data VALUES (NULL, 1, 1, 25, 34);
INSERT INTO versification_data VALUES (NULL, 1, 1, 26, 35);
INSERT INTO versification_data VALUES (NULL, 1, 1, 27, 46);
INSERT INTO versification_data VALUES (NULL, 1, 1, 28, 22);
INSERT INTO versification_data VALUES (NULL, 1, 1, 29, 35);
INSERT INTO versification_data VALUES (NULL, 1, 1, 30, 43);
INSERT INTO versification_data VALUES (NULL, 1, 1, 31, 55);
INSERT INTO versification_data VALUES (NULL, 1, 1, 32, 32);
INSERT INTO versification_data VALUES (NULL, 1, 1, 33, 20);
INSERT INTO versification_data VALUES (NULL, 1, 1, 34, 31);
INSERT INTO versification_data VALUES (NULL, 1, 1, 35, 29);
INSERT INTO versification_data VALUES (NULL, 1, 1, 36, 43);
INSERT INTO versification_data VALUES (NULL, 1, 1, 37, 36);
INSERT INTO versification_data VALUES (NULL, 1, 1, 38, 30);
INSERT INTO versification_data VALUES (NULL, 1, 1, 39, 23);
INSERT INTO versification_data VALUES (NULL, 1, 1, 40, 23);
INSERT INTO versification_data VALUES (NULL, 1, 1, 41, 57);
INSERT INTO versification_data VALUES (NULL, 1, 1, 42, 38);
INSERT INTO versification_data VALUES (NULL, 1, 1, 43, 34);
INSERT INTO versification_data VALUES (NULL, 1, 1, 44, 34);
INSERT INTO versification_data VALUES (NULL, 1, 1, 45, 28);
INSERT INTO versification_data VALUES (NULL, 1, 1, 46, 34);
INSERT INTO versification_data VALUES (NULL, 1, 1, 47, 31);
INSERT INTO versification_data VALUES (NULL, 1, 1, 48, 22);
INSERT INTO versification_data VALUES (NULL, 1, 1, 49, 33);
INSERT INTO versification_data VALUES (NULL, 1, 1, 50, 26);
INSERT INTO versification_data VALUES (NULL, 1, 2, 1, 22);
INSERT INTO versification_data VALUES (NULL, 1, 2, 2, 25);
INSERT INTO versification_data VALUES (NULL, 1, 2, 3, 22);
INSERT INTO versification_data VALUES (NULL, 1, 2, 4, 31);
INSERT INTO versification_data VALUES (NULL, 1, 2, 5, 23);
INSERT INTO versification_data VALUES (NULL, 1, 2, 6, 30);
INSERT INTO versification_data VALUES (NULL, 1, 2, 7, 25);
INSERT INTO versification_data VALUES (NULL, 1, 2, 8, 32);
INSERT INTO versification_data VALUES (NULL, 1, 2, 9, 35);
INSERT INTO versification_data VALUES (NULL, 1, 2, 10, 29);
INSERT INTO versification_data VALUES (NULL, 1, 2, 11, 10);
INSERT INTO versification_data VALUES (NULL, 1, 2, 12, 51);
INSERT INTO versification_data VALUES (NULL, 1, 2, 13, 22);
INSERT INTO versification_data VALUES (NULL, 1, 2, 14, 31);
INSERT INTO versification_data VALUES (NULL, 1, 2, 15, 27);
INSERT INTO versification_data VALUES (NULL, 1, 2, 16, 36);
INSERT INTO versification_data VALUES (NULL, 1, 2, 17, 16);
INSERT INTO versification_data VALUES (NULL, 1, 2, 18, 27);
INSERT INTO versification_data VALUES (NULL, 1, 2, 19, 25);
INSERT INTO versification_data VALUES (NULL, 1, 2, 20, 26);
INSERT INTO versification_data VALUES (NULL, 1, 2, 21, 36);
INSERT INTO versification_data VALUES (NULL, 1, 2, 22, 31);
INSERT INTO versification_data VALUES (NULL, 1, 2, 23, 33);
INSERT INTO versification_data VALUES (NULL, 1, 2, 24, 18);
INSERT INTO versification_data VALUES (NULL, 1, 2, 25, 40);
INSERT INTO versification_data VALUES (NULL, 1, 2, 26, 37);
INSERT INTO versification_data VALUES (NULL, 1, 2, 27, 21);
INSERT INTO versification_data VALUES (NULL, 1, 2, 28, 43);
INSERT INTO versification_data VALUES (NULL, 1, 2, 29, 46);
INSERT INTO versification_data VALUES (NULL, 1, 2, 30, 38);
INSERT INTO versification_data VALUES (NULL, 1, 2, 31, 18);
INSERT INTO versification_data VALUES (NULL, 1, 2, 32, 35);
INSERT INTO versification_data VALUES (NULL, 1, 2, 33, 23);
INSERT INTO versification_data VALUES (NULL, 1, 2, 34, 35);
INSERT INTO versification_data VALUES (NULL, 1, 2, 35, 35);
INSERT INTO versification_data VALUES (NULL, 1, 2, 36, 38);
INSERT INTO versification_data VALUES (NULL, 1, 2, 37, 29);
INSERT INTO versification_data VALUES (NULL, 1, 2, 38, 31);
INSERT INTO versification_data VALUES (NULL, 1, 2, 39, 43);
INSERT INTO versification_data VALUES (NULL, 1, 2, 40, 38);
INSERT INTO versification_data VALUES (NULL, 1, 3, 1, 17);
INSERT INTO versification_data VALUES (NULL, 1, 3, 2, 16);
INSERT INTO versification_data VALUES (NULL, 1, 3, 3, 17);
INSERT INTO versification_data VALUES (NULL, 1, 3, 4, 35);
INSERT INTO versification_data VALUES (NULL, 1, 3, 5, 19);
INSERT INTO versification_data VALUES (NULL, 1, 3, 6, 30);
INSERT INTO versification_data VALUES (NULL, 1, 3, 7, 38);
INSERT INTO versification_data VALUES (NULL, 1, 3, 8, 36);
INSERT INTO versification_data VALUES (NULL, 1, 3, 9, 24);
INSERT INTO versification_data VALUES (NULL, 1, 3, 10, 20);
INSERT INTO versification_data VALUES (NULL, 1, 3, 11, 47);
INSERT INTO versification_data VALUES (NULL, 1, 3, 12, 8);
INSERT INTO versification_data VALUES (NULL, 1, 3, 13, 59);
INSERT INTO versification_data VALUES (NULL, 1, 3, 14, 56);
INSERT INTO versification_data VALUES (NULL, 1, 3, 15, 33);
INSERT INTO versification_data VALUES (NULL, 1, 3, 16, 34);
INSERT INTO versification_data VALUES (NULL, 1, 3, 17, 16);
INSERT INTO versification_data VALUES (NULL, 1, 3, 18, 30);
INSERT INTO versification_data VALUES (NULL, 1, 3, 19, 37);
INSERT INTO versification_data VALUES (NULL, 1, 3, 20, 27);
INSERT INTO versification_data VALUES (NULL, 1, 3, 21, 24);
INSERT INTO versification_data VALUES (NULL, 1, 3, 22, 33);
INSERT INTO versification_data VALUES (NULL, 1, 3, 23, 44);
INSERT INTO versification_data VALUES (NULL, 1, 3, 24, 23);
INSERT INTO versification_data VALUES (NULL, 1, 3, 25, 55);
INSERT INTO versification_data VALUES (NULL, 1, 3, 26, 46);
INSERT INTO versification_data VALUES (NULL, 1, 3, 27, 34);
INSERT INTO versification_data VALUES (NULL, 1, 4, 1, 54);
INSERT INTO versification_data VALUES (NULL, 1, 4, 2, 34);
INSERT INTO versification_data VALUES (NULL, 1, 4, 3, 51);
INSERT INTO versification_data VALUES (NULL, 1, 4, 4, 49);
INSERT INTO versification_data VALUES (NULL, 1, 4, 5, 31);
INSERT INTO versification_data VALUES (NULL, 1, 4, 6, 27);
INSERT INTO versification_data VALUES (NULL, 1, 4, 7, 89);
INSERT INTO versification_data VALUES (NULL, 1, 4, 8, 26);
INSERT INTO versification_data VALUES (NULL, 1, 4, 9, 23);
INSERT INTO versification_data VALUES (NULL, 1, 4, 10, 36);
INSERT INTO versification_data VALUES (NULL, 1, 4, 11, 35);
INSERT INTO versification_data VALUES (NULL, 1, 4, 12, 15);
INSERT INTO versification_data VALUES (NULL, 1, 4, 13, 34);
INSERT INTO versification_data VALUES (NULL, 1, 4, 14, 45);
INSERT INTO versification_data VALUES (NULL, 1, 4, 15, 41);
INSERT INTO versification_data VALUES (NULL, 1, 4, 16, 50);
INSERT INTO versification_data VALUES (NULL, 1, 4, 17, 13);
INSERT INTO versification_data VALUES (NULL, 1, 4, 18, 32);
INSERT INTO versification_data VALUES (NULL, 1, 4, 19, 22);
INSERT INTO versification_data VALUES (NULL, 1, 4, 20, 29);
INSERT INTO versification_data VALUES (NULL, 1, 4, 21, 35);
INSERT INTO versification_data VALUES (NULL, 1, 4, 22, 41);
INSERT INTO versification_data VALUES (NULL, 1, 4, 23, 30);
INSERT INTO versification_data VALUES (NULL, 1, 4, 24, 25);
INSERT INTO versification_data VALUES (NULL, 1, 4, 25, 18);
INSERT INTO versification_data VALUES (NULL, 1, 4, 26, 65);
INSERT INTO versification_data VALUES (NULL, 1, 4, 27, 23);
INSERT INTO versification_data VALUES (NULL, 1, 4, 28, 31);
INSERT INTO versification_data VALUES (NULL, 1, 4, 29, 39);
INSERT INTO versification_data VALUES (NULL, 1, 4, 30, 17);
INSERT INTO versification_data VALUES (NULL, 1, 4, 31, 54);
INSERT INTO versification_data VALUES (NULL, 1, 4, 32, 42);
INSERT INTO versification_data VALUES (NULL, 1, 4, 33, 56);
INSERT INTO versification_data VALUES (NULL, 1, 4, 34, 29);
INSERT INTO versification_data VALUES (NULL, 1, 4, 35, 34);
INSERT INTO versification_data VALUES (NULL, 1, 4, 36, 13);
INSERT INTO versification_data VALUES (NULL, 1, 5, 1, 46);
INSERT INTO versification_data VALUES (NULL, 1, 5, 2, 37);
INSERT INTO versification_data VALUES (NULL, 1, 5, 3, 29);
INSERT INTO versification_data VALUES (NULL, 1, 5, 4, 49);
INSERT INTO versification_data VALUES (NULL, 1, 5, 5, 33);
INSERT INTO versification_data VALUES (NULL, 1, 5, 6, 25);
INSERT INTO versification_data VALUES (NULL, 1, 5, 7, 26);
INSERT INTO versification_data VALUES (NULL, 1, 5, 8, 20);
INSERT INTO versification_data VALUES (NULL, 1, 5, 9, 29);
INSERT INTO versification_data VALUES (NULL, 1, 5, 10, 22);
INSERT INTO versification_data VALUES (NULL, 1, 5, 11, 32);
INSERT INTO versification_data VALUES (NULL, 1, 5, 12, 32);
INSERT INTO versification_data VALUES (NULL, 1, 5, 13, 18);
INSERT INTO versification_data VALUES (NULL, 1, 5, 14, 29);
INSERT INTO versification_data VALUES (NULL, 1, 5, 15, 23);
INSERT INTO versification_data VALUES (NULL, 1, 5, 16, 22);
INSERT INTO versification_data VALUES (NULL, 1, 5, 17, 20);
INSERT INTO versification_data VALUES (NULL, 1, 5, 18, 22);
INSERT INTO versification_data VALUES (NULL, 1, 5, 19, 21);
INSERT INTO versification_data VALUES (NULL, 1, 5, 20, 20);
INSERT INTO versification_data VALUES (NULL, 1, 5, 21, 23);
INSERT INTO versification_data VALUES (NULL, 1, 5, 22, 30);
INSERT INTO versification_data VALUES (NULL, 1, 5, 23, 25);
INSERT INTO versification_data VALUES (NULL, 1, 5, 24, 22);
INSERT INTO versification_data VALUES (NULL, 1, 5, 25, 19);
INSERT INTO versification_data VALUES (NULL, 1, 5, 26, 19);
INSERT INTO versification_data VALUES (NULL, 1, 5, 27, 26);
INSERT INTO versification_data VALUES (NULL, 1, 5, 28, 68);
INSERT INTO versification_data VALUES (NULL, 1, 5, 29, 29);
INSERT INTO versification_data VALUES (NULL, 1, 5, 30, 20);
INSERT INTO versification_data VALUES (NULL, 1, 5, 31, 30);
INSERT INTO versification_data VALUES (NULL, 1, 5, 32, 52);
INSERT INTO versification_data VALUES (NULL, 1, 5, 33, 29);
INSERT INTO versification_data VALUES (NULL, 1, 5, 34, 12);
INSERT INTO versification_data VALUES (NULL, 1, 6, 1, 18);
INSERT INTO versification_data VALUES (NULL, 1, 6, 2, 24);
INSERT INTO versification_data VALUES (NULL, 1, 6, 3, 17);
INSERT INTO versification_data VALUES (NULL, 1, 6, 4, 24);
INSERT INTO versification_data VALUES (NULL, 1, 6, 5, 16);
INSERT INTO versification_data VALUES (NULL, 1, 6, 6, 26);
INSERT INTO versification_data VALUES (NULL, 1, 6, 7, 26);
INSERT INTO versification_data VALUES (NULL, 1, 6, 8, 35);
INSERT INTO versification_data VALUES (NULL, 1, 6, 9, 27);
INSERT INTO versification_data VALUES (NULL, 1, 6, 10, 43);
INSERT INTO versification_data VALUES (NULL, 1, 6, 11, 23);
INSERT INTO versification_data VALUES (NULL, 1, 6, 12, 24);
INSERT INTO versification_data VALUES (NULL, 1, 6, 13, 33);
INSERT INTO versification_data VALUES (NULL, 1, 6, 14, 15);
INSERT INTO versification_data VALUES (NULL, 1, 6, 15, 63);
INSERT INTO versification_data VALUES (NULL, 1, 6, 16, 10);
INSERT INTO versification_data VALUES (NULL, 1, 6, 17, 18);
INSERT INTO versification_data VALUES (NULL, 1, 6, 18, 28);
INSERT INTO versification_data VALUES (NULL, 1, 6, 19, 51);
INSERT INTO versification_data VALUES (NULL, 1, 6, 20, 9);
INSERT INTO versification_data VALUES (NULL, 1, 6, 21, 45);
INSERT INTO versification_data VALUES (NULL, 1, 6, 22, 34);
INSERT INTO versification_data VALUES (NULL, 1, 6, 23, 16);
INSERT INTO versification_data VALUES (NULL, 1, 6, 24, 33);
INSERT INTO versification_data VALUES (NULL, 1, 7, 1, 36);
INSERT INTO versification_data VALUES (NULL, 1, 7, 2, 23);
INSERT INTO versification_data VALUES (NULL, 1, 7, 3, 31);
INSERT INTO versification_data VALUES (NULL, 1, 7, 4, 24);
INSERT INTO versification_data VALUES (NULL, 1, 7, 5, 31);
INSERT INTO versification_data VALUES (NULL, 1, 7, 6, 40);
INSERT INTO versification_data VALUES (NULL, 1, 7, 7, 25);
INSERT INTO versification_data VALUES (NULL, 1, 7, 8, 35);
INSERT INTO versification_data VALUES (NULL, 1, 7, 9, 57);
INSERT INTO versification_data VALUES (NULL, 1, 7, 10, 18);
INSERT INTO versification_data VALUES (NULL, 1, 7, 11, 40);
INSERT INTO versification_data VALUES (NULL, 1, 7, 12, 15);
INSERT INTO versification_data VALUES (NULL, 1, 7, 13, 25);
INSERT INTO versification_data VALUES (NULL, 1, 7, 14, 20);
INSERT INTO versification_data VALUES (NULL, 1, 7, 15, 20);
INSERT INTO versification_data VALUES (NULL, 1, 7, 16, 31);
INSERT INTO versification_data VALUES (NULL, 1, 7, 17, 13);
INSERT INTO versification_data VALUES (NULL, 1, 7, 18, 31);
INSERT INTO versification_data VALUES (NULL, 1, 7, 19, 30);
INSERT INTO versification_data VALUES (NULL, 1, 7, 20, 48);
INSERT INTO versification_data VALUES (NULL, 1, 7, 21, 25);
INSERT INTO versification_data VALUES (NULL, 1, 8, 1, 22);
INSERT INTO versification_data VALUES (NULL, 1, 8, 2, 23);
INSERT INTO versification_data VALUES (NULL, 1, 8, 3, 18);
INSERT INTO versification_data VALUES (NULL, 1, 8, 4, 22);
INSERT INTO versification_data VALUES (NULL, 1, 9, 1, 28);
INSERT INTO versification_data VALUES (NULL, 1, 9, 2, 36);
INSERT INTO versification_data VALUES (NULL, 1, 9, 3, 21);
INSERT INTO versification_data VALUES (NULL, 1, 9, 4, 22);
INSERT INTO versification_data VALUES (NULL, 1, 9, 5, 12);
INSERT INTO versification_data VALUES (NULL, 1, 9, 6, 21);
INSERT INTO versification_data VALUES (NULL, 1, 9, 7, 17);
INSERT INTO versification_data VALUES (NULL, 1, 9, 8, 22);
INSERT INTO versification_data VALUES (NULL, 1, 9, 9, 27);
INSERT INTO versification_data VALUES (NULL, 1, 9, 10, 27);
INSERT INTO versification_data VALUES (NULL, 1, 9, 11, 15);
INSERT INTO versification_data VALUES (NULL, 1, 9, 12, 25);
INSERT INTO versification_data VALUES (NULL, 1, 9, 13, 23);
INSERT INTO versification_data VALUES (NULL, 1, 9, 14, 52);
INSERT INTO versification_data VALUES (NULL, 1, 9, 15, 35);
INSERT INTO versification_data VALUES (NULL, 1, 9, 16, 23);
INSERT INTO versification_data VALUES (NULL, 1, 9, 17, 58);
INSERT INTO versification_data VALUES (NULL, 1, 9, 18, 30);
INSERT INTO versification_data VALUES (NULL, 1, 9, 19, 24);
INSERT INTO versification_data VALUES (NULL, 1, 9, 20, 43);
INSERT INTO versification_data VALUES (NULL, 1, 9, 21, 15);
INSERT INTO versification_data VALUES (NULL, 1, 9, 22, 23);
INSERT INTO versification_data VALUES (NULL, 1, 9, 23, 28);
INSERT INTO versification_data VALUES (NULL, 1, 9, 24, 23);
INSERT INTO versification_data VALUES (NULL, 1, 9, 25, 44);
INSERT INTO versification_data VALUES (NULL, 1, 9, 26, 25);
INSERT INTO versification_data VALUES (NULL, 1, 9, 27, 12);
INSERT INTO versification_data VALUES (NULL, 1, 9, 28, 25);
INSERT INTO versification_data VALUES (NULL, 1, 9, 29, 11);
INSERT INTO versification_data VALUES (NULL, 1, 9, 30, 31);
INSERT INTO versification_data VALUES (NULL, 1, 9, 31, 13);
INSERT INTO versification_data VALUES (NULL, 1, 10, 1, 27);
INSERT INTO versification_data VALUES (NULL, 1, 10, 2, 32);
INSERT INTO versification_data VALUES (NULL, 1, 10, 3, 39);
INSERT INTO versification_data VALUES (NULL, 1, 10, 4, 12);
INSERT INTO versification_data VALUES (NULL, 1, 10, 5, 25);
INSERT INTO versification_data VALUES (NULL, 1, 10, 6, 23);
INSERT INTO versification_data VALUES (NULL, 1, 10, 7, 29);
INSERT INTO versification_data VALUES (NULL, 1, 10, 8, 18);
INSERT INTO versification_data VALUES (NULL, 1, 10, 9, 13);
INSERT INTO versification_data VALUES (NULL, 1, 10, 10, 19);
INSERT INTO versification_data VALUES (NULL, 1, 10, 11, 27);
INSERT INTO versification_data VALUES (NULL, 1, 10, 12, 31);
INSERT INTO versification_data VALUES (NULL, 1, 10, 13, 39);
INSERT INTO versification_data VALUES (NULL, 1, 10, 14, 33);
INSERT INTO versification_data VALUES (NULL, 1, 10, 15, 37);
INSERT INTO versification_data VALUES (NULL, 1, 10, 16, 23);
INSERT INTO versification_data VALUES (NULL, 1, 10, 17, 29);
INSERT INTO versification_data VALUES (NULL, 1, 10, 18, 33);
INSERT INTO versification_data VALUES (NULL, 1, 10, 19, 43);
INSERT INTO versification_data VALUES (NULL, 1, 10, 20, 26);
INSERT INTO versification_data VALUES (NULL, 1, 10, 21, 22);
INSERT INTO versification_data VALUES (NULL, 1, 10, 22, 51);
INSERT INTO versification_data VALUES (NULL, 1, 10, 23, 39);
INSERT INTO versification_data VALUES (NULL, 1, 10, 24, 25);
INSERT INTO versification_data VALUES (NULL, 1, 11, 1, 53);
INSERT INTO versification_data VALUES (NULL, 1, 11, 2, 46);
INSERT INTO versification_data VALUES (NULL, 1, 11, 3, 28);
INSERT INTO versification_data VALUES (NULL, 1, 11, 4, 34);
INSERT INTO versification_data VALUES (NULL, 1, 11, 5, 18);
INSERT INTO versification_data VALUES (NULL, 1, 11, 6, 38);
INSERT INTO versification_data VALUES (NULL, 1, 11, 7, 51);
INSERT INTO versification_data VALUES (NULL, 1, 11, 8, 66);
INSERT INTO versification_data VALUES (NULL, 1, 11, 9, 28);
INSERT INTO versification_data VALUES (NULL, 1, 11, 10, 29);
INSERT INTO versification_data VALUES (NULL, 1, 11, 11, 43);
INSERT INTO versification_data VALUES (NULL, 1, 11, 12, 33);
INSERT INTO versification_data VALUES (NULL, 1, 11, 13, 34);
INSERT INTO versification_data VALUES (NULL, 1, 11, 14, 31);
INSERT INTO versification_data VALUES (NULL, 1, 11, 15, 34);
INSERT INTO versification_data VALUES (NULL, 1, 11, 16, 34);
INSERT INTO versification_data VALUES (NULL, 1, 11, 17, 24);
INSERT INTO versification_data VALUES (NULL, 1, 11, 18, 46);
INSERT INTO versification_data VALUES (NULL, 1, 11, 19, 21);
INSERT INTO versification_data VALUES (NULL, 1, 11, 20, 43);
INSERT INTO versification_data VALUES (NULL, 1, 11, 21, 29);
INSERT INTO versification_data VALUES (NULL, 1, 11, 22, 53);
INSERT INTO versification_data VALUES (NULL, 1, 12, 1, 18);
INSERT INTO versification_data VALUES (NULL, 1, 12, 2, 25);
INSERT INTO versification_data VALUES (NULL, 1, 12, 3, 27);
INSERT INTO versification_data VALUES (NULL, 1, 12, 4, 44);
INSERT INTO versification_data VALUES (NULL, 1, 12, 5, 27);
INSERT INTO versification_data VALUES (NULL, 1, 12, 6, 33);
INSERT INTO versification_data VALUES (NULL, 1, 12, 7, 20);
INSERT INTO versification_data VALUES (NULL, 1, 12, 8, 29);
INSERT INTO versification_data VALUES (NULL, 1, 12, 9, 37);
INSERT INTO versification_data VALUES (NULL, 1, 12, 10, 36);
INSERT INTO versification_data VALUES (NULL, 1, 12, 11, 21);
INSERT INTO versification_data VALUES (NULL, 1, 12, 12, 21);
INSERT INTO versification_data VALUES (NULL, 1, 12, 13, 25);
INSERT INTO versification_data VALUES (NULL, 1, 12, 14, 29);
INSERT INTO versification_data VALUES (NULL, 1, 12, 15, 38);
INSERT INTO versification_data VALUES (NULL, 1, 12, 16, 20);
INSERT INTO versification_data VALUES (NULL, 1, 12, 17, 41);
INSERT INTO versification_data VALUES (NULL, 1, 12, 18, 37);
INSERT INTO versification_data VALUES (NULL, 1, 12, 19, 37);
INSERT INTO versification_data VALUES (NULL, 1, 12, 20, 21);
INSERT INTO versification_data VALUES (NULL, 1, 12, 21, 26);
INSERT INTO versification_data VALUES (NULL, 1, 12, 22, 20);
INSERT INTO versification_data VALUES (NULL, 1, 12, 23, 37);
INSERT INTO versification_data VALUES (NULL, 1, 12, 24, 20);
INSERT INTO versification_data VALUES (NULL, 1, 12, 25, 30);
INSERT INTO versification_data VALUES (NULL, 1, 13, 1, 54);
INSERT INTO versification_data VALUES (NULL, 1, 13, 2, 55);
INSERT INTO versification_data VALUES (NULL, 1, 13, 3, 24);
INSERT INTO versification_data VALUES (NULL, 1, 13, 4, 43);
INSERT INTO versification_data VALUES (NULL, 1, 13, 5, 26);
INSERT INTO versification_data VALUES (NULL, 1, 13, 6, 81);
INSERT INTO versification_data VALUES (NULL, 1, 13, 7, 40);
INSERT INTO versification_data VALUES (NULL, 1, 13, 8, 40);
INSERT INTO versification_data VALUES (NULL, 1, 13, 9, 44);
INSERT INTO versification_data VALUES (NULL, 1, 13, 10, 14);
INSERT INTO versification_data VALUES (NULL, 1, 13, 11, 47);
INSERT INTO versification_data VALUES (NULL, 1, 13, 12, 40);
INSERT INTO versification_data VALUES (NULL, 1, 13, 13, 14);
INSERT INTO versification_data VALUES (NULL, 1, 13, 14, 17);
INSERT INTO versification_data VALUES (NULL, 1, 13, 15, 29);
INSERT INTO versification_data VALUES (NULL, 1, 13, 16, 43);
INSERT INTO versification_data VALUES (NULL, 1, 13, 17, 27);
INSERT INTO versification_data VALUES (NULL, 1, 13, 18, 17);
INSERT INTO versification_data VALUES (NULL, 1, 13, 19, 19);
INSERT INTO versification_data VALUES (NULL, 1, 13, 20, 8);
INSERT INTO versification_data VALUES (NULL, 1, 13, 21, 30);
INSERT INTO versification_data VALUES (NULL, 1, 13, 22, 19);
INSERT INTO versification_data VALUES (NULL, 1, 13, 23, 32);
INSERT INTO versification_data VALUES (NULL, 1, 13, 24, 31);
INSERT INTO versification_data VALUES (NULL, 1, 13, 25, 31);
INSERT INTO versification_data VALUES (NULL, 1, 13, 26, 32);
INSERT INTO versification_data VALUES (NULL, 1, 13, 27, 34);
INSERT INTO versification_data VALUES (NULL, 1, 13, 28, 21);
INSERT INTO versification_data VALUES (NULL, 1, 13, 29, 30);
INSERT INTO versification_data VALUES (NULL, 1, 14, 1, 17);
INSERT INTO versification_data VALUES (NULL, 1, 14, 2, 18);
INSERT INTO versification_data VALUES (NULL, 1, 14, 3, 17);
INSERT INTO versification_data VALUES (NULL, 1, 14, 4, 22);
INSERT INTO versification_data VALUES (NULL, 1, 14, 5, 14);
INSERT INTO versification_data VALUES (NULL, 1, 14, 6, 42);
INSERT INTO versification_data VALUES (NULL, 1, 14, 7, 22);
INSERT INTO versification_data VALUES (NULL, 1, 14, 8, 18);
INSERT INTO versification_data VALUES (NULL, 1, 14, 9, 31);
INSERT INTO versification_data VALUES (NULL, 1, 14, 10, 19);
INSERT INTO versification_data VALUES (NULL, 1, 14, 11, 23);
INSERT INTO versification_data VALUES (NULL, 1, 14, 12, 16);
INSERT INTO versification_data VALUES (NULL, 1, 14, 13, 22);
INSERT INTO versification_data VALUES (NULL, 1, 14, 14, 15);
INSERT INTO versification_data VALUES (NULL, 1, 14, 15, 19);
INSERT INTO versification_data VALUES (NULL, 1, 14, 16, 14);
INSERT INTO versification_data VALUES (NULL, 1, 14, 17, 19);
INSERT INTO versification_data VALUES (NULL, 1, 14, 18, 34);
INSERT INTO versification_data VALUES (NULL, 1, 14, 19, 11);
INSERT INTO versification_data VALUES (NULL, 1, 14, 20, 37);
INSERT INTO versification_data VALUES (NULL, 1, 14, 21, 20);
INSERT INTO versification_data VALUES (NULL, 1, 14, 22, 12);
INSERT INTO versification_data VALUES (NULL, 1, 14, 23, 21);
INSERT INTO versification_data VALUES (NULL, 1, 14, 24, 27);
INSERT INTO versification_data VALUES (NULL, 1, 14, 25, 28);
INSERT INTO versification_data VALUES (NULL, 1, 14, 26, 23);
INSERT INTO versification_data VALUES (NULL, 1, 14, 27, 9);
INSERT INTO versification_data VALUES (NULL, 1, 14, 28, 27);
INSERT INTO versification_data VALUES (NULL, 1, 14, 29, 36);
INSERT INTO versification_data VALUES (NULL, 1, 14, 30, 27);
INSERT INTO versification_data VALUES (NULL, 1, 14, 31, 21);
INSERT INTO versification_data VALUES (NULL, 1, 14, 32, 33);
INSERT INTO versification_data VALUES (NULL, 1, 14, 33, 25);
INSERT INTO versification_data VALUES (NULL, 1, 14, 34, 33);
INSERT INTO versification_data VALUES (NULL, 1, 14, 35, 27);
INSERT INTO versification_data VALUES (NULL, 1, 14, 36, 23);
INSERT INTO versification_data VALUES (NULL, 1, 15, 1, 11);
INSERT INTO versification_data VALUES (NULL, 1, 15, 2, 70);
INSERT INTO versification_data VALUES (NULL, 1, 15, 3, 13);
INSERT INTO versification_data VALUES (NULL, 1, 15, 4, 24);
INSERT INTO versification_data VALUES (NULL, 1, 15, 5, 17);
INSERT INTO versification_data VALUES (NULL, 1, 15, 6, 22);
INSERT INTO versification_data VALUES (NULL, 1, 15, 7, 28);
INSERT INTO versification_data VALUES (NULL, 1, 15, 8, 36);
INSERT INTO versification_data VALUES (NULL, 1, 15, 9, 15);
INSERT INTO versification_data VALUES (NULL, 1, 15, 10, 44);
INSERT INTO versification_data VALUES (NULL, 1, 16, 1, 11);
INSERT INTO versification_data VALUES (NULL, 1, 16, 2, 20);
INSERT INTO versification_data VALUES (NULL, 1, 16, 3, 32);
INSERT INTO versification_data VALUES (NULL, 1, 16, 4, 23);
INSERT INTO versification_data VALUES (NULL, 1, 16, 5, 19);
INSERT INTO versification_data VALUES (NULL, 1, 16, 6, 19);
INSERT INTO versification_data VALUES (NULL, 1, 16, 7, 73);
INSERT INTO versification_data VALUES (NULL, 1, 16, 8, 18);
INSERT INTO versification_data VALUES (NULL, 1, 16, 9, 38);
INSERT INTO versification_data VALUES (NULL, 1, 16, 10, 39);
INSERT INTO versification_data VALUES (NULL, 1, 16, 11, 36);
INSERT INTO versification_data VALUES (NULL, 1, 16, 12, 47);
INSERT INTO versification_data VALUES (NULL, 1, 16, 13, 31);
INSERT INTO versification_data VALUES (NULL, 1, 17, 1, 22);
INSERT INTO versification_data VALUES (NULL, 1, 17, 2, 23);
INSERT INTO versification_data VALUES (NULL, 1, 17, 3, 15);
INSERT INTO versification_data VALUES (NULL, 1, 17, 4, 17);
INSERT INTO versification_data VALUES (NULL, 1, 17, 5, 14);
INSERT INTO versification_data VALUES (NULL, 1, 17, 6, 14);
INSERT INTO versification_data VALUES (NULL, 1, 17, 7, 10);
INSERT INTO versification_data VALUES (NULL, 1, 17, 8, 17);
INSERT INTO versification_data VALUES (NULL, 1, 17, 9, 32);
INSERT INTO versification_data VALUES (NULL, 1, 17, 10, 3);
INSERT INTO versification_data VALUES (NULL, 1, 18, 1, 22);
INSERT INTO versification_data VALUES (NULL, 1, 18, 2, 13);
INSERT INTO versification_data VALUES (NULL, 1, 18, 3, 26);
INSERT INTO versification_data VALUES (NULL, 1, 18, 4, 21);
INSERT INTO versification_data VALUES (NULL, 1, 18, 5, 27);
INSERT INTO versification_data VALUES (NULL, 1, 18, 6, 30);
INSERT INTO versification_data VALUES (NULL, 1, 18, 7, 21);
INSERT INTO versification_data VALUES (NULL, 1, 18, 8, 22);
INSERT INTO versification_data VALUES (NULL, 1, 18, 9, 35);
INSERT INTO versification_data VALUES (NULL, 1, 18, 10, 22);
INSERT INTO versification_data VALUES (NULL, 1, 18, 11, 20);
INSERT INTO versification_data VALUES (NULL, 1, 18, 12, 25);
INSERT INTO versification_data VALUES (NULL, 1, 18, 13, 28);
INSERT INTO versification_data VALUES (NULL, 1, 18, 14, 22);
INSERT INTO versification_data VALUES (NULL, 1, 18, 15, 35);
INSERT INTO versification_data VALUES (NULL, 1, 18, 16, 22);
INSERT INTO versification_data VALUES (NULL, 1, 18, 17, 16);
INSERT INTO versification_data VALUES (NULL, 1, 18, 18, 21);
INSERT INTO versification_data VALUES (NULL, 1, 18, 19, 29);
INSERT INTO versification_data VALUES (NULL, 1, 18, 20, 29);
INSERT INTO versification_data VALUES (NULL, 1, 18, 21, 34);
INSERT INTO versification_data VALUES (NULL, 1, 18, 22, 30);
INSERT INTO versification_data VALUES (NULL, 1, 18, 23, 17);
INSERT INTO versification_data VALUES (NULL, 1, 18, 24, 25);
INSERT INTO versification_data VALUES (NULL, 1, 18, 25, 6);
INSERT INTO versification_data VALUES (NULL, 1, 18, 26, 14);
INSERT INTO versification_data VALUES (NULL, 1, 18, 27, 23);
INSERT INTO versification_data VALUES (NULL, 1, 18, 28, 28);
INSERT INTO versification_data VALUES (NULL, 1, 18, 29, 25);
INSERT INTO versification_data VALUES (NULL, 1, 18, 30, 31);
INSERT INTO versification_data VALUES (NULL, 1, 18, 31, 40);
INSERT INTO versification_data VALUES (NULL, 1, 18, 32, 22);
INSERT INTO versification_data VALUES (NULL, 1, 18, 33, 33);
INSERT INTO versification_data VALUES (NULL, 1, 18, 34, 37);
INSERT INTO versification_data VALUES (NULL, 1, 18, 35, 16);
INSERT INTO versification_data VALUES (NULL, 1, 18, 36, 33);
INSERT INTO versification_data VALUES (NULL, 1, 18, 37, 24);
INSERT INTO versification_data VALUES (NULL, 1, 18, 38, 41);
INSERT INTO versification_data VALUES (NULL, 1, 18, 39, 35);
INSERT INTO versification_data VALUES (NULL, 1, 18, 40, 27);
INSERT INTO versification_data VALUES (NULL, 1, 18, 41, 26);
INSERT INTO versification_data VALUES (NULL, 1, 18, 42, 17);
INSERT INTO versification_data VALUES (NULL, 1, 19, 1, 6);
INSERT INTO versification_data VALUES (NULL, 1, 19, 2, 12);
INSERT INTO versification_data VALUES (NULL, 1, 19, 3, 9);
INSERT INTO versification_data VALUES (NULL, 1, 19, 4, 9);
INSERT INTO versification_data VALUES (NULL, 1, 19, 5, 13);
INSERT INTO versification_data VALUES (NULL, 1, 19, 6, 11);
INSERT INTO versification_data VALUES (NULL, 1, 19, 7, 18);
INSERT INTO versification_data VALUES (NULL, 1, 19, 8, 10);
INSERT INTO versification_data VALUES (NULL, 1, 19, 9, 39);
INSERT INTO versification_data VALUES (NULL, 1, 19, 10, 7);
INSERT INTO versification_data VALUES (NULL, 1, 19, 11, 9);
INSERT INTO versification_data VALUES (NULL, 1, 19, 12, 6);
INSERT INTO versification_data VALUES (NULL, 1, 19, 13, 7);
INSERT INTO versification_data VALUES (NULL, 1, 19, 14, 5);
INSERT INTO versification_data VALUES (NULL, 1, 19, 15, 11);
INSERT INTO versification_data VALUES (NULL, 1, 19, 16, 15);
INSERT INTO versification_data VALUES (NULL, 1, 19, 17, 51);
INSERT INTO versification_data VALUES (NULL, 1, 19, 18, 15);
INSERT INTO versification_data VALUES (NULL, 1, 19, 19, 10);
INSERT INTO versification_data VALUES (NULL, 1, 19, 20, 14);
INSERT INTO versification_data VALUES (NULL, 1, 19, 21, 32);
INSERT INTO versification_data VALUES (NULL, 1, 19, 22, 6);
INSERT INTO versification_data VALUES (NULL, 1, 19, 23, 10);
INSERT INTO versification_data VALUES (NULL, 1, 19, 24, 22);
INSERT INTO versification_data VALUES (NULL, 1, 19, 25, 12);
INSERT INTO versification_data VALUES (NULL, 1, 19, 26, 14);
INSERT INTO versification_data VALUES (NULL, 1, 19, 27, 9);
INSERT INTO versification_data VALUES (NULL, 1, 19, 28, 11);
INSERT INTO versification_data VALUES (NULL, 1, 19, 29, 13);
INSERT INTO versification_data VALUES (NULL, 1, 19, 30, 25);
INSERT INTO versification_data VALUES (NULL, 1, 19, 31, 11);
INSERT INTO versification_data VALUES (NULL, 1, 19, 32, 22);
INSERT INTO versification_data VALUES (NULL, 1, 19, 33, 23);
INSERT INTO versification_data VALUES (NULL, 1, 19, 34, 28);
INSERT INTO versification_data VALUES (NULL, 1, 19, 35, 13);
INSERT INTO versification_data VALUES (NULL, 1, 19, 36, 40);
INSERT INTO versification_data VALUES (NULL, 1, 19, 37, 23);
INSERT INTO versification_data VALUES (NULL, 1, 19, 38, 14);
INSERT INTO versification_data VALUES (NULL, 1, 19, 39, 18);
INSERT INTO versification_data VALUES (NULL, 1, 19, 40, 14);
INSERT INTO versification_data VALUES (NULL, 1, 19, 41, 12);
INSERT INTO versification_data VALUES (NULL, 1, 19, 42, 5);
INSERT INTO versification_data VALUES (NULL, 1, 19, 43, 27);
INSERT INTO versification_data VALUES (NULL, 1, 19, 44, 18);
INSERT INTO versification_data VALUES (NULL, 1, 19, 45, 12);
INSERT INTO versification_data VALUES (NULL, 1, 19, 46, 10);
INSERT INTO versification_data VALUES (NULL, 1, 19, 47, 15);
INSERT INTO versification_data VALUES (NULL, 1, 19, 48, 21);
INSERT INTO versification_data VALUES (NULL, 1, 19, 49, 23);
INSERT INTO versification_data VALUES (NULL, 1, 19, 50, 21);
INSERT INTO versification_data VALUES (NULL, 1, 19, 51, 11);
INSERT INTO versification_data VALUES (NULL, 1, 19, 52, 7);
INSERT INTO versification_data VALUES (NULL, 1, 19, 53, 9);
INSERT INTO versification_data VALUES (NULL, 1, 19, 54, 24);
INSERT INTO versification_data VALUES (NULL, 1, 19, 55, 14);
INSERT INTO versification_data VALUES (NULL, 1, 19, 56, 12);
INSERT INTO versification_data VALUES (NULL, 1, 19, 57, 12);
INSERT INTO versification_data VALUES (NULL, 1, 19, 58, 18);
INSERT INTO versification_data VALUES (NULL, 1, 19, 59, 14);
INSERT INTO versification_data VALUES (NULL, 1, 19, 60, 9);
INSERT INTO versification_data VALUES (NULL, 1, 19, 61, 13);
INSERT INTO versification_data VALUES (NULL, 1, 19, 62, 12);
INSERT INTO versification_data VALUES (NULL, 1, 19, 63, 11);
INSERT INTO versification_data VALUES (NULL, 1, 19, 64, 14);
INSERT INTO versification_data VALUES (NULL, 1, 19, 65, 20);
INSERT INTO versification_data VALUES (NULL, 1, 19, 66, 8);
INSERT INTO versification_data VALUES (NULL, 1, 19, 67, 36);
INSERT INTO versification_data VALUES (NULL, 1, 19, 68, 37);
INSERT INTO versification_data VALUES (NULL, 1, 19, 69, 6);
INSERT INTO versification_data VALUES (NULL, 1, 19, 70, 24);
INSERT INTO versification_data VALUES (NULL, 1, 19, 71, 20);
INSERT INTO versification_data VALUES (NULL, 1, 19, 72, 28);
INSERT INTO versification_data VALUES (NULL, 1, 19, 73, 23);
INSERT INTO versification_data VALUES (NULL, 1, 19, 74, 11);
INSERT INTO versification_data VALUES (NULL, 1, 19, 75, 13);
INSERT INTO versification_data VALUES (NULL, 1, 19, 76, 21);
INSERT INTO versification_data VALUES (NULL, 1, 19, 77, 72);
INSERT INTO versification_data VALUES (NULL, 1, 19, 78, 13);
INSERT INTO versification_data VALUES (NULL, 1, 19, 79, 20);
INSERT INTO versification_data VALUES (NULL, 1, 19, 80, 17);
INSERT INTO versification_data VALUES (NULL, 1, 19, 81, 8);
INSERT INTO versification_data VALUES (NULL, 1, 19, 82, 19);
INSERT INTO versification_data VALUES (NULL, 1, 19, 83, 13);
INSERT INTO versification_data VALUES (NULL, 1, 19, 84, 14);
INSERT INTO versification_data VALUES (NULL, 1, 19, 85, 17);
INSERT INTO versification_data VALUES (NULL, 1, 19, 86, 7);
INSERT INTO versification_data VALUES (NULL, 1, 19, 87, 19);
INSERT INTO versification_data VALUES (NULL, 1, 19, 88, 53);
INSERT INTO versification_data VALUES (NULL, 1, 19, 89, 17);
INSERT INTO versification_data VALUES (NULL, 1, 19, 90, 16);
INSERT INTO versification_data VALUES (NULL, 1, 19, 91, 16);
INSERT INTO versification_data VALUES (NULL, 1, 19, 92, 5);
INSERT INTO versification_data VALUES (NULL, 1, 19, 93, 23);
INSERT INTO versification_data VALUES (NULL, 1, 19, 94, 11);
INSERT INTO versification_data VALUES (NULL, 1, 19, 95, 13);
INSERT INTO versification_data VALUES (NULL, 1, 19, 96, 12);
INSERT INTO versification_data VALUES (NULL, 1, 19, 97, 9);
INSERT INTO versification_data VALUES (NULL, 1, 19, 98, 9);
INSERT INTO versification_data VALUES (NULL, 1, 19, 99, 5);
INSERT INTO versification_data VALUES (NULL, 1, 19, 100, 8);
INSERT INTO versification_data VALUES (NULL, 1, 19, 101, 29);
INSERT INTO versification_data VALUES (NULL, 1, 19, 102, 22);
INSERT INTO versification_data VALUES (NULL, 1, 19, 103, 35);
INSERT INTO versification_data VALUES (NULL, 1, 19, 104, 45);
INSERT INTO versification_data VALUES (NULL, 1, 19, 105, 48);
INSERT INTO versification_data VALUES (NULL, 1, 19, 106, 43);
INSERT INTO versification_data VALUES (NULL, 1, 19, 107, 14);
INSERT INTO versification_data VALUES (NULL, 1, 19, 108, 31);
INSERT INTO versification_data VALUES (NULL, 1, 19, 109, 7);
INSERT INTO versification_data VALUES (NULL, 1, 19, 110, 10);
INSERT INTO versification_data VALUES (NULL, 1, 19, 111, 10);
INSERT INTO versification_data VALUES (NULL, 1, 19, 112, 9);
INSERT INTO versification_data VALUES (NULL, 1, 19, 113, 26);
INSERT INTO versification_data VALUES (NULL, 1, 19, 114, 9);
INSERT INTO versification_data VALUES (NULL, 1, 19, 115, 10);
INSERT INTO versification_data VALUES (NULL, 1, 19, 116, 2);
INSERT INTO versification_data VALUES (NULL, 1, 19, 117, 29);
INSERT INTO versification_data VALUES (NULL, 1, 19, 118, 176);
INSERT INTO versification_data VALUES (NULL, 1, 19, 119, 7);
INSERT INTO versification_data VALUES (NULL, 1, 19, 120, 8);
INSERT INTO versification_data VALUES (NULL, 1, 19, 121, 9);
INSERT INTO versification_data VALUES (NULL, 1, 19, 122, 4);
INSERT INTO versification_data VALUES (NULL, 1, 19, 123, 8);
INSERT INTO versification_data VALUES (NULL, 1, 19, 124, 5);
INSERT INTO versification_data VALUES (NULL, 1, 19, 125, 6);
INSERT INTO versification_data VALUES (NULL, 1, 19, 126, 5);
INSERT INTO versification_data VALUES (NULL, 1, 19, 127, 6);
INSERT INTO versification_data VALUES (NULL, 1, 19, 128, 8);
INSERT INTO versification_data VALUES (NULL, 1, 19, 129, 8);
INSERT INTO versification_data VALUES (NULL, 1, 19, 130, 3);
INSERT INTO versification_data VALUES (NULL, 1, 19, 131, 18);
INSERT INTO versification_data VALUES (NULL, 1, 19, 132, 3);
INSERT INTO versification_data VALUES (NULL, 1, 19, 133, 3);
INSERT INTO versification_data VALUES (NULL, 1, 19, 134, 21);
INSERT INTO versification_data VALUES (NULL, 1, 19, 135, 26);
INSERT INTO versification_data VALUES (NULL, 1, 19, 136, 9);
INSERT INTO versification_data VALUES (NULL, 1, 19, 137, 8);
INSERT INTO versification_data VALUES (NULL, 1, 19, 138, 24);
INSERT INTO versification_data VALUES (NULL, 1, 19, 139, 14);
INSERT INTO versification_data VALUES (NULL, 1, 19, 140, 10);
INSERT INTO versification_data VALUES (NULL, 1, 19, 141, 7);
INSERT INTO versification_data VALUES (NULL, 1, 19, 142, 12);
INSERT INTO versification_data VALUES (NULL, 1, 19, 143, 15);
INSERT INTO versification_data VALUES (NULL, 1, 19, 144, 21);
INSERT INTO versification_data VALUES (NULL, 1, 19, 145, 10);
INSERT INTO versification_data VALUES (NULL, 1, 19, 146, 11);
INSERT INTO versification_data VALUES (NULL, 1, 19, 147, 9);
INSERT INTO versification_data VALUES (NULL, 1, 19, 148, 14);
INSERT INTO versification_data VALUES (NULL, 1, 19, 149, 9);
INSERT INTO versification_data VALUES (NULL, 1, 19, 150, 6);
INSERT INTO versification_data VALUES (NULL, 1, 20, 1, 33);
INSERT INTO versification_data VALUES (NULL, 1, 20, 2, 22);
INSERT INTO versification_data VALUES (NULL, 1, 20, 3, 35);
INSERT INTO versification_data VALUES (NULL, 1, 20, 4, 27);
INSERT INTO versification_data VALUES (NULL, 1, 20, 5, 23);
INSERT INTO versification_data VALUES (NULL, 1, 20, 6, 35);
INSERT INTO versification_data VALUES (NULL, 1, 20, 7, 27);
INSERT INTO versification_data VALUES (NULL, 1, 20, 8, 36);
INSERT INTO versification_data VALUES (NULL, 1, 20, 9, 18);
INSERT INTO versification_data VALUES (NULL, 1, 20, 10, 32);
INSERT INTO versification_data VALUES (NULL, 1, 20, 11, 31);
INSERT INTO versification_data VALUES (NULL, 1, 20, 12, 28);
INSERT INTO versification_data VALUES (NULL, 1, 20, 13, 25);
INSERT INTO versification_data VALUES (NULL, 1, 20, 14, 35);
INSERT INTO versification_data VALUES (NULL, 1, 20, 15, 33);
INSERT INTO versification_data VALUES (NULL, 1, 20, 16, 33);
INSERT INTO versification_data VALUES (NULL, 1, 20, 17, 28);
INSERT INTO versification_data VALUES (NULL, 1, 20, 18, 24);
INSERT INTO versification_data VALUES (NULL, 1, 20, 19, 29);
INSERT INTO versification_data VALUES (NULL, 1, 20, 20, 30);
INSERT INTO versification_data VALUES (NULL, 1, 20, 21, 31);
INSERT INTO versification_data VALUES (NULL, 1, 20, 22, 29);
INSERT INTO versification_data VALUES (NULL, 1, 20, 23, 35);
INSERT INTO versification_data VALUES (NULL, 1, 20, 24, 34);
INSERT INTO versification_data VALUES (NULL, 1, 20, 25, 28);
INSERT INTO versification_data VALUES (NULL, 1, 20, 26, 28);
INSERT INTO versification_data VALUES (NULL, 1, 20, 27, 27);
INSERT INTO versification_data VALUES (NULL, 1, 20, 28, 28);
INSERT INTO versification_data VALUES (NULL, 1, 20, 29, 27);
INSERT INTO versification_data VALUES (NULL, 1, 20, 30, 33);
INSERT INTO versification_data VALUES (NULL, 1, 20, 31, 31);
INSERT INTO versification_data VALUES (NULL, 1, 21, 1, 18);
INSERT INTO versification_data VALUES (NULL, 1, 21, 2, 26);
INSERT INTO versification_data VALUES (NULL, 1, 21, 3, 22);
INSERT INTO versification_data VALUES (NULL, 1, 21, 4, 17);
INSERT INTO versification_data VALUES (NULL, 1, 21, 5, 19);
INSERT INTO versification_data VALUES (NULL, 1, 21, 6, 12);
INSERT INTO versification_data VALUES (NULL, 1, 21, 7, 29);
INSERT INTO versification_data VALUES (NULL, 1, 21, 8, 17);
INSERT INTO versification_data VALUES (NULL, 1, 21, 9, 18);
INSERT INTO versification_data VALUES (NULL, 1, 21, 10, 20);
INSERT INTO versification_data VALUES (NULL, 1, 21, 11, 10);
INSERT INTO versification_data VALUES (NULL, 1, 21, 12, 14);
INSERT INTO versification_data VALUES (NULL, 1, 22, 1, 16);
INSERT INTO versification_data VALUES (NULL, 1, 22, 2, 17);
INSERT INTO versification_data VALUES (NULL, 1, 22, 3, 11);
INSERT INTO versification_data VALUES (NULL, 1, 22, 4, 16);
INSERT INTO versification_data VALUES (NULL, 1, 22, 5, 16);
INSERT INTO versification_data VALUES (NULL, 1, 22, 6, 12);
INSERT INTO versification_data VALUES (NULL, 1, 22, 7, 14);
INSERT INTO versification_data VALUES (NULL, 1, 22, 8, 14);
INSERT INTO versification_data VALUES (NULL, 1, 23, 1, 31);
INSERT INTO versification_data VALUES (NULL, 1, 23, 2, 22);
INSERT INTO versification_data VALUES (NULL, 1, 23, 3, 25);
INSERT INTO versification_data VALUES (NULL, 1, 23, 4, 6);
INSERT INTO versification_data VALUES (NULL, 1, 23, 5, 30);
INSERT INTO versification_data VALUES (NULL, 1, 23, 6, 13);
INSERT INTO versification_data VALUES (NULL, 1, 23, 7, 25);
INSERT INTO versification_data VALUES (NULL, 1, 23, 8, 22);
INSERT INTO versification_data VALUES (NULL, 1, 23, 9, 21);
INSERT INTO versification_data VALUES (NULL, 1, 23, 10, 34);
INSERT INTO versification_data VALUES (NULL, 1, 23, 11, 16);
INSERT INTO versification_data VALUES (NULL, 1, 23, 12, 6);
INSERT INTO versification_data VALUES (NULL, 1, 23, 13, 22);
INSERT INTO versification_data VALUES (NULL, 1, 23, 14, 32);
INSERT INTO versification_data VALUES (NULL, 1, 23, 15, 9);
INSERT INTO versification_data VALUES (NULL, 1, 23, 16, 14);
INSERT INTO versification_data VALUES (NULL, 1, 23, 17, 14);
INSERT INTO versification_data VALUES (NULL, 1, 23, 18, 7);
INSERT INTO versification_data VALUES (NULL, 1, 23, 19, 25);
INSERT INTO versification_data VALUES (NULL, 1, 23, 20, 6);
INSERT INTO versification_data VALUES (NULL, 1, 23, 21, 17);
INSERT INTO versification_data VALUES (NULL, 1, 23, 22, 25);
INSERT INTO versification_data VALUES (NULL, 1, 23, 23, 18);
INSERT INTO versification_data VALUES (NULL, 1, 23, 24, 23);
INSERT INTO versification_data VALUES (NULL, 1, 23, 25, 12);
INSERT INTO versification_data VALUES (NULL, 1, 23, 26, 21);
INSERT INTO versification_data VALUES (NULL, 1, 23, 27, 13);
INSERT INTO versification_data VALUES (NULL, 1, 23, 28, 29);
INSERT INTO versification_data VALUES (NULL, 1, 23, 29, 24);
INSERT INTO versification_data VALUES (NULL, 1, 23, 30, 33);
INSERT INTO versification_data VALUES (NULL, 1, 23, 31, 9);
INSERT INTO versification_data VALUES (NULL, 1, 23, 32, 20);
INSERT INTO versification_data VALUES (NULL, 1, 23, 33, 24);
INSERT INTO versification_data VALUES (NULL, 1, 23, 34, 17);
INSERT INTO versification_data VALUES (NULL, 1, 23, 35, 10);
INSERT INTO versification_data VALUES (NULL, 1, 23, 36, 22);
INSERT INTO versification_data VALUES (NULL, 1, 23, 37, 38);
INSERT INTO versification_data VALUES (NULL, 1, 23, 38, 22);
INSERT INTO versification_data VALUES (NULL, 1, 23, 39, 8);
INSERT INTO versification_data VALUES (NULL, 1, 23, 40, 31);
INSERT INTO versification_data VALUES (NULL, 1, 23, 41, 29);
INSERT INTO versification_data VALUES (NULL, 1, 23, 42, 25);
INSERT INTO versification_data VALUES (NULL, 1, 23, 43, 28);
INSERT INTO versification_data VALUES (NULL, 1, 23, 44, 28);
INSERT INTO versification_data VALUES (NULL, 1, 23, 45, 25);
INSERT INTO versification_data VALUES (NULL, 1, 23, 46, 13);
INSERT INTO versification_data VALUES (NULL, 1, 23, 47, 15);
INSERT INTO versification_data VALUES (NULL, 1, 23, 48, 22);
INSERT INTO versification_data VALUES (NULL, 1, 23, 49, 26);
INSERT INTO versification_data VALUES (NULL, 1, 23, 50, 11);
INSERT INTO versification_data VALUES (NULL, 1, 23, 51, 23);
INSERT INTO versification_data VALUES (NULL, 1, 23, 52, 15);
INSERT INTO versification_data VALUES (NULL, 1, 23, 53, 12);
INSERT INTO versification_data VALUES (NULL, 1, 23, 54, 17);
INSERT INTO versification_data VALUES (NULL, 1, 23, 55, 13);
INSERT INTO versification_data VALUES (NULL, 1, 23, 56, 12);
INSERT INTO versification_data VALUES (NULL, 1, 23, 57, 21);
INSERT INTO versification_data VALUES (NULL, 1, 23, 58, 14);
INSERT INTO versification_data VALUES (NULL, 1, 23, 59, 21);
INSERT INTO versification_data VALUES (NULL, 1, 23, 60, 22);
INSERT INTO versification_data VALUES (NULL, 1, 23, 61, 11);
INSERT INTO versification_data VALUES (NULL, 1, 23, 62, 12);
INSERT INTO versification_data VALUES (NULL, 1, 23, 63, 19);
INSERT INTO versification_data VALUES (NULL, 1, 23, 64, 12);
INSERT INTO versification_data VALUES (NULL, 1, 23, 65, 25);
INSERT INTO versification_data VALUES (NULL, 1, 23, 66, 24);
INSERT INTO versification_data VALUES (NULL, 1, 24, 1, 19);
INSERT INTO versification_data VALUES (NULL, 1, 24, 2, 37);
INSERT INTO versification_data VALUES (NULL, 1, 24, 3, 25);
INSERT INTO versification_data VALUES (NULL, 1, 24, 4, 31);
INSERT INTO versification_data VALUES (NULL, 1, 24, 5, 31);
INSERT INTO versification_data VALUES (NULL, 1, 24, 6, 30);
INSERT INTO versification_data VALUES (NULL, 1, 24, 7, 34);
INSERT INTO versification_data VALUES (NULL, 1, 24, 8, 22);
INSERT INTO versification_data VALUES (NULL, 1, 24, 9, 26);
INSERT INTO versification_data VALUES (NULL, 1, 24, 10, 25);
INSERT INTO versification_data VALUES (NULL, 1, 24, 11, 23);
INSERT INTO versification_data VALUES (NULL, 1, 24, 12, 17);
INSERT INTO versification_data VALUES (NULL, 1, 24, 13, 27);
INSERT INTO versification_data VALUES (NULL, 1, 24, 14, 22);
INSERT INTO versification_data VALUES (NULL, 1, 24, 15, 21);
INSERT INTO versification_data VALUES (NULL, 1, 24, 16, 21);
INSERT INTO versification_data VALUES (NULL, 1, 24, 17, 27);
INSERT INTO versification_data VALUES (NULL, 1, 24, 18, 23);
INSERT INTO versification_data VALUES (NULL, 1, 24, 19, 15);
INSERT INTO versification_data VALUES (NULL, 1, 24, 20, 18);
INSERT INTO versification_data VALUES (NULL, 1, 24, 21, 14);
INSERT INTO versification_data VALUES (NULL, 1, 24, 22, 30);
INSERT INTO versification_data VALUES (NULL, 1, 24, 23, 40);
INSERT INTO versification_data VALUES (NULL, 1, 24, 24, 10);
INSERT INTO versification_data VALUES (NULL, 1, 24, 25, 38);
INSERT INTO versification_data VALUES (NULL, 1, 24, 26, 24);
INSERT INTO versification_data VALUES (NULL, 1, 24, 27, 22);
INSERT INTO versification_data VALUES (NULL, 1, 24, 28, 17);
INSERT INTO versification_data VALUES (NULL, 1, 24, 29, 32);
INSERT INTO versification_data VALUES (NULL, 1, 24, 30, 24);
INSERT INTO versification_data VALUES (NULL, 1, 24, 31, 40);
INSERT INTO versification_data VALUES (NULL, 1, 24, 32, 44);
INSERT INTO versification_data VALUES (NULL, 1, 24, 33, 26);
INSERT INTO versification_data VALUES (NULL, 1, 24, 34, 22);
INSERT INTO versification_data VALUES (NULL, 1, 24, 35, 19);
INSERT INTO versification_data VALUES (NULL, 1, 24, 36, 32);
INSERT INTO versification_data VALUES (NULL, 1, 24, 37, 21);
INSERT INTO versification_data VALUES (NULL, 1, 24, 38, 28);
INSERT INTO versification_data VALUES (NULL, 1, 24, 39, 18);
INSERT INTO versification_data VALUES (NULL, 1, 24, 40, 16);
INSERT INTO versification_data VALUES (NULL, 1, 24, 41, 18);
INSERT INTO versification_data VALUES (NULL, 1, 24, 42, 22);
INSERT INTO versification_data VALUES (NULL, 1, 24, 43, 13);
INSERT INTO versification_data VALUES (NULL, 1, 24, 44, 30);
INSERT INTO versification_data VALUES (NULL, 1, 24, 45, 5);
INSERT INTO versification_data VALUES (NULL, 1, 24, 46, 28);
INSERT INTO versification_data VALUES (NULL, 1, 24, 47, 7);
INSERT INTO versification_data VALUES (NULL, 1, 24, 48, 47);
INSERT INTO versification_data VALUES (NULL, 1, 24, 49, 39);
INSERT INTO versification_data VALUES (NULL, 1, 24, 50, 46);
INSERT INTO versification_data VALUES (NULL, 1, 24, 51, 64);
INSERT INTO versification_data VALUES (NULL, 1, 24, 52, 34);
INSERT INTO versification_data VALUES (NULL, 1, 25, 1, 22);
INSERT INTO versification_data VALUES (NULL, 1, 25, 2, 22);
INSERT INTO versification_data VALUES (NULL, 1, 25, 3, 66);
INSERT INTO versification_data VALUES (NULL, 1, 25, 4, 22);
INSERT INTO versification_data VALUES (NULL, 1, 25, 5, 22);
INSERT INTO versification_data VALUES (NULL, 1, 26, 1, 28);
INSERT INTO versification_data VALUES (NULL, 1, 26, 2, 10);
INSERT INTO versification_data VALUES (NULL, 1, 26, 3, 27);
INSERT INTO versification_data VALUES (NULL, 1, 26, 4, 17);
INSERT INTO versification_data VALUES (NULL, 1, 26, 5, 17);
INSERT INTO versification_data VALUES (NULL, 1, 26, 6, 14);
INSERT INTO versification_data VALUES (NULL, 1, 26, 7, 27);
INSERT INTO versification_data VALUES (NULL, 1, 26, 8, 18);
INSERT INTO versification_data VALUES (NULL, 1, 26, 9, 11);
INSERT INTO versification_data VALUES (NULL, 1, 26, 10, 22);
INSERT INTO versification_data VALUES (NULL, 1, 26, 11, 25);
INSERT INTO versification_data VALUES (NULL, 1, 26, 12, 28);
INSERT INTO versification_data VALUES (NULL, 1, 26, 13, 23);
INSERT INTO versification_data VALUES (NULL, 1, 26, 14, 23);
INSERT INTO versification_data VALUES (NULL, 1, 26, 15, 8);
INSERT INTO versification_data VALUES (NULL, 1, 26, 16, 63);
INSERT INTO versification_data VALUES (NULL, 1, 26, 17, 24);
INSERT INTO versification_data VALUES (NULL, 1, 26, 18, 32);
INSERT INTO versification_data VALUES (NULL, 1, 26, 19, 14);
INSERT INTO versification_data VALUES (NULL, 1, 26, 20, 49);
INSERT INTO versification_data VALUES (NULL, 1, 26, 21, 32);
INSERT INTO versification_data VALUES (NULL, 1, 26, 22, 31);
INSERT INTO versification_data VALUES (NULL, 1, 26, 23, 49);
INSERT INTO versification_data VALUES (NULL, 1, 26, 24, 27);
INSERT INTO versification_data VALUES (NULL, 1, 26, 25, 17);
INSERT INTO versification_data VALUES (NULL, 1, 26, 26, 21);
INSERT INTO versification_data VALUES (NULL, 1, 26, 27, 36);
INSERT INTO versification_data VALUES (NULL, 1, 26, 28, 26);
INSERT INTO versification_data VALUES (NULL, 1, 26, 29, 21);
INSERT INTO versification_data VALUES (NULL, 1, 26, 30, 26);
INSERT INTO versification_data VALUES (NULL, 1, 26, 31, 18);
INSERT INTO versification_data VALUES (NULL, 1, 26, 32, 32);
INSERT INTO versification_data VALUES (NULL, 1, 26, 33, 33);
INSERT INTO versification_data VALUES (NULL, 1, 26, 34, 31);
INSERT INTO versification_data VALUES (NULL, 1, 26, 35, 15);
INSERT INTO versification_data VALUES (NULL, 1, 26, 36, 38);
INSERT INTO versification_data VALUES (NULL, 1, 26, 37, 28);
INSERT INTO versification_data VALUES (NULL, 1, 26, 38, 23);
INSERT INTO versification_data VALUES (NULL, 1, 26, 39, 29);
INSERT INTO versification_data VALUES (NULL, 1, 26, 40, 49);
INSERT INTO versification_data VALUES (NULL, 1, 26, 41, 26);
INSERT INTO versification_data VALUES (NULL, 1, 26, 42, 20);
INSERT INTO versification_data VALUES (NULL, 1, 26, 43, 27);
INSERT INTO versification_data VALUES (NULL, 1, 26, 44, 31);
INSERT INTO versification_data VALUES (NULL, 1, 26, 45, 25);
INSERT INTO versification_data VALUES (NULL, 1, 26, 46, 24);
INSERT INTO versification_data VALUES (NULL, 1, 26, 47, 23);
INSERT INTO versification_data VALUES (NULL, 1, 26, 48, 35);
INSERT INTO versification_data VALUES (NULL, 1, 27, 1, 21);
INSERT INTO versification_data VALUES (NULL, 1, 27, 2, 49);
INSERT INTO versification_data VALUES (NULL, 1, 27, 3, 33);
INSERT INTO versification_data VALUES (NULL, 1, 27, 4, 34);
INSERT INTO versification_data VALUES (NULL, 1, 27, 5, 31);
INSERT INTO versification_data VALUES (NULL, 1, 27, 6, 28);
INSERT INTO versification_data VALUES (NULL, 1, 27, 7, 28);
INSERT INTO versification_data VALUES (NULL, 1, 27, 8, 27);
INSERT INTO versification_data VALUES (NULL, 1, 27, 9, 27);
INSERT INTO versification_data VALUES (NULL, 1, 27, 10, 21);
INSERT INTO versification_data VALUES (NULL, 1, 27, 11, 45);
INSERT INTO versification_data VALUES (NULL, 1, 27, 12, 13);
INSERT INTO versification_data VALUES (NULL, 1, 28, 1, 11);
INSERT INTO versification_data VALUES (NULL, 1, 28, 2, 23);
INSERT INTO versification_data VALUES (NULL, 1, 28, 3, 5);
INSERT INTO versification_data VALUES (NULL, 1, 28, 4, 19);
INSERT INTO versification_data VALUES (NULL, 1, 28, 5, 15);
INSERT INTO versification_data VALUES (NULL, 1, 28, 6, 11);
INSERT INTO versification_data VALUES (NULL, 1, 28, 7, 16);
INSERT INTO versification_data VALUES (NULL, 1, 28, 8, 14);
INSERT INTO versification_data VALUES (NULL, 1, 28, 9, 17);
INSERT INTO versification_data VALUES (NULL, 1, 28, 10, 15);
INSERT INTO versification_data VALUES (NULL, 1, 28, 11, 12);
INSERT INTO versification_data VALUES (NULL, 1, 28, 12, 14);
INSERT INTO versification_data VALUES (NULL, 1, 28, 13, 15);
INSERT INTO versification_data VALUES (NULL, 1, 28, 14, 10);
INSERT INTO versification_data VALUES (NULL, 1, 29, 1, 20);
INSERT INTO versification_data VALUES (NULL, 1, 29, 2, 32);
INSERT INTO versification_data VALUES (NULL, 1, 29, 3, 21);
INSERT INTO versification_data VALUES (NULL, 1, 30, 1, 15);
INSERT INTO versification_data VALUES (NULL, 1, 30, 2, 16);
INSERT INTO versification_data VALUES (NULL, 1, 30, 3, 15);
INSERT INTO versification_data VALUES (NULL, 1, 30, 4, 13);
INSERT INTO versification_data VALUES (NULL, 1, 30, 5, 27);
INSERT INTO versification_data VALUES (NULL, 1, 30, 6, 14);
INSERT INTO versification_data VALUES (NULL, 1, 30, 7, 17);
INSERT INTO versification_data VALUES (NULL, 1, 30, 8, 14);
INSERT INTO versification_data VALUES (NULL, 1, 30, 9, 15);
INSERT INTO versification_data VALUES (NULL, 1, 31, 1, 21);
INSERT INTO versification_data VALUES (NULL, 1, 32, 1, 16);
INSERT INTO versification_data VALUES (NULL, 1, 32, 2, 11);
INSERT INTO versification_data VALUES (NULL, 1, 32, 3, 10);
INSERT INTO versification_data VALUES (NULL, 1, 32, 4, 11);
INSERT INTO versification_data VALUES (NULL, 1, 33, 1, 16);
INSERT INTO versification_data VALUES (NULL, 1, 33, 2, 13);
INSERT INTO versification_data VALUES (NULL, 1, 33, 3, 12);
INSERT INTO versification_data VALUES (NULL, 1, 33, 4, 13);
INSERT INTO versification_data VALUES (NULL, 1, 33, 5, 15);
INSERT INTO versification_data VALUES (NULL, 1, 33, 6, 16);
INSERT INTO versification_data VALUES (NULL, 1, 33, 7, 20);
INSERT INTO versification_data VALUES (NULL, 1, 34, 1, 15);
INSERT INTO versification_data VALUES (NULL, 1, 34, 2, 13);
INSERT INTO versification_data VALUES (NULL, 1, 34, 3, 19);
INSERT INTO versification_data VALUES (NULL, 1, 35, 1, 17);
INSERT INTO versification_data VALUES (NULL, 1, 35, 2, 20);
INSERT INTO versification_data VALUES (NULL, 1, 35, 3, 19);
INSERT INTO versification_data VALUES (NULL, 1, 36, 1, 18);
INSERT INTO versification_data VALUES (NULL, 1, 36, 2, 15);
INSERT INTO versification_data VALUES (NULL, 1, 36, 3, 20);
INSERT INTO versification_data VALUES (NULL, 1, 37, 1, 15);
INSERT INTO versification_data VALUES (NULL, 1, 37, 2, 23);
INSERT INTO versification_data VALUES (NULL, 1, 38, 1, 21);
INSERT INTO versification_data VALUES (NULL, 1, 38, 2, 13);
INSERT INTO versification_data VALUES (NULL, 1, 38, 3, 10);
INSERT INTO versification_data VALUES (NULL, 1, 38, 4, 14);
INSERT INTO versification_data VALUES (NULL, 1, 38, 5, 11);
INSERT INTO versification_data VALUES (NULL, 1, 38, 6, 15);
INSERT INTO versification_data VALUES (NULL, 1, 38, 7, 14);
INSERT INTO versification_data VALUES (NULL, 1, 38, 8, 23);
INSERT INTO versification_data VALUES (NULL, 1, 38, 9, 17);
INSERT INTO versification_data VALUES (NULL, 1, 38, 10, 12);
INSERT INTO versification_data VALUES (NULL, 1, 38, 11, 17);
INSERT INTO versification_data VALUES (NULL, 1, 38, 12, 14);
INSERT INTO versification_data VALUES (NULL, 1, 38, 13, 9);
INSERT INTO versification_data VALUES (NULL, 1, 38, 14, 21);
INSERT INTO versification_data VALUES (NULL, 1, 39, 1, 14);
INSERT INTO versification_data VALUES (NULL, 1, 39, 2, 17);
INSERT INTO versification_data VALUES (NULL, 1, 39, 3, 18);
INSERT INTO versification_data VALUES (NULL, 1, 39, 4, 6);
INSERT INTO versification_data VALUES (NULL, 1, 40, 1, 25);
INSERT INTO versification_data VALUES (NULL, 1, 40, 2, 23);
INSERT INTO versification_data VALUES (NULL, 1, 40, 3, 17);
INSERT INTO versification_data VALUES (NULL, 1, 40, 4, 25);
INSERT INTO versification_data VALUES (NULL, 1, 40, 5, 48);
INSERT INTO versification_data VALUES (NULL, 1, 40, 6, 34);
INSERT INTO versification_data VALUES (NULL, 1, 40, 7, 29);
INSERT INTO versification_data VALUES (NULL, 1, 40, 8, 34);
INSERT INTO versification_data VALUES (NULL, 1, 40, 9, 38);
INSERT INTO versification_data VALUES (NULL, 1, 40, 10, 42);
INSERT INTO versification_data VALUES (NULL, 1, 40, 11, 30);
INSERT INTO versification_data VALUES (NULL, 1, 40, 12, 50);
INSERT INTO versification_data VALUES (NULL, 1, 40, 13, 58);
INSERT INTO versification_data VALUES (NULL, 1, 40, 14, 36);
INSERT INTO versification_data VALUES (NULL, 1, 40, 15, 39);
INSERT INTO versification_data VALUES (NULL, 1, 40, 16, 28);
INSERT INTO versification_data VALUES (NULL, 1, 40, 17, 27);
INSERT INTO versification_data VALUES (NULL, 1, 40, 18, 35);
INSERT INTO versification_data VALUES (NULL, 1, 40, 19, 30);
INSERT INTO versification_data VALUES (NULL, 1, 40, 20, 34);
INSERT INTO versification_data VALUES (NULL, 1, 40, 21, 46);
INSERT INTO versification_data VALUES (NULL, 1, 40, 22, 46);
INSERT INTO versification_data VALUES (NULL, 1, 40, 23, 39);
INSERT INTO versification_data VALUES (NULL, 1, 40, 24, 51);
INSERT INTO versification_data VALUES (NULL, 1, 40, 25, 46);
INSERT INTO versification_data VALUES (NULL, 1, 40, 26, 75);
INSERT INTO versification_data VALUES (NULL, 1, 40, 27, 66);
INSERT INTO versification_data VALUES (NULL, 1, 40, 28, 20);
INSERT INTO versification_data VALUES (NULL, 1, 41, 1, 45);
INSERT INTO versification_data VALUES (NULL, 1, 41, 2, 28);
INSERT INTO versification_data VALUES (NULL, 1, 41, 3, 35);
INSERT INTO versification_data VALUES (NULL, 1, 41, 4, 41);
INSERT INTO versification_data VALUES (NULL, 1, 41, 5, 43);
INSERT INTO versification_data VALUES (NULL, 1, 41, 6, 56);
INSERT INTO versification_data VALUES (NULL, 1, 41, 7, 37);
INSERT INTO versification_data VALUES (NULL, 1, 41, 8, 38);
INSERT INTO versification_data VALUES (NULL, 1, 41, 9, 50);
INSERT INTO versification_data VALUES (NULL, 1, 41, 10, 52);
INSERT INTO versification_data VALUES (NULL, 1, 41, 11, 33);
INSERT INTO versification_data VALUES (NULL, 1, 41, 12, 44);
INSERT INTO versification_data VALUES (NULL, 1, 41, 13, 37);
INSERT INTO versification_data VALUES (NULL, 1, 41, 14, 72);
INSERT INTO versification_data VALUES (NULL, 1, 41, 15, 47);
INSERT INTO versification_data VALUES (NULL, 1, 41, 16, 20);
INSERT INTO versification_data VALUES (NULL, 1, 42, 1, 80);
INSERT INTO versification_data VALUES (NULL, 1, 42, 2, 52);
INSERT INTO versification_data VALUES (NULL, 1, 42, 3, 38);
INSERT INTO versification_data VALUES (NULL, 1, 42, 4, 44);
INSERT INTO versification_data VALUES (NULL, 1, 42, 5, 39);
INSERT INTO versification_data VALUES (NULL, 1, 42, 6, 49);
INSERT INTO versification_data VALUES (NULL, 1, 42, 7, 50);
INSERT INTO versification_data VALUES (NULL, 1, 42, 8, 56);
INSERT INTO versification_data VALUES (NULL, 1, 42, 9, 62);
INSERT INTO versification_data VALUES (NULL, 1, 42, 10, 42);
INSERT INTO versification_data VALUES (NULL, 1, 42, 11, 54);
INSERT INTO versification_data VALUES (NULL, 1, 42, 12, 59);
INSERT INTO versification_data VALUES (NULL, 1, 42, 13, 35);
INSERT INTO versification_data VALUES (NULL, 1, 42, 14, 35);
INSERT INTO versification_data VALUES (NULL, 1, 42, 15, 32);
INSERT INTO versification_data VALUES (NULL, 1, 42, 16, 31);
INSERT INTO versification_data VALUES (NULL, 1, 42, 17, 37);
INSERT INTO versification_data VALUES (NULL, 1, 42, 18, 43);
INSERT INTO versification_data VALUES (NULL, 1, 42, 19, 48);
INSERT INTO versification_data VALUES (NULL, 1, 42, 20, 47);
INSERT INTO versification_data VALUES (NULL, 1, 42, 21, 38);
INSERT INTO versification_data VALUES (NULL, 1, 42, 22, 71);
INSERT INTO versification_data VALUES (NULL, 1, 42, 23, 56);
INSERT INTO versification_data VALUES (NULL, 1, 42, 24, 53);
INSERT INTO versification_data VALUES (NULL, 1, 43, 1, 51);
INSERT INTO versification_data VALUES (NULL, 1, 43, 2, 25);
INSERT INTO versification_data VALUES (NULL, 1, 43, 3, 36);
INSERT INTO versification_data VALUES (NULL, 1, 43, 4, 54);
INSERT INTO versification_data VALUES (NULL, 1, 43, 5, 47);
INSERT INTO versification_data VALUES (NULL, 1, 43, 6, 71);
INSERT INTO versification_data VALUES (NULL, 1, 43, 7, 53);
INSERT INTO versification_data VALUES (NULL, 1, 43, 8, 59);
INSERT INTO versification_data VALUES (NULL, 1, 43, 9, 41);
INSERT INTO versification_data VALUES (NULL, 1, 43, 10, 42);
INSERT INTO versification_data VALUES (NULL, 1, 43, 11, 57);
INSERT INTO versification_data VALUES (NULL, 1, 43, 12, 50);
INSERT INTO versification_data VALUES (NULL, 1, 43, 13, 38);
INSERT INTO versification_data VALUES (NULL, 1, 43, 14, 31);
INSERT INTO versification_data VALUES (NULL, 1, 43, 15, 27);
INSERT INTO versification_data VALUES (NULL, 1, 43, 16, 33);
INSERT INTO versification_data VALUES (NULL, 1, 43, 17, 26);
INSERT INTO versification_data VALUES (NULL, 1, 43, 18, 40);
INSERT INTO versification_data VALUES (NULL, 1, 43, 19, 42);
INSERT INTO versification_data VALUES (NULL, 1, 43, 20, 31);
INSERT INTO versification_data VALUES (NULL, 1, 43, 21, 25);
INSERT INTO versification_data VALUES (NULL, 1, 44, 1, 26);
INSERT INTO versification_data VALUES (NULL, 1, 44, 2, 47);
INSERT INTO versification_data VALUES (NULL, 1, 44, 3, 26);
INSERT INTO versification_data VALUES (NULL, 1, 44, 4, 37);
INSERT INTO versification_data VALUES (NULL, 1, 44, 5, 42);
INSERT INTO versification_data VALUES (NULL, 1, 44, 6, 15);
INSERT INTO versification_data VALUES (NULL, 1, 44, 7, 60);
INSERT INTO versification_data VALUES (NULL, 1, 44, 8, 40);
INSERT INTO versification_data VALUES (NULL, 1, 44, 9, 43);
INSERT INTO versification_data VALUES (NULL, 1, 44, 10, 48);
INSERT INTO versification_data VALUES (NULL, 1, 44, 11, 30);
INSERT INTO versification_data VALUES (NULL, 1, 44, 12, 25);
INSERT INTO versification_data VALUES (NULL, 1, 44, 13, 52);
INSERT INTO versification_data VALUES (NULL, 1, 44, 14, 28);
INSERT INTO versification_data VALUES (NULL, 1, 44, 15, 41);
INSERT INTO versification_data VALUES (NULL, 1, 44, 16, 40);
INSERT INTO versification_data VALUES (NULL, 1, 44, 17, 34);
INSERT INTO versification_data VALUES (NULL, 1, 44, 18, 28);
INSERT INTO versification_data VALUES (NULL, 1, 44, 19, 40);
INSERT INTO versification_data VALUES (NULL, 1, 44, 20, 38);
INSERT INTO versification_data VALUES (NULL, 1, 44, 21, 40);
INSERT INTO versification_data VALUES (NULL, 1, 44, 22, 30);
INSERT INTO versification_data VALUES (NULL, 1, 44, 23, 35);
INSERT INTO versification_data VALUES (NULL, 1, 44, 24, 27);
INSERT INTO versification_data VALUES (NULL, 1, 44, 25, 27);
INSERT INTO versification_data VALUES (NULL, 1, 44, 26, 32);
INSERT INTO versification_data VALUES (NULL, 1, 44, 27, 44);
INSERT INTO versification_data VALUES (NULL, 1, 44, 28, 31);
INSERT INTO versification_data VALUES (NULL, 1, 45, 1, 32);
INSERT INTO versification_data VALUES (NULL, 1, 45, 2, 29);
INSERT INTO versification_data VALUES (NULL, 1, 45, 3, 31);
INSERT INTO versification_data VALUES (NULL, 1, 45, 4, 25);
INSERT INTO versification_data VALUES (NULL, 1, 45, 5, 21);
INSERT INTO versification_data VALUES (NULL, 1, 45, 6, 23);
INSERT INTO versification_data VALUES (NULL, 1, 45, 7, 25);
INSERT INTO versification_data VALUES (NULL, 1, 45, 8, 39);
INSERT INTO versification_data VALUES (NULL, 1, 45, 9, 33);
INSERT INTO versification_data VALUES (NULL, 1, 45, 10, 21);
INSERT INTO versification_data VALUES (NULL, 1, 45, 11, 36);
INSERT INTO versification_data VALUES (NULL, 1, 45, 12, 21);
INSERT INTO versification_data VALUES (NULL, 1, 45, 13, 14);
INSERT INTO versification_data VALUES (NULL, 1, 45, 14, 26);
INSERT INTO versification_data VALUES (NULL, 1, 45, 15, 33);
INSERT INTO versification_data VALUES (NULL, 1, 45, 16, 24);
INSERT INTO versification_data VALUES (NULL, 1, 46, 1, 31);
INSERT INTO versification_data VALUES (NULL, 1, 46, 2, 16);
INSERT INTO versification_data VALUES (NULL, 1, 46, 3, 23);
INSERT INTO versification_data VALUES (NULL, 1, 46, 4, 21);
INSERT INTO versification_data VALUES (NULL, 1, 46, 5, 13);
INSERT INTO versification_data VALUES (NULL, 1, 46, 6, 20);
INSERT INTO versification_data VALUES (NULL, 1, 46, 7, 40);
INSERT INTO versification_data VALUES (NULL, 1, 46, 8, 13);
INSERT INTO versification_data VALUES (NULL, 1, 46, 9, 27);
INSERT INTO versification_data VALUES (NULL, 1, 46, 10, 33);
INSERT INTO versification_data VALUES (NULL, 1, 46, 11, 34);
INSERT INTO versification_data VALUES (NULL, 1, 46, 12, 31);
INSERT INTO versification_data VALUES (NULL, 1, 46, 13, 13);
INSERT INTO versification_data VALUES (NULL, 1, 46, 14, 40);
INSERT INTO versification_data VALUES (NULL, 1, 46, 15, 58);
INSERT INTO versification_data VALUES (NULL, 1, 46, 16, 24);
INSERT INTO versification_data VALUES (NULL, 1, 47, 1, 24);
INSERT INTO versification_data VALUES (NULL, 1, 47, 2, 17);
INSERT INTO versification_data VALUES (NULL, 1, 47, 3, 18);
INSERT INTO versification_data VALUES (NULL, 1, 47, 4, 18);
INSERT INTO versification_data VALUES (NULL, 1, 47, 5, 21);
INSERT INTO versification_data VALUES (NULL, 1, 47, 6, 18);
INSERT INTO versification_data VALUES (NULL, 1, 47, 7, 16);
INSERT INTO versification_data VALUES (NULL, 1, 47, 8, 24);
INSERT INTO versification_data VALUES (NULL, 1, 47, 9, 15);
INSERT INTO versification_data VALUES (NULL, 1, 47, 10, 18);
INSERT INTO versification_data VALUES (NULL, 1, 47, 11, 32);
INSERT INTO versification_data VALUES (NULL, 1, 47, 12, 21);
INSERT INTO versification_data VALUES (NULL, 1, 47, 13, 13);
INSERT INTO versification_data VALUES (NULL, 1, 48, 1, 24);
INSERT INTO versification_data VALUES (NULL, 1, 48, 2, 21);
INSERT INTO versification_data VALUES (NULL, 1, 48, 3, 29);
INSERT INTO versification_data VALUES (NULL, 1, 48, 4, 31);
INSERT INTO versification_data VALUES (NULL, 1, 48, 5, 26);
INSERT INTO versification_data VALUES (NULL, 1, 48, 6, 18);
INSERT INTO versification_data VALUES (NULL, 1, 49, 1, 23);
INSERT INTO versification_data VALUES (NULL, 1, 49, 2, 22);
INSERT INTO versification_data VALUES (NULL, 1, 49, 3, 21);
INSERT INTO versification_data VALUES (NULL, 1, 49, 4, 32);
INSERT INTO versification_data VALUES (NULL, 1, 49, 5, 33);
INSERT INTO versification_data VALUES (NULL, 1, 49, 6, 24);
INSERT INTO versification_data VALUES (NULL, 1, 50, 1, 30);
INSERT INTO versification_data VALUES (NULL, 1, 50, 2, 30);
INSERT INTO versification_data VALUES (NULL, 1, 50, 3, 21);
INSERT INTO versification_data VALUES (NULL, 1, 50, 4, 23);
INSERT INTO versification_data VALUES (NULL, 1, 51, 1, 29);
INSERT INTO versification_data VALUES (NULL, 1, 51, 2, 23);
INSERT INTO versification_data VALUES (NULL, 1, 51, 3, 25);
INSERT INTO versification_data VALUES (NULL, 1, 51, 4, 18);
INSERT INTO versification_data VALUES (NULL, 1, 52, 1, 10);
INSERT INTO versification_data VALUES (NULL, 1, 52, 2, 20);
INSERT INTO versification_data VALUES (NULL, 1, 52, 3, 13);
INSERT INTO versification_data VALUES (NULL, 1, 52, 4, 18);
INSERT INTO versification_data VALUES (NULL, 1, 52, 5, 28);
INSERT INTO versification_data VALUES (NULL, 1, 53, 1, 12);
INSERT INTO versification_data VALUES (NULL, 1, 53, 2, 17);
INSERT INTO versification_data VALUES (NULL, 1, 53, 3, 18);
INSERT INTO versification_data VALUES (NULL, 1, 54, 1, 20);
INSERT INTO versification_data VALUES (NULL, 1, 54, 2, 15);
INSERT INTO versification_data VALUES (NULL, 1, 54, 3, 16);
INSERT INTO versification_data VALUES (NULL, 1, 54, 4, 16);
INSERT INTO versification_data VALUES (NULL, 1, 54, 5, 25);
INSERT INTO versification_data VALUES (NULL, 1, 54, 6, 21);
INSERT INTO versification_data VALUES (NULL, 1, 55, 1, 18);
INSERT INTO versification_data VALUES (NULL, 1, 55, 2, 26);
INSERT INTO versification_data VALUES (NULL, 1, 55, 3, 17);
INSERT INTO versification_data VALUES (NULL, 1, 55, 4, 22);
INSERT INTO versification_data VALUES (NULL, 1, 56, 1, 16);
INSERT INTO versification_data VALUES (NULL, 1, 56, 2, 15);
INSERT INTO versification_data VALUES (NULL, 1, 56, 3, 15);
INSERT INTO versification_data VALUES (NULL, 1, 57, 1, 25);
INSERT INTO versification_data VALUES (NULL, 1, 58, 1, 14);
INSERT INTO versification_data VALUES (NULL, 1, 58, 2, 18);
INSERT INTO versification_data VALUES (NULL, 1, 58, 3, 19);
INSERT INTO versification_data VALUES (NULL, 1, 58, 4, 16);
INSERT INTO versification_data VALUES (NULL, 1, 58, 5, 14);
INSERT INTO versification_data VALUES (NULL, 1, 58, 6, 20);
INSERT INTO versification_data VALUES (NULL, 1, 58, 7, 28);
INSERT INTO versification_data VALUES (NULL, 1, 58, 8, 13);
INSERT INTO versification_data VALUES (NULL, 1, 58, 9, 28);
INSERT INTO versification_data VALUES (NULL, 1, 58, 10, 39);
INSERT INTO versification_data VALUES (NULL, 1, 58, 11, 40);
INSERT INTO versification_data VALUES (NULL, 1, 58, 12, 29);
INSERT INTO versification_data VALUES (NULL, 1, 58, 13, 25);
INSERT INTO versification_data VALUES (NULL, 1, 59, 1, 27);
INSERT INTO versification_data VALUES (NULL, 1, 59, 2, 26);
INSERT INTO versification_data VALUES (NULL, 1, 59, 3, 18);
INSERT INTO versification_data VALUES (NULL, 1, 59, 4, 17);
INSERT INTO versification_data VALUES (NULL, 1, 59, 5, 20);
INSERT INTO versification_data VALUES (NULL, 1, 60, 1, 25);
INSERT INTO versification_data VALUES (NULL, 1, 60, 2, 25);
INSERT INTO versification_data VALUES (NULL, 1, 60, 3, 22);
INSERT INTO versification_data VALUES (NULL, 1, 60, 4, 19);
INSERT INTO versification_data VALUES (NULL, 1, 60, 5, 14);
INSERT INTO versification_data VALUES (NULL, 1, 61, 1, 21);
INSERT INTO versification_data VALUES (NULL, 1, 61, 2, 22);
INSERT INTO versification_data VALUES (NULL, 1, 61, 3, 18);
INSERT INTO versification_data VALUES (NULL, 1, 62, 1, 10);
INSERT INTO versification_data VALUES (NULL, 1, 62, 2, 29);
INSERT INTO versification_data VALUES (NULL, 1, 62, 3, 24);
INSERT INTO versification_data VALUES (NULL, 1, 62, 4, 21);
INSERT INTO versification_data VALUES (NULL, 1, 62, 5, 21);
INSERT INTO versification_data VALUES (NULL, 1, 63, 1, 13);
INSERT INTO versification_data VALUES (NULL, 1, 64, 1, 15);
INSERT INTO versification_data VALUES (NULL, 1, 65, 1, 25);
INSERT INTO versification_data VALUES (NULL, 1, 66, 1, 20);
INSERT INTO versification_data VALUES (NULL, 1, 66, 2, 29);
INSERT INTO versification_data VALUES (NULL, 1, 66, 3, 22);
INSERT INTO versification_data VALUES (NULL, 1, 66, 4, 11);
INSERT INTO versification_data VALUES (NULL, 1, 66, 5, 14);
INSERT INTO versification_data VALUES (NULL, 1, 66, 6, 17);
INSERT INTO versification_data VALUES (NULL, 1, 66, 7, 17);
INSERT INTO versification_data VALUES (NULL, 1, 66, 8, 13);
INSERT INTO versification_data VALUES (NULL, 1, 66, 9, 21);
INSERT INTO versification_data VALUES (NULL, 1, 66, 10, 11);
INSERT INTO versification_data VALUES (NULL, 1, 66, 11, 19);
INSERT INTO versification_data VALUES (NULL, 1, 66, 12, 17);
INSERT INTO versification_data VALUES (NULL, 1, 66, 13, 18);
INSERT INTO versification_data VALUES (NULL, 1, 66, 14, 20);
INSERT INTO versification_data VALUES (NULL, 1, 66, 15, 8);
INSERT INTO versification_data VALUES (NULL, 1, 66, 16, 21);
INSERT INTO versification_data VALUES (NULL, 1, 66, 17, 18);
INSERT INTO versification_data VALUES (NULL, 1, 66, 18, 24);
INSERT INTO versification_data VALUES (NULL, 1, 66, 19, 21);
INSERT INTO versification_data VALUES (NULL, 1, 66, 20, 15);
INSERT INTO versification_data VALUES (NULL, 1, 66, 21, 27);
INSERT INTO versification_data VALUES (NULL, 1, 66, 22, 21);

INSERT INTO versification_names VALUES (2, 'Dutch Traditional');

INSERT INTO versification_data VALUES (NULL, 2, 1, 1, 31);
INSERT INTO versification_data VALUES (NULL, 2, 1, 2, 25);
INSERT INTO versification_data VALUES (NULL, 2, 1, 3, 24);
INSERT INTO versification_data VALUES (NULL, 2, 1, 4, 26);
INSERT INTO versification_data VALUES (NULL, 2, 1, 5, 32);
INSERT INTO versification_data VALUES (NULL, 2, 1, 6, 22);
INSERT INTO versification_data VALUES (NULL, 2, 1, 7, 24);
INSERT INTO versification_data VALUES (NULL, 2, 1, 8, 22);
INSERT INTO versification_data VALUES (NULL, 2, 1, 9, 29);
INSERT INTO versification_data VALUES (NULL, 2, 1, 10, 32);
INSERT INTO versification_data VALUES (NULL, 2, 1, 11, 32);
INSERT INTO versification_data VALUES (NULL, 2, 1, 12, 20);
INSERT INTO versification_data VALUES (NULL, 2, 1, 13, 18);
INSERT INTO versification_data VALUES (NULL, 2, 1, 14, 24);
INSERT INTO versification_data VALUES (NULL, 2, 1, 15, 21);
INSERT INTO versification_data VALUES (NULL, 2, 1, 16, 16);
INSERT INTO versification_data VALUES (NULL, 2, 1, 17, 27);
INSERT INTO versification_data VALUES (NULL, 2, 1, 18, 33);
INSERT INTO versification_data VALUES (NULL, 2, 1, 19, 38);
INSERT INTO versification_data VALUES (NULL, 2, 1, 20, 18);
INSERT INTO versification_data VALUES (NULL, 2, 1, 21, 34);
INSERT INTO versification_data VALUES (NULL, 2, 1, 22, 24);
INSERT INTO versification_data VALUES (NULL, 2, 1, 23, 20);
INSERT INTO versification_data VALUES (NULL, 2, 1, 24, 67);
INSERT INTO versification_data VALUES (NULL, 2, 1, 25, 34);
INSERT INTO versification_data VALUES (NULL, 2, 1, 26, 35);
INSERT INTO versification_data VALUES (NULL, 2, 1, 27, 46);
INSERT INTO versification_data VALUES (NULL, 2, 1, 28, 22);
INSERT INTO versification_data VALUES (NULL, 2, 1, 29, 35);
INSERT INTO versification_data VALUES (NULL, 2, 1, 30, 43);
INSERT INTO versification_data VALUES (NULL, 2, 1, 31, 55);
INSERT INTO versification_data VALUES (NULL, 2, 1, 32, 32);
INSERT INTO versification_data VALUES (NULL, 2, 1, 33, 20);
INSERT INTO versification_data VALUES (NULL, 2, 1, 34, 31);
INSERT INTO versification_data VALUES (NULL, 2, 1, 35, 29);
INSERT INTO versification_data VALUES (NULL, 2, 1, 36, 43);
INSERT INTO versification_data VALUES (NULL, 2, 1, 37, 36);
INSERT INTO versification_data VALUES (NULL, 2, 1, 38, 30);
INSERT INTO versification_data VALUES (NULL, 2, 1, 39, 23);
INSERT INTO versification_data VALUES (NULL, 2, 1, 40, 23);
INSERT INTO versification_data VALUES (NULL, 2, 1, 41, 57);
INSERT INTO versification_data VALUES (NULL, 2, 1, 42, 38);
INSERT INTO versification_data VALUES (NULL, 2, 1, 43, 34);
INSERT INTO versification_data VALUES (NULL, 2, 1, 44, 34);
INSERT INTO versification_data VALUES (NULL, 2, 1, 45, 28);
INSERT INTO versification_data VALUES (NULL, 2, 1, 46, 34);
INSERT INTO versification_data VALUES (NULL, 2, 1, 47, 31);
INSERT INTO versification_data VALUES (NULL, 2, 1, 48, 22);
INSERT INTO versification_data VALUES (NULL, 2, 1, 49, 33);
INSERT INTO versification_data VALUES (NULL, 2, 1, 50, 26);
INSERT INTO versification_data VALUES (NULL, 2, 2, 1, 22);
INSERT INTO versification_data VALUES (NULL, 2, 2, 2, 25);
INSERT INTO versification_data VALUES (NULL, 2, 2, 3, 22);
INSERT INTO versification_data VALUES (NULL, 2, 2, 4, 31);
INSERT INTO versification_data VALUES (NULL, 2, 2, 5, 24);
INSERT INTO versification_data VALUES (NULL, 2, 2, 6, 29);
INSERT INTO versification_data VALUES (NULL, 2, 2, 7, 25);
INSERT INTO versification_data VALUES (NULL, 2, 2, 8, 32);
INSERT INTO versification_data VALUES (NULL, 2, 2, 9, 35);
INSERT INTO versification_data VALUES (NULL, 2, 2, 10, 29);
INSERT INTO versification_data VALUES (NULL, 2, 2, 11, 10);
INSERT INTO versification_data VALUES (NULL, 2, 2, 12, 51);
INSERT INTO versification_data VALUES (NULL, 2, 2, 13, 22);
INSERT INTO versification_data VALUES (NULL, 2, 2, 14, 31);
INSERT INTO versification_data VALUES (NULL, 2, 2, 15, 27);
INSERT INTO versification_data VALUES (NULL, 2, 2, 16, 36);
INSERT INTO versification_data VALUES (NULL, 2, 2, 17, 16);
INSERT INTO versification_data VALUES (NULL, 2, 2, 18, 27);
INSERT INTO versification_data VALUES (NULL, 2, 2, 19, 25);
INSERT INTO versification_data VALUES (NULL, 2, 2, 20, 26);
INSERT INTO versification_data VALUES (NULL, 2, 2, 21, 36);
INSERT INTO versification_data VALUES (NULL, 2, 2, 22, 31);
INSERT INTO versification_data VALUES (NULL, 2, 2, 23, 33);
INSERT INTO versification_data VALUES (NULL, 2, 2, 24, 18);
INSERT INTO versification_data VALUES (NULL, 2, 2, 25, 40);
INSERT INTO versification_data VALUES (NULL, 2, 2, 26, 37);
INSERT INTO versification_data VALUES (NULL, 2, 2, 27, 21);
INSERT INTO versification_data VALUES (NULL, 2, 2, 28, 43);
INSERT INTO versification_data VALUES (NULL, 2, 2, 29, 46);
INSERT INTO versification_data VALUES (NULL, 2, 2, 30, 38);
INSERT INTO versification_data VALUES (NULL, 2, 2, 31, 18);
INSERT INTO versification_data VALUES (NULL, 2, 2, 32, 35);
INSERT INTO versification_data VALUES (NULL, 2, 2, 33, 23);
INSERT INTO versification_data VALUES (NULL, 2, 2, 34, 35);
INSERT INTO versification_data VALUES (NULL, 2, 2, 35, 35);
INSERT INTO versification_data VALUES (NULL, 2, 2, 36, 38);
INSERT INTO versification_data VALUES (NULL, 2, 2, 37, 29);
INSERT INTO versification_data VALUES (NULL, 2, 2, 38, 31);
INSERT INTO versification_data VALUES (NULL, 2, 2, 39, 43);
INSERT INTO versification_data VALUES (NULL, 2, 2, 40, 38);
INSERT INTO versification_data VALUES (NULL, 2, 3, 1, 17);
INSERT INTO versification_data VALUES (NULL, 2, 3, 2, 16);
INSERT INTO versification_data VALUES (NULL, 2, 3, 3, 17);
INSERT INTO versification_data VALUES (NULL, 2, 3, 4, 35);
INSERT INTO versification_data VALUES (NULL, 2, 3, 5, 19);
INSERT INTO versification_data VALUES (NULL, 2, 3, 6, 30);
INSERT INTO versification_data VALUES (NULL, 2, 3, 7, 38);
INSERT INTO versification_data VALUES (NULL, 2, 3, 8, 36);
INSERT INTO versification_data VALUES (NULL, 2, 3, 9, 24);
INSERT INTO versification_data VALUES (NULL, 2, 3, 10, 20);
INSERT INTO versification_data VALUES (NULL, 2, 3, 11, 47);
INSERT INTO versification_data VALUES (NULL, 2, 3, 12, 8);
INSERT INTO versification_data VALUES (NULL, 2, 3, 13, 59);
INSERT INTO versification_data VALUES (NULL, 2, 3, 14, 57);
INSERT INTO versification_data VALUES (NULL, 2, 3, 15, 33);
INSERT INTO versification_data VALUES (NULL, 2, 3, 16, 34);
INSERT INTO versification_data VALUES (NULL, 2, 3, 17, 16);
INSERT INTO versification_data VALUES (NULL, 2, 3, 18, 30);
INSERT INTO versification_data VALUES (NULL, 2, 3, 19, 37);
INSERT INTO versification_data VALUES (NULL, 2, 3, 20, 27);
INSERT INTO versification_data VALUES (NULL, 2, 3, 21, 24);
INSERT INTO versification_data VALUES (NULL, 2, 3, 22, 33);
INSERT INTO versification_data VALUES (NULL, 2, 3, 23, 44);
INSERT INTO versification_data VALUES (NULL, 2, 3, 24, 23);
INSERT INTO versification_data VALUES (NULL, 2, 3, 25, 55);
INSERT INTO versification_data VALUES (NULL, 2, 3, 26, 46);
INSERT INTO versification_data VALUES (NULL, 2, 3, 27, 34);
INSERT INTO versification_data VALUES (NULL, 2, 4, 1, 54);
INSERT INTO versification_data VALUES (NULL, 2, 4, 2, 34);
INSERT INTO versification_data VALUES (NULL, 2, 4, 3, 51);
INSERT INTO versification_data VALUES (NULL, 2, 4, 4, 49);
INSERT INTO versification_data VALUES (NULL, 2, 4, 5, 31);
INSERT INTO versification_data VALUES (NULL, 2, 4, 6, 27);
INSERT INTO versification_data VALUES (NULL, 2, 4, 7, 89);
INSERT INTO versification_data VALUES (NULL, 2, 4, 8, 26);
INSERT INTO versification_data VALUES (NULL, 2, 4, 9, 23);
INSERT INTO versification_data VALUES (NULL, 2, 4, 10, 36);
INSERT INTO versification_data VALUES (NULL, 2, 4, 11, 35);
INSERT INTO versification_data VALUES (NULL, 2, 4, 12, 16);
INSERT INTO versification_data VALUES (NULL, 2, 4, 13, 33);
INSERT INTO versification_data VALUES (NULL, 2, 4, 14, 45);
INSERT INTO versification_data VALUES (NULL, 2, 4, 15, 41);
INSERT INTO versification_data VALUES (NULL, 2, 4, 16, 50);
INSERT INTO versification_data VALUES (NULL, 2, 4, 17, 13);
INSERT INTO versification_data VALUES (NULL, 2, 4, 18, 32);
INSERT INTO versification_data VALUES (NULL, 2, 4, 19, 22);
INSERT INTO versification_data VALUES (NULL, 2, 4, 20, 29);
INSERT INTO versification_data VALUES (NULL, 2, 4, 21, 35);
INSERT INTO versification_data VALUES (NULL, 2, 4, 22, 41);
INSERT INTO versification_data VALUES (NULL, 2, 4, 23, 30);
INSERT INTO versification_data VALUES (NULL, 2, 4, 24, 25);
INSERT INTO versification_data VALUES (NULL, 2, 4, 25, 18);
INSERT INTO versification_data VALUES (NULL, 2, 4, 26, 65);
INSERT INTO versification_data VALUES (NULL, 2, 4, 27, 23);
INSERT INTO versification_data VALUES (NULL, 2, 4, 28, 31);
INSERT INTO versification_data VALUES (NULL, 2, 4, 29, 40);
INSERT INTO versification_data VALUES (NULL, 2, 4, 30, 16);
INSERT INTO versification_data VALUES (NULL, 2, 4, 31, 54);
INSERT INTO versification_data VALUES (NULL, 2, 4, 32, 42);
INSERT INTO versification_data VALUES (NULL, 2, 4, 33, 56);
INSERT INTO versification_data VALUES (NULL, 2, 4, 34, 29);
INSERT INTO versification_data VALUES (NULL, 2, 4, 35, 34);
INSERT INTO versification_data VALUES (NULL, 2, 4, 36, 13);
INSERT INTO versification_data VALUES (NULL, 2, 5, 1, 46);
INSERT INTO versification_data VALUES (NULL, 2, 5, 2, 37);
INSERT INTO versification_data VALUES (NULL, 2, 5, 3, 29);
INSERT INTO versification_data VALUES (NULL, 2, 5, 4, 49);
INSERT INTO versification_data VALUES (NULL, 2, 5, 5, 33);
INSERT INTO versification_data VALUES (NULL, 2, 5, 6, 25);
INSERT INTO versification_data VALUES (NULL, 2, 5, 7, 26);
INSERT INTO versification_data VALUES (NULL, 2, 5, 8, 20);
INSERT INTO versification_data VALUES (NULL, 2, 5, 9, 29);
INSERT INTO versification_data VALUES (NULL, 2, 5, 10, 22);
INSERT INTO versification_data VALUES (NULL, 2, 5, 11, 32);
INSERT INTO versification_data VALUES (NULL, 2, 5, 12, 32);
INSERT INTO versification_data VALUES (NULL, 2, 5, 13, 18);
INSERT INTO versification_data VALUES (NULL, 2, 5, 14, 29);
INSERT INTO versification_data VALUES (NULL, 2, 5, 15, 23);
INSERT INTO versification_data VALUES (NULL, 2, 5, 16, 22);
INSERT INTO versification_data VALUES (NULL, 2, 5, 17, 20);
INSERT INTO versification_data VALUES (NULL, 2, 5, 18, 22);
INSERT INTO versification_data VALUES (NULL, 2, 5, 19, 21);
INSERT INTO versification_data VALUES (NULL, 2, 5, 20, 20);
INSERT INTO versification_data VALUES (NULL, 2, 5, 21, 23);
INSERT INTO versification_data VALUES (NULL, 2, 5, 22, 30);
INSERT INTO versification_data VALUES (NULL, 2, 5, 23, 25);
INSERT INTO versification_data VALUES (NULL, 2, 5, 24, 22);
INSERT INTO versification_data VALUES (NULL, 2, 5, 25, 19);
INSERT INTO versification_data VALUES (NULL, 2, 5, 26, 19);
INSERT INTO versification_data VALUES (NULL, 2, 5, 27, 26);
INSERT INTO versification_data VALUES (NULL, 2, 5, 28, 68);
INSERT INTO versification_data VALUES (NULL, 2, 5, 29, 29);
INSERT INTO versification_data VALUES (NULL, 2, 5, 30, 20);
INSERT INTO versification_data VALUES (NULL, 2, 5, 31, 30);
INSERT INTO versification_data VALUES (NULL, 2, 5, 32, 52);
INSERT INTO versification_data VALUES (NULL, 2, 5, 33, 29);
INSERT INTO versification_data VALUES (NULL, 2, 5, 34, 12);
INSERT INTO versification_data VALUES (NULL, 2, 6, 1, 18);
INSERT INTO versification_data VALUES (NULL, 2, 6, 2, 24);
INSERT INTO versification_data VALUES (NULL, 2, 6, 3, 17);
INSERT INTO versification_data VALUES (NULL, 2, 6, 4, 24);
INSERT INTO versification_data VALUES (NULL, 2, 6, 5, 15);
INSERT INTO versification_data VALUES (NULL, 2, 6, 6, 27);
INSERT INTO versification_data VALUES (NULL, 2, 6, 7, 26);
INSERT INTO versification_data VALUES (NULL, 2, 6, 8, 35);
INSERT INTO versification_data VALUES (NULL, 2, 6, 9, 27);
INSERT INTO versification_data VALUES (NULL, 2, 6, 10, 43);
INSERT INTO versification_data VALUES (NULL, 2, 6, 11, 23);
INSERT INTO versification_data VALUES (NULL, 2, 6, 12, 24);
INSERT INTO versification_data VALUES (NULL, 2, 6, 13, 33);
INSERT INTO versification_data VALUES (NULL, 2, 6, 14, 15);
INSERT INTO versification_data VALUES (NULL, 2, 6, 15, 63);
INSERT INTO versification_data VALUES (NULL, 2, 6, 16, 10);
INSERT INTO versification_data VALUES (NULL, 2, 6, 17, 18);
INSERT INTO versification_data VALUES (NULL, 2, 6, 18, 28);
INSERT INTO versification_data VALUES (NULL, 2, 6, 19, 51);
INSERT INTO versification_data VALUES (NULL, 2, 6, 20, 9);
INSERT INTO versification_data VALUES (NULL, 2, 6, 21, 45);
INSERT INTO versification_data VALUES (NULL, 2, 6, 22, 34);
INSERT INTO versification_data VALUES (NULL, 2, 6, 23, 16);
INSERT INTO versification_data VALUES (NULL, 2, 6, 24, 33);
INSERT INTO versification_data VALUES (NULL, 2, 7, 1, 36);
INSERT INTO versification_data VALUES (NULL, 2, 7, 2, 23);
INSERT INTO versification_data VALUES (NULL, 2, 7, 3, 31);
INSERT INTO versification_data VALUES (NULL, 2, 7, 4, 24);
INSERT INTO versification_data VALUES (NULL, 2, 7, 5, 31);
INSERT INTO versification_data VALUES (NULL, 2, 7, 6, 40);
INSERT INTO versification_data VALUES (NULL, 2, 7, 7, 25);
INSERT INTO versification_data VALUES (NULL, 2, 7, 8, 35);
INSERT INTO versification_data VALUES (NULL, 2, 7, 9, 57);
INSERT INTO versification_data VALUES (NULL, 2, 7, 10, 18);
INSERT INTO versification_data VALUES (NULL, 2, 7, 11, 40);
INSERT INTO versification_data VALUES (NULL, 2, 7, 12, 15);
INSERT INTO versification_data VALUES (NULL, 2, 7, 13, 25);
INSERT INTO versification_data VALUES (NULL, 2, 7, 14, 20);
INSERT INTO versification_data VALUES (NULL, 2, 7, 15, 20);
INSERT INTO versification_data VALUES (NULL, 2, 7, 16, 31);
INSERT INTO versification_data VALUES (NULL, 2, 7, 17, 13);
INSERT INTO versification_data VALUES (NULL, 2, 7, 18, 31);
INSERT INTO versification_data VALUES (NULL, 2, 7, 19, 30);
INSERT INTO versification_data VALUES (NULL, 2, 7, 20, 48);
INSERT INTO versification_data VALUES (NULL, 2, 7, 21, 25);
INSERT INTO versification_data VALUES (NULL, 2, 8, 1, 22);
INSERT INTO versification_data VALUES (NULL, 2, 8, 2, 23);
INSERT INTO versification_data VALUES (NULL, 2, 8, 3, 18);
INSERT INTO versification_data VALUES (NULL, 2, 8, 4, 22);
INSERT INTO versification_data VALUES (NULL, 2, 9, 1, 28);
INSERT INTO versification_data VALUES (NULL, 2, 9, 2, 36);
INSERT INTO versification_data VALUES (NULL, 2, 9, 3, 21);
INSERT INTO versification_data VALUES (NULL, 2, 9, 4, 22);
INSERT INTO versification_data VALUES (NULL, 2, 9, 5, 12);
INSERT INTO versification_data VALUES (NULL, 2, 9, 6, 21);
INSERT INTO versification_data VALUES (NULL, 2, 9, 7, 17);
INSERT INTO versification_data VALUES (NULL, 2, 9, 8, 22);
INSERT INTO versification_data VALUES (NULL, 2, 9, 9, 27);
INSERT INTO versification_data VALUES (NULL, 2, 9, 10, 27);
INSERT INTO versification_data VALUES (NULL, 2, 9, 11, 15);
INSERT INTO versification_data VALUES (NULL, 2, 9, 12, 25);
INSERT INTO versification_data VALUES (NULL, 2, 9, 13, 23);
INSERT INTO versification_data VALUES (NULL, 2, 9, 14, 52);
INSERT INTO versification_data VALUES (NULL, 2, 9, 15, 35);
INSERT INTO versification_data VALUES (NULL, 2, 9, 16, 23);
INSERT INTO versification_data VALUES (NULL, 2, 9, 17, 58);
INSERT INTO versification_data VALUES (NULL, 2, 9, 18, 30);
INSERT INTO versification_data VALUES (NULL, 2, 9, 19, 24);
INSERT INTO versification_data VALUES (NULL, 2, 9, 20, 43);
INSERT INTO versification_data VALUES (NULL, 2, 9, 21, 15);
INSERT INTO versification_data VALUES (NULL, 2, 9, 22, 23);
INSERT INTO versification_data VALUES (NULL, 2, 9, 23, 28);
INSERT INTO versification_data VALUES (NULL, 2, 9, 24, 23);
INSERT INTO versification_data VALUES (NULL, 2, 9, 25, 44);
INSERT INTO versification_data VALUES (NULL, 2, 9, 26, 25);
INSERT INTO versification_data VALUES (NULL, 2, 9, 27, 12);
INSERT INTO versification_data VALUES (NULL, 2, 9, 28, 25);
INSERT INTO versification_data VALUES (NULL, 2, 9, 29, 11);
INSERT INTO versification_data VALUES (NULL, 2, 9, 30, 31);
INSERT INTO versification_data VALUES (NULL, 2, 9, 31, 13);
INSERT INTO versification_data VALUES (NULL, 2, 10, 1, 27);
INSERT INTO versification_data VALUES (NULL, 2, 10, 2, 32);
INSERT INTO versification_data VALUES (NULL, 2, 10, 3, 39);
INSERT INTO versification_data VALUES (NULL, 2, 10, 4, 12);
INSERT INTO versification_data VALUES (NULL, 2, 10, 5, 25);
INSERT INTO versification_data VALUES (NULL, 2, 10, 6, 23);
INSERT INTO versification_data VALUES (NULL, 2, 10, 7, 29);
INSERT INTO versification_data VALUES (NULL, 2, 10, 8, 18);
INSERT INTO versification_data VALUES (NULL, 2, 10, 9, 13);
INSERT INTO versification_data VALUES (NULL, 2, 10, 10, 19);
INSERT INTO versification_data VALUES (NULL, 2, 10, 11, 27);
INSERT INTO versification_data VALUES (NULL, 2, 10, 12, 31);
INSERT INTO versification_data VALUES (NULL, 2, 10, 13, 39);
INSERT INTO versification_data VALUES (NULL, 2, 10, 14, 33);
INSERT INTO versification_data VALUES (NULL, 2, 10, 15, 37);
INSERT INTO versification_data VALUES (NULL, 2, 10, 16, 23);
INSERT INTO versification_data VALUES (NULL, 2, 10, 17, 29);
INSERT INTO versification_data VALUES (NULL, 2, 10, 18, 33);
INSERT INTO versification_data VALUES (NULL, 2, 10, 19, 43);
INSERT INTO versification_data VALUES (NULL, 2, 10, 20, 26);
INSERT INTO versification_data VALUES (NULL, 2, 10, 21, 22);
INSERT INTO versification_data VALUES (NULL, 2, 10, 22, 51);
INSERT INTO versification_data VALUES (NULL, 2, 10, 23, 39);
INSERT INTO versification_data VALUES (NULL, 2, 10, 24, 25);
INSERT INTO versification_data VALUES (NULL, 2, 11, 1, 53);
INSERT INTO versification_data VALUES (NULL, 2, 11, 2, 46);
INSERT INTO versification_data VALUES (NULL, 2, 11, 3, 28);
INSERT INTO versification_data VALUES (NULL, 2, 11, 4, 34);
INSERT INTO versification_data VALUES (NULL, 2, 11, 5, 18);
INSERT INTO versification_data VALUES (NULL, 2, 11, 6, 38);
INSERT INTO versification_data VALUES (NULL, 2, 11, 7, 51);
INSERT INTO versification_data VALUES (NULL, 2, 11, 8, 66);
INSERT INTO versification_data VALUES (NULL, 2, 11, 9, 28);
INSERT INTO versification_data VALUES (NULL, 2, 11, 10, 29);
INSERT INTO versification_data VALUES (NULL, 2, 11, 11, 43);
INSERT INTO versification_data VALUES (NULL, 2, 11, 12, 33);
INSERT INTO versification_data VALUES (NULL, 2, 11, 13, 34);
INSERT INTO versification_data VALUES (NULL, 2, 11, 14, 31);
INSERT INTO versification_data VALUES (NULL, 2, 11, 15, 34);
INSERT INTO versification_data VALUES (NULL, 2, 11, 16, 34);
INSERT INTO versification_data VALUES (NULL, 2, 11, 17, 24);
INSERT INTO versification_data VALUES (NULL, 2, 11, 18, 46);
INSERT INTO versification_data VALUES (NULL, 2, 11, 19, 21);
INSERT INTO versification_data VALUES (NULL, 2, 11, 20, 43);
INSERT INTO versification_data VALUES (NULL, 2, 11, 21, 29);
INSERT INTO versification_data VALUES (NULL, 2, 11, 22, 54);
INSERT INTO versification_data VALUES (NULL, 2, 12, 1, 18);
INSERT INTO versification_data VALUES (NULL, 2, 12, 2, 25);
INSERT INTO versification_data VALUES (NULL, 2, 12, 3, 27);
INSERT INTO versification_data VALUES (NULL, 2, 12, 4, 44);
INSERT INTO versification_data VALUES (NULL, 2, 12, 5, 27);
INSERT INTO versification_data VALUES (NULL, 2, 12, 6, 33);
INSERT INTO versification_data VALUES (NULL, 2, 12, 7, 20);
INSERT INTO versification_data VALUES (NULL, 2, 12, 8, 29);
INSERT INTO versification_data VALUES (NULL, 2, 12, 9, 37);
INSERT INTO versification_data VALUES (NULL, 2, 12, 10, 36);
INSERT INTO versification_data VALUES (NULL, 2, 12, 11, 21);
INSERT INTO versification_data VALUES (NULL, 2, 12, 12, 21);
INSERT INTO versification_data VALUES (NULL, 2, 12, 13, 25);
INSERT INTO versification_data VALUES (NULL, 2, 12, 14, 29);
INSERT INTO versification_data VALUES (NULL, 2, 12, 15, 38);
INSERT INTO versification_data VALUES (NULL, 2, 12, 16, 20);
INSERT INTO versification_data VALUES (NULL, 2, 12, 17, 41);
INSERT INTO versification_data VALUES (NULL, 2, 12, 18, 37);
INSERT INTO versification_data VALUES (NULL, 2, 12, 19, 37);
INSERT INTO versification_data VALUES (NULL, 2, 12, 20, 21);
INSERT INTO versification_data VALUES (NULL, 2, 12, 21, 26);
INSERT INTO versification_data VALUES (NULL, 2, 12, 22, 20);
INSERT INTO versification_data VALUES (NULL, 2, 12, 23, 37);
INSERT INTO versification_data VALUES (NULL, 2, 12, 24, 20);
INSERT INTO versification_data VALUES (NULL, 2, 12, 25, 30);
INSERT INTO versification_data VALUES (NULL, 2, 13, 1, 54);
INSERT INTO versification_data VALUES (NULL, 2, 13, 2, 55);
INSERT INTO versification_data VALUES (NULL, 2, 13, 3, 24);
INSERT INTO versification_data VALUES (NULL, 2, 13, 4, 43);
INSERT INTO versification_data VALUES (NULL, 2, 13, 5, 26);
INSERT INTO versification_data VALUES (NULL, 2, 13, 6, 81);
INSERT INTO versification_data VALUES (NULL, 2, 13, 7, 40);
INSERT INTO versification_data VALUES (NULL, 2, 13, 8, 40);
INSERT INTO versification_data VALUES (NULL, 2, 13, 9, 44);
INSERT INTO versification_data VALUES (NULL, 2, 13, 10, 14);
INSERT INTO versification_data VALUES (NULL, 2, 13, 11, 47);
INSERT INTO versification_data VALUES (NULL, 2, 13, 12, 40);
INSERT INTO versification_data VALUES (NULL, 2, 13, 13, 14);
INSERT INTO versification_data VALUES (NULL, 2, 13, 14, 17);
INSERT INTO versification_data VALUES (NULL, 2, 13, 15, 29);
INSERT INTO versification_data VALUES (NULL, 2, 13, 16, 43);
INSERT INTO versification_data VALUES (NULL, 2, 13, 17, 27);
INSERT INTO versification_data VALUES (NULL, 2, 13, 18, 17);
INSERT INTO versification_data VALUES (NULL, 2, 13, 19, 19);
INSERT INTO versification_data VALUES (NULL, 2, 13, 20, 8);
INSERT INTO versification_data VALUES (NULL, 2, 13, 21, 30);
INSERT INTO versification_data VALUES (NULL, 2, 13, 22, 19);
INSERT INTO versification_data VALUES (NULL, 2, 13, 23, 32);
INSERT INTO versification_data VALUES (NULL, 2, 13, 24, 31);
INSERT INTO versification_data VALUES (NULL, 2, 13, 25, 31);
INSERT INTO versification_data VALUES (NULL, 2, 13, 26, 32);
INSERT INTO versification_data VALUES (NULL, 2, 13, 27, 34);
INSERT INTO versification_data VALUES (NULL, 2, 13, 28, 21);
INSERT INTO versification_data VALUES (NULL, 2, 13, 29, 30);
INSERT INTO versification_data VALUES (NULL, 2, 14, 1, 17);
INSERT INTO versification_data VALUES (NULL, 2, 14, 2, 18);
INSERT INTO versification_data VALUES (NULL, 2, 14, 3, 17);
INSERT INTO versification_data VALUES (NULL, 2, 14, 4, 22);
INSERT INTO versification_data VALUES (NULL, 2, 14, 5, 14);
INSERT INTO versification_data VALUES (NULL, 2, 14, 6, 42);
INSERT INTO versification_data VALUES (NULL, 2, 14, 7, 22);
INSERT INTO versification_data VALUES (NULL, 2, 14, 8, 18);
INSERT INTO versification_data VALUES (NULL, 2, 14, 9, 31);
INSERT INTO versification_data VALUES (NULL, 2, 14, 10, 19);
INSERT INTO versification_data VALUES (NULL, 2, 14, 11, 23);
INSERT INTO versification_data VALUES (NULL, 2, 14, 12, 16);
INSERT INTO versification_data VALUES (NULL, 2, 14, 13, 22);
INSERT INTO versification_data VALUES (NULL, 2, 14, 14, 15);
INSERT INTO versification_data VALUES (NULL, 2, 14, 15, 19);
INSERT INTO versification_data VALUES (NULL, 2, 14, 16, 14);
INSERT INTO versification_data VALUES (NULL, 2, 14, 17, 19);
INSERT INTO versification_data VALUES (NULL, 2, 14, 18, 34);
INSERT INTO versification_data VALUES (NULL, 2, 14, 19, 11);
INSERT INTO versification_data VALUES (NULL, 2, 14, 20, 37);
INSERT INTO versification_data VALUES (NULL, 2, 14, 21, 20);
INSERT INTO versification_data VALUES (NULL, 2, 14, 22, 12);
INSERT INTO versification_data VALUES (NULL, 2, 14, 23, 21);
INSERT INTO versification_data VALUES (NULL, 2, 14, 24, 27);
INSERT INTO versification_data VALUES (NULL, 2, 14, 25, 28);
INSERT INTO versification_data VALUES (NULL, 2, 14, 26, 23);
INSERT INTO versification_data VALUES (NULL, 2, 14, 27, 9);
INSERT INTO versification_data VALUES (NULL, 2, 14, 28, 27);
INSERT INTO versification_data VALUES (NULL, 2, 14, 29, 36);
INSERT INTO versification_data VALUES (NULL, 2, 14, 30, 27);
INSERT INTO versification_data VALUES (NULL, 2, 14, 31, 21);
INSERT INTO versification_data VALUES (NULL, 2, 14, 32, 33);
INSERT INTO versification_data VALUES (NULL, 2, 14, 33, 25);
INSERT INTO versification_data VALUES (NULL, 2, 14, 34, 33);
INSERT INTO versification_data VALUES (NULL, 2, 14, 35, 27);
INSERT INTO versification_data VALUES (NULL, 2, 14, 36, 23);
INSERT INTO versification_data VALUES (NULL, 2, 15, 1, 11);
INSERT INTO versification_data VALUES (NULL, 2, 15, 2, 70);
INSERT INTO versification_data VALUES (NULL, 2, 15, 3, 13);
INSERT INTO versification_data VALUES (NULL, 2, 15, 4, 24);
INSERT INTO versification_data VALUES (NULL, 2, 15, 5, 17);
INSERT INTO versification_data VALUES (NULL, 2, 15, 6, 22);
INSERT INTO versification_data VALUES (NULL, 2, 15, 7, 28);
INSERT INTO versification_data VALUES (NULL, 2, 15, 8, 36);
INSERT INTO versification_data VALUES (NULL, 2, 15, 9, 15);
INSERT INTO versification_data VALUES (NULL, 2, 15, 10, 44);
INSERT INTO versification_data VALUES (NULL, 2, 16, 1, 11);
INSERT INTO versification_data VALUES (NULL, 2, 16, 2, 20);
INSERT INTO versification_data VALUES (NULL, 2, 16, 3, 32);
INSERT INTO versification_data VALUES (NULL, 2, 16, 4, 23);
INSERT INTO versification_data VALUES (NULL, 2, 16, 5, 19);
INSERT INTO versification_data VALUES (NULL, 2, 16, 6, 19);
INSERT INTO versification_data VALUES (NULL, 2, 16, 7, 72);
INSERT INTO versification_data VALUES (NULL, 2, 16, 8, 19);
INSERT INTO versification_data VALUES (NULL, 2, 16, 9, 38);
INSERT INTO versification_data VALUES (NULL, 2, 16, 10, 39);
INSERT INTO versification_data VALUES (NULL, 2, 16, 11, 36);
INSERT INTO versification_data VALUES (NULL, 2, 16, 12, 47);
INSERT INTO versification_data VALUES (NULL, 2, 16, 13, 31);
INSERT INTO versification_data VALUES (NULL, 2, 17, 1, 22);
INSERT INTO versification_data VALUES (NULL, 2, 17, 2, 23);
INSERT INTO versification_data VALUES (NULL, 2, 17, 3, 15);
INSERT INTO versification_data VALUES (NULL, 2, 17, 4, 17);
INSERT INTO versification_data VALUES (NULL, 2, 17, 5, 14);
INSERT INTO versification_data VALUES (NULL, 2, 17, 6, 14);
INSERT INTO versification_data VALUES (NULL, 2, 17, 7, 10);
INSERT INTO versification_data VALUES (NULL, 2, 17, 8, 17);
INSERT INTO versification_data VALUES (NULL, 2, 17, 9, 32);
INSERT INTO versification_data VALUES (NULL, 2, 17, 10, 3);
INSERT INTO versification_data VALUES (NULL, 2, 18, 1, 22);
INSERT INTO versification_data VALUES (NULL, 2, 18, 2, 13);
INSERT INTO versification_data VALUES (NULL, 2, 18, 3, 26);
INSERT INTO versification_data VALUES (NULL, 2, 18, 4, 21);
INSERT INTO versification_data VALUES (NULL, 2, 18, 5, 27);
INSERT INTO versification_data VALUES (NULL, 2, 18, 6, 30);
INSERT INTO versification_data VALUES (NULL, 2, 18, 7, 21);
INSERT INTO versification_data VALUES (NULL, 2, 18, 8, 22);
INSERT INTO versification_data VALUES (NULL, 2, 18, 9, 35);
INSERT INTO versification_data VALUES (NULL, 2, 18, 10, 22);
INSERT INTO versification_data VALUES (NULL, 2, 18, 11, 20);
INSERT INTO versification_data VALUES (NULL, 2, 18, 12, 25);
INSERT INTO versification_data VALUES (NULL, 2, 18, 13, 28);
INSERT INTO versification_data VALUES (NULL, 2, 18, 14, 22);
INSERT INTO versification_data VALUES (NULL, 2, 18, 15, 35);
INSERT INTO versification_data VALUES (NULL, 2, 18, 16, 22);
INSERT INTO versification_data VALUES (NULL, 2, 18, 17, 16);
INSERT INTO versification_data VALUES (NULL, 2, 18, 18, 21);
INSERT INTO versification_data VALUES (NULL, 2, 18, 19, 29);
INSERT INTO versification_data VALUES (NULL, 2, 18, 20, 29);
INSERT INTO versification_data VALUES (NULL, 2, 18, 21, 34);
INSERT INTO versification_data VALUES (NULL, 2, 18, 22, 30);
INSERT INTO versification_data VALUES (NULL, 2, 18, 23, 17);
INSERT INTO versification_data VALUES (NULL, 2, 18, 24, 25);
INSERT INTO versification_data VALUES (NULL, 2, 18, 25, 6);
INSERT INTO versification_data VALUES (NULL, 2, 18, 26, 14);
INSERT INTO versification_data VALUES (NULL, 2, 18, 27, 23);
INSERT INTO versification_data VALUES (NULL, 2, 18, 28, 28);
INSERT INTO versification_data VALUES (NULL, 2, 18, 29, 25);
INSERT INTO versification_data VALUES (NULL, 2, 18, 30, 31);
INSERT INTO versification_data VALUES (NULL, 2, 18, 31, 40);
INSERT INTO versification_data VALUES (NULL, 2, 18, 32, 22);
INSERT INTO versification_data VALUES (NULL, 2, 18, 33, 33);
INSERT INTO versification_data VALUES (NULL, 2, 18, 34, 37);
INSERT INTO versification_data VALUES (NULL, 2, 18, 35, 16);
INSERT INTO versification_data VALUES (NULL, 2, 18, 36, 33);
INSERT INTO versification_data VALUES (NULL, 2, 18, 37, 24);
INSERT INTO versification_data VALUES (NULL, 2, 18, 38, 38);
INSERT INTO versification_data VALUES (NULL, 2, 18, 39, 38);
INSERT INTO versification_data VALUES (NULL, 2, 18, 40, 28);
INSERT INTO versification_data VALUES (NULL, 2, 18, 41, 25);
INSERT INTO versification_data VALUES (NULL, 2, 18, 42, 17);
INSERT INTO versification_data VALUES (NULL, 2, 19, 1, 6);
INSERT INTO versification_data VALUES (NULL, 2, 19, 2, 12);
INSERT INTO versification_data VALUES (NULL, 2, 19, 3, 9);
INSERT INTO versification_data VALUES (NULL, 2, 19, 4, 9);
INSERT INTO versification_data VALUES (NULL, 2, 19, 5, 13);
INSERT INTO versification_data VALUES (NULL, 2, 19, 6, 11);
INSERT INTO versification_data VALUES (NULL, 2, 19, 7, 18);
INSERT INTO versification_data VALUES (NULL, 2, 19, 8, 10);
INSERT INTO versification_data VALUES (NULL, 2, 19, 9, 21);
INSERT INTO versification_data VALUES (NULL, 2, 19, 10, 18);
INSERT INTO versification_data VALUES (NULL, 2, 19, 11, 7);
INSERT INTO versification_data VALUES (NULL, 2, 19, 12, 9);
INSERT INTO versification_data VALUES (NULL, 2, 19, 13, 6);
INSERT INTO versification_data VALUES (NULL, 2, 19, 14, 7);
INSERT INTO versification_data VALUES (NULL, 2, 19, 15, 5);
INSERT INTO versification_data VALUES (NULL, 2, 19, 16, 11);
INSERT INTO versification_data VALUES (NULL, 2, 19, 17, 15);
INSERT INTO versification_data VALUES (NULL, 2, 19, 18, 51);
INSERT INTO versification_data VALUES (NULL, 2, 19, 19, 15);
INSERT INTO versification_data VALUES (NULL, 2, 19, 20, 10);
INSERT INTO versification_data VALUES (NULL, 2, 19, 21, 14);
INSERT INTO versification_data VALUES (NULL, 2, 19, 22, 32);
INSERT INTO versification_data VALUES (NULL, 2, 19, 23, 6);
INSERT INTO versification_data VALUES (NULL, 2, 19, 24, 10);
INSERT INTO versification_data VALUES (NULL, 2, 19, 25, 22);
INSERT INTO versification_data VALUES (NULL, 2, 19, 26, 12);
INSERT INTO versification_data VALUES (NULL, 2, 19, 27, 14);
INSERT INTO versification_data VALUES (NULL, 2, 19, 28, 9);
INSERT INTO versification_data VALUES (NULL, 2, 19, 29, 11);
INSERT INTO versification_data VALUES (NULL, 2, 19, 30, 13);
INSERT INTO versification_data VALUES (NULL, 2, 19, 31, 25);
INSERT INTO versification_data VALUES (NULL, 2, 19, 32, 11);
INSERT INTO versification_data VALUES (NULL, 2, 19, 33, 22);
INSERT INTO versification_data VALUES (NULL, 2, 19, 34, 23);
INSERT INTO versification_data VALUES (NULL, 2, 19, 35, 28);
INSERT INTO versification_data VALUES (NULL, 2, 19, 36, 13);
INSERT INTO versification_data VALUES (NULL, 2, 19, 37, 40);
INSERT INTO versification_data VALUES (NULL, 2, 19, 38, 23);
INSERT INTO versification_data VALUES (NULL, 2, 19, 39, 14);
INSERT INTO versification_data VALUES (NULL, 2, 19, 40, 18);
INSERT INTO versification_data VALUES (NULL, 2, 19, 41, 14);
INSERT INTO versification_data VALUES (NULL, 2, 19, 42, 12);
INSERT INTO versification_data VALUES (NULL, 2, 19, 43, 5);
INSERT INTO versification_data VALUES (NULL, 2, 19, 44, 27);
INSERT INTO versification_data VALUES (NULL, 2, 19, 45, 18);
INSERT INTO versification_data VALUES (NULL, 2, 19, 46, 12);
INSERT INTO versification_data VALUES (NULL, 2, 19, 47, 10);
INSERT INTO versification_data VALUES (NULL, 2, 19, 48, 15);
INSERT INTO versification_data VALUES (NULL, 2, 19, 49, 21);
INSERT INTO versification_data VALUES (NULL, 2, 19, 50, 23);
INSERT INTO versification_data VALUES (NULL, 2, 19, 51, 21);
INSERT INTO versification_data VALUES (NULL, 2, 19, 52, 11);
INSERT INTO versification_data VALUES (NULL, 2, 19, 53, 7);
INSERT INTO versification_data VALUES (NULL, 2, 19, 54, 9);
INSERT INTO versification_data VALUES (NULL, 2, 19, 55, 24);
INSERT INTO versification_data VALUES (NULL, 2, 19, 56, 14);
INSERT INTO versification_data VALUES (NULL, 2, 19, 57, 12);
INSERT INTO versification_data VALUES (NULL, 2, 19, 58, 12);
INSERT INTO versification_data VALUES (NULL, 2, 19, 59, 18);
INSERT INTO versification_data VALUES (NULL, 2, 19, 60, 14);
INSERT INTO versification_data VALUES (NULL, 2, 19, 61, 9);
INSERT INTO versification_data VALUES (NULL, 2, 19, 62, 13);
INSERT INTO versification_data VALUES (NULL, 2, 19, 63, 12);
INSERT INTO versification_data VALUES (NULL, 2, 19, 64, 11);
INSERT INTO versification_data VALUES (NULL, 2, 19, 65, 14);
INSERT INTO versification_data VALUES (NULL, 2, 19, 66, 20);
INSERT INTO versification_data VALUES (NULL, 2, 19, 67, 8);
INSERT INTO versification_data VALUES (NULL, 2, 19, 68, 36);
INSERT INTO versification_data VALUES (NULL, 2, 19, 69, 37);
INSERT INTO versification_data VALUES (NULL, 2, 19, 70, 6);
INSERT INTO versification_data VALUES (NULL, 2, 19, 71, 24);
INSERT INTO versification_data VALUES (NULL, 2, 19, 72, 20);
INSERT INTO versification_data VALUES (NULL, 2, 19, 73, 28);
INSERT INTO versification_data VALUES (NULL, 2, 19, 74, 23);
INSERT INTO versification_data VALUES (NULL, 2, 19, 75, 11);
INSERT INTO versification_data VALUES (NULL, 2, 19, 76, 13);
INSERT INTO versification_data VALUES (NULL, 2, 19, 77, 21);
INSERT INTO versification_data VALUES (NULL, 2, 19, 78, 72);
INSERT INTO versification_data VALUES (NULL, 2, 19, 79, 13);
INSERT INTO versification_data VALUES (NULL, 2, 19, 80, 20);
INSERT INTO versification_data VALUES (NULL, 2, 19, 81, 17);
INSERT INTO versification_data VALUES (NULL, 2, 19, 82, 8);
INSERT INTO versification_data VALUES (NULL, 2, 19, 83, 19);
INSERT INTO versification_data VALUES (NULL, 2, 19, 84, 13);
INSERT INTO versification_data VALUES (NULL, 2, 19, 85, 14);
INSERT INTO versification_data VALUES (NULL, 2, 19, 86, 17);
INSERT INTO versification_data VALUES (NULL, 2, 19, 87, 7);
INSERT INTO versification_data VALUES (NULL, 2, 19, 88, 19);
INSERT INTO versification_data VALUES (NULL, 2, 19, 89, 53);
INSERT INTO versification_data VALUES (NULL, 2, 19, 90, 17);
INSERT INTO versification_data VALUES (NULL, 2, 19, 91, 16);
INSERT INTO versification_data VALUES (NULL, 2, 19, 92, 16);
INSERT INTO versification_data VALUES (NULL, 2, 19, 93, 5);
INSERT INTO versification_data VALUES (NULL, 2, 19, 94, 23);
INSERT INTO versification_data VALUES (NULL, 2, 19, 95, 11);
INSERT INTO versification_data VALUES (NULL, 2, 19, 96, 13);
INSERT INTO versification_data VALUES (NULL, 2, 19, 97, 12);
INSERT INTO versification_data VALUES (NULL, 2, 19, 98, 9);
INSERT INTO versification_data VALUES (NULL, 2, 19, 99, 9);
INSERT INTO versification_data VALUES (NULL, 2, 19, 100, 5);
INSERT INTO versification_data VALUES (NULL, 2, 19, 101, 8);
INSERT INTO versification_data VALUES (NULL, 2, 19, 102, 29);
INSERT INTO versification_data VALUES (NULL, 2, 19, 103, 22);
INSERT INTO versification_data VALUES (NULL, 2, 19, 104, 35);
INSERT INTO versification_data VALUES (NULL, 2, 19, 105, 45);
INSERT INTO versification_data VALUES (NULL, 2, 19, 106, 48);
INSERT INTO versification_data VALUES (NULL, 2, 19, 107, 43);
INSERT INTO versification_data VALUES (NULL, 2, 19, 108, 14);
INSERT INTO versification_data VALUES (NULL, 2, 19, 109, 31);
INSERT INTO versification_data VALUES (NULL, 2, 19, 110, 7);
INSERT INTO versification_data VALUES (NULL, 2, 19, 111, 10);
INSERT INTO versification_data VALUES (NULL, 2, 19, 112, 10);
INSERT INTO versification_data VALUES (NULL, 2, 19, 113, 9);
INSERT INTO versification_data VALUES (NULL, 2, 19, 114, 8);
INSERT INTO versification_data VALUES (NULL, 2, 19, 115, 18);
INSERT INTO versification_data VALUES (NULL, 2, 19, 116, 19);
INSERT INTO versification_data VALUES (NULL, 2, 19, 117, 2);
INSERT INTO versification_data VALUES (NULL, 2, 19, 118, 29);
INSERT INTO versification_data VALUES (NULL, 2, 19, 119, 176);
INSERT INTO versification_data VALUES (NULL, 2, 19, 120, 7);
INSERT INTO versification_data VALUES (NULL, 2, 19, 121, 8);
INSERT INTO versification_data VALUES (NULL, 2, 19, 122, 9);
INSERT INTO versification_data VALUES (NULL, 2, 19, 123, 4);
INSERT INTO versification_data VALUES (NULL, 2, 19, 124, 8);
INSERT INTO versification_data VALUES (NULL, 2, 19, 125, 5);
INSERT INTO versification_data VALUES (NULL, 2, 19, 126, 6);
INSERT INTO versification_data VALUES (NULL, 2, 19, 127, 5);
INSERT INTO versification_data VALUES (NULL, 2, 19, 128, 6);
INSERT INTO versification_data VALUES (NULL, 2, 19, 129, 8);
INSERT INTO versification_data VALUES (NULL, 2, 19, 130, 8);
INSERT INTO versification_data VALUES (NULL, 2, 19, 131, 3);
INSERT INTO versification_data VALUES (NULL, 2, 19, 132, 18);
INSERT INTO versification_data VALUES (NULL, 2, 19, 133, 3);
INSERT INTO versification_data VALUES (NULL, 2, 19, 134, 3);
INSERT INTO versification_data VALUES (NULL, 2, 19, 135, 21);
INSERT INTO versification_data VALUES (NULL, 2, 19, 136, 26);
INSERT INTO versification_data VALUES (NULL, 2, 19, 137, 9);
INSERT INTO versification_data VALUES (NULL, 2, 19, 138, 8);
INSERT INTO versification_data VALUES (NULL, 2, 19, 139, 24);
INSERT INTO versification_data VALUES (NULL, 2, 19, 140, 14);
INSERT INTO versification_data VALUES (NULL, 2, 19, 141, 10);
INSERT INTO versification_data VALUES (NULL, 2, 19, 142, 8);
INSERT INTO versification_data VALUES (NULL, 2, 19, 143, 12);
INSERT INTO versification_data VALUES (NULL, 2, 19, 144, 15);
INSERT INTO versification_data VALUES (NULL, 2, 19, 145, 21);
INSERT INTO versification_data VALUES (NULL, 2, 19, 146, 10);
INSERT INTO versification_data VALUES (NULL, 2, 19, 147, 20);
INSERT INTO versification_data VALUES (NULL, 2, 19, 148, 14);
INSERT INTO versification_data VALUES (NULL, 2, 19, 149, 9);
INSERT INTO versification_data VALUES (NULL, 2, 19, 150, 6);
INSERT INTO versification_data VALUES (NULL, 2, 20, 1, 33);
INSERT INTO versification_data VALUES (NULL, 2, 20, 2, 22);
INSERT INTO versification_data VALUES (NULL, 2, 20, 3, 35);
INSERT INTO versification_data VALUES (NULL, 2, 20, 4, 27);
INSERT INTO versification_data VALUES (NULL, 2, 20, 5, 23);
INSERT INTO versification_data VALUES (NULL, 2, 20, 6, 35);
INSERT INTO versification_data VALUES (NULL, 2, 20, 7, 27);
INSERT INTO versification_data VALUES (NULL, 2, 20, 8, 36);
INSERT INTO versification_data VALUES (NULL, 2, 20, 9, 18);
INSERT INTO versification_data VALUES (NULL, 2, 20, 10, 32);
INSERT INTO versification_data VALUES (NULL, 2, 20, 11, 31);
INSERT INTO versification_data VALUES (NULL, 2, 20, 12, 28);
INSERT INTO versification_data VALUES (NULL, 2, 20, 13, 25);
INSERT INTO versification_data VALUES (NULL, 2, 20, 14, 35);
INSERT INTO versification_data VALUES (NULL, 2, 20, 15, 33);
INSERT INTO versification_data VALUES (NULL, 2, 20, 16, 33);
INSERT INTO versification_data VALUES (NULL, 2, 20, 17, 28);
INSERT INTO versification_data VALUES (NULL, 2, 20, 18, 24);
INSERT INTO versification_data VALUES (NULL, 2, 20, 19, 29);
INSERT INTO versification_data VALUES (NULL, 2, 20, 20, 30);
INSERT INTO versification_data VALUES (NULL, 2, 20, 21, 31);
INSERT INTO versification_data VALUES (NULL, 2, 20, 22, 29);
INSERT INTO versification_data VALUES (NULL, 2, 20, 23, 35);
INSERT INTO versification_data VALUES (NULL, 2, 20, 24, 34);
INSERT INTO versification_data VALUES (NULL, 2, 20, 25, 28);
INSERT INTO versification_data VALUES (NULL, 2, 20, 26, 28);
INSERT INTO versification_data VALUES (NULL, 2, 20, 27, 27);
INSERT INTO versification_data VALUES (NULL, 2, 20, 28, 28);
INSERT INTO versification_data VALUES (NULL, 2, 20, 29, 27);
INSERT INTO versification_data VALUES (NULL, 2, 20, 30, 33);
INSERT INTO versification_data VALUES (NULL, 2, 20, 31, 31);
INSERT INTO versification_data VALUES (NULL, 2, 21, 1, 18);
INSERT INTO versification_data VALUES (NULL, 2, 21, 2, 26);
INSERT INTO versification_data VALUES (NULL, 2, 21, 3, 22);
INSERT INTO versification_data VALUES (NULL, 2, 21, 4, 17);
INSERT INTO versification_data VALUES (NULL, 2, 21, 5, 19);
INSERT INTO versification_data VALUES (NULL, 2, 21, 6, 12);
INSERT INTO versification_data VALUES (NULL, 2, 21, 7, 29);
INSERT INTO versification_data VALUES (NULL, 2, 21, 8, 17);
INSERT INTO versification_data VALUES (NULL, 2, 21, 9, 18);
INSERT INTO versification_data VALUES (NULL, 2, 21, 10, 20);
INSERT INTO versification_data VALUES (NULL, 2, 21, 11, 10);
INSERT INTO versification_data VALUES (NULL, 2, 21, 12, 14);
INSERT INTO versification_data VALUES (NULL, 2, 22, 1, 17);
INSERT INTO versification_data VALUES (NULL, 2, 22, 2, 17);
INSERT INTO versification_data VALUES (NULL, 2, 22, 3, 11);
INSERT INTO versification_data VALUES (NULL, 2, 22, 4, 16);
INSERT INTO versification_data VALUES (NULL, 2, 22, 5, 16);
INSERT INTO versification_data VALUES (NULL, 2, 22, 6, 13);
INSERT INTO versification_data VALUES (NULL, 2, 22, 7, 13);
INSERT INTO versification_data VALUES (NULL, 2, 22, 8, 14);
INSERT INTO versification_data VALUES (NULL, 2, 23, 1, 31);
INSERT INTO versification_data VALUES (NULL, 2, 23, 2, 22);
INSERT INTO versification_data VALUES (NULL, 2, 23, 3, 26);
INSERT INTO versification_data VALUES (NULL, 2, 23, 4, 6);
INSERT INTO versification_data VALUES (NULL, 2, 23, 5, 30);
INSERT INTO versification_data VALUES (NULL, 2, 23, 6, 13);
INSERT INTO versification_data VALUES (NULL, 2, 23, 7, 25);
INSERT INTO versification_data VALUES (NULL, 2, 23, 8, 23);
INSERT INTO versification_data VALUES (NULL, 2, 23, 9, 20);
INSERT INTO versification_data VALUES (NULL, 2, 23, 10, 34);
INSERT INTO versification_data VALUES (NULL, 2, 23, 11, 16);
INSERT INTO versification_data VALUES (NULL, 2, 23, 12, 6);
INSERT INTO versification_data VALUES (NULL, 2, 23, 13, 22);
INSERT INTO versification_data VALUES (NULL, 2, 23, 14, 32);
INSERT INTO versification_data VALUES (NULL, 2, 23, 15, 9);
INSERT INTO versification_data VALUES (NULL, 2, 23, 16, 14);
INSERT INTO versification_data VALUES (NULL, 2, 23, 17, 14);
INSERT INTO versification_data VALUES (NULL, 2, 23, 18, 7);
INSERT INTO versification_data VALUES (NULL, 2, 23, 19, 25);
INSERT INTO versification_data VALUES (NULL, 2, 23, 20, 6);
INSERT INTO versification_data VALUES (NULL, 2, 23, 21, 17);
INSERT INTO versification_data VALUES (NULL, 2, 23, 22, 25);
INSERT INTO versification_data VALUES (NULL, 2, 23, 23, 18);
INSERT INTO versification_data VALUES (NULL, 2, 23, 24, 23);
INSERT INTO versification_data VALUES (NULL, 2, 23, 25, 12);
INSERT INTO versification_data VALUES (NULL, 2, 23, 26, 21);
INSERT INTO versification_data VALUES (NULL, 2, 23, 27, 13);
INSERT INTO versification_data VALUES (NULL, 2, 23, 28, 29);
INSERT INTO versification_data VALUES (NULL, 2, 23, 29, 24);
INSERT INTO versification_data VALUES (NULL, 2, 23, 30, 33);
INSERT INTO versification_data VALUES (NULL, 2, 23, 31, 9);
INSERT INTO versification_data VALUES (NULL, 2, 23, 32, 20);
INSERT INTO versification_data VALUES (NULL, 2, 23, 33, 24);
INSERT INTO versification_data VALUES (NULL, 2, 23, 34, 17);
INSERT INTO versification_data VALUES (NULL, 2, 23, 35, 10);
INSERT INTO versification_data VALUES (NULL, 2, 23, 36, 22);
INSERT INTO versification_data VALUES (NULL, 2, 23, 37, 38);
INSERT INTO versification_data VALUES (NULL, 2, 23, 38, 22);
INSERT INTO versification_data VALUES (NULL, 2, 23, 39, 8);
INSERT INTO versification_data VALUES (NULL, 2, 23, 40, 31);
INSERT INTO versification_data VALUES (NULL, 2, 23, 41, 29);
INSERT INTO versification_data VALUES (NULL, 2, 23, 42, 25);
INSERT INTO versification_data VALUES (NULL, 2, 23, 43, 28);
INSERT INTO versification_data VALUES (NULL, 2, 23, 44, 28);
INSERT INTO versification_data VALUES (NULL, 2, 23, 45, 25);
INSERT INTO versification_data VALUES (NULL, 2, 23, 46, 13);
INSERT INTO versification_data VALUES (NULL, 2, 23, 47, 15);
INSERT INTO versification_data VALUES (NULL, 2, 23, 48, 22);
INSERT INTO versification_data VALUES (NULL, 2, 23, 49, 26);
INSERT INTO versification_data VALUES (NULL, 2, 23, 50, 11);
INSERT INTO versification_data VALUES (NULL, 2, 23, 51, 23);
INSERT INTO versification_data VALUES (NULL, 2, 23, 52, 15);
INSERT INTO versification_data VALUES (NULL, 2, 23, 53, 12);
INSERT INTO versification_data VALUES (NULL, 2, 23, 54, 17);
INSERT INTO versification_data VALUES (NULL, 2, 23, 55, 13);
INSERT INTO versification_data VALUES (NULL, 2, 23, 56, 12);
INSERT INTO versification_data VALUES (NULL, 2, 23, 57, 21);
INSERT INTO versification_data VALUES (NULL, 2, 23, 58, 14);
INSERT INTO versification_data VALUES (NULL, 2, 23, 59, 21);
INSERT INTO versification_data VALUES (NULL, 2, 23, 60, 22);
INSERT INTO versification_data VALUES (NULL, 2, 23, 61, 11);
INSERT INTO versification_data VALUES (NULL, 2, 23, 62, 12);
INSERT INTO versification_data VALUES (NULL, 2, 23, 63, 19);
INSERT INTO versification_data VALUES (NULL, 2, 23, 64, 12);
INSERT INTO versification_data VALUES (NULL, 2, 23, 65, 25);
INSERT INTO versification_data VALUES (NULL, 2, 23, 66, 24);
INSERT INTO versification_data VALUES (NULL, 2, 24, 1, 19);
INSERT INTO versification_data VALUES (NULL, 2, 24, 2, 37);
INSERT INTO versification_data VALUES (NULL, 2, 24, 3, 25);
INSERT INTO versification_data VALUES (NULL, 2, 24, 4, 31);
INSERT INTO versification_data VALUES (NULL, 2, 24, 5, 31);
INSERT INTO versification_data VALUES (NULL, 2, 24, 6, 30);
INSERT INTO versification_data VALUES (NULL, 2, 24, 7, 34);
INSERT INTO versification_data VALUES (NULL, 2, 24, 8, 22);
INSERT INTO versification_data VALUES (NULL, 2, 24, 9, 26);
INSERT INTO versification_data VALUES (NULL, 2, 24, 10, 25);
INSERT INTO versification_data VALUES (NULL, 2, 24, 11, 23);
INSERT INTO versification_data VALUES (NULL, 2, 24, 12, 17);
INSERT INTO versification_data VALUES (NULL, 2, 24, 13, 27);
INSERT INTO versification_data VALUES (NULL, 2, 24, 14, 22);
INSERT INTO versification_data VALUES (NULL, 2, 24, 15, 21);
INSERT INTO versification_data VALUES (NULL, 2, 24, 16, 21);
INSERT INTO versification_data VALUES (NULL, 2, 24, 17, 27);
INSERT INTO versification_data VALUES (NULL, 2, 24, 18, 23);
INSERT INTO versification_data VALUES (NULL, 2, 24, 19, 15);
INSERT INTO versification_data VALUES (NULL, 2, 24, 20, 18);
INSERT INTO versification_data VALUES (NULL, 2, 24, 21, 14);
INSERT INTO versification_data VALUES (NULL, 2, 24, 22, 30);
INSERT INTO versification_data VALUES (NULL, 2, 24, 23, 40);
INSERT INTO versification_data VALUES (NULL, 2, 24, 24, 10);
INSERT INTO versification_data VALUES (NULL, 2, 24, 25, 38);
INSERT INTO versification_data VALUES (NULL, 2, 24, 26, 24);
INSERT INTO versification_data VALUES (NULL, 2, 24, 27, 22);
INSERT INTO versification_data VALUES (NULL, 2, 24, 28, 17);
INSERT INTO versification_data VALUES (NULL, 2, 24, 29, 32);
INSERT INTO versification_data VALUES (NULL, 2, 24, 30, 24);
INSERT INTO versification_data VALUES (NULL, 2, 24, 31, 40);
INSERT INTO versification_data VALUES (NULL, 2, 24, 32, 44);
INSERT INTO versification_data VALUES (NULL, 2, 24, 33, 26);
INSERT INTO versification_data VALUES (NULL, 2, 24, 34, 22);
INSERT INTO versification_data VALUES (NULL, 2, 24, 35, 19);
INSERT INTO versification_data VALUES (NULL, 2, 24, 36, 32);
INSERT INTO versification_data VALUES (NULL, 2, 24, 37, 21);
INSERT INTO versification_data VALUES (NULL, 2, 24, 38, 28);
INSERT INTO versification_data VALUES (NULL, 2, 24, 39, 18);
INSERT INTO versification_data VALUES (NULL, 2, 24, 40, 16);
INSERT INTO versification_data VALUES (NULL, 2, 24, 41, 18);
INSERT INTO versification_data VALUES (NULL, 2, 24, 42, 22);
INSERT INTO versification_data VALUES (NULL, 2, 24, 43, 13);
INSERT INTO versification_data VALUES (NULL, 2, 24, 44, 30);
INSERT INTO versification_data VALUES (NULL, 2, 24, 45, 5);
INSERT INTO versification_data VALUES (NULL, 2, 24, 46, 28);
INSERT INTO versification_data VALUES (NULL, 2, 24, 47, 7);
INSERT INTO versification_data VALUES (NULL, 2, 24, 48, 47);
INSERT INTO versification_data VALUES (NULL, 2, 24, 49, 39);
INSERT INTO versification_data VALUES (NULL, 2, 24, 50, 46);
INSERT INTO versification_data VALUES (NULL, 2, 24, 51, 64);
INSERT INTO versification_data VALUES (NULL, 2, 24, 52, 34);
INSERT INTO versification_data VALUES (NULL, 2, 25, 1, 22);
INSERT INTO versification_data VALUES (NULL, 2, 25, 2, 22);
INSERT INTO versification_data VALUES (NULL, 2, 25, 3, 66);
INSERT INTO versification_data VALUES (NULL, 2, 25, 4, 22);
INSERT INTO versification_data VALUES (NULL, 2, 25, 5, 22);
INSERT INTO versification_data VALUES (NULL, 2, 26, 1, 28);
INSERT INTO versification_data VALUES (NULL, 2, 26, 2, 10);
INSERT INTO versification_data VALUES (NULL, 2, 26, 3, 27);
INSERT INTO versification_data VALUES (NULL, 2, 26, 4, 17);
INSERT INTO versification_data VALUES (NULL, 2, 26, 5, 17);
INSERT INTO versification_data VALUES (NULL, 2, 26, 6, 14);
INSERT INTO versification_data VALUES (NULL, 2, 26, 7, 27);
INSERT INTO versification_data VALUES (NULL, 2, 26, 8, 18);
INSERT INTO versification_data VALUES (NULL, 2, 26, 9, 11);
INSERT INTO versification_data VALUES (NULL, 2, 26, 10, 22);
INSERT INTO versification_data VALUES (NULL, 2, 26, 11, 25);
INSERT INTO versification_data VALUES (NULL, 2, 26, 12, 28);
INSERT INTO versification_data VALUES (NULL, 2, 26, 13, 23);
INSERT INTO versification_data VALUES (NULL, 2, 26, 14, 23);
INSERT INTO versification_data VALUES (NULL, 2, 26, 15, 8);
INSERT INTO versification_data VALUES (NULL, 2, 26, 16, 63);
INSERT INTO versification_data VALUES (NULL, 2, 26, 17, 24);
INSERT INTO versification_data VALUES (NULL, 2, 26, 18, 32);
INSERT INTO versification_data VALUES (NULL, 2, 26, 19, 14);
INSERT INTO versification_data VALUES (NULL, 2, 26, 20, 49);
INSERT INTO versification_data VALUES (NULL, 2, 26, 21, 32);
INSERT INTO versification_data VALUES (NULL, 2, 26, 22, 31);
INSERT INTO versification_data VALUES (NULL, 2, 26, 23, 49);
INSERT INTO versification_data VALUES (NULL, 2, 26, 24, 27);
INSERT INTO versification_data VALUES (NULL, 2, 26, 25, 17);
INSERT INTO versification_data VALUES (NULL, 2, 26, 26, 21);
INSERT INTO versification_data VALUES (NULL, 2, 26, 27, 36);
INSERT INTO versification_data VALUES (NULL, 2, 26, 28, 26);
INSERT INTO versification_data VALUES (NULL, 2, 26, 29, 21);
INSERT INTO versification_data VALUES (NULL, 2, 26, 30, 26);
INSERT INTO versification_data VALUES (NULL, 2, 26, 31, 18);
INSERT INTO versification_data VALUES (NULL, 2, 26, 32, 32);
INSERT INTO versification_data VALUES (NULL, 2, 26, 33, 33);
INSERT INTO versification_data VALUES (NULL, 2, 26, 34, 31);
INSERT INTO versification_data VALUES (NULL, 2, 26, 35, 15);
INSERT INTO versification_data VALUES (NULL, 2, 26, 36, 38);
INSERT INTO versification_data VALUES (NULL, 2, 26, 37, 28);
INSERT INTO versification_data VALUES (NULL, 2, 26, 38, 23);
INSERT INTO versification_data VALUES (NULL, 2, 26, 39, 29);
INSERT INTO versification_data VALUES (NULL, 2, 26, 40, 49);
INSERT INTO versification_data VALUES (NULL, 2, 26, 41, 26);
INSERT INTO versification_data VALUES (NULL, 2, 26, 42, 20);
INSERT INTO versification_data VALUES (NULL, 2, 26, 43, 27);
INSERT INTO versification_data VALUES (NULL, 2, 26, 44, 31);
INSERT INTO versification_data VALUES (NULL, 2, 26, 45, 25);
INSERT INTO versification_data VALUES (NULL, 2, 26, 46, 24);
INSERT INTO versification_data VALUES (NULL, 2, 26, 47, 23);
INSERT INTO versification_data VALUES (NULL, 2, 26, 48, 35);
INSERT INTO versification_data VALUES (NULL, 2, 27, 1, 21);
INSERT INTO versification_data VALUES (NULL, 2, 27, 2, 49);
INSERT INTO versification_data VALUES (NULL, 2, 27, 3, 30);
INSERT INTO versification_data VALUES (NULL, 2, 27, 4, 37);
INSERT INTO versification_data VALUES (NULL, 2, 27, 5, 30);
INSERT INTO versification_data VALUES (NULL, 2, 27, 6, 29);
INSERT INTO versification_data VALUES (NULL, 2, 27, 7, 28);
INSERT INTO versification_data VALUES (NULL, 2, 27, 8, 27);
INSERT INTO versification_data VALUES (NULL, 2, 27, 9, 27);
INSERT INTO versification_data VALUES (NULL, 2, 27, 10, 21);
INSERT INTO versification_data VALUES (NULL, 2, 27, 11, 45);
INSERT INTO versification_data VALUES (NULL, 2, 27, 12, 13);
INSERT INTO versification_data VALUES (NULL, 2, 28, 1, 12);
INSERT INTO versification_data VALUES (NULL, 2, 28, 2, 22);
INSERT INTO versification_data VALUES (NULL, 2, 28, 3, 5);
INSERT INTO versification_data VALUES (NULL, 2, 28, 4, 19);
INSERT INTO versification_data VALUES (NULL, 2, 28, 5, 15);
INSERT INTO versification_data VALUES (NULL, 2, 28, 6, 11);
INSERT INTO versification_data VALUES (NULL, 2, 28, 7, 16);
INSERT INTO versification_data VALUES (NULL, 2, 28, 8, 14);
INSERT INTO versification_data VALUES (NULL, 2, 28, 9, 17);
INSERT INTO versification_data VALUES (NULL, 2, 28, 10, 15);
INSERT INTO versification_data VALUES (NULL, 2, 28, 11, 11);
INSERT INTO versification_data VALUES (NULL, 2, 28, 12, 15);
INSERT INTO versification_data VALUES (NULL, 2, 28, 13, 15);
INSERT INTO versification_data VALUES (NULL, 2, 28, 14, 10);
INSERT INTO versification_data VALUES (NULL, 2, 29, 1, 20);
INSERT INTO versification_data VALUES (NULL, 2, 29, 2, 32);
INSERT INTO versification_data VALUES (NULL, 2, 29, 3, 21);
INSERT INTO versification_data VALUES (NULL, 2, 30, 1, 15);
INSERT INTO versification_data VALUES (NULL, 2, 30, 2, 16);
INSERT INTO versification_data VALUES (NULL, 2, 30, 3, 15);
INSERT INTO versification_data VALUES (NULL, 2, 30, 4, 13);
INSERT INTO versification_data VALUES (NULL, 2, 30, 5, 27);
INSERT INTO versification_data VALUES (NULL, 2, 30, 6, 14);
INSERT INTO versification_data VALUES (NULL, 2, 30, 7, 17);
INSERT INTO versification_data VALUES (NULL, 2, 30, 8, 14);
INSERT INTO versification_data VALUES (NULL, 2, 30, 9, 15);
INSERT INTO versification_data VALUES (NULL, 2, 31, 1, 21);
INSERT INTO versification_data VALUES (NULL, 2, 32, 1, 17);
INSERT INTO versification_data VALUES (NULL, 2, 32, 2, 10);
INSERT INTO versification_data VALUES (NULL, 2, 32, 3, 10);
INSERT INTO versification_data VALUES (NULL, 2, 32, 4, 11);
INSERT INTO versification_data VALUES (NULL, 2, 33, 1, 16);
INSERT INTO versification_data VALUES (NULL, 2, 33, 2, 13);
INSERT INTO versification_data VALUES (NULL, 2, 33, 3, 12);
INSERT INTO versification_data VALUES (NULL, 2, 33, 4, 14);
INSERT INTO versification_data VALUES (NULL, 2, 33, 5, 14);
INSERT INTO versification_data VALUES (NULL, 2, 33, 6, 16);
INSERT INTO versification_data VALUES (NULL, 2, 33, 7, 20);
INSERT INTO versification_data VALUES (NULL, 2, 34, 1, 15);
INSERT INTO versification_data VALUES (NULL, 2, 34, 2, 13);
INSERT INTO versification_data VALUES (NULL, 2, 34, 3, 19);
INSERT INTO versification_data VALUES (NULL, 2, 35, 1, 17);
INSERT INTO versification_data VALUES (NULL, 2, 35, 2, 20);
INSERT INTO versification_data VALUES (NULL, 2, 35, 3, 19);
INSERT INTO versification_data VALUES (NULL, 2, 36, 1, 18);
INSERT INTO versification_data VALUES (NULL, 2, 36, 2, 15);
INSERT INTO versification_data VALUES (NULL, 2, 36, 3, 20);
INSERT INTO versification_data VALUES (NULL, 2, 37, 1, 14);
INSERT INTO versification_data VALUES (NULL, 2, 37, 2, 24);
INSERT INTO versification_data VALUES (NULL, 2, 38, 1, 21);
INSERT INTO versification_data VALUES (NULL, 2, 38, 2, 13);
INSERT INTO versification_data VALUES (NULL, 2, 38, 3, 10);
INSERT INTO versification_data VALUES (NULL, 2, 38, 4, 14);
INSERT INTO versification_data VALUES (NULL, 2, 38, 5, 11);
INSERT INTO versification_data VALUES (NULL, 2, 38, 6, 15);
INSERT INTO versification_data VALUES (NULL, 2, 38, 7, 14);
INSERT INTO versification_data VALUES (NULL, 2, 38, 8, 23);
INSERT INTO versification_data VALUES (NULL, 2, 38, 9, 17);
INSERT INTO versification_data VALUES (NULL, 2, 38, 10, 12);
INSERT INTO versification_data VALUES (NULL, 2, 38, 11, 17);
INSERT INTO versification_data VALUES (NULL, 2, 38, 12, 14);
INSERT INTO versification_data VALUES (NULL, 2, 38, 13, 9);
INSERT INTO versification_data VALUES (NULL, 2, 38, 14, 21);
INSERT INTO versification_data VALUES (NULL, 2, 39, 1, 14);
INSERT INTO versification_data VALUES (NULL, 2, 39, 2, 17);
INSERT INTO versification_data VALUES (NULL, 2, 39, 3, 18);
INSERT INTO versification_data VALUES (NULL, 2, 39, 4, 6);
INSERT INTO versification_data VALUES (NULL, 2, 40, 1, 25);
INSERT INTO versification_data VALUES (NULL, 2, 40, 2, 23);
INSERT INTO versification_data VALUES (NULL, 2, 40, 3, 17);
INSERT INTO versification_data VALUES (NULL, 2, 40, 4, 25);
INSERT INTO versification_data VALUES (NULL, 2, 40, 5, 48);
INSERT INTO versification_data VALUES (NULL, 2, 40, 6, 34);
INSERT INTO versification_data VALUES (NULL, 2, 40, 7, 29);
INSERT INTO versification_data VALUES (NULL, 2, 40, 8, 34);
INSERT INTO versification_data VALUES (NULL, 2, 40, 9, 38);
INSERT INTO versification_data VALUES (NULL, 2, 40, 10, 42);
INSERT INTO versification_data VALUES (NULL, 2, 40, 11, 30);
INSERT INTO versification_data VALUES (NULL, 2, 40, 12, 50);
INSERT INTO versification_data VALUES (NULL, 2, 40, 13, 58);
INSERT INTO versification_data VALUES (NULL, 2, 40, 14, 36);
INSERT INTO versification_data VALUES (NULL, 2, 40, 15, 39);
INSERT INTO versification_data VALUES (NULL, 2, 40, 16, 28);
INSERT INTO versification_data VALUES (NULL, 2, 40, 17, 27);
INSERT INTO versification_data VALUES (NULL, 2, 40, 18, 35);
INSERT INTO versification_data VALUES (NULL, 2, 40, 19, 30);
INSERT INTO versification_data VALUES (NULL, 2, 40, 20, 34);
INSERT INTO versification_data VALUES (NULL, 2, 40, 21, 46);
INSERT INTO versification_data VALUES (NULL, 2, 40, 22, 46);
INSERT INTO versification_data VALUES (NULL, 2, 40, 23, 39);
INSERT INTO versification_data VALUES (NULL, 2, 40, 24, 51);
INSERT INTO versification_data VALUES (NULL, 2, 40, 25, 46);
INSERT INTO versification_data VALUES (NULL, 2, 40, 26, 75);
INSERT INTO versification_data VALUES (NULL, 2, 40, 27, 66);
INSERT INTO versification_data VALUES (NULL, 2, 40, 28, 20);
INSERT INTO versification_data VALUES (NULL, 2, 41, 1, 45);
INSERT INTO versification_data VALUES (NULL, 2, 41, 2, 28);
INSERT INTO versification_data VALUES (NULL, 2, 41, 3, 35);
INSERT INTO versification_data VALUES (NULL, 2, 41, 4, 41);
INSERT INTO versification_data VALUES (NULL, 2, 41, 5, 43);
INSERT INTO versification_data VALUES (NULL, 2, 41, 6, 56);
INSERT INTO versification_data VALUES (NULL, 2, 41, 7, 37);
INSERT INTO versification_data VALUES (NULL, 2, 41, 8, 38);
INSERT INTO versification_data VALUES (NULL, 2, 41, 9, 50);
INSERT INTO versification_data VALUES (NULL, 2, 41, 10, 52);
INSERT INTO versification_data VALUES (NULL, 2, 41, 11, 33);
INSERT INTO versification_data VALUES (NULL, 2, 41, 12, 44);
INSERT INTO versification_data VALUES (NULL, 2, 41, 13, 37);
INSERT INTO versification_data VALUES (NULL, 2, 41, 14, 72);
INSERT INTO versification_data VALUES (NULL, 2, 41, 15, 47);
INSERT INTO versification_data VALUES (NULL, 2, 41, 16, 20);
INSERT INTO versification_data VALUES (NULL, 2, 42, 1, 80);
INSERT INTO versification_data VALUES (NULL, 2, 42, 2, 52);
INSERT INTO versification_data VALUES (NULL, 2, 42, 3, 38);
INSERT INTO versification_data VALUES (NULL, 2, 42, 4, 44);
INSERT INTO versification_data VALUES (NULL, 2, 42, 5, 39);
INSERT INTO versification_data VALUES (NULL, 2, 42, 6, 49);
INSERT INTO versification_data VALUES (NULL, 2, 42, 7, 50);
INSERT INTO versification_data VALUES (NULL, 2, 42, 8, 56);
INSERT INTO versification_data VALUES (NULL, 2, 42, 9, 62);
INSERT INTO versification_data VALUES (NULL, 2, 42, 10, 42);
INSERT INTO versification_data VALUES (NULL, 2, 42, 11, 54);
INSERT INTO versification_data VALUES (NULL, 2, 42, 12, 59);
INSERT INTO versification_data VALUES (NULL, 2, 42, 13, 35);
INSERT INTO versification_data VALUES (NULL, 2, 42, 14, 35);
INSERT INTO versification_data VALUES (NULL, 2, 42, 15, 32);
INSERT INTO versification_data VALUES (NULL, 2, 42, 16, 31);
INSERT INTO versification_data VALUES (NULL, 2, 42, 17, 37);
INSERT INTO versification_data VALUES (NULL, 2, 42, 18, 43);
INSERT INTO versification_data VALUES (NULL, 2, 42, 19, 48);
INSERT INTO versification_data VALUES (NULL, 2, 42, 20, 47);
INSERT INTO versification_data VALUES (NULL, 2, 42, 21, 38);
INSERT INTO versification_data VALUES (NULL, 2, 42, 22, 71);
INSERT INTO versification_data VALUES (NULL, 2, 42, 23, 56);
INSERT INTO versification_data VALUES (NULL, 2, 42, 24, 53);
INSERT INTO versification_data VALUES (NULL, 2, 43, 1, 52);
INSERT INTO versification_data VALUES (NULL, 2, 43, 2, 25);
INSERT INTO versification_data VALUES (NULL, 2, 43, 3, 36);
INSERT INTO versification_data VALUES (NULL, 2, 43, 4, 54);
INSERT INTO versification_data VALUES (NULL, 2, 43, 5, 47);
INSERT INTO versification_data VALUES (NULL, 2, 43, 6, 71);
INSERT INTO versification_data VALUES (NULL, 2, 43, 7, 53);
INSERT INTO versification_data VALUES (NULL, 2, 43, 8, 59);
INSERT INTO versification_data VALUES (NULL, 2, 43, 9, 41);
INSERT INTO versification_data VALUES (NULL, 2, 43, 10, 42);
INSERT INTO versification_data VALUES (NULL, 2, 43, 11, 57);
INSERT INTO versification_data VALUES (NULL, 2, 43, 12, 50);
INSERT INTO versification_data VALUES (NULL, 2, 43, 13, 38);
INSERT INTO versification_data VALUES (NULL, 2, 43, 14, 31);
INSERT INTO versification_data VALUES (NULL, 2, 43, 15, 27);
INSERT INTO versification_data VALUES (NULL, 2, 43, 16, 33);
INSERT INTO versification_data VALUES (NULL, 2, 43, 17, 26);
INSERT INTO versification_data VALUES (NULL, 2, 43, 18, 40);
INSERT INTO versification_data VALUES (NULL, 2, 43, 19, 42);
INSERT INTO versification_data VALUES (NULL, 2, 43, 20, 31);
INSERT INTO versification_data VALUES (NULL, 2, 43, 21, 25);
INSERT INTO versification_data VALUES (NULL, 2, 44, 1, 26);
INSERT INTO versification_data VALUES (NULL, 2, 44, 2, 47);
INSERT INTO versification_data VALUES (NULL, 2, 44, 3, 26);
INSERT INTO versification_data VALUES (NULL, 2, 44, 4, 37);
INSERT INTO versification_data VALUES (NULL, 2, 44, 5, 42);
INSERT INTO versification_data VALUES (NULL, 2, 44, 6, 15);
INSERT INTO versification_data VALUES (NULL, 2, 44, 7, 60);
INSERT INTO versification_data VALUES (NULL, 2, 44, 8, 40);
INSERT INTO versification_data VALUES (NULL, 2, 44, 9, 43);
INSERT INTO versification_data VALUES (NULL, 2, 44, 10, 48);
INSERT INTO versification_data VALUES (NULL, 2, 44, 11, 30);
INSERT INTO versification_data VALUES (NULL, 2, 44, 12, 25);
INSERT INTO versification_data VALUES (NULL, 2, 44, 13, 52);
INSERT INTO versification_data VALUES (NULL, 2, 44, 14, 28);
INSERT INTO versification_data VALUES (NULL, 2, 44, 15, 41);
INSERT INTO versification_data VALUES (NULL, 2, 44, 16, 40);
INSERT INTO versification_data VALUES (NULL, 2, 44, 17, 34);
INSERT INTO versification_data VALUES (NULL, 2, 44, 18, 28);
INSERT INTO versification_data VALUES (NULL, 2, 44, 19, 40);
INSERT INTO versification_data VALUES (NULL, 2, 44, 20, 38);
INSERT INTO versification_data VALUES (NULL, 2, 44, 21, 40);
INSERT INTO versification_data VALUES (NULL, 2, 44, 22, 30);
INSERT INTO versification_data VALUES (NULL, 2, 44, 23, 35);
INSERT INTO versification_data VALUES (NULL, 2, 44, 24, 27);
INSERT INTO versification_data VALUES (NULL, 2, 44, 25, 27);
INSERT INTO versification_data VALUES (NULL, 2, 44, 26, 32);
INSERT INTO versification_data VALUES (NULL, 2, 44, 27, 44);
INSERT INTO versification_data VALUES (NULL, 2, 44, 28, 31);
INSERT INTO versification_data VALUES (NULL, 2, 45, 1, 32);
INSERT INTO versification_data VALUES (NULL, 2, 45, 2, 29);
INSERT INTO versification_data VALUES (NULL, 2, 45, 3, 31);
INSERT INTO versification_data VALUES (NULL, 2, 45, 4, 25);
INSERT INTO versification_data VALUES (NULL, 2, 45, 5, 21);
INSERT INTO versification_data VALUES (NULL, 2, 45, 6, 23);
INSERT INTO versification_data VALUES (NULL, 2, 45, 7, 26);
INSERT INTO versification_data VALUES (NULL, 2, 45, 8, 39);
INSERT INTO versification_data VALUES (NULL, 2, 45, 9, 33);
INSERT INTO versification_data VALUES (NULL, 2, 45, 10, 21);
INSERT INTO versification_data VALUES (NULL, 2, 45, 11, 36);
INSERT INTO versification_data VALUES (NULL, 2, 45, 12, 21);
INSERT INTO versification_data VALUES (NULL, 2, 45, 13, 14);
INSERT INTO versification_data VALUES (NULL, 2, 45, 14, 23);
INSERT INTO versification_data VALUES (NULL, 2, 45, 15, 33);
INSERT INTO versification_data VALUES (NULL, 2, 45, 16, 27);
INSERT INTO versification_data VALUES (NULL, 2, 46, 1, 31);
INSERT INTO versification_data VALUES (NULL, 2, 46, 2, 16);
INSERT INTO versification_data VALUES (NULL, 2, 46, 3, 23);
INSERT INTO versification_data VALUES (NULL, 2, 46, 4, 21);
INSERT INTO versification_data VALUES (NULL, 2, 46, 5, 13);
INSERT INTO versification_data VALUES (NULL, 2, 46, 6, 20);
INSERT INTO versification_data VALUES (NULL, 2, 46, 7, 40);
INSERT INTO versification_data VALUES (NULL, 2, 46, 8, 13);
INSERT INTO versification_data VALUES (NULL, 2, 46, 9, 27);
INSERT INTO versification_data VALUES (NULL, 2, 46, 10, 33);
INSERT INTO versification_data VALUES (NULL, 2, 46, 11, 34);
INSERT INTO versification_data VALUES (NULL, 2, 46, 12, 31);
INSERT INTO versification_data VALUES (NULL, 2, 46, 13, 13);
INSERT INTO versification_data VALUES (NULL, 2, 46, 14, 40);
INSERT INTO versification_data VALUES (NULL, 2, 46, 15, 58);
INSERT INTO versification_data VALUES (NULL, 2, 46, 16, 24);
INSERT INTO versification_data VALUES (NULL, 2, 47, 1, 24);
INSERT INTO versification_data VALUES (NULL, 2, 47, 2, 17);
INSERT INTO versification_data VALUES (NULL, 2, 47, 3, 18);
INSERT INTO versification_data VALUES (NULL, 2, 47, 4, 18);
INSERT INTO versification_data VALUES (NULL, 2, 47, 5, 21);
INSERT INTO versification_data VALUES (NULL, 2, 47, 6, 18);
INSERT INTO versification_data VALUES (NULL, 2, 47, 7, 16);
INSERT INTO versification_data VALUES (NULL, 2, 47, 8, 24);
INSERT INTO versification_data VALUES (NULL, 2, 47, 9, 15);
INSERT INTO versification_data VALUES (NULL, 2, 47, 10, 18);
INSERT INTO versification_data VALUES (NULL, 2, 47, 11, 33);
INSERT INTO versification_data VALUES (NULL, 2, 47, 12, 21);
INSERT INTO versification_data VALUES (NULL, 2, 47, 13, 13);
INSERT INTO versification_data VALUES (NULL, 2, 48, 1, 24);
INSERT INTO versification_data VALUES (NULL, 2, 48, 2, 21);
INSERT INTO versification_data VALUES (NULL, 2, 48, 3, 29);
INSERT INTO versification_data VALUES (NULL, 2, 48, 4, 31);
INSERT INTO versification_data VALUES (NULL, 2, 48, 5, 26);
INSERT INTO versification_data VALUES (NULL, 2, 48, 6, 18);
INSERT INTO versification_data VALUES (NULL, 2, 49, 1, 23);
INSERT INTO versification_data VALUES (NULL, 2, 49, 2, 22);
INSERT INTO versification_data VALUES (NULL, 2, 49, 3, 21);
INSERT INTO versification_data VALUES (NULL, 2, 49, 4, 32);
INSERT INTO versification_data VALUES (NULL, 2, 49, 5, 33);
INSERT INTO versification_data VALUES (NULL, 2, 49, 6, 24);
INSERT INTO versification_data VALUES (NULL, 2, 50, 1, 30);
INSERT INTO versification_data VALUES (NULL, 2, 50, 2, 30);
INSERT INTO versification_data VALUES (NULL, 2, 50, 3, 21);
INSERT INTO versification_data VALUES (NULL, 2, 50, 4, 23);
INSERT INTO versification_data VALUES (NULL, 2, 51, 1, 29);
INSERT INTO versification_data VALUES (NULL, 2, 51, 2, 23);
INSERT INTO versification_data VALUES (NULL, 2, 51, 3, 25);
INSERT INTO versification_data VALUES (NULL, 2, 51, 4, 18);
INSERT INTO versification_data VALUES (NULL, 2, 52, 1, 10);
INSERT INTO versification_data VALUES (NULL, 2, 52, 2, 20);
INSERT INTO versification_data VALUES (NULL, 2, 52, 3, 13);
INSERT INTO versification_data VALUES (NULL, 2, 52, 4, 18);
INSERT INTO versification_data VALUES (NULL, 2, 52, 5, 28);
INSERT INTO versification_data VALUES (NULL, 2, 53, 1, 12);
INSERT INTO versification_data VALUES (NULL, 2, 53, 2, 17);
INSERT INTO versification_data VALUES (NULL, 2, 53, 3, 18);
INSERT INTO versification_data VALUES (NULL, 2, 54, 1, 20);
INSERT INTO versification_data VALUES (NULL, 2, 54, 2, 15);
INSERT INTO versification_data VALUES (NULL, 2, 54, 3, 16);
INSERT INTO versification_data VALUES (NULL, 2, 54, 4, 16);
INSERT INTO versification_data VALUES (NULL, 2, 54, 5, 25);
INSERT INTO versification_data VALUES (NULL, 2, 54, 6, 21);
INSERT INTO versification_data VALUES (NULL, 2, 55, 1, 18);
INSERT INTO versification_data VALUES (NULL, 2, 55, 2, 26);
INSERT INTO versification_data VALUES (NULL, 2, 55, 3, 17);
INSERT INTO versification_data VALUES (NULL, 2, 55, 4, 22);
INSERT INTO versification_data VALUES (NULL, 2, 56, 1, 16);
INSERT INTO versification_data VALUES (NULL, 2, 56, 2, 15);
INSERT INTO versification_data VALUES (NULL, 2, 56, 3, 15);
INSERT INTO versification_data VALUES (NULL, 2, 57, 1, 25);
INSERT INTO versification_data VALUES (NULL, 2, 58, 1, 14);
INSERT INTO versification_data VALUES (NULL, 2, 58, 2, 18);
INSERT INTO versification_data VALUES (NULL, 2, 58, 3, 19);
INSERT INTO versification_data VALUES (NULL, 2, 58, 4, 16);
INSERT INTO versification_data VALUES (NULL, 2, 58, 5, 14);
INSERT INTO versification_data VALUES (NULL, 2, 58, 6, 20);
INSERT INTO versification_data VALUES (NULL, 2, 58, 7, 28);
INSERT INTO versification_data VALUES (NULL, 2, 58, 8, 13);
INSERT INTO versification_data VALUES (NULL, 2, 58, 9, 28);
INSERT INTO versification_data VALUES (NULL, 2, 58, 10, 39);
INSERT INTO versification_data VALUES (NULL, 2, 58, 11, 40);
INSERT INTO versification_data VALUES (NULL, 2, 58, 12, 29);
INSERT INTO versification_data VALUES (NULL, 2, 58, 13, 25);
INSERT INTO versification_data VALUES (NULL, 2, 59, 1, 27);
INSERT INTO versification_data VALUES (NULL, 2, 59, 2, 26);
INSERT INTO versification_data VALUES (NULL, 2, 59, 3, 18);
INSERT INTO versification_data VALUES (NULL, 2, 59, 4, 17);
INSERT INTO versification_data VALUES (NULL, 2, 59, 5, 20);
INSERT INTO versification_data VALUES (NULL, 2, 60, 1, 25);
INSERT INTO versification_data VALUES (NULL, 2, 60, 2, 25);
INSERT INTO versification_data VALUES (NULL, 2, 60, 3, 22);
INSERT INTO versification_data VALUES (NULL, 2, 60, 4, 19);
INSERT INTO versification_data VALUES (NULL, 2, 60, 5, 14);
INSERT INTO versification_data VALUES (NULL, 2, 61, 1, 21);
INSERT INTO versification_data VALUES (NULL, 2, 61, 2, 22);
INSERT INTO versification_data VALUES (NULL, 2, 61, 3, 18);
INSERT INTO versification_data VALUES (NULL, 2, 62, 1, 10);
INSERT INTO versification_data VALUES (NULL, 2, 62, 2, 29);
INSERT INTO versification_data VALUES (NULL, 2, 62, 3, 24);
INSERT INTO versification_data VALUES (NULL, 2, 62, 4, 21);
INSERT INTO versification_data VALUES (NULL, 2, 62, 5, 21);
INSERT INTO versification_data VALUES (NULL, 2, 63, 1, 13);
INSERT INTO versification_data VALUES (NULL, 2, 64, 1, 15);
INSERT INTO versification_data VALUES (NULL, 2, 65, 1, 25);
INSERT INTO versification_data VALUES (NULL, 2, 66, 1, 20);
INSERT INTO versification_data VALUES (NULL, 2, 66, 2, 29);
INSERT INTO versification_data VALUES (NULL, 2, 66, 3, 22);
INSERT INTO versification_data VALUES (NULL, 2, 66, 4, 11);
INSERT INTO versification_data VALUES (NULL, 2, 66, 5, 14);
INSERT INTO versification_data VALUES (NULL, 2, 66, 6, 17);
INSERT INTO versification_data VALUES (NULL, 2, 66, 7, 17);
INSERT INTO versification_data VALUES (NULL, 2, 66, 8, 13);
INSERT INTO versification_data VALUES (NULL, 2, 66, 9, 21);
INSERT INTO versification_data VALUES (NULL, 2, 66, 10, 11);
INSERT INTO versification_data VALUES (NULL, 2, 66, 11, 19);
INSERT INTO versification_data VALUES (NULL, 2, 66, 12, 18);
INSERT INTO versification_data VALUES (NULL, 2, 66, 13, 18);
INSERT INTO versification_data VALUES (NULL, 2, 66, 14, 20);
INSERT INTO versification_data VALUES (NULL, 2, 66, 15, 8);
INSERT INTO versification_data VALUES (NULL, 2, 66, 16, 21);
INSERT INTO versification_data VALUES (NULL, 2, 66, 17, 18);
INSERT INTO versification_data VALUES (NULL, 2, 66, 18, 24);
INSERT INTO versification_data VALUES (NULL, 2, 66, 19, 21);
INSERT INTO versification_data VALUES (NULL, 2, 66, 20, 15);
INSERT INTO versification_data VALUES (NULL, 2, 66, 21, 27);
INSERT INTO versification_data VALUES (NULL, 2, 66, 22, 21);

INSERT INTO versification_names VALUES (3, 'Vulgate');

INSERT INTO versification_data VALUES (NULL, 3, 1, 1, 31);
INSERT INTO versification_data VALUES (NULL, 3, 1, 2, 25);
INSERT INTO versification_data VALUES (NULL, 3, 1, 3, 24);
INSERT INTO versification_data VALUES (NULL, 3, 1, 4, 26);
INSERT INTO versification_data VALUES (NULL, 3, 1, 5, 32);
INSERT INTO versification_data VALUES (NULL, 3, 1, 6, 22);
INSERT INTO versification_data VALUES (NULL, 3, 1, 7, 24);
INSERT INTO versification_data VALUES (NULL, 3, 1, 8, 22);
INSERT INTO versification_data VALUES (NULL, 3, 1, 9, 29);
INSERT INTO versification_data VALUES (NULL, 3, 1, 10, 32);
INSERT INTO versification_data VALUES (NULL, 3, 1, 11, 32);
INSERT INTO versification_data VALUES (NULL, 3, 1, 12, 20);
INSERT INTO versification_data VALUES (NULL, 3, 1, 13, 18);
INSERT INTO versification_data VALUES (NULL, 3, 1, 14, 24);
INSERT INTO versification_data VALUES (NULL, 3, 1, 15, 21);
INSERT INTO versification_data VALUES (NULL, 3, 1, 16, 16);
INSERT INTO versification_data VALUES (NULL, 3, 1, 17, 27);
INSERT INTO versification_data VALUES (NULL, 3, 1, 18, 33);
INSERT INTO versification_data VALUES (NULL, 3, 1, 19, 38);
INSERT INTO versification_data VALUES (NULL, 3, 1, 20, 18);
INSERT INTO versification_data VALUES (NULL, 3, 1, 21, 34);
INSERT INTO versification_data VALUES (NULL, 3, 1, 22, 24);
INSERT INTO versification_data VALUES (NULL, 3, 1, 23, 20);
INSERT INTO versification_data VALUES (NULL, 3, 1, 24, 67);
INSERT INTO versification_data VALUES (NULL, 3, 1, 25, 34);
INSERT INTO versification_data VALUES (NULL, 3, 1, 26, 35);
INSERT INTO versification_data VALUES (NULL, 3, 1, 27, 46);
INSERT INTO versification_data VALUES (NULL, 3, 1, 28, 22);
INSERT INTO versification_data VALUES (NULL, 3, 1, 29, 35);
INSERT INTO versification_data VALUES (NULL, 3, 1, 30, 43);
INSERT INTO versification_data VALUES (NULL, 3, 1, 31, 55);
INSERT INTO versification_data VALUES (NULL, 3, 1, 32, 32);
INSERT INTO versification_data VALUES (NULL, 3, 1, 33, 20);
INSERT INTO versification_data VALUES (NULL, 3, 1, 34, 31);
INSERT INTO versification_data VALUES (NULL, 3, 1, 35, 29);
INSERT INTO versification_data VALUES (NULL, 3, 1, 36, 43);
INSERT INTO versification_data VALUES (NULL, 3, 1, 37, 36);
INSERT INTO versification_data VALUES (NULL, 3, 1, 38, 30);
INSERT INTO versification_data VALUES (NULL, 3, 1, 39, 23);
INSERT INTO versification_data VALUES (NULL, 3, 1, 40, 23);
INSERT INTO versification_data VALUES (NULL, 3, 1, 41, 57);
INSERT INTO versification_data VALUES (NULL, 3, 1, 42, 38);
INSERT INTO versification_data VALUES (NULL, 3, 1, 43, 34);
INSERT INTO versification_data VALUES (NULL, 3, 1, 44, 34);
INSERT INTO versification_data VALUES (NULL, 3, 1, 45, 28);
INSERT INTO versification_data VALUES (NULL, 3, 1, 46, 34);
INSERT INTO versification_data VALUES (NULL, 3, 1, 47, 31);
INSERT INTO versification_data VALUES (NULL, 3, 1, 48, 22);
INSERT INTO versification_data VALUES (NULL, 3, 1, 49, 32);
INSERT INTO versification_data VALUES (NULL, 3, 1, 50, 25);
INSERT INTO versification_data VALUES (NULL, 3, 2, 1, 22);
INSERT INTO versification_data VALUES (NULL, 3, 2, 2, 25);
INSERT INTO versification_data VALUES (NULL, 3, 2, 3, 22);
INSERT INTO versification_data VALUES (NULL, 3, 2, 4, 31);
INSERT INTO versification_data VALUES (NULL, 3, 2, 5, 23);
INSERT INTO versification_data VALUES (NULL, 3, 2, 6, 30);
INSERT INTO versification_data VALUES (NULL, 3, 2, 7, 25);
INSERT INTO versification_data VALUES (NULL, 3, 2, 8, 32);
INSERT INTO versification_data VALUES (NULL, 3, 2, 9, 35);
INSERT INTO versification_data VALUES (NULL, 3, 2, 10, 29);
INSERT INTO versification_data VALUES (NULL, 3, 2, 11, 10);
INSERT INTO versification_data VALUES (NULL, 3, 2, 12, 51);
INSERT INTO versification_data VALUES (NULL, 3, 2, 13, 22);
INSERT INTO versification_data VALUES (NULL, 3, 2, 14, 31);
INSERT INTO versification_data VALUES (NULL, 3, 2, 15, 27);
INSERT INTO versification_data VALUES (NULL, 3, 2, 16, 36);
INSERT INTO versification_data VALUES (NULL, 3, 2, 17, 16);
INSERT INTO versification_data VALUES (NULL, 3, 2, 18, 27);
INSERT INTO versification_data VALUES (NULL, 3, 2, 19, 25);
INSERT INTO versification_data VALUES (NULL, 3, 2, 20, 26);
INSERT INTO versification_data VALUES (NULL, 3, 2, 21, 36);
INSERT INTO versification_data VALUES (NULL, 3, 2, 22, 31);
INSERT INTO versification_data VALUES (NULL, 3, 2, 23, 33);
INSERT INTO versification_data VALUES (NULL, 3, 2, 24, 18);
INSERT INTO versification_data VALUES (NULL, 3, 2, 25, 40);
INSERT INTO versification_data VALUES (NULL, 3, 2, 26, 37);
INSERT INTO versification_data VALUES (NULL, 3, 2, 27, 21);
INSERT INTO versification_data VALUES (NULL, 3, 2, 28, 43);
INSERT INTO versification_data VALUES (NULL, 3, 2, 29, 46);
INSERT INTO versification_data VALUES (NULL, 3, 2, 30, 38);
INSERT INTO versification_data VALUES (NULL, 3, 2, 31, 18);
INSERT INTO versification_data VALUES (NULL, 3, 2, 32, 35);
INSERT INTO versification_data VALUES (NULL, 3, 2, 33, 23);
INSERT INTO versification_data VALUES (NULL, 3, 2, 34, 35);
INSERT INTO versification_data VALUES (NULL, 3, 2, 35, 35);
INSERT INTO versification_data VALUES (NULL, 3, 2, 36, 38);
INSERT INTO versification_data VALUES (NULL, 3, 2, 37, 29);
INSERT INTO versification_data VALUES (NULL, 3, 2, 38, 31);
INSERT INTO versification_data VALUES (NULL, 3, 2, 39, 43);
INSERT INTO versification_data VALUES (NULL, 3, 2, 40, 36);
INSERT INTO versification_data VALUES (NULL, 3, 3, 1, 17);
INSERT INTO versification_data VALUES (NULL, 3, 3, 2, 16);
INSERT INTO versification_data VALUES (NULL, 3, 3, 3, 17);
INSERT INTO versification_data VALUES (NULL, 3, 3, 4, 35);
INSERT INTO versification_data VALUES (NULL, 3, 3, 5, 19);
INSERT INTO versification_data VALUES (NULL, 3, 3, 6, 30);
INSERT INTO versification_data VALUES (NULL, 3, 3, 7, 38);
INSERT INTO versification_data VALUES (NULL, 3, 3, 8, 36);
INSERT INTO versification_data VALUES (NULL, 3, 3, 9, 24);
INSERT INTO versification_data VALUES (NULL, 3, 3, 10, 20);
INSERT INTO versification_data VALUES (NULL, 3, 3, 11, 47);
INSERT INTO versification_data VALUES (NULL, 3, 3, 12, 8);
INSERT INTO versification_data VALUES (NULL, 3, 3, 13, 59);
INSERT INTO versification_data VALUES (NULL, 3, 3, 14, 57);
INSERT INTO versification_data VALUES (NULL, 3, 3, 15, 33);
INSERT INTO versification_data VALUES (NULL, 3, 3, 16, 34);
INSERT INTO versification_data VALUES (NULL, 3, 3, 17, 16);
INSERT INTO versification_data VALUES (NULL, 3, 3, 18, 30);
INSERT INTO versification_data VALUES (NULL, 3, 3, 19, 37);
INSERT INTO versification_data VALUES (NULL, 3, 3, 20, 27);
INSERT INTO versification_data VALUES (NULL, 3, 3, 21, 24);
INSERT INTO versification_data VALUES (NULL, 3, 3, 22, 33);
INSERT INTO versification_data VALUES (NULL, 3, 3, 23, 44);
INSERT INTO versification_data VALUES (NULL, 3, 3, 24, 23);
INSERT INTO versification_data VALUES (NULL, 3, 3, 25, 55);
INSERT INTO versification_data VALUES (NULL, 3, 3, 26, 45);
INSERT INTO versification_data VALUES (NULL, 3, 3, 27, 34);
INSERT INTO versification_data VALUES (NULL, 3, 4, 1, 54);
INSERT INTO versification_data VALUES (NULL, 3, 4, 2, 34);
INSERT INTO versification_data VALUES (NULL, 3, 4, 3, 51);
INSERT INTO versification_data VALUES (NULL, 3, 4, 4, 49);
INSERT INTO versification_data VALUES (NULL, 3, 4, 5, 31);
INSERT INTO versification_data VALUES (NULL, 3, 4, 6, 27);
INSERT INTO versification_data VALUES (NULL, 3, 4, 7, 89);
INSERT INTO versification_data VALUES (NULL, 3, 4, 8, 26);
INSERT INTO versification_data VALUES (NULL, 3, 4, 9, 23);
INSERT INTO versification_data VALUES (NULL, 3, 4, 10, 36);
INSERT INTO versification_data VALUES (NULL, 3, 4, 11, 34);
INSERT INTO versification_data VALUES (NULL, 3, 4, 12, 15);
INSERT INTO versification_data VALUES (NULL, 3, 4, 13, 34);
INSERT INTO versification_data VALUES (NULL, 3, 4, 14, 45);
INSERT INTO versification_data VALUES (NULL, 3, 4, 15, 41);
INSERT INTO versification_data VALUES (NULL, 3, 4, 16, 50);
INSERT INTO versification_data VALUES (NULL, 3, 4, 17, 13);
INSERT INTO versification_data VALUES (NULL, 3, 4, 18, 32);
INSERT INTO versification_data VALUES (NULL, 3, 4, 19, 22);
INSERT INTO versification_data VALUES (NULL, 3, 4, 20, 30);
INSERT INTO versification_data VALUES (NULL, 3, 4, 21, 35);
INSERT INTO versification_data VALUES (NULL, 3, 4, 22, 41);
INSERT INTO versification_data VALUES (NULL, 3, 4, 23, 30);
INSERT INTO versification_data VALUES (NULL, 3, 4, 24, 25);
INSERT INTO versification_data VALUES (NULL, 3, 4, 25, 18);
INSERT INTO versification_data VALUES (NULL, 3, 4, 26, 65);
INSERT INTO versification_data VALUES (NULL, 3, 4, 27, 23);
INSERT INTO versification_data VALUES (NULL, 3, 4, 28, 31);
INSERT INTO versification_data VALUES (NULL, 3, 4, 29, 39);
INSERT INTO versification_data VALUES (NULL, 3, 4, 30, 17);
INSERT INTO versification_data VALUES (NULL, 3, 4, 31, 54);
INSERT INTO versification_data VALUES (NULL, 3, 4, 32, 42);
INSERT INTO versification_data VALUES (NULL, 3, 4, 33, 56);
INSERT INTO versification_data VALUES (NULL, 3, 4, 34, 29);
INSERT INTO versification_data VALUES (NULL, 3, 4, 35, 34);
INSERT INTO versification_data VALUES (NULL, 3, 4, 36, 13);
INSERT INTO versification_data VALUES (NULL, 3, 5, 1, 46);
INSERT INTO versification_data VALUES (NULL, 3, 5, 2, 37);
INSERT INTO versification_data VALUES (NULL, 3, 5, 3, 29);
INSERT INTO versification_data VALUES (NULL, 3, 5, 4, 49);
INSERT INTO versification_data VALUES (NULL, 3, 5, 5, 33);
INSERT INTO versification_data VALUES (NULL, 3, 5, 6, 25);
INSERT INTO versification_data VALUES (NULL, 3, 5, 7, 26);
INSERT INTO versification_data VALUES (NULL, 3, 5, 8, 20);
INSERT INTO versification_data VALUES (NULL, 3, 5, 9, 29);
INSERT INTO versification_data VALUES (NULL, 3, 5, 10, 22);
INSERT INTO versification_data VALUES (NULL, 3, 5, 11, 32);
INSERT INTO versification_data VALUES (NULL, 3, 5, 12, 32);
INSERT INTO versification_data VALUES (NULL, 3, 5, 13, 18);
INSERT INTO versification_data VALUES (NULL, 3, 5, 14, 29);
INSERT INTO versification_data VALUES (NULL, 3, 5, 15, 23);
INSERT INTO versification_data VALUES (NULL, 3, 5, 16, 22);
INSERT INTO versification_data VALUES (NULL, 3, 5, 17, 20);
INSERT INTO versification_data VALUES (NULL, 3, 5, 18, 22);
INSERT INTO versification_data VALUES (NULL, 3, 5, 19, 21);
INSERT INTO versification_data VALUES (NULL, 3, 5, 20, 20);
INSERT INTO versification_data VALUES (NULL, 3, 5, 21, 23);
INSERT INTO versification_data VALUES (NULL, 3, 5, 22, 30);
INSERT INTO versification_data VALUES (NULL, 3, 5, 23, 25);
INSERT INTO versification_data VALUES (NULL, 3, 5, 24, 22);
INSERT INTO versification_data VALUES (NULL, 3, 5, 25, 19);
INSERT INTO versification_data VALUES (NULL, 3, 5, 26, 19);
INSERT INTO versification_data VALUES (NULL, 3, 5, 27, 26);
INSERT INTO versification_data VALUES (NULL, 3, 5, 28, 68);
INSERT INTO versification_data VALUES (NULL, 3, 5, 29, 29);
INSERT INTO versification_data VALUES (NULL, 3, 5, 30, 20);
INSERT INTO versification_data VALUES (NULL, 3, 5, 31, 30);
INSERT INTO versification_data VALUES (NULL, 3, 5, 32, 52);
INSERT INTO versification_data VALUES (NULL, 3, 5, 33, 29);
INSERT INTO versification_data VALUES (NULL, 3, 5, 34, 12);
INSERT INTO versification_data VALUES (NULL, 3, 6, 1, 18);
INSERT INTO versification_data VALUES (NULL, 3, 6, 2, 24);
INSERT INTO versification_data VALUES (NULL, 3, 6, 3, 17);
INSERT INTO versification_data VALUES (NULL, 3, 6, 4, 25);
INSERT INTO versification_data VALUES (NULL, 3, 6, 5, 16);
INSERT INTO versification_data VALUES (NULL, 3, 6, 6, 27);
INSERT INTO versification_data VALUES (NULL, 3, 6, 7, 26);
INSERT INTO versification_data VALUES (NULL, 3, 6, 8, 35);
INSERT INTO versification_data VALUES (NULL, 3, 6, 9, 27);
INSERT INTO versification_data VALUES (NULL, 3, 6, 10, 43);
INSERT INTO versification_data VALUES (NULL, 3, 6, 11, 23);
INSERT INTO versification_data VALUES (NULL, 3, 6, 12, 24);
INSERT INTO versification_data VALUES (NULL, 3, 6, 13, 33);
INSERT INTO versification_data VALUES (NULL, 3, 6, 14, 15);
INSERT INTO versification_data VALUES (NULL, 3, 6, 15, 63);
INSERT INTO versification_data VALUES (NULL, 3, 6, 16, 10);
INSERT INTO versification_data VALUES (NULL, 3, 6, 17, 18);
INSERT INTO versification_data VALUES (NULL, 3, 6, 18, 28);
INSERT INTO versification_data VALUES (NULL, 3, 6, 19, 51);
INSERT INTO versification_data VALUES (NULL, 3, 6, 20, 9);
INSERT INTO versification_data VALUES (NULL, 3, 6, 21, 43);
INSERT INTO versification_data VALUES (NULL, 3, 6, 22, 34);
INSERT INTO versification_data VALUES (NULL, 3, 6, 23, 16);
INSERT INTO versification_data VALUES (NULL, 3, 6, 24, 33);
INSERT INTO versification_data VALUES (NULL, 3, 7, 1, 36);
INSERT INTO versification_data VALUES (NULL, 3, 7, 2, 23);
INSERT INTO versification_data VALUES (NULL, 3, 7, 3, 31);
INSERT INTO versification_data VALUES (NULL, 3, 7, 4, 24);
INSERT INTO versification_data VALUES (NULL, 3, 7, 5, 32);
INSERT INTO versification_data VALUES (NULL, 3, 7, 6, 40);
INSERT INTO versification_data VALUES (NULL, 3, 7, 7, 25);
INSERT INTO versification_data VALUES (NULL, 3, 7, 8, 35);
INSERT INTO versification_data VALUES (NULL, 3, 7, 9, 57);
INSERT INTO versification_data VALUES (NULL, 3, 7, 10, 18);
INSERT INTO versification_data VALUES (NULL, 3, 7, 11, 40);
INSERT INTO versification_data VALUES (NULL, 3, 7, 12, 15);
INSERT INTO versification_data VALUES (NULL, 3, 7, 13, 25);
INSERT INTO versification_data VALUES (NULL, 3, 7, 14, 20);
INSERT INTO versification_data VALUES (NULL, 3, 7, 15, 20);
INSERT INTO versification_data VALUES (NULL, 3, 7, 16, 31);
INSERT INTO versification_data VALUES (NULL, 3, 7, 17, 13);
INSERT INTO versification_data VALUES (NULL, 3, 7, 18, 31);
INSERT INTO versification_data VALUES (NULL, 3, 7, 19, 30);
INSERT INTO versification_data VALUES (NULL, 3, 7, 20, 48);
INSERT INTO versification_data VALUES (NULL, 3, 7, 21, 24);
INSERT INTO versification_data VALUES (NULL, 3, 8, 1, 22);
INSERT INTO versification_data VALUES (NULL, 3, 8, 2, 23);
INSERT INTO versification_data VALUES (NULL, 3, 8, 3, 18);
INSERT INTO versification_data VALUES (NULL, 3, 8, 4, 22);
INSERT INTO versification_data VALUES (NULL, 3, 9, 1, 28);
INSERT INTO versification_data VALUES (NULL, 3, 9, 2, 36);
INSERT INTO versification_data VALUES (NULL, 3, 9, 3, 21);
INSERT INTO versification_data VALUES (NULL, 3, 9, 4, 22);
INSERT INTO versification_data VALUES (NULL, 3, 9, 5, 12);
INSERT INTO versification_data VALUES (NULL, 3, 9, 6, 21);
INSERT INTO versification_data VALUES (NULL, 3, 9, 7, 17);
INSERT INTO versification_data VALUES (NULL, 3, 9, 8, 22);
INSERT INTO versification_data VALUES (NULL, 3, 9, 9, 27);
INSERT INTO versification_data VALUES (NULL, 3, 9, 10, 27);
INSERT INTO versification_data VALUES (NULL, 3, 9, 11, 15);
INSERT INTO versification_data VALUES (NULL, 3, 9, 12, 25);
INSERT INTO versification_data VALUES (NULL, 3, 9, 13, 23);
INSERT INTO versification_data VALUES (NULL, 3, 9, 14, 52);
INSERT INTO versification_data VALUES (NULL, 3, 9, 15, 35);
INSERT INTO versification_data VALUES (NULL, 3, 9, 16, 23);
INSERT INTO versification_data VALUES (NULL, 3, 9, 17, 58);
INSERT INTO versification_data VALUES (NULL, 3, 9, 18, 30);
INSERT INTO versification_data VALUES (NULL, 3, 9, 19, 24);
INSERT INTO versification_data VALUES (NULL, 3, 9, 20, 43);
INSERT INTO versification_data VALUES (NULL, 3, 9, 21, 15);
INSERT INTO versification_data VALUES (NULL, 3, 9, 22, 23);
INSERT INTO versification_data VALUES (NULL, 3, 9, 23, 28);
INSERT INTO versification_data VALUES (NULL, 3, 9, 24, 23);
INSERT INTO versification_data VALUES (NULL, 3, 9, 25, 44);
INSERT INTO versification_data VALUES (NULL, 3, 9, 26, 25);
INSERT INTO versification_data VALUES (NULL, 3, 9, 27, 12);
INSERT INTO versification_data VALUES (NULL, 3, 9, 28, 25);
INSERT INTO versification_data VALUES (NULL, 3, 9, 29, 11);
INSERT INTO versification_data VALUES (NULL, 3, 9, 30, 31);
INSERT INTO versification_data VALUES (NULL, 3, 9, 31, 13);
INSERT INTO versification_data VALUES (NULL, 3, 10, 1, 27);
INSERT INTO versification_data VALUES (NULL, 3, 10, 2, 32);
INSERT INTO versification_data VALUES (NULL, 3, 10, 3, 39);
INSERT INTO versification_data VALUES (NULL, 3, 10, 4, 12);
INSERT INTO versification_data VALUES (NULL, 3, 10, 5, 25);
INSERT INTO versification_data VALUES (NULL, 3, 10, 6, 23);
INSERT INTO versification_data VALUES (NULL, 3, 10, 7, 29);
INSERT INTO versification_data VALUES (NULL, 3, 10, 8, 18);
INSERT INTO versification_data VALUES (NULL, 3, 10, 9, 13);
INSERT INTO versification_data VALUES (NULL, 3, 10, 10, 19);
INSERT INTO versification_data VALUES (NULL, 3, 10, 11, 27);
INSERT INTO versification_data VALUES (NULL, 3, 10, 12, 31);
INSERT INTO versification_data VALUES (NULL, 3, 10, 13, 39);
INSERT INTO versification_data VALUES (NULL, 3, 10, 14, 33);
INSERT INTO versification_data VALUES (NULL, 3, 10, 15, 37);
INSERT INTO versification_data VALUES (NULL, 3, 10, 16, 23);
INSERT INTO versification_data VALUES (NULL, 3, 10, 17, 29);
INSERT INTO versification_data VALUES (NULL, 3, 10, 18, 33);
INSERT INTO versification_data VALUES (NULL, 3, 10, 19, 43);
INSERT INTO versification_data VALUES (NULL, 3, 10, 20, 26);
INSERT INTO versification_data VALUES (NULL, 3, 10, 21, 22);
INSERT INTO versification_data VALUES (NULL, 3, 10, 22, 51);
INSERT INTO versification_data VALUES (NULL, 3, 10, 23, 39);
INSERT INTO versification_data VALUES (NULL, 3, 10, 24, 25);
INSERT INTO versification_data VALUES (NULL, 3, 11, 1, 53);
INSERT INTO versification_data VALUES (NULL, 3, 11, 2, 46);
INSERT INTO versification_data VALUES (NULL, 3, 11, 3, 28);
INSERT INTO versification_data VALUES (NULL, 3, 11, 4, 34);
INSERT INTO versification_data VALUES (NULL, 3, 11, 5, 18);
INSERT INTO versification_data VALUES (NULL, 3, 11, 6, 38);
INSERT INTO versification_data VALUES (NULL, 3, 11, 7, 51);
INSERT INTO versification_data VALUES (NULL, 3, 11, 8, 66);
INSERT INTO versification_data VALUES (NULL, 3, 11, 9, 28);
INSERT INTO versification_data VALUES (NULL, 3, 11, 10, 29);
INSERT INTO versification_data VALUES (NULL, 3, 11, 11, 43);
INSERT INTO versification_data VALUES (NULL, 3, 11, 12, 33);
INSERT INTO versification_data VALUES (NULL, 3, 11, 13, 34);
INSERT INTO versification_data VALUES (NULL, 3, 11, 14, 31);
INSERT INTO versification_data VALUES (NULL, 3, 11, 15, 34);
INSERT INTO versification_data VALUES (NULL, 3, 11, 16, 34);
INSERT INTO versification_data VALUES (NULL, 3, 11, 17, 24);
INSERT INTO versification_data VALUES (NULL, 3, 11, 18, 46);
INSERT INTO versification_data VALUES (NULL, 3, 11, 19, 21);
INSERT INTO versification_data VALUES (NULL, 3, 11, 20, 43);
INSERT INTO versification_data VALUES (NULL, 3, 11, 21, 29);
INSERT INTO versification_data VALUES (NULL, 3, 11, 22, 54);
INSERT INTO versification_data VALUES (NULL, 3, 12, 1, 18);
INSERT INTO versification_data VALUES (NULL, 3, 12, 2, 25);
INSERT INTO versification_data VALUES (NULL, 3, 12, 3, 27);
INSERT INTO versification_data VALUES (NULL, 3, 12, 4, 44);
INSERT INTO versification_data VALUES (NULL, 3, 12, 5, 27);
INSERT INTO versification_data VALUES (NULL, 3, 12, 6, 33);
INSERT INTO versification_data VALUES (NULL, 3, 12, 7, 20);
INSERT INTO versification_data VALUES (NULL, 3, 12, 8, 29);
INSERT INTO versification_data VALUES (NULL, 3, 12, 9, 37);
INSERT INTO versification_data VALUES (NULL, 3, 12, 10, 36);
INSERT INTO versification_data VALUES (NULL, 3, 12, 11, 21);
INSERT INTO versification_data VALUES (NULL, 3, 12, 12, 21);
INSERT INTO versification_data VALUES (NULL, 3, 12, 13, 25);
INSERT INTO versification_data VALUES (NULL, 3, 12, 14, 29);
INSERT INTO versification_data VALUES (NULL, 3, 12, 15, 38);
INSERT INTO versification_data VALUES (NULL, 3, 12, 16, 20);
INSERT INTO versification_data VALUES (NULL, 3, 12, 17, 41);
INSERT INTO versification_data VALUES (NULL, 3, 12, 18, 37);
INSERT INTO versification_data VALUES (NULL, 3, 12, 19, 37);
INSERT INTO versification_data VALUES (NULL, 3, 12, 20, 21);
INSERT INTO versification_data VALUES (NULL, 3, 12, 21, 26);
INSERT INTO versification_data VALUES (NULL, 3, 12, 22, 20);
INSERT INTO versification_data VALUES (NULL, 3, 12, 23, 37);
INSERT INTO versification_data VALUES (NULL, 3, 12, 24, 20);
INSERT INTO versification_data VALUES (NULL, 3, 12, 25, 30);
INSERT INTO versification_data VALUES (NULL, 3, 13, 1, 54);
INSERT INTO versification_data VALUES (NULL, 3, 13, 2, 55);
INSERT INTO versification_data VALUES (NULL, 3, 13, 3, 24);
INSERT INTO versification_data VALUES (NULL, 3, 13, 4, 43);
INSERT INTO versification_data VALUES (NULL, 3, 13, 5, 26);
INSERT INTO versification_data VALUES (NULL, 3, 13, 6, 81);
INSERT INTO versification_data VALUES (NULL, 3, 13, 7, 40);
INSERT INTO versification_data VALUES (NULL, 3, 13, 8, 40);
INSERT INTO versification_data VALUES (NULL, 3, 13, 9, 44);
INSERT INTO versification_data VALUES (NULL, 3, 13, 10, 14);
INSERT INTO versification_data VALUES (NULL, 3, 13, 11, 46);
INSERT INTO versification_data VALUES (NULL, 3, 13, 12, 40);
INSERT INTO versification_data VALUES (NULL, 3, 13, 13, 14);
INSERT INTO versification_data VALUES (NULL, 3, 13, 14, 17);
INSERT INTO versification_data VALUES (NULL, 3, 13, 15, 29);
INSERT INTO versification_data VALUES (NULL, 3, 13, 16, 43);
INSERT INTO versification_data VALUES (NULL, 3, 13, 17, 27);
INSERT INTO versification_data VALUES (NULL, 3, 13, 18, 17);
INSERT INTO versification_data VALUES (NULL, 3, 13, 19, 19);
INSERT INTO versification_data VALUES (NULL, 3, 13, 20, 7);
INSERT INTO versification_data VALUES (NULL, 3, 13, 21, 30);
INSERT INTO versification_data VALUES (NULL, 3, 13, 22, 19);
INSERT INTO versification_data VALUES (NULL, 3, 13, 23, 32);
INSERT INTO versification_data VALUES (NULL, 3, 13, 24, 31);
INSERT INTO versification_data VALUES (NULL, 3, 13, 25, 31);
INSERT INTO versification_data VALUES (NULL, 3, 13, 26, 32);
INSERT INTO versification_data VALUES (NULL, 3, 13, 27, 34);
INSERT INTO versification_data VALUES (NULL, 3, 13, 28, 21);
INSERT INTO versification_data VALUES (NULL, 3, 13, 29, 30);
INSERT INTO versification_data VALUES (NULL, 3, 14, 1, 17);
INSERT INTO versification_data VALUES (NULL, 3, 14, 2, 18);
INSERT INTO versification_data VALUES (NULL, 3, 14, 3, 17);
INSERT INTO versification_data VALUES (NULL, 3, 14, 4, 22);
INSERT INTO versification_data VALUES (NULL, 3, 14, 5, 14);
INSERT INTO versification_data VALUES (NULL, 3, 14, 6, 42);
INSERT INTO versification_data VALUES (NULL, 3, 14, 7, 22);
INSERT INTO versification_data VALUES (NULL, 3, 14, 8, 18);
INSERT INTO versification_data VALUES (NULL, 3, 14, 9, 31);
INSERT INTO versification_data VALUES (NULL, 3, 14, 10, 19);
INSERT INTO versification_data VALUES (NULL, 3, 14, 11, 23);
INSERT INTO versification_data VALUES (NULL, 3, 14, 12, 16);
INSERT INTO versification_data VALUES (NULL, 3, 14, 13, 22);
INSERT INTO versification_data VALUES (NULL, 3, 14, 14, 15);
INSERT INTO versification_data VALUES (NULL, 3, 14, 15, 19);
INSERT INTO versification_data VALUES (NULL, 3, 14, 16, 14);
INSERT INTO versification_data VALUES (NULL, 3, 14, 17, 19);
INSERT INTO versification_data VALUES (NULL, 3, 14, 18, 34);
INSERT INTO versification_data VALUES (NULL, 3, 14, 19, 11);
INSERT INTO versification_data VALUES (NULL, 3, 14, 20, 37);
INSERT INTO versification_data VALUES (NULL, 3, 14, 21, 20);
INSERT INTO versification_data VALUES (NULL, 3, 14, 22, 12);
INSERT INTO versification_data VALUES (NULL, 3, 14, 23, 21);
INSERT INTO versification_data VALUES (NULL, 3, 14, 24, 27);
INSERT INTO versification_data VALUES (NULL, 3, 14, 25, 28);
INSERT INTO versification_data VALUES (NULL, 3, 14, 26, 23);
INSERT INTO versification_data VALUES (NULL, 3, 14, 27, 9);
INSERT INTO versification_data VALUES (NULL, 3, 14, 28, 27);
INSERT INTO versification_data VALUES (NULL, 3, 14, 29, 36);
INSERT INTO versification_data VALUES (NULL, 3, 14, 30, 27);
INSERT INTO versification_data VALUES (NULL, 3, 14, 31, 21);
INSERT INTO versification_data VALUES (NULL, 3, 14, 32, 33);
INSERT INTO versification_data VALUES (NULL, 3, 14, 33, 25);
INSERT INTO versification_data VALUES (NULL, 3, 14, 34, 33);
INSERT INTO versification_data VALUES (NULL, 3, 14, 35, 27);
INSERT INTO versification_data VALUES (NULL, 3, 14, 36, 23);
INSERT INTO versification_data VALUES (NULL, 3, 15, 1, 11);
INSERT INTO versification_data VALUES (NULL, 3, 15, 2, 70);
INSERT INTO versification_data VALUES (NULL, 3, 15, 3, 13);
INSERT INTO versification_data VALUES (NULL, 3, 15, 4, 24);
INSERT INTO versification_data VALUES (NULL, 3, 15, 5, 17);
INSERT INTO versification_data VALUES (NULL, 3, 15, 6, 22);
INSERT INTO versification_data VALUES (NULL, 3, 15, 7, 28);
INSERT INTO versification_data VALUES (NULL, 3, 15, 8, 36);
INSERT INTO versification_data VALUES (NULL, 3, 15, 9, 15);
INSERT INTO versification_data VALUES (NULL, 3, 15, 10, 44);
INSERT INTO versification_data VALUES (NULL, 3, 16, 1, 11);
INSERT INTO versification_data VALUES (NULL, 3, 16, 2, 20);
INSERT INTO versification_data VALUES (NULL, 3, 16, 3, 31);
INSERT INTO versification_data VALUES (NULL, 3, 16, 4, 23);
INSERT INTO versification_data VALUES (NULL, 3, 16, 5, 19);
INSERT INTO versification_data VALUES (NULL, 3, 16, 6, 19);
INSERT INTO versification_data VALUES (NULL, 3, 16, 7, 73);
INSERT INTO versification_data VALUES (NULL, 3, 16, 8, 18);
INSERT INTO versification_data VALUES (NULL, 3, 16, 9, 38);
INSERT INTO versification_data VALUES (NULL, 3, 16, 10, 39);
INSERT INTO versification_data VALUES (NULL, 3, 16, 11, 36);
INSERT INTO versification_data VALUES (NULL, 3, 16, 12, 46);
INSERT INTO versification_data VALUES (NULL, 3, 16, 13, 31);
INSERT INTO versification_data VALUES (NULL, 3, 17, 1, 22);
INSERT INTO versification_data VALUES (NULL, 3, 17, 2, 23);
INSERT INTO versification_data VALUES (NULL, 3, 17, 3, 15);
INSERT INTO versification_data VALUES (NULL, 3, 17, 4, 17);
INSERT INTO versification_data VALUES (NULL, 3, 17, 5, 14);
INSERT INTO versification_data VALUES (NULL, 3, 17, 6, 14);
INSERT INTO versification_data VALUES (NULL, 3, 17, 7, 10);
INSERT INTO versification_data VALUES (NULL, 3, 17, 8, 17);
INSERT INTO versification_data VALUES (NULL, 3, 17, 9, 32);
INSERT INTO versification_data VALUES (NULL, 3, 17, 10, 13);
INSERT INTO versification_data VALUES (NULL, 3, 17, 11, 12);
INSERT INTO versification_data VALUES (NULL, 3, 17, 12, 6);
INSERT INTO versification_data VALUES (NULL, 3, 17, 13, 18);
INSERT INTO versification_data VALUES (NULL, 3, 17, 14, 19);
INSERT INTO versification_data VALUES (NULL, 3, 17, 15, 19);
INSERT INTO versification_data VALUES (NULL, 3, 17, 16, 24);
INSERT INTO versification_data VALUES (NULL, 3, 18, 1, 22);
INSERT INTO versification_data VALUES (NULL, 3, 18, 2, 13);
INSERT INTO versification_data VALUES (NULL, 3, 18, 3, 26);
INSERT INTO versification_data VALUES (NULL, 3, 18, 4, 21);
INSERT INTO versification_data VALUES (NULL, 3, 18, 5, 27);
INSERT INTO versification_data VALUES (NULL, 3, 18, 6, 30);
INSERT INTO versification_data VALUES (NULL, 3, 18, 7, 21);
INSERT INTO versification_data VALUES (NULL, 3, 18, 8, 22);
INSERT INTO versification_data VALUES (NULL, 3, 18, 9, 35);
INSERT INTO versification_data VALUES (NULL, 3, 18, 10, 22);
INSERT INTO versification_data VALUES (NULL, 3, 18, 11, 20);
INSERT INTO versification_data VALUES (NULL, 3, 18, 12, 25);
INSERT INTO versification_data VALUES (NULL, 3, 18, 13, 28);
INSERT INTO versification_data VALUES (NULL, 3, 18, 14, 22);
INSERT INTO versification_data VALUES (NULL, 3, 18, 15, 35);
INSERT INTO versification_data VALUES (NULL, 3, 18, 16, 23);
INSERT INTO versification_data VALUES (NULL, 3, 18, 17, 16);
INSERT INTO versification_data VALUES (NULL, 3, 18, 18, 21);
INSERT INTO versification_data VALUES (NULL, 3, 18, 19, 29);
INSERT INTO versification_data VALUES (NULL, 3, 18, 20, 29);
INSERT INTO versification_data VALUES (NULL, 3, 18, 21, 34);
INSERT INTO versification_data VALUES (NULL, 3, 18, 22, 30);
INSERT INTO versification_data VALUES (NULL, 3, 18, 23, 17);
INSERT INTO versification_data VALUES (NULL, 3, 18, 24, 25);
INSERT INTO versification_data VALUES (NULL, 3, 18, 25, 6);
INSERT INTO versification_data VALUES (NULL, 3, 18, 26, 14);
INSERT INTO versification_data VALUES (NULL, 3, 18, 27, 23);
INSERT INTO versification_data VALUES (NULL, 3, 18, 28, 28);
INSERT INTO versification_data VALUES (NULL, 3, 18, 29, 25);
INSERT INTO versification_data VALUES (NULL, 3, 18, 30, 31);
INSERT INTO versification_data VALUES (NULL, 3, 18, 31, 40);
INSERT INTO versification_data VALUES (NULL, 3, 18, 32, 22);
INSERT INTO versification_data VALUES (NULL, 3, 18, 33, 33);
INSERT INTO versification_data VALUES (NULL, 3, 18, 34, 37);
INSERT INTO versification_data VALUES (NULL, 3, 18, 35, 16);
INSERT INTO versification_data VALUES (NULL, 3, 18, 36, 33);
INSERT INTO versification_data VALUES (NULL, 3, 18, 37, 24);
INSERT INTO versification_data VALUES (NULL, 3, 18, 38, 41);
INSERT INTO versification_data VALUES (NULL, 3, 18, 39, 35);
INSERT INTO versification_data VALUES (NULL, 3, 18, 40, 28);
INSERT INTO versification_data VALUES (NULL, 3, 18, 41, 25);
INSERT INTO versification_data VALUES (NULL, 3, 18, 42, 16);
INSERT INTO versification_data VALUES (NULL, 3, 19, 1, 6);
INSERT INTO versification_data VALUES (NULL, 3, 19, 2, 13);
INSERT INTO versification_data VALUES (NULL, 3, 19, 3, 9);
INSERT INTO versification_data VALUES (NULL, 3, 19, 4, 10);
INSERT INTO versification_data VALUES (NULL, 3, 19, 5, 13);
INSERT INTO versification_data VALUES (NULL, 3, 19, 6, 11);
INSERT INTO versification_data VALUES (NULL, 3, 19, 7, 18);
INSERT INTO versification_data VALUES (NULL, 3, 19, 8, 10);
INSERT INTO versification_data VALUES (NULL, 3, 19, 9, 39);
INSERT INTO versification_data VALUES (NULL, 3, 19, 10, 8);
INSERT INTO versification_data VALUES (NULL, 3, 19, 11, 9);
INSERT INTO versification_data VALUES (NULL, 3, 19, 12, 6);
INSERT INTO versification_data VALUES (NULL, 3, 19, 13, 7);
INSERT INTO versification_data VALUES (NULL, 3, 19, 14, 5);
INSERT INTO versification_data VALUES (NULL, 3, 19, 15, 10);
INSERT INTO versification_data VALUES (NULL, 3, 19, 16, 15);
INSERT INTO versification_data VALUES (NULL, 3, 19, 17, 51);
INSERT INTO versification_data VALUES (NULL, 3, 19, 18, 15);
INSERT INTO versification_data VALUES (NULL, 3, 19, 19, 10);
INSERT INTO versification_data VALUES (NULL, 3, 19, 20, 14);
INSERT INTO versification_data VALUES (NULL, 3, 19, 21, 32);
INSERT INTO versification_data VALUES (NULL, 3, 19, 22, 6);
INSERT INTO versification_data VALUES (NULL, 3, 19, 23, 10);
INSERT INTO versification_data VALUES (NULL, 3, 19, 24, 22);
INSERT INTO versification_data VALUES (NULL, 3, 19, 25, 12);
INSERT INTO versification_data VALUES (NULL, 3, 19, 26, 14);
INSERT INTO versification_data VALUES (NULL, 3, 19, 27, 9);
INSERT INTO versification_data VALUES (NULL, 3, 19, 28, 11);
INSERT INTO versification_data VALUES (NULL, 3, 19, 29, 13);
INSERT INTO versification_data VALUES (NULL, 3, 19, 30, 25);
INSERT INTO versification_data VALUES (NULL, 3, 19, 31, 11);
INSERT INTO versification_data VALUES (NULL, 3, 19, 32, 22);
INSERT INTO versification_data VALUES (NULL, 3, 19, 33, 23);
INSERT INTO versification_data VALUES (NULL, 3, 19, 34, 28);
INSERT INTO versification_data VALUES (NULL, 3, 19, 35, 13);
INSERT INTO versification_data VALUES (NULL, 3, 19, 36, 40);
INSERT INTO versification_data VALUES (NULL, 3, 19, 37, 23);
INSERT INTO versification_data VALUES (NULL, 3, 19, 38, 14);
INSERT INTO versification_data VALUES (NULL, 3, 19, 39, 18);
INSERT INTO versification_data VALUES (NULL, 3, 19, 40, 14);
INSERT INTO versification_data VALUES (NULL, 3, 19, 41, 12);
INSERT INTO versification_data VALUES (NULL, 3, 19, 42, 5);
INSERT INTO versification_data VALUES (NULL, 3, 19, 43, 26);
INSERT INTO versification_data VALUES (NULL, 3, 19, 44, 18);
INSERT INTO versification_data VALUES (NULL, 3, 19, 45, 12);
INSERT INTO versification_data VALUES (NULL, 3, 19, 46, 10);
INSERT INTO versification_data VALUES (NULL, 3, 19, 47, 15);
INSERT INTO versification_data VALUES (NULL, 3, 19, 48, 21);
INSERT INTO versification_data VALUES (NULL, 3, 19, 49, 23);
INSERT INTO versification_data VALUES (NULL, 3, 19, 50, 21);
INSERT INTO versification_data VALUES (NULL, 3, 19, 51, 11);
INSERT INTO versification_data VALUES (NULL, 3, 19, 52, 7);
INSERT INTO versification_data VALUES (NULL, 3, 19, 53, 9);
INSERT INTO versification_data VALUES (NULL, 3, 19, 54, 24);
INSERT INTO versification_data VALUES (NULL, 3, 19, 55, 13);
INSERT INTO versification_data VALUES (NULL, 3, 19, 56, 12);
INSERT INTO versification_data VALUES (NULL, 3, 19, 57, 12);
INSERT INTO versification_data VALUES (NULL, 3, 19, 58, 18);
INSERT INTO versification_data VALUES (NULL, 3, 19, 59, 14);
INSERT INTO versification_data VALUES (NULL, 3, 19, 60, 9);
INSERT INTO versification_data VALUES (NULL, 3, 19, 61, 13);
INSERT INTO versification_data VALUES (NULL, 3, 19, 62, 12);
INSERT INTO versification_data VALUES (NULL, 3, 19, 63, 11);
INSERT INTO versification_data VALUES (NULL, 3, 19, 64, 14);
INSERT INTO versification_data VALUES (NULL, 3, 19, 65, 20);
INSERT INTO versification_data VALUES (NULL, 3, 19, 66, 8);
INSERT INTO versification_data VALUES (NULL, 3, 19, 67, 36);
INSERT INTO versification_data VALUES (NULL, 3, 19, 68, 37);
INSERT INTO versification_data VALUES (NULL, 3, 19, 69, 6);
INSERT INTO versification_data VALUES (NULL, 3, 19, 70, 24);
INSERT INTO versification_data VALUES (NULL, 3, 19, 71, 20);
INSERT INTO versification_data VALUES (NULL, 3, 19, 72, 28);
INSERT INTO versification_data VALUES (NULL, 3, 19, 73, 23);
INSERT INTO versification_data VALUES (NULL, 3, 19, 74, 11);
INSERT INTO versification_data VALUES (NULL, 3, 19, 75, 13);
INSERT INTO versification_data VALUES (NULL, 3, 19, 76, 21);
INSERT INTO versification_data VALUES (NULL, 3, 19, 77, 72);
INSERT INTO versification_data VALUES (NULL, 3, 19, 78, 13);
INSERT INTO versification_data VALUES (NULL, 3, 19, 79, 20);
INSERT INTO versification_data VALUES (NULL, 3, 19, 80, 17);
INSERT INTO versification_data VALUES (NULL, 3, 19, 81, 8);
INSERT INTO versification_data VALUES (NULL, 3, 19, 82, 19);
INSERT INTO versification_data VALUES (NULL, 3, 19, 83, 13);
INSERT INTO versification_data VALUES (NULL, 3, 19, 84, 14);
INSERT INTO versification_data VALUES (NULL, 3, 19, 85, 17);
INSERT INTO versification_data VALUES (NULL, 3, 19, 86, 7);
INSERT INTO versification_data VALUES (NULL, 3, 19, 87, 19);
INSERT INTO versification_data VALUES (NULL, 3, 19, 88, 53);
INSERT INTO versification_data VALUES (NULL, 3, 19, 89, 17);
INSERT INTO versification_data VALUES (NULL, 3, 19, 90, 16);
INSERT INTO versification_data VALUES (NULL, 3, 19, 91, 16);
INSERT INTO versification_data VALUES (NULL, 3, 19, 92, 5);
INSERT INTO versification_data VALUES (NULL, 3, 19, 93, 23);
INSERT INTO versification_data VALUES (NULL, 3, 19, 94, 11);
INSERT INTO versification_data VALUES (NULL, 3, 19, 95, 13);
INSERT INTO versification_data VALUES (NULL, 3, 19, 96, 12);
INSERT INTO versification_data VALUES (NULL, 3, 19, 97, 9);
INSERT INTO versification_data VALUES (NULL, 3, 19, 98, 9);
INSERT INTO versification_data VALUES (NULL, 3, 19, 99, 5);
INSERT INTO versification_data VALUES (NULL, 3, 19, 100, 8);
INSERT INTO versification_data VALUES (NULL, 3, 19, 101, 29);
INSERT INTO versification_data VALUES (NULL, 3, 19, 102, 22);
INSERT INTO versification_data VALUES (NULL, 3, 19, 103, 35);
INSERT INTO versification_data VALUES (NULL, 3, 19, 104, 45);
INSERT INTO versification_data VALUES (NULL, 3, 19, 105, 48);
INSERT INTO versification_data VALUES (NULL, 3, 19, 106, 43);
INSERT INTO versification_data VALUES (NULL, 3, 19, 107, 14);
INSERT INTO versification_data VALUES (NULL, 3, 19, 108, 31);
INSERT INTO versification_data VALUES (NULL, 3, 19, 109, 7);
INSERT INTO versification_data VALUES (NULL, 3, 19, 110, 10);
INSERT INTO versification_data VALUES (NULL, 3, 19, 111, 10);
INSERT INTO versification_data VALUES (NULL, 3, 19, 112, 9);
INSERT INTO versification_data VALUES (NULL, 3, 19, 113, 26);
INSERT INTO versification_data VALUES (NULL, 3, 19, 114, 9);
INSERT INTO versification_data VALUES (NULL, 3, 19, 115, 19);
INSERT INTO versification_data VALUES (NULL, 3, 19, 116, 2);
INSERT INTO versification_data VALUES (NULL, 3, 19, 117, 29);
INSERT INTO versification_data VALUES (NULL, 3, 19, 118, 176);
INSERT INTO versification_data VALUES (NULL, 3, 19, 119, 7);
INSERT INTO versification_data VALUES (NULL, 3, 19, 120, 8);
INSERT INTO versification_data VALUES (NULL, 3, 19, 121, 9);
INSERT INTO versification_data VALUES (NULL, 3, 19, 122, 4);
INSERT INTO versification_data VALUES (NULL, 3, 19, 123, 8);
INSERT INTO versification_data VALUES (NULL, 3, 19, 124, 5);
INSERT INTO versification_data VALUES (NULL, 3, 19, 125, 6);
INSERT INTO versification_data VALUES (NULL, 3, 19, 126, 5);
INSERT INTO versification_data VALUES (NULL, 3, 19, 127, 6);
INSERT INTO versification_data VALUES (NULL, 3, 19, 128, 8);
INSERT INTO versification_data VALUES (NULL, 3, 19, 129, 8);
INSERT INTO versification_data VALUES (NULL, 3, 19, 130, 3);
INSERT INTO versification_data VALUES (NULL, 3, 19, 131, 18);
INSERT INTO versification_data VALUES (NULL, 3, 19, 132, 3);
INSERT INTO versification_data VALUES (NULL, 3, 19, 133, 3);
INSERT INTO versification_data VALUES (NULL, 3, 19, 134, 21);
INSERT INTO versification_data VALUES (NULL, 3, 19, 135, 26);
INSERT INTO versification_data VALUES (NULL, 3, 19, 136, 9);
INSERT INTO versification_data VALUES (NULL, 3, 19, 137, 8);
INSERT INTO versification_data VALUES (NULL, 3, 19, 138, 24);
INSERT INTO versification_data VALUES (NULL, 3, 19, 139, 14);
INSERT INTO versification_data VALUES (NULL, 3, 19, 140, 10);
INSERT INTO versification_data VALUES (NULL, 3, 19, 141, 8);
INSERT INTO versification_data VALUES (NULL, 3, 19, 142, 12);
INSERT INTO versification_data VALUES (NULL, 3, 19, 143, 15);
INSERT INTO versification_data VALUES (NULL, 3, 19, 144, 21);
INSERT INTO versification_data VALUES (NULL, 3, 19, 145, 10);
INSERT INTO versification_data VALUES (NULL, 3, 19, 146, 11);
INSERT INTO versification_data VALUES (NULL, 3, 19, 147, 20);
INSERT INTO versification_data VALUES (NULL, 3, 19, 148, 14);
INSERT INTO versification_data VALUES (NULL, 3, 19, 149, 9);
INSERT INTO versification_data VALUES (NULL, 3, 19, 150, 6);
INSERT INTO versification_data VALUES (NULL, 3, 20, 1, 33);
INSERT INTO versification_data VALUES (NULL, 3, 20, 2, 22);
INSERT INTO versification_data VALUES (NULL, 3, 20, 3, 35);
INSERT INTO versification_data VALUES (NULL, 3, 20, 4, 27);
INSERT INTO versification_data VALUES (NULL, 3, 20, 5, 23);
INSERT INTO versification_data VALUES (NULL, 3, 20, 6, 35);
INSERT INTO versification_data VALUES (NULL, 3, 20, 7, 27);
INSERT INTO versification_data VALUES (NULL, 3, 20, 8, 36);
INSERT INTO versification_data VALUES (NULL, 3, 20, 9, 18);
INSERT INTO versification_data VALUES (NULL, 3, 20, 10, 32);
INSERT INTO versification_data VALUES (NULL, 3, 20, 11, 31);
INSERT INTO versification_data VALUES (NULL, 3, 20, 12, 28);
INSERT INTO versification_data VALUES (NULL, 3, 20, 13, 25);
INSERT INTO versification_data VALUES (NULL, 3, 20, 14, 35);
INSERT INTO versification_data VALUES (NULL, 3, 20, 15, 33);
INSERT INTO versification_data VALUES (NULL, 3, 20, 16, 33);
INSERT INTO versification_data VALUES (NULL, 3, 20, 17, 28);
INSERT INTO versification_data VALUES (NULL, 3, 20, 18, 24);
INSERT INTO versification_data VALUES (NULL, 3, 20, 19, 29);
INSERT INTO versification_data VALUES (NULL, 3, 20, 20, 30);
INSERT INTO versification_data VALUES (NULL, 3, 20, 21, 31);
INSERT INTO versification_data VALUES (NULL, 3, 20, 22, 29);
INSERT INTO versification_data VALUES (NULL, 3, 20, 23, 35);
INSERT INTO versification_data VALUES (NULL, 3, 20, 24, 34);
INSERT INTO versification_data VALUES (NULL, 3, 20, 25, 28);
INSERT INTO versification_data VALUES (NULL, 3, 20, 26, 28);
INSERT INTO versification_data VALUES (NULL, 3, 20, 27, 27);
INSERT INTO versification_data VALUES (NULL, 3, 20, 28, 28);
INSERT INTO versification_data VALUES (NULL, 3, 20, 29, 27);
INSERT INTO versification_data VALUES (NULL, 3, 20, 30, 33);
INSERT INTO versification_data VALUES (NULL, 3, 20, 31, 31);
INSERT INTO versification_data VALUES (NULL, 3, 21, 1, 18);
INSERT INTO versification_data VALUES (NULL, 3, 21, 2, 26);
INSERT INTO versification_data VALUES (NULL, 3, 21, 3, 22);
INSERT INTO versification_data VALUES (NULL, 3, 21, 4, 17);
INSERT INTO versification_data VALUES (NULL, 3, 21, 5, 19);
INSERT INTO versification_data VALUES (NULL, 3, 21, 6, 11);
INSERT INTO versification_data VALUES (NULL, 3, 21, 7, 30);
INSERT INTO versification_data VALUES (NULL, 3, 21, 8, 17);
INSERT INTO versification_data VALUES (NULL, 3, 21, 9, 18);
INSERT INTO versification_data VALUES (NULL, 3, 21, 10, 20);
INSERT INTO versification_data VALUES (NULL, 3, 21, 11, 10);
INSERT INTO versification_data VALUES (NULL, 3, 21, 12, 14);
INSERT INTO versification_data VALUES (NULL, 3, 22, 1, 16);
INSERT INTO versification_data VALUES (NULL, 3, 22, 2, 17);
INSERT INTO versification_data VALUES (NULL, 3, 22, 3, 11);
INSERT INTO versification_data VALUES (NULL, 3, 22, 4, 16);
INSERT INTO versification_data VALUES (NULL, 3, 22, 5, 17);
INSERT INTO versification_data VALUES (NULL, 3, 22, 6, 12);
INSERT INTO versification_data VALUES (NULL, 3, 22, 7, 13);
INSERT INTO versification_data VALUES (NULL, 3, 22, 8, 14);
INSERT INTO versification_data VALUES (NULL, 3, 23, 1, 31);
INSERT INTO versification_data VALUES (NULL, 3, 23, 2, 22);
INSERT INTO versification_data VALUES (NULL, 3, 23, 3, 26);
INSERT INTO versification_data VALUES (NULL, 3, 23, 4, 6);
INSERT INTO versification_data VALUES (NULL, 3, 23, 5, 30);
INSERT INTO versification_data VALUES (NULL, 3, 23, 6, 13);
INSERT INTO versification_data VALUES (NULL, 3, 23, 7, 25);
INSERT INTO versification_data VALUES (NULL, 3, 23, 8, 22);
INSERT INTO versification_data VALUES (NULL, 3, 23, 9, 21);
INSERT INTO versification_data VALUES (NULL, 3, 23, 10, 34);
INSERT INTO versification_data VALUES (NULL, 3, 23, 11, 16);
INSERT INTO versification_data VALUES (NULL, 3, 23, 12, 6);
INSERT INTO versification_data VALUES (NULL, 3, 23, 13, 22);
INSERT INTO versification_data VALUES (NULL, 3, 23, 14, 32);
INSERT INTO versification_data VALUES (NULL, 3, 23, 15, 9);
INSERT INTO versification_data VALUES (NULL, 3, 23, 16, 14);
INSERT INTO versification_data VALUES (NULL, 3, 23, 17, 14);
INSERT INTO versification_data VALUES (NULL, 3, 23, 18, 7);
INSERT INTO versification_data VALUES (NULL, 3, 23, 19, 25);
INSERT INTO versification_data VALUES (NULL, 3, 23, 20, 6);
INSERT INTO versification_data VALUES (NULL, 3, 23, 21, 17);
INSERT INTO versification_data VALUES (NULL, 3, 23, 22, 25);
INSERT INTO versification_data VALUES (NULL, 3, 23, 23, 18);
INSERT INTO versification_data VALUES (NULL, 3, 23, 24, 23);
INSERT INTO versification_data VALUES (NULL, 3, 23, 25, 12);
INSERT INTO versification_data VALUES (NULL, 3, 23, 26, 21);
INSERT INTO versification_data VALUES (NULL, 3, 23, 27, 13);
INSERT INTO versification_data VALUES (NULL, 3, 23, 28, 29);
INSERT INTO versification_data VALUES (NULL, 3, 23, 29, 24);
INSERT INTO versification_data VALUES (NULL, 3, 23, 30, 33);
INSERT INTO versification_data VALUES (NULL, 3, 23, 31, 9);
INSERT INTO versification_data VALUES (NULL, 3, 23, 32, 20);
INSERT INTO versification_data VALUES (NULL, 3, 23, 33, 24);
INSERT INTO versification_data VALUES (NULL, 3, 23, 34, 17);
INSERT INTO versification_data VALUES (NULL, 3, 23, 35, 10);
INSERT INTO versification_data VALUES (NULL, 3, 23, 36, 22);
INSERT INTO versification_data VALUES (NULL, 3, 23, 37, 38);
INSERT INTO versification_data VALUES (NULL, 3, 23, 38, 22);
INSERT INTO versification_data VALUES (NULL, 3, 23, 39, 8);
INSERT INTO versification_data VALUES (NULL, 3, 23, 40, 31);
INSERT INTO versification_data VALUES (NULL, 3, 23, 41, 29);
INSERT INTO versification_data VALUES (NULL, 3, 23, 42, 25);
INSERT INTO versification_data VALUES (NULL, 3, 23, 43, 28);
INSERT INTO versification_data VALUES (NULL, 3, 23, 44, 28);
INSERT INTO versification_data VALUES (NULL, 3, 23, 45, 25);
INSERT INTO versification_data VALUES (NULL, 3, 23, 46, 13);
INSERT INTO versification_data VALUES (NULL, 3, 23, 47, 15);
INSERT INTO versification_data VALUES (NULL, 3, 23, 48, 22);
INSERT INTO versification_data VALUES (NULL, 3, 23, 49, 26);
INSERT INTO versification_data VALUES (NULL, 3, 23, 50, 11);
INSERT INTO versification_data VALUES (NULL, 3, 23, 51, 23);
INSERT INTO versification_data VALUES (NULL, 3, 23, 52, 15);
INSERT INTO versification_data VALUES (NULL, 3, 23, 53, 12);
INSERT INTO versification_data VALUES (NULL, 3, 23, 54, 17);
INSERT INTO versification_data VALUES (NULL, 3, 23, 55, 13);
INSERT INTO versification_data VALUES (NULL, 3, 23, 56, 12);
INSERT INTO versification_data VALUES (NULL, 3, 23, 57, 21);
INSERT INTO versification_data VALUES (NULL, 3, 23, 58, 14);
INSERT INTO versification_data VALUES (NULL, 3, 23, 59, 21);
INSERT INTO versification_data VALUES (NULL, 3, 23, 60, 22);
INSERT INTO versification_data VALUES (NULL, 3, 23, 61, 11);
INSERT INTO versification_data VALUES (NULL, 3, 23, 62, 12);
INSERT INTO versification_data VALUES (NULL, 3, 23, 63, 19);
INSERT INTO versification_data VALUES (NULL, 3, 23, 64, 12);
INSERT INTO versification_data VALUES (NULL, 3, 23, 65, 25);
INSERT INTO versification_data VALUES (NULL, 3, 23, 66, 24);
INSERT INTO versification_data VALUES (NULL, 3, 24, 1, 19);
INSERT INTO versification_data VALUES (NULL, 3, 24, 2, 37);
INSERT INTO versification_data VALUES (NULL, 3, 24, 3, 25);
INSERT INTO versification_data VALUES (NULL, 3, 24, 4, 31);
INSERT INTO versification_data VALUES (NULL, 3, 24, 5, 31);
INSERT INTO versification_data VALUES (NULL, 3, 24, 6, 30);
INSERT INTO versification_data VALUES (NULL, 3, 24, 7, 34);
INSERT INTO versification_data VALUES (NULL, 3, 24, 8, 22);
INSERT INTO versification_data VALUES (NULL, 3, 24, 9, 26);
INSERT INTO versification_data VALUES (NULL, 3, 24, 10, 25);
INSERT INTO versification_data VALUES (NULL, 3, 24, 11, 23);
INSERT INTO versification_data VALUES (NULL, 3, 24, 12, 17);
INSERT INTO versification_data VALUES (NULL, 3, 24, 13, 27);
INSERT INTO versification_data VALUES (NULL, 3, 24, 14, 22);
INSERT INTO versification_data VALUES (NULL, 3, 24, 15, 21);
INSERT INTO versification_data VALUES (NULL, 3, 24, 16, 21);
INSERT INTO versification_data VALUES (NULL, 3, 24, 17, 27);
INSERT INTO versification_data VALUES (NULL, 3, 24, 18, 23);
INSERT INTO versification_data VALUES (NULL, 3, 24, 19, 15);
INSERT INTO versification_data VALUES (NULL, 3, 24, 20, 18);
INSERT INTO versification_data VALUES (NULL, 3, 24, 21, 14);
INSERT INTO versification_data VALUES (NULL, 3, 24, 22, 30);
INSERT INTO versification_data VALUES (NULL, 3, 24, 23, 40);
INSERT INTO versification_data VALUES (NULL, 3, 24, 24, 10);
INSERT INTO versification_data VALUES (NULL, 3, 24, 25, 38);
INSERT INTO versification_data VALUES (NULL, 3, 24, 26, 24);
INSERT INTO versification_data VALUES (NULL, 3, 24, 27, 22);
INSERT INTO versification_data VALUES (NULL, 3, 24, 28, 17);
INSERT INTO versification_data VALUES (NULL, 3, 24, 29, 32);
INSERT INTO versification_data VALUES (NULL, 3, 24, 30, 24);
INSERT INTO versification_data VALUES (NULL, 3, 24, 31, 40);
INSERT INTO versification_data VALUES (NULL, 3, 24, 32, 44);
INSERT INTO versification_data VALUES (NULL, 3, 24, 33, 26);
INSERT INTO versification_data VALUES (NULL, 3, 24, 34, 22);
INSERT INTO versification_data VALUES (NULL, 3, 24, 35, 19);
INSERT INTO versification_data VALUES (NULL, 3, 24, 36, 32);
INSERT INTO versification_data VALUES (NULL, 3, 24, 37, 20);
INSERT INTO versification_data VALUES (NULL, 3, 24, 38, 28);
INSERT INTO versification_data VALUES (NULL, 3, 24, 39, 18);
INSERT INTO versification_data VALUES (NULL, 3, 24, 40, 16);
INSERT INTO versification_data VALUES (NULL, 3, 24, 41, 18);
INSERT INTO versification_data VALUES (NULL, 3, 24, 42, 22);
INSERT INTO versification_data VALUES (NULL, 3, 24, 43, 13);
INSERT INTO versification_data VALUES (NULL, 3, 24, 44, 30);
INSERT INTO versification_data VALUES (NULL, 3, 24, 45, 5);
INSERT INTO versification_data VALUES (NULL, 3, 24, 46, 28);
INSERT INTO versification_data VALUES (NULL, 3, 24, 47, 7);
INSERT INTO versification_data VALUES (NULL, 3, 24, 48, 47);
INSERT INTO versification_data VALUES (NULL, 3, 24, 49, 39);
INSERT INTO versification_data VALUES (NULL, 3, 24, 50, 46);
INSERT INTO versification_data VALUES (NULL, 3, 24, 51, 64);
INSERT INTO versification_data VALUES (NULL, 3, 24, 52, 34);
INSERT INTO versification_data VALUES (NULL, 3, 25, 1, 22);
INSERT INTO versification_data VALUES (NULL, 3, 25, 2, 22);
INSERT INTO versification_data VALUES (NULL, 3, 25, 3, 66);
INSERT INTO versification_data VALUES (NULL, 3, 25, 4, 22);
INSERT INTO versification_data VALUES (NULL, 3, 25, 5, 22);
INSERT INTO versification_data VALUES (NULL, 3, 26, 1, 28);
INSERT INTO versification_data VALUES (NULL, 3, 26, 2, 9);
INSERT INTO versification_data VALUES (NULL, 3, 26, 3, 27);
INSERT INTO versification_data VALUES (NULL, 3, 26, 4, 17);
INSERT INTO versification_data VALUES (NULL, 3, 26, 5, 17);
INSERT INTO versification_data VALUES (NULL, 3, 26, 6, 14);
INSERT INTO versification_data VALUES (NULL, 3, 26, 7, 27);
INSERT INTO versification_data VALUES (NULL, 3, 26, 8, 18);
INSERT INTO versification_data VALUES (NULL, 3, 26, 9, 11);
INSERT INTO versification_data VALUES (NULL, 3, 26, 10, 22);
INSERT INTO versification_data VALUES (NULL, 3, 26, 11, 25);
INSERT INTO versification_data VALUES (NULL, 3, 26, 12, 28);
INSERT INTO versification_data VALUES (NULL, 3, 26, 13, 23);
INSERT INTO versification_data VALUES (NULL, 3, 26, 14, 23);
INSERT INTO versification_data VALUES (NULL, 3, 26, 15, 8);
INSERT INTO versification_data VALUES (NULL, 3, 26, 16, 63);
INSERT INTO versification_data VALUES (NULL, 3, 26, 17, 24);
INSERT INTO versification_data VALUES (NULL, 3, 26, 18, 32);
INSERT INTO versification_data VALUES (NULL, 3, 26, 19, 14);
INSERT INTO versification_data VALUES (NULL, 3, 26, 20, 49);
INSERT INTO versification_data VALUES (NULL, 3, 26, 21, 32);
INSERT INTO versification_data VALUES (NULL, 3, 26, 22, 31);
INSERT INTO versification_data VALUES (NULL, 3, 26, 23, 49);
INSERT INTO versification_data VALUES (NULL, 3, 26, 24, 27);
INSERT INTO versification_data VALUES (NULL, 3, 26, 25, 17);
INSERT INTO versification_data VALUES (NULL, 3, 26, 26, 21);
INSERT INTO versification_data VALUES (NULL, 3, 26, 27, 36);
INSERT INTO versification_data VALUES (NULL, 3, 26, 28, 26);
INSERT INTO versification_data VALUES (NULL, 3, 26, 29, 21);
INSERT INTO versification_data VALUES (NULL, 3, 26, 30, 26);
INSERT INTO versification_data VALUES (NULL, 3, 26, 31, 18);
INSERT INTO versification_data VALUES (NULL, 3, 26, 32, 32);
INSERT INTO versification_data VALUES (NULL, 3, 26, 33, 33);
INSERT INTO versification_data VALUES (NULL, 3, 26, 34, 31);
INSERT INTO versification_data VALUES (NULL, 3, 26, 35, 15);
INSERT INTO versification_data VALUES (NULL, 3, 26, 36, 38);
INSERT INTO versification_data VALUES (NULL, 3, 26, 37, 28);
INSERT INTO versification_data VALUES (NULL, 3, 26, 38, 23);
INSERT INTO versification_data VALUES (NULL, 3, 26, 39, 29);
INSERT INTO versification_data VALUES (NULL, 3, 26, 40, 49);
INSERT INTO versification_data VALUES (NULL, 3, 26, 41, 26);
INSERT INTO versification_data VALUES (NULL, 3, 26, 42, 20);
INSERT INTO versification_data VALUES (NULL, 3, 26, 43, 27);
INSERT INTO versification_data VALUES (NULL, 3, 26, 44, 31);
INSERT INTO versification_data VALUES (NULL, 3, 26, 45, 25);
INSERT INTO versification_data VALUES (NULL, 3, 26, 46, 24);
INSERT INTO versification_data VALUES (NULL, 3, 26, 47, 23);
INSERT INTO versification_data VALUES (NULL, 3, 26, 48, 35);
INSERT INTO versification_data VALUES (NULL, 3, 27, 1, 21);
INSERT INTO versification_data VALUES (NULL, 3, 27, 2, 49);
INSERT INTO versification_data VALUES (NULL, 3, 27, 3, 100);
INSERT INTO versification_data VALUES (NULL, 3, 27, 4, 34);
INSERT INTO versification_data VALUES (NULL, 3, 27, 5, 31);
INSERT INTO versification_data VALUES (NULL, 3, 27, 6, 28);
INSERT INTO versification_data VALUES (NULL, 3, 27, 7, 28);
INSERT INTO versification_data VALUES (NULL, 3, 27, 8, 27);
INSERT INTO versification_data VALUES (NULL, 3, 27, 9, 27);
INSERT INTO versification_data VALUES (NULL, 3, 27, 10, 21);
INSERT INTO versification_data VALUES (NULL, 3, 27, 11, 45);
INSERT INTO versification_data VALUES (NULL, 3, 27, 12, 13);
INSERT INTO versification_data VALUES (NULL, 3, 27, 13, 65);
INSERT INTO versification_data VALUES (NULL, 3, 27, 14, 41);
INSERT INTO versification_data VALUES (NULL, 3, 28, 1, 11);
INSERT INTO versification_data VALUES (NULL, 3, 28, 2, 24);
INSERT INTO versification_data VALUES (NULL, 3, 28, 3, 5);
INSERT INTO versification_data VALUES (NULL, 3, 28, 4, 19);
INSERT INTO versification_data VALUES (NULL, 3, 28, 5, 15);
INSERT INTO versification_data VALUES (NULL, 3, 28, 6, 11);
INSERT INTO versification_data VALUES (NULL, 3, 28, 7, 16);
INSERT INTO versification_data VALUES (NULL, 3, 28, 8, 14);
INSERT INTO versification_data VALUES (NULL, 3, 28, 9, 17);
INSERT INTO versification_data VALUES (NULL, 3, 28, 10, 15);
INSERT INTO versification_data VALUES (NULL, 3, 28, 11, 12);
INSERT INTO versification_data VALUES (NULL, 3, 28, 12, 14);
INSERT INTO versification_data VALUES (NULL, 3, 28, 13, 15);
INSERT INTO versification_data VALUES (NULL, 3, 28, 14, 10);
INSERT INTO versification_data VALUES (NULL, 3, 29, 1, 20);
INSERT INTO versification_data VALUES (NULL, 3, 29, 2, 32);
INSERT INTO versification_data VALUES (NULL, 3, 29, 3, 21);
INSERT INTO versification_data VALUES (NULL, 3, 30, 1, 15);
INSERT INTO versification_data VALUES (NULL, 3, 30, 2, 16);
INSERT INTO versification_data VALUES (NULL, 3, 30, 3, 15);
INSERT INTO versification_data VALUES (NULL, 3, 30, 4, 13);
INSERT INTO versification_data VALUES (NULL, 3, 30, 5, 27);
INSERT INTO versification_data VALUES (NULL, 3, 30, 6, 15);
INSERT INTO versification_data VALUES (NULL, 3, 30, 7, 17);
INSERT INTO versification_data VALUES (NULL, 3, 30, 8, 14);
INSERT INTO versification_data VALUES (NULL, 3, 30, 9, 15);
INSERT INTO versification_data VALUES (NULL, 3, 31, 1, 21);
INSERT INTO versification_data VALUES (NULL, 3, 32, 1, 16);
INSERT INTO versification_data VALUES (NULL, 3, 32, 2, 11);
INSERT INTO versification_data VALUES (NULL, 3, 32, 3, 10);
INSERT INTO versification_data VALUES (NULL, 3, 32, 4, 11);
INSERT INTO versification_data VALUES (NULL, 3, 33, 1, 16);
INSERT INTO versification_data VALUES (NULL, 3, 33, 2, 13);
INSERT INTO versification_data VALUES (NULL, 3, 33, 3, 12);
INSERT INTO versification_data VALUES (NULL, 3, 33, 4, 13);
INSERT INTO versification_data VALUES (NULL, 3, 33, 5, 14);
INSERT INTO versification_data VALUES (NULL, 3, 33, 6, 16);
INSERT INTO versification_data VALUES (NULL, 3, 33, 7, 20);
INSERT INTO versification_data VALUES (NULL, 3, 34, 1, 15);
INSERT INTO versification_data VALUES (NULL, 3, 34, 2, 13);
INSERT INTO versification_data VALUES (NULL, 3, 34, 3, 19);
INSERT INTO versification_data VALUES (NULL, 3, 35, 1, 17);
INSERT INTO versification_data VALUES (NULL, 3, 35, 2, 20);
INSERT INTO versification_data VALUES (NULL, 3, 35, 3, 19);
INSERT INTO versification_data VALUES (NULL, 3, 36, 1, 18);
INSERT INTO versification_data VALUES (NULL, 3, 36, 2, 15);
INSERT INTO versification_data VALUES (NULL, 3, 36, 3, 20);
INSERT INTO versification_data VALUES (NULL, 3, 37, 1, 14);
INSERT INTO versification_data VALUES (NULL, 3, 37, 2, 24);
INSERT INTO versification_data VALUES (NULL, 3, 38, 1, 21);
INSERT INTO versification_data VALUES (NULL, 3, 38, 2, 13);
INSERT INTO versification_data VALUES (NULL, 3, 38, 3, 10);
INSERT INTO versification_data VALUES (NULL, 3, 38, 4, 14);
INSERT INTO versification_data VALUES (NULL, 3, 38, 5, 11);
INSERT INTO versification_data VALUES (NULL, 3, 38, 6, 15);
INSERT INTO versification_data VALUES (NULL, 3, 38, 7, 14);
INSERT INTO versification_data VALUES (NULL, 3, 38, 8, 23);
INSERT INTO versification_data VALUES (NULL, 3, 38, 9, 17);
INSERT INTO versification_data VALUES (NULL, 3, 38, 10, 12);
INSERT INTO versification_data VALUES (NULL, 3, 38, 11, 17);
INSERT INTO versification_data VALUES (NULL, 3, 38, 12, 14);
INSERT INTO versification_data VALUES (NULL, 3, 38, 13, 9);
INSERT INTO versification_data VALUES (NULL, 3, 38, 14, 21);
INSERT INTO versification_data VALUES (NULL, 3, 39, 1, 14);
INSERT INTO versification_data VALUES (NULL, 3, 39, 2, 17);
INSERT INTO versification_data VALUES (NULL, 3, 39, 3, 18);
INSERT INTO versification_data VALUES (NULL, 3, 39, 4, 6);
INSERT INTO versification_data VALUES (NULL, 3, 40, 1, 25);
INSERT INTO versification_data VALUES (NULL, 3, 40, 2, 23);
INSERT INTO versification_data VALUES (NULL, 3, 40, 3, 17);
INSERT INTO versification_data VALUES (NULL, 3, 40, 4, 25);
INSERT INTO versification_data VALUES (NULL, 3, 40, 5, 48);
INSERT INTO versification_data VALUES (NULL, 3, 40, 6, 34);
INSERT INTO versification_data VALUES (NULL, 3, 40, 7, 29);
INSERT INTO versification_data VALUES (NULL, 3, 40, 8, 34);
INSERT INTO versification_data VALUES (NULL, 3, 40, 9, 38);
INSERT INTO versification_data VALUES (NULL, 3, 40, 10, 42);
INSERT INTO versification_data VALUES (NULL, 3, 40, 11, 30);
INSERT INTO versification_data VALUES (NULL, 3, 40, 12, 50);
INSERT INTO versification_data VALUES (NULL, 3, 40, 13, 58);
INSERT INTO versification_data VALUES (NULL, 3, 40, 14, 36);
INSERT INTO versification_data VALUES (NULL, 3, 40, 15, 39);
INSERT INTO versification_data VALUES (NULL, 3, 40, 16, 28);
INSERT INTO versification_data VALUES (NULL, 3, 40, 17, 26);
INSERT INTO versification_data VALUES (NULL, 3, 40, 18, 35);
INSERT INTO versification_data VALUES (NULL, 3, 40, 19, 30);
INSERT INTO versification_data VALUES (NULL, 3, 40, 20, 34);
INSERT INTO versification_data VALUES (NULL, 3, 40, 21, 46);
INSERT INTO versification_data VALUES (NULL, 3, 40, 22, 46);
INSERT INTO versification_data VALUES (NULL, 3, 40, 23, 39);
INSERT INTO versification_data VALUES (NULL, 3, 40, 24, 51);
INSERT INTO versification_data VALUES (NULL, 3, 40, 25, 46);
INSERT INTO versification_data VALUES (NULL, 3, 40, 26, 75);
INSERT INTO versification_data VALUES (NULL, 3, 40, 27, 66);
INSERT INTO versification_data VALUES (NULL, 3, 40, 28, 20);
INSERT INTO versification_data VALUES (NULL, 3, 41, 1, 45);
INSERT INTO versification_data VALUES (NULL, 3, 41, 2, 28);
INSERT INTO versification_data VALUES (NULL, 3, 41, 3, 35);
INSERT INTO versification_data VALUES (NULL, 3, 41, 4, 40);
INSERT INTO versification_data VALUES (NULL, 3, 41, 5, 43);
INSERT INTO versification_data VALUES (NULL, 3, 41, 6, 56);
INSERT INTO versification_data VALUES (NULL, 3, 41, 7, 37);
INSERT INTO versification_data VALUES (NULL, 3, 41, 8, 39);
INSERT INTO versification_data VALUES (NULL, 3, 41, 9, 49);
INSERT INTO versification_data VALUES (NULL, 3, 41, 10, 52);
INSERT INTO versification_data VALUES (NULL, 3, 41, 11, 33);
INSERT INTO versification_data VALUES (NULL, 3, 41, 12, 44);
INSERT INTO versification_data VALUES (NULL, 3, 41, 13, 37);
INSERT INTO versification_data VALUES (NULL, 3, 41, 14, 72);
INSERT INTO versification_data VALUES (NULL, 3, 41, 15, 47);
INSERT INTO versification_data VALUES (NULL, 3, 41, 16, 20);
INSERT INTO versification_data VALUES (NULL, 3, 42, 1, 80);
INSERT INTO versification_data VALUES (NULL, 3, 42, 2, 52);
INSERT INTO versification_data VALUES (NULL, 3, 42, 3, 38);
INSERT INTO versification_data VALUES (NULL, 3, 42, 4, 44);
INSERT INTO versification_data VALUES (NULL, 3, 42, 5, 39);
INSERT INTO versification_data VALUES (NULL, 3, 42, 6, 49);
INSERT INTO versification_data VALUES (NULL, 3, 42, 7, 50);
INSERT INTO versification_data VALUES (NULL, 3, 42, 8, 56);
INSERT INTO versification_data VALUES (NULL, 3, 42, 9, 62);
INSERT INTO versification_data VALUES (NULL, 3, 42, 10, 42);
INSERT INTO versification_data VALUES (NULL, 3, 42, 11, 54);
INSERT INTO versification_data VALUES (NULL, 3, 42, 12, 59);
INSERT INTO versification_data VALUES (NULL, 3, 42, 13, 35);
INSERT INTO versification_data VALUES (NULL, 3, 42, 14, 35);
INSERT INTO versification_data VALUES (NULL, 3, 42, 15, 32);
INSERT INTO versification_data VALUES (NULL, 3, 42, 16, 31);
INSERT INTO versification_data VALUES (NULL, 3, 42, 17, 37);
INSERT INTO versification_data VALUES (NULL, 3, 42, 18, 43);
INSERT INTO versification_data VALUES (NULL, 3, 42, 19, 48);
INSERT INTO versification_data VALUES (NULL, 3, 42, 20, 47);
INSERT INTO versification_data VALUES (NULL, 3, 42, 21, 38);
INSERT INTO versification_data VALUES (NULL, 3, 42, 22, 71);
INSERT INTO versification_data VALUES (NULL, 3, 42, 23, 56);
INSERT INTO versification_data VALUES (NULL, 3, 42, 24, 53);
INSERT INTO versification_data VALUES (NULL, 3, 43, 1, 51);
INSERT INTO versification_data VALUES (NULL, 3, 43, 2, 25);
INSERT INTO versification_data VALUES (NULL, 3, 43, 3, 36);
INSERT INTO versification_data VALUES (NULL, 3, 43, 4, 54);
INSERT INTO versification_data VALUES (NULL, 3, 43, 5, 47);
INSERT INTO versification_data VALUES (NULL, 3, 43, 6, 72);
INSERT INTO versification_data VALUES (NULL, 3, 43, 7, 53);
INSERT INTO versification_data VALUES (NULL, 3, 43, 8, 59);
INSERT INTO versification_data VALUES (NULL, 3, 43, 9, 41);
INSERT INTO versification_data VALUES (NULL, 3, 43, 10, 42);
INSERT INTO versification_data VALUES (NULL, 3, 43, 11, 57);
INSERT INTO versification_data VALUES (NULL, 3, 43, 12, 50);
INSERT INTO versification_data VALUES (NULL, 3, 43, 13, 38);
INSERT INTO versification_data VALUES (NULL, 3, 43, 14, 31);
INSERT INTO versification_data VALUES (NULL, 3, 43, 15, 27);
INSERT INTO versification_data VALUES (NULL, 3, 43, 16, 33);
INSERT INTO versification_data VALUES (NULL, 3, 43, 17, 26);
INSERT INTO versification_data VALUES (NULL, 3, 43, 18, 40);
INSERT INTO versification_data VALUES (NULL, 3, 43, 19, 42);
INSERT INTO versification_data VALUES (NULL, 3, 43, 20, 31);
INSERT INTO versification_data VALUES (NULL, 3, 43, 21, 25);
INSERT INTO versification_data VALUES (NULL, 3, 44, 1, 26);
INSERT INTO versification_data VALUES (NULL, 3, 44, 2, 47);
INSERT INTO versification_data VALUES (NULL, 3, 44, 3, 26);
INSERT INTO versification_data VALUES (NULL, 3, 44, 4, 37);
INSERT INTO versification_data VALUES (NULL, 3, 44, 5, 42);
INSERT INTO versification_data VALUES (NULL, 3, 44, 6, 15);
INSERT INTO versification_data VALUES (NULL, 3, 44, 7, 59);
INSERT INTO versification_data VALUES (NULL, 3, 44, 8, 40);
INSERT INTO versification_data VALUES (NULL, 3, 44, 9, 43);
INSERT INTO versification_data VALUES (NULL, 3, 44, 10, 48);
INSERT INTO versification_data VALUES (NULL, 3, 44, 11, 30);
INSERT INTO versification_data VALUES (NULL, 3, 44, 12, 25);
INSERT INTO versification_data VALUES (NULL, 3, 44, 13, 52);
INSERT INTO versification_data VALUES (NULL, 3, 44, 14, 27);
INSERT INTO versification_data VALUES (NULL, 3, 44, 15, 41);
INSERT INTO versification_data VALUES (NULL, 3, 44, 16, 40);
INSERT INTO versification_data VALUES (NULL, 3, 44, 17, 34);
INSERT INTO versification_data VALUES (NULL, 3, 44, 18, 28);
INSERT INTO versification_data VALUES (NULL, 3, 44, 19, 40);
INSERT INTO versification_data VALUES (NULL, 3, 44, 20, 38);
INSERT INTO versification_data VALUES (NULL, 3, 44, 21, 40);
INSERT INTO versification_data VALUES (NULL, 3, 44, 22, 30);
INSERT INTO versification_data VALUES (NULL, 3, 44, 23, 35);
INSERT INTO versification_data VALUES (NULL, 3, 44, 24, 27);
INSERT INTO versification_data VALUES (NULL, 3, 44, 25, 27);
INSERT INTO versification_data VALUES (NULL, 3, 44, 26, 32);
INSERT INTO versification_data VALUES (NULL, 3, 44, 27, 44);
INSERT INTO versification_data VALUES (NULL, 3, 44, 28, 31);
INSERT INTO versification_data VALUES (NULL, 3, 45, 1, 32);
INSERT INTO versification_data VALUES (NULL, 3, 45, 2, 29);
INSERT INTO versification_data VALUES (NULL, 3, 45, 3, 31);
INSERT INTO versification_data VALUES (NULL, 3, 45, 4, 25);
INSERT INTO versification_data VALUES (NULL, 3, 45, 5, 21);
INSERT INTO versification_data VALUES (NULL, 3, 45, 6, 23);
INSERT INTO versification_data VALUES (NULL, 3, 45, 7, 25);
INSERT INTO versification_data VALUES (NULL, 3, 45, 8, 39);
INSERT INTO versification_data VALUES (NULL, 3, 45, 9, 33);
INSERT INTO versification_data VALUES (NULL, 3, 45, 10, 21);
INSERT INTO versification_data VALUES (NULL, 3, 45, 11, 36);
INSERT INTO versification_data VALUES (NULL, 3, 45, 12, 21);
INSERT INTO versification_data VALUES (NULL, 3, 45, 13, 14);
INSERT INTO versification_data VALUES (NULL, 3, 45, 14, 23);
INSERT INTO versification_data VALUES (NULL, 3, 45, 15, 33);
INSERT INTO versification_data VALUES (NULL, 3, 45, 16, 27);
INSERT INTO versification_data VALUES (NULL, 3, 46, 1, 31);
INSERT INTO versification_data VALUES (NULL, 3, 46, 2, 16);
INSERT INTO versification_data VALUES (NULL, 3, 46, 3, 23);
INSERT INTO versification_data VALUES (NULL, 3, 46, 4, 21);
INSERT INTO versification_data VALUES (NULL, 3, 46, 5, 13);
INSERT INTO versification_data VALUES (NULL, 3, 46, 6, 20);
INSERT INTO versification_data VALUES (NULL, 3, 46, 7, 40);
INSERT INTO versification_data VALUES (NULL, 3, 46, 8, 13);
INSERT INTO versification_data VALUES (NULL, 3, 46, 9, 27);
INSERT INTO versification_data VALUES (NULL, 3, 46, 10, 33);
INSERT INTO versification_data VALUES (NULL, 3, 46, 11, 34);
INSERT INTO versification_data VALUES (NULL, 3, 46, 12, 31);
INSERT INTO versification_data VALUES (NULL, 3, 46, 13, 13);
INSERT INTO versification_data VALUES (NULL, 3, 46, 14, 40);
INSERT INTO versification_data VALUES (NULL, 3, 46, 15, 58);
INSERT INTO versification_data VALUES (NULL, 3, 46, 16, 24);
INSERT INTO versification_data VALUES (NULL, 3, 47, 1, 24);
INSERT INTO versification_data VALUES (NULL, 3, 47, 2, 17);
INSERT INTO versification_data VALUES (NULL, 3, 47, 3, 18);
INSERT INTO versification_data VALUES (NULL, 3, 47, 4, 18);
INSERT INTO versification_data VALUES (NULL, 3, 47, 5, 21);
INSERT INTO versification_data VALUES (NULL, 3, 47, 6, 18);
INSERT INTO versification_data VALUES (NULL, 3, 47, 7, 16);
INSERT INTO versification_data VALUES (NULL, 3, 47, 8, 24);
INSERT INTO versification_data VALUES (NULL, 3, 47, 9, 15);
INSERT INTO versification_data VALUES (NULL, 3, 47, 10, 18);
INSERT INTO versification_data VALUES (NULL, 3, 47, 11, 33);
INSERT INTO versification_data VALUES (NULL, 3, 47, 12, 21);
INSERT INTO versification_data VALUES (NULL, 3, 47, 13, 13);
INSERT INTO versification_data VALUES (NULL, 3, 48, 1, 24);
INSERT INTO versification_data VALUES (NULL, 3, 48, 2, 21);
INSERT INTO versification_data VALUES (NULL, 3, 48, 3, 29);
INSERT INTO versification_data VALUES (NULL, 3, 48, 4, 31);
INSERT INTO versification_data VALUES (NULL, 3, 48, 5, 26);
INSERT INTO versification_data VALUES (NULL, 3, 48, 6, 18);
INSERT INTO versification_data VALUES (NULL, 3, 49, 1, 23);
INSERT INTO versification_data VALUES (NULL, 3, 49, 2, 22);
INSERT INTO versification_data VALUES (NULL, 3, 49, 3, 21);
INSERT INTO versification_data VALUES (NULL, 3, 49, 4, 32);
INSERT INTO versification_data VALUES (NULL, 3, 49, 5, 33);
INSERT INTO versification_data VALUES (NULL, 3, 49, 6, 24);
INSERT INTO versification_data VALUES (NULL, 3, 50, 1, 30);
INSERT INTO versification_data VALUES (NULL, 3, 50, 2, 30);
INSERT INTO versification_data VALUES (NULL, 3, 50, 3, 21);
INSERT INTO versification_data VALUES (NULL, 3, 50, 4, 23);
INSERT INTO versification_data VALUES (NULL, 3, 51, 1, 29);
INSERT INTO versification_data VALUES (NULL, 3, 51, 2, 23);
INSERT INTO versification_data VALUES (NULL, 3, 51, 3, 25);
INSERT INTO versification_data VALUES (NULL, 3, 51, 4, 18);
INSERT INTO versification_data VALUES (NULL, 3, 52, 1, 10);
INSERT INTO versification_data VALUES (NULL, 3, 52, 2, 20);
INSERT INTO versification_data VALUES (NULL, 3, 52, 3, 13);
INSERT INTO versification_data VALUES (NULL, 3, 52, 4, 18);
INSERT INTO versification_data VALUES (NULL, 3, 52, 5, 28);
INSERT INTO versification_data VALUES (NULL, 3, 53, 1, 12);
INSERT INTO versification_data VALUES (NULL, 3, 53, 2, 17);
INSERT INTO versification_data VALUES (NULL, 3, 53, 3, 18);
INSERT INTO versification_data VALUES (NULL, 3, 54, 1, 20);
INSERT INTO versification_data VALUES (NULL, 3, 54, 2, 15);
INSERT INTO versification_data VALUES (NULL, 3, 54, 3, 16);
INSERT INTO versification_data VALUES (NULL, 3, 54, 4, 16);
INSERT INTO versification_data VALUES (NULL, 3, 54, 5, 25);
INSERT INTO versification_data VALUES (NULL, 3, 54, 6, 21);
INSERT INTO versification_data VALUES (NULL, 3, 55, 1, 18);
INSERT INTO versification_data VALUES (NULL, 3, 55, 2, 26);
INSERT INTO versification_data VALUES (NULL, 3, 55, 3, 17);
INSERT INTO versification_data VALUES (NULL, 3, 55, 4, 22);
INSERT INTO versification_data VALUES (NULL, 3, 56, 1, 16);
INSERT INTO versification_data VALUES (NULL, 3, 56, 2, 15);
INSERT INTO versification_data VALUES (NULL, 3, 56, 3, 15);
INSERT INTO versification_data VALUES (NULL, 3, 57, 1, 25);
INSERT INTO versification_data VALUES (NULL, 3, 58, 1, 14);
INSERT INTO versification_data VALUES (NULL, 3, 58, 2, 18);
INSERT INTO versification_data VALUES (NULL, 3, 58, 3, 19);
INSERT INTO versification_data VALUES (NULL, 3, 58, 4, 16);
INSERT INTO versification_data VALUES (NULL, 3, 58, 5, 14);
INSERT INTO versification_data VALUES (NULL, 3, 58, 6, 20);
INSERT INTO versification_data VALUES (NULL, 3, 58, 7, 28);
INSERT INTO versification_data VALUES (NULL, 3, 58, 8, 13);
INSERT INTO versification_data VALUES (NULL, 3, 58, 9, 28);
INSERT INTO versification_data VALUES (NULL, 3, 58, 10, 39);
INSERT INTO versification_data VALUES (NULL, 3, 58, 11, 40);
INSERT INTO versification_data VALUES (NULL, 3, 58, 12, 29);
INSERT INTO versification_data VALUES (NULL, 3, 58, 13, 25);
INSERT INTO versification_data VALUES (NULL, 3, 59, 1, 27);
INSERT INTO versification_data VALUES (NULL, 3, 59, 2, 26);
INSERT INTO versification_data VALUES (NULL, 3, 59, 3, 18);
INSERT INTO versification_data VALUES (NULL, 3, 59, 4, 17);
INSERT INTO versification_data VALUES (NULL, 3, 59, 5, 20);
INSERT INTO versification_data VALUES (NULL, 3, 60, 1, 25);
INSERT INTO versification_data VALUES (NULL, 3, 60, 2, 25);
INSERT INTO versification_data VALUES (NULL, 3, 60, 3, 22);
INSERT INTO versification_data VALUES (NULL, 3, 60, 4, 19);
INSERT INTO versification_data VALUES (NULL, 3, 60, 5, 14);
INSERT INTO versification_data VALUES (NULL, 3, 61, 1, 21);
INSERT INTO versification_data VALUES (NULL, 3, 61, 2, 22);
INSERT INTO versification_data VALUES (NULL, 3, 61, 3, 18);
INSERT INTO versification_data VALUES (NULL, 3, 62, 1, 10);
INSERT INTO versification_data VALUES (NULL, 3, 62, 2, 29);
INSERT INTO versification_data VALUES (NULL, 3, 62, 3, 24);
INSERT INTO versification_data VALUES (NULL, 3, 62, 4, 21);
INSERT INTO versification_data VALUES (NULL, 3, 62, 5, 21);
INSERT INTO versification_data VALUES (NULL, 3, 63, 1, 13);
INSERT INTO versification_data VALUES (NULL, 3, 64, 1, 15);
INSERT INTO versification_data VALUES (NULL, 3, 65, 1, 25);
INSERT INTO versification_data VALUES (NULL, 3, 66, 1, 20);
INSERT INTO versification_data VALUES (NULL, 3, 66, 2, 29);
INSERT INTO versification_data VALUES (NULL, 3, 66, 3, 22);
INSERT INTO versification_data VALUES (NULL, 3, 66, 4, 11);
INSERT INTO versification_data VALUES (NULL, 3, 66, 5, 14);
INSERT INTO versification_data VALUES (NULL, 3, 66, 6, 17);
INSERT INTO versification_data VALUES (NULL, 3, 66, 7, 17);
INSERT INTO versification_data VALUES (NULL, 3, 66, 8, 13);
INSERT INTO versification_data VALUES (NULL, 3, 66, 9, 21);
INSERT INTO versification_data VALUES (NULL, 3, 66, 10, 11);
INSERT INTO versification_data VALUES (NULL, 3, 66, 11, 19);
INSERT INTO versification_data VALUES (NULL, 3, 66, 12, 18);
INSERT INTO versification_data VALUES (NULL, 3, 66, 13, 18);
INSERT INTO versification_data VALUES (NULL, 3, 66, 14, 20);
INSERT INTO versification_data VALUES (NULL, 3, 66, 15, 8);
INSERT INTO versification_data VALUES (NULL, 3, 66, 16, 21);
INSERT INTO versification_data VALUES (NULL, 3, 66, 17, 18);
INSERT INTO versification_data VALUES (NULL, 3, 66, 18, 24);
INSERT INTO versification_data VALUES (NULL, 3, 66, 19, 21);
INSERT INTO versification_data VALUES (NULL, 3, 66, 20, 15);
INSERT INTO versification_data VALUES (NULL, 3, 66, 21, 27);
INSERT INTO versification_data VALUES (NULL, 3, 66, 22, 21);

INSERT INTO versification_names VALUES (4, 'Russian Protestant');

INSERT INTO versification_data VALUES (NULL, 4, 1, 1, 31);
INSERT INTO versification_data VALUES (NULL, 4, 1, 2, 25);
INSERT INTO versification_data VALUES (NULL, 4, 1, 3, 24);
INSERT INTO versification_data VALUES (NULL, 4, 1, 4, 26);
INSERT INTO versification_data VALUES (NULL, 4, 1, 5, 32);
INSERT INTO versification_data VALUES (NULL, 4, 1, 6, 22);
INSERT INTO versification_data VALUES (NULL, 4, 1, 7, 24);
INSERT INTO versification_data VALUES (NULL, 4, 1, 8, 22);
INSERT INTO versification_data VALUES (NULL, 4, 1, 9, 29);
INSERT INTO versification_data VALUES (NULL, 4, 1, 10, 32);
INSERT INTO versification_data VALUES (NULL, 4, 1, 11, 32);
INSERT INTO versification_data VALUES (NULL, 4, 1, 12, 20);
INSERT INTO versification_data VALUES (NULL, 4, 1, 13, 18);
INSERT INTO versification_data VALUES (NULL, 4, 1, 14, 24);
INSERT INTO versification_data VALUES (NULL, 4, 1, 15, 21);
INSERT INTO versification_data VALUES (NULL, 4, 1, 16, 16);
INSERT INTO versification_data VALUES (NULL, 4, 1, 17, 27);
INSERT INTO versification_data VALUES (NULL, 4, 1, 18, 33);
INSERT INTO versification_data VALUES (NULL, 4, 1, 19, 38);
INSERT INTO versification_data VALUES (NULL, 4, 1, 20, 18);
INSERT INTO versification_data VALUES (NULL, 4, 1, 21, 34);
INSERT INTO versification_data VALUES (NULL, 4, 1, 22, 24);
INSERT INTO versification_data VALUES (NULL, 4, 1, 23, 20);
INSERT INTO versification_data VALUES (NULL, 4, 1, 24, 67);
INSERT INTO versification_data VALUES (NULL, 4, 1, 25, 34);
INSERT INTO versification_data VALUES (NULL, 4, 1, 26, 35);
INSERT INTO versification_data VALUES (NULL, 4, 1, 27, 46);
INSERT INTO versification_data VALUES (NULL, 4, 1, 28, 22);
INSERT INTO versification_data VALUES (NULL, 4, 1, 29, 35);
INSERT INTO versification_data VALUES (NULL, 4, 1, 30, 43);
INSERT INTO versification_data VALUES (NULL, 4, 1, 31, 55);
INSERT INTO versification_data VALUES (NULL, 4, 1, 32, 32);
INSERT INTO versification_data VALUES (NULL, 4, 1, 33, 20);
INSERT INTO versification_data VALUES (NULL, 4, 1, 34, 31);
INSERT INTO versification_data VALUES (NULL, 4, 1, 35, 29);
INSERT INTO versification_data VALUES (NULL, 4, 1, 36, 43);
INSERT INTO versification_data VALUES (NULL, 4, 1, 37, 36);
INSERT INTO versification_data VALUES (NULL, 4, 1, 38, 30);
INSERT INTO versification_data VALUES (NULL, 4, 1, 39, 23);
INSERT INTO versification_data VALUES (NULL, 4, 1, 40, 23);
INSERT INTO versification_data VALUES (NULL, 4, 1, 41, 57);
INSERT INTO versification_data VALUES (NULL, 4, 1, 42, 38);
INSERT INTO versification_data VALUES (NULL, 4, 1, 43, 34);
INSERT INTO versification_data VALUES (NULL, 4, 1, 44, 34);
INSERT INTO versification_data VALUES (NULL, 4, 1, 45, 28);
INSERT INTO versification_data VALUES (NULL, 4, 1, 46, 34);
INSERT INTO versification_data VALUES (NULL, 4, 1, 47, 31);
INSERT INTO versification_data VALUES (NULL, 4, 1, 48, 22);
INSERT INTO versification_data VALUES (NULL, 4, 1, 49, 33);
INSERT INTO versification_data VALUES (NULL, 4, 1, 50, 26);
INSERT INTO versification_data VALUES (NULL, 4, 2, 1, 22);
INSERT INTO versification_data VALUES (NULL, 4, 2, 2, 25);
INSERT INTO versification_data VALUES (NULL, 4, 2, 3, 22);
INSERT INTO versification_data VALUES (NULL, 4, 2, 4, 31);
INSERT INTO versification_data VALUES (NULL, 4, 2, 5, 23);
INSERT INTO versification_data VALUES (NULL, 4, 2, 6, 30);
INSERT INTO versification_data VALUES (NULL, 4, 2, 7, 25);
INSERT INTO versification_data VALUES (NULL, 4, 2, 8, 32);
INSERT INTO versification_data VALUES (NULL, 4, 2, 9, 35);
INSERT INTO versification_data VALUES (NULL, 4, 2, 10, 29);
INSERT INTO versification_data VALUES (NULL, 4, 2, 11, 10);
INSERT INTO versification_data VALUES (NULL, 4, 2, 12, 51);
INSERT INTO versification_data VALUES (NULL, 4, 2, 13, 22);
INSERT INTO versification_data VALUES (NULL, 4, 2, 14, 31);
INSERT INTO versification_data VALUES (NULL, 4, 2, 15, 27);
INSERT INTO versification_data VALUES (NULL, 4, 2, 16, 36);
INSERT INTO versification_data VALUES (NULL, 4, 2, 17, 16);
INSERT INTO versification_data VALUES (NULL, 4, 2, 18, 27);
INSERT INTO versification_data VALUES (NULL, 4, 2, 19, 25);
INSERT INTO versification_data VALUES (NULL, 4, 2, 20, 26);
INSERT INTO versification_data VALUES (NULL, 4, 2, 21, 36);
INSERT INTO versification_data VALUES (NULL, 4, 2, 22, 31);
INSERT INTO versification_data VALUES (NULL, 4, 2, 23, 33);
INSERT INTO versification_data VALUES (NULL, 4, 2, 24, 18);
INSERT INTO versification_data VALUES (NULL, 4, 2, 25, 40);
INSERT INTO versification_data VALUES (NULL, 4, 2, 26, 37);
INSERT INTO versification_data VALUES (NULL, 4, 2, 27, 21);
INSERT INTO versification_data VALUES (NULL, 4, 2, 28, 43);
INSERT INTO versification_data VALUES (NULL, 4, 2, 29, 46);
INSERT INTO versification_data VALUES (NULL, 4, 2, 30, 38);
INSERT INTO versification_data VALUES (NULL, 4, 2, 31, 18);
INSERT INTO versification_data VALUES (NULL, 4, 2, 32, 35);
INSERT INTO versification_data VALUES (NULL, 4, 2, 33, 23);
INSERT INTO versification_data VALUES (NULL, 4, 2, 34, 35);
INSERT INTO versification_data VALUES (NULL, 4, 2, 35, 35);
INSERT INTO versification_data VALUES (NULL, 4, 2, 36, 38);
INSERT INTO versification_data VALUES (NULL, 4, 2, 37, 29);
INSERT INTO versification_data VALUES (NULL, 4, 2, 38, 31);
INSERT INTO versification_data VALUES (NULL, 4, 2, 39, 43);
INSERT INTO versification_data VALUES (NULL, 4, 2, 40, 38);
INSERT INTO versification_data VALUES (NULL, 4, 3, 1, 17);
INSERT INTO versification_data VALUES (NULL, 4, 3, 2, 16);
INSERT INTO versification_data VALUES (NULL, 4, 3, 3, 17);
INSERT INTO versification_data VALUES (NULL, 4, 3, 4, 35);
INSERT INTO versification_data VALUES (NULL, 4, 3, 5, 19);
INSERT INTO versification_data VALUES (NULL, 4, 3, 6, 30);
INSERT INTO versification_data VALUES (NULL, 4, 3, 7, 38);
INSERT INTO versification_data VALUES (NULL, 4, 3, 8, 36);
INSERT INTO versification_data VALUES (NULL, 4, 3, 9, 24);
INSERT INTO versification_data VALUES (NULL, 4, 3, 10, 20);
INSERT INTO versification_data VALUES (NULL, 4, 3, 11, 47);
INSERT INTO versification_data VALUES (NULL, 4, 3, 12, 8);
INSERT INTO versification_data VALUES (NULL, 4, 3, 13, 59);
INSERT INTO versification_data VALUES (NULL, 4, 3, 14, 56);
INSERT INTO versification_data VALUES (NULL, 4, 3, 15, 33);
INSERT INTO versification_data VALUES (NULL, 4, 3, 16, 34);
INSERT INTO versification_data VALUES (NULL, 4, 3, 17, 16);
INSERT INTO versification_data VALUES (NULL, 4, 3, 18, 30);
INSERT INTO versification_data VALUES (NULL, 4, 3, 19, 37);
INSERT INTO versification_data VALUES (NULL, 4, 3, 20, 27);
INSERT INTO versification_data VALUES (NULL, 4, 3, 21, 24);
INSERT INTO versification_data VALUES (NULL, 4, 3, 22, 33);
INSERT INTO versification_data VALUES (NULL, 4, 3, 23, 44);
INSERT INTO versification_data VALUES (NULL, 4, 3, 24, 23);
INSERT INTO versification_data VALUES (NULL, 4, 3, 25, 55);
INSERT INTO versification_data VALUES (NULL, 4, 3, 26, 46);
INSERT INTO versification_data VALUES (NULL, 4, 3, 27, 34);
INSERT INTO versification_data VALUES (NULL, 4, 4, 1, 54);
INSERT INTO versification_data VALUES (NULL, 4, 4, 2, 34);
INSERT INTO versification_data VALUES (NULL, 4, 4, 3, 51);
INSERT INTO versification_data VALUES (NULL, 4, 4, 4, 49);
INSERT INTO versification_data VALUES (NULL, 4, 4, 5, 31);
INSERT INTO versification_data VALUES (NULL, 4, 4, 6, 27);
INSERT INTO versification_data VALUES (NULL, 4, 4, 7, 89);
INSERT INTO versification_data VALUES (NULL, 4, 4, 8, 26);
INSERT INTO versification_data VALUES (NULL, 4, 4, 9, 23);
INSERT INTO versification_data VALUES (NULL, 4, 4, 10, 36);
INSERT INTO versification_data VALUES (NULL, 4, 4, 11, 35);
INSERT INTO versification_data VALUES (NULL, 4, 4, 12, 15);
INSERT INTO versification_data VALUES (NULL, 4, 4, 13, 34);
INSERT INTO versification_data VALUES (NULL, 4, 4, 14, 45);
INSERT INTO versification_data VALUES (NULL, 4, 4, 15, 41);
INSERT INTO versification_data VALUES (NULL, 4, 4, 16, 50);
INSERT INTO versification_data VALUES (NULL, 4, 4, 17, 13);
INSERT INTO versification_data VALUES (NULL, 4, 4, 18, 32);
INSERT INTO versification_data VALUES (NULL, 4, 4, 19, 22);
INSERT INTO versification_data VALUES (NULL, 4, 4, 20, 29);
INSERT INTO versification_data VALUES (NULL, 4, 4, 21, 35);
INSERT INTO versification_data VALUES (NULL, 4, 4, 22, 41);
INSERT INTO versification_data VALUES (NULL, 4, 4, 23, 30);
INSERT INTO versification_data VALUES (NULL, 4, 4, 24, 25);
INSERT INTO versification_data VALUES (NULL, 4, 4, 25, 18);
INSERT INTO versification_data VALUES (NULL, 4, 4, 26, 65);
INSERT INTO versification_data VALUES (NULL, 4, 4, 27, 23);
INSERT INTO versification_data VALUES (NULL, 4, 4, 28, 31);
INSERT INTO versification_data VALUES (NULL, 4, 4, 29, 39);
INSERT INTO versification_data VALUES (NULL, 4, 4, 30, 17);
INSERT INTO versification_data VALUES (NULL, 4, 4, 31, 54);
INSERT INTO versification_data VALUES (NULL, 4, 4, 32, 42);
INSERT INTO versification_data VALUES (NULL, 4, 4, 33, 56);
INSERT INTO versification_data VALUES (NULL, 4, 4, 34, 29);
INSERT INTO versification_data VALUES (NULL, 4, 4, 35, 34);
INSERT INTO versification_data VALUES (NULL, 4, 4, 36, 13);
INSERT INTO versification_data VALUES (NULL, 4, 5, 1, 46);
INSERT INTO versification_data VALUES (NULL, 4, 5, 2, 37);
INSERT INTO versification_data VALUES (NULL, 4, 5, 3, 29);
INSERT INTO versification_data VALUES (NULL, 4, 5, 4, 49);
INSERT INTO versification_data VALUES (NULL, 4, 5, 5, 33);
INSERT INTO versification_data VALUES (NULL, 4, 5, 6, 25);
INSERT INTO versification_data VALUES (NULL, 4, 5, 7, 26);
INSERT INTO versification_data VALUES (NULL, 4, 5, 8, 20);
INSERT INTO versification_data VALUES (NULL, 4, 5, 9, 29);
INSERT INTO versification_data VALUES (NULL, 4, 5, 10, 22);
INSERT INTO versification_data VALUES (NULL, 4, 5, 11, 32);
INSERT INTO versification_data VALUES (NULL, 4, 5, 12, 32);
INSERT INTO versification_data VALUES (NULL, 4, 5, 13, 18);
INSERT INTO versification_data VALUES (NULL, 4, 5, 14, 29);
INSERT INTO versification_data VALUES (NULL, 4, 5, 15, 23);
INSERT INTO versification_data VALUES (NULL, 4, 5, 16, 22);
INSERT INTO versification_data VALUES (NULL, 4, 5, 17, 20);
INSERT INTO versification_data VALUES (NULL, 4, 5, 18, 22);
INSERT INTO versification_data VALUES (NULL, 4, 5, 19, 21);
INSERT INTO versification_data VALUES (NULL, 4, 5, 20, 20);
INSERT INTO versification_data VALUES (NULL, 4, 5, 21, 23);
INSERT INTO versification_data VALUES (NULL, 4, 5, 22, 30);
INSERT INTO versification_data VALUES (NULL, 4, 5, 23, 25);
INSERT INTO versification_data VALUES (NULL, 4, 5, 24, 22);
INSERT INTO versification_data VALUES (NULL, 4, 5, 25, 19);
INSERT INTO versification_data VALUES (NULL, 4, 5, 26, 19);
INSERT INTO versification_data VALUES (NULL, 4, 5, 27, 26);
INSERT INTO versification_data VALUES (NULL, 4, 5, 28, 68);
INSERT INTO versification_data VALUES (NULL, 4, 5, 29, 29);
INSERT INTO versification_data VALUES (NULL, 4, 5, 30, 20);
INSERT INTO versification_data VALUES (NULL, 4, 5, 31, 30);
INSERT INTO versification_data VALUES (NULL, 4, 5, 32, 52);
INSERT INTO versification_data VALUES (NULL, 4, 5, 33, 29);
INSERT INTO versification_data VALUES (NULL, 4, 5, 34, 12);
INSERT INTO versification_data VALUES (NULL, 4, 6, 1, 18);
INSERT INTO versification_data VALUES (NULL, 4, 6, 2, 24);
INSERT INTO versification_data VALUES (NULL, 4, 6, 3, 17);
INSERT INTO versification_data VALUES (NULL, 4, 6, 4, 24);
INSERT INTO versification_data VALUES (NULL, 4, 6, 5, 16);
INSERT INTO versification_data VALUES (NULL, 4, 6, 6, 26);
INSERT INTO versification_data VALUES (NULL, 4, 6, 7, 26);
INSERT INTO versification_data VALUES (NULL, 4, 6, 8, 35);
INSERT INTO versification_data VALUES (NULL, 4, 6, 9, 27);
INSERT INTO versification_data VALUES (NULL, 4, 6, 10, 43);
INSERT INTO versification_data VALUES (NULL, 4, 6, 11, 23);
INSERT INTO versification_data VALUES (NULL, 4, 6, 12, 24);
INSERT INTO versification_data VALUES (NULL, 4, 6, 13, 33);
INSERT INTO versification_data VALUES (NULL, 4, 6, 14, 15);
INSERT INTO versification_data VALUES (NULL, 4, 6, 15, 63);
INSERT INTO versification_data VALUES (NULL, 4, 6, 16, 10);
INSERT INTO versification_data VALUES (NULL, 4, 6, 17, 18);
INSERT INTO versification_data VALUES (NULL, 4, 6, 18, 28);
INSERT INTO versification_data VALUES (NULL, 4, 6, 19, 51);
INSERT INTO versification_data VALUES (NULL, 4, 6, 20, 9);
INSERT INTO versification_data VALUES (NULL, 4, 6, 21, 45);
INSERT INTO versification_data VALUES (NULL, 4, 6, 22, 34);
INSERT INTO versification_data VALUES (NULL, 4, 6, 23, 16);
INSERT INTO versification_data VALUES (NULL, 4, 6, 24, 33);
INSERT INTO versification_data VALUES (NULL, 4, 7, 1, 36);
INSERT INTO versification_data VALUES (NULL, 4, 7, 2, 23);
INSERT INTO versification_data VALUES (NULL, 4, 7, 3, 31);
INSERT INTO versification_data VALUES (NULL, 4, 7, 4, 24);
INSERT INTO versification_data VALUES (NULL, 4, 7, 5, 31);
INSERT INTO versification_data VALUES (NULL, 4, 7, 6, 40);
INSERT INTO versification_data VALUES (NULL, 4, 7, 7, 25);
INSERT INTO versification_data VALUES (NULL, 4, 7, 8, 35);
INSERT INTO versification_data VALUES (NULL, 4, 7, 9, 57);
INSERT INTO versification_data VALUES (NULL, 4, 7, 10, 18);
INSERT INTO versification_data VALUES (NULL, 4, 7, 11, 40);
INSERT INTO versification_data VALUES (NULL, 4, 7, 12, 15);
INSERT INTO versification_data VALUES (NULL, 4, 7, 13, 25);
INSERT INTO versification_data VALUES (NULL, 4, 7, 14, 20);
INSERT INTO versification_data VALUES (NULL, 4, 7, 15, 20);
INSERT INTO versification_data VALUES (NULL, 4, 7, 16, 31);
INSERT INTO versification_data VALUES (NULL, 4, 7, 17, 13);
INSERT INTO versification_data VALUES (NULL, 4, 7, 18, 31);
INSERT INTO versification_data VALUES (NULL, 4, 7, 19, 30);
INSERT INTO versification_data VALUES (NULL, 4, 7, 20, 48);
INSERT INTO versification_data VALUES (NULL, 4, 7, 21, 25);
INSERT INTO versification_data VALUES (NULL, 4, 8, 1, 22);
INSERT INTO versification_data VALUES (NULL, 4, 8, 2, 23);
INSERT INTO versification_data VALUES (NULL, 4, 8, 3, 18);
INSERT INTO versification_data VALUES (NULL, 4, 8, 4, 22);
INSERT INTO versification_data VALUES (NULL, 4, 9, 1, 28);
INSERT INTO versification_data VALUES (NULL, 4, 9, 2, 36);
INSERT INTO versification_data VALUES (NULL, 4, 9, 3, 21);
INSERT INTO versification_data VALUES (NULL, 4, 9, 4, 22);
INSERT INTO versification_data VALUES (NULL, 4, 9, 5, 12);
INSERT INTO versification_data VALUES (NULL, 4, 9, 6, 21);
INSERT INTO versification_data VALUES (NULL, 4, 9, 7, 17);
INSERT INTO versification_data VALUES (NULL, 4, 9, 8, 22);
INSERT INTO versification_data VALUES (NULL, 4, 9, 9, 27);
INSERT INTO versification_data VALUES (NULL, 4, 9, 10, 27);
INSERT INTO versification_data VALUES (NULL, 4, 9, 11, 15);
INSERT INTO versification_data VALUES (NULL, 4, 9, 12, 25);
INSERT INTO versification_data VALUES (NULL, 4, 9, 13, 23);
INSERT INTO versification_data VALUES (NULL, 4, 9, 14, 52);
INSERT INTO versification_data VALUES (NULL, 4, 9, 15, 35);
INSERT INTO versification_data VALUES (NULL, 4, 9, 16, 23);
INSERT INTO versification_data VALUES (NULL, 4, 9, 17, 58);
INSERT INTO versification_data VALUES (NULL, 4, 9, 18, 30);
INSERT INTO versification_data VALUES (NULL, 4, 9, 19, 24);
INSERT INTO versification_data VALUES (NULL, 4, 9, 20, 43);
INSERT INTO versification_data VALUES (NULL, 4, 9, 21, 15);
INSERT INTO versification_data VALUES (NULL, 4, 9, 22, 23);
INSERT INTO versification_data VALUES (NULL, 4, 9, 23, 28);
INSERT INTO versification_data VALUES (NULL, 4, 9, 24, 23);
INSERT INTO versification_data VALUES (NULL, 4, 9, 25, 44);
INSERT INTO versification_data VALUES (NULL, 4, 9, 26, 25);
INSERT INTO versification_data VALUES (NULL, 4, 9, 27, 12);
INSERT INTO versification_data VALUES (NULL, 4, 9, 28, 25);
INSERT INTO versification_data VALUES (NULL, 4, 9, 29, 11);
INSERT INTO versification_data VALUES (NULL, 4, 9, 30, 31);
INSERT INTO versification_data VALUES (NULL, 4, 9, 31, 13);
INSERT INTO versification_data VALUES (NULL, 4, 10, 1, 27);
INSERT INTO versification_data VALUES (NULL, 4, 10, 2, 32);
INSERT INTO versification_data VALUES (NULL, 4, 10, 3, 39);
INSERT INTO versification_data VALUES (NULL, 4, 10, 4, 12);
INSERT INTO versification_data VALUES (NULL, 4, 10, 5, 25);
INSERT INTO versification_data VALUES (NULL, 4, 10, 6, 23);
INSERT INTO versification_data VALUES (NULL, 4, 10, 7, 29);
INSERT INTO versification_data VALUES (NULL, 4, 10, 8, 18);
INSERT INTO versification_data VALUES (NULL, 4, 10, 9, 13);
INSERT INTO versification_data VALUES (NULL, 4, 10, 10, 19);
INSERT INTO versification_data VALUES (NULL, 4, 10, 11, 27);
INSERT INTO versification_data VALUES (NULL, 4, 10, 12, 31);
INSERT INTO versification_data VALUES (NULL, 4, 10, 13, 39);
INSERT INTO versification_data VALUES (NULL, 4, 10, 14, 33);
INSERT INTO versification_data VALUES (NULL, 4, 10, 15, 37);
INSERT INTO versification_data VALUES (NULL, 4, 10, 16, 23);
INSERT INTO versification_data VALUES (NULL, 4, 10, 17, 29);
INSERT INTO versification_data VALUES (NULL, 4, 10, 18, 33);
INSERT INTO versification_data VALUES (NULL, 4, 10, 19, 43);
INSERT INTO versification_data VALUES (NULL, 4, 10, 20, 26);
INSERT INTO versification_data VALUES (NULL, 4, 10, 21, 22);
INSERT INTO versification_data VALUES (NULL, 4, 10, 22, 51);
INSERT INTO versification_data VALUES (NULL, 4, 10, 23, 39);
INSERT INTO versification_data VALUES (NULL, 4, 10, 24, 25);
INSERT INTO versification_data VALUES (NULL, 4, 11, 1, 53);
INSERT INTO versification_data VALUES (NULL, 4, 11, 2, 46);
INSERT INTO versification_data VALUES (NULL, 4, 11, 3, 28);
INSERT INTO versification_data VALUES (NULL, 4, 11, 4, 34);
INSERT INTO versification_data VALUES (NULL, 4, 11, 5, 18);
INSERT INTO versification_data VALUES (NULL, 4, 11, 6, 38);
INSERT INTO versification_data VALUES (NULL, 4, 11, 7, 51);
INSERT INTO versification_data VALUES (NULL, 4, 11, 8, 66);
INSERT INTO versification_data VALUES (NULL, 4, 11, 9, 28);
INSERT INTO versification_data VALUES (NULL, 4, 11, 10, 29);
INSERT INTO versification_data VALUES (NULL, 4, 11, 11, 43);
INSERT INTO versification_data VALUES (NULL, 4, 11, 12, 33);
INSERT INTO versification_data VALUES (NULL, 4, 11, 13, 34);
INSERT INTO versification_data VALUES (NULL, 4, 11, 14, 31);
INSERT INTO versification_data VALUES (NULL, 4, 11, 15, 34);
INSERT INTO versification_data VALUES (NULL, 4, 11, 16, 34);
INSERT INTO versification_data VALUES (NULL, 4, 11, 17, 24);
INSERT INTO versification_data VALUES (NULL, 4, 11, 18, 46);
INSERT INTO versification_data VALUES (NULL, 4, 11, 19, 21);
INSERT INTO versification_data VALUES (NULL, 4, 11, 20, 43);
INSERT INTO versification_data VALUES (NULL, 4, 11, 21, 29);
INSERT INTO versification_data VALUES (NULL, 4, 11, 22, 53);
INSERT INTO versification_data VALUES (NULL, 4, 12, 1, 18);
INSERT INTO versification_data VALUES (NULL, 4, 12, 2, 25);
INSERT INTO versification_data VALUES (NULL, 4, 12, 3, 27);
INSERT INTO versification_data VALUES (NULL, 4, 12, 4, 44);
INSERT INTO versification_data VALUES (NULL, 4, 12, 5, 27);
INSERT INTO versification_data VALUES (NULL, 4, 12, 6, 33);
INSERT INTO versification_data VALUES (NULL, 4, 12, 7, 20);
INSERT INTO versification_data VALUES (NULL, 4, 12, 8, 29);
INSERT INTO versification_data VALUES (NULL, 4, 12, 9, 37);
INSERT INTO versification_data VALUES (NULL, 4, 12, 10, 36);
INSERT INTO versification_data VALUES (NULL, 4, 12, 11, 21);
INSERT INTO versification_data VALUES (NULL, 4, 12, 12, 21);
INSERT INTO versification_data VALUES (NULL, 4, 12, 13, 25);
INSERT INTO versification_data VALUES (NULL, 4, 12, 14, 29);
INSERT INTO versification_data VALUES (NULL, 4, 12, 15, 38);
INSERT INTO versification_data VALUES (NULL, 4, 12, 16, 20);
INSERT INTO versification_data VALUES (NULL, 4, 12, 17, 41);
INSERT INTO versification_data VALUES (NULL, 4, 12, 18, 37);
INSERT INTO versification_data VALUES (NULL, 4, 12, 19, 37);
INSERT INTO versification_data VALUES (NULL, 4, 12, 20, 21);
INSERT INTO versification_data VALUES (NULL, 4, 12, 21, 26);
INSERT INTO versification_data VALUES (NULL, 4, 12, 22, 20);
INSERT INTO versification_data VALUES (NULL, 4, 12, 23, 37);
INSERT INTO versification_data VALUES (NULL, 4, 12, 24, 20);
INSERT INTO versification_data VALUES (NULL, 4, 12, 25, 30);
INSERT INTO versification_data VALUES (NULL, 4, 13, 1, 54);
INSERT INTO versification_data VALUES (NULL, 4, 13, 2, 55);
INSERT INTO versification_data VALUES (NULL, 4, 13, 3, 24);
INSERT INTO versification_data VALUES (NULL, 4, 13, 4, 43);
INSERT INTO versification_data VALUES (NULL, 4, 13, 5, 26);
INSERT INTO versification_data VALUES (NULL, 4, 13, 6, 81);
INSERT INTO versification_data VALUES (NULL, 4, 13, 7, 40);
INSERT INTO versification_data VALUES (NULL, 4, 13, 8, 40);
INSERT INTO versification_data VALUES (NULL, 4, 13, 9, 44);
INSERT INTO versification_data VALUES (NULL, 4, 13, 10, 14);
INSERT INTO versification_data VALUES (NULL, 4, 13, 11, 47);
INSERT INTO versification_data VALUES (NULL, 4, 13, 12, 40);
INSERT INTO versification_data VALUES (NULL, 4, 13, 13, 14);
INSERT INTO versification_data VALUES (NULL, 4, 13, 14, 17);
INSERT INTO versification_data VALUES (NULL, 4, 13, 15, 29);
INSERT INTO versification_data VALUES (NULL, 4, 13, 16, 43);
INSERT INTO versification_data VALUES (NULL, 4, 13, 17, 27);
INSERT INTO versification_data VALUES (NULL, 4, 13, 18, 17);
INSERT INTO versification_data VALUES (NULL, 4, 13, 19, 19);
INSERT INTO versification_data VALUES (NULL, 4, 13, 20, 8);
INSERT INTO versification_data VALUES (NULL, 4, 13, 21, 30);
INSERT INTO versification_data VALUES (NULL, 4, 13, 22, 19);
INSERT INTO versification_data VALUES (NULL, 4, 13, 23, 32);
INSERT INTO versification_data VALUES (NULL, 4, 13, 24, 31);
INSERT INTO versification_data VALUES (NULL, 4, 13, 25, 31);
INSERT INTO versification_data VALUES (NULL, 4, 13, 26, 32);
INSERT INTO versification_data VALUES (NULL, 4, 13, 27, 34);
INSERT INTO versification_data VALUES (NULL, 4, 13, 28, 21);
INSERT INTO versification_data VALUES (NULL, 4, 13, 29, 30);
INSERT INTO versification_data VALUES (NULL, 4, 14, 1, 17);
INSERT INTO versification_data VALUES (NULL, 4, 14, 2, 18);
INSERT INTO versification_data VALUES (NULL, 4, 14, 3, 17);
INSERT INTO versification_data VALUES (NULL, 4, 14, 4, 22);
INSERT INTO versification_data VALUES (NULL, 4, 14, 5, 14);
INSERT INTO versification_data VALUES (NULL, 4, 14, 6, 42);
INSERT INTO versification_data VALUES (NULL, 4, 14, 7, 22);
INSERT INTO versification_data VALUES (NULL, 4, 14, 8, 18);
INSERT INTO versification_data VALUES (NULL, 4, 14, 9, 31);
INSERT INTO versification_data VALUES (NULL, 4, 14, 10, 19);
INSERT INTO versification_data VALUES (NULL, 4, 14, 11, 23);
INSERT INTO versification_data VALUES (NULL, 4, 14, 12, 16);
INSERT INTO versification_data VALUES (NULL, 4, 14, 13, 22);
INSERT INTO versification_data VALUES (NULL, 4, 14, 14, 15);
INSERT INTO versification_data VALUES (NULL, 4, 14, 15, 19);
INSERT INTO versification_data VALUES (NULL, 4, 14, 16, 14);
INSERT INTO versification_data VALUES (NULL, 4, 14, 17, 19);
INSERT INTO versification_data VALUES (NULL, 4, 14, 18, 34);
INSERT INTO versification_data VALUES (NULL, 4, 14, 19, 11);
INSERT INTO versification_data VALUES (NULL, 4, 14, 20, 37);
INSERT INTO versification_data VALUES (NULL, 4, 14, 21, 20);
INSERT INTO versification_data VALUES (NULL, 4, 14, 22, 12);
INSERT INTO versification_data VALUES (NULL, 4, 14, 23, 21);
INSERT INTO versification_data VALUES (NULL, 4, 14, 24, 27);
INSERT INTO versification_data VALUES (NULL, 4, 14, 25, 28);
INSERT INTO versification_data VALUES (NULL, 4, 14, 26, 23);
INSERT INTO versification_data VALUES (NULL, 4, 14, 27, 9);
INSERT INTO versification_data VALUES (NULL, 4, 14, 28, 27);
INSERT INTO versification_data VALUES (NULL, 4, 14, 29, 36);
INSERT INTO versification_data VALUES (NULL, 4, 14, 30, 27);
INSERT INTO versification_data VALUES (NULL, 4, 14, 31, 21);
INSERT INTO versification_data VALUES (NULL, 4, 14, 32, 33);
INSERT INTO versification_data VALUES (NULL, 4, 14, 33, 25);
INSERT INTO versification_data VALUES (NULL, 4, 14, 34, 33);
INSERT INTO versification_data VALUES (NULL, 4, 14, 35, 27);
INSERT INTO versification_data VALUES (NULL, 4, 14, 36, 23);
INSERT INTO versification_data VALUES (NULL, 4, 15, 1, 11);
INSERT INTO versification_data VALUES (NULL, 4, 15, 2, 70);
INSERT INTO versification_data VALUES (NULL, 4, 15, 3, 13);
INSERT INTO versification_data VALUES (NULL, 4, 15, 4, 24);
INSERT INTO versification_data VALUES (NULL, 4, 15, 5, 17);
INSERT INTO versification_data VALUES (NULL, 4, 15, 6, 22);
INSERT INTO versification_data VALUES (NULL, 4, 15, 7, 28);
INSERT INTO versification_data VALUES (NULL, 4, 15, 8, 36);
INSERT INTO versification_data VALUES (NULL, 4, 15, 9, 15);
INSERT INTO versification_data VALUES (NULL, 4, 15, 10, 44);
INSERT INTO versification_data VALUES (NULL, 4, 16, 1, 11);
INSERT INTO versification_data VALUES (NULL, 4, 16, 2, 20);
INSERT INTO versification_data VALUES (NULL, 4, 16, 3, 32);
INSERT INTO versification_data VALUES (NULL, 4, 16, 4, 23);
INSERT INTO versification_data VALUES (NULL, 4, 16, 5, 19);
INSERT INTO versification_data VALUES (NULL, 4, 16, 6, 19);
INSERT INTO versification_data VALUES (NULL, 4, 16, 7, 73);
INSERT INTO versification_data VALUES (NULL, 4, 16, 8, 18);
INSERT INTO versification_data VALUES (NULL, 4, 16, 9, 38);
INSERT INTO versification_data VALUES (NULL, 4, 16, 10, 39);
INSERT INTO versification_data VALUES (NULL, 4, 16, 11, 36);
INSERT INTO versification_data VALUES (NULL, 4, 16, 12, 47);
INSERT INTO versification_data VALUES (NULL, 4, 16, 13, 31);
INSERT INTO versification_data VALUES (NULL, 4, 17, 1, 22);
INSERT INTO versification_data VALUES (NULL, 4, 17, 2, 23);
INSERT INTO versification_data VALUES (NULL, 4, 17, 3, 15);
INSERT INTO versification_data VALUES (NULL, 4, 17, 4, 17);
INSERT INTO versification_data VALUES (NULL, 4, 17, 5, 14);
INSERT INTO versification_data VALUES (NULL, 4, 17, 6, 14);
INSERT INTO versification_data VALUES (NULL, 4, 17, 7, 10);
INSERT INTO versification_data VALUES (NULL, 4, 17, 8, 17);
INSERT INTO versification_data VALUES (NULL, 4, 17, 9, 32);
INSERT INTO versification_data VALUES (NULL, 4, 17, 10, 3);
INSERT INTO versification_data VALUES (NULL, 4, 18, 1, 22);
INSERT INTO versification_data VALUES (NULL, 4, 18, 2, 13);
INSERT INTO versification_data VALUES (NULL, 4, 18, 3, 26);
INSERT INTO versification_data VALUES (NULL, 4, 18, 4, 21);
INSERT INTO versification_data VALUES (NULL, 4, 18, 5, 27);
INSERT INTO versification_data VALUES (NULL, 4, 18, 6, 30);
INSERT INTO versification_data VALUES (NULL, 4, 18, 7, 21);
INSERT INTO versification_data VALUES (NULL, 4, 18, 8, 22);
INSERT INTO versification_data VALUES (NULL, 4, 18, 9, 35);
INSERT INTO versification_data VALUES (NULL, 4, 18, 10, 22);
INSERT INTO versification_data VALUES (NULL, 4, 18, 11, 20);
INSERT INTO versification_data VALUES (NULL, 4, 18, 12, 25);
INSERT INTO versification_data VALUES (NULL, 4, 18, 13, 28);
INSERT INTO versification_data VALUES (NULL, 4, 18, 14, 22);
INSERT INTO versification_data VALUES (NULL, 4, 18, 15, 35);
INSERT INTO versification_data VALUES (NULL, 4, 18, 16, 22);
INSERT INTO versification_data VALUES (NULL, 4, 18, 17, 16);
INSERT INTO versification_data VALUES (NULL, 4, 18, 18, 21);
INSERT INTO versification_data VALUES (NULL, 4, 18, 19, 29);
INSERT INTO versification_data VALUES (NULL, 4, 18, 20, 29);
INSERT INTO versification_data VALUES (NULL, 4, 18, 21, 34);
INSERT INTO versification_data VALUES (NULL, 4, 18, 22, 30);
INSERT INTO versification_data VALUES (NULL, 4, 18, 23, 17);
INSERT INTO versification_data VALUES (NULL, 4, 18, 24, 25);
INSERT INTO versification_data VALUES (NULL, 4, 18, 25, 6);
INSERT INTO versification_data VALUES (NULL, 4, 18, 26, 14);
INSERT INTO versification_data VALUES (NULL, 4, 18, 27, 23);
INSERT INTO versification_data VALUES (NULL, 4, 18, 28, 28);
INSERT INTO versification_data VALUES (NULL, 4, 18, 29, 25);
INSERT INTO versification_data VALUES (NULL, 4, 18, 30, 31);
INSERT INTO versification_data VALUES (NULL, 4, 18, 31, 40);
INSERT INTO versification_data VALUES (NULL, 4, 18, 32, 22);
INSERT INTO versification_data VALUES (NULL, 4, 18, 33, 33);
INSERT INTO versification_data VALUES (NULL, 4, 18, 34, 37);
INSERT INTO versification_data VALUES (NULL, 4, 18, 35, 16);
INSERT INTO versification_data VALUES (NULL, 4, 18, 36, 33);
INSERT INTO versification_data VALUES (NULL, 4, 18, 37, 24);
INSERT INTO versification_data VALUES (NULL, 4, 18, 38, 41);
INSERT INTO versification_data VALUES (NULL, 4, 18, 39, 35);
INSERT INTO versification_data VALUES (NULL, 4, 18, 40, 27);
INSERT INTO versification_data VALUES (NULL, 4, 18, 41, 26);
INSERT INTO versification_data VALUES (NULL, 4, 18, 42, 17);
INSERT INTO versification_data VALUES (NULL, 4, 19, 1, 6);
INSERT INTO versification_data VALUES (NULL, 4, 19, 2, 12);
INSERT INTO versification_data VALUES (NULL, 4, 19, 3, 9);
INSERT INTO versification_data VALUES (NULL, 4, 19, 4, 9);
INSERT INTO versification_data VALUES (NULL, 4, 19, 5, 13);
INSERT INTO versification_data VALUES (NULL, 4, 19, 6, 11);
INSERT INTO versification_data VALUES (NULL, 4, 19, 7, 18);
INSERT INTO versification_data VALUES (NULL, 4, 19, 8, 10);
INSERT INTO versification_data VALUES (NULL, 4, 19, 9, 39);
INSERT INTO versification_data VALUES (NULL, 4, 19, 10, 7);
INSERT INTO versification_data VALUES (NULL, 4, 19, 11, 9);
INSERT INTO versification_data VALUES (NULL, 4, 19, 12, 6);
INSERT INTO versification_data VALUES (NULL, 4, 19, 13, 7);
INSERT INTO versification_data VALUES (NULL, 4, 19, 14, 5);
INSERT INTO versification_data VALUES (NULL, 4, 19, 15, 11);
INSERT INTO versification_data VALUES (NULL, 4, 19, 16, 15);
INSERT INTO versification_data VALUES (NULL, 4, 19, 17, 51);
INSERT INTO versification_data VALUES (NULL, 4, 19, 18, 15);
INSERT INTO versification_data VALUES (NULL, 4, 19, 19, 10);
INSERT INTO versification_data VALUES (NULL, 4, 19, 20, 14);
INSERT INTO versification_data VALUES (NULL, 4, 19, 21, 32);
INSERT INTO versification_data VALUES (NULL, 4, 19, 22, 6);
INSERT INTO versification_data VALUES (NULL, 4, 19, 23, 10);
INSERT INTO versification_data VALUES (NULL, 4, 19, 24, 22);
INSERT INTO versification_data VALUES (NULL, 4, 19, 25, 12);
INSERT INTO versification_data VALUES (NULL, 4, 19, 26, 14);
INSERT INTO versification_data VALUES (NULL, 4, 19, 27, 9);
INSERT INTO versification_data VALUES (NULL, 4, 19, 28, 11);
INSERT INTO versification_data VALUES (NULL, 4, 19, 29, 13);
INSERT INTO versification_data VALUES (NULL, 4, 19, 30, 25);
INSERT INTO versification_data VALUES (NULL, 4, 19, 31, 11);
INSERT INTO versification_data VALUES (NULL, 4, 19, 32, 22);
INSERT INTO versification_data VALUES (NULL, 4, 19, 33, 23);
INSERT INTO versification_data VALUES (NULL, 4, 19, 34, 28);
INSERT INTO versification_data VALUES (NULL, 4, 19, 35, 13);
INSERT INTO versification_data VALUES (NULL, 4, 19, 36, 40);
INSERT INTO versification_data VALUES (NULL, 4, 19, 37, 23);
INSERT INTO versification_data VALUES (NULL, 4, 19, 38, 14);
INSERT INTO versification_data VALUES (NULL, 4, 19, 39, 18);
INSERT INTO versification_data VALUES (NULL, 4, 19, 40, 14);
INSERT INTO versification_data VALUES (NULL, 4, 19, 41, 12);
INSERT INTO versification_data VALUES (NULL, 4, 19, 42, 5);
INSERT INTO versification_data VALUES (NULL, 4, 19, 43, 27);
INSERT INTO versification_data VALUES (NULL, 4, 19, 44, 18);
INSERT INTO versification_data VALUES (NULL, 4, 19, 45, 12);
INSERT INTO versification_data VALUES (NULL, 4, 19, 46, 10);
INSERT INTO versification_data VALUES (NULL, 4, 19, 47, 15);
INSERT INTO versification_data VALUES (NULL, 4, 19, 48, 21);
INSERT INTO versification_data VALUES (NULL, 4, 19, 49, 23);
INSERT INTO versification_data VALUES (NULL, 4, 19, 50, 21);
INSERT INTO versification_data VALUES (NULL, 4, 19, 51, 11);
INSERT INTO versification_data VALUES (NULL, 4, 19, 52, 7);
INSERT INTO versification_data VALUES (NULL, 4, 19, 53, 9);
INSERT INTO versification_data VALUES (NULL, 4, 19, 54, 24);
INSERT INTO versification_data VALUES (NULL, 4, 19, 55, 14);
INSERT INTO versification_data VALUES (NULL, 4, 19, 56, 12);
INSERT INTO versification_data VALUES (NULL, 4, 19, 57, 12);
INSERT INTO versification_data VALUES (NULL, 4, 19, 58, 18);
INSERT INTO versification_data VALUES (NULL, 4, 19, 59, 14);
INSERT INTO versification_data VALUES (NULL, 4, 19, 60, 9);
INSERT INTO versification_data VALUES (NULL, 4, 19, 61, 13);
INSERT INTO versification_data VALUES (NULL, 4, 19, 62, 12);
INSERT INTO versification_data VALUES (NULL, 4, 19, 63, 11);
INSERT INTO versification_data VALUES (NULL, 4, 19, 64, 14);
INSERT INTO versification_data VALUES (NULL, 4, 19, 65, 20);
INSERT INTO versification_data VALUES (NULL, 4, 19, 66, 8);
INSERT INTO versification_data VALUES (NULL, 4, 19, 67, 36);
INSERT INTO versification_data VALUES (NULL, 4, 19, 68, 37);
INSERT INTO versification_data VALUES (NULL, 4, 19, 69, 6);
INSERT INTO versification_data VALUES (NULL, 4, 19, 70, 24);
INSERT INTO versification_data VALUES (NULL, 4, 19, 71, 20);
INSERT INTO versification_data VALUES (NULL, 4, 19, 72, 28);
INSERT INTO versification_data VALUES (NULL, 4, 19, 73, 23);
INSERT INTO versification_data VALUES (NULL, 4, 19, 74, 11);
INSERT INTO versification_data VALUES (NULL, 4, 19, 75, 13);
INSERT INTO versification_data VALUES (NULL, 4, 19, 76, 21);
INSERT INTO versification_data VALUES (NULL, 4, 19, 77, 72);
INSERT INTO versification_data VALUES (NULL, 4, 19, 78, 13);
INSERT INTO versification_data VALUES (NULL, 4, 19, 79, 20);
INSERT INTO versification_data VALUES (NULL, 4, 19, 80, 17);
INSERT INTO versification_data VALUES (NULL, 4, 19, 81, 8);
INSERT INTO versification_data VALUES (NULL, 4, 19, 82, 19);
INSERT INTO versification_data VALUES (NULL, 4, 19, 83, 13);
INSERT INTO versification_data VALUES (NULL, 4, 19, 84, 14);
INSERT INTO versification_data VALUES (NULL, 4, 19, 85, 17);
INSERT INTO versification_data VALUES (NULL, 4, 19, 86, 7);
INSERT INTO versification_data VALUES (NULL, 4, 19, 87, 19);
INSERT INTO versification_data VALUES (NULL, 4, 19, 88, 53);
INSERT INTO versification_data VALUES (NULL, 4, 19, 89, 17);
INSERT INTO versification_data VALUES (NULL, 4, 19, 90, 16);
INSERT INTO versification_data VALUES (NULL, 4, 19, 91, 16);
INSERT INTO versification_data VALUES (NULL, 4, 19, 92, 5);
INSERT INTO versification_data VALUES (NULL, 4, 19, 93, 23);
INSERT INTO versification_data VALUES (NULL, 4, 19, 94, 11);
INSERT INTO versification_data VALUES (NULL, 4, 19, 95, 13);
INSERT INTO versification_data VALUES (NULL, 4, 19, 96, 12);
INSERT INTO versification_data VALUES (NULL, 4, 19, 97, 9);
INSERT INTO versification_data VALUES (NULL, 4, 19, 98, 9);
INSERT INTO versification_data VALUES (NULL, 4, 19, 99, 5);
INSERT INTO versification_data VALUES (NULL, 4, 19, 100, 8);
INSERT INTO versification_data VALUES (NULL, 4, 19, 101, 29);
INSERT INTO versification_data VALUES (NULL, 4, 19, 102, 22);
INSERT INTO versification_data VALUES (NULL, 4, 19, 103, 35);
INSERT INTO versification_data VALUES (NULL, 4, 19, 104, 45);
INSERT INTO versification_data VALUES (NULL, 4, 19, 105, 48);
INSERT INTO versification_data VALUES (NULL, 4, 19, 106, 43);
INSERT INTO versification_data VALUES (NULL, 4, 19, 107, 14);
INSERT INTO versification_data VALUES (NULL, 4, 19, 108, 31);
INSERT INTO versification_data VALUES (NULL, 4, 19, 109, 7);
INSERT INTO versification_data VALUES (NULL, 4, 19, 110, 10);
INSERT INTO versification_data VALUES (NULL, 4, 19, 111, 10);
INSERT INTO versification_data VALUES (NULL, 4, 19, 112, 9);
INSERT INTO versification_data VALUES (NULL, 4, 19, 113, 26);
INSERT INTO versification_data VALUES (NULL, 4, 19, 114, 9);
INSERT INTO versification_data VALUES (NULL, 4, 19, 115, 10);
INSERT INTO versification_data VALUES (NULL, 4, 19, 116, 2);
INSERT INTO versification_data VALUES (NULL, 4, 19, 117, 29);
INSERT INTO versification_data VALUES (NULL, 4, 19, 118, 176);
INSERT INTO versification_data VALUES (NULL, 4, 19, 119, 7);
INSERT INTO versification_data VALUES (NULL, 4, 19, 120, 8);
INSERT INTO versification_data VALUES (NULL, 4, 19, 121, 9);
INSERT INTO versification_data VALUES (NULL, 4, 19, 122, 4);
INSERT INTO versification_data VALUES (NULL, 4, 19, 123, 8);
INSERT INTO versification_data VALUES (NULL, 4, 19, 124, 5);
INSERT INTO versification_data VALUES (NULL, 4, 19, 125, 6);
INSERT INTO versification_data VALUES (NULL, 4, 19, 126, 5);
INSERT INTO versification_data VALUES (NULL, 4, 19, 127, 6);
INSERT INTO versification_data VALUES (NULL, 4, 19, 128, 8);
INSERT INTO versification_data VALUES (NULL, 4, 19, 129, 8);
INSERT INTO versification_data VALUES (NULL, 4, 19, 130, 3);
INSERT INTO versification_data VALUES (NULL, 4, 19, 131, 18);
INSERT INTO versification_data VALUES (NULL, 4, 19, 132, 3);
INSERT INTO versification_data VALUES (NULL, 4, 19, 133, 3);
INSERT INTO versification_data VALUES (NULL, 4, 19, 134, 21);
INSERT INTO versification_data VALUES (NULL, 4, 19, 135, 26);
INSERT INTO versification_data VALUES (NULL, 4, 19, 136, 9);
INSERT INTO versification_data VALUES (NULL, 4, 19, 137, 8);
INSERT INTO versification_data VALUES (NULL, 4, 19, 138, 24);
INSERT INTO versification_data VALUES (NULL, 4, 19, 139, 14);
INSERT INTO versification_data VALUES (NULL, 4, 19, 140, 10);
INSERT INTO versification_data VALUES (NULL, 4, 19, 141, 7);
INSERT INTO versification_data VALUES (NULL, 4, 19, 142, 12);
INSERT INTO versification_data VALUES (NULL, 4, 19, 143, 15);
INSERT INTO versification_data VALUES (NULL, 4, 19, 144, 21);
INSERT INTO versification_data VALUES (NULL, 4, 19, 145, 10);
INSERT INTO versification_data VALUES (NULL, 4, 19, 146, 11);
INSERT INTO versification_data VALUES (NULL, 4, 19, 147, 9);
INSERT INTO versification_data VALUES (NULL, 4, 19, 148, 14);
INSERT INTO versification_data VALUES (NULL, 4, 19, 149, 9);
INSERT INTO versification_data VALUES (NULL, 4, 19, 150, 6);
INSERT INTO versification_data VALUES (NULL, 4, 20, 1, 33);
INSERT INTO versification_data VALUES (NULL, 4, 20, 2, 22);
INSERT INTO versification_data VALUES (NULL, 4, 20, 3, 35);
INSERT INTO versification_data VALUES (NULL, 4, 20, 4, 27);
INSERT INTO versification_data VALUES (NULL, 4, 20, 5, 23);
INSERT INTO versification_data VALUES (NULL, 4, 20, 6, 35);
INSERT INTO versification_data VALUES (NULL, 4, 20, 7, 27);
INSERT INTO versification_data VALUES (NULL, 4, 20, 8, 36);
INSERT INTO versification_data VALUES (NULL, 4, 20, 9, 18);
INSERT INTO versification_data VALUES (NULL, 4, 20, 10, 32);
INSERT INTO versification_data VALUES (NULL, 4, 20, 11, 31);
INSERT INTO versification_data VALUES (NULL, 4, 20, 12, 28);
INSERT INTO versification_data VALUES (NULL, 4, 20, 13, 25);
INSERT INTO versification_data VALUES (NULL, 4, 20, 14, 35);
INSERT INTO versification_data VALUES (NULL, 4, 20, 15, 33);
INSERT INTO versification_data VALUES (NULL, 4, 20, 16, 33);
INSERT INTO versification_data VALUES (NULL, 4, 20, 17, 28);
INSERT INTO versification_data VALUES (NULL, 4, 20, 18, 24);
INSERT INTO versification_data VALUES (NULL, 4, 20, 19, 29);
INSERT INTO versification_data VALUES (NULL, 4, 20, 20, 30);
INSERT INTO versification_data VALUES (NULL, 4, 20, 21, 31);
INSERT INTO versification_data VALUES (NULL, 4, 20, 22, 29);
INSERT INTO versification_data VALUES (NULL, 4, 20, 23, 35);
INSERT INTO versification_data VALUES (NULL, 4, 20, 24, 34);
INSERT INTO versification_data VALUES (NULL, 4, 20, 25, 28);
INSERT INTO versification_data VALUES (NULL, 4, 20, 26, 28);
INSERT INTO versification_data VALUES (NULL, 4, 20, 27, 27);
INSERT INTO versification_data VALUES (NULL, 4, 20, 28, 28);
INSERT INTO versification_data VALUES (NULL, 4, 20, 29, 27);
INSERT INTO versification_data VALUES (NULL, 4, 20, 30, 33);
INSERT INTO versification_data VALUES (NULL, 4, 20, 31, 31);
INSERT INTO versification_data VALUES (NULL, 4, 21, 1, 18);
INSERT INTO versification_data VALUES (NULL, 4, 21, 2, 26);
INSERT INTO versification_data VALUES (NULL, 4, 21, 3, 22);
INSERT INTO versification_data VALUES (NULL, 4, 21, 4, 17);
INSERT INTO versification_data VALUES (NULL, 4, 21, 5, 19);
INSERT INTO versification_data VALUES (NULL, 4, 21, 6, 12);
INSERT INTO versification_data VALUES (NULL, 4, 21, 7, 29);
INSERT INTO versification_data VALUES (NULL, 4, 21, 8, 17);
INSERT INTO versification_data VALUES (NULL, 4, 21, 9, 18);
INSERT INTO versification_data VALUES (NULL, 4, 21, 10, 20);
INSERT INTO versification_data VALUES (NULL, 4, 21, 11, 10);
INSERT INTO versification_data VALUES (NULL, 4, 21, 12, 14);
INSERT INTO versification_data VALUES (NULL, 4, 22, 1, 16);
INSERT INTO versification_data VALUES (NULL, 4, 22, 2, 17);
INSERT INTO versification_data VALUES (NULL, 4, 22, 3, 11);
INSERT INTO versification_data VALUES (NULL, 4, 22, 4, 16);
INSERT INTO versification_data VALUES (NULL, 4, 22, 5, 16);
INSERT INTO versification_data VALUES (NULL, 4, 22, 6, 12);
INSERT INTO versification_data VALUES (NULL, 4, 22, 7, 14);
INSERT INTO versification_data VALUES (NULL, 4, 22, 8, 14);
INSERT INTO versification_data VALUES (NULL, 4, 23, 1, 31);
INSERT INTO versification_data VALUES (NULL, 4, 23, 2, 22);
INSERT INTO versification_data VALUES (NULL, 4, 23, 3, 25);
INSERT INTO versification_data VALUES (NULL, 4, 23, 4, 6);
INSERT INTO versification_data VALUES (NULL, 4, 23, 5, 30);
INSERT INTO versification_data VALUES (NULL, 4, 23, 6, 13);
INSERT INTO versification_data VALUES (NULL, 4, 23, 7, 25);
INSERT INTO versification_data VALUES (NULL, 4, 23, 8, 22);
INSERT INTO versification_data VALUES (NULL, 4, 23, 9, 21);
INSERT INTO versification_data VALUES (NULL, 4, 23, 10, 34);
INSERT INTO versification_data VALUES (NULL, 4, 23, 11, 16);
INSERT INTO versification_data VALUES (NULL, 4, 23, 12, 6);
INSERT INTO versification_data VALUES (NULL, 4, 23, 13, 22);
INSERT INTO versification_data VALUES (NULL, 4, 23, 14, 32);
INSERT INTO versification_data VALUES (NULL, 4, 23, 15, 9);
INSERT INTO versification_data VALUES (NULL, 4, 23, 16, 14);
INSERT INTO versification_data VALUES (NULL, 4, 23, 17, 14);
INSERT INTO versification_data VALUES (NULL, 4, 23, 18, 7);
INSERT INTO versification_data VALUES (NULL, 4, 23, 19, 25);
INSERT INTO versification_data VALUES (NULL, 4, 23, 20, 6);
INSERT INTO versification_data VALUES (NULL, 4, 23, 21, 17);
INSERT INTO versification_data VALUES (NULL, 4, 23, 22, 25);
INSERT INTO versification_data VALUES (NULL, 4, 23, 23, 18);
INSERT INTO versification_data VALUES (NULL, 4, 23, 24, 23);
INSERT INTO versification_data VALUES (NULL, 4, 23, 25, 12);
INSERT INTO versification_data VALUES (NULL, 4, 23, 26, 21);
INSERT INTO versification_data VALUES (NULL, 4, 23, 27, 13);
INSERT INTO versification_data VALUES (NULL, 4, 23, 28, 29);
INSERT INTO versification_data VALUES (NULL, 4, 23, 29, 24);
INSERT INTO versification_data VALUES (NULL, 4, 23, 30, 33);
INSERT INTO versification_data VALUES (NULL, 4, 23, 31, 9);
INSERT INTO versification_data VALUES (NULL, 4, 23, 32, 20);
INSERT INTO versification_data VALUES (NULL, 4, 23, 33, 24);
INSERT INTO versification_data VALUES (NULL, 4, 23, 34, 17);
INSERT INTO versification_data VALUES (NULL, 4, 23, 35, 10);
INSERT INTO versification_data VALUES (NULL, 4, 23, 36, 22);
INSERT INTO versification_data VALUES (NULL, 4, 23, 37, 38);
INSERT INTO versification_data VALUES (NULL, 4, 23, 38, 22);
INSERT INTO versification_data VALUES (NULL, 4, 23, 39, 8);
INSERT INTO versification_data VALUES (NULL, 4, 23, 40, 31);
INSERT INTO versification_data VALUES (NULL, 4, 23, 41, 29);
INSERT INTO versification_data VALUES (NULL, 4, 23, 42, 25);
INSERT INTO versification_data VALUES (NULL, 4, 23, 43, 28);
INSERT INTO versification_data VALUES (NULL, 4, 23, 44, 28);
INSERT INTO versification_data VALUES (NULL, 4, 23, 45, 25);
INSERT INTO versification_data VALUES (NULL, 4, 23, 46, 13);
INSERT INTO versification_data VALUES (NULL, 4, 23, 47, 15);
INSERT INTO versification_data VALUES (NULL, 4, 23, 48, 22);
INSERT INTO versification_data VALUES (NULL, 4, 23, 49, 26);
INSERT INTO versification_data VALUES (NULL, 4, 23, 50, 11);
INSERT INTO versification_data VALUES (NULL, 4, 23, 51, 23);
INSERT INTO versification_data VALUES (NULL, 4, 23, 52, 15);
INSERT INTO versification_data VALUES (NULL, 4, 23, 53, 12);
INSERT INTO versification_data VALUES (NULL, 4, 23, 54, 17);
INSERT INTO versification_data VALUES (NULL, 4, 23, 55, 13);
INSERT INTO versification_data VALUES (NULL, 4, 23, 56, 12);
INSERT INTO versification_data VALUES (NULL, 4, 23, 57, 21);
INSERT INTO versification_data VALUES (NULL, 4, 23, 58, 14);
INSERT INTO versification_data VALUES (NULL, 4, 23, 59, 21);
INSERT INTO versification_data VALUES (NULL, 4, 23, 60, 22);
INSERT INTO versification_data VALUES (NULL, 4, 23, 61, 11);
INSERT INTO versification_data VALUES (NULL, 4, 23, 62, 12);
INSERT INTO versification_data VALUES (NULL, 4, 23, 63, 19);
INSERT INTO versification_data VALUES (NULL, 4, 23, 64, 12);
INSERT INTO versification_data VALUES (NULL, 4, 23, 65, 25);
INSERT INTO versification_data VALUES (NULL, 4, 23, 66, 24);
INSERT INTO versification_data VALUES (NULL, 4, 24, 1, 19);
INSERT INTO versification_data VALUES (NULL, 4, 24, 2, 37);
INSERT INTO versification_data VALUES (NULL, 4, 24, 3, 25);
INSERT INTO versification_data VALUES (NULL, 4, 24, 4, 31);
INSERT INTO versification_data VALUES (NULL, 4, 24, 5, 31);
INSERT INTO versification_data VALUES (NULL, 4, 24, 6, 30);
INSERT INTO versification_data VALUES (NULL, 4, 24, 7, 34);
INSERT INTO versification_data VALUES (NULL, 4, 24, 8, 22);
INSERT INTO versification_data VALUES (NULL, 4, 24, 9, 26);
INSERT INTO versification_data VALUES (NULL, 4, 24, 10, 25);
INSERT INTO versification_data VALUES (NULL, 4, 24, 11, 23);
INSERT INTO versification_data VALUES (NULL, 4, 24, 12, 17);
INSERT INTO versification_data VALUES (NULL, 4, 24, 13, 27);
INSERT INTO versification_data VALUES (NULL, 4, 24, 14, 22);
INSERT INTO versification_data VALUES (NULL, 4, 24, 15, 21);
INSERT INTO versification_data VALUES (NULL, 4, 24, 16, 21);
INSERT INTO versification_data VALUES (NULL, 4, 24, 17, 27);
INSERT INTO versification_data VALUES (NULL, 4, 24, 18, 23);
INSERT INTO versification_data VALUES (NULL, 4, 24, 19, 15);
INSERT INTO versification_data VALUES (NULL, 4, 24, 20, 18);
INSERT INTO versification_data VALUES (NULL, 4, 24, 21, 14);
INSERT INTO versification_data VALUES (NULL, 4, 24, 22, 30);
INSERT INTO versification_data VALUES (NULL, 4, 24, 23, 40);
INSERT INTO versification_data VALUES (NULL, 4, 24, 24, 10);
INSERT INTO versification_data VALUES (NULL, 4, 24, 25, 38);
INSERT INTO versification_data VALUES (NULL, 4, 24, 26, 24);
INSERT INTO versification_data VALUES (NULL, 4, 24, 27, 22);
INSERT INTO versification_data VALUES (NULL, 4, 24, 28, 17);
INSERT INTO versification_data VALUES (NULL, 4, 24, 29, 32);
INSERT INTO versification_data VALUES (NULL, 4, 24, 30, 24);
INSERT INTO versification_data VALUES (NULL, 4, 24, 31, 40);
INSERT INTO versification_data VALUES (NULL, 4, 24, 32, 44);
INSERT INTO versification_data VALUES (NULL, 4, 24, 33, 26);
INSERT INTO versification_data VALUES (NULL, 4, 24, 34, 22);
INSERT INTO versification_data VALUES (NULL, 4, 24, 35, 19);
INSERT INTO versification_data VALUES (NULL, 4, 24, 36, 32);
INSERT INTO versification_data VALUES (NULL, 4, 24, 37, 21);
INSERT INTO versification_data VALUES (NULL, 4, 24, 38, 28);
INSERT INTO versification_data VALUES (NULL, 4, 24, 39, 18);
INSERT INTO versification_data VALUES (NULL, 4, 24, 40, 16);
INSERT INTO versification_data VALUES (NULL, 4, 24, 41, 18);
INSERT INTO versification_data VALUES (NULL, 4, 24, 42, 22);
INSERT INTO versification_data VALUES (NULL, 4, 24, 43, 13);
INSERT INTO versification_data VALUES (NULL, 4, 24, 44, 30);
INSERT INTO versification_data VALUES (NULL, 4, 24, 45, 5);
INSERT INTO versification_data VALUES (NULL, 4, 24, 46, 28);
INSERT INTO versification_data VALUES (NULL, 4, 24, 47, 7);
INSERT INTO versification_data VALUES (NULL, 4, 24, 48, 47);
INSERT INTO versification_data VALUES (NULL, 4, 24, 49, 39);
INSERT INTO versification_data VALUES (NULL, 4, 24, 50, 46);
INSERT INTO versification_data VALUES (NULL, 4, 24, 51, 64);
INSERT INTO versification_data VALUES (NULL, 4, 24, 52, 34);
INSERT INTO versification_data VALUES (NULL, 4, 25, 1, 22);
INSERT INTO versification_data VALUES (NULL, 4, 25, 2, 22);
INSERT INTO versification_data VALUES (NULL, 4, 25, 3, 66);
INSERT INTO versification_data VALUES (NULL, 4, 25, 4, 22);
INSERT INTO versification_data VALUES (NULL, 4, 25, 5, 22);
INSERT INTO versification_data VALUES (NULL, 4, 26, 1, 28);
INSERT INTO versification_data VALUES (NULL, 4, 26, 2, 10);
INSERT INTO versification_data VALUES (NULL, 4, 26, 3, 27);
INSERT INTO versification_data VALUES (NULL, 4, 26, 4, 17);
INSERT INTO versification_data VALUES (NULL, 4, 26, 5, 17);
INSERT INTO versification_data VALUES (NULL, 4, 26, 6, 14);
INSERT INTO versification_data VALUES (NULL, 4, 26, 7, 27);
INSERT INTO versification_data VALUES (NULL, 4, 26, 8, 18);
INSERT INTO versification_data VALUES (NULL, 4, 26, 9, 11);
INSERT INTO versification_data VALUES (NULL, 4, 26, 10, 22);
INSERT INTO versification_data VALUES (NULL, 4, 26, 11, 25);
INSERT INTO versification_data VALUES (NULL, 4, 26, 12, 28);
INSERT INTO versification_data VALUES (NULL, 4, 26, 13, 23);
INSERT INTO versification_data VALUES (NULL, 4, 26, 14, 23);
INSERT INTO versification_data VALUES (NULL, 4, 26, 15, 8);
INSERT INTO versification_data VALUES (NULL, 4, 26, 16, 63);
INSERT INTO versification_data VALUES (NULL, 4, 26, 17, 24);
INSERT INTO versification_data VALUES (NULL, 4, 26, 18, 32);
INSERT INTO versification_data VALUES (NULL, 4, 26, 19, 14);
INSERT INTO versification_data VALUES (NULL, 4, 26, 20, 49);
INSERT INTO versification_data VALUES (NULL, 4, 26, 21, 32);
INSERT INTO versification_data VALUES (NULL, 4, 26, 22, 31);
INSERT INTO versification_data VALUES (NULL, 4, 26, 23, 49);
INSERT INTO versification_data VALUES (NULL, 4, 26, 24, 27);
INSERT INTO versification_data VALUES (NULL, 4, 26, 25, 17);
INSERT INTO versification_data VALUES (NULL, 4, 26, 26, 21);
INSERT INTO versification_data VALUES (NULL, 4, 26, 27, 36);
INSERT INTO versification_data VALUES (NULL, 4, 26, 28, 26);
INSERT INTO versification_data VALUES (NULL, 4, 26, 29, 21);
INSERT INTO versification_data VALUES (NULL, 4, 26, 30, 26);
INSERT INTO versification_data VALUES (NULL, 4, 26, 31, 18);
INSERT INTO versification_data VALUES (NULL, 4, 26, 32, 32);
INSERT INTO versification_data VALUES (NULL, 4, 26, 33, 33);
INSERT INTO versification_data VALUES (NULL, 4, 26, 34, 31);
INSERT INTO versification_data VALUES (NULL, 4, 26, 35, 15);
INSERT INTO versification_data VALUES (NULL, 4, 26, 36, 38);
INSERT INTO versification_data VALUES (NULL, 4, 26, 37, 28);
INSERT INTO versification_data VALUES (NULL, 4, 26, 38, 23);
INSERT INTO versification_data VALUES (NULL, 4, 26, 39, 29);
INSERT INTO versification_data VALUES (NULL, 4, 26, 40, 49);
INSERT INTO versification_data VALUES (NULL, 4, 26, 41, 26);
INSERT INTO versification_data VALUES (NULL, 4, 26, 42, 20);
INSERT INTO versification_data VALUES (NULL, 4, 26, 43, 27);
INSERT INTO versification_data VALUES (NULL, 4, 26, 44, 31);
INSERT INTO versification_data VALUES (NULL, 4, 26, 45, 25);
INSERT INTO versification_data VALUES (NULL, 4, 26, 46, 24);
INSERT INTO versification_data VALUES (NULL, 4, 26, 47, 23);
INSERT INTO versification_data VALUES (NULL, 4, 26, 48, 35);
INSERT INTO versification_data VALUES (NULL, 4, 27, 1, 21);
INSERT INTO versification_data VALUES (NULL, 4, 27, 2, 49);
INSERT INTO versification_data VALUES (NULL, 4, 27, 3, 33);
INSERT INTO versification_data VALUES (NULL, 4, 27, 4, 34);
INSERT INTO versification_data VALUES (NULL, 4, 27, 5, 31);
INSERT INTO versification_data VALUES (NULL, 4, 27, 6, 28);
INSERT INTO versification_data VALUES (NULL, 4, 27, 7, 28);
INSERT INTO versification_data VALUES (NULL, 4, 27, 8, 27);
INSERT INTO versification_data VALUES (NULL, 4, 27, 9, 27);
INSERT INTO versification_data VALUES (NULL, 4, 27, 10, 21);
INSERT INTO versification_data VALUES (NULL, 4, 27, 11, 45);
INSERT INTO versification_data VALUES (NULL, 4, 27, 12, 13);
INSERT INTO versification_data VALUES (NULL, 4, 28, 1, 11);
INSERT INTO versification_data VALUES (NULL, 4, 28, 2, 23);
INSERT INTO versification_data VALUES (NULL, 4, 28, 3, 5);
INSERT INTO versification_data VALUES (NULL, 4, 28, 4, 19);
INSERT INTO versification_data VALUES (NULL, 4, 28, 5, 15);
INSERT INTO versification_data VALUES (NULL, 4, 28, 6, 11);
INSERT INTO versification_data VALUES (NULL, 4, 28, 7, 16);
INSERT INTO versification_data VALUES (NULL, 4, 28, 8, 14);
INSERT INTO versification_data VALUES (NULL, 4, 28, 9, 17);
INSERT INTO versification_data VALUES (NULL, 4, 28, 10, 15);
INSERT INTO versification_data VALUES (NULL, 4, 28, 11, 12);
INSERT INTO versification_data VALUES (NULL, 4, 28, 12, 14);
INSERT INTO versification_data VALUES (NULL, 4, 28, 13, 15);
INSERT INTO versification_data VALUES (NULL, 4, 28, 14, 10);
INSERT INTO versification_data VALUES (NULL, 4, 29, 1, 20);
INSERT INTO versification_data VALUES (NULL, 4, 29, 2, 32);
INSERT INTO versification_data VALUES (NULL, 4, 29, 3, 21);
INSERT INTO versification_data VALUES (NULL, 4, 30, 1, 15);
INSERT INTO versification_data VALUES (NULL, 4, 30, 2, 16);
INSERT INTO versification_data VALUES (NULL, 4, 30, 3, 15);
INSERT INTO versification_data VALUES (NULL, 4, 30, 4, 13);
INSERT INTO versification_data VALUES (NULL, 4, 30, 5, 27);
INSERT INTO versification_data VALUES (NULL, 4, 30, 6, 14);
INSERT INTO versification_data VALUES (NULL, 4, 30, 7, 17);
INSERT INTO versification_data VALUES (NULL, 4, 30, 8, 14);
INSERT INTO versification_data VALUES (NULL, 4, 30, 9, 15);
INSERT INTO versification_data VALUES (NULL, 4, 31, 1, 21);
INSERT INTO versification_data VALUES (NULL, 4, 32, 1, 16);
INSERT INTO versification_data VALUES (NULL, 4, 32, 2, 11);
INSERT INTO versification_data VALUES (NULL, 4, 32, 3, 10);
INSERT INTO versification_data VALUES (NULL, 4, 32, 4, 11);
INSERT INTO versification_data VALUES (NULL, 4, 33, 1, 16);
INSERT INTO versification_data VALUES (NULL, 4, 33, 2, 13);
INSERT INTO versification_data VALUES (NULL, 4, 33, 3, 12);
INSERT INTO versification_data VALUES (NULL, 4, 33, 4, 13);
INSERT INTO versification_data VALUES (NULL, 4, 33, 5, 15);
INSERT INTO versification_data VALUES (NULL, 4, 33, 6, 16);
INSERT INTO versification_data VALUES (NULL, 4, 33, 7, 20);
INSERT INTO versification_data VALUES (NULL, 4, 34, 1, 15);
INSERT INTO versification_data VALUES (NULL, 4, 34, 2, 13);
INSERT INTO versification_data VALUES (NULL, 4, 34, 3, 19);
INSERT INTO versification_data VALUES (NULL, 4, 35, 1, 17);
INSERT INTO versification_data VALUES (NULL, 4, 35, 2, 20);
INSERT INTO versification_data VALUES (NULL, 4, 35, 3, 19);
INSERT INTO versification_data VALUES (NULL, 4, 36, 1, 18);
INSERT INTO versification_data VALUES (NULL, 4, 36, 2, 15);
INSERT INTO versification_data VALUES (NULL, 4, 36, 3, 20);
INSERT INTO versification_data VALUES (NULL, 4, 37, 1, 15);
INSERT INTO versification_data VALUES (NULL, 4, 37, 2, 23);
INSERT INTO versification_data VALUES (NULL, 4, 38, 1, 21);
INSERT INTO versification_data VALUES (NULL, 4, 38, 2, 13);
INSERT INTO versification_data VALUES (NULL, 4, 38, 3, 10);
INSERT INTO versification_data VALUES (NULL, 4, 38, 4, 14);
INSERT INTO versification_data VALUES (NULL, 4, 38, 5, 11);
INSERT INTO versification_data VALUES (NULL, 4, 38, 6, 15);
INSERT INTO versification_data VALUES (NULL, 4, 38, 7, 14);
INSERT INTO versification_data VALUES (NULL, 4, 38, 8, 23);
INSERT INTO versification_data VALUES (NULL, 4, 38, 9, 17);
INSERT INTO versification_data VALUES (NULL, 4, 38, 10, 12);
INSERT INTO versification_data VALUES (NULL, 4, 38, 11, 17);
INSERT INTO versification_data VALUES (NULL, 4, 38, 12, 14);
INSERT INTO versification_data VALUES (NULL, 4, 38, 13, 9);
INSERT INTO versification_data VALUES (NULL, 4, 38, 14, 21);
INSERT INTO versification_data VALUES (NULL, 4, 39, 1, 14);
INSERT INTO versification_data VALUES (NULL, 4, 39, 2, 17);
INSERT INTO versification_data VALUES (NULL, 4, 39, 3, 18);
INSERT INTO versification_data VALUES (NULL, 4, 39, 4, 6);
INSERT INTO versification_data VALUES (NULL, 4, 40, 1, 25);
INSERT INTO versification_data VALUES (NULL, 4, 40, 2, 23);
INSERT INTO versification_data VALUES (NULL, 4, 40, 3, 17);
INSERT INTO versification_data VALUES (NULL, 4, 40, 4, 25);
INSERT INTO versification_data VALUES (NULL, 4, 40, 5, 48);
INSERT INTO versification_data VALUES (NULL, 4, 40, 6, 34);
INSERT INTO versification_data VALUES (NULL, 4, 40, 7, 29);
INSERT INTO versification_data VALUES (NULL, 4, 40, 8, 34);
INSERT INTO versification_data VALUES (NULL, 4, 40, 9, 38);
INSERT INTO versification_data VALUES (NULL, 4, 40, 10, 42);
INSERT INTO versification_data VALUES (NULL, 4, 40, 11, 30);
INSERT INTO versification_data VALUES (NULL, 4, 40, 12, 50);
INSERT INTO versification_data VALUES (NULL, 4, 40, 13, 58);
INSERT INTO versification_data VALUES (NULL, 4, 40, 14, 36);
INSERT INTO versification_data VALUES (NULL, 4, 40, 15, 39);
INSERT INTO versification_data VALUES (NULL, 4, 40, 16, 28);
INSERT INTO versification_data VALUES (NULL, 4, 40, 17, 27);
INSERT INTO versification_data VALUES (NULL, 4, 40, 18, 35);
INSERT INTO versification_data VALUES (NULL, 4, 40, 19, 30);
INSERT INTO versification_data VALUES (NULL, 4, 40, 20, 34);
INSERT INTO versification_data VALUES (NULL, 4, 40, 21, 46);
INSERT INTO versification_data VALUES (NULL, 4, 40, 22, 46);
INSERT INTO versification_data VALUES (NULL, 4, 40, 23, 39);
INSERT INTO versification_data VALUES (NULL, 4, 40, 24, 51);
INSERT INTO versification_data VALUES (NULL, 4, 40, 25, 46);
INSERT INTO versification_data VALUES (NULL, 4, 40, 26, 75);
INSERT INTO versification_data VALUES (NULL, 4, 40, 27, 66);
INSERT INTO versification_data VALUES (NULL, 4, 40, 28, 20);
INSERT INTO versification_data VALUES (NULL, 4, 41, 1, 45);
INSERT INTO versification_data VALUES (NULL, 4, 41, 2, 28);
INSERT INTO versification_data VALUES (NULL, 4, 41, 3, 35);
INSERT INTO versification_data VALUES (NULL, 4, 41, 4, 41);
INSERT INTO versification_data VALUES (NULL, 4, 41, 5, 43);
INSERT INTO versification_data VALUES (NULL, 4, 41, 6, 56);
INSERT INTO versification_data VALUES (NULL, 4, 41, 7, 37);
INSERT INTO versification_data VALUES (NULL, 4, 41, 8, 38);
INSERT INTO versification_data VALUES (NULL, 4, 41, 9, 50);
INSERT INTO versification_data VALUES (NULL, 4, 41, 10, 52);
INSERT INTO versification_data VALUES (NULL, 4, 41, 11, 33);
INSERT INTO versification_data VALUES (NULL, 4, 41, 12, 44);
INSERT INTO versification_data VALUES (NULL, 4, 41, 13, 37);
INSERT INTO versification_data VALUES (NULL, 4, 41, 14, 72);
INSERT INTO versification_data VALUES (NULL, 4, 41, 15, 47);
INSERT INTO versification_data VALUES (NULL, 4, 41, 16, 20);
INSERT INTO versification_data VALUES (NULL, 4, 42, 1, 80);
INSERT INTO versification_data VALUES (NULL, 4, 42, 2, 52);
INSERT INTO versification_data VALUES (NULL, 4, 42, 3, 38);
INSERT INTO versification_data VALUES (NULL, 4, 42, 4, 44);
INSERT INTO versification_data VALUES (NULL, 4, 42, 5, 39);
INSERT INTO versification_data VALUES (NULL, 4, 42, 6, 49);
INSERT INTO versification_data VALUES (NULL, 4, 42, 7, 50);
INSERT INTO versification_data VALUES (NULL, 4, 42, 8, 56);
INSERT INTO versification_data VALUES (NULL, 4, 42, 9, 62);
INSERT INTO versification_data VALUES (NULL, 4, 42, 10, 42);
INSERT INTO versification_data VALUES (NULL, 4, 42, 11, 54);
INSERT INTO versification_data VALUES (NULL, 4, 42, 12, 59);
INSERT INTO versification_data VALUES (NULL, 4, 42, 13, 35);
INSERT INTO versification_data VALUES (NULL, 4, 42, 14, 35);
INSERT INTO versification_data VALUES (NULL, 4, 42, 15, 32);
INSERT INTO versification_data VALUES (NULL, 4, 42, 16, 31);
INSERT INTO versification_data VALUES (NULL, 4, 42, 17, 37);
INSERT INTO versification_data VALUES (NULL, 4, 42, 18, 43);
INSERT INTO versification_data VALUES (NULL, 4, 42, 19, 48);
INSERT INTO versification_data VALUES (NULL, 4, 42, 20, 47);
INSERT INTO versification_data VALUES (NULL, 4, 42, 21, 38);
INSERT INTO versification_data VALUES (NULL, 4, 42, 22, 71);
INSERT INTO versification_data VALUES (NULL, 4, 42, 23, 56);
INSERT INTO versification_data VALUES (NULL, 4, 42, 24, 53);
INSERT INTO versification_data VALUES (NULL, 4, 43, 1, 51);
INSERT INTO versification_data VALUES (NULL, 4, 43, 2, 25);
INSERT INTO versification_data VALUES (NULL, 4, 43, 3, 36);
INSERT INTO versification_data VALUES (NULL, 4, 43, 4, 54);
INSERT INTO versification_data VALUES (NULL, 4, 43, 5, 47);
INSERT INTO versification_data VALUES (NULL, 4, 43, 6, 71);
INSERT INTO versification_data VALUES (NULL, 4, 43, 7, 53);
INSERT INTO versification_data VALUES (NULL, 4, 43, 8, 59);
INSERT INTO versification_data VALUES (NULL, 4, 43, 9, 41);
INSERT INTO versification_data VALUES (NULL, 4, 43, 10, 42);
INSERT INTO versification_data VALUES (NULL, 4, 43, 11, 57);
INSERT INTO versification_data VALUES (NULL, 4, 43, 12, 50);
INSERT INTO versification_data VALUES (NULL, 4, 43, 13, 38);
INSERT INTO versification_data VALUES (NULL, 4, 43, 14, 31);
INSERT INTO versification_data VALUES (NULL, 4, 43, 15, 27);
INSERT INTO versification_data VALUES (NULL, 4, 43, 16, 33);
INSERT INTO versification_data VALUES (NULL, 4, 43, 17, 26);
INSERT INTO versification_data VALUES (NULL, 4, 43, 18, 40);
INSERT INTO versification_data VALUES (NULL, 4, 43, 19, 42);
INSERT INTO versification_data VALUES (NULL, 4, 43, 20, 31);
INSERT INTO versification_data VALUES (NULL, 4, 43, 21, 25);
INSERT INTO versification_data VALUES (NULL, 4, 44, 1, 26);
INSERT INTO versification_data VALUES (NULL, 4, 44, 2, 47);
INSERT INTO versification_data VALUES (NULL, 4, 44, 3, 26);
INSERT INTO versification_data VALUES (NULL, 4, 44, 4, 37);
INSERT INTO versification_data VALUES (NULL, 4, 44, 5, 42);
INSERT INTO versification_data VALUES (NULL, 4, 44, 6, 15);
INSERT INTO versification_data VALUES (NULL, 4, 44, 7, 60);
INSERT INTO versification_data VALUES (NULL, 4, 44, 8, 40);
INSERT INTO versification_data VALUES (NULL, 4, 44, 9, 43);
INSERT INTO versification_data VALUES (NULL, 4, 44, 10, 48);
INSERT INTO versification_data VALUES (NULL, 4, 44, 11, 30);
INSERT INTO versification_data VALUES (NULL, 4, 44, 12, 25);
INSERT INTO versification_data VALUES (NULL, 4, 44, 13, 52);
INSERT INTO versification_data VALUES (NULL, 4, 44, 14, 28);
INSERT INTO versification_data VALUES (NULL, 4, 44, 15, 41);
INSERT INTO versification_data VALUES (NULL, 4, 44, 16, 40);
INSERT INTO versification_data VALUES (NULL, 4, 44, 17, 34);
INSERT INTO versification_data VALUES (NULL, 4, 44, 18, 28);
INSERT INTO versification_data VALUES (NULL, 4, 44, 19, 40);
INSERT INTO versification_data VALUES (NULL, 4, 44, 20, 38);
INSERT INTO versification_data VALUES (NULL, 4, 44, 21, 40);
INSERT INTO versification_data VALUES (NULL, 4, 44, 22, 30);
INSERT INTO versification_data VALUES (NULL, 4, 44, 23, 35);
INSERT INTO versification_data VALUES (NULL, 4, 44, 24, 27);
INSERT INTO versification_data VALUES (NULL, 4, 44, 25, 27);
INSERT INTO versification_data VALUES (NULL, 4, 44, 26, 32);
INSERT INTO versification_data VALUES (NULL, 4, 44, 27, 44);
INSERT INTO versification_data VALUES (NULL, 4, 44, 28, 31);
INSERT INTO versification_data VALUES (NULL, 4, 45, 1, 32);
INSERT INTO versification_data VALUES (NULL, 4, 45, 2, 29);
INSERT INTO versification_data VALUES (NULL, 4, 45, 3, 31);
INSERT INTO versification_data VALUES (NULL, 4, 45, 4, 25);
INSERT INTO versification_data VALUES (NULL, 4, 45, 5, 21);
INSERT INTO versification_data VALUES (NULL, 4, 45, 6, 23);
INSERT INTO versification_data VALUES (NULL, 4, 45, 7, 25);
INSERT INTO versification_data VALUES (NULL, 4, 45, 8, 39);
INSERT INTO versification_data VALUES (NULL, 4, 45, 9, 33);
INSERT INTO versification_data VALUES (NULL, 4, 45, 10, 21);
INSERT INTO versification_data VALUES (NULL, 4, 45, 11, 36);
INSERT INTO versification_data VALUES (NULL, 4, 45, 12, 21);
INSERT INTO versification_data VALUES (NULL, 4, 45, 13, 14);
INSERT INTO versification_data VALUES (NULL, 4, 45, 14, 26);
INSERT INTO versification_data VALUES (NULL, 4, 45, 15, 33);
INSERT INTO versification_data VALUES (NULL, 4, 45, 16, 24);
INSERT INTO versification_data VALUES (NULL, 4, 46, 1, 31);
INSERT INTO versification_data VALUES (NULL, 4, 46, 2, 16);
INSERT INTO versification_data VALUES (NULL, 4, 46, 3, 23);
INSERT INTO versification_data VALUES (NULL, 4, 46, 4, 21);
INSERT INTO versification_data VALUES (NULL, 4, 46, 5, 13);
INSERT INTO versification_data VALUES (NULL, 4, 46, 6, 20);
INSERT INTO versification_data VALUES (NULL, 4, 46, 7, 40);
INSERT INTO versification_data VALUES (NULL, 4, 46, 8, 13);
INSERT INTO versification_data VALUES (NULL, 4, 46, 9, 27);
INSERT INTO versification_data VALUES (NULL, 4, 46, 10, 33);
INSERT INTO versification_data VALUES (NULL, 4, 46, 11, 34);
INSERT INTO versification_data VALUES (NULL, 4, 46, 12, 31);
INSERT INTO versification_data VALUES (NULL, 4, 46, 13, 13);
INSERT INTO versification_data VALUES (NULL, 4, 46, 14, 40);
INSERT INTO versification_data VALUES (NULL, 4, 46, 15, 58);
INSERT INTO versification_data VALUES (NULL, 4, 46, 16, 24);
INSERT INTO versification_data VALUES (NULL, 4, 47, 1, 24);
INSERT INTO versification_data VALUES (NULL, 4, 47, 2, 17);
INSERT INTO versification_data VALUES (NULL, 4, 47, 3, 18);
INSERT INTO versification_data VALUES (NULL, 4, 47, 4, 18);
INSERT INTO versification_data VALUES (NULL, 4, 47, 5, 21);
INSERT INTO versification_data VALUES (NULL, 4, 47, 6, 18);
INSERT INTO versification_data VALUES (NULL, 4, 47, 7, 16);
INSERT INTO versification_data VALUES (NULL, 4, 47, 8, 24);
INSERT INTO versification_data VALUES (NULL, 4, 47, 9, 15);
INSERT INTO versification_data VALUES (NULL, 4, 47, 10, 18);
INSERT INTO versification_data VALUES (NULL, 4, 47, 11, 32);
INSERT INTO versification_data VALUES (NULL, 4, 47, 12, 21);
INSERT INTO versification_data VALUES (NULL, 4, 47, 13, 13);
INSERT INTO versification_data VALUES (NULL, 4, 48, 1, 24);
INSERT INTO versification_data VALUES (NULL, 4, 48, 2, 21);
INSERT INTO versification_data VALUES (NULL, 4, 48, 3, 29);
INSERT INTO versification_data VALUES (NULL, 4, 48, 4, 31);
INSERT INTO versification_data VALUES (NULL, 4, 48, 5, 26);
INSERT INTO versification_data VALUES (NULL, 4, 48, 6, 18);
INSERT INTO versification_data VALUES (NULL, 4, 49, 1, 23);
INSERT INTO versification_data VALUES (NULL, 4, 49, 2, 22);
INSERT INTO versification_data VALUES (NULL, 4, 49, 3, 21);
INSERT INTO versification_data VALUES (NULL, 4, 49, 4, 32);
INSERT INTO versification_data VALUES (NULL, 4, 49, 5, 33);
INSERT INTO versification_data VALUES (NULL, 4, 49, 6, 24);
INSERT INTO versification_data VALUES (NULL, 4, 50, 1, 30);
INSERT INTO versification_data VALUES (NULL, 4, 50, 2, 30);
INSERT INTO versification_data VALUES (NULL, 4, 50, 3, 21);
INSERT INTO versification_data VALUES (NULL, 4, 50, 4, 23);
INSERT INTO versification_data VALUES (NULL, 4, 51, 1, 29);
INSERT INTO versification_data VALUES (NULL, 4, 51, 2, 23);
INSERT INTO versification_data VALUES (NULL, 4, 51, 3, 25);
INSERT INTO versification_data VALUES (NULL, 4, 51, 4, 18);
INSERT INTO versification_data VALUES (NULL, 4, 52, 1, 10);
INSERT INTO versification_data VALUES (NULL, 4, 52, 2, 20);
INSERT INTO versification_data VALUES (NULL, 4, 52, 3, 13);
INSERT INTO versification_data VALUES (NULL, 4, 52, 4, 18);
INSERT INTO versification_data VALUES (NULL, 4, 52, 5, 28);
INSERT INTO versification_data VALUES (NULL, 4, 53, 1, 12);
INSERT INTO versification_data VALUES (NULL, 4, 53, 2, 17);
INSERT INTO versification_data VALUES (NULL, 4, 53, 3, 18);
INSERT INTO versification_data VALUES (NULL, 4, 54, 1, 20);
INSERT INTO versification_data VALUES (NULL, 4, 54, 2, 15);
INSERT INTO versification_data VALUES (NULL, 4, 54, 3, 16);
INSERT INTO versification_data VALUES (NULL, 4, 54, 4, 16);
INSERT INTO versification_data VALUES (NULL, 4, 54, 5, 25);
INSERT INTO versification_data VALUES (NULL, 4, 54, 6, 21);
INSERT INTO versification_data VALUES (NULL, 4, 55, 1, 18);
INSERT INTO versification_data VALUES (NULL, 4, 55, 2, 26);
INSERT INTO versification_data VALUES (NULL, 4, 55, 3, 17);
INSERT INTO versification_data VALUES (NULL, 4, 55, 4, 22);
INSERT INTO versification_data VALUES (NULL, 4, 56, 1, 16);
INSERT INTO versification_data VALUES (NULL, 4, 56, 2, 15);
INSERT INTO versification_data VALUES (NULL, 4, 56, 3, 15);
INSERT INTO versification_data VALUES (NULL, 4, 57, 1, 25);
INSERT INTO versification_data VALUES (NULL, 4, 58, 1, 14);
INSERT INTO versification_data VALUES (NULL, 4, 58, 2, 18);
INSERT INTO versification_data VALUES (NULL, 4, 58, 3, 19);
INSERT INTO versification_data VALUES (NULL, 4, 58, 4, 16);
INSERT INTO versification_data VALUES (NULL, 4, 58, 5, 14);
INSERT INTO versification_data VALUES (NULL, 4, 58, 6, 20);
INSERT INTO versification_data VALUES (NULL, 4, 58, 7, 28);
INSERT INTO versification_data VALUES (NULL, 4, 58, 8, 13);
INSERT INTO versification_data VALUES (NULL, 4, 58, 9, 28);
INSERT INTO versification_data VALUES (NULL, 4, 58, 10, 39);
INSERT INTO versification_data VALUES (NULL, 4, 58, 11, 40);
INSERT INTO versification_data VALUES (NULL, 4, 58, 12, 29);
INSERT INTO versification_data VALUES (NULL, 4, 58, 13, 25);
INSERT INTO versification_data VALUES (NULL, 4, 59, 1, 27);
INSERT INTO versification_data VALUES (NULL, 4, 59, 2, 26);
INSERT INTO versification_data VALUES (NULL, 4, 59, 3, 18);
INSERT INTO versification_data VALUES (NULL, 4, 59, 4, 17);
INSERT INTO versification_data VALUES (NULL, 4, 59, 5, 20);
INSERT INTO versification_data VALUES (NULL, 4, 60, 1, 25);
INSERT INTO versification_data VALUES (NULL, 4, 60, 2, 25);
INSERT INTO versification_data VALUES (NULL, 4, 60, 3, 22);
INSERT INTO versification_data VALUES (NULL, 4, 60, 4, 19);
INSERT INTO versification_data VALUES (NULL, 4, 60, 5, 14);
INSERT INTO versification_data VALUES (NULL, 4, 61, 1, 21);
INSERT INTO versification_data VALUES (NULL, 4, 61, 2, 22);
INSERT INTO versification_data VALUES (NULL, 4, 61, 3, 18);
INSERT INTO versification_data VALUES (NULL, 4, 62, 1, 10);
INSERT INTO versification_data VALUES (NULL, 4, 62, 2, 29);
INSERT INTO versification_data VALUES (NULL, 4, 62, 3, 24);
INSERT INTO versification_data VALUES (NULL, 4, 62, 4, 21);
INSERT INTO versification_data VALUES (NULL, 4, 62, 5, 21);
INSERT INTO versification_data VALUES (NULL, 4, 63, 1, 13);
INSERT INTO versification_data VALUES (NULL, 4, 64, 1, 15);
INSERT INTO versification_data VALUES (NULL, 4, 65, 1, 25);
INSERT INTO versification_data VALUES (NULL, 4, 66, 1, 20);
INSERT INTO versification_data VALUES (NULL, 4, 66, 2, 29);
INSERT INTO versification_data VALUES (NULL, 4, 66, 3, 22);
INSERT INTO versification_data VALUES (NULL, 4, 66, 4, 11);
INSERT INTO versification_data VALUES (NULL, 4, 66, 5, 14);
INSERT INTO versification_data VALUES (NULL, 4, 66, 6, 17);
INSERT INTO versification_data VALUES (NULL, 4, 66, 7, 17);
INSERT INTO versification_data VALUES (NULL, 4, 66, 8, 13);
INSERT INTO versification_data VALUES (NULL, 4, 66, 9, 21);
INSERT INTO versification_data VALUES (NULL, 4, 66, 10, 11);
INSERT INTO versification_data VALUES (NULL, 4, 66, 11, 19);
INSERT INTO versification_data VALUES (NULL, 4, 66, 12, 17);
INSERT INTO versification_data VALUES (NULL, 4, 66, 13, 18);
INSERT INTO versification_data VALUES (NULL, 4, 66, 14, 20);
INSERT INTO versification_data VALUES (NULL, 4, 66, 15, 8);
INSERT INTO versification_data VALUES (NULL, 4, 66, 16, 21);
INSERT INTO versification_data VALUES (NULL, 4, 66, 17, 18);
INSERT INTO versification_data VALUES (NULL, 4, 66, 18, 24);
INSERT INTO versification_data VALUES (NULL, 4, 66, 19, 21);
INSERT INTO versification_data VALUES (NULL, 4, 66, 20, 15);
INSERT INTO versification_data VALUES (NULL, 4, 66, 21, 27);
INSERT INTO versification_data VALUES (NULL, 4, 66, 22, 21);

INSERT INTO versification_names VALUES (5, 'Russian Orthodox');

INSERT INTO versification_data VALUES (NULL, 5, 1, 1, 31);
INSERT INTO versification_data VALUES (NULL, 5, 1, 2, 25);
INSERT INTO versification_data VALUES (NULL, 5, 1, 3, 24);
INSERT INTO versification_data VALUES (NULL, 5, 1, 4, 26);
INSERT INTO versification_data VALUES (NULL, 5, 1, 5, 32);
INSERT INTO versification_data VALUES (NULL, 5, 1, 6, 22);
INSERT INTO versification_data VALUES (NULL, 5, 1, 7, 24);
INSERT INTO versification_data VALUES (NULL, 5, 1, 8, 22);
INSERT INTO versification_data VALUES (NULL, 5, 1, 9, 29);
INSERT INTO versification_data VALUES (NULL, 5, 1, 10, 32);
INSERT INTO versification_data VALUES (NULL, 5, 1, 11, 32);
INSERT INTO versification_data VALUES (NULL, 5, 1, 12, 20);
INSERT INTO versification_data VALUES (NULL, 5, 1, 13, 18);
INSERT INTO versification_data VALUES (NULL, 5, 1, 14, 24);
INSERT INTO versification_data VALUES (NULL, 5, 1, 15, 21);
INSERT INTO versification_data VALUES (NULL, 5, 1, 16, 16);
INSERT INTO versification_data VALUES (NULL, 5, 1, 17, 27);
INSERT INTO versification_data VALUES (NULL, 5, 1, 18, 33);
INSERT INTO versification_data VALUES (NULL, 5, 1, 19, 38);
INSERT INTO versification_data VALUES (NULL, 5, 1, 20, 18);
INSERT INTO versification_data VALUES (NULL, 5, 1, 21, 34);
INSERT INTO versification_data VALUES (NULL, 5, 1, 22, 24);
INSERT INTO versification_data VALUES (NULL, 5, 1, 23, 20);
INSERT INTO versification_data VALUES (NULL, 5, 1, 24, 67);
INSERT INTO versification_data VALUES (NULL, 5, 1, 25, 34);
INSERT INTO versification_data VALUES (NULL, 5, 1, 26, 35);
INSERT INTO versification_data VALUES (NULL, 5, 1, 27, 46);
INSERT INTO versification_data VALUES (NULL, 5, 1, 28, 22);
INSERT INTO versification_data VALUES (NULL, 5, 1, 29, 35);
INSERT INTO versification_data VALUES (NULL, 5, 1, 30, 43);
INSERT INTO versification_data VALUES (NULL, 5, 1, 31, 55);
INSERT INTO versification_data VALUES (NULL, 5, 1, 32, 32);
INSERT INTO versification_data VALUES (NULL, 5, 1, 33, 20);
INSERT INTO versification_data VALUES (NULL, 5, 1, 34, 31);
INSERT INTO versification_data VALUES (NULL, 5, 1, 35, 29);
INSERT INTO versification_data VALUES (NULL, 5, 1, 36, 43);
INSERT INTO versification_data VALUES (NULL, 5, 1, 37, 36);
INSERT INTO versification_data VALUES (NULL, 5, 1, 38, 30);
INSERT INTO versification_data VALUES (NULL, 5, 1, 39, 23);
INSERT INTO versification_data VALUES (NULL, 5, 1, 40, 23);
INSERT INTO versification_data VALUES (NULL, 5, 1, 41, 57);
INSERT INTO versification_data VALUES (NULL, 5, 1, 42, 38);
INSERT INTO versification_data VALUES (NULL, 5, 1, 43, 34);
INSERT INTO versification_data VALUES (NULL, 5, 1, 44, 34);
INSERT INTO versification_data VALUES (NULL, 5, 1, 45, 28);
INSERT INTO versification_data VALUES (NULL, 5, 1, 46, 34);
INSERT INTO versification_data VALUES (NULL, 5, 1, 47, 31);
INSERT INTO versification_data VALUES (NULL, 5, 1, 48, 22);
INSERT INTO versification_data VALUES (NULL, 5, 1, 49, 33);
INSERT INTO versification_data VALUES (NULL, 5, 1, 50, 26);
INSERT INTO versification_data VALUES (NULL, 5, 2, 1, 22);
INSERT INTO versification_data VALUES (NULL, 5, 2, 2, 25);
INSERT INTO versification_data VALUES (NULL, 5, 2, 3, 22);
INSERT INTO versification_data VALUES (NULL, 5, 2, 4, 31);
INSERT INTO versification_data VALUES (NULL, 5, 2, 5, 23);
INSERT INTO versification_data VALUES (NULL, 5, 2, 6, 30);
INSERT INTO versification_data VALUES (NULL, 5, 2, 7, 25);
INSERT INTO versification_data VALUES (NULL, 5, 2, 8, 32);
INSERT INTO versification_data VALUES (NULL, 5, 2, 9, 35);
INSERT INTO versification_data VALUES (NULL, 5, 2, 10, 29);
INSERT INTO versification_data VALUES (NULL, 5, 2, 11, 10);
INSERT INTO versification_data VALUES (NULL, 5, 2, 12, 51);
INSERT INTO versification_data VALUES (NULL, 5, 2, 13, 22);
INSERT INTO versification_data VALUES (NULL, 5, 2, 14, 31);
INSERT INTO versification_data VALUES (NULL, 5, 2, 15, 27);
INSERT INTO versification_data VALUES (NULL, 5, 2, 16, 36);
INSERT INTO versification_data VALUES (NULL, 5, 2, 17, 16);
INSERT INTO versification_data VALUES (NULL, 5, 2, 18, 27);
INSERT INTO versification_data VALUES (NULL, 5, 2, 19, 25);
INSERT INTO versification_data VALUES (NULL, 5, 2, 20, 26);
INSERT INTO versification_data VALUES (NULL, 5, 2, 21, 36);
INSERT INTO versification_data VALUES (NULL, 5, 2, 22, 31);
INSERT INTO versification_data VALUES (NULL, 5, 2, 23, 33);
INSERT INTO versification_data VALUES (NULL, 5, 2, 24, 18);
INSERT INTO versification_data VALUES (NULL, 5, 2, 25, 40);
INSERT INTO versification_data VALUES (NULL, 5, 2, 26, 37);
INSERT INTO versification_data VALUES (NULL, 5, 2, 27, 21);
INSERT INTO versification_data VALUES (NULL, 5, 2, 28, 43);
INSERT INTO versification_data VALUES (NULL, 5, 2, 29, 46);
INSERT INTO versification_data VALUES (NULL, 5, 2, 30, 38);
INSERT INTO versification_data VALUES (NULL, 5, 2, 31, 18);
INSERT INTO versification_data VALUES (NULL, 5, 2, 32, 35);
INSERT INTO versification_data VALUES (NULL, 5, 2, 33, 23);
INSERT INTO versification_data VALUES (NULL, 5, 2, 34, 35);
INSERT INTO versification_data VALUES (NULL, 5, 2, 35, 35);
INSERT INTO versification_data VALUES (NULL, 5, 2, 36, 38);
INSERT INTO versification_data VALUES (NULL, 5, 2, 37, 29);
INSERT INTO versification_data VALUES (NULL, 5, 2, 38, 31);
INSERT INTO versification_data VALUES (NULL, 5, 2, 39, 43);
INSERT INTO versification_data VALUES (NULL, 5, 2, 40, 38);
INSERT INTO versification_data VALUES (NULL, 5, 3, 1, 17);
INSERT INTO versification_data VALUES (NULL, 5, 3, 2, 16);
INSERT INTO versification_data VALUES (NULL, 5, 3, 3, 17);
INSERT INTO versification_data VALUES (NULL, 5, 3, 4, 35);
INSERT INTO versification_data VALUES (NULL, 5, 3, 5, 19);
INSERT INTO versification_data VALUES (NULL, 5, 3, 6, 30);
INSERT INTO versification_data VALUES (NULL, 5, 3, 7, 38);
INSERT INTO versification_data VALUES (NULL, 5, 3, 8, 36);
INSERT INTO versification_data VALUES (NULL, 5, 3, 9, 24);
INSERT INTO versification_data VALUES (NULL, 5, 3, 10, 20);
INSERT INTO versification_data VALUES (NULL, 5, 3, 11, 47);
INSERT INTO versification_data VALUES (NULL, 5, 3, 12, 8);
INSERT INTO versification_data VALUES (NULL, 5, 3, 13, 59);
INSERT INTO versification_data VALUES (NULL, 5, 3, 14, 56);
INSERT INTO versification_data VALUES (NULL, 5, 3, 15, 33);
INSERT INTO versification_data VALUES (NULL, 5, 3, 16, 34);
INSERT INTO versification_data VALUES (NULL, 5, 3, 17, 16);
INSERT INTO versification_data VALUES (NULL, 5, 3, 18, 30);
INSERT INTO versification_data VALUES (NULL, 5, 3, 19, 37);
INSERT INTO versification_data VALUES (NULL, 5, 3, 20, 27);
INSERT INTO versification_data VALUES (NULL, 5, 3, 21, 24);
INSERT INTO versification_data VALUES (NULL, 5, 3, 22, 33);
INSERT INTO versification_data VALUES (NULL, 5, 3, 23, 44);
INSERT INTO versification_data VALUES (NULL, 5, 3, 24, 23);
INSERT INTO versification_data VALUES (NULL, 5, 3, 25, 55);
INSERT INTO versification_data VALUES (NULL, 5, 3, 26, 46);
INSERT INTO versification_data VALUES (NULL, 5, 3, 27, 34);
INSERT INTO versification_data VALUES (NULL, 5, 4, 1, 54);
INSERT INTO versification_data VALUES (NULL, 5, 4, 2, 34);
INSERT INTO versification_data VALUES (NULL, 5, 4, 3, 51);
INSERT INTO versification_data VALUES (NULL, 5, 4, 4, 49);
INSERT INTO versification_data VALUES (NULL, 5, 4, 5, 31);
INSERT INTO versification_data VALUES (NULL, 5, 4, 6, 27);
INSERT INTO versification_data VALUES (NULL, 5, 4, 7, 89);
INSERT INTO versification_data VALUES (NULL, 5, 4, 8, 26);
INSERT INTO versification_data VALUES (NULL, 5, 4, 9, 23);
INSERT INTO versification_data VALUES (NULL, 5, 4, 10, 36);
INSERT INTO versification_data VALUES (NULL, 5, 4, 11, 35);
INSERT INTO versification_data VALUES (NULL, 5, 4, 12, 15);
INSERT INTO versification_data VALUES (NULL, 5, 4, 13, 34);
INSERT INTO versification_data VALUES (NULL, 5, 4, 14, 45);
INSERT INTO versification_data VALUES (NULL, 5, 4, 15, 41);
INSERT INTO versification_data VALUES (NULL, 5, 4, 16, 50);
INSERT INTO versification_data VALUES (NULL, 5, 4, 17, 13);
INSERT INTO versification_data VALUES (NULL, 5, 4, 18, 32);
INSERT INTO versification_data VALUES (NULL, 5, 4, 19, 22);
INSERT INTO versification_data VALUES (NULL, 5, 4, 20, 29);
INSERT INTO versification_data VALUES (NULL, 5, 4, 21, 35);
INSERT INTO versification_data VALUES (NULL, 5, 4, 22, 41);
INSERT INTO versification_data VALUES (NULL, 5, 4, 23, 30);
INSERT INTO versification_data VALUES (NULL, 5, 4, 24, 25);
INSERT INTO versification_data VALUES (NULL, 5, 4, 25, 18);
INSERT INTO versification_data VALUES (NULL, 5, 4, 26, 65);
INSERT INTO versification_data VALUES (NULL, 5, 4, 27, 23);
INSERT INTO versification_data VALUES (NULL, 5, 4, 28, 31);
INSERT INTO versification_data VALUES (NULL, 5, 4, 29, 39);
INSERT INTO versification_data VALUES (NULL, 5, 4, 30, 17);
INSERT INTO versification_data VALUES (NULL, 5, 4, 31, 54);
INSERT INTO versification_data VALUES (NULL, 5, 4, 32, 42);
INSERT INTO versification_data VALUES (NULL, 5, 4, 33, 56);
INSERT INTO versification_data VALUES (NULL, 5, 4, 34, 29);
INSERT INTO versification_data VALUES (NULL, 5, 4, 35, 34);
INSERT INTO versification_data VALUES (NULL, 5, 4, 36, 13);
INSERT INTO versification_data VALUES (NULL, 5, 5, 1, 46);
INSERT INTO versification_data VALUES (NULL, 5, 5, 2, 37);
INSERT INTO versification_data VALUES (NULL, 5, 5, 3, 29);
INSERT INTO versification_data VALUES (NULL, 5, 5, 4, 49);
INSERT INTO versification_data VALUES (NULL, 5, 5, 5, 33);
INSERT INTO versification_data VALUES (NULL, 5, 5, 6, 25);
INSERT INTO versification_data VALUES (NULL, 5, 5, 7, 26);
INSERT INTO versification_data VALUES (NULL, 5, 5, 8, 20);
INSERT INTO versification_data VALUES (NULL, 5, 5, 9, 29);
INSERT INTO versification_data VALUES (NULL, 5, 5, 10, 22);
INSERT INTO versification_data VALUES (NULL, 5, 5, 11, 32);
INSERT INTO versification_data VALUES (NULL, 5, 5, 12, 32);
INSERT INTO versification_data VALUES (NULL, 5, 5, 13, 18);
INSERT INTO versification_data VALUES (NULL, 5, 5, 14, 29);
INSERT INTO versification_data VALUES (NULL, 5, 5, 15, 23);
INSERT INTO versification_data VALUES (NULL, 5, 5, 16, 22);
INSERT INTO versification_data VALUES (NULL, 5, 5, 17, 20);
INSERT INTO versification_data VALUES (NULL, 5, 5, 18, 22);
INSERT INTO versification_data VALUES (NULL, 5, 5, 19, 21);
INSERT INTO versification_data VALUES (NULL, 5, 5, 20, 20);
INSERT INTO versification_data VALUES (NULL, 5, 5, 21, 23);
INSERT INTO versification_data VALUES (NULL, 5, 5, 22, 30);
INSERT INTO versification_data VALUES (NULL, 5, 5, 23, 25);
INSERT INTO versification_data VALUES (NULL, 5, 5, 24, 22);
INSERT INTO versification_data VALUES (NULL, 5, 5, 25, 19);
INSERT INTO versification_data VALUES (NULL, 5, 5, 26, 19);
INSERT INTO versification_data VALUES (NULL, 5, 5, 27, 26);
INSERT INTO versification_data VALUES (NULL, 5, 5, 28, 68);
INSERT INTO versification_data VALUES (NULL, 5, 5, 29, 29);
INSERT INTO versification_data VALUES (NULL, 5, 5, 30, 20);
INSERT INTO versification_data VALUES (NULL, 5, 5, 31, 30);
INSERT INTO versification_data VALUES (NULL, 5, 5, 32, 52);
INSERT INTO versification_data VALUES (NULL, 5, 5, 33, 29);
INSERT INTO versification_data VALUES (NULL, 5, 5, 34, 12);
INSERT INTO versification_data VALUES (NULL, 5, 6, 1, 18);
INSERT INTO versification_data VALUES (NULL, 5, 6, 2, 24);
INSERT INTO versification_data VALUES (NULL, 5, 6, 3, 17);
INSERT INTO versification_data VALUES (NULL, 5, 6, 4, 24);
INSERT INTO versification_data VALUES (NULL, 5, 6, 5, 16);
INSERT INTO versification_data VALUES (NULL, 5, 6, 6, 26);
INSERT INTO versification_data VALUES (NULL, 5, 6, 7, 26);
INSERT INTO versification_data VALUES (NULL, 5, 6, 8, 35);
INSERT INTO versification_data VALUES (NULL, 5, 6, 9, 27);
INSERT INTO versification_data VALUES (NULL, 5, 6, 10, 43);
INSERT INTO versification_data VALUES (NULL, 5, 6, 11, 23);
INSERT INTO versification_data VALUES (NULL, 5, 6, 12, 24);
INSERT INTO versification_data VALUES (NULL, 5, 6, 13, 33);
INSERT INTO versification_data VALUES (NULL, 5, 6, 14, 15);
INSERT INTO versification_data VALUES (NULL, 5, 6, 15, 63);
INSERT INTO versification_data VALUES (NULL, 5, 6, 16, 10);
INSERT INTO versification_data VALUES (NULL, 5, 6, 17, 18);
INSERT INTO versification_data VALUES (NULL, 5, 6, 18, 28);
INSERT INTO versification_data VALUES (NULL, 5, 6, 19, 51);
INSERT INTO versification_data VALUES (NULL, 5, 6, 20, 9);
INSERT INTO versification_data VALUES (NULL, 5, 6, 21, 45);
INSERT INTO versification_data VALUES (NULL, 5, 6, 22, 34);
INSERT INTO versification_data VALUES (NULL, 5, 6, 23, 16);
INSERT INTO versification_data VALUES (NULL, 5, 6, 24, 36);
INSERT INTO versification_data VALUES (NULL, 5, 7, 1, 36);
INSERT INTO versification_data VALUES (NULL, 5, 7, 2, 23);
INSERT INTO versification_data VALUES (NULL, 5, 7, 3, 31);
INSERT INTO versification_data VALUES (NULL, 5, 7, 4, 24);
INSERT INTO versification_data VALUES (NULL, 5, 7, 5, 31);
INSERT INTO versification_data VALUES (NULL, 5, 7, 6, 40);
INSERT INTO versification_data VALUES (NULL, 5, 7, 7, 25);
INSERT INTO versification_data VALUES (NULL, 5, 7, 8, 35);
INSERT INTO versification_data VALUES (NULL, 5, 7, 9, 57);
INSERT INTO versification_data VALUES (NULL, 5, 7, 10, 18);
INSERT INTO versification_data VALUES (NULL, 5, 7, 11, 40);
INSERT INTO versification_data VALUES (NULL, 5, 7, 12, 15);
INSERT INTO versification_data VALUES (NULL, 5, 7, 13, 25);
INSERT INTO versification_data VALUES (NULL, 5, 7, 14, 20);
INSERT INTO versification_data VALUES (NULL, 5, 7, 15, 20);
INSERT INTO versification_data VALUES (NULL, 5, 7, 16, 31);
INSERT INTO versification_data VALUES (NULL, 5, 7, 17, 13);
INSERT INTO versification_data VALUES (NULL, 5, 7, 18, 31);
INSERT INTO versification_data VALUES (NULL, 5, 7, 19, 30);
INSERT INTO versification_data VALUES (NULL, 5, 7, 20, 48);
INSERT INTO versification_data VALUES (NULL, 5, 7, 21, 25);
INSERT INTO versification_data VALUES (NULL, 5, 8, 1, 22);
INSERT INTO versification_data VALUES (NULL, 5, 8, 2, 23);
INSERT INTO versification_data VALUES (NULL, 5, 8, 3, 18);
INSERT INTO versification_data VALUES (NULL, 5, 8, 4, 22);
INSERT INTO versification_data VALUES (NULL, 5, 9, 1, 28);
INSERT INTO versification_data VALUES (NULL, 5, 9, 2, 36);
INSERT INTO versification_data VALUES (NULL, 5, 9, 3, 21);
INSERT INTO versification_data VALUES (NULL, 5, 9, 4, 22);
INSERT INTO versification_data VALUES (NULL, 5, 9, 5, 12);
INSERT INTO versification_data VALUES (NULL, 5, 9, 6, 21);
INSERT INTO versification_data VALUES (NULL, 5, 9, 7, 17);
INSERT INTO versification_data VALUES (NULL, 5, 9, 8, 22);
INSERT INTO versification_data VALUES (NULL, 5, 9, 9, 27);
INSERT INTO versification_data VALUES (NULL, 5, 9, 10, 27);
INSERT INTO versification_data VALUES (NULL, 5, 9, 11, 15);
INSERT INTO versification_data VALUES (NULL, 5, 9, 12, 25);
INSERT INTO versification_data VALUES (NULL, 5, 9, 13, 23);
INSERT INTO versification_data VALUES (NULL, 5, 9, 14, 52);
INSERT INTO versification_data VALUES (NULL, 5, 9, 15, 35);
INSERT INTO versification_data VALUES (NULL, 5, 9, 16, 23);
INSERT INTO versification_data VALUES (NULL, 5, 9, 17, 58);
INSERT INTO versification_data VALUES (NULL, 5, 9, 18, 30);
INSERT INTO versification_data VALUES (NULL, 5, 9, 19, 24);
INSERT INTO versification_data VALUES (NULL, 5, 9, 20, 43);
INSERT INTO versification_data VALUES (NULL, 5, 9, 21, 15);
INSERT INTO versification_data VALUES (NULL, 5, 9, 22, 23);
INSERT INTO versification_data VALUES (NULL, 5, 9, 23, 28);
INSERT INTO versification_data VALUES (NULL, 5, 9, 24, 23);
INSERT INTO versification_data VALUES (NULL, 5, 9, 25, 44);
INSERT INTO versification_data VALUES (NULL, 5, 9, 26, 25);
INSERT INTO versification_data VALUES (NULL, 5, 9, 27, 12);
INSERT INTO versification_data VALUES (NULL, 5, 9, 28, 25);
INSERT INTO versification_data VALUES (NULL, 5, 9, 29, 11);
INSERT INTO versification_data VALUES (NULL, 5, 9, 30, 31);
INSERT INTO versification_data VALUES (NULL, 5, 9, 31, 13);
INSERT INTO versification_data VALUES (NULL, 5, 10, 1, 27);
INSERT INTO versification_data VALUES (NULL, 5, 10, 2, 32);
INSERT INTO versification_data VALUES (NULL, 5, 10, 3, 39);
INSERT INTO versification_data VALUES (NULL, 5, 10, 4, 12);
INSERT INTO versification_data VALUES (NULL, 5, 10, 5, 25);
INSERT INTO versification_data VALUES (NULL, 5, 10, 6, 23);
INSERT INTO versification_data VALUES (NULL, 5, 10, 7, 29);
INSERT INTO versification_data VALUES (NULL, 5, 10, 8, 18);
INSERT INTO versification_data VALUES (NULL, 5, 10, 9, 13);
INSERT INTO versification_data VALUES (NULL, 5, 10, 10, 19);
INSERT INTO versification_data VALUES (NULL, 5, 10, 11, 27);
INSERT INTO versification_data VALUES (NULL, 5, 10, 12, 31);
INSERT INTO versification_data VALUES (NULL, 5, 10, 13, 39);
INSERT INTO versification_data VALUES (NULL, 5, 10, 14, 33);
INSERT INTO versification_data VALUES (NULL, 5, 10, 15, 37);
INSERT INTO versification_data VALUES (NULL, 5, 10, 16, 23);
INSERT INTO versification_data VALUES (NULL, 5, 10, 17, 29);
INSERT INTO versification_data VALUES (NULL, 5, 10, 18, 33);
INSERT INTO versification_data VALUES (NULL, 5, 10, 19, 43);
INSERT INTO versification_data VALUES (NULL, 5, 10, 20, 26);
INSERT INTO versification_data VALUES (NULL, 5, 10, 21, 22);
INSERT INTO versification_data VALUES (NULL, 5, 10, 22, 51);
INSERT INTO versification_data VALUES (NULL, 5, 10, 23, 39);
INSERT INTO versification_data VALUES (NULL, 5, 10, 24, 25);
INSERT INTO versification_data VALUES (NULL, 5, 11, 1, 53);
INSERT INTO versification_data VALUES (NULL, 5, 11, 2, 46);
INSERT INTO versification_data VALUES (NULL, 5, 11, 3, 28);
INSERT INTO versification_data VALUES (NULL, 5, 11, 4, 34);
INSERT INTO versification_data VALUES (NULL, 5, 11, 5, 18);
INSERT INTO versification_data VALUES (NULL, 5, 11, 6, 38);
INSERT INTO versification_data VALUES (NULL, 5, 11, 7, 51);
INSERT INTO versification_data VALUES (NULL, 5, 11, 8, 66);
INSERT INTO versification_data VALUES (NULL, 5, 11, 9, 28);
INSERT INTO versification_data VALUES (NULL, 5, 11, 10, 29);
INSERT INTO versification_data VALUES (NULL, 5, 11, 11, 43);
INSERT INTO versification_data VALUES (NULL, 5, 11, 12, 33);
INSERT INTO versification_data VALUES (NULL, 5, 11, 13, 34);
INSERT INTO versification_data VALUES (NULL, 5, 11, 14, 31);
INSERT INTO versification_data VALUES (NULL, 5, 11, 15, 34);
INSERT INTO versification_data VALUES (NULL, 5, 11, 16, 34);
INSERT INTO versification_data VALUES (NULL, 5, 11, 17, 24);
INSERT INTO versification_data VALUES (NULL, 5, 11, 18, 46);
INSERT INTO versification_data VALUES (NULL, 5, 11, 19, 21);
INSERT INTO versification_data VALUES (NULL, 5, 11, 20, 43);
INSERT INTO versification_data VALUES (NULL, 5, 11, 21, 29);
INSERT INTO versification_data VALUES (NULL, 5, 11, 22, 53);
INSERT INTO versification_data VALUES (NULL, 5, 12, 1, 18);
INSERT INTO versification_data VALUES (NULL, 5, 12, 2, 25);
INSERT INTO versification_data VALUES (NULL, 5, 12, 3, 27);
INSERT INTO versification_data VALUES (NULL, 5, 12, 4, 44);
INSERT INTO versification_data VALUES (NULL, 5, 12, 5, 27);
INSERT INTO versification_data VALUES (NULL, 5, 12, 6, 33);
INSERT INTO versification_data VALUES (NULL, 5, 12, 7, 20);
INSERT INTO versification_data VALUES (NULL, 5, 12, 8, 29);
INSERT INTO versification_data VALUES (NULL, 5, 12, 9, 37);
INSERT INTO versification_data VALUES (NULL, 5, 12, 10, 36);
INSERT INTO versification_data VALUES (NULL, 5, 12, 11, 21);
INSERT INTO versification_data VALUES (NULL, 5, 12, 12, 21);
INSERT INTO versification_data VALUES (NULL, 5, 12, 13, 25);
INSERT INTO versification_data VALUES (NULL, 5, 12, 14, 29);
INSERT INTO versification_data VALUES (NULL, 5, 12, 15, 38);
INSERT INTO versification_data VALUES (NULL, 5, 12, 16, 20);
INSERT INTO versification_data VALUES (NULL, 5, 12, 17, 41);
INSERT INTO versification_data VALUES (NULL, 5, 12, 18, 37);
INSERT INTO versification_data VALUES (NULL, 5, 12, 19, 37);
INSERT INTO versification_data VALUES (NULL, 5, 12, 20, 21);
INSERT INTO versification_data VALUES (NULL, 5, 12, 21, 26);
INSERT INTO versification_data VALUES (NULL, 5, 12, 22, 20);
INSERT INTO versification_data VALUES (NULL, 5, 12, 23, 37);
INSERT INTO versification_data VALUES (NULL, 5, 12, 24, 20);
INSERT INTO versification_data VALUES (NULL, 5, 12, 25, 30);
INSERT INTO versification_data VALUES (NULL, 5, 13, 1, 54);
INSERT INTO versification_data VALUES (NULL, 5, 13, 2, 55);
INSERT INTO versification_data VALUES (NULL, 5, 13, 3, 24);
INSERT INTO versification_data VALUES (NULL, 5, 13, 4, 43);
INSERT INTO versification_data VALUES (NULL, 5, 13, 5, 26);
INSERT INTO versification_data VALUES (NULL, 5, 13, 6, 81);
INSERT INTO versification_data VALUES (NULL, 5, 13, 7, 40);
INSERT INTO versification_data VALUES (NULL, 5, 13, 8, 40);
INSERT INTO versification_data VALUES (NULL, 5, 13, 9, 44);
INSERT INTO versification_data VALUES (NULL, 5, 13, 10, 14);
INSERT INTO versification_data VALUES (NULL, 5, 13, 11, 47);
INSERT INTO versification_data VALUES (NULL, 5, 13, 12, 40);
INSERT INTO versification_data VALUES (NULL, 5, 13, 13, 14);
INSERT INTO versification_data VALUES (NULL, 5, 13, 14, 17);
INSERT INTO versification_data VALUES (NULL, 5, 13, 15, 29);
INSERT INTO versification_data VALUES (NULL, 5, 13, 16, 43);
INSERT INTO versification_data VALUES (NULL, 5, 13, 17, 27);
INSERT INTO versification_data VALUES (NULL, 5, 13, 18, 17);
INSERT INTO versification_data VALUES (NULL, 5, 13, 19, 19);
INSERT INTO versification_data VALUES (NULL, 5, 13, 20, 8);
INSERT INTO versification_data VALUES (NULL, 5, 13, 21, 30);
INSERT INTO versification_data VALUES (NULL, 5, 13, 22, 19);
INSERT INTO versification_data VALUES (NULL, 5, 13, 23, 32);
INSERT INTO versification_data VALUES (NULL, 5, 13, 24, 31);
INSERT INTO versification_data VALUES (NULL, 5, 13, 25, 31);
INSERT INTO versification_data VALUES (NULL, 5, 13, 26, 32);
INSERT INTO versification_data VALUES (NULL, 5, 13, 27, 34);
INSERT INTO versification_data VALUES (NULL, 5, 13, 28, 21);
INSERT INTO versification_data VALUES (NULL, 5, 13, 29, 30);
INSERT INTO versification_data VALUES (NULL, 5, 14, 1, 17);
INSERT INTO versification_data VALUES (NULL, 5, 14, 2, 18);
INSERT INTO versification_data VALUES (NULL, 5, 14, 3, 17);
INSERT INTO versification_data VALUES (NULL, 5, 14, 4, 22);
INSERT INTO versification_data VALUES (NULL, 5, 14, 5, 14);
INSERT INTO versification_data VALUES (NULL, 5, 14, 6, 42);
INSERT INTO versification_data VALUES (NULL, 5, 14, 7, 22);
INSERT INTO versification_data VALUES (NULL, 5, 14, 8, 18);
INSERT INTO versification_data VALUES (NULL, 5, 14, 9, 31);
INSERT INTO versification_data VALUES (NULL, 5, 14, 10, 19);
INSERT INTO versification_data VALUES (NULL, 5, 14, 11, 23);
INSERT INTO versification_data VALUES (NULL, 5, 14, 12, 16);
INSERT INTO versification_data VALUES (NULL, 5, 14, 13, 22);
INSERT INTO versification_data VALUES (NULL, 5, 14, 14, 15);
INSERT INTO versification_data VALUES (NULL, 5, 14, 15, 19);
INSERT INTO versification_data VALUES (NULL, 5, 14, 16, 14);
INSERT INTO versification_data VALUES (NULL, 5, 14, 17, 19);
INSERT INTO versification_data VALUES (NULL, 5, 14, 18, 34);
INSERT INTO versification_data VALUES (NULL, 5, 14, 19, 11);
INSERT INTO versification_data VALUES (NULL, 5, 14, 20, 37);
INSERT INTO versification_data VALUES (NULL, 5, 14, 21, 20);
INSERT INTO versification_data VALUES (NULL, 5, 14, 22, 12);
INSERT INTO versification_data VALUES (NULL, 5, 14, 23, 21);
INSERT INTO versification_data VALUES (NULL, 5, 14, 24, 27);
INSERT INTO versification_data VALUES (NULL, 5, 14, 25, 28);
INSERT INTO versification_data VALUES (NULL, 5, 14, 26, 23);
INSERT INTO versification_data VALUES (NULL, 5, 14, 27, 9);
INSERT INTO versification_data VALUES (NULL, 5, 14, 28, 27);
INSERT INTO versification_data VALUES (NULL, 5, 14, 29, 36);
INSERT INTO versification_data VALUES (NULL, 5, 14, 30, 27);
INSERT INTO versification_data VALUES (NULL, 5, 14, 31, 21);
INSERT INTO versification_data VALUES (NULL, 5, 14, 32, 33);
INSERT INTO versification_data VALUES (NULL, 5, 14, 33, 25);
INSERT INTO versification_data VALUES (NULL, 5, 14, 34, 33);
INSERT INTO versification_data VALUES (NULL, 5, 14, 35, 27);
INSERT INTO versification_data VALUES (NULL, 5, 14, 36, 23);
INSERT INTO versification_data VALUES (NULL, 5, 14, 37, 12);
INSERT INTO versification_data VALUES (NULL, 5, 15, 1, 11);
INSERT INTO versification_data VALUES (NULL, 5, 15, 2, 70);
INSERT INTO versification_data VALUES (NULL, 5, 15, 3, 13);
INSERT INTO versification_data VALUES (NULL, 5, 15, 4, 24);
INSERT INTO versification_data VALUES (NULL, 5, 15, 5, 17);
INSERT INTO versification_data VALUES (NULL, 5, 15, 6, 22);
INSERT INTO versification_data VALUES (NULL, 5, 15, 7, 28);
INSERT INTO versification_data VALUES (NULL, 5, 15, 8, 36);
INSERT INTO versification_data VALUES (NULL, 5, 15, 9, 15);
INSERT INTO versification_data VALUES (NULL, 5, 15, 10, 44);
INSERT INTO versification_data VALUES (NULL, 5, 16, 1, 11);
INSERT INTO versification_data VALUES (NULL, 5, 16, 2, 20);
INSERT INTO versification_data VALUES (NULL, 5, 16, 3, 32);
INSERT INTO versification_data VALUES (NULL, 5, 16, 4, 23);
INSERT INTO versification_data VALUES (NULL, 5, 16, 5, 19);
INSERT INTO versification_data VALUES (NULL, 5, 16, 6, 19);
INSERT INTO versification_data VALUES (NULL, 5, 16, 7, 73);
INSERT INTO versification_data VALUES (NULL, 5, 16, 8, 18);
INSERT INTO versification_data VALUES (NULL, 5, 16, 9, 38);
INSERT INTO versification_data VALUES (NULL, 5, 16, 10, 39);
INSERT INTO versification_data VALUES (NULL, 5, 16, 11, 36);
INSERT INTO versification_data VALUES (NULL, 5, 16, 12, 47);
INSERT INTO versification_data VALUES (NULL, 5, 16, 13, 31);
INSERT INTO versification_data VALUES (NULL, 5, 17, 1, 22);
INSERT INTO versification_data VALUES (NULL, 5, 17, 2, 23);
INSERT INTO versification_data VALUES (NULL, 5, 17, 3, 15);
INSERT INTO versification_data VALUES (NULL, 5, 17, 4, 17);
INSERT INTO versification_data VALUES (NULL, 5, 17, 5, 14);
INSERT INTO versification_data VALUES (NULL, 5, 17, 6, 14);
INSERT INTO versification_data VALUES (NULL, 5, 17, 7, 10);
INSERT INTO versification_data VALUES (NULL, 5, 17, 8, 17);
INSERT INTO versification_data VALUES (NULL, 5, 17, 9, 32);
INSERT INTO versification_data VALUES (NULL, 5, 17, 10, 3);
INSERT INTO versification_data VALUES (NULL, 5, 18, 1, 22);
INSERT INTO versification_data VALUES (NULL, 5, 18, 2, 13);
INSERT INTO versification_data VALUES (NULL, 5, 18, 3, 26);
INSERT INTO versification_data VALUES (NULL, 5, 18, 4, 21);
INSERT INTO versification_data VALUES (NULL, 5, 18, 5, 27);
INSERT INTO versification_data VALUES (NULL, 5, 18, 6, 30);
INSERT INTO versification_data VALUES (NULL, 5, 18, 7, 21);
INSERT INTO versification_data VALUES (NULL, 5, 18, 8, 22);
INSERT INTO versification_data VALUES (NULL, 5, 18, 9, 35);
INSERT INTO versification_data VALUES (NULL, 5, 18, 10, 22);
INSERT INTO versification_data VALUES (NULL, 5, 18, 11, 20);
INSERT INTO versification_data VALUES (NULL, 5, 18, 12, 25);
INSERT INTO versification_data VALUES (NULL, 5, 18, 13, 28);
INSERT INTO versification_data VALUES (NULL, 5, 18, 14, 22);
INSERT INTO versification_data VALUES (NULL, 5, 18, 15, 35);
INSERT INTO versification_data VALUES (NULL, 5, 18, 16, 22);
INSERT INTO versification_data VALUES (NULL, 5, 18, 17, 16);
INSERT INTO versification_data VALUES (NULL, 5, 18, 18, 21);
INSERT INTO versification_data VALUES (NULL, 5, 18, 19, 29);
INSERT INTO versification_data VALUES (NULL, 5, 18, 20, 29);
INSERT INTO versification_data VALUES (NULL, 5, 18, 21, 34);
INSERT INTO versification_data VALUES (NULL, 5, 18, 22, 30);
INSERT INTO versification_data VALUES (NULL, 5, 18, 23, 17);
INSERT INTO versification_data VALUES (NULL, 5, 18, 24, 25);
INSERT INTO versification_data VALUES (NULL, 5, 18, 25, 6);
INSERT INTO versification_data VALUES (NULL, 5, 18, 26, 14);
INSERT INTO versification_data VALUES (NULL, 5, 18, 27, 23);
INSERT INTO versification_data VALUES (NULL, 5, 18, 28, 28);
INSERT INTO versification_data VALUES (NULL, 5, 18, 29, 25);
INSERT INTO versification_data VALUES (NULL, 5, 18, 30, 31);
INSERT INTO versification_data VALUES (NULL, 5, 18, 31, 40);
INSERT INTO versification_data VALUES (NULL, 5, 18, 32, 22);
INSERT INTO versification_data VALUES (NULL, 5, 18, 33, 33);
INSERT INTO versification_data VALUES (NULL, 5, 18, 34, 37);
INSERT INTO versification_data VALUES (NULL, 5, 18, 35, 16);
INSERT INTO versification_data VALUES (NULL, 5, 18, 36, 33);
INSERT INTO versification_data VALUES (NULL, 5, 18, 37, 24);
INSERT INTO versification_data VALUES (NULL, 5, 18, 38, 41);
INSERT INTO versification_data VALUES (NULL, 5, 18, 39, 35);
INSERT INTO versification_data VALUES (NULL, 5, 18, 40, 27);
INSERT INTO versification_data VALUES (NULL, 5, 18, 41, 26);
INSERT INTO versification_data VALUES (NULL, 5, 18, 42, 17);
INSERT INTO versification_data VALUES (NULL, 5, 19, 1, 6);
INSERT INTO versification_data VALUES (NULL, 5, 19, 2, 12);
INSERT INTO versification_data VALUES (NULL, 5, 19, 3, 9);
INSERT INTO versification_data VALUES (NULL, 5, 19, 4, 9);
INSERT INTO versification_data VALUES (NULL, 5, 19, 5, 13);
INSERT INTO versification_data VALUES (NULL, 5, 19, 6, 11);
INSERT INTO versification_data VALUES (NULL, 5, 19, 7, 18);
INSERT INTO versification_data VALUES (NULL, 5, 19, 8, 10);
INSERT INTO versification_data VALUES (NULL, 5, 19, 9, 39);
INSERT INTO versification_data VALUES (NULL, 5, 19, 10, 7);
INSERT INTO versification_data VALUES (NULL, 5, 19, 11, 9);
INSERT INTO versification_data VALUES (NULL, 5, 19, 12, 6);
INSERT INTO versification_data VALUES (NULL, 5, 19, 13, 7);
INSERT INTO versification_data VALUES (NULL, 5, 19, 14, 5);
INSERT INTO versification_data VALUES (NULL, 5, 19, 15, 11);
INSERT INTO versification_data VALUES (NULL, 5, 19, 16, 15);
INSERT INTO versification_data VALUES (NULL, 5, 19, 17, 51);
INSERT INTO versification_data VALUES (NULL, 5, 19, 18, 15);
INSERT INTO versification_data VALUES (NULL, 5, 19, 19, 10);
INSERT INTO versification_data VALUES (NULL, 5, 19, 20, 14);
INSERT INTO versification_data VALUES (NULL, 5, 19, 21, 32);
INSERT INTO versification_data VALUES (NULL, 5, 19, 22, 6);
INSERT INTO versification_data VALUES (NULL, 5, 19, 23, 10);
INSERT INTO versification_data VALUES (NULL, 5, 19, 24, 22);
INSERT INTO versification_data VALUES (NULL, 5, 19, 25, 12);
INSERT INTO versification_data VALUES (NULL, 5, 19, 26, 14);
INSERT INTO versification_data VALUES (NULL, 5, 19, 27, 9);
INSERT INTO versification_data VALUES (NULL, 5, 19, 28, 11);
INSERT INTO versification_data VALUES (NULL, 5, 19, 29, 13);
INSERT INTO versification_data VALUES (NULL, 5, 19, 30, 25);
INSERT INTO versification_data VALUES (NULL, 5, 19, 31, 11);
INSERT INTO versification_data VALUES (NULL, 5, 19, 32, 22);
INSERT INTO versification_data VALUES (NULL, 5, 19, 33, 23);
INSERT INTO versification_data VALUES (NULL, 5, 19, 34, 28);
INSERT INTO versification_data VALUES (NULL, 5, 19, 35, 13);
INSERT INTO versification_data VALUES (NULL, 5, 19, 36, 40);
INSERT INTO versification_data VALUES (NULL, 5, 19, 37, 23);
INSERT INTO versification_data VALUES (NULL, 5, 19, 38, 14);
INSERT INTO versification_data VALUES (NULL, 5, 19, 39, 18);
INSERT INTO versification_data VALUES (NULL, 5, 19, 40, 14);
INSERT INTO versification_data VALUES (NULL, 5, 19, 41, 12);
INSERT INTO versification_data VALUES (NULL, 5, 19, 42, 5);
INSERT INTO versification_data VALUES (NULL, 5, 19, 43, 27);
INSERT INTO versification_data VALUES (NULL, 5, 19, 44, 18);
INSERT INTO versification_data VALUES (NULL, 5, 19, 45, 12);
INSERT INTO versification_data VALUES (NULL, 5, 19, 46, 10);
INSERT INTO versification_data VALUES (NULL, 5, 19, 47, 15);
INSERT INTO versification_data VALUES (NULL, 5, 19, 48, 21);
INSERT INTO versification_data VALUES (NULL, 5, 19, 49, 23);
INSERT INTO versification_data VALUES (NULL, 5, 19, 50, 21);
INSERT INTO versification_data VALUES (NULL, 5, 19, 51, 11);
INSERT INTO versification_data VALUES (NULL, 5, 19, 52, 7);
INSERT INTO versification_data VALUES (NULL, 5, 19, 53, 9);
INSERT INTO versification_data VALUES (NULL, 5, 19, 54, 24);
INSERT INTO versification_data VALUES (NULL, 5, 19, 55, 14);
INSERT INTO versification_data VALUES (NULL, 5, 19, 56, 12);
INSERT INTO versification_data VALUES (NULL, 5, 19, 57, 12);
INSERT INTO versification_data VALUES (NULL, 5, 19, 58, 18);
INSERT INTO versification_data VALUES (NULL, 5, 19, 59, 14);
INSERT INTO versification_data VALUES (NULL, 5, 19, 60, 9);
INSERT INTO versification_data VALUES (NULL, 5, 19, 61, 13);
INSERT INTO versification_data VALUES (NULL, 5, 19, 62, 12);
INSERT INTO versification_data VALUES (NULL, 5, 19, 63, 11);
INSERT INTO versification_data VALUES (NULL, 5, 19, 64, 14);
INSERT INTO versification_data VALUES (NULL, 5, 19, 65, 20);
INSERT INTO versification_data VALUES (NULL, 5, 19, 66, 8);
INSERT INTO versification_data VALUES (NULL, 5, 19, 67, 36);
INSERT INTO versification_data VALUES (NULL, 5, 19, 68, 37);
INSERT INTO versification_data VALUES (NULL, 5, 19, 69, 6);
INSERT INTO versification_data VALUES (NULL, 5, 19, 70, 24);
INSERT INTO versification_data VALUES (NULL, 5, 19, 71, 20);
INSERT INTO versification_data VALUES (NULL, 5, 19, 72, 28);
INSERT INTO versification_data VALUES (NULL, 5, 19, 73, 23);
INSERT INTO versification_data VALUES (NULL, 5, 19, 74, 11);
INSERT INTO versification_data VALUES (NULL, 5, 19, 75, 13);
INSERT INTO versification_data VALUES (NULL, 5, 19, 76, 21);
INSERT INTO versification_data VALUES (NULL, 5, 19, 77, 72);
INSERT INTO versification_data VALUES (NULL, 5, 19, 78, 13);
INSERT INTO versification_data VALUES (NULL, 5, 19, 79, 20);
INSERT INTO versification_data VALUES (NULL, 5, 19, 80, 17);
INSERT INTO versification_data VALUES (NULL, 5, 19, 81, 8);
INSERT INTO versification_data VALUES (NULL, 5, 19, 82, 19);
INSERT INTO versification_data VALUES (NULL, 5, 19, 83, 13);
INSERT INTO versification_data VALUES (NULL, 5, 19, 84, 14);
INSERT INTO versification_data VALUES (NULL, 5, 19, 85, 17);
INSERT INTO versification_data VALUES (NULL, 5, 19, 86, 7);
INSERT INTO versification_data VALUES (NULL, 5, 19, 87, 19);
INSERT INTO versification_data VALUES (NULL, 5, 19, 88, 53);
INSERT INTO versification_data VALUES (NULL, 5, 19, 89, 17);
INSERT INTO versification_data VALUES (NULL, 5, 19, 90, 16);
INSERT INTO versification_data VALUES (NULL, 5, 19, 91, 16);
INSERT INTO versification_data VALUES (NULL, 5, 19, 92, 5);
INSERT INTO versification_data VALUES (NULL, 5, 19, 93, 23);
INSERT INTO versification_data VALUES (NULL, 5, 19, 94, 11);
INSERT INTO versification_data VALUES (NULL, 5, 19, 95, 13);
INSERT INTO versification_data VALUES (NULL, 5, 19, 96, 12);
INSERT INTO versification_data VALUES (NULL, 5, 19, 97, 9);
INSERT INTO versification_data VALUES (NULL, 5, 19, 98, 9);
INSERT INTO versification_data VALUES (NULL, 5, 19, 99, 5);
INSERT INTO versification_data VALUES (NULL, 5, 19, 100, 8);
INSERT INTO versification_data VALUES (NULL, 5, 19, 101, 29);
INSERT INTO versification_data VALUES (NULL, 5, 19, 102, 22);
INSERT INTO versification_data VALUES (NULL, 5, 19, 103, 35);
INSERT INTO versification_data VALUES (NULL, 5, 19, 104, 45);
INSERT INTO versification_data VALUES (NULL, 5, 19, 105, 48);
INSERT INTO versification_data VALUES (NULL, 5, 19, 106, 43);
INSERT INTO versification_data VALUES (NULL, 5, 19, 107, 14);
INSERT INTO versification_data VALUES (NULL, 5, 19, 108, 31);
INSERT INTO versification_data VALUES (NULL, 5, 19, 109, 7);
INSERT INTO versification_data VALUES (NULL, 5, 19, 110, 10);
INSERT INTO versification_data VALUES (NULL, 5, 19, 111, 10);
INSERT INTO versification_data VALUES (NULL, 5, 19, 112, 9);
INSERT INTO versification_data VALUES (NULL, 5, 19, 113, 26);
INSERT INTO versification_data VALUES (NULL, 5, 19, 114, 8);
INSERT INTO versification_data VALUES (NULL, 5, 19, 115, 10);
INSERT INTO versification_data VALUES (NULL, 5, 19, 116, 2);
INSERT INTO versification_data VALUES (NULL, 5, 19, 117, 29);
INSERT INTO versification_data VALUES (NULL, 5, 19, 118, 176);
INSERT INTO versification_data VALUES (NULL, 5, 19, 119, 7);
INSERT INTO versification_data VALUES (NULL, 5, 19, 120, 8);
INSERT INTO versification_data VALUES (NULL, 5, 19, 121, 9);
INSERT INTO versification_data VALUES (NULL, 5, 19, 122, 4);
INSERT INTO versification_data VALUES (NULL, 5, 19, 123, 8);
INSERT INTO versification_data VALUES (NULL, 5, 19, 124, 5);
INSERT INTO versification_data VALUES (NULL, 5, 19, 125, 6);
INSERT INTO versification_data VALUES (NULL, 5, 19, 126, 5);
INSERT INTO versification_data VALUES (NULL, 5, 19, 127, 6);
INSERT INTO versification_data VALUES (NULL, 5, 19, 128, 8);
INSERT INTO versification_data VALUES (NULL, 5, 19, 129, 8);
INSERT INTO versification_data VALUES (NULL, 5, 19, 130, 3);
INSERT INTO versification_data VALUES (NULL, 5, 19, 131, 18);
INSERT INTO versification_data VALUES (NULL, 5, 19, 132, 3);
INSERT INTO versification_data VALUES (NULL, 5, 19, 133, 3);
INSERT INTO versification_data VALUES (NULL, 5, 19, 134, 21);
INSERT INTO versification_data VALUES (NULL, 5, 19, 135, 26);
INSERT INTO versification_data VALUES (NULL, 5, 19, 136, 9);
INSERT INTO versification_data VALUES (NULL, 5, 19, 137, 8);
INSERT INTO versification_data VALUES (NULL, 5, 19, 138, 24);
INSERT INTO versification_data VALUES (NULL, 5, 19, 139, 14);
INSERT INTO versification_data VALUES (NULL, 5, 19, 140, 10);
INSERT INTO versification_data VALUES (NULL, 5, 19, 141, 7);
INSERT INTO versification_data VALUES (NULL, 5, 19, 142, 12);
INSERT INTO versification_data VALUES (NULL, 5, 19, 143, 15);
INSERT INTO versification_data VALUES (NULL, 5, 19, 144, 21);
INSERT INTO versification_data VALUES (NULL, 5, 19, 145, 10);
INSERT INTO versification_data VALUES (NULL, 5, 19, 146, 11);
INSERT INTO versification_data VALUES (NULL, 5, 19, 147, 9);
INSERT INTO versification_data VALUES (NULL, 5, 19, 148, 14);
INSERT INTO versification_data VALUES (NULL, 5, 19, 149, 9);
INSERT INTO versification_data VALUES (NULL, 5, 19, 150, 6);
INSERT INTO versification_data VALUES (NULL, 5, 19, 151, 7);
INSERT INTO versification_data VALUES (NULL, 5, 20, 1, 33);
INSERT INTO versification_data VALUES (NULL, 5, 20, 2, 22);
INSERT INTO versification_data VALUES (NULL, 5, 20, 3, 35);
INSERT INTO versification_data VALUES (NULL, 5, 20, 4, 29);
INSERT INTO versification_data VALUES (NULL, 5, 20, 5, 23);
INSERT INTO versification_data VALUES (NULL, 5, 20, 6, 35);
INSERT INTO versification_data VALUES (NULL, 5, 20, 7, 27);
INSERT INTO versification_data VALUES (NULL, 5, 20, 8, 36);
INSERT INTO versification_data VALUES (NULL, 5, 20, 9, 18);
INSERT INTO versification_data VALUES (NULL, 5, 20, 10, 32);
INSERT INTO versification_data VALUES (NULL, 5, 20, 11, 31);
INSERT INTO versification_data VALUES (NULL, 5, 20, 12, 28);
INSERT INTO versification_data VALUES (NULL, 5, 20, 13, 26);
INSERT INTO versification_data VALUES (NULL, 5, 20, 14, 35);
INSERT INTO versification_data VALUES (NULL, 5, 20, 15, 33);
INSERT INTO versification_data VALUES (NULL, 5, 20, 16, 33);
INSERT INTO versification_data VALUES (NULL, 5, 20, 17, 28);
INSERT INTO versification_data VALUES (NULL, 5, 20, 18, 25);
INSERT INTO versification_data VALUES (NULL, 5, 20, 19, 29);
INSERT INTO versification_data VALUES (NULL, 5, 20, 20, 30);
INSERT INTO versification_data VALUES (NULL, 5, 20, 21, 31);
INSERT INTO versification_data VALUES (NULL, 5, 20, 22, 29);
INSERT INTO versification_data VALUES (NULL, 5, 20, 23, 35);
INSERT INTO versification_data VALUES (NULL, 5, 20, 24, 34);
INSERT INTO versification_data VALUES (NULL, 5, 20, 25, 28);
INSERT INTO versification_data VALUES (NULL, 5, 20, 26, 28);
INSERT INTO versification_data VALUES (NULL, 5, 20, 27, 27);
INSERT INTO versification_data VALUES (NULL, 5, 20, 28, 28);
INSERT INTO versification_data VALUES (NULL, 5, 20, 29, 27);
INSERT INTO versification_data VALUES (NULL, 5, 20, 30, 33);
INSERT INTO versification_data VALUES (NULL, 5, 20, 31, 31);
INSERT INTO versification_data VALUES (NULL, 5, 21, 1, 18);
INSERT INTO versification_data VALUES (NULL, 5, 21, 2, 26);
INSERT INTO versification_data VALUES (NULL, 5, 21, 3, 22);
INSERT INTO versification_data VALUES (NULL, 5, 21, 4, 17);
INSERT INTO versification_data VALUES (NULL, 5, 21, 5, 19);
INSERT INTO versification_data VALUES (NULL, 5, 21, 6, 12);
INSERT INTO versification_data VALUES (NULL, 5, 21, 7, 29);
INSERT INTO versification_data VALUES (NULL, 5, 21, 8, 17);
INSERT INTO versification_data VALUES (NULL, 5, 21, 9, 18);
INSERT INTO versification_data VALUES (NULL, 5, 21, 10, 20);
INSERT INTO versification_data VALUES (NULL, 5, 21, 11, 10);
INSERT INTO versification_data VALUES (NULL, 5, 21, 12, 14);
INSERT INTO versification_data VALUES (NULL, 5, 22, 1, 16);
INSERT INTO versification_data VALUES (NULL, 5, 22, 2, 17);
INSERT INTO versification_data VALUES (NULL, 5, 22, 3, 11);
INSERT INTO versification_data VALUES (NULL, 5, 22, 4, 16);
INSERT INTO versification_data VALUES (NULL, 5, 22, 5, 16);
INSERT INTO versification_data VALUES (NULL, 5, 22, 6, 12);
INSERT INTO versification_data VALUES (NULL, 5, 22, 7, 14);
INSERT INTO versification_data VALUES (NULL, 5, 22, 8, 14);
INSERT INTO versification_data VALUES (NULL, 5, 23, 1, 31);
INSERT INTO versification_data VALUES (NULL, 5, 23, 2, 22);
INSERT INTO versification_data VALUES (NULL, 5, 23, 3, 25);
INSERT INTO versification_data VALUES (NULL, 5, 23, 4, 6);
INSERT INTO versification_data VALUES (NULL, 5, 23, 5, 30);
INSERT INTO versification_data VALUES (NULL, 5, 23, 6, 13);
INSERT INTO versification_data VALUES (NULL, 5, 23, 7, 25);
INSERT INTO versification_data VALUES (NULL, 5, 23, 8, 22);
INSERT INTO versification_data VALUES (NULL, 5, 23, 9, 21);
INSERT INTO versification_data VALUES (NULL, 5, 23, 10, 34);
INSERT INTO versification_data VALUES (NULL, 5, 23, 11, 16);
INSERT INTO versification_data VALUES (NULL, 5, 23, 12, 6);
INSERT INTO versification_data VALUES (NULL, 5, 23, 13, 22);
INSERT INTO versification_data VALUES (NULL, 5, 23, 14, 32);
INSERT INTO versification_data VALUES (NULL, 5, 23, 15, 9);
INSERT INTO versification_data VALUES (NULL, 5, 23, 16, 14);
INSERT INTO versification_data VALUES (NULL, 5, 23, 17, 14);
INSERT INTO versification_data VALUES (NULL, 5, 23, 18, 7);
INSERT INTO versification_data VALUES (NULL, 5, 23, 19, 25);
INSERT INTO versification_data VALUES (NULL, 5, 23, 20, 6);
INSERT INTO versification_data VALUES (NULL, 5, 23, 21, 17);
INSERT INTO versification_data VALUES (NULL, 5, 23, 22, 25);
INSERT INTO versification_data VALUES (NULL, 5, 23, 23, 18);
INSERT INTO versification_data VALUES (NULL, 5, 23, 24, 23);
INSERT INTO versification_data VALUES (NULL, 5, 23, 25, 12);
INSERT INTO versification_data VALUES (NULL, 5, 23, 26, 21);
INSERT INTO versification_data VALUES (NULL, 5, 23, 27, 13);
INSERT INTO versification_data VALUES (NULL, 5, 23, 28, 29);
INSERT INTO versification_data VALUES (NULL, 5, 23, 29, 24);
INSERT INTO versification_data VALUES (NULL, 5, 23, 30, 33);
INSERT INTO versification_data VALUES (NULL, 5, 23, 31, 9);
INSERT INTO versification_data VALUES (NULL, 5, 23, 32, 20);
INSERT INTO versification_data VALUES (NULL, 5, 23, 33, 24);
INSERT INTO versification_data VALUES (NULL, 5, 23, 34, 17);
INSERT INTO versification_data VALUES (NULL, 5, 23, 35, 10);
INSERT INTO versification_data VALUES (NULL, 5, 23, 36, 22);
INSERT INTO versification_data VALUES (NULL, 5, 23, 37, 38);
INSERT INTO versification_data VALUES (NULL, 5, 23, 38, 22);
INSERT INTO versification_data VALUES (NULL, 5, 23, 39, 8);
INSERT INTO versification_data VALUES (NULL, 5, 23, 40, 31);
INSERT INTO versification_data VALUES (NULL, 5, 23, 41, 29);
INSERT INTO versification_data VALUES (NULL, 5, 23, 42, 25);
INSERT INTO versification_data VALUES (NULL, 5, 23, 43, 28);
INSERT INTO versification_data VALUES (NULL, 5, 23, 44, 28);
INSERT INTO versification_data VALUES (NULL, 5, 23, 45, 25);
INSERT INTO versification_data VALUES (NULL, 5, 23, 46, 13);
INSERT INTO versification_data VALUES (NULL, 5, 23, 47, 15);
INSERT INTO versification_data VALUES (NULL, 5, 23, 48, 22);
INSERT INTO versification_data VALUES (NULL, 5, 23, 49, 26);
INSERT INTO versification_data VALUES (NULL, 5, 23, 50, 11);
INSERT INTO versification_data VALUES (NULL, 5, 23, 51, 23);
INSERT INTO versification_data VALUES (NULL, 5, 23, 52, 15);
INSERT INTO versification_data VALUES (NULL, 5, 23, 53, 12);
INSERT INTO versification_data VALUES (NULL, 5, 23, 54, 17);
INSERT INTO versification_data VALUES (NULL, 5, 23, 55, 13);
INSERT INTO versification_data VALUES (NULL, 5, 23, 56, 12);
INSERT INTO versification_data VALUES (NULL, 5, 23, 57, 21);
INSERT INTO versification_data VALUES (NULL, 5, 23, 58, 14);
INSERT INTO versification_data VALUES (NULL, 5, 23, 59, 21);
INSERT INTO versification_data VALUES (NULL, 5, 23, 60, 22);
INSERT INTO versification_data VALUES (NULL, 5, 23, 61, 11);
INSERT INTO versification_data VALUES (NULL, 5, 23, 62, 12);
INSERT INTO versification_data VALUES (NULL, 5, 23, 63, 19);
INSERT INTO versification_data VALUES (NULL, 5, 23, 64, 12);
INSERT INTO versification_data VALUES (NULL, 5, 23, 65, 25);
INSERT INTO versification_data VALUES (NULL, 5, 23, 66, 24);
INSERT INTO versification_data VALUES (NULL, 5, 24, 1, 19);
INSERT INTO versification_data VALUES (NULL, 5, 24, 2, 37);
INSERT INTO versification_data VALUES (NULL, 5, 24, 3, 25);
INSERT INTO versification_data VALUES (NULL, 5, 24, 4, 31);
INSERT INTO versification_data VALUES (NULL, 5, 24, 5, 31);
INSERT INTO versification_data VALUES (NULL, 5, 24, 6, 30);
INSERT INTO versification_data VALUES (NULL, 5, 24, 7, 34);
INSERT INTO versification_data VALUES (NULL, 5, 24, 8, 22);
INSERT INTO versification_data VALUES (NULL, 5, 24, 9, 26);
INSERT INTO versification_data VALUES (NULL, 5, 24, 10, 25);
INSERT INTO versification_data VALUES (NULL, 5, 24, 11, 23);
INSERT INTO versification_data VALUES (NULL, 5, 24, 12, 17);
INSERT INTO versification_data VALUES (NULL, 5, 24, 13, 27);
INSERT INTO versification_data VALUES (NULL, 5, 24, 14, 22);
INSERT INTO versification_data VALUES (NULL, 5, 24, 15, 21);
INSERT INTO versification_data VALUES (NULL, 5, 24, 16, 21);
INSERT INTO versification_data VALUES (NULL, 5, 24, 17, 27);
INSERT INTO versification_data VALUES (NULL, 5, 24, 18, 23);
INSERT INTO versification_data VALUES (NULL, 5, 24, 19, 15);
INSERT INTO versification_data VALUES (NULL, 5, 24, 20, 18);
INSERT INTO versification_data VALUES (NULL, 5, 24, 21, 14);
INSERT INTO versification_data VALUES (NULL, 5, 24, 22, 30);
INSERT INTO versification_data VALUES (NULL, 5, 24, 23, 40);
INSERT INTO versification_data VALUES (NULL, 5, 24, 24, 10);
INSERT INTO versification_data VALUES (NULL, 5, 24, 25, 38);
INSERT INTO versification_data VALUES (NULL, 5, 24, 26, 24);
INSERT INTO versification_data VALUES (NULL, 5, 24, 27, 22);
INSERT INTO versification_data VALUES (NULL, 5, 24, 28, 17);
INSERT INTO versification_data VALUES (NULL, 5, 24, 29, 32);
INSERT INTO versification_data VALUES (NULL, 5, 24, 30, 24);
INSERT INTO versification_data VALUES (NULL, 5, 24, 31, 40);
INSERT INTO versification_data VALUES (NULL, 5, 24, 32, 44);
INSERT INTO versification_data VALUES (NULL, 5, 24, 33, 26);
INSERT INTO versification_data VALUES (NULL, 5, 24, 34, 22);
INSERT INTO versification_data VALUES (NULL, 5, 24, 35, 19);
INSERT INTO versification_data VALUES (NULL, 5, 24, 36, 32);
INSERT INTO versification_data VALUES (NULL, 5, 24, 37, 21);
INSERT INTO versification_data VALUES (NULL, 5, 24, 38, 28);
INSERT INTO versification_data VALUES (NULL, 5, 24, 39, 18);
INSERT INTO versification_data VALUES (NULL, 5, 24, 40, 16);
INSERT INTO versification_data VALUES (NULL, 5, 24, 41, 18);
INSERT INTO versification_data VALUES (NULL, 5, 24, 42, 22);
INSERT INTO versification_data VALUES (NULL, 5, 24, 43, 13);
INSERT INTO versification_data VALUES (NULL, 5, 24, 44, 30);
INSERT INTO versification_data VALUES (NULL, 5, 24, 45, 5);
INSERT INTO versification_data VALUES (NULL, 5, 24, 46, 28);
INSERT INTO versification_data VALUES (NULL, 5, 24, 47, 7);
INSERT INTO versification_data VALUES (NULL, 5, 24, 48, 47);
INSERT INTO versification_data VALUES (NULL, 5, 24, 49, 39);
INSERT INTO versification_data VALUES (NULL, 5, 24, 50, 46);
INSERT INTO versification_data VALUES (NULL, 5, 24, 51, 64);
INSERT INTO versification_data VALUES (NULL, 5, 24, 52, 34);
INSERT INTO versification_data VALUES (NULL, 5, 25, 1, 22);
INSERT INTO versification_data VALUES (NULL, 5, 25, 2, 22);
INSERT INTO versification_data VALUES (NULL, 5, 25, 3, 66);
INSERT INTO versification_data VALUES (NULL, 5, 25, 4, 22);
INSERT INTO versification_data VALUES (NULL, 5, 25, 5, 22);
INSERT INTO versification_data VALUES (NULL, 5, 26, 1, 28);
INSERT INTO versification_data VALUES (NULL, 5, 26, 2, 10);
INSERT INTO versification_data VALUES (NULL, 5, 26, 3, 27);
INSERT INTO versification_data VALUES (NULL, 5, 26, 4, 17);
INSERT INTO versification_data VALUES (NULL, 5, 26, 5, 17);
INSERT INTO versification_data VALUES (NULL, 5, 26, 6, 14);
INSERT INTO versification_data VALUES (NULL, 5, 26, 7, 27);
INSERT INTO versification_data VALUES (NULL, 5, 26, 8, 18);
INSERT INTO versification_data VALUES (NULL, 5, 26, 9, 11);
INSERT INTO versification_data VALUES (NULL, 5, 26, 10, 22);
INSERT INTO versification_data VALUES (NULL, 5, 26, 11, 25);
INSERT INTO versification_data VALUES (NULL, 5, 26, 12, 28);
INSERT INTO versification_data VALUES (NULL, 5, 26, 13, 23);
INSERT INTO versification_data VALUES (NULL, 5, 26, 14, 23);
INSERT INTO versification_data VALUES (NULL, 5, 26, 15, 8);
INSERT INTO versification_data VALUES (NULL, 5, 26, 16, 63);
INSERT INTO versification_data VALUES (NULL, 5, 26, 17, 24);
INSERT INTO versification_data VALUES (NULL, 5, 26, 18, 32);
INSERT INTO versification_data VALUES (NULL, 5, 26, 19, 14);
INSERT INTO versification_data VALUES (NULL, 5, 26, 20, 49);
INSERT INTO versification_data VALUES (NULL, 5, 26, 21, 32);
INSERT INTO versification_data VALUES (NULL, 5, 26, 22, 31);
INSERT INTO versification_data VALUES (NULL, 5, 26, 23, 49);
INSERT INTO versification_data VALUES (NULL, 5, 26, 24, 27);
INSERT INTO versification_data VALUES (NULL, 5, 26, 25, 17);
INSERT INTO versification_data VALUES (NULL, 5, 26, 26, 21);
INSERT INTO versification_data VALUES (NULL, 5, 26, 27, 36);
INSERT INTO versification_data VALUES (NULL, 5, 26, 28, 26);
INSERT INTO versification_data VALUES (NULL, 5, 26, 29, 21);
INSERT INTO versification_data VALUES (NULL, 5, 26, 30, 26);
INSERT INTO versification_data VALUES (NULL, 5, 26, 31, 18);
INSERT INTO versification_data VALUES (NULL, 5, 26, 32, 32);
INSERT INTO versification_data VALUES (NULL, 5, 26, 33, 33);
INSERT INTO versification_data VALUES (NULL, 5, 26, 34, 31);
INSERT INTO versification_data VALUES (NULL, 5, 26, 35, 15);
INSERT INTO versification_data VALUES (NULL, 5, 26, 36, 38);
INSERT INTO versification_data VALUES (NULL, 5, 26, 37, 28);
INSERT INTO versification_data VALUES (NULL, 5, 26, 38, 23);
INSERT INTO versification_data VALUES (NULL, 5, 26, 39, 29);
INSERT INTO versification_data VALUES (NULL, 5, 26, 40, 49);
INSERT INTO versification_data VALUES (NULL, 5, 26, 41, 26);
INSERT INTO versification_data VALUES (NULL, 5, 26, 42, 20);
INSERT INTO versification_data VALUES (NULL, 5, 26, 43, 27);
INSERT INTO versification_data VALUES (NULL, 5, 26, 44, 31);
INSERT INTO versification_data VALUES (NULL, 5, 26, 45, 25);
INSERT INTO versification_data VALUES (NULL, 5, 26, 46, 24);
INSERT INTO versification_data VALUES (NULL, 5, 26, 47, 23);
INSERT INTO versification_data VALUES (NULL, 5, 26, 48, 35);
INSERT INTO versification_data VALUES (NULL, 5, 27, 1, 21);
INSERT INTO versification_data VALUES (NULL, 5, 27, 2, 49);
INSERT INTO versification_data VALUES (NULL, 5, 27, 3, 100);
INSERT INTO versification_data VALUES (NULL, 5, 27, 4, 34);
INSERT INTO versification_data VALUES (NULL, 5, 27, 5, 31);
INSERT INTO versification_data VALUES (NULL, 5, 27, 6, 28);
INSERT INTO versification_data VALUES (NULL, 5, 27, 7, 28);
INSERT INTO versification_data VALUES (NULL, 5, 27, 8, 27);
INSERT INTO versification_data VALUES (NULL, 5, 27, 9, 27);
INSERT INTO versification_data VALUES (NULL, 5, 27, 10, 21);
INSERT INTO versification_data VALUES (NULL, 5, 27, 11, 45);
INSERT INTO versification_data VALUES (NULL, 5, 27, 12, 13);
INSERT INTO versification_data VALUES (NULL, 5, 27, 13, 64);
INSERT INTO versification_data VALUES (NULL, 5, 27, 14, 42);
INSERT INTO versification_data VALUES (NULL, 5, 28, 1, 11);
INSERT INTO versification_data VALUES (NULL, 5, 28, 2, 23);
INSERT INTO versification_data VALUES (NULL, 5, 28, 3, 5);
INSERT INTO versification_data VALUES (NULL, 5, 28, 4, 19);
INSERT INTO versification_data VALUES (NULL, 5, 28, 5, 15);
INSERT INTO versification_data VALUES (NULL, 5, 28, 6, 11);
INSERT INTO versification_data VALUES (NULL, 5, 28, 7, 16);
INSERT INTO versification_data VALUES (NULL, 5, 28, 8, 14);
INSERT INTO versification_data VALUES (NULL, 5, 28, 9, 17);
INSERT INTO versification_data VALUES (NULL, 5, 28, 10, 15);
INSERT INTO versification_data VALUES (NULL, 5, 28, 11, 12);
INSERT INTO versification_data VALUES (NULL, 5, 28, 12, 14);
INSERT INTO versification_data VALUES (NULL, 5, 28, 13, 15);
INSERT INTO versification_data VALUES (NULL, 5, 28, 14, 10);
INSERT INTO versification_data VALUES (NULL, 5, 29, 1, 20);
INSERT INTO versification_data VALUES (NULL, 5, 29, 2, 32);
INSERT INTO versification_data VALUES (NULL, 5, 29, 3, 21);
INSERT INTO versification_data VALUES (NULL, 5, 30, 1, 15);
INSERT INTO versification_data VALUES (NULL, 5, 30, 2, 16);
INSERT INTO versification_data VALUES (NULL, 5, 30, 3, 15);
INSERT INTO versification_data VALUES (NULL, 5, 30, 4, 13);
INSERT INTO versification_data VALUES (NULL, 5, 30, 5, 27);
INSERT INTO versification_data VALUES (NULL, 5, 30, 6, 14);
INSERT INTO versification_data VALUES (NULL, 5, 30, 7, 17);
INSERT INTO versification_data VALUES (NULL, 5, 30, 8, 14);
INSERT INTO versification_data VALUES (NULL, 5, 30, 9, 15);
INSERT INTO versification_data VALUES (NULL, 5, 31, 1, 21);
INSERT INTO versification_data VALUES (NULL, 5, 32, 1, 16);
INSERT INTO versification_data VALUES (NULL, 5, 32, 2, 11);
INSERT INTO versification_data VALUES (NULL, 5, 32, 3, 10);
INSERT INTO versification_data VALUES (NULL, 5, 32, 4, 11);
INSERT INTO versification_data VALUES (NULL, 5, 33, 1, 16);
INSERT INTO versification_data VALUES (NULL, 5, 33, 2, 13);
INSERT INTO versification_data VALUES (NULL, 5, 33, 3, 12);
INSERT INTO versification_data VALUES (NULL, 5, 33, 4, 13);
INSERT INTO versification_data VALUES (NULL, 5, 33, 5, 15);
INSERT INTO versification_data VALUES (NULL, 5, 33, 6, 16);
INSERT INTO versification_data VALUES (NULL, 5, 33, 7, 20);
INSERT INTO versification_data VALUES (NULL, 5, 34, 1, 15);
INSERT INTO versification_data VALUES (NULL, 5, 34, 2, 13);
INSERT INTO versification_data VALUES (NULL, 5, 34, 3, 19);
INSERT INTO versification_data VALUES (NULL, 5, 35, 1, 17);
INSERT INTO versification_data VALUES (NULL, 5, 35, 2, 20);
INSERT INTO versification_data VALUES (NULL, 5, 35, 3, 19);
INSERT INTO versification_data VALUES (NULL, 5, 36, 1, 18);
INSERT INTO versification_data VALUES (NULL, 5, 36, 2, 15);
INSERT INTO versification_data VALUES (NULL, 5, 36, 3, 20);
INSERT INTO versification_data VALUES (NULL, 5, 37, 1, 15);
INSERT INTO versification_data VALUES (NULL, 5, 37, 2, 23);
INSERT INTO versification_data VALUES (NULL, 5, 38, 1, 21);
INSERT INTO versification_data VALUES (NULL, 5, 38, 2, 13);
INSERT INTO versification_data VALUES (NULL, 5, 38, 3, 10);
INSERT INTO versification_data VALUES (NULL, 5, 38, 4, 14);
INSERT INTO versification_data VALUES (NULL, 5, 38, 5, 11);
INSERT INTO versification_data VALUES (NULL, 5, 38, 6, 15);
INSERT INTO versification_data VALUES (NULL, 5, 38, 7, 14);
INSERT INTO versification_data VALUES (NULL, 5, 38, 8, 23);
INSERT INTO versification_data VALUES (NULL, 5, 38, 9, 17);
INSERT INTO versification_data VALUES (NULL, 5, 38, 10, 12);
INSERT INTO versification_data VALUES (NULL, 5, 38, 11, 17);
INSERT INTO versification_data VALUES (NULL, 5, 38, 12, 14);
INSERT INTO versification_data VALUES (NULL, 5, 38, 13, 9);
INSERT INTO versification_data VALUES (NULL, 5, 38, 14, 21);
INSERT INTO versification_data VALUES (NULL, 5, 39, 1, 14);
INSERT INTO versification_data VALUES (NULL, 5, 39, 2, 17);
INSERT INTO versification_data VALUES (NULL, 5, 39, 3, 18);
INSERT INTO versification_data VALUES (NULL, 5, 39, 4, 6);
INSERT INTO versification_data VALUES (NULL, 5, 40, 1, 25);
INSERT INTO versification_data VALUES (NULL, 5, 40, 2, 23);
INSERT INTO versification_data VALUES (NULL, 5, 40, 3, 17);
INSERT INTO versification_data VALUES (NULL, 5, 40, 4, 25);
INSERT INTO versification_data VALUES (NULL, 5, 40, 5, 48);
INSERT INTO versification_data VALUES (NULL, 5, 40, 6, 34);
INSERT INTO versification_data VALUES (NULL, 5, 40, 7, 29);
INSERT INTO versification_data VALUES (NULL, 5, 40, 8, 34);
INSERT INTO versification_data VALUES (NULL, 5, 40, 9, 38);
INSERT INTO versification_data VALUES (NULL, 5, 40, 10, 42);
INSERT INTO versification_data VALUES (NULL, 5, 40, 11, 30);
INSERT INTO versification_data VALUES (NULL, 5, 40, 12, 50);
INSERT INTO versification_data VALUES (NULL, 5, 40, 13, 58);
INSERT INTO versification_data VALUES (NULL, 5, 40, 14, 36);
INSERT INTO versification_data VALUES (NULL, 5, 40, 15, 39);
INSERT INTO versification_data VALUES (NULL, 5, 40, 16, 28);
INSERT INTO versification_data VALUES (NULL, 5, 40, 17, 27);
INSERT INTO versification_data VALUES (NULL, 5, 40, 18, 35);
INSERT INTO versification_data VALUES (NULL, 5, 40, 19, 30);
INSERT INTO versification_data VALUES (NULL, 5, 40, 20, 34);
INSERT INTO versification_data VALUES (NULL, 5, 40, 21, 46);
INSERT INTO versification_data VALUES (NULL, 5, 40, 22, 46);
INSERT INTO versification_data VALUES (NULL, 5, 40, 23, 39);
INSERT INTO versification_data VALUES (NULL, 5, 40, 24, 51);
INSERT INTO versification_data VALUES (NULL, 5, 40, 25, 46);
INSERT INTO versification_data VALUES (NULL, 5, 40, 26, 75);
INSERT INTO versification_data VALUES (NULL, 5, 40, 27, 66);
INSERT INTO versification_data VALUES (NULL, 5, 40, 28, 20);
INSERT INTO versification_data VALUES (NULL, 5, 41, 1, 45);
INSERT INTO versification_data VALUES (NULL, 5, 41, 2, 28);
INSERT INTO versification_data VALUES (NULL, 5, 41, 3, 35);
INSERT INTO versification_data VALUES (NULL, 5, 41, 4, 41);
INSERT INTO versification_data VALUES (NULL, 5, 41, 5, 43);
INSERT INTO versification_data VALUES (NULL, 5, 41, 6, 56);
INSERT INTO versification_data VALUES (NULL, 5, 41, 7, 37);
INSERT INTO versification_data VALUES (NULL, 5, 41, 8, 38);
INSERT INTO versification_data VALUES (NULL, 5, 41, 9, 50);
INSERT INTO versification_data VALUES (NULL, 5, 41, 10, 52);
INSERT INTO versification_data VALUES (NULL, 5, 41, 11, 33);
INSERT INTO versification_data VALUES (NULL, 5, 41, 12, 44);
INSERT INTO versification_data VALUES (NULL, 5, 41, 13, 37);
INSERT INTO versification_data VALUES (NULL, 5, 41, 14, 72);
INSERT INTO versification_data VALUES (NULL, 5, 41, 15, 47);
INSERT INTO versification_data VALUES (NULL, 5, 41, 16, 20);
INSERT INTO versification_data VALUES (NULL, 5, 42, 1, 80);
INSERT INTO versification_data VALUES (NULL, 5, 42, 2, 52);
INSERT INTO versification_data VALUES (NULL, 5, 42, 3, 38);
INSERT INTO versification_data VALUES (NULL, 5, 42, 4, 44);
INSERT INTO versification_data VALUES (NULL, 5, 42, 5, 39);
INSERT INTO versification_data VALUES (NULL, 5, 42, 6, 49);
INSERT INTO versification_data VALUES (NULL, 5, 42, 7, 50);
INSERT INTO versification_data VALUES (NULL, 5, 42, 8, 56);
INSERT INTO versification_data VALUES (NULL, 5, 42, 9, 62);
INSERT INTO versification_data VALUES (NULL, 5, 42, 10, 42);
INSERT INTO versification_data VALUES (NULL, 5, 42, 11, 54);
INSERT INTO versification_data VALUES (NULL, 5, 42, 12, 59);
INSERT INTO versification_data VALUES (NULL, 5, 42, 13, 35);
INSERT INTO versification_data VALUES (NULL, 5, 42, 14, 35);
INSERT INTO versification_data VALUES (NULL, 5, 42, 15, 32);
INSERT INTO versification_data VALUES (NULL, 5, 42, 16, 31);
INSERT INTO versification_data VALUES (NULL, 5, 42, 17, 37);
INSERT INTO versification_data VALUES (NULL, 5, 42, 18, 43);
INSERT INTO versification_data VALUES (NULL, 5, 42, 19, 48);
INSERT INTO versification_data VALUES (NULL, 5, 42, 20, 47);
INSERT INTO versification_data VALUES (NULL, 5, 42, 21, 38);
INSERT INTO versification_data VALUES (NULL, 5, 42, 22, 71);
INSERT INTO versification_data VALUES (NULL, 5, 42, 23, 56);
INSERT INTO versification_data VALUES (NULL, 5, 42, 24, 53);
INSERT INTO versification_data VALUES (NULL, 5, 43, 1, 51);
INSERT INTO versification_data VALUES (NULL, 5, 43, 2, 25);
INSERT INTO versification_data VALUES (NULL, 5, 43, 3, 36);
INSERT INTO versification_data VALUES (NULL, 5, 43, 4, 54);
INSERT INTO versification_data VALUES (NULL, 5, 43, 5, 47);
INSERT INTO versification_data VALUES (NULL, 5, 43, 6, 71);
INSERT INTO versification_data VALUES (NULL, 5, 43, 7, 53);
INSERT INTO versification_data VALUES (NULL, 5, 43, 8, 59);
INSERT INTO versification_data VALUES (NULL, 5, 43, 9, 41);
INSERT INTO versification_data VALUES (NULL, 5, 43, 10, 42);
INSERT INTO versification_data VALUES (NULL, 5, 43, 11, 57);
INSERT INTO versification_data VALUES (NULL, 5, 43, 12, 50);
INSERT INTO versification_data VALUES (NULL, 5, 43, 13, 38);
INSERT INTO versification_data VALUES (NULL, 5, 43, 14, 31);
INSERT INTO versification_data VALUES (NULL, 5, 43, 15, 27);
INSERT INTO versification_data VALUES (NULL, 5, 43, 16, 33);
INSERT INTO versification_data VALUES (NULL, 5, 43, 17, 26);
INSERT INTO versification_data VALUES (NULL, 5, 43, 18, 40);
INSERT INTO versification_data VALUES (NULL, 5, 43, 19, 42);
INSERT INTO versification_data VALUES (NULL, 5, 43, 20, 31);
INSERT INTO versification_data VALUES (NULL, 5, 43, 21, 25);
INSERT INTO versification_data VALUES (NULL, 5, 44, 1, 26);
INSERT INTO versification_data VALUES (NULL, 5, 44, 2, 47);
INSERT INTO versification_data VALUES (NULL, 5, 44, 3, 26);
INSERT INTO versification_data VALUES (NULL, 5, 44, 4, 37);
INSERT INTO versification_data VALUES (NULL, 5, 44, 5, 42);
INSERT INTO versification_data VALUES (NULL, 5, 44, 6, 15);
INSERT INTO versification_data VALUES (NULL, 5, 44, 7, 60);
INSERT INTO versification_data VALUES (NULL, 5, 44, 8, 40);
INSERT INTO versification_data VALUES (NULL, 5, 44, 9, 43);
INSERT INTO versification_data VALUES (NULL, 5, 44, 10, 48);
INSERT INTO versification_data VALUES (NULL, 5, 44, 11, 30);
INSERT INTO versification_data VALUES (NULL, 5, 44, 12, 25);
INSERT INTO versification_data VALUES (NULL, 5, 44, 13, 52);
INSERT INTO versification_data VALUES (NULL, 5, 44, 14, 28);
INSERT INTO versification_data VALUES (NULL, 5, 44, 15, 41);
INSERT INTO versification_data VALUES (NULL, 5, 44, 16, 40);
INSERT INTO versification_data VALUES (NULL, 5, 44, 17, 34);
INSERT INTO versification_data VALUES (NULL, 5, 44, 18, 28);
INSERT INTO versification_data VALUES (NULL, 5, 44, 19, 40);
INSERT INTO versification_data VALUES (NULL, 5, 44, 20, 38);
INSERT INTO versification_data VALUES (NULL, 5, 44, 21, 40);
INSERT INTO versification_data VALUES (NULL, 5, 44, 22, 30);
INSERT INTO versification_data VALUES (NULL, 5, 44, 23, 35);
INSERT INTO versification_data VALUES (NULL, 5, 44, 24, 27);
INSERT INTO versification_data VALUES (NULL, 5, 44, 25, 27);
INSERT INTO versification_data VALUES (NULL, 5, 44, 26, 32);
INSERT INTO versification_data VALUES (NULL, 5, 44, 27, 44);
INSERT INTO versification_data VALUES (NULL, 5, 44, 28, 31);
INSERT INTO versification_data VALUES (NULL, 5, 45, 1, 32);
INSERT INTO versification_data VALUES (NULL, 5, 45, 2, 29);
INSERT INTO versification_data VALUES (NULL, 5, 45, 3, 31);
INSERT INTO versification_data VALUES (NULL, 5, 45, 4, 25);
INSERT INTO versification_data VALUES (NULL, 5, 45, 5, 21);
INSERT INTO versification_data VALUES (NULL, 5, 45, 6, 23);
INSERT INTO versification_data VALUES (NULL, 5, 45, 7, 25);
INSERT INTO versification_data VALUES (NULL, 5, 45, 8, 39);
INSERT INTO versification_data VALUES (NULL, 5, 45, 9, 33);
INSERT INTO versification_data VALUES (NULL, 5, 45, 10, 21);
INSERT INTO versification_data VALUES (NULL, 5, 45, 11, 36);
INSERT INTO versification_data VALUES (NULL, 5, 45, 12, 21);
INSERT INTO versification_data VALUES (NULL, 5, 45, 13, 14);
INSERT INTO versification_data VALUES (NULL, 5, 45, 14, 26);
INSERT INTO versification_data VALUES (NULL, 5, 45, 15, 33);
INSERT INTO versification_data VALUES (NULL, 5, 45, 16, 24);
INSERT INTO versification_data VALUES (NULL, 5, 46, 1, 31);
INSERT INTO versification_data VALUES (NULL, 5, 46, 2, 16);
INSERT INTO versification_data VALUES (NULL, 5, 46, 3, 23);
INSERT INTO versification_data VALUES (NULL, 5, 46, 4, 21);
INSERT INTO versification_data VALUES (NULL, 5, 46, 5, 13);
INSERT INTO versification_data VALUES (NULL, 5, 46, 6, 20);
INSERT INTO versification_data VALUES (NULL, 5, 46, 7, 40);
INSERT INTO versification_data VALUES (NULL, 5, 46, 8, 13);
INSERT INTO versification_data VALUES (NULL, 5, 46, 9, 27);
INSERT INTO versification_data VALUES (NULL, 5, 46, 10, 33);
INSERT INTO versification_data VALUES (NULL, 5, 46, 11, 34);
INSERT INTO versification_data VALUES (NULL, 5, 46, 12, 31);
INSERT INTO versification_data VALUES (NULL, 5, 46, 13, 13);
INSERT INTO versification_data VALUES (NULL, 5, 46, 14, 40);
INSERT INTO versification_data VALUES (NULL, 5, 46, 15, 58);
INSERT INTO versification_data VALUES (NULL, 5, 46, 16, 24);
INSERT INTO versification_data VALUES (NULL, 5, 47, 1, 24);
INSERT INTO versification_data VALUES (NULL, 5, 47, 2, 17);
INSERT INTO versification_data VALUES (NULL, 5, 47, 3, 18);
INSERT INTO versification_data VALUES (NULL, 5, 47, 4, 18);
INSERT INTO versification_data VALUES (NULL, 5, 47, 5, 21);
INSERT INTO versification_data VALUES (NULL, 5, 47, 6, 18);
INSERT INTO versification_data VALUES (NULL, 5, 47, 7, 16);
INSERT INTO versification_data VALUES (NULL, 5, 47, 8, 24);
INSERT INTO versification_data VALUES (NULL, 5, 47, 9, 15);
INSERT INTO versification_data VALUES (NULL, 5, 47, 10, 18);
INSERT INTO versification_data VALUES (NULL, 5, 47, 11, 32);
INSERT INTO versification_data VALUES (NULL, 5, 47, 12, 21);
INSERT INTO versification_data VALUES (NULL, 5, 47, 13, 13);
INSERT INTO versification_data VALUES (NULL, 5, 48, 1, 24);
INSERT INTO versification_data VALUES (NULL, 5, 48, 2, 21);
INSERT INTO versification_data VALUES (NULL, 5, 48, 3, 29);
INSERT INTO versification_data VALUES (NULL, 5, 48, 4, 31);
INSERT INTO versification_data VALUES (NULL, 5, 48, 5, 26);
INSERT INTO versification_data VALUES (NULL, 5, 48, 6, 18);
INSERT INTO versification_data VALUES (NULL, 5, 49, 1, 23);
INSERT INTO versification_data VALUES (NULL, 5, 49, 2, 22);
INSERT INTO versification_data VALUES (NULL, 5, 49, 3, 21);
INSERT INTO versification_data VALUES (NULL, 5, 49, 4, 32);
INSERT INTO versification_data VALUES (NULL, 5, 49, 5, 33);
INSERT INTO versification_data VALUES (NULL, 5, 49, 6, 24);
INSERT INTO versification_data VALUES (NULL, 5, 50, 1, 30);
INSERT INTO versification_data VALUES (NULL, 5, 50, 2, 30);
INSERT INTO versification_data VALUES (NULL, 5, 50, 3, 21);
INSERT INTO versification_data VALUES (NULL, 5, 50, 4, 23);
INSERT INTO versification_data VALUES (NULL, 5, 51, 1, 29);
INSERT INTO versification_data VALUES (NULL, 5, 51, 2, 23);
INSERT INTO versification_data VALUES (NULL, 5, 51, 3, 25);
INSERT INTO versification_data VALUES (NULL, 5, 51, 4, 18);
INSERT INTO versification_data VALUES (NULL, 5, 52, 1, 10);
INSERT INTO versification_data VALUES (NULL, 5, 52, 2, 20);
INSERT INTO versification_data VALUES (NULL, 5, 52, 3, 13);
INSERT INTO versification_data VALUES (NULL, 5, 52, 4, 18);
INSERT INTO versification_data VALUES (NULL, 5, 52, 5, 28);
INSERT INTO versification_data VALUES (NULL, 5, 53, 1, 12);
INSERT INTO versification_data VALUES (NULL, 5, 53, 2, 17);
INSERT INTO versification_data VALUES (NULL, 5, 53, 3, 18);
INSERT INTO versification_data VALUES (NULL, 5, 54, 1, 20);
INSERT INTO versification_data VALUES (NULL, 5, 54, 2, 15);
INSERT INTO versification_data VALUES (NULL, 5, 54, 3, 16);
INSERT INTO versification_data VALUES (NULL, 5, 54, 4, 16);
INSERT INTO versification_data VALUES (NULL, 5, 54, 5, 25);
INSERT INTO versification_data VALUES (NULL, 5, 54, 6, 21);
INSERT INTO versification_data VALUES (NULL, 5, 55, 1, 18);
INSERT INTO versification_data VALUES (NULL, 5, 55, 2, 26);
INSERT INTO versification_data VALUES (NULL, 5, 55, 3, 17);
INSERT INTO versification_data VALUES (NULL, 5, 55, 4, 22);
INSERT INTO versification_data VALUES (NULL, 5, 56, 1, 16);
INSERT INTO versification_data VALUES (NULL, 5, 56, 2, 15);
INSERT INTO versification_data VALUES (NULL, 5, 56, 3, 15);
INSERT INTO versification_data VALUES (NULL, 5, 57, 1, 25);
INSERT INTO versification_data VALUES (NULL, 5, 58, 1, 14);
INSERT INTO versification_data VALUES (NULL, 5, 58, 2, 18);
INSERT INTO versification_data VALUES (NULL, 5, 58, 3, 19);
INSERT INTO versification_data VALUES (NULL, 5, 58, 4, 16);
INSERT INTO versification_data VALUES (NULL, 5, 58, 5, 14);
INSERT INTO versification_data VALUES (NULL, 5, 58, 6, 20);
INSERT INTO versification_data VALUES (NULL, 5, 58, 7, 28);
INSERT INTO versification_data VALUES (NULL, 5, 58, 8, 13);
INSERT INTO versification_data VALUES (NULL, 5, 58, 9, 28);
INSERT INTO versification_data VALUES (NULL, 5, 58, 10, 39);
INSERT INTO versification_data VALUES (NULL, 5, 58, 11, 40);
INSERT INTO versification_data VALUES (NULL, 5, 58, 12, 29);
INSERT INTO versification_data VALUES (NULL, 5, 58, 13, 25);
INSERT INTO versification_data VALUES (NULL, 5, 59, 1, 27);
INSERT INTO versification_data VALUES (NULL, 5, 59, 2, 26);
INSERT INTO versification_data VALUES (NULL, 5, 59, 3, 18);
INSERT INTO versification_data VALUES (NULL, 5, 59, 4, 17);
INSERT INTO versification_data VALUES (NULL, 5, 59, 5, 20);
INSERT INTO versification_data VALUES (NULL, 5, 60, 1, 25);
INSERT INTO versification_data VALUES (NULL, 5, 60, 2, 25);
INSERT INTO versification_data VALUES (NULL, 5, 60, 3, 22);
INSERT INTO versification_data VALUES (NULL, 5, 60, 4, 19);
INSERT INTO versification_data VALUES (NULL, 5, 60, 5, 14);
INSERT INTO versification_data VALUES (NULL, 5, 61, 1, 21);
INSERT INTO versification_data VALUES (NULL, 5, 61, 2, 22);
INSERT INTO versification_data VALUES (NULL, 5, 61, 3, 18);
INSERT INTO versification_data VALUES (NULL, 5, 62, 1, 10);
INSERT INTO versification_data VALUES (NULL, 5, 62, 2, 29);
INSERT INTO versification_data VALUES (NULL, 5, 62, 3, 24);
INSERT INTO versification_data VALUES (NULL, 5, 62, 4, 21);
INSERT INTO versification_data VALUES (NULL, 5, 62, 5, 21);
INSERT INTO versification_data VALUES (NULL, 5, 63, 1, 13);
INSERT INTO versification_data VALUES (NULL, 5, 64, 1, 15);
INSERT INTO versification_data VALUES (NULL, 5, 65, 1, 25);
INSERT INTO versification_data VALUES (NULL, 5, 66, 1, 20);
INSERT INTO versification_data VALUES (NULL, 5, 66, 2, 29);
INSERT INTO versification_data VALUES (NULL, 5, 66, 3, 22);
INSERT INTO versification_data VALUES (NULL, 5, 66, 4, 11);
INSERT INTO versification_data VALUES (NULL, 5, 66, 5, 14);
INSERT INTO versification_data VALUES (NULL, 5, 66, 6, 17);
INSERT INTO versification_data VALUES (NULL, 5, 66, 7, 17);
INSERT INTO versification_data VALUES (NULL, 5, 66, 8, 13);
INSERT INTO versification_data VALUES (NULL, 5, 66, 9, 21);
INSERT INTO versification_data VALUES (NULL, 5, 66, 10, 11);
INSERT INTO versification_data VALUES (NULL, 5, 66, 11, 19);
INSERT INTO versification_data VALUES (NULL, 5, 66, 12, 17);
INSERT INTO versification_data VALUES (NULL, 5, 66, 13, 18);
INSERT INTO versification_data VALUES (NULL, 5, 66, 14, 20);
INSERT INTO versification_data VALUES (NULL, 5, 66, 15, 8);
INSERT INTO versification_data VALUES (NULL, 5, 66, 16, 21);
INSERT INTO versification_data VALUES (NULL, 5, 66, 17, 18);
INSERT INTO versification_data VALUES (NULL, 5, 66, 18, 24);
INSERT INTO versification_data VALUES (NULL, 5, 66, 19, 21);
INSERT INTO versification_data VALUES (NULL, 5, 66, 20, 15);
INSERT INTO versification_data VALUES (NULL, 5, 66, 21, 27);
INSERT INTO versification_data VALUES (NULL, 5, 66, 22, 21);

INSERT INTO versification_names VALUES (6, 'Septuagint');

INSERT INTO versification_data VALUES (NULL, 6, 1, 1, 31);
INSERT INTO versification_data VALUES (NULL, 6, 1, 2, 25);
INSERT INTO versification_data VALUES (NULL, 6, 1, 3, 24);
INSERT INTO versification_data VALUES (NULL, 6, 1, 4, 26);
INSERT INTO versification_data VALUES (NULL, 6, 1, 5, 32);
INSERT INTO versification_data VALUES (NULL, 6, 1, 6, 22);
INSERT INTO versification_data VALUES (NULL, 6, 1, 7, 24);
INSERT INTO versification_data VALUES (NULL, 6, 1, 8, 22);
INSERT INTO versification_data VALUES (NULL, 6, 1, 9, 29);
INSERT INTO versification_data VALUES (NULL, 6, 1, 10, 32);
INSERT INTO versification_data VALUES (NULL, 6, 1, 11, 32);
INSERT INTO versification_data VALUES (NULL, 6, 1, 12, 20);
INSERT INTO versification_data VALUES (NULL, 6, 1, 13, 18);
INSERT INTO versification_data VALUES (NULL, 6, 1, 14, 24);
INSERT INTO versification_data VALUES (NULL, 6, 1, 15, 21);
INSERT INTO versification_data VALUES (NULL, 6, 1, 16, 16);
INSERT INTO versification_data VALUES (NULL, 6, 1, 17, 27);
INSERT INTO versification_data VALUES (NULL, 6, 1, 18, 33);
INSERT INTO versification_data VALUES (NULL, 6, 1, 19, 38);
INSERT INTO versification_data VALUES (NULL, 6, 1, 20, 18);
INSERT INTO versification_data VALUES (NULL, 6, 1, 21, 34);
INSERT INTO versification_data VALUES (NULL, 6, 1, 22, 24);
INSERT INTO versification_data VALUES (NULL, 6, 1, 23, 20);
INSERT INTO versification_data VALUES (NULL, 6, 1, 24, 67);
INSERT INTO versification_data VALUES (NULL, 6, 1, 25, 34);
INSERT INTO versification_data VALUES (NULL, 6, 1, 26, 35);
INSERT INTO versification_data VALUES (NULL, 6, 1, 27, 46);
INSERT INTO versification_data VALUES (NULL, 6, 1, 28, 22);
INSERT INTO versification_data VALUES (NULL, 6, 1, 29, 35);
INSERT INTO versification_data VALUES (NULL, 6, 1, 30, 43);
INSERT INTO versification_data VALUES (NULL, 6, 1, 31, 54);
INSERT INTO versification_data VALUES (NULL, 6, 1, 32, 33);
INSERT INTO versification_data VALUES (NULL, 6, 1, 33, 20);
INSERT INTO versification_data VALUES (NULL, 6, 1, 34, 31);
INSERT INTO versification_data VALUES (NULL, 6, 1, 35, 29);
INSERT INTO versification_data VALUES (NULL, 6, 1, 36, 43);
INSERT INTO versification_data VALUES (NULL, 6, 1, 37, 36);
INSERT INTO versification_data VALUES (NULL, 6, 1, 38, 30);
INSERT INTO versification_data VALUES (NULL, 6, 1, 39, 23);
INSERT INTO versification_data VALUES (NULL, 6, 1, 40, 23);
INSERT INTO versification_data VALUES (NULL, 6, 1, 41, 57);
INSERT INTO versification_data VALUES (NULL, 6, 1, 42, 38);
INSERT INTO versification_data VALUES (NULL, 6, 1, 43, 34);
INSERT INTO versification_data VALUES (NULL, 6, 1, 44, 34);
INSERT INTO versification_data VALUES (NULL, 6, 1, 45, 28);
INSERT INTO versification_data VALUES (NULL, 6, 1, 46, 34);
INSERT INTO versification_data VALUES (NULL, 6, 1, 47, 31);
INSERT INTO versification_data VALUES (NULL, 6, 1, 48, 22);
INSERT INTO versification_data VALUES (NULL, 6, 1, 49, 33);
INSERT INTO versification_data VALUES (NULL, 6, 1, 50, 26);
INSERT INTO versification_data VALUES (NULL, 6, 2, 1, 22);
INSERT INTO versification_data VALUES (NULL, 6, 2, 2, 25);
INSERT INTO versification_data VALUES (NULL, 6, 2, 3, 22);
INSERT INTO versification_data VALUES (NULL, 6, 2, 4, 31);
INSERT INTO versification_data VALUES (NULL, 6, 2, 5, 23);
INSERT INTO versification_data VALUES (NULL, 6, 2, 6, 30);
INSERT INTO versification_data VALUES (NULL, 6, 2, 7, 29);
INSERT INTO versification_data VALUES (NULL, 6, 2, 8, 28);
INSERT INTO versification_data VALUES (NULL, 6, 2, 9, 35);
INSERT INTO versification_data VALUES (NULL, 6, 2, 10, 29);
INSERT INTO versification_data VALUES (NULL, 6, 2, 11, 10);
INSERT INTO versification_data VALUES (NULL, 6, 2, 12, 51);
INSERT INTO versification_data VALUES (NULL, 6, 2, 13, 22);
INSERT INTO versification_data VALUES (NULL, 6, 2, 14, 31);
INSERT INTO versification_data VALUES (NULL, 6, 2, 15, 27);
INSERT INTO versification_data VALUES (NULL, 6, 2, 16, 36);
INSERT INTO versification_data VALUES (NULL, 6, 2, 17, 16);
INSERT INTO versification_data VALUES (NULL, 6, 2, 18, 27);
INSERT INTO versification_data VALUES (NULL, 6, 2, 19, 25);
INSERT INTO versification_data VALUES (NULL, 6, 2, 20, 26);
INSERT INTO versification_data VALUES (NULL, 6, 2, 21, 37);
INSERT INTO versification_data VALUES (NULL, 6, 2, 22, 30);
INSERT INTO versification_data VALUES (NULL, 6, 2, 23, 33);
INSERT INTO versification_data VALUES (NULL, 6, 2, 24, 18);
INSERT INTO versification_data VALUES (NULL, 6, 2, 25, 40);
INSERT INTO versification_data VALUES (NULL, 6, 2, 26, 37);
INSERT INTO versification_data VALUES (NULL, 6, 2, 27, 21);
INSERT INTO versification_data VALUES (NULL, 6, 2, 28, 43);
INSERT INTO versification_data VALUES (NULL, 6, 2, 29, 46);
INSERT INTO versification_data VALUES (NULL, 6, 2, 30, 38);
INSERT INTO versification_data VALUES (NULL, 6, 2, 31, 18);
INSERT INTO versification_data VALUES (NULL, 6, 2, 32, 35);
INSERT INTO versification_data VALUES (NULL, 6, 2, 33, 23);
INSERT INTO versification_data VALUES (NULL, 6, 2, 34, 35);
INSERT INTO versification_data VALUES (NULL, 6, 2, 35, 35);
INSERT INTO versification_data VALUES (NULL, 6, 2, 36, 38);
INSERT INTO versification_data VALUES (NULL, 6, 2, 37, 21);
INSERT INTO versification_data VALUES (NULL, 6, 2, 38, 27);
INSERT INTO versification_data VALUES (NULL, 6, 2, 39, 23);
INSERT INTO versification_data VALUES (NULL, 6, 2, 40, 38);
INSERT INTO versification_data VALUES (NULL, 6, 3, 1, 17);
INSERT INTO versification_data VALUES (NULL, 6, 3, 2, 16);
INSERT INTO versification_data VALUES (NULL, 6, 3, 3, 17);
INSERT INTO versification_data VALUES (NULL, 6, 3, 4, 35);
INSERT INTO versification_data VALUES (NULL, 6, 3, 5, 26);
INSERT INTO versification_data VALUES (NULL, 6, 3, 6, 23);
INSERT INTO versification_data VALUES (NULL, 6, 3, 7, 38);
INSERT INTO versification_data VALUES (NULL, 6, 3, 8, 36);
INSERT INTO versification_data VALUES (NULL, 6, 3, 9, 24);
INSERT INTO versification_data VALUES (NULL, 6, 3, 10, 20);
INSERT INTO versification_data VALUES (NULL, 6, 3, 11, 47);
INSERT INTO versification_data VALUES (NULL, 6, 3, 12, 8);
INSERT INTO versification_data VALUES (NULL, 6, 3, 13, 59);
INSERT INTO versification_data VALUES (NULL, 6, 3, 14, 57);
INSERT INTO versification_data VALUES (NULL, 6, 3, 15, 33);
INSERT INTO versification_data VALUES (NULL, 6, 3, 16, 34);
INSERT INTO versification_data VALUES (NULL, 6, 3, 17, 16);
INSERT INTO versification_data VALUES (NULL, 6, 3, 18, 30);
INSERT INTO versification_data VALUES (NULL, 6, 3, 19, 37);
INSERT INTO versification_data VALUES (NULL, 6, 3, 20, 27);
INSERT INTO versification_data VALUES (NULL, 6, 3, 21, 24);
INSERT INTO versification_data VALUES (NULL, 6, 3, 22, 33);
INSERT INTO versification_data VALUES (NULL, 6, 3, 23, 44);
INSERT INTO versification_data VALUES (NULL, 6, 3, 24, 23);
INSERT INTO versification_data VALUES (NULL, 6, 3, 25, 55);
INSERT INTO versification_data VALUES (NULL, 6, 3, 26, 46);
INSERT INTO versification_data VALUES (NULL, 6, 3, 27, 34);
INSERT INTO versification_data VALUES (NULL, 6, 4, 1, 54);
INSERT INTO versification_data VALUES (NULL, 6, 4, 2, 34);
INSERT INTO versification_data VALUES (NULL, 6, 4, 3, 51);
INSERT INTO versification_data VALUES (NULL, 6, 4, 4, 49);
INSERT INTO versification_data VALUES (NULL, 6, 4, 5, 31);
INSERT INTO versification_data VALUES (NULL, 6, 4, 6, 26);
INSERT INTO versification_data VALUES (NULL, 6, 4, 7, 89);
INSERT INTO versification_data VALUES (NULL, 6, 4, 8, 26);
INSERT INTO versification_data VALUES (NULL, 6, 4, 9, 23);
INSERT INTO versification_data VALUES (NULL, 6, 4, 10, 36);
INSERT INTO versification_data VALUES (NULL, 6, 4, 11, 35);
INSERT INTO versification_data VALUES (NULL, 6, 4, 12, 16);
INSERT INTO versification_data VALUES (NULL, 6, 4, 13, 33);
INSERT INTO versification_data VALUES (NULL, 6, 4, 14, 45);
INSERT INTO versification_data VALUES (NULL, 6, 4, 15, 41);
INSERT INTO versification_data VALUES (NULL, 6, 4, 16, 35);
INSERT INTO versification_data VALUES (NULL, 6, 4, 17, 28);
INSERT INTO versification_data VALUES (NULL, 6, 4, 18, 32);
INSERT INTO versification_data VALUES (NULL, 6, 4, 19, 22);
INSERT INTO versification_data VALUES (NULL, 6, 4, 20, 29);
INSERT INTO versification_data VALUES (NULL, 6, 4, 21, 35);
INSERT INTO versification_data VALUES (NULL, 6, 4, 22, 41);
INSERT INTO versification_data VALUES (NULL, 6, 4, 23, 30);
INSERT INTO versification_data VALUES (NULL, 6, 4, 24, 25);
INSERT INTO versification_data VALUES (NULL, 6, 4, 25, 18);
INSERT INTO versification_data VALUES (NULL, 6, 4, 26, 65);
INSERT INTO versification_data VALUES (NULL, 6, 4, 27, 23);
INSERT INTO versification_data VALUES (NULL, 6, 4, 28, 31);
INSERT INTO versification_data VALUES (NULL, 6, 4, 29, 39);
INSERT INTO versification_data VALUES (NULL, 6, 4, 30, 17);
INSERT INTO versification_data VALUES (NULL, 6, 4, 31, 54);
INSERT INTO versification_data VALUES (NULL, 6, 4, 32, 42);
INSERT INTO versification_data VALUES (NULL, 6, 4, 33, 56);
INSERT INTO versification_data VALUES (NULL, 6, 4, 34, 29);
INSERT INTO versification_data VALUES (NULL, 6, 4, 35, 34);
INSERT INTO versification_data VALUES (NULL, 6, 4, 36, 13);
INSERT INTO versification_data VALUES (NULL, 6, 5, 1, 46);
INSERT INTO versification_data VALUES (NULL, 6, 5, 2, 37);
INSERT INTO versification_data VALUES (NULL, 6, 5, 3, 29);
INSERT INTO versification_data VALUES (NULL, 6, 5, 4, 49);
INSERT INTO versification_data VALUES (NULL, 6, 5, 5, 33);
INSERT INTO versification_data VALUES (NULL, 6, 5, 6, 25);
INSERT INTO versification_data VALUES (NULL, 6, 5, 7, 26);
INSERT INTO versification_data VALUES (NULL, 6, 5, 8, 20);
INSERT INTO versification_data VALUES (NULL, 6, 5, 9, 29);
INSERT INTO versification_data VALUES (NULL, 6, 5, 10, 22);
INSERT INTO versification_data VALUES (NULL, 6, 5, 11, 32);
INSERT INTO versification_data VALUES (NULL, 6, 5, 12, 31);
INSERT INTO versification_data VALUES (NULL, 6, 5, 13, 19);
INSERT INTO versification_data VALUES (NULL, 6, 5, 14, 29);
INSERT INTO versification_data VALUES (NULL, 6, 5, 15, 23);
INSERT INTO versification_data VALUES (NULL, 6, 5, 16, 22);
INSERT INTO versification_data VALUES (NULL, 6, 5, 17, 20);
INSERT INTO versification_data VALUES (NULL, 6, 5, 18, 22);
INSERT INTO versification_data VALUES (NULL, 6, 5, 19, 21);
INSERT INTO versification_data VALUES (NULL, 6, 5, 20, 20);
INSERT INTO versification_data VALUES (NULL, 6, 5, 21, 23);
INSERT INTO versification_data VALUES (NULL, 6, 5, 22, 29);
INSERT INTO versification_data VALUES (NULL, 6, 5, 23, 26);
INSERT INTO versification_data VALUES (NULL, 6, 5, 24, 22);
INSERT INTO versification_data VALUES (NULL, 6, 5, 25, 19);
INSERT INTO versification_data VALUES (NULL, 6, 5, 26, 19);
INSERT INTO versification_data VALUES (NULL, 6, 5, 27, 26);
INSERT INTO versification_data VALUES (NULL, 6, 5, 28, 69);
INSERT INTO versification_data VALUES (NULL, 6, 5, 29, 28);
INSERT INTO versification_data VALUES (NULL, 6, 5, 30, 20);
INSERT INTO versification_data VALUES (NULL, 6, 5, 31, 30);
INSERT INTO versification_data VALUES (NULL, 6, 5, 32, 52);
INSERT INTO versification_data VALUES (NULL, 6, 5, 33, 29);
INSERT INTO versification_data VALUES (NULL, 6, 5, 34, 12);
INSERT INTO versification_data VALUES (NULL, 6, 6, 1, 18);
INSERT INTO versification_data VALUES (NULL, 6, 6, 2, 24);
INSERT INTO versification_data VALUES (NULL, 6, 6, 3, 17);
INSERT INTO versification_data VALUES (NULL, 6, 6, 4, 24);
INSERT INTO versification_data VALUES (NULL, 6, 6, 5, 15);
INSERT INTO versification_data VALUES (NULL, 6, 6, 6, 27);
INSERT INTO versification_data VALUES (NULL, 6, 6, 7, 26);
INSERT INTO versification_data VALUES (NULL, 6, 6, 8, 29);
INSERT INTO versification_data VALUES (NULL, 6, 6, 9, 27);
INSERT INTO versification_data VALUES (NULL, 6, 6, 10, 42);
INSERT INTO versification_data VALUES (NULL, 6, 6, 11, 23);
INSERT INTO versification_data VALUES (NULL, 6, 6, 12, 24);
INSERT INTO versification_data VALUES (NULL, 6, 6, 13, 32);
INSERT INTO versification_data VALUES (NULL, 6, 6, 14, 15);
INSERT INTO versification_data VALUES (NULL, 6, 6, 15, 63);
INSERT INTO versification_data VALUES (NULL, 6, 6, 16, 10);
INSERT INTO versification_data VALUES (NULL, 6, 6, 17, 18);
INSERT INTO versification_data VALUES (NULL, 6, 6, 18, 28);
INSERT INTO versification_data VALUES (NULL, 6, 6, 19, 51);
INSERT INTO versification_data VALUES (NULL, 6, 6, 20, 9);
INSERT INTO versification_data VALUES (NULL, 6, 6, 21, 45);
INSERT INTO versification_data VALUES (NULL, 6, 6, 22, 34);
INSERT INTO versification_data VALUES (NULL, 6, 6, 23, 16);
INSERT INTO versification_data VALUES (NULL, 6, 6, 24, 33);
INSERT INTO versification_data VALUES (NULL, 6, 7, 1, 36);
INSERT INTO versification_data VALUES (NULL, 6, 7, 2, 23);
INSERT INTO versification_data VALUES (NULL, 6, 7, 3, 31);
INSERT INTO versification_data VALUES (NULL, 6, 7, 4, 24);
INSERT INTO versification_data VALUES (NULL, 6, 7, 5, 31);
INSERT INTO versification_data VALUES (NULL, 6, 7, 6, 40);
INSERT INTO versification_data VALUES (NULL, 6, 7, 7, 25);
INSERT INTO versification_data VALUES (NULL, 6, 7, 8, 35);
INSERT INTO versification_data VALUES (NULL, 6, 7, 9, 57);
INSERT INTO versification_data VALUES (NULL, 6, 7, 10, 18);
INSERT INTO versification_data VALUES (NULL, 6, 7, 11, 40);
INSERT INTO versification_data VALUES (NULL, 6, 7, 12, 15);
INSERT INTO versification_data VALUES (NULL, 6, 7, 13, 25);
INSERT INTO versification_data VALUES (NULL, 6, 7, 14, 20);
INSERT INTO versification_data VALUES (NULL, 6, 7, 15, 20);
INSERT INTO versification_data VALUES (NULL, 6, 7, 16, 31);
INSERT INTO versification_data VALUES (NULL, 6, 7, 17, 13);
INSERT INTO versification_data VALUES (NULL, 6, 7, 18, 31);
INSERT INTO versification_data VALUES (NULL, 6, 7, 19, 30);
INSERT INTO versification_data VALUES (NULL, 6, 7, 20, 48);
INSERT INTO versification_data VALUES (NULL, 6, 7, 21, 25);
INSERT INTO versification_data VALUES (NULL, 6, 8, 1, 22);
INSERT INTO versification_data VALUES (NULL, 6, 8, 2, 23);
INSERT INTO versification_data VALUES (NULL, 6, 8, 3, 18);
INSERT INTO versification_data VALUES (NULL, 6, 8, 4, 22);
INSERT INTO versification_data VALUES (NULL, 6, 9, 1, 28);
INSERT INTO versification_data VALUES (NULL, 6, 9, 2, 36);
INSERT INTO versification_data VALUES (NULL, 6, 9, 3, 21);
INSERT INTO versification_data VALUES (NULL, 6, 9, 4, 22);
INSERT INTO versification_data VALUES (NULL, 6, 9, 5, 12);
INSERT INTO versification_data VALUES (NULL, 6, 9, 6, 21);
INSERT INTO versification_data VALUES (NULL, 6, 9, 7, 17);
INSERT INTO versification_data VALUES (NULL, 6, 9, 8, 22);
INSERT INTO versification_data VALUES (NULL, 6, 9, 9, 27);
INSERT INTO versification_data VALUES (NULL, 6, 9, 10, 27);
INSERT INTO versification_data VALUES (NULL, 6, 9, 11, 15);
INSERT INTO versification_data VALUES (NULL, 6, 9, 12, 25);
INSERT INTO versification_data VALUES (NULL, 6, 9, 13, 23);
INSERT INTO versification_data VALUES (NULL, 6, 9, 14, 52);
INSERT INTO versification_data VALUES (NULL, 6, 9, 15, 35);
INSERT INTO versification_data VALUES (NULL, 6, 9, 16, 23);
INSERT INTO versification_data VALUES (NULL, 6, 9, 17, 54);
INSERT INTO versification_data VALUES (NULL, 6, 9, 18, 29);
INSERT INTO versification_data VALUES (NULL, 6, 9, 19, 24);
INSERT INTO versification_data VALUES (NULL, 6, 9, 20, 42);
INSERT INTO versification_data VALUES (NULL, 6, 9, 21, 16);
INSERT INTO versification_data VALUES (NULL, 6, 9, 22, 23);
INSERT INTO versification_data VALUES (NULL, 6, 9, 23, 28);
INSERT INTO versification_data VALUES (NULL, 6, 9, 24, 23);
INSERT INTO versification_data VALUES (NULL, 6, 9, 25, 44);
INSERT INTO versification_data VALUES (NULL, 6, 9, 26, 25);
INSERT INTO versification_data VALUES (NULL, 6, 9, 27, 12);
INSERT INTO versification_data VALUES (NULL, 6, 9, 28, 25);
INSERT INTO versification_data VALUES (NULL, 6, 9, 29, 11);
INSERT INTO versification_data VALUES (NULL, 6, 9, 30, 31);
INSERT INTO versification_data VALUES (NULL, 6, 9, 31, 13);
INSERT INTO versification_data VALUES (NULL, 6, 10, 1, 27);
INSERT INTO versification_data VALUES (NULL, 6, 10, 2, 32);
INSERT INTO versification_data VALUES (NULL, 6, 10, 3, 39);
INSERT INTO versification_data VALUES (NULL, 6, 10, 4, 12);
INSERT INTO versification_data VALUES (NULL, 6, 10, 5, 25);
INSERT INTO versification_data VALUES (NULL, 6, 10, 6, 23);
INSERT INTO versification_data VALUES (NULL, 6, 10, 7, 29);
INSERT INTO versification_data VALUES (NULL, 6, 10, 8, 18);
INSERT INTO versification_data VALUES (NULL, 6, 10, 9, 13);
INSERT INTO versification_data VALUES (NULL, 6, 10, 10, 19);
INSERT INTO versification_data VALUES (NULL, 6, 10, 11, 27);
INSERT INTO versification_data VALUES (NULL, 6, 10, 12, 31);
INSERT INTO versification_data VALUES (NULL, 6, 10, 13, 39);
INSERT INTO versification_data VALUES (NULL, 6, 10, 14, 33);
INSERT INTO versification_data VALUES (NULL, 6, 10, 15, 37);
INSERT INTO versification_data VALUES (NULL, 6, 10, 16, 23);
INSERT INTO versification_data VALUES (NULL, 6, 10, 17, 29);
INSERT INTO versification_data VALUES (NULL, 6, 10, 18, 32);
INSERT INTO versification_data VALUES (NULL, 6, 10, 19, 44);
INSERT INTO versification_data VALUES (NULL, 6, 10, 20, 26);
INSERT INTO versification_data VALUES (NULL, 6, 10, 21, 22);
INSERT INTO versification_data VALUES (NULL, 6, 10, 22, 51);
INSERT INTO versification_data VALUES (NULL, 6, 10, 23, 39);
INSERT INTO versification_data VALUES (NULL, 6, 10, 24, 25);
INSERT INTO versification_data VALUES (NULL, 6, 11, 1, 53);
INSERT INTO versification_data VALUES (NULL, 6, 11, 2, 46);
INSERT INTO versification_data VALUES (NULL, 6, 11, 3, 28);
INSERT INTO versification_data VALUES (NULL, 6, 11, 4, 19);
INSERT INTO versification_data VALUES (NULL, 6, 11, 5, 32);
INSERT INTO versification_data VALUES (NULL, 6, 11, 6, 36);
INSERT INTO versification_data VALUES (NULL, 6, 11, 7, 50);
INSERT INTO versification_data VALUES (NULL, 6, 11, 8, 66);
INSERT INTO versification_data VALUES (NULL, 6, 11, 9, 28);
INSERT INTO versification_data VALUES (NULL, 6, 11, 10, 29);
INSERT INTO versification_data VALUES (NULL, 6, 11, 11, 43);
INSERT INTO versification_data VALUES (NULL, 6, 11, 12, 33);
INSERT INTO versification_data VALUES (NULL, 6, 11, 13, 34);
INSERT INTO versification_data VALUES (NULL, 6, 11, 14, 31);
INSERT INTO versification_data VALUES (NULL, 6, 11, 15, 34);
INSERT INTO versification_data VALUES (NULL, 6, 11, 16, 34);
INSERT INTO versification_data VALUES (NULL, 6, 11, 17, 24);
INSERT INTO versification_data VALUES (NULL, 6, 11, 18, 46);
INSERT INTO versification_data VALUES (NULL, 6, 11, 19, 21);
INSERT INTO versification_data VALUES (NULL, 6, 11, 20, 29);
INSERT INTO versification_data VALUES (NULL, 6, 11, 21, 43);
INSERT INTO versification_data VALUES (NULL, 6, 11, 22, 54);
INSERT INTO versification_data VALUES (NULL, 6, 12, 1, 18);
INSERT INTO versification_data VALUES (NULL, 6, 12, 2, 25);
INSERT INTO versification_data VALUES (NULL, 6, 12, 3, 27);
INSERT INTO versification_data VALUES (NULL, 6, 12, 4, 44);
INSERT INTO versification_data VALUES (NULL, 6, 12, 5, 27);
INSERT INTO versification_data VALUES (NULL, 6, 12, 6, 33);
INSERT INTO versification_data VALUES (NULL, 6, 12, 7, 20);
INSERT INTO versification_data VALUES (NULL, 6, 12, 8, 29);
INSERT INTO versification_data VALUES (NULL, 6, 12, 9, 37);
INSERT INTO versification_data VALUES (NULL, 6, 12, 10, 36);
INSERT INTO versification_data VALUES (NULL, 6, 12, 11, 20);
INSERT INTO versification_data VALUES (NULL, 6, 12, 12, 22);
INSERT INTO versification_data VALUES (NULL, 6, 12, 13, 25);
INSERT INTO versification_data VALUES (NULL, 6, 12, 14, 29);
INSERT INTO versification_data VALUES (NULL, 6, 12, 15, 38);
INSERT INTO versification_data VALUES (NULL, 6, 12, 16, 20);
INSERT INTO versification_data VALUES (NULL, 6, 12, 17, 41);
INSERT INTO versification_data VALUES (NULL, 6, 12, 18, 37);
INSERT INTO versification_data VALUES (NULL, 6, 12, 19, 37);
INSERT INTO versification_data VALUES (NULL, 6, 12, 20, 21);
INSERT INTO versification_data VALUES (NULL, 6, 12, 21, 26);
INSERT INTO versification_data VALUES (NULL, 6, 12, 22, 20);
INSERT INTO versification_data VALUES (NULL, 6, 12, 23, 37);
INSERT INTO versification_data VALUES (NULL, 6, 12, 24, 20);
INSERT INTO versification_data VALUES (NULL, 6, 12, 25, 30);
INSERT INTO versification_data VALUES (NULL, 6, 13, 1, 54);
INSERT INTO versification_data VALUES (NULL, 6, 13, 2, 55);
INSERT INTO versification_data VALUES (NULL, 6, 13, 3, 24);
INSERT INTO versification_data VALUES (NULL, 6, 13, 4, 43);
INSERT INTO versification_data VALUES (NULL, 6, 13, 5, 41);
INSERT INTO versification_data VALUES (NULL, 6, 13, 6, 66);
INSERT INTO versification_data VALUES (NULL, 6, 13, 7, 40);
INSERT INTO versification_data VALUES (NULL, 6, 13, 8, 40);
INSERT INTO versification_data VALUES (NULL, 6, 13, 9, 44);
INSERT INTO versification_data VALUES (NULL, 6, 13, 10, 14);
INSERT INTO versification_data VALUES (NULL, 6, 13, 11, 47);
INSERT INTO versification_data VALUES (NULL, 6, 13, 12, 41);
INSERT INTO versification_data VALUES (NULL, 6, 13, 13, 14);
INSERT INTO versification_data VALUES (NULL, 6, 13, 14, 17);
INSERT INTO versification_data VALUES (NULL, 6, 13, 15, 29);
INSERT INTO versification_data VALUES (NULL, 6, 13, 16, 43);
INSERT INTO versification_data VALUES (NULL, 6, 13, 17, 27);
INSERT INTO versification_data VALUES (NULL, 6, 13, 18, 17);
INSERT INTO versification_data VALUES (NULL, 6, 13, 19, 19);
INSERT INTO versification_data VALUES (NULL, 6, 13, 20, 8);
INSERT INTO versification_data VALUES (NULL, 6, 13, 21, 30);
INSERT INTO versification_data VALUES (NULL, 6, 13, 22, 19);
INSERT INTO versification_data VALUES (NULL, 6, 13, 23, 32);
INSERT INTO versification_data VALUES (NULL, 6, 13, 24, 31);
INSERT INTO versification_data VALUES (NULL, 6, 13, 25, 31);
INSERT INTO versification_data VALUES (NULL, 6, 13, 26, 32);
INSERT INTO versification_data VALUES (NULL, 6, 13, 27, 34);
INSERT INTO versification_data VALUES (NULL, 6, 13, 28, 21);
INSERT INTO versification_data VALUES (NULL, 6, 13, 29, 30);
INSERT INTO versification_data VALUES (NULL, 6, 14, 1, 18);
INSERT INTO versification_data VALUES (NULL, 6, 14, 2, 17);
INSERT INTO versification_data VALUES (NULL, 6, 14, 3, 17);
INSERT INTO versification_data VALUES (NULL, 6, 14, 4, 22);
INSERT INTO versification_data VALUES (NULL, 6, 14, 5, 14);
INSERT INTO versification_data VALUES (NULL, 6, 14, 6, 42);
INSERT INTO versification_data VALUES (NULL, 6, 14, 7, 22);
INSERT INTO versification_data VALUES (NULL, 6, 14, 8, 18);
INSERT INTO versification_data VALUES (NULL, 6, 14, 9, 31);
INSERT INTO versification_data VALUES (NULL, 6, 14, 10, 19);
INSERT INTO versification_data VALUES (NULL, 6, 14, 11, 23);
INSERT INTO versification_data VALUES (NULL, 6, 14, 12, 16);
INSERT INTO versification_data VALUES (NULL, 6, 14, 13, 23);
INSERT INTO versification_data VALUES (NULL, 6, 14, 14, 14);
INSERT INTO versification_data VALUES (NULL, 6, 14, 15, 19);
INSERT INTO versification_data VALUES (NULL, 6, 14, 16, 14);
INSERT INTO versification_data VALUES (NULL, 6, 14, 17, 19);
INSERT INTO versification_data VALUES (NULL, 6, 14, 18, 34);
INSERT INTO versification_data VALUES (NULL, 6, 14, 19, 11);
INSERT INTO versification_data VALUES (NULL, 6, 14, 20, 37);
INSERT INTO versification_data VALUES (NULL, 6, 14, 21, 20);
INSERT INTO versification_data VALUES (NULL, 6, 14, 22, 12);
INSERT INTO versification_data VALUES (NULL, 6, 14, 23, 21);
INSERT INTO versification_data VALUES (NULL, 6, 14, 24, 27);
INSERT INTO versification_data VALUES (NULL, 6, 14, 25, 28);
INSERT INTO versification_data VALUES (NULL, 6, 14, 26, 23);
INSERT INTO versification_data VALUES (NULL, 6, 14, 27, 9);
INSERT INTO versification_data VALUES (NULL, 6, 14, 28, 27);
INSERT INTO versification_data VALUES (NULL, 6, 14, 29, 36);
INSERT INTO versification_data VALUES (NULL, 6, 14, 30, 27);
INSERT INTO versification_data VALUES (NULL, 6, 14, 31, 21);
INSERT INTO versification_data VALUES (NULL, 6, 14, 32, 33);
INSERT INTO versification_data VALUES (NULL, 6, 14, 33, 25);
INSERT INTO versification_data VALUES (NULL, 6, 14, 34, 33);
INSERT INTO versification_data VALUES (NULL, 6, 14, 35, 27);
INSERT INTO versification_data VALUES (NULL, 6, 14, 36, 23);
INSERT INTO versification_data VALUES (NULL, 6, 17, 1, 22);
INSERT INTO versification_data VALUES (NULL, 6, 17, 2, 23);
INSERT INTO versification_data VALUES (NULL, 6, 17, 3, 15);
INSERT INTO versification_data VALUES (NULL, 6, 17, 4, 17);
INSERT INTO versification_data VALUES (NULL, 6, 17, 5, 14);
INSERT INTO versification_data VALUES (NULL, 6, 17, 6, 14);
INSERT INTO versification_data VALUES (NULL, 6, 17, 7, 10);
INSERT INTO versification_data VALUES (NULL, 6, 17, 8, 17);
INSERT INTO versification_data VALUES (NULL, 6, 17, 9, 32);
INSERT INTO versification_data VALUES (NULL, 6, 17, 10, 3);
INSERT INTO versification_data VALUES (NULL, 6, 18, 1, 22);
INSERT INTO versification_data VALUES (NULL, 6, 18, 2, 13);
INSERT INTO versification_data VALUES (NULL, 6, 18, 3, 26);
INSERT INTO versification_data VALUES (NULL, 6, 18, 4, 21);
INSERT INTO versification_data VALUES (NULL, 6, 18, 5, 27);
INSERT INTO versification_data VALUES (NULL, 6, 18, 6, 30);
INSERT INTO versification_data VALUES (NULL, 6, 18, 7, 21);
INSERT INTO versification_data VALUES (NULL, 6, 18, 8, 22);
INSERT INTO versification_data VALUES (NULL, 6, 18, 9, 35);
INSERT INTO versification_data VALUES (NULL, 6, 18, 10, 22);
INSERT INTO versification_data VALUES (NULL, 6, 18, 11, 20);
INSERT INTO versification_data VALUES (NULL, 6, 18, 12, 25);
INSERT INTO versification_data VALUES (NULL, 6, 18, 13, 28);
INSERT INTO versification_data VALUES (NULL, 6, 18, 14, 22);
INSERT INTO versification_data VALUES (NULL, 6, 18, 15, 35);
INSERT INTO versification_data VALUES (NULL, 6, 18, 16, 22);
INSERT INTO versification_data VALUES (NULL, 6, 18, 17, 16);
INSERT INTO versification_data VALUES (NULL, 6, 18, 18, 21);
INSERT INTO versification_data VALUES (NULL, 6, 18, 19, 29);
INSERT INTO versification_data VALUES (NULL, 6, 18, 20, 29);
INSERT INTO versification_data VALUES (NULL, 6, 18, 21, 34);
INSERT INTO versification_data VALUES (NULL, 6, 18, 22, 30);
INSERT INTO versification_data VALUES (NULL, 6, 18, 23, 17);
INSERT INTO versification_data VALUES (NULL, 6, 18, 24, 25);
INSERT INTO versification_data VALUES (NULL, 6, 18, 25, 6);
INSERT INTO versification_data VALUES (NULL, 6, 18, 26, 14);
INSERT INTO versification_data VALUES (NULL, 6, 18, 27, 23);
INSERT INTO versification_data VALUES (NULL, 6, 18, 28, 28);
INSERT INTO versification_data VALUES (NULL, 6, 18, 29, 25);
INSERT INTO versification_data VALUES (NULL, 6, 18, 30, 31);
INSERT INTO versification_data VALUES (NULL, 6, 18, 31, 40);
INSERT INTO versification_data VALUES (NULL, 6, 18, 32, 22);
INSERT INTO versification_data VALUES (NULL, 6, 18, 33, 33);
INSERT INTO versification_data VALUES (NULL, 6, 18, 34, 37);
INSERT INTO versification_data VALUES (NULL, 6, 18, 35, 16);
INSERT INTO versification_data VALUES (NULL, 6, 18, 36, 33);
INSERT INTO versification_data VALUES (NULL, 6, 18, 37, 24);
INSERT INTO versification_data VALUES (NULL, 6, 18, 38, 41);
INSERT INTO versification_data VALUES (NULL, 6, 18, 39, 30);
INSERT INTO versification_data VALUES (NULL, 6, 18, 40, 32);
INSERT INTO versification_data VALUES (NULL, 6, 18, 41, 26);
INSERT INTO versification_data VALUES (NULL, 6, 18, 42, 17);
INSERT INTO versification_data VALUES (NULL, 6, 19, 1, 6);
INSERT INTO versification_data VALUES (NULL, 6, 19, 2, 12);
INSERT INTO versification_data VALUES (NULL, 6, 19, 3, 9);
INSERT INTO versification_data VALUES (NULL, 6, 19, 4, 9);
INSERT INTO versification_data VALUES (NULL, 6, 19, 5, 13);
INSERT INTO versification_data VALUES (NULL, 6, 19, 6, 11);
INSERT INTO versification_data VALUES (NULL, 6, 19, 7, 18);
INSERT INTO versification_data VALUES (NULL, 6, 19, 8, 10);
INSERT INTO versification_data VALUES (NULL, 6, 19, 9, 39);
INSERT INTO versification_data VALUES (NULL, 6, 19, 10, 7);
INSERT INTO versification_data VALUES (NULL, 6, 19, 11, 9);
INSERT INTO versification_data VALUES (NULL, 6, 19, 12, 6);
INSERT INTO versification_data VALUES (NULL, 6, 19, 13, 7);
INSERT INTO versification_data VALUES (NULL, 6, 19, 14, 5);
INSERT INTO versification_data VALUES (NULL, 6, 19, 15, 11);
INSERT INTO versification_data VALUES (NULL, 6, 19, 16, 15);
INSERT INTO versification_data VALUES (NULL, 6, 19, 17, 51);
INSERT INTO versification_data VALUES (NULL, 6, 19, 18, 15);
INSERT INTO versification_data VALUES (NULL, 6, 19, 19, 10);
INSERT INTO versification_data VALUES (NULL, 6, 19, 20, 14);
INSERT INTO versification_data VALUES (NULL, 6, 19, 21, 32);
INSERT INTO versification_data VALUES (NULL, 6, 19, 22, 6);
INSERT INTO versification_data VALUES (NULL, 6, 19, 23, 10);
INSERT INTO versification_data VALUES (NULL, 6, 19, 24, 22);
INSERT INTO versification_data VALUES (NULL, 6, 19, 25, 12);
INSERT INTO versification_data VALUES (NULL, 6, 19, 26, 14);
INSERT INTO versification_data VALUES (NULL, 6, 19, 27, 9);
INSERT INTO versification_data VALUES (NULL, 6, 19, 28, 11);
INSERT INTO versification_data VALUES (NULL, 6, 19, 29, 13);
INSERT INTO versification_data VALUES (NULL, 6, 19, 30, 25);
INSERT INTO versification_data VALUES (NULL, 6, 19, 31, 11);
INSERT INTO versification_data VALUES (NULL, 6, 19, 32, 22);
INSERT INTO versification_data VALUES (NULL, 6, 19, 33, 23);
INSERT INTO versification_data VALUES (NULL, 6, 19, 34, 28);
INSERT INTO versification_data VALUES (NULL, 6, 19, 35, 13);
INSERT INTO versification_data VALUES (NULL, 6, 19, 36, 40);
INSERT INTO versification_data VALUES (NULL, 6, 19, 37, 23);
INSERT INTO versification_data VALUES (NULL, 6, 19, 38, 14);
INSERT INTO versification_data VALUES (NULL, 6, 19, 39, 18);
INSERT INTO versification_data VALUES (NULL, 6, 19, 40, 14);
INSERT INTO versification_data VALUES (NULL, 6, 19, 41, 12);
INSERT INTO versification_data VALUES (NULL, 6, 19, 42, 5);
INSERT INTO versification_data VALUES (NULL, 6, 19, 43, 27);
INSERT INTO versification_data VALUES (NULL, 6, 19, 44, 18);
INSERT INTO versification_data VALUES (NULL, 6, 19, 45, 12);
INSERT INTO versification_data VALUES (NULL, 6, 19, 46, 10);
INSERT INTO versification_data VALUES (NULL, 6, 19, 47, 15);
INSERT INTO versification_data VALUES (NULL, 6, 19, 48, 21);
INSERT INTO versification_data VALUES (NULL, 6, 19, 49, 23);
INSERT INTO versification_data VALUES (NULL, 6, 19, 50, 21);
INSERT INTO versification_data VALUES (NULL, 6, 19, 51, 11);
INSERT INTO versification_data VALUES (NULL, 6, 19, 52, 7);
INSERT INTO versification_data VALUES (NULL, 6, 19, 53, 9);
INSERT INTO versification_data VALUES (NULL, 6, 19, 54, 24);
INSERT INTO versification_data VALUES (NULL, 6, 19, 55, 14);
INSERT INTO versification_data VALUES (NULL, 6, 19, 56, 12);
INSERT INTO versification_data VALUES (NULL, 6, 19, 57, 12);
INSERT INTO versification_data VALUES (NULL, 6, 19, 58, 18);
INSERT INTO versification_data VALUES (NULL, 6, 19, 59, 14);
INSERT INTO versification_data VALUES (NULL, 6, 19, 60, 9);
INSERT INTO versification_data VALUES (NULL, 6, 19, 61, 13);
INSERT INTO versification_data VALUES (NULL, 6, 19, 62, 12);
INSERT INTO versification_data VALUES (NULL, 6, 19, 63, 11);
INSERT INTO versification_data VALUES (NULL, 6, 19, 64, 14);
INSERT INTO versification_data VALUES (NULL, 6, 19, 65, 20);
INSERT INTO versification_data VALUES (NULL, 6, 19, 66, 8);
INSERT INTO versification_data VALUES (NULL, 6, 19, 67, 36);
INSERT INTO versification_data VALUES (NULL, 6, 19, 68, 37);
INSERT INTO versification_data VALUES (NULL, 6, 19, 69, 6);
INSERT INTO versification_data VALUES (NULL, 6, 19, 70, 24);
INSERT INTO versification_data VALUES (NULL, 6, 19, 71, 20);
INSERT INTO versification_data VALUES (NULL, 6, 19, 72, 28);
INSERT INTO versification_data VALUES (NULL, 6, 19, 73, 23);
INSERT INTO versification_data VALUES (NULL, 6, 19, 74, 11);
INSERT INTO versification_data VALUES (NULL, 6, 19, 75, 13);
INSERT INTO versification_data VALUES (NULL, 6, 19, 76, 21);
INSERT INTO versification_data VALUES (NULL, 6, 19, 77, 72);
INSERT INTO versification_data VALUES (NULL, 6, 19, 78, 13);
INSERT INTO versification_data VALUES (NULL, 6, 19, 79, 20);
INSERT INTO versification_data VALUES (NULL, 6, 19, 80, 17);
INSERT INTO versification_data VALUES (NULL, 6, 19, 81, 8);
INSERT INTO versification_data VALUES (NULL, 6, 19, 82, 19);
INSERT INTO versification_data VALUES (NULL, 6, 19, 83, 13);
INSERT INTO versification_data VALUES (NULL, 6, 19, 84, 14);
INSERT INTO versification_data VALUES (NULL, 6, 19, 85, 17);
INSERT INTO versification_data VALUES (NULL, 6, 19, 86, 7);
INSERT INTO versification_data VALUES (NULL, 6, 19, 87, 19);
INSERT INTO versification_data VALUES (NULL, 6, 19, 88, 53);
INSERT INTO versification_data VALUES (NULL, 6, 19, 89, 17);
INSERT INTO versification_data VALUES (NULL, 6, 19, 90, 16);
INSERT INTO versification_data VALUES (NULL, 6, 19, 91, 16);
INSERT INTO versification_data VALUES (NULL, 6, 19, 92, 5);
INSERT INTO versification_data VALUES (NULL, 6, 19, 93, 23);
INSERT INTO versification_data VALUES (NULL, 6, 19, 94, 11);
INSERT INTO versification_data VALUES (NULL, 6, 19, 95, 13);
INSERT INTO versification_data VALUES (NULL, 6, 19, 96, 12);
INSERT INTO versification_data VALUES (NULL, 6, 19, 97, 9);
INSERT INTO versification_data VALUES (NULL, 6, 19, 98, 9);
INSERT INTO versification_data VALUES (NULL, 6, 19, 99, 5);
INSERT INTO versification_data VALUES (NULL, 6, 19, 100, 8);
INSERT INTO versification_data VALUES (NULL, 6, 19, 101, 29);
INSERT INTO versification_data VALUES (NULL, 6, 19, 102, 22);
INSERT INTO versification_data VALUES (NULL, 6, 19, 103, 35);
INSERT INTO versification_data VALUES (NULL, 6, 19, 104, 45);
INSERT INTO versification_data VALUES (NULL, 6, 19, 105, 48);
INSERT INTO versification_data VALUES (NULL, 6, 19, 106, 43);
INSERT INTO versification_data VALUES (NULL, 6, 19, 107, 14);
INSERT INTO versification_data VALUES (NULL, 6, 19, 108, 31);
INSERT INTO versification_data VALUES (NULL, 6, 19, 109, 7);
INSERT INTO versification_data VALUES (NULL, 6, 19, 110, 10);
INSERT INTO versification_data VALUES (NULL, 6, 19, 111, 10);
INSERT INTO versification_data VALUES (NULL, 6, 19, 112, 9);
INSERT INTO versification_data VALUES (NULL, 6, 19, 113, 26);
INSERT INTO versification_data VALUES (NULL, 6, 19, 114, 9);
INSERT INTO versification_data VALUES (NULL, 6, 19, 115, 10);
INSERT INTO versification_data VALUES (NULL, 6, 19, 116, 2);
INSERT INTO versification_data VALUES (NULL, 6, 19, 117, 29);
INSERT INTO versification_data VALUES (NULL, 6, 19, 118, 176);
INSERT INTO versification_data VALUES (NULL, 6, 19, 119, 7);
INSERT INTO versification_data VALUES (NULL, 6, 19, 120, 8);
INSERT INTO versification_data VALUES (NULL, 6, 19, 121, 9);
INSERT INTO versification_data VALUES (NULL, 6, 19, 122, 4);
INSERT INTO versification_data VALUES (NULL, 6, 19, 123, 8);
INSERT INTO versification_data VALUES (NULL, 6, 19, 124, 5);
INSERT INTO versification_data VALUES (NULL, 6, 19, 125, 6);
INSERT INTO versification_data VALUES (NULL, 6, 19, 126, 5);
INSERT INTO versification_data VALUES (NULL, 6, 19, 127, 6);
INSERT INTO versification_data VALUES (NULL, 6, 19, 128, 8);
INSERT INTO versification_data VALUES (NULL, 6, 19, 129, 8);
INSERT INTO versification_data VALUES (NULL, 6, 19, 130, 3);
INSERT INTO versification_data VALUES (NULL, 6, 19, 131, 18);
INSERT INTO versification_data VALUES (NULL, 6, 19, 132, 3);
INSERT INTO versification_data VALUES (NULL, 6, 19, 133, 3);
INSERT INTO versification_data VALUES (NULL, 6, 19, 134, 21);
INSERT INTO versification_data VALUES (NULL, 6, 19, 135, 26);
INSERT INTO versification_data VALUES (NULL, 6, 19, 136, 9);
INSERT INTO versification_data VALUES (NULL, 6, 19, 137, 8);
INSERT INTO versification_data VALUES (NULL, 6, 19, 138, 24);
INSERT INTO versification_data VALUES (NULL, 6, 19, 139, 14);
INSERT INTO versification_data VALUES (NULL, 6, 19, 140, 10);
INSERT INTO versification_data VALUES (NULL, 6, 19, 141, 8);
INSERT INTO versification_data VALUES (NULL, 6, 19, 142, 12);
INSERT INTO versification_data VALUES (NULL, 6, 19, 143, 15);
INSERT INTO versification_data VALUES (NULL, 6, 19, 144, 21);
INSERT INTO versification_data VALUES (NULL, 6, 19, 145, 10);
INSERT INTO versification_data VALUES (NULL, 6, 19, 146, 11);
INSERT INTO versification_data VALUES (NULL, 6, 19, 147, 9);
INSERT INTO versification_data VALUES (NULL, 6, 19, 148, 14);
INSERT INTO versification_data VALUES (NULL, 6, 19, 149, 9);
INSERT INTO versification_data VALUES (NULL, 6, 19, 150, 6);
INSERT INTO versification_data VALUES (NULL, 6, 19, 151, 7);
INSERT INTO versification_data VALUES (NULL, 6, 20, 1, 33);
INSERT INTO versification_data VALUES (NULL, 6, 20, 2, 22);
INSERT INTO versification_data VALUES (NULL, 6, 20, 3, 35);
INSERT INTO versification_data VALUES (NULL, 6, 20, 4, 27);
INSERT INTO versification_data VALUES (NULL, 6, 20, 5, 23);
INSERT INTO versification_data VALUES (NULL, 6, 20, 6, 35);
INSERT INTO versification_data VALUES (NULL, 6, 20, 7, 27);
INSERT INTO versification_data VALUES (NULL, 6, 20, 8, 36);
INSERT INTO versification_data VALUES (NULL, 6, 20, 9, 18);
INSERT INTO versification_data VALUES (NULL, 6, 20, 10, 32);
INSERT INTO versification_data VALUES (NULL, 6, 20, 11, 31);
INSERT INTO versification_data VALUES (NULL, 6, 20, 12, 28);
INSERT INTO versification_data VALUES (NULL, 6, 20, 13, 25);
INSERT INTO versification_data VALUES (NULL, 6, 20, 14, 35);
INSERT INTO versification_data VALUES (NULL, 6, 20, 15, 33);
INSERT INTO versification_data VALUES (NULL, 6, 20, 16, 33);
INSERT INTO versification_data VALUES (NULL, 6, 20, 17, 28);
INSERT INTO versification_data VALUES (NULL, 6, 20, 18, 22);
INSERT INTO versification_data VALUES (NULL, 6, 20, 19, 29);
INSERT INTO versification_data VALUES (NULL, 6, 20, 20, 30);
INSERT INTO versification_data VALUES (NULL, 6, 20, 21, 31);
INSERT INTO versification_data VALUES (NULL, 6, 20, 22, 29);
INSERT INTO versification_data VALUES (NULL, 6, 20, 23, 35);
INSERT INTO versification_data VALUES (NULL, 6, 20, 24, 34);
INSERT INTO versification_data VALUES (NULL, 6, 20, 25, 28);
INSERT INTO versification_data VALUES (NULL, 6, 20, 26, 28);
INSERT INTO versification_data VALUES (NULL, 6, 20, 27, 27);
INSERT INTO versification_data VALUES (NULL, 6, 20, 28, 28);
INSERT INTO versification_data VALUES (NULL, 6, 20, 29, 27);
INSERT INTO versification_data VALUES (NULL, 6, 20, 30, 33);
INSERT INTO versification_data VALUES (NULL, 6, 20, 31, 31);
INSERT INTO versification_data VALUES (NULL, 6, 21, 1, 18);
INSERT INTO versification_data VALUES (NULL, 6, 21, 2, 26);
INSERT INTO versification_data VALUES (NULL, 6, 21, 3, 22);
INSERT INTO versification_data VALUES (NULL, 6, 21, 4, 17);
INSERT INTO versification_data VALUES (NULL, 6, 21, 5, 19);
INSERT INTO versification_data VALUES (NULL, 6, 21, 6, 12);
INSERT INTO versification_data VALUES (NULL, 6, 21, 7, 29);
INSERT INTO versification_data VALUES (NULL, 6, 21, 8, 17);
INSERT INTO versification_data VALUES (NULL, 6, 21, 9, 18);
INSERT INTO versification_data VALUES (NULL, 6, 21, 10, 20);
INSERT INTO versification_data VALUES (NULL, 6, 21, 11, 10);
INSERT INTO versification_data VALUES (NULL, 6, 21, 12, 14);
INSERT INTO versification_data VALUES (NULL, 6, 22, 1, 17);
INSERT INTO versification_data VALUES (NULL, 6, 22, 2, 17);
INSERT INTO versification_data VALUES (NULL, 6, 22, 3, 11);
INSERT INTO versification_data VALUES (NULL, 6, 22, 4, 16);
INSERT INTO versification_data VALUES (NULL, 6, 22, 5, 16);
INSERT INTO versification_data VALUES (NULL, 6, 22, 6, 12);
INSERT INTO versification_data VALUES (NULL, 6, 22, 7, 14);
INSERT INTO versification_data VALUES (NULL, 6, 22, 8, 14);
INSERT INTO versification_data VALUES (NULL, 6, 23, 1, 31);
INSERT INTO versification_data VALUES (NULL, 6, 23, 2, 21);
INSERT INTO versification_data VALUES (NULL, 6, 23, 3, 26);
INSERT INTO versification_data VALUES (NULL, 6, 23, 4, 6);
INSERT INTO versification_data VALUES (NULL, 6, 23, 5, 30);
INSERT INTO versification_data VALUES (NULL, 6, 23, 6, 13);
INSERT INTO versification_data VALUES (NULL, 6, 23, 7, 25);
INSERT INTO versification_data VALUES (NULL, 6, 23, 8, 23);
INSERT INTO versification_data VALUES (NULL, 6, 23, 9, 20);
INSERT INTO versification_data VALUES (NULL, 6, 23, 10, 34);
INSERT INTO versification_data VALUES (NULL, 6, 23, 11, 16);
INSERT INTO versification_data VALUES (NULL, 6, 23, 12, 6);
INSERT INTO versification_data VALUES (NULL, 6, 23, 13, 22);
INSERT INTO versification_data VALUES (NULL, 6, 23, 14, 32);
INSERT INTO versification_data VALUES (NULL, 6, 23, 15, 9);
INSERT INTO versification_data VALUES (NULL, 6, 23, 16, 14);
INSERT INTO versification_data VALUES (NULL, 6, 23, 17, 14);
INSERT INTO versification_data VALUES (NULL, 6, 23, 18, 7);
INSERT INTO versification_data VALUES (NULL, 6, 23, 19, 25);
INSERT INTO versification_data VALUES (NULL, 6, 23, 20, 6);
INSERT INTO versification_data VALUES (NULL, 6, 23, 21, 17);
INSERT INTO versification_data VALUES (NULL, 6, 23, 22, 25);
INSERT INTO versification_data VALUES (NULL, 6, 23, 23, 18);
INSERT INTO versification_data VALUES (NULL, 6, 23, 24, 23);
INSERT INTO versification_data VALUES (NULL, 6, 23, 25, 12);
INSERT INTO versification_data VALUES (NULL, 6, 23, 26, 21);
INSERT INTO versification_data VALUES (NULL, 6, 23, 27, 13);
INSERT INTO versification_data VALUES (NULL, 6, 23, 28, 29);
INSERT INTO versification_data VALUES (NULL, 6, 23, 29, 24);
INSERT INTO versification_data VALUES (NULL, 6, 23, 30, 33);
INSERT INTO versification_data VALUES (NULL, 6, 23, 31, 9);
INSERT INTO versification_data VALUES (NULL, 6, 23, 32, 20);
INSERT INTO versification_data VALUES (NULL, 6, 23, 33, 24);
INSERT INTO versification_data VALUES (NULL, 6, 23, 34, 17);
INSERT INTO versification_data VALUES (NULL, 6, 23, 35, 10);
INSERT INTO versification_data VALUES (NULL, 6, 23, 36, 22);
INSERT INTO versification_data VALUES (NULL, 6, 23, 37, 38);
INSERT INTO versification_data VALUES (NULL, 6, 23, 38, 22);
INSERT INTO versification_data VALUES (NULL, 6, 23, 39, 8);
INSERT INTO versification_data VALUES (NULL, 6, 23, 40, 31);
INSERT INTO versification_data VALUES (NULL, 6, 23, 41, 29);
INSERT INTO versification_data VALUES (NULL, 6, 23, 42, 25);
INSERT INTO versification_data VALUES (NULL, 6, 23, 43, 28);
INSERT INTO versification_data VALUES (NULL, 6, 23, 44, 28);
INSERT INTO versification_data VALUES (NULL, 6, 23, 45, 25);
INSERT INTO versification_data VALUES (NULL, 6, 23, 46, 13);
INSERT INTO versification_data VALUES (NULL, 6, 23, 47, 15);
INSERT INTO versification_data VALUES (NULL, 6, 23, 48, 22);
INSERT INTO versification_data VALUES (NULL, 6, 23, 49, 26);
INSERT INTO versification_data VALUES (NULL, 6, 23, 50, 11);
INSERT INTO versification_data VALUES (NULL, 6, 23, 51, 23);
INSERT INTO versification_data VALUES (NULL, 6, 23, 52, 15);
INSERT INTO versification_data VALUES (NULL, 6, 23, 53, 12);
INSERT INTO versification_data VALUES (NULL, 6, 23, 54, 17);
INSERT INTO versification_data VALUES (NULL, 6, 23, 55, 13);
INSERT INTO versification_data VALUES (NULL, 6, 23, 56, 11);
INSERT INTO versification_data VALUES (NULL, 6, 23, 57, 21);
INSERT INTO versification_data VALUES (NULL, 6, 23, 58, 14);
INSERT INTO versification_data VALUES (NULL, 6, 23, 59, 21);
INSERT INTO versification_data VALUES (NULL, 6, 23, 60, 22);
INSERT INTO versification_data VALUES (NULL, 6, 23, 61, 11);
INSERT INTO versification_data VALUES (NULL, 6, 23, 62, 12);
INSERT INTO versification_data VALUES (NULL, 6, 23, 63, 19);
INSERT INTO versification_data VALUES (NULL, 6, 23, 64, 11);
INSERT INTO versification_data VALUES (NULL, 6, 23, 65, 25);
INSERT INTO versification_data VALUES (NULL, 6, 23, 66, 24);
INSERT INTO versification_data VALUES (NULL, 6, 24, 1, 19);
INSERT INTO versification_data VALUES (NULL, 6, 24, 2, 37);
INSERT INTO versification_data VALUES (NULL, 6, 24, 3, 25);
INSERT INTO versification_data VALUES (NULL, 6, 24, 4, 31);
INSERT INTO versification_data VALUES (NULL, 6, 24, 5, 31);
INSERT INTO versification_data VALUES (NULL, 6, 24, 6, 30);
INSERT INTO versification_data VALUES (NULL, 6, 24, 7, 34);
INSERT INTO versification_data VALUES (NULL, 6, 24, 8, 23);
INSERT INTO versification_data VALUES (NULL, 6, 24, 9, 25);
INSERT INTO versification_data VALUES (NULL, 6, 24, 10, 25);
INSERT INTO versification_data VALUES (NULL, 6, 24, 11, 23);
INSERT INTO versification_data VALUES (NULL, 6, 24, 12, 17);
INSERT INTO versification_data VALUES (NULL, 6, 24, 13, 27);
INSERT INTO versification_data VALUES (NULL, 6, 24, 14, 22);
INSERT INTO versification_data VALUES (NULL, 6, 24, 15, 21);
INSERT INTO versification_data VALUES (NULL, 6, 24, 16, 21);
INSERT INTO versification_data VALUES (NULL, 6, 24, 17, 27);
INSERT INTO versification_data VALUES (NULL, 6, 24, 18, 23);
INSERT INTO versification_data VALUES (NULL, 6, 24, 19, 15);
INSERT INTO versification_data VALUES (NULL, 6, 24, 20, 18);
INSERT INTO versification_data VALUES (NULL, 6, 24, 21, 14);
INSERT INTO versification_data VALUES (NULL, 6, 24, 22, 30);
INSERT INTO versification_data VALUES (NULL, 6, 24, 23, 40);
INSERT INTO versification_data VALUES (NULL, 6, 24, 24, 10);
INSERT INTO versification_data VALUES (NULL, 6, 24, 25, 20);
INSERT INTO versification_data VALUES (NULL, 6, 24, 26, 28);
INSERT INTO versification_data VALUES (NULL, 6, 24, 27, 46);
INSERT INTO versification_data VALUES (NULL, 6, 24, 28, 64);
INSERT INTO versification_data VALUES (NULL, 6, 24, 29, 7);
INSERT INTO versification_data VALUES (NULL, 6, 24, 30, 33);
INSERT INTO versification_data VALUES (NULL, 6, 24, 31, 44);
INSERT INTO versification_data VALUES (NULL, 6, 24, 32, 38);
INSERT INTO versification_data VALUES (NULL, 6, 24, 33, 24);
INSERT INTO versification_data VALUES (NULL, 6, 24, 34, 22);
INSERT INTO versification_data VALUES (NULL, 6, 24, 35, 17);
INSERT INTO versification_data VALUES (NULL, 6, 24, 36, 32);
INSERT INTO versification_data VALUES (NULL, 6, 24, 37, 24);
INSERT INTO versification_data VALUES (NULL, 6, 24, 38, 40);
INSERT INTO versification_data VALUES (NULL, 6, 24, 39, 44);
INSERT INTO versification_data VALUES (NULL, 6, 24, 40, 13);
INSERT INTO versification_data VALUES (NULL, 6, 24, 41, 22);
INSERT INTO versification_data VALUES (NULL, 6, 24, 42, 19);
INSERT INTO versification_data VALUES (NULL, 6, 24, 43, 32);
INSERT INTO versification_data VALUES (NULL, 6, 24, 44, 21);
INSERT INTO versification_data VALUES (NULL, 6, 24, 45, 28);
INSERT INTO versification_data VALUES (NULL, 6, 24, 46, 18);
INSERT INTO versification_data VALUES (NULL, 6, 24, 47, 16);
INSERT INTO versification_data VALUES (NULL, 6, 24, 48, 18);
INSERT INTO versification_data VALUES (NULL, 6, 24, 49, 22);
INSERT INTO versification_data VALUES (NULL, 6, 24, 50, 13);
INSERT INTO versification_data VALUES (NULL, 6, 24, 51, 35);
INSERT INTO versification_data VALUES (NULL, 6, 24, 52, 34);
INSERT INTO versification_data VALUES (NULL, 6, 25, 1, 22);
INSERT INTO versification_data VALUES (NULL, 6, 25, 2, 22);
INSERT INTO versification_data VALUES (NULL, 6, 25, 3, 66);
INSERT INTO versification_data VALUES (NULL, 6, 25, 4, 22);
INSERT INTO versification_data VALUES (NULL, 6, 25, 5, 22);
INSERT INTO versification_data VALUES (NULL, 6, 26, 1, 28);
INSERT INTO versification_data VALUES (NULL, 6, 26, 2, 10);
INSERT INTO versification_data VALUES (NULL, 6, 26, 3, 27);
INSERT INTO versification_data VALUES (NULL, 6, 26, 4, 17);
INSERT INTO versification_data VALUES (NULL, 6, 26, 5, 17);
INSERT INTO versification_data VALUES (NULL, 6, 26, 6, 14);
INSERT INTO versification_data VALUES (NULL, 6, 26, 7, 27);
INSERT INTO versification_data VALUES (NULL, 6, 26, 8, 18);
INSERT INTO versification_data VALUES (NULL, 6, 26, 9, 11);
INSERT INTO versification_data VALUES (NULL, 6, 26, 10, 22);
INSERT INTO versification_data VALUES (NULL, 6, 26, 11, 25);
INSERT INTO versification_data VALUES (NULL, 6, 26, 12, 28);
INSERT INTO versification_data VALUES (NULL, 6, 26, 13, 23);
INSERT INTO versification_data VALUES (NULL, 6, 26, 14, 23);
INSERT INTO versification_data VALUES (NULL, 6, 26, 15, 8);
INSERT INTO versification_data VALUES (NULL, 6, 26, 16, 63);
INSERT INTO versification_data VALUES (NULL, 6, 26, 17, 24);
INSERT INTO versification_data VALUES (NULL, 6, 26, 18, 32);
INSERT INTO versification_data VALUES (NULL, 6, 26, 19, 14);
INSERT INTO versification_data VALUES (NULL, 6, 26, 20, 44);
INSERT INTO versification_data VALUES (NULL, 6, 26, 21, 37);
INSERT INTO versification_data VALUES (NULL, 6, 26, 22, 31);
INSERT INTO versification_data VALUES (NULL, 6, 26, 23, 49);
INSERT INTO versification_data VALUES (NULL, 6, 26, 24, 27);
INSERT INTO versification_data VALUES (NULL, 6, 26, 25, 17);
INSERT INTO versification_data VALUES (NULL, 6, 26, 26, 21);
INSERT INTO versification_data VALUES (NULL, 6, 26, 27, 36);
INSERT INTO versification_data VALUES (NULL, 6, 26, 28, 26);
INSERT INTO versification_data VALUES (NULL, 6, 26, 29, 21);
INSERT INTO versification_data VALUES (NULL, 6, 26, 30, 26);
INSERT INTO versification_data VALUES (NULL, 6, 26, 31, 18);
INSERT INTO versification_data VALUES (NULL, 6, 26, 32, 32);
INSERT INTO versification_data VALUES (NULL, 6, 26, 33, 33);
INSERT INTO versification_data VALUES (NULL, 6, 26, 34, 31);
INSERT INTO versification_data VALUES (NULL, 6, 26, 35, 15);
INSERT INTO versification_data VALUES (NULL, 6, 26, 36, 38);
INSERT INTO versification_data VALUES (NULL, 6, 26, 37, 28);
INSERT INTO versification_data VALUES (NULL, 6, 26, 38, 23);
INSERT INTO versification_data VALUES (NULL, 6, 26, 39, 29);
INSERT INTO versification_data VALUES (NULL, 6, 26, 40, 49);
INSERT INTO versification_data VALUES (NULL, 6, 26, 41, 26);
INSERT INTO versification_data VALUES (NULL, 6, 26, 42, 20);
INSERT INTO versification_data VALUES (NULL, 6, 26, 43, 27);
INSERT INTO versification_data VALUES (NULL, 6, 26, 44, 31);
INSERT INTO versification_data VALUES (NULL, 6, 26, 45, 25);
INSERT INTO versification_data VALUES (NULL, 6, 26, 46, 24);
INSERT INTO versification_data VALUES (NULL, 6, 26, 47, 23);
INSERT INTO versification_data VALUES (NULL, 6, 26, 48, 35);
INSERT INTO versification_data VALUES (NULL, 6, 27, 1, 21);
INSERT INTO versification_data VALUES (NULL, 6, 27, 2, 49);
INSERT INTO versification_data VALUES (NULL, 6, 27, 3, 97);
INSERT INTO versification_data VALUES (NULL, 6, 27, 4, 37);
INSERT INTO versification_data VALUES (NULL, 6, 27, 5, 30);
INSERT INTO versification_data VALUES (NULL, 6, 27, 6, 29);
INSERT INTO versification_data VALUES (NULL, 6, 27, 7, 28);
INSERT INTO versification_data VALUES (NULL, 6, 27, 8, 27);
INSERT INTO versification_data VALUES (NULL, 6, 27, 9, 27);
INSERT INTO versification_data VALUES (NULL, 6, 27, 10, 21);
INSERT INTO versification_data VALUES (NULL, 6, 27, 11, 45);
INSERT INTO versification_data VALUES (NULL, 6, 27, 12, 13);
INSERT INTO versification_data VALUES (NULL, 6, 28, 1, 9);
INSERT INTO versification_data VALUES (NULL, 6, 28, 2, 25);
INSERT INTO versification_data VALUES (NULL, 6, 28, 3, 5);
INSERT INTO versification_data VALUES (NULL, 6, 28, 4, 19);
INSERT INTO versification_data VALUES (NULL, 6, 28, 5, 15);
INSERT INTO versification_data VALUES (NULL, 6, 28, 6, 11);
INSERT INTO versification_data VALUES (NULL, 6, 28, 7, 16);
INSERT INTO versification_data VALUES (NULL, 6, 28, 8, 14);
INSERT INTO versification_data VALUES (NULL, 6, 28, 9, 17);
INSERT INTO versification_data VALUES (NULL, 6, 28, 10, 15);
INSERT INTO versification_data VALUES (NULL, 6, 28, 11, 11);
INSERT INTO versification_data VALUES (NULL, 6, 28, 12, 15);
INSERT INTO versification_data VALUES (NULL, 6, 28, 13, 15);
INSERT INTO versification_data VALUES (NULL, 6, 28, 14, 10);
INSERT INTO versification_data VALUES (NULL, 6, 29, 1, 20);
INSERT INTO versification_data VALUES (NULL, 6, 29, 2, 27);
INSERT INTO versification_data VALUES (NULL, 6, 29, 3, 5);
INSERT INTO versification_data VALUES (NULL, 6, 29, 4, 21);
INSERT INTO versification_data VALUES (NULL, 6, 30, 1, 15);
INSERT INTO versification_data VALUES (NULL, 6, 30, 2, 16);
INSERT INTO versification_data VALUES (NULL, 6, 30, 3, 15);
INSERT INTO versification_data VALUES (NULL, 6, 30, 4, 13);
INSERT INTO versification_data VALUES (NULL, 6, 30, 5, 27);
INSERT INTO versification_data VALUES (NULL, 6, 30, 6, 14);
INSERT INTO versification_data VALUES (NULL, 6, 30, 7, 17);
INSERT INTO versification_data VALUES (NULL, 6, 30, 8, 14);
INSERT INTO versification_data VALUES (NULL, 6, 30, 9, 15);
INSERT INTO versification_data VALUES (NULL, 6, 31, 1, 21);
INSERT INTO versification_data VALUES (NULL, 6, 32, 1, 16);
INSERT INTO versification_data VALUES (NULL, 6, 32, 2, 11);
INSERT INTO versification_data VALUES (NULL, 6, 32, 3, 10);
INSERT INTO versification_data VALUES (NULL, 6, 32, 4, 11);
INSERT INTO versification_data VALUES (NULL, 6, 33, 1, 16);
INSERT INTO versification_data VALUES (NULL, 6, 33, 2, 13);
INSERT INTO versification_data VALUES (NULL, 6, 33, 3, 12);
INSERT INTO versification_data VALUES (NULL, 6, 33, 4, 14);
INSERT INTO versification_data VALUES (NULL, 6, 33, 5, 14);
INSERT INTO versification_data VALUES (NULL, 6, 33, 6, 16);
INSERT INTO versification_data VALUES (NULL, 6, 33, 7, 20);
INSERT INTO versification_data VALUES (NULL, 6, 34, 1, 14);
INSERT INTO versification_data VALUES (NULL, 6, 34, 2, 14);
INSERT INTO versification_data VALUES (NULL, 6, 34, 3, 19);
INSERT INTO versification_data VALUES (NULL, 6, 35, 1, 17);
INSERT INTO versification_data VALUES (NULL, 6, 35, 2, 20);
INSERT INTO versification_data VALUES (NULL, 6, 35, 3, 19);
INSERT INTO versification_data VALUES (NULL, 6, 36, 1, 18);
INSERT INTO versification_data VALUES (NULL, 6, 36, 2, 15);
INSERT INTO versification_data VALUES (NULL, 6, 36, 3, 20);
INSERT INTO versification_data VALUES (NULL, 6, 37, 1, 15);
INSERT INTO versification_data VALUES (NULL, 6, 37, 2, 23);
INSERT INTO versification_data VALUES (NULL, 6, 38, 1, 17);
INSERT INTO versification_data VALUES (NULL, 6, 38, 2, 17);
INSERT INTO versification_data VALUES (NULL, 6, 38, 3, 10);
INSERT INTO versification_data VALUES (NULL, 6, 38, 4, 14);
INSERT INTO versification_data VALUES (NULL, 6, 38, 5, 11);
INSERT INTO versification_data VALUES (NULL, 6, 38, 6, 15);
INSERT INTO versification_data VALUES (NULL, 6, 38, 7, 14);
INSERT INTO versification_data VALUES (NULL, 6, 38, 8, 23);
INSERT INTO versification_data VALUES (NULL, 6, 38, 9, 17);
INSERT INTO versification_data VALUES (NULL, 6, 38, 10, 12);
INSERT INTO versification_data VALUES (NULL, 6, 38, 11, 17);
INSERT INTO versification_data VALUES (NULL, 6, 38, 12, 14);
INSERT INTO versification_data VALUES (NULL, 6, 38, 13, 9);
INSERT INTO versification_data VALUES (NULL, 6, 38, 14, 21);
INSERT INTO versification_data VALUES (NULL, 6, 39, 1, 14);
INSERT INTO versification_data VALUES (NULL, 6, 39, 2, 17);
INSERT INTO versification_data VALUES (NULL, 6, 39, 3, 24);
INSERT INTO versification_data VALUES (NULL, 6, 40, 1, 25);
INSERT INTO versification_data VALUES (NULL, 6, 40, 2, 23);
INSERT INTO versification_data VALUES (NULL, 6, 40, 3, 17);
INSERT INTO versification_data VALUES (NULL, 6, 40, 4, 25);
INSERT INTO versification_data VALUES (NULL, 6, 40, 5, 48);
INSERT INTO versification_data VALUES (NULL, 6, 40, 6, 34);
INSERT INTO versification_data VALUES (NULL, 6, 40, 7, 29);
INSERT INTO versification_data VALUES (NULL, 6, 40, 8, 34);
INSERT INTO versification_data VALUES (NULL, 6, 40, 9, 38);
INSERT INTO versification_data VALUES (NULL, 6, 40, 10, 42);
INSERT INTO versification_data VALUES (NULL, 6, 40, 11, 30);
INSERT INTO versification_data VALUES (NULL, 6, 40, 12, 50);
INSERT INTO versification_data VALUES (NULL, 6, 40, 13, 58);
INSERT INTO versification_data VALUES (NULL, 6, 40, 14, 36);
INSERT INTO versification_data VALUES (NULL, 6, 40, 15, 39);
INSERT INTO versification_data VALUES (NULL, 6, 40, 16, 28);
INSERT INTO versification_data VALUES (NULL, 6, 40, 17, 27);
INSERT INTO versification_data VALUES (NULL, 6, 40, 18, 35);
INSERT INTO versification_data VALUES (NULL, 6, 40, 19, 30);
INSERT INTO versification_data VALUES (NULL, 6, 40, 20, 34);
INSERT INTO versification_data VALUES (NULL, 6, 40, 21, 46);
INSERT INTO versification_data VALUES (NULL, 6, 40, 22, 46);
INSERT INTO versification_data VALUES (NULL, 6, 40, 23, 39);
INSERT INTO versification_data VALUES (NULL, 6, 40, 24, 51);
INSERT INTO versification_data VALUES (NULL, 6, 40, 25, 46);
INSERT INTO versification_data VALUES (NULL, 6, 40, 26, 75);
INSERT INTO versification_data VALUES (NULL, 6, 40, 27, 66);
INSERT INTO versification_data VALUES (NULL, 6, 40, 28, 20);
INSERT INTO versification_data VALUES (NULL, 6, 41, 1, 45);
INSERT INTO versification_data VALUES (NULL, 6, 41, 2, 28);
INSERT INTO versification_data VALUES (NULL, 6, 41, 3, 35);
INSERT INTO versification_data VALUES (NULL, 6, 41, 4, 41);
INSERT INTO versification_data VALUES (NULL, 6, 41, 5, 43);
INSERT INTO versification_data VALUES (NULL, 6, 41, 6, 56);
INSERT INTO versification_data VALUES (NULL, 6, 41, 7, 37);
INSERT INTO versification_data VALUES (NULL, 6, 41, 8, 38);
INSERT INTO versification_data VALUES (NULL, 6, 41, 9, 50);
INSERT INTO versification_data VALUES (NULL, 6, 41, 10, 52);
INSERT INTO versification_data VALUES (NULL, 6, 41, 11, 33);
INSERT INTO versification_data VALUES (NULL, 6, 41, 12, 44);
INSERT INTO versification_data VALUES (NULL, 6, 41, 13, 37);
INSERT INTO versification_data VALUES (NULL, 6, 41, 14, 72);
INSERT INTO versification_data VALUES (NULL, 6, 41, 15, 47);
INSERT INTO versification_data VALUES (NULL, 6, 41, 16, 20);
INSERT INTO versification_data VALUES (NULL, 6, 42, 1, 80);
INSERT INTO versification_data VALUES (NULL, 6, 42, 2, 52);
INSERT INTO versification_data VALUES (NULL, 6, 42, 3, 38);
INSERT INTO versification_data VALUES (NULL, 6, 42, 4, 44);
INSERT INTO versification_data VALUES (NULL, 6, 42, 5, 39);
INSERT INTO versification_data VALUES (NULL, 6, 42, 6, 49);
INSERT INTO versification_data VALUES (NULL, 6, 42, 7, 50);
INSERT INTO versification_data VALUES (NULL, 6, 42, 8, 56);
INSERT INTO versification_data VALUES (NULL, 6, 42, 9, 62);
INSERT INTO versification_data VALUES (NULL, 6, 42, 10, 42);
INSERT INTO versification_data VALUES (NULL, 6, 42, 11, 54);
INSERT INTO versification_data VALUES (NULL, 6, 42, 12, 59);
INSERT INTO versification_data VALUES (NULL, 6, 42, 13, 35);
INSERT INTO versification_data VALUES (NULL, 6, 42, 14, 35);
INSERT INTO versification_data VALUES (NULL, 6, 42, 15, 32);
INSERT INTO versification_data VALUES (NULL, 6, 42, 16, 31);
INSERT INTO versification_data VALUES (NULL, 6, 42, 17, 37);
INSERT INTO versification_data VALUES (NULL, 6, 42, 18, 43);
INSERT INTO versification_data VALUES (NULL, 6, 42, 19, 48);
INSERT INTO versification_data VALUES (NULL, 6, 42, 20, 47);
INSERT INTO versification_data VALUES (NULL, 6, 42, 21, 38);
INSERT INTO versification_data VALUES (NULL, 6, 42, 22, 71);
INSERT INTO versification_data VALUES (NULL, 6, 42, 23, 56);
INSERT INTO versification_data VALUES (NULL, 6, 42, 24, 53);
INSERT INTO versification_data VALUES (NULL, 6, 43, 1, 51);
INSERT INTO versification_data VALUES (NULL, 6, 43, 2, 25);
INSERT INTO versification_data VALUES (NULL, 6, 43, 3, 36);
INSERT INTO versification_data VALUES (NULL, 6, 43, 4, 54);
INSERT INTO versification_data VALUES (NULL, 6, 43, 5, 47);
INSERT INTO versification_data VALUES (NULL, 6, 43, 6, 71);
INSERT INTO versification_data VALUES (NULL, 6, 43, 7, 53);
INSERT INTO versification_data VALUES (NULL, 6, 43, 8, 59);
INSERT INTO versification_data VALUES (NULL, 6, 43, 9, 41);
INSERT INTO versification_data VALUES (NULL, 6, 43, 10, 42);
INSERT INTO versification_data VALUES (NULL, 6, 43, 11, 57);
INSERT INTO versification_data VALUES (NULL, 6, 43, 12, 50);
INSERT INTO versification_data VALUES (NULL, 6, 43, 13, 38);
INSERT INTO versification_data VALUES (NULL, 6, 43, 14, 31);
INSERT INTO versification_data VALUES (NULL, 6, 43, 15, 27);
INSERT INTO versification_data VALUES (NULL, 6, 43, 16, 33);
INSERT INTO versification_data VALUES (NULL, 6, 43, 17, 26);
INSERT INTO versification_data VALUES (NULL, 6, 43, 18, 40);
INSERT INTO versification_data VALUES (NULL, 6, 43, 19, 42);
INSERT INTO versification_data VALUES (NULL, 6, 43, 20, 31);
INSERT INTO versification_data VALUES (NULL, 6, 43, 21, 25);
INSERT INTO versification_data VALUES (NULL, 6, 44, 1, 26);
INSERT INTO versification_data VALUES (NULL, 6, 44, 2, 47);
INSERT INTO versification_data VALUES (NULL, 6, 44, 3, 26);
INSERT INTO versification_data VALUES (NULL, 6, 44, 4, 37);
INSERT INTO versification_data VALUES (NULL, 6, 44, 5, 42);
INSERT INTO versification_data VALUES (NULL, 6, 44, 6, 15);
INSERT INTO versification_data VALUES (NULL, 6, 44, 7, 60);
INSERT INTO versification_data VALUES (NULL, 6, 44, 8, 40);
INSERT INTO versification_data VALUES (NULL, 6, 44, 9, 43);
INSERT INTO versification_data VALUES (NULL, 6, 44, 10, 48);
INSERT INTO versification_data VALUES (NULL, 6, 44, 11, 30);
INSERT INTO versification_data VALUES (NULL, 6, 44, 12, 25);
INSERT INTO versification_data VALUES (NULL, 6, 44, 13, 52);
INSERT INTO versification_data VALUES (NULL, 6, 44, 14, 28);
INSERT INTO versification_data VALUES (NULL, 6, 44, 15, 41);
INSERT INTO versification_data VALUES (NULL, 6, 44, 16, 40);
INSERT INTO versification_data VALUES (NULL, 6, 44, 17, 34);
INSERT INTO versification_data VALUES (NULL, 6, 44, 18, 28);
INSERT INTO versification_data VALUES (NULL, 6, 44, 19, 40);
INSERT INTO versification_data VALUES (NULL, 6, 44, 20, 38);
INSERT INTO versification_data VALUES (NULL, 6, 44, 21, 40);
INSERT INTO versification_data VALUES (NULL, 6, 44, 22, 30);
INSERT INTO versification_data VALUES (NULL, 6, 44, 23, 35);
INSERT INTO versification_data VALUES (NULL, 6, 44, 24, 27);
INSERT INTO versification_data VALUES (NULL, 6, 44, 25, 27);
INSERT INTO versification_data VALUES (NULL, 6, 44, 26, 32);
INSERT INTO versification_data VALUES (NULL, 6, 44, 27, 44);
INSERT INTO versification_data VALUES (NULL, 6, 44, 28, 31);
INSERT INTO versification_data VALUES (NULL, 6, 45, 1, 32);
INSERT INTO versification_data VALUES (NULL, 6, 45, 2, 29);
INSERT INTO versification_data VALUES (NULL, 6, 45, 3, 31);
INSERT INTO versification_data VALUES (NULL, 6, 45, 4, 25);
INSERT INTO versification_data VALUES (NULL, 6, 45, 5, 21);
INSERT INTO versification_data VALUES (NULL, 6, 45, 6, 23);
INSERT INTO versification_data VALUES (NULL, 6, 45, 7, 25);
INSERT INTO versification_data VALUES (NULL, 6, 45, 8, 39);
INSERT INTO versification_data VALUES (NULL, 6, 45, 9, 33);
INSERT INTO versification_data VALUES (NULL, 6, 45, 10, 21);
INSERT INTO versification_data VALUES (NULL, 6, 45, 11, 36);
INSERT INTO versification_data VALUES (NULL, 6, 45, 12, 21);
INSERT INTO versification_data VALUES (NULL, 6, 45, 13, 14);
INSERT INTO versification_data VALUES (NULL, 6, 45, 14, 23);
INSERT INTO versification_data VALUES (NULL, 6, 45, 15, 33);
INSERT INTO versification_data VALUES (NULL, 6, 45, 16, 27);
INSERT INTO versification_data VALUES (NULL, 6, 46, 1, 31);
INSERT INTO versification_data VALUES (NULL, 6, 46, 2, 16);
INSERT INTO versification_data VALUES (NULL, 6, 46, 3, 23);
INSERT INTO versification_data VALUES (NULL, 6, 46, 4, 21);
INSERT INTO versification_data VALUES (NULL, 6, 46, 5, 13);
INSERT INTO versification_data VALUES (NULL, 6, 46, 6, 20);
INSERT INTO versification_data VALUES (NULL, 6, 46, 7, 40);
INSERT INTO versification_data VALUES (NULL, 6, 46, 8, 13);
INSERT INTO versification_data VALUES (NULL, 6, 46, 9, 27);
INSERT INTO versification_data VALUES (NULL, 6, 46, 10, 33);
INSERT INTO versification_data VALUES (NULL, 6, 46, 11, 34);
INSERT INTO versification_data VALUES (NULL, 6, 46, 12, 31);
INSERT INTO versification_data VALUES (NULL, 6, 46, 13, 13);
INSERT INTO versification_data VALUES (NULL, 6, 46, 14, 40);
INSERT INTO versification_data VALUES (NULL, 6, 46, 15, 58);
INSERT INTO versification_data VALUES (NULL, 6, 46, 16, 24);
INSERT INTO versification_data VALUES (NULL, 6, 47, 1, 24);
INSERT INTO versification_data VALUES (NULL, 6, 47, 2, 17);
INSERT INTO versification_data VALUES (NULL, 6, 47, 3, 18);
INSERT INTO versification_data VALUES (NULL, 6, 47, 4, 18);
INSERT INTO versification_data VALUES (NULL, 6, 47, 5, 21);
INSERT INTO versification_data VALUES (NULL, 6, 47, 6, 18);
INSERT INTO versification_data VALUES (NULL, 6, 47, 7, 16);
INSERT INTO versification_data VALUES (NULL, 6, 47, 8, 24);
INSERT INTO versification_data VALUES (NULL, 6, 47, 9, 15);
INSERT INTO versification_data VALUES (NULL, 6, 47, 10, 18);
INSERT INTO versification_data VALUES (NULL, 6, 47, 11, 33);
INSERT INTO versification_data VALUES (NULL, 6, 47, 12, 21);
INSERT INTO versification_data VALUES (NULL, 6, 47, 13, 13);
INSERT INTO versification_data VALUES (NULL, 6, 48, 1, 24);
INSERT INTO versification_data VALUES (NULL, 6, 48, 2, 21);
INSERT INTO versification_data VALUES (NULL, 6, 48, 3, 29);
INSERT INTO versification_data VALUES (NULL, 6, 48, 4, 31);
INSERT INTO versification_data VALUES (NULL, 6, 48, 5, 26);
INSERT INTO versification_data VALUES (NULL, 6, 48, 6, 18);
INSERT INTO versification_data VALUES (NULL, 6, 49, 1, 23);
INSERT INTO versification_data VALUES (NULL, 6, 49, 2, 22);
INSERT INTO versification_data VALUES (NULL, 6, 49, 3, 21);
INSERT INTO versification_data VALUES (NULL, 6, 49, 4, 32);
INSERT INTO versification_data VALUES (NULL, 6, 49, 5, 33);
INSERT INTO versification_data VALUES (NULL, 6, 49, 6, 24);
INSERT INTO versification_data VALUES (NULL, 6, 50, 1, 30);
INSERT INTO versification_data VALUES (NULL, 6, 50, 2, 30);
INSERT INTO versification_data VALUES (NULL, 6, 50, 3, 21);
INSERT INTO versification_data VALUES (NULL, 6, 50, 4, 23);
INSERT INTO versification_data VALUES (NULL, 6, 51, 1, 29);
INSERT INTO versification_data VALUES (NULL, 6, 51, 2, 23);
INSERT INTO versification_data VALUES (NULL, 6, 51, 3, 25);
INSERT INTO versification_data VALUES (NULL, 6, 51, 4, 18);
INSERT INTO versification_data VALUES (NULL, 6, 52, 1, 10);
INSERT INTO versification_data VALUES (NULL, 6, 52, 2, 20);
INSERT INTO versification_data VALUES (NULL, 6, 52, 3, 13);
INSERT INTO versification_data VALUES (NULL, 6, 52, 4, 18);
INSERT INTO versification_data VALUES (NULL, 6, 52, 5, 28);
INSERT INTO versification_data VALUES (NULL, 6, 53, 1, 12);
INSERT INTO versification_data VALUES (NULL, 6, 53, 2, 17);
INSERT INTO versification_data VALUES (NULL, 6, 53, 3, 18);
INSERT INTO versification_data VALUES (NULL, 6, 54, 1, 20);
INSERT INTO versification_data VALUES (NULL, 6, 54, 2, 15);
INSERT INTO versification_data VALUES (NULL, 6, 54, 3, 16);
INSERT INTO versification_data VALUES (NULL, 6, 54, 4, 16);
INSERT INTO versification_data VALUES (NULL, 6, 54, 5, 25);
INSERT INTO versification_data VALUES (NULL, 6, 54, 6, 21);
INSERT INTO versification_data VALUES (NULL, 6, 55, 1, 18);
INSERT INTO versification_data VALUES (NULL, 6, 55, 2, 26);
INSERT INTO versification_data VALUES (NULL, 6, 55, 3, 17);
INSERT INTO versification_data VALUES (NULL, 6, 55, 4, 22);
INSERT INTO versification_data VALUES (NULL, 6, 56, 1, 16);
INSERT INTO versification_data VALUES (NULL, 6, 56, 2, 15);
INSERT INTO versification_data VALUES (NULL, 6, 56, 3, 15);
INSERT INTO versification_data VALUES (NULL, 6, 57, 1, 25);
INSERT INTO versification_data VALUES (NULL, 6, 58, 1, 14);
INSERT INTO versification_data VALUES (NULL, 6, 58, 2, 18);
INSERT INTO versification_data VALUES (NULL, 6, 58, 3, 19);
INSERT INTO versification_data VALUES (NULL, 6, 58, 4, 16);
INSERT INTO versification_data VALUES (NULL, 6, 58, 5, 14);
INSERT INTO versification_data VALUES (NULL, 6, 58, 6, 20);
INSERT INTO versification_data VALUES (NULL, 6, 58, 7, 28);
INSERT INTO versification_data VALUES (NULL, 6, 58, 8, 13);
INSERT INTO versification_data VALUES (NULL, 6, 58, 9, 28);
INSERT INTO versification_data VALUES (NULL, 6, 58, 10, 39);
INSERT INTO versification_data VALUES (NULL, 6, 58, 11, 40);
INSERT INTO versification_data VALUES (NULL, 6, 58, 12, 29);
INSERT INTO versification_data VALUES (NULL, 6, 58, 13, 25);
INSERT INTO versification_data VALUES (NULL, 6, 59, 1, 27);
INSERT INTO versification_data VALUES (NULL, 6, 59, 2, 26);
INSERT INTO versification_data VALUES (NULL, 6, 59, 3, 18);
INSERT INTO versification_data VALUES (NULL, 6, 59, 4, 17);
INSERT INTO versification_data VALUES (NULL, 6, 59, 5, 20);
INSERT INTO versification_data VALUES (NULL, 6, 60, 1, 25);
INSERT INTO versification_data VALUES (NULL, 6, 60, 2, 25);
INSERT INTO versification_data VALUES (NULL, 6, 60, 3, 22);
INSERT INTO versification_data VALUES (NULL, 6, 60, 4, 19);
INSERT INTO versification_data VALUES (NULL, 6, 60, 5, 14);
INSERT INTO versification_data VALUES (NULL, 6, 61, 1, 21);
INSERT INTO versification_data VALUES (NULL, 6, 61, 2, 22);
INSERT INTO versification_data VALUES (NULL, 6, 61, 3, 18);
INSERT INTO versification_data VALUES (NULL, 6, 62, 1, 10);
INSERT INTO versification_data VALUES (NULL, 6, 62, 2, 29);
INSERT INTO versification_data VALUES (NULL, 6, 62, 3, 24);
INSERT INTO versification_data VALUES (NULL, 6, 62, 4, 21);
INSERT INTO versification_data VALUES (NULL, 6, 62, 5, 21);
INSERT INTO versification_data VALUES (NULL, 6, 63, 1, 13);
INSERT INTO versification_data VALUES (NULL, 6, 64, 1, 15);
INSERT INTO versification_data VALUES (NULL, 6, 65, 1, 25);
INSERT INTO versification_data VALUES (NULL, 6, 66, 1, 20);
INSERT INTO versification_data VALUES (NULL, 6, 66, 2, 29);
INSERT INTO versification_data VALUES (NULL, 6, 66, 3, 22);
INSERT INTO versification_data VALUES (NULL, 6, 66, 4, 11);
INSERT INTO versification_data VALUES (NULL, 6, 66, 5, 14);
INSERT INTO versification_data VALUES (NULL, 6, 66, 6, 17);
INSERT INTO versification_data VALUES (NULL, 6, 66, 7, 17);
INSERT INTO versification_data VALUES (NULL, 6, 66, 8, 13);
INSERT INTO versification_data VALUES (NULL, 6, 66, 9, 21);
INSERT INTO versification_data VALUES (NULL, 6, 66, 10, 11);
INSERT INTO versification_data VALUES (NULL, 6, 66, 11, 19);
INSERT INTO versification_data VALUES (NULL, 6, 66, 12, 18);
INSERT INTO versification_data VALUES (NULL, 6, 66, 13, 18);
INSERT INTO versification_data VALUES (NULL, 6, 66, 14, 20);
INSERT INTO versification_data VALUES (NULL, 6, 66, 15, 8);
INSERT INTO versification_data VALUES (NULL, 6, 66, 16, 21);
INSERT INTO versification_data VALUES (NULL, 6, 66, 17, 18);
INSERT INTO versification_data VALUES (NULL, 6, 66, 18, 24);
INSERT INTO versification_data VALUES (NULL, 6, 66, 19, 21);
INSERT INTO versification_data VALUES (NULL, 6, 66, 20, 15);
INSERT INTO versification_data VALUES (NULL, 6, 66, 21, 27);
INSERT INTO versification_data VALUES (NULL, 6, 66, 22, 21);

INSERT INTO versification_names VALUES (7, 'English');

INSERT INTO versification_data VALUES (NULL, 7, 1, 1, 31);
INSERT INTO versification_data VALUES (NULL, 7, 1, 2, 25);
INSERT INTO versification_data VALUES (NULL, 7, 1, 3, 24);
INSERT INTO versification_data VALUES (NULL, 7, 1, 4, 26);
INSERT INTO versification_data VALUES (NULL, 7, 1, 5, 32);
INSERT INTO versification_data VALUES (NULL, 7, 1, 6, 22);
INSERT INTO versification_data VALUES (NULL, 7, 1, 7, 24);
INSERT INTO versification_data VALUES (NULL, 7, 1, 8, 22);
INSERT INTO versification_data VALUES (NULL, 7, 1, 9, 29);
INSERT INTO versification_data VALUES (NULL, 7, 1, 10, 32);
INSERT INTO versification_data VALUES (NULL, 7, 1, 11, 32);
INSERT INTO versification_data VALUES (NULL, 7, 1, 12, 20);
INSERT INTO versification_data VALUES (NULL, 7, 1, 13, 18);
INSERT INTO versification_data VALUES (NULL, 7, 1, 14, 24);
INSERT INTO versification_data VALUES (NULL, 7, 1, 15, 21);
INSERT INTO versification_data VALUES (NULL, 7, 1, 16, 16);
INSERT INTO versification_data VALUES (NULL, 7, 1, 17, 27);
INSERT INTO versification_data VALUES (NULL, 7, 1, 18, 33);
INSERT INTO versification_data VALUES (NULL, 7, 1, 19, 38);
INSERT INTO versification_data VALUES (NULL, 7, 1, 20, 18);
INSERT INTO versification_data VALUES (NULL, 7, 1, 21, 34);
INSERT INTO versification_data VALUES (NULL, 7, 1, 22, 24);
INSERT INTO versification_data VALUES (NULL, 7, 1, 23, 20);
INSERT INTO versification_data VALUES (NULL, 7, 1, 24, 67);
INSERT INTO versification_data VALUES (NULL, 7, 1, 25, 34);
INSERT INTO versification_data VALUES (NULL, 7, 1, 26, 35);
INSERT INTO versification_data VALUES (NULL, 7, 1, 27, 46);
INSERT INTO versification_data VALUES (NULL, 7, 1, 28, 22);
INSERT INTO versification_data VALUES (NULL, 7, 1, 29, 35);
INSERT INTO versification_data VALUES (NULL, 7, 1, 30, 43);
INSERT INTO versification_data VALUES (NULL, 7, 1, 31, 55);
INSERT INTO versification_data VALUES (NULL, 7, 1, 32, 32);
INSERT INTO versification_data VALUES (NULL, 7, 1, 33, 20);
INSERT INTO versification_data VALUES (NULL, 7, 1, 34, 31);
INSERT INTO versification_data VALUES (NULL, 7, 1, 35, 29);
INSERT INTO versification_data VALUES (NULL, 7, 1, 36, 43);
INSERT INTO versification_data VALUES (NULL, 7, 1, 37, 36);
INSERT INTO versification_data VALUES (NULL, 7, 1, 38, 30);
INSERT INTO versification_data VALUES (NULL, 7, 1, 39, 23);
INSERT INTO versification_data VALUES (NULL, 7, 1, 40, 23);
INSERT INTO versification_data VALUES (NULL, 7, 1, 41, 57);
INSERT INTO versification_data VALUES (NULL, 7, 1, 42, 38);
INSERT INTO versification_data VALUES (NULL, 7, 1, 43, 34);
INSERT INTO versification_data VALUES (NULL, 7, 1, 44, 34);
INSERT INTO versification_data VALUES (NULL, 7, 1, 45, 28);
INSERT INTO versification_data VALUES (NULL, 7, 1, 46, 34);
INSERT INTO versification_data VALUES (NULL, 7, 1, 47, 31);
INSERT INTO versification_data VALUES (NULL, 7, 1, 48, 22);
INSERT INTO versification_data VALUES (NULL, 7, 1, 49, 33);
INSERT INTO versification_data VALUES (NULL, 7, 1, 50, 26);
INSERT INTO versification_data VALUES (NULL, 7, 2, 1, 22);
INSERT INTO versification_data VALUES (NULL, 7, 2, 2, 25);
INSERT INTO versification_data VALUES (NULL, 7, 2, 3, 22);
INSERT INTO versification_data VALUES (NULL, 7, 2, 4, 31);
INSERT INTO versification_data VALUES (NULL, 7, 2, 5, 23);
INSERT INTO versification_data VALUES (NULL, 7, 2, 6, 30);
INSERT INTO versification_data VALUES (NULL, 7, 2, 7, 25);
INSERT INTO versification_data VALUES (NULL, 7, 2, 8, 32);
INSERT INTO versification_data VALUES (NULL, 7, 2, 9, 35);
INSERT INTO versification_data VALUES (NULL, 7, 2, 10, 29);
INSERT INTO versification_data VALUES (NULL, 7, 2, 11, 10);
INSERT INTO versification_data VALUES (NULL, 7, 2, 12, 51);
INSERT INTO versification_data VALUES (NULL, 7, 2, 13, 22);
INSERT INTO versification_data VALUES (NULL, 7, 2, 14, 31);
INSERT INTO versification_data VALUES (NULL, 7, 2, 15, 27);
INSERT INTO versification_data VALUES (NULL, 7, 2, 16, 36);
INSERT INTO versification_data VALUES (NULL, 7, 2, 17, 16);
INSERT INTO versification_data VALUES (NULL, 7, 2, 18, 27);
INSERT INTO versification_data VALUES (NULL, 7, 2, 19, 25);
INSERT INTO versification_data VALUES (NULL, 7, 2, 20, 26);
INSERT INTO versification_data VALUES (NULL, 7, 2, 21, 36);
INSERT INTO versification_data VALUES (NULL, 7, 2, 22, 31);
INSERT INTO versification_data VALUES (NULL, 7, 2, 23, 33);
INSERT INTO versification_data VALUES (NULL, 7, 2, 24, 18);
INSERT INTO versification_data VALUES (NULL, 7, 2, 25, 40);
INSERT INTO versification_data VALUES (NULL, 7, 2, 26, 37);
INSERT INTO versification_data VALUES (NULL, 7, 2, 27, 21);
INSERT INTO versification_data VALUES (NULL, 7, 2, 28, 43);
INSERT INTO versification_data VALUES (NULL, 7, 2, 29, 46);
INSERT INTO versification_data VALUES (NULL, 7, 2, 30, 38);
INSERT INTO versification_data VALUES (NULL, 7, 2, 31, 18);
INSERT INTO versification_data VALUES (NULL, 7, 2, 32, 35);
INSERT INTO versification_data VALUES (NULL, 7, 2, 33, 23);
INSERT INTO versification_data VALUES (NULL, 7, 2, 34, 35);
INSERT INTO versification_data VALUES (NULL, 7, 2, 35, 35);
INSERT INTO versification_data VALUES (NULL, 7, 2, 36, 38);
INSERT INTO versification_data VALUES (NULL, 7, 2, 37, 29);
INSERT INTO versification_data VALUES (NULL, 7, 2, 38, 31);
INSERT INTO versification_data VALUES (NULL, 7, 2, 39, 43);
INSERT INTO versification_data VALUES (NULL, 7, 2, 40, 38);
INSERT INTO versification_data VALUES (NULL, 7, 3, 1, 17);
INSERT INTO versification_data VALUES (NULL, 7, 3, 2, 16);
INSERT INTO versification_data VALUES (NULL, 7, 3, 3, 17);
INSERT INTO versification_data VALUES (NULL, 7, 3, 4, 35);
INSERT INTO versification_data VALUES (NULL, 7, 3, 5, 19);
INSERT INTO versification_data VALUES (NULL, 7, 3, 6, 30);
INSERT INTO versification_data VALUES (NULL, 7, 3, 7, 38);
INSERT INTO versification_data VALUES (NULL, 7, 3, 8, 36);
INSERT INTO versification_data VALUES (NULL, 7, 3, 9, 24);
INSERT INTO versification_data VALUES (NULL, 7, 3, 10, 20);
INSERT INTO versification_data VALUES (NULL, 7, 3, 11, 47);
INSERT INTO versification_data VALUES (NULL, 7, 3, 12, 8);
INSERT INTO versification_data VALUES (NULL, 7, 3, 13, 59);
INSERT INTO versification_data VALUES (NULL, 7, 3, 14, 57);
INSERT INTO versification_data VALUES (NULL, 7, 3, 15, 33);
INSERT INTO versification_data VALUES (NULL, 7, 3, 16, 34);
INSERT INTO versification_data VALUES (NULL, 7, 3, 17, 16);
INSERT INTO versification_data VALUES (NULL, 7, 3, 18, 30);
INSERT INTO versification_data VALUES (NULL, 7, 3, 19, 37);
INSERT INTO versification_data VALUES (NULL, 7, 3, 20, 27);
INSERT INTO versification_data VALUES (NULL, 7, 3, 21, 24);
INSERT INTO versification_data VALUES (NULL, 7, 3, 22, 33);
INSERT INTO versification_data VALUES (NULL, 7, 3, 23, 44);
INSERT INTO versification_data VALUES (NULL, 7, 3, 24, 23);
INSERT INTO versification_data VALUES (NULL, 7, 3, 25, 55);
INSERT INTO versification_data VALUES (NULL, 7, 3, 26, 46);
INSERT INTO versification_data VALUES (NULL, 7, 3, 27, 34);
INSERT INTO versification_data VALUES (NULL, 7, 4, 1, 54);
INSERT INTO versification_data VALUES (NULL, 7, 4, 2, 34);
INSERT INTO versification_data VALUES (NULL, 7, 4, 3, 51);
INSERT INTO versification_data VALUES (NULL, 7, 4, 4, 49);
INSERT INTO versification_data VALUES (NULL, 7, 4, 5, 31);
INSERT INTO versification_data VALUES (NULL, 7, 4, 6, 27);
INSERT INTO versification_data VALUES (NULL, 7, 4, 7, 89);
INSERT INTO versification_data VALUES (NULL, 7, 4, 8, 26);
INSERT INTO versification_data VALUES (NULL, 7, 4, 9, 23);
INSERT INTO versification_data VALUES (NULL, 7, 4, 10, 36);
INSERT INTO versification_data VALUES (NULL, 7, 4, 11, 35);
INSERT INTO versification_data VALUES (NULL, 7, 4, 12, 16);
INSERT INTO versification_data VALUES (NULL, 7, 4, 13, 33);
INSERT INTO versification_data VALUES (NULL, 7, 4, 14, 45);
INSERT INTO versification_data VALUES (NULL, 7, 4, 15, 41);
INSERT INTO versification_data VALUES (NULL, 7, 4, 16, 50);
INSERT INTO versification_data VALUES (NULL, 7, 4, 17, 13);
INSERT INTO versification_data VALUES (NULL, 7, 4, 18, 32);
INSERT INTO versification_data VALUES (NULL, 7, 4, 19, 22);
INSERT INTO versification_data VALUES (NULL, 7, 4, 20, 29);
INSERT INTO versification_data VALUES (NULL, 7, 4, 21, 35);
INSERT INTO versification_data VALUES (NULL, 7, 4, 22, 41);
INSERT INTO versification_data VALUES (NULL, 7, 4, 23, 30);
INSERT INTO versification_data VALUES (NULL, 7, 4, 24, 25);
INSERT INTO versification_data VALUES (NULL, 7, 4, 25, 18);
INSERT INTO versification_data VALUES (NULL, 7, 4, 26, 65);
INSERT INTO versification_data VALUES (NULL, 7, 4, 27, 23);
INSERT INTO versification_data VALUES (NULL, 7, 4, 28, 31);
INSERT INTO versification_data VALUES (NULL, 7, 4, 29, 40);
INSERT INTO versification_data VALUES (NULL, 7, 4, 30, 16);
INSERT INTO versification_data VALUES (NULL, 7, 4, 31, 54);
INSERT INTO versification_data VALUES (NULL, 7, 4, 32, 42);
INSERT INTO versification_data VALUES (NULL, 7, 4, 33, 56);
INSERT INTO versification_data VALUES (NULL, 7, 4, 34, 29);
INSERT INTO versification_data VALUES (NULL, 7, 4, 35, 34);
INSERT INTO versification_data VALUES (NULL, 7, 4, 36, 13);
INSERT INTO versification_data VALUES (NULL, 7, 5, 1, 46);
INSERT INTO versification_data VALUES (NULL, 7, 5, 2, 37);
INSERT INTO versification_data VALUES (NULL, 7, 5, 3, 29);
INSERT INTO versification_data VALUES (NULL, 7, 5, 4, 49);
INSERT INTO versification_data VALUES (NULL, 7, 5, 5, 33);
INSERT INTO versification_data VALUES (NULL, 7, 5, 6, 25);
INSERT INTO versification_data VALUES (NULL, 7, 5, 7, 26);
INSERT INTO versification_data VALUES (NULL, 7, 5, 8, 20);
INSERT INTO versification_data VALUES (NULL, 7, 5, 9, 29);
INSERT INTO versification_data VALUES (NULL, 7, 5, 10, 22);
INSERT INTO versification_data VALUES (NULL, 7, 5, 11, 32);
INSERT INTO versification_data VALUES (NULL, 7, 5, 12, 32);
INSERT INTO versification_data VALUES (NULL, 7, 5, 13, 18);
INSERT INTO versification_data VALUES (NULL, 7, 5, 14, 29);
INSERT INTO versification_data VALUES (NULL, 7, 5, 15, 23);
INSERT INTO versification_data VALUES (NULL, 7, 5, 16, 22);
INSERT INTO versification_data VALUES (NULL, 7, 5, 17, 20);
INSERT INTO versification_data VALUES (NULL, 7, 5, 18, 22);
INSERT INTO versification_data VALUES (NULL, 7, 5, 19, 21);
INSERT INTO versification_data VALUES (NULL, 7, 5, 20, 20);
INSERT INTO versification_data VALUES (NULL, 7, 5, 21, 23);
INSERT INTO versification_data VALUES (NULL, 7, 5, 22, 30);
INSERT INTO versification_data VALUES (NULL, 7, 5, 23, 25);
INSERT INTO versification_data VALUES (NULL, 7, 5, 24, 22);
INSERT INTO versification_data VALUES (NULL, 7, 5, 25, 19);
INSERT INTO versification_data VALUES (NULL, 7, 5, 26, 19);
INSERT INTO versification_data VALUES (NULL, 7, 5, 27, 26);
INSERT INTO versification_data VALUES (NULL, 7, 5, 28, 68);
INSERT INTO versification_data VALUES (NULL, 7, 5, 29, 29);
INSERT INTO versification_data VALUES (NULL, 7, 5, 30, 20);
INSERT INTO versification_data VALUES (NULL, 7, 5, 31, 30);
INSERT INTO versification_data VALUES (NULL, 7, 5, 32, 52);
INSERT INTO versification_data VALUES (NULL, 7, 5, 33, 29);
INSERT INTO versification_data VALUES (NULL, 7, 5, 34, 12);
INSERT INTO versification_data VALUES (NULL, 7, 6, 1, 18);
INSERT INTO versification_data VALUES (NULL, 7, 6, 2, 24);
INSERT INTO versification_data VALUES (NULL, 7, 6, 3, 17);
INSERT INTO versification_data VALUES (NULL, 7, 6, 4, 24);
INSERT INTO versification_data VALUES (NULL, 7, 6, 5, 15);
INSERT INTO versification_data VALUES (NULL, 7, 6, 6, 27);
INSERT INTO versification_data VALUES (NULL, 7, 6, 7, 26);
INSERT INTO versification_data VALUES (NULL, 7, 6, 8, 35);
INSERT INTO versification_data VALUES (NULL, 7, 6, 9, 27);
INSERT INTO versification_data VALUES (NULL, 7, 6, 10, 43);
INSERT INTO versification_data VALUES (NULL, 7, 6, 11, 23);
INSERT INTO versification_data VALUES (NULL, 7, 6, 12, 24);
INSERT INTO versification_data VALUES (NULL, 7, 6, 13, 33);
INSERT INTO versification_data VALUES (NULL, 7, 6, 14, 15);
INSERT INTO versification_data VALUES (NULL, 7, 6, 15, 63);
INSERT INTO versification_data VALUES (NULL, 7, 6, 16, 10);
INSERT INTO versification_data VALUES (NULL, 7, 6, 17, 18);
INSERT INTO versification_data VALUES (NULL, 7, 6, 18, 28);
INSERT INTO versification_data VALUES (NULL, 7, 6, 19, 51);
INSERT INTO versification_data VALUES (NULL, 7, 6, 20, 9);
INSERT INTO versification_data VALUES (NULL, 7, 6, 21, 45);
INSERT INTO versification_data VALUES (NULL, 7, 6, 22, 34);
INSERT INTO versification_data VALUES (NULL, 7, 6, 23, 16);
INSERT INTO versification_data VALUES (NULL, 7, 6, 24, 33);
INSERT INTO versification_data VALUES (NULL, 7, 7, 1, 36);
INSERT INTO versification_data VALUES (NULL, 7, 7, 2, 23);
INSERT INTO versification_data VALUES (NULL, 7, 7, 3, 31);
INSERT INTO versification_data VALUES (NULL, 7, 7, 4, 24);
INSERT INTO versification_data VALUES (NULL, 7, 7, 5, 31);
INSERT INTO versification_data VALUES (NULL, 7, 7, 6, 40);
INSERT INTO versification_data VALUES (NULL, 7, 7, 7, 25);
INSERT INTO versification_data VALUES (NULL, 7, 7, 8, 35);
INSERT INTO versification_data VALUES (NULL, 7, 7, 9, 57);
INSERT INTO versification_data VALUES (NULL, 7, 7, 10, 18);
INSERT INTO versification_data VALUES (NULL, 7, 7, 11, 40);
INSERT INTO versification_data VALUES (NULL, 7, 7, 12, 15);
INSERT INTO versification_data VALUES (NULL, 7, 7, 13, 25);
INSERT INTO versification_data VALUES (NULL, 7, 7, 14, 20);
INSERT INTO versification_data VALUES (NULL, 7, 7, 15, 20);
INSERT INTO versification_data VALUES (NULL, 7, 7, 16, 31);
INSERT INTO versification_data VALUES (NULL, 7, 7, 17, 13);
INSERT INTO versification_data VALUES (NULL, 7, 7, 18, 31);
INSERT INTO versification_data VALUES (NULL, 7, 7, 19, 30);
INSERT INTO versification_data VALUES (NULL, 7, 7, 20, 48);
INSERT INTO versification_data VALUES (NULL, 7, 7, 21, 25);
INSERT INTO versification_data VALUES (NULL, 7, 8, 1, 22);
INSERT INTO versification_data VALUES (NULL, 7, 8, 2, 23);
INSERT INTO versification_data VALUES (NULL, 7, 8, 3, 18);
INSERT INTO versification_data VALUES (NULL, 7, 8, 4, 22);
INSERT INTO versification_data VALUES (NULL, 7, 9, 1, 28);
INSERT INTO versification_data VALUES (NULL, 7, 9, 2, 36);
INSERT INTO versification_data VALUES (NULL, 7, 9, 3, 21);
INSERT INTO versification_data VALUES (NULL, 7, 9, 4, 22);
INSERT INTO versification_data VALUES (NULL, 7, 9, 5, 12);
INSERT INTO versification_data VALUES (NULL, 7, 9, 6, 21);
INSERT INTO versification_data VALUES (NULL, 7, 9, 7, 17);
INSERT INTO versification_data VALUES (NULL, 7, 9, 8, 22);
INSERT INTO versification_data VALUES (NULL, 7, 9, 9, 27);
INSERT INTO versification_data VALUES (NULL, 7, 9, 10, 27);
INSERT INTO versification_data VALUES (NULL, 7, 9, 11, 15);
INSERT INTO versification_data VALUES (NULL, 7, 9, 12, 25);
INSERT INTO versification_data VALUES (NULL, 7, 9, 13, 23);
INSERT INTO versification_data VALUES (NULL, 7, 9, 14, 52);
INSERT INTO versification_data VALUES (NULL, 7, 9, 15, 35);
INSERT INTO versification_data VALUES (NULL, 7, 9, 16, 23);
INSERT INTO versification_data VALUES (NULL, 7, 9, 17, 58);
INSERT INTO versification_data VALUES (NULL, 7, 9, 18, 30);
INSERT INTO versification_data VALUES (NULL, 7, 9, 19, 24);
INSERT INTO versification_data VALUES (NULL, 7, 9, 20, 42);
INSERT INTO versification_data VALUES (NULL, 7, 9, 21, 15);
INSERT INTO versification_data VALUES (NULL, 7, 9, 22, 23);
INSERT INTO versification_data VALUES (NULL, 7, 9, 23, 29);
INSERT INTO versification_data VALUES (NULL, 7, 9, 24, 22);
INSERT INTO versification_data VALUES (NULL, 7, 9, 25, 44);
INSERT INTO versification_data VALUES (NULL, 7, 9, 26, 25);
INSERT INTO versification_data VALUES (NULL, 7, 9, 27, 12);
INSERT INTO versification_data VALUES (NULL, 7, 9, 28, 25);
INSERT INTO versification_data VALUES (NULL, 7, 9, 29, 11);
INSERT INTO versification_data VALUES (NULL, 7, 9, 30, 31);
INSERT INTO versification_data VALUES (NULL, 7, 9, 31, 13);
INSERT INTO versification_data VALUES (NULL, 7, 10, 1, 27);
INSERT INTO versification_data VALUES (NULL, 7, 10, 2, 32);
INSERT INTO versification_data VALUES (NULL, 7, 10, 3, 39);
INSERT INTO versification_data VALUES (NULL, 7, 10, 4, 12);
INSERT INTO versification_data VALUES (NULL, 7, 10, 5, 25);
INSERT INTO versification_data VALUES (NULL, 7, 10, 6, 23);
INSERT INTO versification_data VALUES (NULL, 7, 10, 7, 29);
INSERT INTO versification_data VALUES (NULL, 7, 10, 8, 18);
INSERT INTO versification_data VALUES (NULL, 7, 10, 9, 13);
INSERT INTO versification_data VALUES (NULL, 7, 10, 10, 19);
INSERT INTO versification_data VALUES (NULL, 7, 10, 11, 27);
INSERT INTO versification_data VALUES (NULL, 7, 10, 12, 31);
INSERT INTO versification_data VALUES (NULL, 7, 10, 13, 39);
INSERT INTO versification_data VALUES (NULL, 7, 10, 14, 33);
INSERT INTO versification_data VALUES (NULL, 7, 10, 15, 37);
INSERT INTO versification_data VALUES (NULL, 7, 10, 16, 23);
INSERT INTO versification_data VALUES (NULL, 7, 10, 17, 29);
INSERT INTO versification_data VALUES (NULL, 7, 10, 18, 33);
INSERT INTO versification_data VALUES (NULL, 7, 10, 19, 43);
INSERT INTO versification_data VALUES (NULL, 7, 10, 20, 26);
INSERT INTO versification_data VALUES (NULL, 7, 10, 21, 22);
INSERT INTO versification_data VALUES (NULL, 7, 10, 22, 51);
INSERT INTO versification_data VALUES (NULL, 7, 10, 23, 39);
INSERT INTO versification_data VALUES (NULL, 7, 10, 24, 25);
INSERT INTO versification_data VALUES (NULL, 7, 11, 1, 53);
INSERT INTO versification_data VALUES (NULL, 7, 11, 2, 46);
INSERT INTO versification_data VALUES (NULL, 7, 11, 3, 28);
INSERT INTO versification_data VALUES (NULL, 7, 11, 4, 34);
INSERT INTO versification_data VALUES (NULL, 7, 11, 5, 18);
INSERT INTO versification_data VALUES (NULL, 7, 11, 6, 38);
INSERT INTO versification_data VALUES (NULL, 7, 11, 7, 51);
INSERT INTO versification_data VALUES (NULL, 7, 11, 8, 66);
INSERT INTO versification_data VALUES (NULL, 7, 11, 9, 28);
INSERT INTO versification_data VALUES (NULL, 7, 11, 10, 29);
INSERT INTO versification_data VALUES (NULL, 7, 11, 11, 43);
INSERT INTO versification_data VALUES (NULL, 7, 11, 12, 33);
INSERT INTO versification_data VALUES (NULL, 7, 11, 13, 34);
INSERT INTO versification_data VALUES (NULL, 7, 11, 14, 31);
INSERT INTO versification_data VALUES (NULL, 7, 11, 15, 34);
INSERT INTO versification_data VALUES (NULL, 7, 11, 16, 34);
INSERT INTO versification_data VALUES (NULL, 7, 11, 17, 24);
INSERT INTO versification_data VALUES (NULL, 7, 11, 18, 46);
INSERT INTO versification_data VALUES (NULL, 7, 11, 19, 21);
INSERT INTO versification_data VALUES (NULL, 7, 11, 20, 43);
INSERT INTO versification_data VALUES (NULL, 7, 11, 21, 29);
INSERT INTO versification_data VALUES (NULL, 7, 11, 22, 53);
INSERT INTO versification_data VALUES (NULL, 7, 12, 1, 18);
INSERT INTO versification_data VALUES (NULL, 7, 12, 2, 25);
INSERT INTO versification_data VALUES (NULL, 7, 12, 3, 27);
INSERT INTO versification_data VALUES (NULL, 7, 12, 4, 44);
INSERT INTO versification_data VALUES (NULL, 7, 12, 5, 27);
INSERT INTO versification_data VALUES (NULL, 7, 12, 6, 33);
INSERT INTO versification_data VALUES (NULL, 7, 12, 7, 20);
INSERT INTO versification_data VALUES (NULL, 7, 12, 8, 29);
INSERT INTO versification_data VALUES (NULL, 7, 12, 9, 37);
INSERT INTO versification_data VALUES (NULL, 7, 12, 10, 36);
INSERT INTO versification_data VALUES (NULL, 7, 12, 11, 21);
INSERT INTO versification_data VALUES (NULL, 7, 12, 12, 21);
INSERT INTO versification_data VALUES (NULL, 7, 12, 13, 25);
INSERT INTO versification_data VALUES (NULL, 7, 12, 14, 29);
INSERT INTO versification_data VALUES (NULL, 7, 12, 15, 38);
INSERT INTO versification_data VALUES (NULL, 7, 12, 16, 20);
INSERT INTO versification_data VALUES (NULL, 7, 12, 17, 41);
INSERT INTO versification_data VALUES (NULL, 7, 12, 18, 37);
INSERT INTO versification_data VALUES (NULL, 7, 12, 19, 37);
INSERT INTO versification_data VALUES (NULL, 7, 12, 20, 21);
INSERT INTO versification_data VALUES (NULL, 7, 12, 21, 26);
INSERT INTO versification_data VALUES (NULL, 7, 12, 22, 20);
INSERT INTO versification_data VALUES (NULL, 7, 12, 23, 37);
INSERT INTO versification_data VALUES (NULL, 7, 12, 24, 20);
INSERT INTO versification_data VALUES (NULL, 7, 12, 25, 30);
INSERT INTO versification_data VALUES (NULL, 7, 13, 1, 54);
INSERT INTO versification_data VALUES (NULL, 7, 13, 2, 55);
INSERT INTO versification_data VALUES (NULL, 7, 13, 3, 24);
INSERT INTO versification_data VALUES (NULL, 7, 13, 4, 43);
INSERT INTO versification_data VALUES (NULL, 7, 13, 5, 26);
INSERT INTO versification_data VALUES (NULL, 7, 13, 6, 81);
INSERT INTO versification_data VALUES (NULL, 7, 13, 7, 40);
INSERT INTO versification_data VALUES (NULL, 7, 13, 8, 40);
INSERT INTO versification_data VALUES (NULL, 7, 13, 9, 44);
INSERT INTO versification_data VALUES (NULL, 7, 13, 10, 14);
INSERT INTO versification_data VALUES (NULL, 7, 13, 11, 47);
INSERT INTO versification_data VALUES (NULL, 7, 13, 12, 40);
INSERT INTO versification_data VALUES (NULL, 7, 13, 13, 14);
INSERT INTO versification_data VALUES (NULL, 7, 13, 14, 17);
INSERT INTO versification_data VALUES (NULL, 7, 13, 15, 29);
INSERT INTO versification_data VALUES (NULL, 7, 13, 16, 43);
INSERT INTO versification_data VALUES (NULL, 7, 13, 17, 27);
INSERT INTO versification_data VALUES (NULL, 7, 13, 18, 17);
INSERT INTO versification_data VALUES (NULL, 7, 13, 19, 19);
INSERT INTO versification_data VALUES (NULL, 7, 13, 20, 8);
INSERT INTO versification_data VALUES (NULL, 7, 13, 21, 30);
INSERT INTO versification_data VALUES (NULL, 7, 13, 22, 19);
INSERT INTO versification_data VALUES (NULL, 7, 13, 23, 32);
INSERT INTO versification_data VALUES (NULL, 7, 13, 24, 31);
INSERT INTO versification_data VALUES (NULL, 7, 13, 25, 31);
INSERT INTO versification_data VALUES (NULL, 7, 13, 26, 32);
INSERT INTO versification_data VALUES (NULL, 7, 13, 27, 34);
INSERT INTO versification_data VALUES (NULL, 7, 13, 28, 21);
INSERT INTO versification_data VALUES (NULL, 7, 13, 29, 30);
INSERT INTO versification_data VALUES (NULL, 7, 14, 1, 17);
INSERT INTO versification_data VALUES (NULL, 7, 14, 2, 18);
INSERT INTO versification_data VALUES (NULL, 7, 14, 3, 17);
INSERT INTO versification_data VALUES (NULL, 7, 14, 4, 22);
INSERT INTO versification_data VALUES (NULL, 7, 14, 5, 14);
INSERT INTO versification_data VALUES (NULL, 7, 14, 6, 42);
INSERT INTO versification_data VALUES (NULL, 7, 14, 7, 22);
INSERT INTO versification_data VALUES (NULL, 7, 14, 8, 18);
INSERT INTO versification_data VALUES (NULL, 7, 14, 9, 31);
INSERT INTO versification_data VALUES (NULL, 7, 14, 10, 19);
INSERT INTO versification_data VALUES (NULL, 7, 14, 11, 23);
INSERT INTO versification_data VALUES (NULL, 7, 14, 12, 16);
INSERT INTO versification_data VALUES (NULL, 7, 14, 13, 22);
INSERT INTO versification_data VALUES (NULL, 7, 14, 14, 15);
INSERT INTO versification_data VALUES (NULL, 7, 14, 15, 19);
INSERT INTO versification_data VALUES (NULL, 7, 14, 16, 14);
INSERT INTO versification_data VALUES (NULL, 7, 14, 17, 19);
INSERT INTO versification_data VALUES (NULL, 7, 14, 18, 34);
INSERT INTO versification_data VALUES (NULL, 7, 14, 19, 11);
INSERT INTO versification_data VALUES (NULL, 7, 14, 20, 37);
INSERT INTO versification_data VALUES (NULL, 7, 14, 21, 20);
INSERT INTO versification_data VALUES (NULL, 7, 14, 22, 12);
INSERT INTO versification_data VALUES (NULL, 7, 14, 23, 21);
INSERT INTO versification_data VALUES (NULL, 7, 14, 24, 27);
INSERT INTO versification_data VALUES (NULL, 7, 14, 25, 28);
INSERT INTO versification_data VALUES (NULL, 7, 14, 26, 23);
INSERT INTO versification_data VALUES (NULL, 7, 14, 27, 9);
INSERT INTO versification_data VALUES (NULL, 7, 14, 28, 27);
INSERT INTO versification_data VALUES (NULL, 7, 14, 29, 36);
INSERT INTO versification_data VALUES (NULL, 7, 14, 30, 27);
INSERT INTO versification_data VALUES (NULL, 7, 14, 31, 21);
INSERT INTO versification_data VALUES (NULL, 7, 14, 32, 33);
INSERT INTO versification_data VALUES (NULL, 7, 14, 33, 25);
INSERT INTO versification_data VALUES (NULL, 7, 14, 34, 33);
INSERT INTO versification_data VALUES (NULL, 7, 14, 35, 27);
INSERT INTO versification_data VALUES (NULL, 7, 14, 36, 23);
INSERT INTO versification_data VALUES (NULL, 7, 15, 1, 11);
INSERT INTO versification_data VALUES (NULL, 7, 15, 2, 70);
INSERT INTO versification_data VALUES (NULL, 7, 15, 3, 13);
INSERT INTO versification_data VALUES (NULL, 7, 15, 4, 24);
INSERT INTO versification_data VALUES (NULL, 7, 15, 5, 17);
INSERT INTO versification_data VALUES (NULL, 7, 15, 6, 22);
INSERT INTO versification_data VALUES (NULL, 7, 15, 7, 28);
INSERT INTO versification_data VALUES (NULL, 7, 15, 8, 36);
INSERT INTO versification_data VALUES (NULL, 7, 15, 9, 15);
INSERT INTO versification_data VALUES (NULL, 7, 15, 10, 44);
INSERT INTO versification_data VALUES (NULL, 7, 16, 1, 11);
INSERT INTO versification_data VALUES (NULL, 7, 16, 2, 20);
INSERT INTO versification_data VALUES (NULL, 7, 16, 3, 32);
INSERT INTO versification_data VALUES (NULL, 7, 16, 4, 23);
INSERT INTO versification_data VALUES (NULL, 7, 16, 5, 19);
INSERT INTO versification_data VALUES (NULL, 7, 16, 6, 19);
INSERT INTO versification_data VALUES (NULL, 7, 16, 7, 73);
INSERT INTO versification_data VALUES (NULL, 7, 16, 8, 18);
INSERT INTO versification_data VALUES (NULL, 7, 16, 9, 38);
INSERT INTO versification_data VALUES (NULL, 7, 16, 10, 39);
INSERT INTO versification_data VALUES (NULL, 7, 16, 11, 36);
INSERT INTO versification_data VALUES (NULL, 7, 16, 12, 47);
INSERT INTO versification_data VALUES (NULL, 7, 16, 13, 31);
INSERT INTO versification_data VALUES (NULL, 7, 17, 1, 22);
INSERT INTO versification_data VALUES (NULL, 7, 17, 2, 23);
INSERT INTO versification_data VALUES (NULL, 7, 17, 3, 15);
INSERT INTO versification_data VALUES (NULL, 7, 17, 4, 17);
INSERT INTO versification_data VALUES (NULL, 7, 17, 5, 14);
INSERT INTO versification_data VALUES (NULL, 7, 17, 6, 14);
INSERT INTO versification_data VALUES (NULL, 7, 17, 7, 10);
INSERT INTO versification_data VALUES (NULL, 7, 17, 8, 17);
INSERT INTO versification_data VALUES (NULL, 7, 17, 9, 32);
INSERT INTO versification_data VALUES (NULL, 7, 17, 10, 3);
INSERT INTO versification_data VALUES (NULL, 7, 18, 1, 22);
INSERT INTO versification_data VALUES (NULL, 7, 18, 2, 13);
INSERT INTO versification_data VALUES (NULL, 7, 18, 3, 26);
INSERT INTO versification_data VALUES (NULL, 7, 18, 4, 21);
INSERT INTO versification_data VALUES (NULL, 7, 18, 5, 27);
INSERT INTO versification_data VALUES (NULL, 7, 18, 6, 30);
INSERT INTO versification_data VALUES (NULL, 7, 18, 7, 21);
INSERT INTO versification_data VALUES (NULL, 7, 18, 8, 22);
INSERT INTO versification_data VALUES (NULL, 7, 18, 9, 35);
INSERT INTO versification_data VALUES (NULL, 7, 18, 10, 22);
INSERT INTO versification_data VALUES (NULL, 7, 18, 11, 20);
INSERT INTO versification_data VALUES (NULL, 7, 18, 12, 25);
INSERT INTO versification_data VALUES (NULL, 7, 18, 13, 28);
INSERT INTO versification_data VALUES (NULL, 7, 18, 14, 22);
INSERT INTO versification_data VALUES (NULL, 7, 18, 15, 35);
INSERT INTO versification_data VALUES (NULL, 7, 18, 16, 22);
INSERT INTO versification_data VALUES (NULL, 7, 18, 17, 16);
INSERT INTO versification_data VALUES (NULL, 7, 18, 18, 21);
INSERT INTO versification_data VALUES (NULL, 7, 18, 19, 29);
INSERT INTO versification_data VALUES (NULL, 7, 18, 20, 29);
INSERT INTO versification_data VALUES (NULL, 7, 18, 21, 34);
INSERT INTO versification_data VALUES (NULL, 7, 18, 22, 30);
INSERT INTO versification_data VALUES (NULL, 7, 18, 23, 17);
INSERT INTO versification_data VALUES (NULL, 7, 18, 24, 25);
INSERT INTO versification_data VALUES (NULL, 7, 18, 25, 6);
INSERT INTO versification_data VALUES (NULL, 7, 18, 26, 14);
INSERT INTO versification_data VALUES (NULL, 7, 18, 27, 23);
INSERT INTO versification_data VALUES (NULL, 7, 18, 28, 28);
INSERT INTO versification_data VALUES (NULL, 7, 18, 29, 25);
INSERT INTO versification_data VALUES (NULL, 7, 18, 30, 31);
INSERT INTO versification_data VALUES (NULL, 7, 18, 31, 40);
INSERT INTO versification_data VALUES (NULL, 7, 18, 32, 22);
INSERT INTO versification_data VALUES (NULL, 7, 18, 33, 33);
INSERT INTO versification_data VALUES (NULL, 7, 18, 34, 37);
INSERT INTO versification_data VALUES (NULL, 7, 18, 35, 16);
INSERT INTO versification_data VALUES (NULL, 7, 18, 36, 33);
INSERT INTO versification_data VALUES (NULL, 7, 18, 37, 24);
INSERT INTO versification_data VALUES (NULL, 7, 18, 38, 41);
INSERT INTO versification_data VALUES (NULL, 7, 18, 39, 30);
INSERT INTO versification_data VALUES (NULL, 7, 18, 40, 24);
INSERT INTO versification_data VALUES (NULL, 7, 18, 41, 34);
INSERT INTO versification_data VALUES (NULL, 7, 18, 42, 17);
INSERT INTO versification_data VALUES (NULL, 7, 19, 1, 6);
INSERT INTO versification_data VALUES (NULL, 7, 19, 2, 12);
INSERT INTO versification_data VALUES (NULL, 7, 19, 3, 8);
INSERT INTO versification_data VALUES (NULL, 7, 19, 4, 8);
INSERT INTO versification_data VALUES (NULL, 7, 19, 5, 12);
INSERT INTO versification_data VALUES (NULL, 7, 19, 6, 10);
INSERT INTO versification_data VALUES (NULL, 7, 19, 7, 17);
INSERT INTO versification_data VALUES (NULL, 7, 19, 8, 9);
INSERT INTO versification_data VALUES (NULL, 7, 19, 9, 20);
INSERT INTO versification_data VALUES (NULL, 7, 19, 10, 18);
INSERT INTO versification_data VALUES (NULL, 7, 19, 11, 7);
INSERT INTO versification_data VALUES (NULL, 7, 19, 12, 8);
INSERT INTO versification_data VALUES (NULL, 7, 19, 13, 6);
INSERT INTO versification_data VALUES (NULL, 7, 19, 14, 7);
INSERT INTO versification_data VALUES (NULL, 7, 19, 15, 5);
INSERT INTO versification_data VALUES (NULL, 7, 19, 16, 11);
INSERT INTO versification_data VALUES (NULL, 7, 19, 17, 15);
INSERT INTO versification_data VALUES (NULL, 7, 19, 18, 50);
INSERT INTO versification_data VALUES (NULL, 7, 19, 19, 14);
INSERT INTO versification_data VALUES (NULL, 7, 19, 20, 9);
INSERT INTO versification_data VALUES (NULL, 7, 19, 21, 13);
INSERT INTO versification_data VALUES (NULL, 7, 19, 22, 31);
INSERT INTO versification_data VALUES (NULL, 7, 19, 23, 6);
INSERT INTO versification_data VALUES (NULL, 7, 19, 24, 10);
INSERT INTO versification_data VALUES (NULL, 7, 19, 25, 22);
INSERT INTO versification_data VALUES (NULL, 7, 19, 26, 12);
INSERT INTO versification_data VALUES (NULL, 7, 19, 27, 14);
INSERT INTO versification_data VALUES (NULL, 7, 19, 28, 9);
INSERT INTO versification_data VALUES (NULL, 7, 19, 29, 11);
INSERT INTO versification_data VALUES (NULL, 7, 19, 30, 12);
INSERT INTO versification_data VALUES (NULL, 7, 19, 31, 24);
INSERT INTO versification_data VALUES (NULL, 7, 19, 32, 11);
INSERT INTO versification_data VALUES (NULL, 7, 19, 33, 22);
INSERT INTO versification_data VALUES (NULL, 7, 19, 34, 22);
INSERT INTO versification_data VALUES (NULL, 7, 19, 35, 28);
INSERT INTO versification_data VALUES (NULL, 7, 19, 36, 12);
INSERT INTO versification_data VALUES (NULL, 7, 19, 37, 40);
INSERT INTO versification_data VALUES (NULL, 7, 19, 38, 22);
INSERT INTO versification_data VALUES (NULL, 7, 19, 39, 13);
INSERT INTO versification_data VALUES (NULL, 7, 19, 40, 17);
INSERT INTO versification_data VALUES (NULL, 7, 19, 41, 13);
INSERT INTO versification_data VALUES (NULL, 7, 19, 42, 11);
INSERT INTO versification_data VALUES (NULL, 7, 19, 43, 5);
INSERT INTO versification_data VALUES (NULL, 7, 19, 44, 26);
INSERT INTO versification_data VALUES (NULL, 7, 19, 45, 17);
INSERT INTO versification_data VALUES (NULL, 7, 19, 46, 11);
INSERT INTO versification_data VALUES (NULL, 7, 19, 47, 9);
INSERT INTO versification_data VALUES (NULL, 7, 19, 48, 14);
INSERT INTO versification_data VALUES (NULL, 7, 19, 49, 20);
INSERT INTO versification_data VALUES (NULL, 7, 19, 50, 23);
INSERT INTO versification_data VALUES (NULL, 7, 19, 51, 19);
INSERT INTO versification_data VALUES (NULL, 7, 19, 52, 9);
INSERT INTO versification_data VALUES (NULL, 7, 19, 53, 6);
INSERT INTO versification_data VALUES (NULL, 7, 19, 54, 7);
INSERT INTO versification_data VALUES (NULL, 7, 19, 55, 23);
INSERT INTO versification_data VALUES (NULL, 7, 19, 56, 13);
INSERT INTO versification_data VALUES (NULL, 7, 19, 57, 11);
INSERT INTO versification_data VALUES (NULL, 7, 19, 58, 11);
INSERT INTO versification_data VALUES (NULL, 7, 19, 59, 17);
INSERT INTO versification_data VALUES (NULL, 7, 19, 60, 12);
INSERT INTO versification_data VALUES (NULL, 7, 19, 61, 8);
INSERT INTO versification_data VALUES (NULL, 7, 19, 62, 12);
INSERT INTO versification_data VALUES (NULL, 7, 19, 63, 11);
INSERT INTO versification_data VALUES (NULL, 7, 19, 64, 10);
INSERT INTO versification_data VALUES (NULL, 7, 19, 65, 13);
INSERT INTO versification_data VALUES (NULL, 7, 19, 66, 20);
INSERT INTO versification_data VALUES (NULL, 7, 19, 67, 7);
INSERT INTO versification_data VALUES (NULL, 7, 19, 68, 35);
INSERT INTO versification_data VALUES (NULL, 7, 19, 69, 36);
INSERT INTO versification_data VALUES (NULL, 7, 19, 70, 5);
INSERT INTO versification_data VALUES (NULL, 7, 19, 71, 24);
INSERT INTO versification_data VALUES (NULL, 7, 19, 72, 20);
INSERT INTO versification_data VALUES (NULL, 7, 19, 73, 28);
INSERT INTO versification_data VALUES (NULL, 7, 19, 74, 23);
INSERT INTO versification_data VALUES (NULL, 7, 19, 75, 10);
INSERT INTO versification_data VALUES (NULL, 7, 19, 76, 12);
INSERT INTO versification_data VALUES (NULL, 7, 19, 77, 20);
INSERT INTO versification_data VALUES (NULL, 7, 19, 78, 72);
INSERT INTO versification_data VALUES (NULL, 7, 19, 79, 13);
INSERT INTO versification_data VALUES (NULL, 7, 19, 80, 19);
INSERT INTO versification_data VALUES (NULL, 7, 19, 81, 16);
INSERT INTO versification_data VALUES (NULL, 7, 19, 82, 8);
INSERT INTO versification_data VALUES (NULL, 7, 19, 83, 18);
INSERT INTO versification_data VALUES (NULL, 7, 19, 84, 12);
INSERT INTO versification_data VALUES (NULL, 7, 19, 85, 13);
INSERT INTO versification_data VALUES (NULL, 7, 19, 86, 17);
INSERT INTO versification_data VALUES (NULL, 7, 19, 87, 7);
INSERT INTO versification_data VALUES (NULL, 7, 19, 88, 18);
INSERT INTO versification_data VALUES (NULL, 7, 19, 89, 52);
INSERT INTO versification_data VALUES (NULL, 7, 19, 90, 17);
INSERT INTO versification_data VALUES (NULL, 7, 19, 91, 16);
INSERT INTO versification_data VALUES (NULL, 7, 19, 92, 15);
INSERT INTO versification_data VALUES (NULL, 7, 19, 93, 5);
INSERT INTO versification_data VALUES (NULL, 7, 19, 94, 23);
INSERT INTO versification_data VALUES (NULL, 7, 19, 95, 11);
INSERT INTO versification_data VALUES (NULL, 7, 19, 96, 13);
INSERT INTO versification_data VALUES (NULL, 7, 19, 97, 12);
INSERT INTO versification_data VALUES (NULL, 7, 19, 98, 9);
INSERT INTO versification_data VALUES (NULL, 7, 19, 99, 9);
INSERT INTO versification_data VALUES (NULL, 7, 19, 100, 5);
INSERT INTO versification_data VALUES (NULL, 7, 19, 101, 8);
INSERT INTO versification_data VALUES (NULL, 7, 19, 102, 28);
INSERT INTO versification_data VALUES (NULL, 7, 19, 103, 22);
INSERT INTO versification_data VALUES (NULL, 7, 19, 104, 35);
INSERT INTO versification_data VALUES (NULL, 7, 19, 105, 45);
INSERT INTO versification_data VALUES (NULL, 7, 19, 106, 48);
INSERT INTO versification_data VALUES (NULL, 7, 19, 107, 43);
INSERT INTO versification_data VALUES (NULL, 7, 19, 108, 13);
INSERT INTO versification_data VALUES (NULL, 7, 19, 109, 31);
INSERT INTO versification_data VALUES (NULL, 7, 19, 110, 7);
INSERT INTO versification_data VALUES (NULL, 7, 19, 111, 10);
INSERT INTO versification_data VALUES (NULL, 7, 19, 112, 10);
INSERT INTO versification_data VALUES (NULL, 7, 19, 113, 9);
INSERT INTO versification_data VALUES (NULL, 7, 19, 114, 8);
INSERT INTO versification_data VALUES (NULL, 7, 19, 115, 18);
INSERT INTO versification_data VALUES (NULL, 7, 19, 116, 19);
INSERT INTO versification_data VALUES (NULL, 7, 19, 117, 2);
INSERT INTO versification_data VALUES (NULL, 7, 19, 118, 29);
INSERT INTO versification_data VALUES (NULL, 7, 19, 119, 176);
INSERT INTO versification_data VALUES (NULL, 7, 19, 120, 7);
INSERT INTO versification_data VALUES (NULL, 7, 19, 121, 8);
INSERT INTO versification_data VALUES (NULL, 7, 19, 122, 9);
INSERT INTO versification_data VALUES (NULL, 7, 19, 123, 4);
INSERT INTO versification_data VALUES (NULL, 7, 19, 124, 8);
INSERT INTO versification_data VALUES (NULL, 7, 19, 125, 5);
INSERT INTO versification_data VALUES (NULL, 7, 19, 126, 6);
INSERT INTO versification_data VALUES (NULL, 7, 19, 127, 5);
INSERT INTO versification_data VALUES (NULL, 7, 19, 128, 6);
INSERT INTO versification_data VALUES (NULL, 7, 19, 129, 8);
INSERT INTO versification_data VALUES (NULL, 7, 19, 130, 8);
INSERT INTO versification_data VALUES (NULL, 7, 19, 131, 3);
INSERT INTO versification_data VALUES (NULL, 7, 19, 132, 18);
INSERT INTO versification_data VALUES (NULL, 7, 19, 133, 3);
INSERT INTO versification_data VALUES (NULL, 7, 19, 134, 3);
INSERT INTO versification_data VALUES (NULL, 7, 19, 135, 21);
INSERT INTO versification_data VALUES (NULL, 7, 19, 136, 26);
INSERT INTO versification_data VALUES (NULL, 7, 19, 137, 9);
INSERT INTO versification_data VALUES (NULL, 7, 19, 138, 8);
INSERT INTO versification_data VALUES (NULL, 7, 19, 139, 24);
INSERT INTO versification_data VALUES (NULL, 7, 19, 140, 13);
INSERT INTO versification_data VALUES (NULL, 7, 19, 141, 10);
INSERT INTO versification_data VALUES (NULL, 7, 19, 142, 7);
INSERT INTO versification_data VALUES (NULL, 7, 19, 143, 12);
INSERT INTO versification_data VALUES (NULL, 7, 19, 144, 15);
INSERT INTO versification_data VALUES (NULL, 7, 19, 145, 21);
INSERT INTO versification_data VALUES (NULL, 7, 19, 146, 10);
INSERT INTO versification_data VALUES (NULL, 7, 19, 147, 20);
INSERT INTO versification_data VALUES (NULL, 7, 19, 148, 14);
INSERT INTO versification_data VALUES (NULL, 7, 19, 149, 9);
INSERT INTO versification_data VALUES (NULL, 7, 19, 150, 6);
INSERT INTO versification_data VALUES (NULL, 7, 20, 1, 33);
INSERT INTO versification_data VALUES (NULL, 7, 20, 2, 22);
INSERT INTO versification_data VALUES (NULL, 7, 20, 3, 35);
INSERT INTO versification_data VALUES (NULL, 7, 20, 4, 27);
INSERT INTO versification_data VALUES (NULL, 7, 20, 5, 23);
INSERT INTO versification_data VALUES (NULL, 7, 20, 6, 35);
INSERT INTO versification_data VALUES (NULL, 7, 20, 7, 27);
INSERT INTO versification_data VALUES (NULL, 7, 20, 8, 36);
INSERT INTO versification_data VALUES (NULL, 7, 20, 9, 18);
INSERT INTO versification_data VALUES (NULL, 7, 20, 10, 32);
INSERT INTO versification_data VALUES (NULL, 7, 20, 11, 31);
INSERT INTO versification_data VALUES (NULL, 7, 20, 12, 28);
INSERT INTO versification_data VALUES (NULL, 7, 20, 13, 25);
INSERT INTO versification_data VALUES (NULL, 7, 20, 14, 35);
INSERT INTO versification_data VALUES (NULL, 7, 20, 15, 33);
INSERT INTO versification_data VALUES (NULL, 7, 20, 16, 33);
INSERT INTO versification_data VALUES (NULL, 7, 20, 17, 28);
INSERT INTO versification_data VALUES (NULL, 7, 20, 18, 24);
INSERT INTO versification_data VALUES (NULL, 7, 20, 19, 29);
INSERT INTO versification_data VALUES (NULL, 7, 20, 20, 30);
INSERT INTO versification_data VALUES (NULL, 7, 20, 21, 31);
INSERT INTO versification_data VALUES (NULL, 7, 20, 22, 29);
INSERT INTO versification_data VALUES (NULL, 7, 20, 23, 35);
INSERT INTO versification_data VALUES (NULL, 7, 20, 24, 34);
INSERT INTO versification_data VALUES (NULL, 7, 20, 25, 28);
INSERT INTO versification_data VALUES (NULL, 7, 20, 26, 28);
INSERT INTO versification_data VALUES (NULL, 7, 20, 27, 27);
INSERT INTO versification_data VALUES (NULL, 7, 20, 28, 28);
INSERT INTO versification_data VALUES (NULL, 7, 20, 29, 27);
INSERT INTO versification_data VALUES (NULL, 7, 20, 30, 33);
INSERT INTO versification_data VALUES (NULL, 7, 20, 31, 31);
INSERT INTO versification_data VALUES (NULL, 7, 21, 1, 18);
INSERT INTO versification_data VALUES (NULL, 7, 21, 2, 26);
INSERT INTO versification_data VALUES (NULL, 7, 21, 3, 22);
INSERT INTO versification_data VALUES (NULL, 7, 21, 4, 16);
INSERT INTO versification_data VALUES (NULL, 7, 21, 5, 20);
INSERT INTO versification_data VALUES (NULL, 7, 21, 6, 12);
INSERT INTO versification_data VALUES (NULL, 7, 21, 7, 29);
INSERT INTO versification_data VALUES (NULL, 7, 21, 8, 17);
INSERT INTO versification_data VALUES (NULL, 7, 21, 9, 18);
INSERT INTO versification_data VALUES (NULL, 7, 21, 10, 20);
INSERT INTO versification_data VALUES (NULL, 7, 21, 11, 10);
INSERT INTO versification_data VALUES (NULL, 7, 21, 12, 14);
INSERT INTO versification_data VALUES (NULL, 7, 22, 1, 17);
INSERT INTO versification_data VALUES (NULL, 7, 22, 2, 17);
INSERT INTO versification_data VALUES (NULL, 7, 22, 3, 11);
INSERT INTO versification_data VALUES (NULL, 7, 22, 4, 16);
INSERT INTO versification_data VALUES (NULL, 7, 22, 5, 16);
INSERT INTO versification_data VALUES (NULL, 7, 22, 6, 13);
INSERT INTO versification_data VALUES (NULL, 7, 22, 7, 13);
INSERT INTO versification_data VALUES (NULL, 7, 22, 8, 14);
INSERT INTO versification_data VALUES (NULL, 7, 23, 1, 31);
INSERT INTO versification_data VALUES (NULL, 7, 23, 2, 22);
INSERT INTO versification_data VALUES (NULL, 7, 23, 3, 26);
INSERT INTO versification_data VALUES (NULL, 7, 23, 4, 6);
INSERT INTO versification_data VALUES (NULL, 7, 23, 5, 30);
INSERT INTO versification_data VALUES (NULL, 7, 23, 6, 13);
INSERT INTO versification_data VALUES (NULL, 7, 23, 7, 25);
INSERT INTO versification_data VALUES (NULL, 7, 23, 8, 22);
INSERT INTO versification_data VALUES (NULL, 7, 23, 9, 21);
INSERT INTO versification_data VALUES (NULL, 7, 23, 10, 34);
INSERT INTO versification_data VALUES (NULL, 7, 23, 11, 16);
INSERT INTO versification_data VALUES (NULL, 7, 23, 12, 6);
INSERT INTO versification_data VALUES (NULL, 7, 23, 13, 22);
INSERT INTO versification_data VALUES (NULL, 7, 23, 14, 32);
INSERT INTO versification_data VALUES (NULL, 7, 23, 15, 9);
INSERT INTO versification_data VALUES (NULL, 7, 23, 16, 14);
INSERT INTO versification_data VALUES (NULL, 7, 23, 17, 14);
INSERT INTO versification_data VALUES (NULL, 7, 23, 18, 7);
INSERT INTO versification_data VALUES (NULL, 7, 23, 19, 25);
INSERT INTO versification_data VALUES (NULL, 7, 23, 20, 6);
INSERT INTO versification_data VALUES (NULL, 7, 23, 21, 17);
INSERT INTO versification_data VALUES (NULL, 7, 23, 22, 25);
INSERT INTO versification_data VALUES (NULL, 7, 23, 23, 18);
INSERT INTO versification_data VALUES (NULL, 7, 23, 24, 23);
INSERT INTO versification_data VALUES (NULL, 7, 23, 25, 12);
INSERT INTO versification_data VALUES (NULL, 7, 23, 26, 21);
INSERT INTO versification_data VALUES (NULL, 7, 23, 27, 13);
INSERT INTO versification_data VALUES (NULL, 7, 23, 28, 29);
INSERT INTO versification_data VALUES (NULL, 7, 23, 29, 24);
INSERT INTO versification_data VALUES (NULL, 7, 23, 30, 33);
INSERT INTO versification_data VALUES (NULL, 7, 23, 31, 9);
INSERT INTO versification_data VALUES (NULL, 7, 23, 32, 20);
INSERT INTO versification_data VALUES (NULL, 7, 23, 33, 24);
INSERT INTO versification_data VALUES (NULL, 7, 23, 34, 17);
INSERT INTO versification_data VALUES (NULL, 7, 23, 35, 10);
INSERT INTO versification_data VALUES (NULL, 7, 23, 36, 22);
INSERT INTO versification_data VALUES (NULL, 7, 23, 37, 38);
INSERT INTO versification_data VALUES (NULL, 7, 23, 38, 22);
INSERT INTO versification_data VALUES (NULL, 7, 23, 39, 8);
INSERT INTO versification_data VALUES (NULL, 7, 23, 40, 31);
INSERT INTO versification_data VALUES (NULL, 7, 23, 41, 29);
INSERT INTO versification_data VALUES (NULL, 7, 23, 42, 25);
INSERT INTO versification_data VALUES (NULL, 7, 23, 43, 28);
INSERT INTO versification_data VALUES (NULL, 7, 23, 44, 28);
INSERT INTO versification_data VALUES (NULL, 7, 23, 45, 25);
INSERT INTO versification_data VALUES (NULL, 7, 23, 46, 13);
INSERT INTO versification_data VALUES (NULL, 7, 23, 47, 15);
INSERT INTO versification_data VALUES (NULL, 7, 23, 48, 22);
INSERT INTO versification_data VALUES (NULL, 7, 23, 49, 26);
INSERT INTO versification_data VALUES (NULL, 7, 23, 50, 11);
INSERT INTO versification_data VALUES (NULL, 7, 23, 51, 23);
INSERT INTO versification_data VALUES (NULL, 7, 23, 52, 15);
INSERT INTO versification_data VALUES (NULL, 7, 23, 53, 12);
INSERT INTO versification_data VALUES (NULL, 7, 23, 54, 17);
INSERT INTO versification_data VALUES (NULL, 7, 23, 55, 13);
INSERT INTO versification_data VALUES (NULL, 7, 23, 56, 12);
INSERT INTO versification_data VALUES (NULL, 7, 23, 57, 21);
INSERT INTO versification_data VALUES (NULL, 7, 23, 58, 14);
INSERT INTO versification_data VALUES (NULL, 7, 23, 59, 21);
INSERT INTO versification_data VALUES (NULL, 7, 23, 60, 22);
INSERT INTO versification_data VALUES (NULL, 7, 23, 61, 11);
INSERT INTO versification_data VALUES (NULL, 7, 23, 62, 12);
INSERT INTO versification_data VALUES (NULL, 7, 23, 63, 19);
INSERT INTO versification_data VALUES (NULL, 7, 23, 64, 12);
INSERT INTO versification_data VALUES (NULL, 7, 23, 65, 25);
INSERT INTO versification_data VALUES (NULL, 7, 23, 66, 24);
INSERT INTO versification_data VALUES (NULL, 7, 24, 1, 19);
INSERT INTO versification_data VALUES (NULL, 7, 24, 2, 37);
INSERT INTO versification_data VALUES (NULL, 7, 24, 3, 25);
INSERT INTO versification_data VALUES (NULL, 7, 24, 4, 31);
INSERT INTO versification_data VALUES (NULL, 7, 24, 5, 31);
INSERT INTO versification_data VALUES (NULL, 7, 24, 6, 30);
INSERT INTO versification_data VALUES (NULL, 7, 24, 7, 34);
INSERT INTO versification_data VALUES (NULL, 7, 24, 8, 22);
INSERT INTO versification_data VALUES (NULL, 7, 24, 9, 26);
INSERT INTO versification_data VALUES (NULL, 7, 24, 10, 25);
INSERT INTO versification_data VALUES (NULL, 7, 24, 11, 23);
INSERT INTO versification_data VALUES (NULL, 7, 24, 12, 17);
INSERT INTO versification_data VALUES (NULL, 7, 24, 13, 27);
INSERT INTO versification_data VALUES (NULL, 7, 24, 14, 22);
INSERT INTO versification_data VALUES (NULL, 7, 24, 15, 21);
INSERT INTO versification_data VALUES (NULL, 7, 24, 16, 21);
INSERT INTO versification_data VALUES (NULL, 7, 24, 17, 27);
INSERT INTO versification_data VALUES (NULL, 7, 24, 18, 23);
INSERT INTO versification_data VALUES (NULL, 7, 24, 19, 15);
INSERT INTO versification_data VALUES (NULL, 7, 24, 20, 18);
INSERT INTO versification_data VALUES (NULL, 7, 24, 21, 14);
INSERT INTO versification_data VALUES (NULL, 7, 24, 22, 30);
INSERT INTO versification_data VALUES (NULL, 7, 24, 23, 40);
INSERT INTO versification_data VALUES (NULL, 7, 24, 24, 10);
INSERT INTO versification_data VALUES (NULL, 7, 24, 25, 38);
INSERT INTO versification_data VALUES (NULL, 7, 24, 26, 24);
INSERT INTO versification_data VALUES (NULL, 7, 24, 27, 22);
INSERT INTO versification_data VALUES (NULL, 7, 24, 28, 17);
INSERT INTO versification_data VALUES (NULL, 7, 24, 29, 32);
INSERT INTO versification_data VALUES (NULL, 7, 24, 30, 24);
INSERT INTO versification_data VALUES (NULL, 7, 24, 31, 40);
INSERT INTO versification_data VALUES (NULL, 7, 24, 32, 44);
INSERT INTO versification_data VALUES (NULL, 7, 24, 33, 26);
INSERT INTO versification_data VALUES (NULL, 7, 24, 34, 22);
INSERT INTO versification_data VALUES (NULL, 7, 24, 35, 19);
INSERT INTO versification_data VALUES (NULL, 7, 24, 36, 32);
INSERT INTO versification_data VALUES (NULL, 7, 24, 37, 21);
INSERT INTO versification_data VALUES (NULL, 7, 24, 38, 28);
INSERT INTO versification_data VALUES (NULL, 7, 24, 39, 18);
INSERT INTO versification_data VALUES (NULL, 7, 24, 40, 16);
INSERT INTO versification_data VALUES (NULL, 7, 24, 41, 18);
INSERT INTO versification_data VALUES (NULL, 7, 24, 42, 22);
INSERT INTO versification_data VALUES (NULL, 7, 24, 43, 13);
INSERT INTO versification_data VALUES (NULL, 7, 24, 44, 30);
INSERT INTO versification_data VALUES (NULL, 7, 24, 45, 5);
INSERT INTO versification_data VALUES (NULL, 7, 24, 46, 28);
INSERT INTO versification_data VALUES (NULL, 7, 24, 47, 7);
INSERT INTO versification_data VALUES (NULL, 7, 24, 48, 47);
INSERT INTO versification_data VALUES (NULL, 7, 24, 49, 39);
INSERT INTO versification_data VALUES (NULL, 7, 24, 50, 46);
INSERT INTO versification_data VALUES (NULL, 7, 24, 51, 64);
INSERT INTO versification_data VALUES (NULL, 7, 24, 52, 34);
INSERT INTO versification_data VALUES (NULL, 7, 25, 1, 22);
INSERT INTO versification_data VALUES (NULL, 7, 25, 2, 22);
INSERT INTO versification_data VALUES (NULL, 7, 25, 3, 66);
INSERT INTO versification_data VALUES (NULL, 7, 25, 4, 22);
INSERT INTO versification_data VALUES (NULL, 7, 25, 5, 22);
INSERT INTO versification_data VALUES (NULL, 7, 26, 1, 28);
INSERT INTO versification_data VALUES (NULL, 7, 26, 2, 10);
INSERT INTO versification_data VALUES (NULL, 7, 26, 3, 27);
INSERT INTO versification_data VALUES (NULL, 7, 26, 4, 17);
INSERT INTO versification_data VALUES (NULL, 7, 26, 5, 17);
INSERT INTO versification_data VALUES (NULL, 7, 26, 6, 14);
INSERT INTO versification_data VALUES (NULL, 7, 26, 7, 27);
INSERT INTO versification_data VALUES (NULL, 7, 26, 8, 18);
INSERT INTO versification_data VALUES (NULL, 7, 26, 9, 11);
INSERT INTO versification_data VALUES (NULL, 7, 26, 10, 22);
INSERT INTO versification_data VALUES (NULL, 7, 26, 11, 25);
INSERT INTO versification_data VALUES (NULL, 7, 26, 12, 28);
INSERT INTO versification_data VALUES (NULL, 7, 26, 13, 23);
INSERT INTO versification_data VALUES (NULL, 7, 26, 14, 23);
INSERT INTO versification_data VALUES (NULL, 7, 26, 15, 8);
INSERT INTO versification_data VALUES (NULL, 7, 26, 16, 63);
INSERT INTO versification_data VALUES (NULL, 7, 26, 17, 24);
INSERT INTO versification_data VALUES (NULL, 7, 26, 18, 32);
INSERT INTO versification_data VALUES (NULL, 7, 26, 19, 14);
INSERT INTO versification_data VALUES (NULL, 7, 26, 20, 49);
INSERT INTO versification_data VALUES (NULL, 7, 26, 21, 32);
INSERT INTO versification_data VALUES (NULL, 7, 26, 22, 31);
INSERT INTO versification_data VALUES (NULL, 7, 26, 23, 49);
INSERT INTO versification_data VALUES (NULL, 7, 26, 24, 27);
INSERT INTO versification_data VALUES (NULL, 7, 26, 25, 17);
INSERT INTO versification_data VALUES (NULL, 7, 26, 26, 21);
INSERT INTO versification_data VALUES (NULL, 7, 26, 27, 36);
INSERT INTO versification_data VALUES (NULL, 7, 26, 28, 26);
INSERT INTO versification_data VALUES (NULL, 7, 26, 29, 21);
INSERT INTO versification_data VALUES (NULL, 7, 26, 30, 26);
INSERT INTO versification_data VALUES (NULL, 7, 26, 31, 18);
INSERT INTO versification_data VALUES (NULL, 7, 26, 32, 32);
INSERT INTO versification_data VALUES (NULL, 7, 26, 33, 33);
INSERT INTO versification_data VALUES (NULL, 7, 26, 34, 31);
INSERT INTO versification_data VALUES (NULL, 7, 26, 35, 15);
INSERT INTO versification_data VALUES (NULL, 7, 26, 36, 38);
INSERT INTO versification_data VALUES (NULL, 7, 26, 37, 28);
INSERT INTO versification_data VALUES (NULL, 7, 26, 38, 23);
INSERT INTO versification_data VALUES (NULL, 7, 26, 39, 29);
INSERT INTO versification_data VALUES (NULL, 7, 26, 40, 49);
INSERT INTO versification_data VALUES (NULL, 7, 26, 41, 26);
INSERT INTO versification_data VALUES (NULL, 7, 26, 42, 20);
INSERT INTO versification_data VALUES (NULL, 7, 26, 43, 27);
INSERT INTO versification_data VALUES (NULL, 7, 26, 44, 31);
INSERT INTO versification_data VALUES (NULL, 7, 26, 45, 25);
INSERT INTO versification_data VALUES (NULL, 7, 26, 46, 24);
INSERT INTO versification_data VALUES (NULL, 7, 26, 47, 23);
INSERT INTO versification_data VALUES (NULL, 7, 26, 48, 35);
INSERT INTO versification_data VALUES (NULL, 7, 27, 1, 21);
INSERT INTO versification_data VALUES (NULL, 7, 27, 2, 49);
INSERT INTO versification_data VALUES (NULL, 7, 27, 3, 30);
INSERT INTO versification_data VALUES (NULL, 7, 27, 4, 37);
INSERT INTO versification_data VALUES (NULL, 7, 27, 5, 31);
INSERT INTO versification_data VALUES (NULL, 7, 27, 6, 28);
INSERT INTO versification_data VALUES (NULL, 7, 27, 7, 28);
INSERT INTO versification_data VALUES (NULL, 7, 27, 8, 27);
INSERT INTO versification_data VALUES (NULL, 7, 27, 9, 27);
INSERT INTO versification_data VALUES (NULL, 7, 27, 10, 21);
INSERT INTO versification_data VALUES (NULL, 7, 27, 11, 45);
INSERT INTO versification_data VALUES (NULL, 7, 27, 12, 13);
INSERT INTO versification_data VALUES (NULL, 7, 28, 1, 11);
INSERT INTO versification_data VALUES (NULL, 7, 28, 2, 23);
INSERT INTO versification_data VALUES (NULL, 7, 28, 3, 5);
INSERT INTO versification_data VALUES (NULL, 7, 28, 4, 19);
INSERT INTO versification_data VALUES (NULL, 7, 28, 5, 15);
INSERT INTO versification_data VALUES (NULL, 7, 28, 6, 11);
INSERT INTO versification_data VALUES (NULL, 7, 28, 7, 16);
INSERT INTO versification_data VALUES (NULL, 7, 28, 8, 14);
INSERT INTO versification_data VALUES (NULL, 7, 28, 9, 17);
INSERT INTO versification_data VALUES (NULL, 7, 28, 10, 15);
INSERT INTO versification_data VALUES (NULL, 7, 28, 11, 12);
INSERT INTO versification_data VALUES (NULL, 7, 28, 12, 14);
INSERT INTO versification_data VALUES (NULL, 7, 28, 13, 16);
INSERT INTO versification_data VALUES (NULL, 7, 28, 14, 9);
INSERT INTO versification_data VALUES (NULL, 7, 29, 1, 20);
INSERT INTO versification_data VALUES (NULL, 7, 29, 2, 32);
INSERT INTO versification_data VALUES (NULL, 7, 29, 3, 21);
INSERT INTO versification_data VALUES (NULL, 7, 30, 1, 15);
INSERT INTO versification_data VALUES (NULL, 7, 30, 2, 16);
INSERT INTO versification_data VALUES (NULL, 7, 30, 3, 15);
INSERT INTO versification_data VALUES (NULL, 7, 30, 4, 13);
INSERT INTO versification_data VALUES (NULL, 7, 30, 5, 27);
INSERT INTO versification_data VALUES (NULL, 7, 30, 6, 14);
INSERT INTO versification_data VALUES (NULL, 7, 30, 7, 17);
INSERT INTO versification_data VALUES (NULL, 7, 30, 8, 14);
INSERT INTO versification_data VALUES (NULL, 7, 30, 9, 15);
INSERT INTO versification_data VALUES (NULL, 7, 31, 1, 21);
INSERT INTO versification_data VALUES (NULL, 7, 32, 1, 17);
INSERT INTO versification_data VALUES (NULL, 7, 32, 2, 10);
INSERT INTO versification_data VALUES (NULL, 7, 32, 3, 10);
INSERT INTO versification_data VALUES (NULL, 7, 32, 4, 11);
INSERT INTO versification_data VALUES (NULL, 7, 33, 1, 16);
INSERT INTO versification_data VALUES (NULL, 7, 33, 2, 13);
INSERT INTO versification_data VALUES (NULL, 7, 33, 3, 12);
INSERT INTO versification_data VALUES (NULL, 7, 33, 4, 13);
INSERT INTO versification_data VALUES (NULL, 7, 33, 5, 15);
INSERT INTO versification_data VALUES (NULL, 7, 33, 6, 16);
INSERT INTO versification_data VALUES (NULL, 7, 33, 7, 20);
INSERT INTO versification_data VALUES (NULL, 7, 34, 1, 15);
INSERT INTO versification_data VALUES (NULL, 7, 34, 2, 13);
INSERT INTO versification_data VALUES (NULL, 7, 34, 3, 19);
INSERT INTO versification_data VALUES (NULL, 7, 35, 1, 17);
INSERT INTO versification_data VALUES (NULL, 7, 35, 2, 20);
INSERT INTO versification_data VALUES (NULL, 7, 35, 3, 19);
INSERT INTO versification_data VALUES (NULL, 7, 36, 1, 18);
INSERT INTO versification_data VALUES (NULL, 7, 36, 2, 15);
INSERT INTO versification_data VALUES (NULL, 7, 36, 3, 20);
INSERT INTO versification_data VALUES (NULL, 7, 37, 1, 15);
INSERT INTO versification_data VALUES (NULL, 7, 37, 2, 23);
INSERT INTO versification_data VALUES (NULL, 7, 38, 1, 21);
INSERT INTO versification_data VALUES (NULL, 7, 38, 2, 13);
INSERT INTO versification_data VALUES (NULL, 7, 38, 3, 10);
INSERT INTO versification_data VALUES (NULL, 7, 38, 4, 14);
INSERT INTO versification_data VALUES (NULL, 7, 38, 5, 11);
INSERT INTO versification_data VALUES (NULL, 7, 38, 6, 15);
INSERT INTO versification_data VALUES (NULL, 7, 38, 7, 14);
INSERT INTO versification_data VALUES (NULL, 7, 38, 8, 23);
INSERT INTO versification_data VALUES (NULL, 7, 38, 9, 17);
INSERT INTO versification_data VALUES (NULL, 7, 38, 10, 12);
INSERT INTO versification_data VALUES (NULL, 7, 38, 11, 17);
INSERT INTO versification_data VALUES (NULL, 7, 38, 12, 14);
INSERT INTO versification_data VALUES (NULL, 7, 38, 13, 9);
INSERT INTO versification_data VALUES (NULL, 7, 38, 14, 21);
INSERT INTO versification_data VALUES (NULL, 7, 39, 1, 14);
INSERT INTO versification_data VALUES (NULL, 7, 39, 2, 17);
INSERT INTO versification_data VALUES (NULL, 7, 39, 3, 18);
INSERT INTO versification_data VALUES (NULL, 7, 39, 4, 6);
INSERT INTO versification_data VALUES (NULL, 7, 40, 1, 25);
INSERT INTO versification_data VALUES (NULL, 7, 40, 2, 23);
INSERT INTO versification_data VALUES (NULL, 7, 40, 3, 17);
INSERT INTO versification_data VALUES (NULL, 7, 40, 4, 25);
INSERT INTO versification_data VALUES (NULL, 7, 40, 5, 48);
INSERT INTO versification_data VALUES (NULL, 7, 40, 6, 34);
INSERT INTO versification_data VALUES (NULL, 7, 40, 7, 29);
INSERT INTO versification_data VALUES (NULL, 7, 40, 8, 34);
INSERT INTO versification_data VALUES (NULL, 7, 40, 9, 38);
INSERT INTO versification_data VALUES (NULL, 7, 40, 10, 42);
INSERT INTO versification_data VALUES (NULL, 7, 40, 11, 30);
INSERT INTO versification_data VALUES (NULL, 7, 40, 12, 50);
INSERT INTO versification_data VALUES (NULL, 7, 40, 13, 58);
INSERT INTO versification_data VALUES (NULL, 7, 40, 14, 36);
INSERT INTO versification_data VALUES (NULL, 7, 40, 15, 39);
INSERT INTO versification_data VALUES (NULL, 7, 40, 16, 28);
INSERT INTO versification_data VALUES (NULL, 7, 40, 17, 27);
INSERT INTO versification_data VALUES (NULL, 7, 40, 18, 35);
INSERT INTO versification_data VALUES (NULL, 7, 40, 19, 30);
INSERT INTO versification_data VALUES (NULL, 7, 40, 20, 34);
INSERT INTO versification_data VALUES (NULL, 7, 40, 21, 46);
INSERT INTO versification_data VALUES (NULL, 7, 40, 22, 46);
INSERT INTO versification_data VALUES (NULL, 7, 40, 23, 39);
INSERT INTO versification_data VALUES (NULL, 7, 40, 24, 51);
INSERT INTO versification_data VALUES (NULL, 7, 40, 25, 46);
INSERT INTO versification_data VALUES (NULL, 7, 40, 26, 75);
INSERT INTO versification_data VALUES (NULL, 7, 40, 27, 66);
INSERT INTO versification_data VALUES (NULL, 7, 40, 28, 20);
INSERT INTO versification_data VALUES (NULL, 7, 41, 1, 45);
INSERT INTO versification_data VALUES (NULL, 7, 41, 2, 28);
INSERT INTO versification_data VALUES (NULL, 7, 41, 3, 35);
INSERT INTO versification_data VALUES (NULL, 7, 41, 4, 41);
INSERT INTO versification_data VALUES (NULL, 7, 41, 5, 43);
INSERT INTO versification_data VALUES (NULL, 7, 41, 6, 56);
INSERT INTO versification_data VALUES (NULL, 7, 41, 7, 37);
INSERT INTO versification_data VALUES (NULL, 7, 41, 8, 38);
INSERT INTO versification_data VALUES (NULL, 7, 41, 9, 50);
INSERT INTO versification_data VALUES (NULL, 7, 41, 10, 52);
INSERT INTO versification_data VALUES (NULL, 7, 41, 11, 33);
INSERT INTO versification_data VALUES (NULL, 7, 41, 12, 44);
INSERT INTO versification_data VALUES (NULL, 7, 41, 13, 37);
INSERT INTO versification_data VALUES (NULL, 7, 41, 14, 72);
INSERT INTO versification_data VALUES (NULL, 7, 41, 15, 47);
INSERT INTO versification_data VALUES (NULL, 7, 41, 16, 20);
INSERT INTO versification_data VALUES (NULL, 7, 42, 1, 80);
INSERT INTO versification_data VALUES (NULL, 7, 42, 2, 52);
INSERT INTO versification_data VALUES (NULL, 7, 42, 3, 38);
INSERT INTO versification_data VALUES (NULL, 7, 42, 4, 44);
INSERT INTO versification_data VALUES (NULL, 7, 42, 5, 39);
INSERT INTO versification_data VALUES (NULL, 7, 42, 6, 49);
INSERT INTO versification_data VALUES (NULL, 7, 42, 7, 50);
INSERT INTO versification_data VALUES (NULL, 7, 42, 8, 56);
INSERT INTO versification_data VALUES (NULL, 7, 42, 9, 62);
INSERT INTO versification_data VALUES (NULL, 7, 42, 10, 42);
INSERT INTO versification_data VALUES (NULL, 7, 42, 11, 54);
INSERT INTO versification_data VALUES (NULL, 7, 42, 12, 59);
INSERT INTO versification_data VALUES (NULL, 7, 42, 13, 35);
INSERT INTO versification_data VALUES (NULL, 7, 42, 14, 35);
INSERT INTO versification_data VALUES (NULL, 7, 42, 15, 32);
INSERT INTO versification_data VALUES (NULL, 7, 42, 16, 31);
INSERT INTO versification_data VALUES (NULL, 7, 42, 17, 37);
INSERT INTO versification_data VALUES (NULL, 7, 42, 18, 43);
INSERT INTO versification_data VALUES (NULL, 7, 42, 19, 48);
INSERT INTO versification_data VALUES (NULL, 7, 42, 20, 47);
INSERT INTO versification_data VALUES (NULL, 7, 42, 21, 38);
INSERT INTO versification_data VALUES (NULL, 7, 42, 22, 71);
INSERT INTO versification_data VALUES (NULL, 7, 42, 23, 56);
INSERT INTO versification_data VALUES (NULL, 7, 42, 24, 53);
INSERT INTO versification_data VALUES (NULL, 7, 43, 1, 51);
INSERT INTO versification_data VALUES (NULL, 7, 43, 2, 25);
INSERT INTO versification_data VALUES (NULL, 7, 43, 3, 36);
INSERT INTO versification_data VALUES (NULL, 7, 43, 4, 54);
INSERT INTO versification_data VALUES (NULL, 7, 43, 5, 47);
INSERT INTO versification_data VALUES (NULL, 7, 43, 6, 71);
INSERT INTO versification_data VALUES (NULL, 7, 43, 7, 53);
INSERT INTO versification_data VALUES (NULL, 7, 43, 8, 59);
INSERT INTO versification_data VALUES (NULL, 7, 43, 9, 41);
INSERT INTO versification_data VALUES (NULL, 7, 43, 10, 42);
INSERT INTO versification_data VALUES (NULL, 7, 43, 11, 57);
INSERT INTO versification_data VALUES (NULL, 7, 43, 12, 50);
INSERT INTO versification_data VALUES (NULL, 7, 43, 13, 38);
INSERT INTO versification_data VALUES (NULL, 7, 43, 14, 31);
INSERT INTO versification_data VALUES (NULL, 7, 43, 15, 27);
INSERT INTO versification_data VALUES (NULL, 7, 43, 16, 33);
INSERT INTO versification_data VALUES (NULL, 7, 43, 17, 26);
INSERT INTO versification_data VALUES (NULL, 7, 43, 18, 40);
INSERT INTO versification_data VALUES (NULL, 7, 43, 19, 42);
INSERT INTO versification_data VALUES (NULL, 7, 43, 20, 31);
INSERT INTO versification_data VALUES (NULL, 7, 43, 21, 25);
INSERT INTO versification_data VALUES (NULL, 7, 44, 1, 26);
INSERT INTO versification_data VALUES (NULL, 7, 44, 2, 47);
INSERT INTO versification_data VALUES (NULL, 7, 44, 3, 26);
INSERT INTO versification_data VALUES (NULL, 7, 44, 4, 37);
INSERT INTO versification_data VALUES (NULL, 7, 44, 5, 42);
INSERT INTO versification_data VALUES (NULL, 7, 44, 6, 15);
INSERT INTO versification_data VALUES (NULL, 7, 44, 7, 60);
INSERT INTO versification_data VALUES (NULL, 7, 44, 8, 40);
INSERT INTO versification_data VALUES (NULL, 7, 44, 9, 43);
INSERT INTO versification_data VALUES (NULL, 7, 44, 10, 48);
INSERT INTO versification_data VALUES (NULL, 7, 44, 11, 30);
INSERT INTO versification_data VALUES (NULL, 7, 44, 12, 25);
INSERT INTO versification_data VALUES (NULL, 7, 44, 13, 52);
INSERT INTO versification_data VALUES (NULL, 7, 44, 14, 28);
INSERT INTO versification_data VALUES (NULL, 7, 44, 15, 41);
INSERT INTO versification_data VALUES (NULL, 7, 44, 16, 40);
INSERT INTO versification_data VALUES (NULL, 7, 44, 17, 34);
INSERT INTO versification_data VALUES (NULL, 7, 44, 18, 28);
INSERT INTO versification_data VALUES (NULL, 7, 44, 19, 41);
INSERT INTO versification_data VALUES (NULL, 7, 44, 20, 38);
INSERT INTO versification_data VALUES (NULL, 7, 44, 21, 40);
INSERT INTO versification_data VALUES (NULL, 7, 44, 22, 30);
INSERT INTO versification_data VALUES (NULL, 7, 44, 23, 35);
INSERT INTO versification_data VALUES (NULL, 7, 44, 24, 27);
INSERT INTO versification_data VALUES (NULL, 7, 44, 25, 27);
INSERT INTO versification_data VALUES (NULL, 7, 44, 26, 32);
INSERT INTO versification_data VALUES (NULL, 7, 44, 27, 44);
INSERT INTO versification_data VALUES (NULL, 7, 44, 28, 31);
INSERT INTO versification_data VALUES (NULL, 7, 45, 1, 32);
INSERT INTO versification_data VALUES (NULL, 7, 45, 2, 29);
INSERT INTO versification_data VALUES (NULL, 7, 45, 3, 31);
INSERT INTO versification_data VALUES (NULL, 7, 45, 4, 25);
INSERT INTO versification_data VALUES (NULL, 7, 45, 5, 21);
INSERT INTO versification_data VALUES (NULL, 7, 45, 6, 23);
INSERT INTO versification_data VALUES (NULL, 7, 45, 7, 25);
INSERT INTO versification_data VALUES (NULL, 7, 45, 8, 39);
INSERT INTO versification_data VALUES (NULL, 7, 45, 9, 33);
INSERT INTO versification_data VALUES (NULL, 7, 45, 10, 21);
INSERT INTO versification_data VALUES (NULL, 7, 45, 11, 36);
INSERT INTO versification_data VALUES (NULL, 7, 45, 12, 21);
INSERT INTO versification_data VALUES (NULL, 7, 45, 13, 14);
INSERT INTO versification_data VALUES (NULL, 7, 45, 14, 23);
INSERT INTO versification_data VALUES (NULL, 7, 45, 15, 33);
INSERT INTO versification_data VALUES (NULL, 7, 45, 16, 27);
INSERT INTO versification_data VALUES (NULL, 7, 46, 1, 31);
INSERT INTO versification_data VALUES (NULL, 7, 46, 2, 16);
INSERT INTO versification_data VALUES (NULL, 7, 46, 3, 23);
INSERT INTO versification_data VALUES (NULL, 7, 46, 4, 21);
INSERT INTO versification_data VALUES (NULL, 7, 46, 5, 13);
INSERT INTO versification_data VALUES (NULL, 7, 46, 6, 20);
INSERT INTO versification_data VALUES (NULL, 7, 46, 7, 40);
INSERT INTO versification_data VALUES (NULL, 7, 46, 8, 13);
INSERT INTO versification_data VALUES (NULL, 7, 46, 9, 27);
INSERT INTO versification_data VALUES (NULL, 7, 46, 10, 33);
INSERT INTO versification_data VALUES (NULL, 7, 46, 11, 34);
INSERT INTO versification_data VALUES (NULL, 7, 46, 12, 31);
INSERT INTO versification_data VALUES (NULL, 7, 46, 13, 13);
INSERT INTO versification_data VALUES (NULL, 7, 46, 14, 40);
INSERT INTO versification_data VALUES (NULL, 7, 46, 15, 58);
INSERT INTO versification_data VALUES (NULL, 7, 46, 16, 24);
INSERT INTO versification_data VALUES (NULL, 7, 47, 1, 24);
INSERT INTO versification_data VALUES (NULL, 7, 47, 2, 17);
INSERT INTO versification_data VALUES (NULL, 7, 47, 3, 18);
INSERT INTO versification_data VALUES (NULL, 7, 47, 4, 18);
INSERT INTO versification_data VALUES (NULL, 7, 47, 5, 21);
INSERT INTO versification_data VALUES (NULL, 7, 47, 6, 18);
INSERT INTO versification_data VALUES (NULL, 7, 47, 7, 16);
INSERT INTO versification_data VALUES (NULL, 7, 47, 8, 24);
INSERT INTO versification_data VALUES (NULL, 7, 47, 9, 15);
INSERT INTO versification_data VALUES (NULL, 7, 47, 10, 18);
INSERT INTO versification_data VALUES (NULL, 7, 47, 11, 33);
INSERT INTO versification_data VALUES (NULL, 7, 47, 12, 21);
INSERT INTO versification_data VALUES (NULL, 7, 47, 13, 14);
INSERT INTO versification_data VALUES (NULL, 7, 48, 1, 24);
INSERT INTO versification_data VALUES (NULL, 7, 48, 2, 21);
INSERT INTO versification_data VALUES (NULL, 7, 48, 3, 29);
INSERT INTO versification_data VALUES (NULL, 7, 48, 4, 31);
INSERT INTO versification_data VALUES (NULL, 7, 48, 5, 26);
INSERT INTO versification_data VALUES (NULL, 7, 48, 6, 18);
INSERT INTO versification_data VALUES (NULL, 7, 49, 1, 23);
INSERT INTO versification_data VALUES (NULL, 7, 49, 2, 22);
INSERT INTO versification_data VALUES (NULL, 7, 49, 3, 21);
INSERT INTO versification_data VALUES (NULL, 7, 49, 4, 32);
INSERT INTO versification_data VALUES (NULL, 7, 49, 5, 33);
INSERT INTO versification_data VALUES (NULL, 7, 49, 6, 24);
INSERT INTO versification_data VALUES (NULL, 7, 50, 1, 30);
INSERT INTO versification_data VALUES (NULL, 7, 50, 2, 30);
INSERT INTO versification_data VALUES (NULL, 7, 50, 3, 21);
INSERT INTO versification_data VALUES (NULL, 7, 50, 4, 23);
INSERT INTO versification_data VALUES (NULL, 7, 51, 1, 29);
INSERT INTO versification_data VALUES (NULL, 7, 51, 2, 23);
INSERT INTO versification_data VALUES (NULL, 7, 51, 3, 25);
INSERT INTO versification_data VALUES (NULL, 7, 51, 4, 18);
INSERT INTO versification_data VALUES (NULL, 7, 52, 1, 10);
INSERT INTO versification_data VALUES (NULL, 7, 52, 2, 20);
INSERT INTO versification_data VALUES (NULL, 7, 52, 3, 13);
INSERT INTO versification_data VALUES (NULL, 7, 52, 4, 18);
INSERT INTO versification_data VALUES (NULL, 7, 52, 5, 28);
INSERT INTO versification_data VALUES (NULL, 7, 53, 1, 12);
INSERT INTO versification_data VALUES (NULL, 7, 53, 2, 17);
INSERT INTO versification_data VALUES (NULL, 7, 53, 3, 18);
INSERT INTO versification_data VALUES (NULL, 7, 54, 1, 20);
INSERT INTO versification_data VALUES (NULL, 7, 54, 2, 15);
INSERT INTO versification_data VALUES (NULL, 7, 54, 3, 16);
INSERT INTO versification_data VALUES (NULL, 7, 54, 4, 16);
INSERT INTO versification_data VALUES (NULL, 7, 54, 5, 25);
INSERT INTO versification_data VALUES (NULL, 7, 54, 6, 21);
INSERT INTO versification_data VALUES (NULL, 7, 55, 1, 18);
INSERT INTO versification_data VALUES (NULL, 7, 55, 2, 26);
INSERT INTO versification_data VALUES (NULL, 7, 55, 3, 17);
INSERT INTO versification_data VALUES (NULL, 7, 55, 4, 22);
INSERT INTO versification_data VALUES (NULL, 7, 56, 1, 16);
INSERT INTO versification_data VALUES (NULL, 7, 56, 2, 15);
INSERT INTO versification_data VALUES (NULL, 7, 56, 3, 15);
INSERT INTO versification_data VALUES (NULL, 7, 57, 1, 25);
INSERT INTO versification_data VALUES (NULL, 7, 58, 1, 14);
INSERT INTO versification_data VALUES (NULL, 7, 58, 2, 18);
INSERT INTO versification_data VALUES (NULL, 7, 58, 3, 19);
INSERT INTO versification_data VALUES (NULL, 7, 58, 4, 16);
INSERT INTO versification_data VALUES (NULL, 7, 58, 5, 14);
INSERT INTO versification_data VALUES (NULL, 7, 58, 6, 20);
INSERT INTO versification_data VALUES (NULL, 7, 58, 7, 28);
INSERT INTO versification_data VALUES (NULL, 7, 58, 8, 13);
INSERT INTO versification_data VALUES (NULL, 7, 58, 9, 28);
INSERT INTO versification_data VALUES (NULL, 7, 58, 10, 39);
INSERT INTO versification_data VALUES (NULL, 7, 58, 11, 40);
INSERT INTO versification_data VALUES (NULL, 7, 58, 12, 29);
INSERT INTO versification_data VALUES (NULL, 7, 58, 13, 25);
INSERT INTO versification_data VALUES (NULL, 7, 59, 1, 27);
INSERT INTO versification_data VALUES (NULL, 7, 59, 2, 26);
INSERT INTO versification_data VALUES (NULL, 7, 59, 3, 18);
INSERT INTO versification_data VALUES (NULL, 7, 59, 4, 17);
INSERT INTO versification_data VALUES (NULL, 7, 59, 5, 20);
INSERT INTO versification_data VALUES (NULL, 7, 60, 1, 25);
INSERT INTO versification_data VALUES (NULL, 7, 60, 2, 25);
INSERT INTO versification_data VALUES (NULL, 7, 60, 3, 22);
INSERT INTO versification_data VALUES (NULL, 7, 60, 4, 19);
INSERT INTO versification_data VALUES (NULL, 7, 60, 5, 14);
INSERT INTO versification_data VALUES (NULL, 7, 61, 1, 21);
INSERT INTO versification_data VALUES (NULL, 7, 61, 2, 22);
INSERT INTO versification_data VALUES (NULL, 7, 61, 3, 18);
INSERT INTO versification_data VALUES (NULL, 7, 62, 1, 10);
INSERT INTO versification_data VALUES (NULL, 7, 62, 2, 29);
INSERT INTO versification_data VALUES (NULL, 7, 62, 3, 24);
INSERT INTO versification_data VALUES (NULL, 7, 62, 4, 21);
INSERT INTO versification_data VALUES (NULL, 7, 62, 5, 21);
INSERT INTO versification_data VALUES (NULL, 7, 63, 1, 13);
INSERT INTO versification_data VALUES (NULL, 7, 64, 1, 14);
INSERT INTO versification_data VALUES (NULL, 7, 65, 1, 25);
INSERT INTO versification_data VALUES (NULL, 7, 66, 1, 20);
INSERT INTO versification_data VALUES (NULL, 7, 66, 2, 29);
INSERT INTO versification_data VALUES (NULL, 7, 66, 3, 22);
INSERT INTO versification_data VALUES (NULL, 7, 66, 4, 11);
INSERT INTO versification_data VALUES (NULL, 7, 66, 5, 14);
INSERT INTO versification_data VALUES (NULL, 7, 66, 6, 17);
INSERT INTO versification_data VALUES (NULL, 7, 66, 7, 17);
INSERT INTO versification_data VALUES (NULL, 7, 66, 8, 13);
INSERT INTO versification_data VALUES (NULL, 7, 66, 9, 21);
INSERT INTO versification_data VALUES (NULL, 7, 66, 10, 11);
INSERT INTO versification_data VALUES (NULL, 7, 66, 11, 19);
INSERT INTO versification_data VALUES (NULL, 7, 66, 12, 17);
INSERT INTO versification_data VALUES (NULL, 7, 66, 13, 18);
INSERT INTO versification_data VALUES (NULL, 7, 66, 14, 20);
INSERT INTO versification_data VALUES (NULL, 7, 66, 15, 8);
INSERT INTO versification_data VALUES (NULL, 7, 66, 16, 21);
INSERT INTO versification_data VALUES (NULL, 7, 66, 17, 18);
INSERT INTO versification_data VALUES (NULL, 7, 66, 18, 24);
INSERT INTO versification_data VALUES (NULL, 7, 66, 19, 21);
INSERT INTO versification_data VALUES (NULL, 7, 66, 20, 15);
INSERT INTO versification_data VALUES (NULL, 7, 66, 21, 27);
INSERT INTO versification_data VALUES (NULL, 7, 66, 22, 21);

INSERT INTO versification_names VALUES (8, 'Spanish');

INSERT INTO versification_data VALUES (NULL, 8, 1, 1, 31);
INSERT INTO versification_data VALUES (NULL, 8, 1, 2, 25);
INSERT INTO versification_data VALUES (NULL, 8, 1, 3, 24);
INSERT INTO versification_data VALUES (NULL, 8, 1, 4, 26);
INSERT INTO versification_data VALUES (NULL, 8, 1, 5, 32);
INSERT INTO versification_data VALUES (NULL, 8, 1, 6, 22);
INSERT INTO versification_data VALUES (NULL, 8, 1, 7, 24);
INSERT INTO versification_data VALUES (NULL, 8, 1, 8, 22);
INSERT INTO versification_data VALUES (NULL, 8, 1, 9, 29);
INSERT INTO versification_data VALUES (NULL, 8, 1, 10, 32);
INSERT INTO versification_data VALUES (NULL, 8, 1, 11, 32);
INSERT INTO versification_data VALUES (NULL, 8, 1, 12, 20);
INSERT INTO versification_data VALUES (NULL, 8, 1, 13, 18);
INSERT INTO versification_data VALUES (NULL, 8, 1, 14, 24);
INSERT INTO versification_data VALUES (NULL, 8, 1, 15, 21);
INSERT INTO versification_data VALUES (NULL, 8, 1, 16, 16);
INSERT INTO versification_data VALUES (NULL, 8, 1, 17, 27);
INSERT INTO versification_data VALUES (NULL, 8, 1, 18, 33);
INSERT INTO versification_data VALUES (NULL, 8, 1, 19, 38);
INSERT INTO versification_data VALUES (NULL, 8, 1, 20, 18);
INSERT INTO versification_data VALUES (NULL, 8, 1, 21, 34);
INSERT INTO versification_data VALUES (NULL, 8, 1, 22, 24);
INSERT INTO versification_data VALUES (NULL, 8, 1, 23, 20);
INSERT INTO versification_data VALUES (NULL, 8, 1, 24, 67);
INSERT INTO versification_data VALUES (NULL, 8, 1, 25, 34);
INSERT INTO versification_data VALUES (NULL, 8, 1, 26, 35);
INSERT INTO versification_data VALUES (NULL, 8, 1, 27, 46);
INSERT INTO versification_data VALUES (NULL, 8, 1, 28, 22);
INSERT INTO versification_data VALUES (NULL, 8, 1, 29, 35);
INSERT INTO versification_data VALUES (NULL, 8, 1, 30, 43);
INSERT INTO versification_data VALUES (NULL, 8, 1, 31, 55);
INSERT INTO versification_data VALUES (NULL, 8, 1, 32, 32);
INSERT INTO versification_data VALUES (NULL, 8, 1, 33, 20);
INSERT INTO versification_data VALUES (NULL, 8, 1, 34, 31);
INSERT INTO versification_data VALUES (NULL, 8, 1, 35, 29);
INSERT INTO versification_data VALUES (NULL, 8, 1, 36, 43);
INSERT INTO versification_data VALUES (NULL, 8, 1, 37, 36);
INSERT INTO versification_data VALUES (NULL, 8, 1, 38, 30);
INSERT INTO versification_data VALUES (NULL, 8, 1, 39, 23);
INSERT INTO versification_data VALUES (NULL, 8, 1, 40, 23);
INSERT INTO versification_data VALUES (NULL, 8, 1, 41, 57);
INSERT INTO versification_data VALUES (NULL, 8, 1, 42, 38);
INSERT INTO versification_data VALUES (NULL, 8, 1, 43, 34);
INSERT INTO versification_data VALUES (NULL, 8, 1, 44, 34);
INSERT INTO versification_data VALUES (NULL, 8, 1, 45, 28);
INSERT INTO versification_data VALUES (NULL, 8, 1, 46, 34);
INSERT INTO versification_data VALUES (NULL, 8, 1, 47, 31);
INSERT INTO versification_data VALUES (NULL, 8, 1, 48, 22);
INSERT INTO versification_data VALUES (NULL, 8, 1, 49, 33);
INSERT INTO versification_data VALUES (NULL, 8, 1, 50, 26);
INSERT INTO versification_data VALUES (NULL, 8, 2, 1, 22);
INSERT INTO versification_data VALUES (NULL, 8, 2, 2, 25);
INSERT INTO versification_data VALUES (NULL, 8, 2, 3, 22);
INSERT INTO versification_data VALUES (NULL, 8, 2, 4, 31);
INSERT INTO versification_data VALUES (NULL, 8, 2, 5, 23);
INSERT INTO versification_data VALUES (NULL, 8, 2, 6, 30);
INSERT INTO versification_data VALUES (NULL, 8, 2, 7, 25);
INSERT INTO versification_data VALUES (NULL, 8, 2, 8, 32);
INSERT INTO versification_data VALUES (NULL, 8, 2, 9, 35);
INSERT INTO versification_data VALUES (NULL, 8, 2, 10, 29);
INSERT INTO versification_data VALUES (NULL, 8, 2, 11, 10);
INSERT INTO versification_data VALUES (NULL, 8, 2, 12, 51);
INSERT INTO versification_data VALUES (NULL, 8, 2, 13, 22);
INSERT INTO versification_data VALUES (NULL, 8, 2, 14, 31);
INSERT INTO versification_data VALUES (NULL, 8, 2, 15, 27);
INSERT INTO versification_data VALUES (NULL, 8, 2, 16, 36);
INSERT INTO versification_data VALUES (NULL, 8, 2, 17, 16);
INSERT INTO versification_data VALUES (NULL, 8, 2, 18, 27);
INSERT INTO versification_data VALUES (NULL, 8, 2, 19, 25);
INSERT INTO versification_data VALUES (NULL, 8, 2, 20, 26);
INSERT INTO versification_data VALUES (NULL, 8, 2, 21, 36);
INSERT INTO versification_data VALUES (NULL, 8, 2, 22, 31);
INSERT INTO versification_data VALUES (NULL, 8, 2, 23, 33);
INSERT INTO versification_data VALUES (NULL, 8, 2, 24, 18);
INSERT INTO versification_data VALUES (NULL, 8, 2, 25, 40);
INSERT INTO versification_data VALUES (NULL, 8, 2, 26, 37);
INSERT INTO versification_data VALUES (NULL, 8, 2, 27, 21);
INSERT INTO versification_data VALUES (NULL, 8, 2, 28, 43);
INSERT INTO versification_data VALUES (NULL, 8, 2, 29, 46);
INSERT INTO versification_data VALUES (NULL, 8, 2, 30, 38);
INSERT INTO versification_data VALUES (NULL, 8, 2, 31, 18);
INSERT INTO versification_data VALUES (NULL, 8, 2, 32, 35);
INSERT INTO versification_data VALUES (NULL, 8, 2, 33, 23);
INSERT INTO versification_data VALUES (NULL, 8, 2, 34, 35);
INSERT INTO versification_data VALUES (NULL, 8, 2, 35, 35);
INSERT INTO versification_data VALUES (NULL, 8, 2, 36, 38);
INSERT INTO versification_data VALUES (NULL, 8, 2, 37, 29);
INSERT INTO versification_data VALUES (NULL, 8, 2, 38, 31);
INSERT INTO versification_data VALUES (NULL, 8, 2, 39, 43);
INSERT INTO versification_data VALUES (NULL, 8, 2, 40, 38);
INSERT INTO versification_data VALUES (NULL, 8, 3, 1, 17);
INSERT INTO versification_data VALUES (NULL, 8, 3, 2, 16);
INSERT INTO versification_data VALUES (NULL, 8, 3, 3, 17);
INSERT INTO versification_data VALUES (NULL, 8, 3, 4, 35);
INSERT INTO versification_data VALUES (NULL, 8, 3, 5, 19);
INSERT INTO versification_data VALUES (NULL, 8, 3, 6, 30);
INSERT INTO versification_data VALUES (NULL, 8, 3, 7, 38);
INSERT INTO versification_data VALUES (NULL, 8, 3, 8, 36);
INSERT INTO versification_data VALUES (NULL, 8, 3, 9, 24);
INSERT INTO versification_data VALUES (NULL, 8, 3, 10, 20);
INSERT INTO versification_data VALUES (NULL, 8, 3, 11, 47);
INSERT INTO versification_data VALUES (NULL, 8, 3, 12, 8);
INSERT INTO versification_data VALUES (NULL, 8, 3, 13, 59);
INSERT INTO versification_data VALUES (NULL, 8, 3, 14, 57);
INSERT INTO versification_data VALUES (NULL, 8, 3, 15, 33);
INSERT INTO versification_data VALUES (NULL, 8, 3, 16, 34);
INSERT INTO versification_data VALUES (NULL, 8, 3, 17, 16);
INSERT INTO versification_data VALUES (NULL, 8, 3, 18, 30);
INSERT INTO versification_data VALUES (NULL, 8, 3, 19, 37);
INSERT INTO versification_data VALUES (NULL, 8, 3, 20, 27);
INSERT INTO versification_data VALUES (NULL, 8, 3, 21, 24);
INSERT INTO versification_data VALUES (NULL, 8, 3, 22, 33);
INSERT INTO versification_data VALUES (NULL, 8, 3, 23, 44);
INSERT INTO versification_data VALUES (NULL, 8, 3, 24, 23);
INSERT INTO versification_data VALUES (NULL, 8, 3, 25, 55);
INSERT INTO versification_data VALUES (NULL, 8, 3, 26, 46);
INSERT INTO versification_data VALUES (NULL, 8, 3, 27, 34);
INSERT INTO versification_data VALUES (NULL, 8, 4, 1, 54);
INSERT INTO versification_data VALUES (NULL, 8, 4, 2, 34);
INSERT INTO versification_data VALUES (NULL, 8, 4, 3, 51);
INSERT INTO versification_data VALUES (NULL, 8, 4, 4, 49);
INSERT INTO versification_data VALUES (NULL, 8, 4, 5, 31);
INSERT INTO versification_data VALUES (NULL, 8, 4, 6, 27);
INSERT INTO versification_data VALUES (NULL, 8, 4, 7, 89);
INSERT INTO versification_data VALUES (NULL, 8, 4, 8, 26);
INSERT INTO versification_data VALUES (NULL, 8, 4, 9, 23);
INSERT INTO versification_data VALUES (NULL, 8, 4, 10, 36);
INSERT INTO versification_data VALUES (NULL, 8, 4, 11, 35);
INSERT INTO versification_data VALUES (NULL, 8, 4, 12, 16);
INSERT INTO versification_data VALUES (NULL, 8, 4, 13, 33);
INSERT INTO versification_data VALUES (NULL, 8, 4, 14, 45);
INSERT INTO versification_data VALUES (NULL, 8, 4, 15, 41);
INSERT INTO versification_data VALUES (NULL, 8, 4, 16, 50);
INSERT INTO versification_data VALUES (NULL, 8, 4, 17, 13);
INSERT INTO versification_data VALUES (NULL, 8, 4, 18, 32);
INSERT INTO versification_data VALUES (NULL, 8, 4, 19, 22);
INSERT INTO versification_data VALUES (NULL, 8, 4, 20, 29);
INSERT INTO versification_data VALUES (NULL, 8, 4, 21, 35);
INSERT INTO versification_data VALUES (NULL, 8, 4, 22, 41);
INSERT INTO versification_data VALUES (NULL, 8, 4, 23, 30);
INSERT INTO versification_data VALUES (NULL, 8, 4, 24, 25);
INSERT INTO versification_data VALUES (NULL, 8, 4, 25, 19);
INSERT INTO versification_data VALUES (NULL, 8, 4, 26, 65);
INSERT INTO versification_data VALUES (NULL, 8, 4, 27, 23);
INSERT INTO versification_data VALUES (NULL, 8, 4, 28, 31);
INSERT INTO versification_data VALUES (NULL, 8, 4, 29, 40);
INSERT INTO versification_data VALUES (NULL, 8, 4, 30, 16);
INSERT INTO versification_data VALUES (NULL, 8, 4, 31, 54);
INSERT INTO versification_data VALUES (NULL, 8, 4, 32, 42);
INSERT INTO versification_data VALUES (NULL, 8, 4, 33, 56);
INSERT INTO versification_data VALUES (NULL, 8, 4, 34, 29);
INSERT INTO versification_data VALUES (NULL, 8, 4, 35, 34);
INSERT INTO versification_data VALUES (NULL, 8, 4, 36, 13);
INSERT INTO versification_data VALUES (NULL, 8, 5, 1, 46);
INSERT INTO versification_data VALUES (NULL, 8, 5, 2, 37);
INSERT INTO versification_data VALUES (NULL, 8, 5, 3, 29);
INSERT INTO versification_data VALUES (NULL, 8, 5, 4, 49);
INSERT INTO versification_data VALUES (NULL, 8, 5, 5, 33);
INSERT INTO versification_data VALUES (NULL, 8, 5, 6, 25);
INSERT INTO versification_data VALUES (NULL, 8, 5, 7, 26);
INSERT INTO versification_data VALUES (NULL, 8, 5, 8, 20);
INSERT INTO versification_data VALUES (NULL, 8, 5, 9, 29);
INSERT INTO versification_data VALUES (NULL, 8, 5, 10, 22);
INSERT INTO versification_data VALUES (NULL, 8, 5, 11, 32);
INSERT INTO versification_data VALUES (NULL, 8, 5, 12, 32);
INSERT INTO versification_data VALUES (NULL, 8, 5, 13, 18);
INSERT INTO versification_data VALUES (NULL, 8, 5, 14, 29);
INSERT INTO versification_data VALUES (NULL, 8, 5, 15, 23);
INSERT INTO versification_data VALUES (NULL, 8, 5, 16, 22);
INSERT INTO versification_data VALUES (NULL, 8, 5, 17, 20);
INSERT INTO versification_data VALUES (NULL, 8, 5, 18, 22);
INSERT INTO versification_data VALUES (NULL, 8, 5, 19, 21);
INSERT INTO versification_data VALUES (NULL, 8, 5, 20, 20);
INSERT INTO versification_data VALUES (NULL, 8, 5, 21, 23);
INSERT INTO versification_data VALUES (NULL, 8, 5, 22, 30);
INSERT INTO versification_data VALUES (NULL, 8, 5, 23, 25);
INSERT INTO versification_data VALUES (NULL, 8, 5, 24, 22);
INSERT INTO versification_data VALUES (NULL, 8, 5, 25, 19);
INSERT INTO versification_data VALUES (NULL, 8, 5, 26, 19);
INSERT INTO versification_data VALUES (NULL, 8, 5, 27, 26);
INSERT INTO versification_data VALUES (NULL, 8, 5, 28, 68);
INSERT INTO versification_data VALUES (NULL, 8, 5, 29, 29);
INSERT INTO versification_data VALUES (NULL, 8, 5, 30, 20);
INSERT INTO versification_data VALUES (NULL, 8, 5, 31, 30);
INSERT INTO versification_data VALUES (NULL, 8, 5, 32, 52);
INSERT INTO versification_data VALUES (NULL, 8, 5, 33, 29);
INSERT INTO versification_data VALUES (NULL, 8, 5, 34, 12);
INSERT INTO versification_data VALUES (NULL, 8, 6, 1, 18);
INSERT INTO versification_data VALUES (NULL, 8, 6, 2, 24);
INSERT INTO versification_data VALUES (NULL, 8, 6, 3, 17);
INSERT INTO versification_data VALUES (NULL, 8, 6, 4, 24);
INSERT INTO versification_data VALUES (NULL, 8, 6, 5, 15);
INSERT INTO versification_data VALUES (NULL, 8, 6, 6, 27);
INSERT INTO versification_data VALUES (NULL, 8, 6, 7, 26);
INSERT INTO versification_data VALUES (NULL, 8, 6, 8, 35);
INSERT INTO versification_data VALUES (NULL, 8, 6, 9, 27);
INSERT INTO versification_data VALUES (NULL, 8, 6, 10, 43);
INSERT INTO versification_data VALUES (NULL, 8, 6, 11, 23);
INSERT INTO versification_data VALUES (NULL, 8, 6, 12, 24);
INSERT INTO versification_data VALUES (NULL, 8, 6, 13, 33);
INSERT INTO versification_data VALUES (NULL, 8, 6, 14, 15);
INSERT INTO versification_data VALUES (NULL, 8, 6, 15, 63);
INSERT INTO versification_data VALUES (NULL, 8, 6, 16, 10);
INSERT INTO versification_data VALUES (NULL, 8, 6, 17, 18);
INSERT INTO versification_data VALUES (NULL, 8, 6, 18, 28);
INSERT INTO versification_data VALUES (NULL, 8, 6, 19, 51);
INSERT INTO versification_data VALUES (NULL, 8, 6, 20, 9);
INSERT INTO versification_data VALUES (NULL, 8, 6, 21, 45);
INSERT INTO versification_data VALUES (NULL, 8, 6, 22, 34);
INSERT INTO versification_data VALUES (NULL, 8, 6, 23, 16);
INSERT INTO versification_data VALUES (NULL, 8, 6, 24, 33);
INSERT INTO versification_data VALUES (NULL, 8, 7, 1, 36);
INSERT INTO versification_data VALUES (NULL, 8, 7, 2, 23);
INSERT INTO versification_data VALUES (NULL, 8, 7, 3, 31);
INSERT INTO versification_data VALUES (NULL, 8, 7, 4, 24);
INSERT INTO versification_data VALUES (NULL, 8, 7, 5, 31);
INSERT INTO versification_data VALUES (NULL, 8, 7, 6, 40);
INSERT INTO versification_data VALUES (NULL, 8, 7, 7, 25);
INSERT INTO versification_data VALUES (NULL, 8, 7, 8, 35);
INSERT INTO versification_data VALUES (NULL, 8, 7, 9, 57);
INSERT INTO versification_data VALUES (NULL, 8, 7, 10, 18);
INSERT INTO versification_data VALUES (NULL, 8, 7, 11, 40);
INSERT INTO versification_data VALUES (NULL, 8, 7, 12, 15);
INSERT INTO versification_data VALUES (NULL, 8, 7, 13, 25);
INSERT INTO versification_data VALUES (NULL, 8, 7, 14, 20);
INSERT INTO versification_data VALUES (NULL, 8, 7, 15, 20);
INSERT INTO versification_data VALUES (NULL, 8, 7, 16, 31);
INSERT INTO versification_data VALUES (NULL, 8, 7, 17, 13);
INSERT INTO versification_data VALUES (NULL, 8, 7, 18, 31);
INSERT INTO versification_data VALUES (NULL, 8, 7, 19, 30);
INSERT INTO versification_data VALUES (NULL, 8, 7, 20, 48);
INSERT INTO versification_data VALUES (NULL, 8, 7, 21, 25);
INSERT INTO versification_data VALUES (NULL, 8, 8, 1, 22);
INSERT INTO versification_data VALUES (NULL, 8, 8, 2, 23);
INSERT INTO versification_data VALUES (NULL, 8, 8, 3, 18);
INSERT INTO versification_data VALUES (NULL, 8, 8, 4, 22);
INSERT INTO versification_data VALUES (NULL, 8, 9, 1, 28);
INSERT INTO versification_data VALUES (NULL, 8, 9, 2, 36);
INSERT INTO versification_data VALUES (NULL, 8, 9, 3, 21);
INSERT INTO versification_data VALUES (NULL, 8, 9, 4, 22);
INSERT INTO versification_data VALUES (NULL, 8, 9, 5, 12);
INSERT INTO versification_data VALUES (NULL, 8, 9, 6, 21);
INSERT INTO versification_data VALUES (NULL, 8, 9, 7, 17);
INSERT INTO versification_data VALUES (NULL, 8, 9, 8, 22);
INSERT INTO versification_data VALUES (NULL, 8, 9, 9, 27);
INSERT INTO versification_data VALUES (NULL, 8, 9, 10, 27);
INSERT INTO versification_data VALUES (NULL, 8, 9, 11, 15);
INSERT INTO versification_data VALUES (NULL, 8, 9, 12, 25);
INSERT INTO versification_data VALUES (NULL, 8, 9, 13, 23);
INSERT INTO versification_data VALUES (NULL, 8, 9, 14, 52);
INSERT INTO versification_data VALUES (NULL, 8, 9, 15, 35);
INSERT INTO versification_data VALUES (NULL, 8, 9, 16, 23);
INSERT INTO versification_data VALUES (NULL, 8, 9, 17, 58);
INSERT INTO versification_data VALUES (NULL, 8, 9, 18, 30);
INSERT INTO versification_data VALUES (NULL, 8, 9, 19, 24);
INSERT INTO versification_data VALUES (NULL, 8, 9, 20, 42);
INSERT INTO versification_data VALUES (NULL, 8, 9, 21, 15);
INSERT INTO versification_data VALUES (NULL, 8, 9, 22, 23);
INSERT INTO versification_data VALUES (NULL, 8, 9, 23, 29);
INSERT INTO versification_data VALUES (NULL, 8, 9, 24, 22);
INSERT INTO versification_data VALUES (NULL, 8, 9, 25, 44);
INSERT INTO versification_data VALUES (NULL, 8, 9, 26, 25);
INSERT INTO versification_data VALUES (NULL, 8, 9, 27, 12);
INSERT INTO versification_data VALUES (NULL, 8, 9, 28, 25);
INSERT INTO versification_data VALUES (NULL, 8, 9, 29, 11);
INSERT INTO versification_data VALUES (NULL, 8, 9, 30, 31);
INSERT INTO versification_data VALUES (NULL, 8, 9, 31, 13);
INSERT INTO versification_data VALUES (NULL, 8, 10, 1, 27);
INSERT INTO versification_data VALUES (NULL, 8, 10, 2, 32);
INSERT INTO versification_data VALUES (NULL, 8, 10, 3, 39);
INSERT INTO versification_data VALUES (NULL, 8, 10, 4, 12);
INSERT INTO versification_data VALUES (NULL, 8, 10, 5, 25);
INSERT INTO versification_data VALUES (NULL, 8, 10, 6, 23);
INSERT INTO versification_data VALUES (NULL, 8, 10, 7, 29);
INSERT INTO versification_data VALUES (NULL, 8, 10, 8, 18);
INSERT INTO versification_data VALUES (NULL, 8, 10, 9, 13);
INSERT INTO versification_data VALUES (NULL, 8, 10, 10, 19);
INSERT INTO versification_data VALUES (NULL, 8, 10, 11, 27);
INSERT INTO versification_data VALUES (NULL, 8, 10, 12, 31);
INSERT INTO versification_data VALUES (NULL, 8, 10, 13, 39);
INSERT INTO versification_data VALUES (NULL, 8, 10, 14, 33);
INSERT INTO versification_data VALUES (NULL, 8, 10, 15, 37);
INSERT INTO versification_data VALUES (NULL, 8, 10, 16, 23);
INSERT INTO versification_data VALUES (NULL, 8, 10, 17, 29);
INSERT INTO versification_data VALUES (NULL, 8, 10, 18, 33);
INSERT INTO versification_data VALUES (NULL, 8, 10, 19, 43);
INSERT INTO versification_data VALUES (NULL, 8, 10, 20, 26);
INSERT INTO versification_data VALUES (NULL, 8, 10, 21, 22);
INSERT INTO versification_data VALUES (NULL, 8, 10, 22, 51);
INSERT INTO versification_data VALUES (NULL, 8, 10, 23, 39);
INSERT INTO versification_data VALUES (NULL, 8, 10, 24, 25);
INSERT INTO versification_data VALUES (NULL, 8, 11, 1, 53);
INSERT INTO versification_data VALUES (NULL, 8, 11, 2, 46);
INSERT INTO versification_data VALUES (NULL, 8, 11, 3, 28);
INSERT INTO versification_data VALUES (NULL, 8, 11, 4, 34);
INSERT INTO versification_data VALUES (NULL, 8, 11, 5, 18);
INSERT INTO versification_data VALUES (NULL, 8, 11, 6, 38);
INSERT INTO versification_data VALUES (NULL, 8, 11, 7, 51);
INSERT INTO versification_data VALUES (NULL, 8, 11, 8, 66);
INSERT INTO versification_data VALUES (NULL, 8, 11, 9, 28);
INSERT INTO versification_data VALUES (NULL, 8, 11, 10, 29);
INSERT INTO versification_data VALUES (NULL, 8, 11, 11, 43);
INSERT INTO versification_data VALUES (NULL, 8, 11, 12, 33);
INSERT INTO versification_data VALUES (NULL, 8, 11, 13, 34);
INSERT INTO versification_data VALUES (NULL, 8, 11, 14, 31);
INSERT INTO versification_data VALUES (NULL, 8, 11, 15, 34);
INSERT INTO versification_data VALUES (NULL, 8, 11, 16, 34);
INSERT INTO versification_data VALUES (NULL, 8, 11, 17, 24);
INSERT INTO versification_data VALUES (NULL, 8, 11, 18, 46);
INSERT INTO versification_data VALUES (NULL, 8, 11, 19, 21);
INSERT INTO versification_data VALUES (NULL, 8, 11, 20, 43);
INSERT INTO versification_data VALUES (NULL, 8, 11, 21, 29);
INSERT INTO versification_data VALUES (NULL, 8, 11, 22, 53);
INSERT INTO versification_data VALUES (NULL, 8, 12, 1, 18);
INSERT INTO versification_data VALUES (NULL, 8, 12, 2, 25);
INSERT INTO versification_data VALUES (NULL, 8, 12, 3, 27);
INSERT INTO versification_data VALUES (NULL, 8, 12, 4, 44);
INSERT INTO versification_data VALUES (NULL, 8, 12, 5, 27);
INSERT INTO versification_data VALUES (NULL, 8, 12, 6, 33);
INSERT INTO versification_data VALUES (NULL, 8, 12, 7, 20);
INSERT INTO versification_data VALUES (NULL, 8, 12, 8, 29);
INSERT INTO versification_data VALUES (NULL, 8, 12, 9, 37);
INSERT INTO versification_data VALUES (NULL, 8, 12, 10, 36);
INSERT INTO versification_data VALUES (NULL, 8, 12, 11, 21);
INSERT INTO versification_data VALUES (NULL, 8, 12, 12, 21);
INSERT INTO versification_data VALUES (NULL, 8, 12, 13, 25);
INSERT INTO versification_data VALUES (NULL, 8, 12, 14, 29);
INSERT INTO versification_data VALUES (NULL, 8, 12, 15, 38);
INSERT INTO versification_data VALUES (NULL, 8, 12, 16, 20);
INSERT INTO versification_data VALUES (NULL, 8, 12, 17, 41);
INSERT INTO versification_data VALUES (NULL, 8, 12, 18, 37);
INSERT INTO versification_data VALUES (NULL, 8, 12, 19, 37);
INSERT INTO versification_data VALUES (NULL, 8, 12, 20, 21);
INSERT INTO versification_data VALUES (NULL, 8, 12, 21, 26);
INSERT INTO versification_data VALUES (NULL, 8, 12, 22, 20);
INSERT INTO versification_data VALUES (NULL, 8, 12, 23, 37);
INSERT INTO versification_data VALUES (NULL, 8, 12, 24, 20);
INSERT INTO versification_data VALUES (NULL, 8, 12, 25, 30);
INSERT INTO versification_data VALUES (NULL, 8, 13, 1, 54);
INSERT INTO versification_data VALUES (NULL, 8, 13, 2, 55);
INSERT INTO versification_data VALUES (NULL, 8, 13, 3, 24);
INSERT INTO versification_data VALUES (NULL, 8, 13, 4, 43);
INSERT INTO versification_data VALUES (NULL, 8, 13, 5, 26);
INSERT INTO versification_data VALUES (NULL, 8, 13, 6, 81);
INSERT INTO versification_data VALUES (NULL, 8, 13, 7, 40);
INSERT INTO versification_data VALUES (NULL, 8, 13, 8, 40);
INSERT INTO versification_data VALUES (NULL, 8, 13, 9, 44);
INSERT INTO versification_data VALUES (NULL, 8, 13, 10, 14);
INSERT INTO versification_data VALUES (NULL, 8, 13, 11, 47);
INSERT INTO versification_data VALUES (NULL, 8, 13, 12, 40);
INSERT INTO versification_data VALUES (NULL, 8, 13, 13, 14);
INSERT INTO versification_data VALUES (NULL, 8, 13, 14, 17);
INSERT INTO versification_data VALUES (NULL, 8, 13, 15, 29);
INSERT INTO versification_data VALUES (NULL, 8, 13, 16, 43);
INSERT INTO versification_data VALUES (NULL, 8, 13, 17, 27);
INSERT INTO versification_data VALUES (NULL, 8, 13, 18, 17);
INSERT INTO versification_data VALUES (NULL, 8, 13, 19, 19);
INSERT INTO versification_data VALUES (NULL, 8, 13, 20, 8);
INSERT INTO versification_data VALUES (NULL, 8, 13, 21, 30);
INSERT INTO versification_data VALUES (NULL, 8, 13, 22, 19);
INSERT INTO versification_data VALUES (NULL, 8, 13, 23, 32);
INSERT INTO versification_data VALUES (NULL, 8, 13, 24, 31);
INSERT INTO versification_data VALUES (NULL, 8, 13, 25, 31);
INSERT INTO versification_data VALUES (NULL, 8, 13, 26, 32);
INSERT INTO versification_data VALUES (NULL, 8, 13, 27, 34);
INSERT INTO versification_data VALUES (NULL, 8, 13, 28, 21);
INSERT INTO versification_data VALUES (NULL, 8, 13, 29, 30);
INSERT INTO versification_data VALUES (NULL, 8, 14, 1, 17);
INSERT INTO versification_data VALUES (NULL, 8, 14, 2, 18);
INSERT INTO versification_data VALUES (NULL, 8, 14, 3, 17);
INSERT INTO versification_data VALUES (NULL, 8, 14, 4, 22);
INSERT INTO versification_data VALUES (NULL, 8, 14, 5, 14);
INSERT INTO versification_data VALUES (NULL, 8, 14, 6, 42);
INSERT INTO versification_data VALUES (NULL, 8, 14, 7, 22);
INSERT INTO versification_data VALUES (NULL, 8, 14, 8, 18);
INSERT INTO versification_data VALUES (NULL, 8, 14, 9, 31);
INSERT INTO versification_data VALUES (NULL, 8, 14, 10, 19);
INSERT INTO versification_data VALUES (NULL, 8, 14, 11, 23);
INSERT INTO versification_data VALUES (NULL, 8, 14, 12, 17);
INSERT INTO versification_data VALUES (NULL, 8, 14, 13, 22);
INSERT INTO versification_data VALUES (NULL, 8, 14, 14, 15);
INSERT INTO versification_data VALUES (NULL, 8, 14, 15, 19);
INSERT INTO versification_data VALUES (NULL, 8, 14, 16, 14);
INSERT INTO versification_data VALUES (NULL, 8, 14, 17, 19);
INSERT INTO versification_data VALUES (NULL, 8, 14, 18, 34);
INSERT INTO versification_data VALUES (NULL, 8, 14, 19, 11);
INSERT INTO versification_data VALUES (NULL, 8, 14, 20, 37);
INSERT INTO versification_data VALUES (NULL, 8, 14, 21, 20);
INSERT INTO versification_data VALUES (NULL, 8, 14, 22, 12);
INSERT INTO versification_data VALUES (NULL, 8, 14, 23, 21);
INSERT INTO versification_data VALUES (NULL, 8, 14, 24, 27);
INSERT INTO versification_data VALUES (NULL, 8, 14, 25, 28);
INSERT INTO versification_data VALUES (NULL, 8, 14, 26, 23);
INSERT INTO versification_data VALUES (NULL, 8, 14, 27, 9);
INSERT INTO versification_data VALUES (NULL, 8, 14, 28, 27);
INSERT INTO versification_data VALUES (NULL, 8, 14, 29, 36);
INSERT INTO versification_data VALUES (NULL, 8, 14, 30, 27);
INSERT INTO versification_data VALUES (NULL, 8, 14, 31, 21);
INSERT INTO versification_data VALUES (NULL, 8, 14, 32, 33);
INSERT INTO versification_data VALUES (NULL, 8, 14, 33, 25);
INSERT INTO versification_data VALUES (NULL, 8, 14, 34, 33);
INSERT INTO versification_data VALUES (NULL, 8, 14, 35, 27);
INSERT INTO versification_data VALUES (NULL, 8, 14, 36, 23);
INSERT INTO versification_data VALUES (NULL, 8, 15, 1, 11);
INSERT INTO versification_data VALUES (NULL, 8, 15, 2, 70);
INSERT INTO versification_data VALUES (NULL, 8, 15, 3, 13);
INSERT INTO versification_data VALUES (NULL, 8, 15, 4, 24);
INSERT INTO versification_data VALUES (NULL, 8, 15, 5, 17);
INSERT INTO versification_data VALUES (NULL, 8, 15, 6, 22);
INSERT INTO versification_data VALUES (NULL, 8, 15, 7, 28);
INSERT INTO versification_data VALUES (NULL, 8, 15, 8, 36);
INSERT INTO versification_data VALUES (NULL, 8, 15, 9, 15);
INSERT INTO versification_data VALUES (NULL, 8, 15, 10, 44);
INSERT INTO versification_data VALUES (NULL, 8, 16, 1, 11);
INSERT INTO versification_data VALUES (NULL, 8, 16, 2, 20);
INSERT INTO versification_data VALUES (NULL, 8, 16, 3, 32);
INSERT INTO versification_data VALUES (NULL, 8, 16, 4, 23);
INSERT INTO versification_data VALUES (NULL, 8, 16, 5, 19);
INSERT INTO versification_data VALUES (NULL, 8, 16, 6, 19);
INSERT INTO versification_data VALUES (NULL, 8, 16, 7, 73);
INSERT INTO versification_data VALUES (NULL, 8, 16, 8, 18);
INSERT INTO versification_data VALUES (NULL, 8, 16, 9, 38);
INSERT INTO versification_data VALUES (NULL, 8, 16, 10, 39);
INSERT INTO versification_data VALUES (NULL, 8, 16, 11, 36);
INSERT INTO versification_data VALUES (NULL, 8, 16, 12, 47);
INSERT INTO versification_data VALUES (NULL, 8, 16, 13, 31);
INSERT INTO versification_data VALUES (NULL, 8, 17, 1, 22);
INSERT INTO versification_data VALUES (NULL, 8, 17, 2, 23);
INSERT INTO versification_data VALUES (NULL, 8, 17, 3, 15);
INSERT INTO versification_data VALUES (NULL, 8, 17, 4, 17);
INSERT INTO versification_data VALUES (NULL, 8, 17, 5, 14);
INSERT INTO versification_data VALUES (NULL, 8, 17, 6, 14);
INSERT INTO versification_data VALUES (NULL, 8, 17, 7, 10);
INSERT INTO versification_data VALUES (NULL, 8, 17, 8, 17);
INSERT INTO versification_data VALUES (NULL, 8, 17, 9, 32);
INSERT INTO versification_data VALUES (NULL, 8, 17, 10, 3);
INSERT INTO versification_data VALUES (NULL, 8, 18, 1, 22);
INSERT INTO versification_data VALUES (NULL, 8, 18, 2, 13);
INSERT INTO versification_data VALUES (NULL, 8, 18, 3, 26);
INSERT INTO versification_data VALUES (NULL, 8, 18, 4, 21);
INSERT INTO versification_data VALUES (NULL, 8, 18, 5, 27);
INSERT INTO versification_data VALUES (NULL, 8, 18, 6, 30);
INSERT INTO versification_data VALUES (NULL, 8, 18, 7, 21);
INSERT INTO versification_data VALUES (NULL, 8, 18, 8, 22);
INSERT INTO versification_data VALUES (NULL, 8, 18, 9, 35);
INSERT INTO versification_data VALUES (NULL, 8, 18, 10, 22);
INSERT INTO versification_data VALUES (NULL, 8, 18, 11, 20);
INSERT INTO versification_data VALUES (NULL, 8, 18, 12, 25);
INSERT INTO versification_data VALUES (NULL, 8, 18, 13, 28);
INSERT INTO versification_data VALUES (NULL, 8, 18, 14, 22);
INSERT INTO versification_data VALUES (NULL, 8, 18, 15, 35);
INSERT INTO versification_data VALUES (NULL, 8, 18, 16, 22);
INSERT INTO versification_data VALUES (NULL, 8, 18, 17, 16);
INSERT INTO versification_data VALUES (NULL, 8, 18, 18, 21);
INSERT INTO versification_data VALUES (NULL, 8, 18, 19, 29);
INSERT INTO versification_data VALUES (NULL, 8, 18, 20, 29);
INSERT INTO versification_data VALUES (NULL, 8, 18, 21, 34);
INSERT INTO versification_data VALUES (NULL, 8, 18, 22, 30);
INSERT INTO versification_data VALUES (NULL, 8, 18, 23, 17);
INSERT INTO versification_data VALUES (NULL, 8, 18, 24, 25);
INSERT INTO versification_data VALUES (NULL, 8, 18, 25, 6);
INSERT INTO versification_data VALUES (NULL, 8, 18, 26, 14);
INSERT INTO versification_data VALUES (NULL, 8, 18, 27, 23);
INSERT INTO versification_data VALUES (NULL, 8, 18, 28, 28);
INSERT INTO versification_data VALUES (NULL, 8, 18, 29, 25);
INSERT INTO versification_data VALUES (NULL, 8, 18, 30, 31);
INSERT INTO versification_data VALUES (NULL, 8, 18, 31, 40);
INSERT INTO versification_data VALUES (NULL, 8, 18, 32, 22);
INSERT INTO versification_data VALUES (NULL, 8, 18, 33, 33);
INSERT INTO versification_data VALUES (NULL, 8, 18, 34, 37);
INSERT INTO versification_data VALUES (NULL, 8, 18, 35, 16);
INSERT INTO versification_data VALUES (NULL, 8, 18, 36, 33);
INSERT INTO versification_data VALUES (NULL, 8, 18, 37, 24);
INSERT INTO versification_data VALUES (NULL, 8, 18, 38, 41);
INSERT INTO versification_data VALUES (NULL, 8, 18, 39, 30);
INSERT INTO versification_data VALUES (NULL, 8, 18, 40, 24);
INSERT INTO versification_data VALUES (NULL, 8, 18, 41, 34);
INSERT INTO versification_data VALUES (NULL, 8, 18, 42, 17);
INSERT INTO versification_data VALUES (NULL, 8, 19, 1, 6);
INSERT INTO versification_data VALUES (NULL, 8, 19, 2, 12);
INSERT INTO versification_data VALUES (NULL, 8, 19, 3, 8);
INSERT INTO versification_data VALUES (NULL, 8, 19, 4, 8);
INSERT INTO versification_data VALUES (NULL, 8, 19, 5, 12);
INSERT INTO versification_data VALUES (NULL, 8, 19, 6, 10);
INSERT INTO versification_data VALUES (NULL, 8, 19, 7, 17);
INSERT INTO versification_data VALUES (NULL, 8, 19, 8, 9);
INSERT INTO versification_data VALUES (NULL, 8, 19, 9, 20);
INSERT INTO versification_data VALUES (NULL, 8, 19, 10, 18);
INSERT INTO versification_data VALUES (NULL, 8, 19, 11, 7);
INSERT INTO versification_data VALUES (NULL, 8, 19, 12, 8);
INSERT INTO versification_data VALUES (NULL, 8, 19, 13, 6);
INSERT INTO versification_data VALUES (NULL, 8, 19, 14, 7);
INSERT INTO versification_data VALUES (NULL, 8, 19, 15, 5);
INSERT INTO versification_data VALUES (NULL, 8, 19, 16, 11);
INSERT INTO versification_data VALUES (NULL, 8, 19, 17, 15);
INSERT INTO versification_data VALUES (NULL, 8, 19, 18, 50);
INSERT INTO versification_data VALUES (NULL, 8, 19, 19, 14);
INSERT INTO versification_data VALUES (NULL, 8, 19, 20, 9);
INSERT INTO versification_data VALUES (NULL, 8, 19, 21, 13);
INSERT INTO versification_data VALUES (NULL, 8, 19, 22, 31);
INSERT INTO versification_data VALUES (NULL, 8, 19, 23, 6);
INSERT INTO versification_data VALUES (NULL, 8, 19, 24, 10);
INSERT INTO versification_data VALUES (NULL, 8, 19, 25, 22);
INSERT INTO versification_data VALUES (NULL, 8, 19, 26, 12);
INSERT INTO versification_data VALUES (NULL, 8, 19, 27, 14);
INSERT INTO versification_data VALUES (NULL, 8, 19, 28, 9);
INSERT INTO versification_data VALUES (NULL, 8, 19, 29, 11);
INSERT INTO versification_data VALUES (NULL, 8, 19, 30, 12);
INSERT INTO versification_data VALUES (NULL, 8, 19, 31, 24);
INSERT INTO versification_data VALUES (NULL, 8, 19, 32, 11);
INSERT INTO versification_data VALUES (NULL, 8, 19, 33, 22);
INSERT INTO versification_data VALUES (NULL, 8, 19, 34, 22);
INSERT INTO versification_data VALUES (NULL, 8, 19, 35, 28);
INSERT INTO versification_data VALUES (NULL, 8, 19, 36, 12);
INSERT INTO versification_data VALUES (NULL, 8, 19, 37, 40);
INSERT INTO versification_data VALUES (NULL, 8, 19, 38, 22);
INSERT INTO versification_data VALUES (NULL, 8, 19, 39, 13);
INSERT INTO versification_data VALUES (NULL, 8, 19, 40, 17);
INSERT INTO versification_data VALUES (NULL, 8, 19, 41, 13);
INSERT INTO versification_data VALUES (NULL, 8, 19, 42, 11);
INSERT INTO versification_data VALUES (NULL, 8, 19, 43, 5);
INSERT INTO versification_data VALUES (NULL, 8, 19, 44, 26);
INSERT INTO versification_data VALUES (NULL, 8, 19, 45, 17);
INSERT INTO versification_data VALUES (NULL, 8, 19, 46, 11);
INSERT INTO versification_data VALUES (NULL, 8, 19, 47, 10);
INSERT INTO versification_data VALUES (NULL, 8, 19, 48, 14);
INSERT INTO versification_data VALUES (NULL, 8, 19, 49, 20);
INSERT INTO versification_data VALUES (NULL, 8, 19, 50, 23);
INSERT INTO versification_data VALUES (NULL, 8, 19, 51, 19);
INSERT INTO versification_data VALUES (NULL, 8, 19, 52, 9);
INSERT INTO versification_data VALUES (NULL, 8, 19, 53, 6);
INSERT INTO versification_data VALUES (NULL, 8, 19, 54, 7);
INSERT INTO versification_data VALUES (NULL, 8, 19, 55, 23);
INSERT INTO versification_data VALUES (NULL, 8, 19, 56, 13);
INSERT INTO versification_data VALUES (NULL, 8, 19, 57, 11);
INSERT INTO versification_data VALUES (NULL, 8, 19, 58, 11);
INSERT INTO versification_data VALUES (NULL, 8, 19, 59, 17);
INSERT INTO versification_data VALUES (NULL, 8, 19, 60, 12);
INSERT INTO versification_data VALUES (NULL, 8, 19, 61, 8);
INSERT INTO versification_data VALUES (NULL, 8, 19, 62, 12);
INSERT INTO versification_data VALUES (NULL, 8, 19, 63, 11);
INSERT INTO versification_data VALUES (NULL, 8, 19, 64, 10);
INSERT INTO versification_data VALUES (NULL, 8, 19, 65, 13);
INSERT INTO versification_data VALUES (NULL, 8, 19, 66, 20);
INSERT INTO versification_data VALUES (NULL, 8, 19, 67, 7);
INSERT INTO versification_data VALUES (NULL, 8, 19, 68, 35);
INSERT INTO versification_data VALUES (NULL, 8, 19, 69, 36);
INSERT INTO versification_data VALUES (NULL, 8, 19, 70, 5);
INSERT INTO versification_data VALUES (NULL, 8, 19, 71, 24);
INSERT INTO versification_data VALUES (NULL, 8, 19, 72, 20);
INSERT INTO versification_data VALUES (NULL, 8, 19, 73, 28);
INSERT INTO versification_data VALUES (NULL, 8, 19, 74, 23);
INSERT INTO versification_data VALUES (NULL, 8, 19, 75, 10);
INSERT INTO versification_data VALUES (NULL, 8, 19, 76, 12);
INSERT INTO versification_data VALUES (NULL, 8, 19, 77, 20);
INSERT INTO versification_data VALUES (NULL, 8, 19, 78, 72);
INSERT INTO versification_data VALUES (NULL, 8, 19, 79, 13);
INSERT INTO versification_data VALUES (NULL, 8, 19, 80, 19);
INSERT INTO versification_data VALUES (NULL, 8, 19, 81, 16);
INSERT INTO versification_data VALUES (NULL, 8, 19, 82, 8);
INSERT INTO versification_data VALUES (NULL, 8, 19, 83, 18);
INSERT INTO versification_data VALUES (NULL, 8, 19, 84, 12);
INSERT INTO versification_data VALUES (NULL, 8, 19, 85, 13);
INSERT INTO versification_data VALUES (NULL, 8, 19, 86, 17);
INSERT INTO versification_data VALUES (NULL, 8, 19, 87, 7);
INSERT INTO versification_data VALUES (NULL, 8, 19, 88, 18);
INSERT INTO versification_data VALUES (NULL, 8, 19, 89, 52);
INSERT INTO versification_data VALUES (NULL, 8, 19, 90, 17);
INSERT INTO versification_data VALUES (NULL, 8, 19, 91, 16);
INSERT INTO versification_data VALUES (NULL, 8, 19, 92, 15);
INSERT INTO versification_data VALUES (NULL, 8, 19, 93, 5);
INSERT INTO versification_data VALUES (NULL, 8, 19, 94, 23);
INSERT INTO versification_data VALUES (NULL, 8, 19, 95, 11);
INSERT INTO versification_data VALUES (NULL, 8, 19, 96, 13);
INSERT INTO versification_data VALUES (NULL, 8, 19, 97, 12);
INSERT INTO versification_data VALUES (NULL, 8, 19, 98, 9);
INSERT INTO versification_data VALUES (NULL, 8, 19, 99, 9);
INSERT INTO versification_data VALUES (NULL, 8, 19, 100, 5);
INSERT INTO versification_data VALUES (NULL, 8, 19, 101, 8);
INSERT INTO versification_data VALUES (NULL, 8, 19, 102, 28);
INSERT INTO versification_data VALUES (NULL, 8, 19, 103, 22);
INSERT INTO versification_data VALUES (NULL, 8, 19, 104, 35);
INSERT INTO versification_data VALUES (NULL, 8, 19, 105, 45);
INSERT INTO versification_data VALUES (NULL, 8, 19, 106, 48);
INSERT INTO versification_data VALUES (NULL, 8, 19, 107, 43);
INSERT INTO versification_data VALUES (NULL, 8, 19, 108, 13);
INSERT INTO versification_data VALUES (NULL, 8, 19, 109, 31);
INSERT INTO versification_data VALUES (NULL, 8, 19, 110, 7);
INSERT INTO versification_data VALUES (NULL, 8, 19, 111, 10);
INSERT INTO versification_data VALUES (NULL, 8, 19, 112, 10);
INSERT INTO versification_data VALUES (NULL, 8, 19, 113, 9);
INSERT INTO versification_data VALUES (NULL, 8, 19, 114, 8);
INSERT INTO versification_data VALUES (NULL, 8, 19, 115, 18);
INSERT INTO versification_data VALUES (NULL, 8, 19, 116, 19);
INSERT INTO versification_data VALUES (NULL, 8, 19, 117, 2);
INSERT INTO versification_data VALUES (NULL, 8, 19, 118, 29);
INSERT INTO versification_data VALUES (NULL, 8, 19, 119, 176);
INSERT INTO versification_data VALUES (NULL, 8, 19, 120, 7);
INSERT INTO versification_data VALUES (NULL, 8, 19, 121, 8);
INSERT INTO versification_data VALUES (NULL, 8, 19, 122, 9);
INSERT INTO versification_data VALUES (NULL, 8, 19, 123, 4);
INSERT INTO versification_data VALUES (NULL, 8, 19, 124, 8);
INSERT INTO versification_data VALUES (NULL, 8, 19, 125, 5);
INSERT INTO versification_data VALUES (NULL, 8, 19, 126, 6);
INSERT INTO versification_data VALUES (NULL, 8, 19, 127, 5);
INSERT INTO versification_data VALUES (NULL, 8, 19, 128, 6);
INSERT INTO versification_data VALUES (NULL, 8, 19, 129, 8);
INSERT INTO versification_data VALUES (NULL, 8, 19, 130, 8);
INSERT INTO versification_data VALUES (NULL, 8, 19, 131, 3);
INSERT INTO versification_data VALUES (NULL, 8, 19, 132, 18);
INSERT INTO versification_data VALUES (NULL, 8, 19, 133, 3);
INSERT INTO versification_data VALUES (NULL, 8, 19, 134, 3);
INSERT INTO versification_data VALUES (NULL, 8, 19, 135, 21);
INSERT INTO versification_data VALUES (NULL, 8, 19, 136, 26);
INSERT INTO versification_data VALUES (NULL, 8, 19, 137, 9);
INSERT INTO versification_data VALUES (NULL, 8, 19, 138, 8);
INSERT INTO versification_data VALUES (NULL, 8, 19, 139, 24);
INSERT INTO versification_data VALUES (NULL, 8, 19, 140, 13);
INSERT INTO versification_data VALUES (NULL, 8, 19, 141, 10);
INSERT INTO versification_data VALUES (NULL, 8, 19, 142, 7);
INSERT INTO versification_data VALUES (NULL, 8, 19, 143, 12);
INSERT INTO versification_data VALUES (NULL, 8, 19, 144, 15);
INSERT INTO versification_data VALUES (NULL, 8, 19, 145, 21);
INSERT INTO versification_data VALUES (NULL, 8, 19, 146, 10);
INSERT INTO versification_data VALUES (NULL, 8, 19, 147, 20);
INSERT INTO versification_data VALUES (NULL, 8, 19, 148, 14);
INSERT INTO versification_data VALUES (NULL, 8, 19, 149, 9);
INSERT INTO versification_data VALUES (NULL, 8, 19, 150, 6);
INSERT INTO versification_data VALUES (NULL, 8, 20, 1, 33);
INSERT INTO versification_data VALUES (NULL, 8, 20, 2, 22);
INSERT INTO versification_data VALUES (NULL, 8, 20, 3, 35);
INSERT INTO versification_data VALUES (NULL, 8, 20, 4, 27);
INSERT INTO versification_data VALUES (NULL, 8, 20, 5, 23);
INSERT INTO versification_data VALUES (NULL, 8, 20, 6, 35);
INSERT INTO versification_data VALUES (NULL, 8, 20, 7, 27);
INSERT INTO versification_data VALUES (NULL, 8, 20, 8, 36);
INSERT INTO versification_data VALUES (NULL, 8, 20, 9, 18);
INSERT INTO versification_data VALUES (NULL, 8, 20, 10, 32);
INSERT INTO versification_data VALUES (NULL, 8, 20, 11, 31);
INSERT INTO versification_data VALUES (NULL, 8, 20, 12, 28);
INSERT INTO versification_data VALUES (NULL, 8, 20, 13, 25);
INSERT INTO versification_data VALUES (NULL, 8, 20, 14, 35);
INSERT INTO versification_data VALUES (NULL, 8, 20, 15, 33);
INSERT INTO versification_data VALUES (NULL, 8, 20, 16, 33);
INSERT INTO versification_data VALUES (NULL, 8, 20, 17, 28);
INSERT INTO versification_data VALUES (NULL, 8, 20, 18, 24);
INSERT INTO versification_data VALUES (NULL, 8, 20, 19, 29);
INSERT INTO versification_data VALUES (NULL, 8, 20, 20, 30);
INSERT INTO versification_data VALUES (NULL, 8, 20, 21, 31);
INSERT INTO versification_data VALUES (NULL, 8, 20, 22, 29);
INSERT INTO versification_data VALUES (NULL, 8, 20, 23, 35);
INSERT INTO versification_data VALUES (NULL, 8, 20, 24, 34);
INSERT INTO versification_data VALUES (NULL, 8, 20, 25, 28);
INSERT INTO versification_data VALUES (NULL, 8, 20, 26, 28);
INSERT INTO versification_data VALUES (NULL, 8, 20, 27, 27);
INSERT INTO versification_data VALUES (NULL, 8, 20, 28, 28);
INSERT INTO versification_data VALUES (NULL, 8, 20, 29, 27);
INSERT INTO versification_data VALUES (NULL, 8, 20, 30, 33);
INSERT INTO versification_data VALUES (NULL, 8, 20, 31, 31);
INSERT INTO versification_data VALUES (NULL, 8, 21, 1, 18);
INSERT INTO versification_data VALUES (NULL, 8, 21, 2, 26);
INSERT INTO versification_data VALUES (NULL, 8, 21, 3, 22);
INSERT INTO versification_data VALUES (NULL, 8, 21, 4, 16);
INSERT INTO versification_data VALUES (NULL, 8, 21, 5, 20);
INSERT INTO versification_data VALUES (NULL, 8, 21, 6, 12);
INSERT INTO versification_data VALUES (NULL, 8, 21, 7, 29);
INSERT INTO versification_data VALUES (NULL, 8, 21, 8, 17);
INSERT INTO versification_data VALUES (NULL, 8, 21, 9, 18);
INSERT INTO versification_data VALUES (NULL, 8, 21, 10, 20);
INSERT INTO versification_data VALUES (NULL, 8, 21, 11, 10);
INSERT INTO versification_data VALUES (NULL, 8, 21, 12, 14);
INSERT INTO versification_data VALUES (NULL, 8, 22, 1, 17);
INSERT INTO versification_data VALUES (NULL, 8, 22, 2, 17);
INSERT INTO versification_data VALUES (NULL, 8, 22, 3, 11);
INSERT INTO versification_data VALUES (NULL, 8, 22, 4, 16);
INSERT INTO versification_data VALUES (NULL, 8, 22, 5, 16);
INSERT INTO versification_data VALUES (NULL, 8, 22, 6, 13);
INSERT INTO versification_data VALUES (NULL, 8, 22, 7, 13);
INSERT INTO versification_data VALUES (NULL, 8, 22, 8, 14);
INSERT INTO versification_data VALUES (NULL, 8, 23, 1, 31);
INSERT INTO versification_data VALUES (NULL, 8, 23, 2, 22);
INSERT INTO versification_data VALUES (NULL, 8, 23, 3, 26);
INSERT INTO versification_data VALUES (NULL, 8, 23, 4, 6);
INSERT INTO versification_data VALUES (NULL, 8, 23, 5, 30);
INSERT INTO versification_data VALUES (NULL, 8, 23, 6, 13);
INSERT INTO versification_data VALUES (NULL, 8, 23, 7, 25);
INSERT INTO versification_data VALUES (NULL, 8, 23, 8, 22);
INSERT INTO versification_data VALUES (NULL, 8, 23, 9, 21);
INSERT INTO versification_data VALUES (NULL, 8, 23, 10, 34);
INSERT INTO versification_data VALUES (NULL, 8, 23, 11, 16);
INSERT INTO versification_data VALUES (NULL, 8, 23, 12, 6);
INSERT INTO versification_data VALUES (NULL, 8, 23, 13, 22);
INSERT INTO versification_data VALUES (NULL, 8, 23, 14, 32);
INSERT INTO versification_data VALUES (NULL, 8, 23, 15, 9);
INSERT INTO versification_data VALUES (NULL, 8, 23, 16, 14);
INSERT INTO versification_data VALUES (NULL, 8, 23, 17, 14);
INSERT INTO versification_data VALUES (NULL, 8, 23, 18, 7);
INSERT INTO versification_data VALUES (NULL, 8, 23, 19, 25);
INSERT INTO versification_data VALUES (NULL, 8, 23, 20, 6);
INSERT INTO versification_data VALUES (NULL, 8, 23, 21, 17);
INSERT INTO versification_data VALUES (NULL, 8, 23, 22, 25);
INSERT INTO versification_data VALUES (NULL, 8, 23, 23, 18);
INSERT INTO versification_data VALUES (NULL, 8, 23, 24, 23);
INSERT INTO versification_data VALUES (NULL, 8, 23, 25, 12);
INSERT INTO versification_data VALUES (NULL, 8, 23, 26, 21);
INSERT INTO versification_data VALUES (NULL, 8, 23, 27, 13);
INSERT INTO versification_data VALUES (NULL, 8, 23, 28, 29);
INSERT INTO versification_data VALUES (NULL, 8, 23, 29, 24);
INSERT INTO versification_data VALUES (NULL, 8, 23, 30, 33);
INSERT INTO versification_data VALUES (NULL, 8, 23, 31, 9);
INSERT INTO versification_data VALUES (NULL, 8, 23, 32, 20);
INSERT INTO versification_data VALUES (NULL, 8, 23, 33, 24);
INSERT INTO versification_data VALUES (NULL, 8, 23, 34, 17);
INSERT INTO versification_data VALUES (NULL, 8, 23, 35, 10);
INSERT INTO versification_data VALUES (NULL, 8, 23, 36, 22);
INSERT INTO versification_data VALUES (NULL, 8, 23, 37, 38);
INSERT INTO versification_data VALUES (NULL, 8, 23, 38, 22);
INSERT INTO versification_data VALUES (NULL, 8, 23, 39, 8);
INSERT INTO versification_data VALUES (NULL, 8, 23, 40, 31);
INSERT INTO versification_data VALUES (NULL, 8, 23, 41, 29);
INSERT INTO versification_data VALUES (NULL, 8, 23, 42, 25);
INSERT INTO versification_data VALUES (NULL, 8, 23, 43, 28);
INSERT INTO versification_data VALUES (NULL, 8, 23, 44, 28);
INSERT INTO versification_data VALUES (NULL, 8, 23, 45, 25);
INSERT INTO versification_data VALUES (NULL, 8, 23, 46, 13);
INSERT INTO versification_data VALUES (NULL, 8, 23, 47, 15);
INSERT INTO versification_data VALUES (NULL, 8, 23, 48, 22);
INSERT INTO versification_data VALUES (NULL, 8, 23, 49, 26);
INSERT INTO versification_data VALUES (NULL, 8, 23, 50, 11);
INSERT INTO versification_data VALUES (NULL, 8, 23, 51, 23);
INSERT INTO versification_data VALUES (NULL, 8, 23, 52, 15);
INSERT INTO versification_data VALUES (NULL, 8, 23, 53, 12);
INSERT INTO versification_data VALUES (NULL, 8, 23, 54, 17);
INSERT INTO versification_data VALUES (NULL, 8, 23, 55, 13);
INSERT INTO versification_data VALUES (NULL, 8, 23, 56, 12);
INSERT INTO versification_data VALUES (NULL, 8, 23, 57, 21);
INSERT INTO versification_data VALUES (NULL, 8, 23, 58, 14);
INSERT INTO versification_data VALUES (NULL, 8, 23, 59, 21);
INSERT INTO versification_data VALUES (NULL, 8, 23, 60, 22);
INSERT INTO versification_data VALUES (NULL, 8, 23, 61, 11);
INSERT INTO versification_data VALUES (NULL, 8, 23, 62, 12);
INSERT INTO versification_data VALUES (NULL, 8, 23, 63, 19);
INSERT INTO versification_data VALUES (NULL, 8, 23, 64, 12);
INSERT INTO versification_data VALUES (NULL, 8, 23, 65, 25);
INSERT INTO versification_data VALUES (NULL, 8, 23, 66, 24);
INSERT INTO versification_data VALUES (NULL, 8, 24, 1, 19);
INSERT INTO versification_data VALUES (NULL, 8, 24, 2, 37);
INSERT INTO versification_data VALUES (NULL, 8, 24, 3, 25);
INSERT INTO versification_data VALUES (NULL, 8, 24, 4, 31);
INSERT INTO versification_data VALUES (NULL, 8, 24, 5, 31);
INSERT INTO versification_data VALUES (NULL, 8, 24, 6, 30);
INSERT INTO versification_data VALUES (NULL, 8, 24, 7, 34);
INSERT INTO versification_data VALUES (NULL, 8, 24, 8, 22);
INSERT INTO versification_data VALUES (NULL, 8, 24, 9, 26);
INSERT INTO versification_data VALUES (NULL, 8, 24, 10, 25);
INSERT INTO versification_data VALUES (NULL, 8, 24, 11, 23);
INSERT INTO versification_data VALUES (NULL, 8, 24, 12, 17);
INSERT INTO versification_data VALUES (NULL, 8, 24, 13, 27);
INSERT INTO versification_data VALUES (NULL, 8, 24, 14, 22);
INSERT INTO versification_data VALUES (NULL, 8, 24, 15, 21);
INSERT INTO versification_data VALUES (NULL, 8, 24, 16, 21);
INSERT INTO versification_data VALUES (NULL, 8, 24, 17, 27);
INSERT INTO versification_data VALUES (NULL, 8, 24, 18, 23);
INSERT INTO versification_data VALUES (NULL, 8, 24, 19, 15);
INSERT INTO versification_data VALUES (NULL, 8, 24, 20, 18);
INSERT INTO versification_data VALUES (NULL, 8, 24, 21, 14);
INSERT INTO versification_data VALUES (NULL, 8, 24, 22, 30);
INSERT INTO versification_data VALUES (NULL, 8, 24, 23, 40);
INSERT INTO versification_data VALUES (NULL, 8, 24, 24, 10);
INSERT INTO versification_data VALUES (NULL, 8, 24, 25, 38);
INSERT INTO versification_data VALUES (NULL, 8, 24, 26, 24);
INSERT INTO versification_data VALUES (NULL, 8, 24, 27, 22);
INSERT INTO versification_data VALUES (NULL, 8, 24, 28, 17);
INSERT INTO versification_data VALUES (NULL, 8, 24, 29, 32);
INSERT INTO versification_data VALUES (NULL, 8, 24, 30, 24);
INSERT INTO versification_data VALUES (NULL, 8, 24, 31, 40);
INSERT INTO versification_data VALUES (NULL, 8, 24, 32, 44);
INSERT INTO versification_data VALUES (NULL, 8, 24, 33, 26);
INSERT INTO versification_data VALUES (NULL, 8, 24, 34, 22);
INSERT INTO versification_data VALUES (NULL, 8, 24, 35, 19);
INSERT INTO versification_data VALUES (NULL, 8, 24, 36, 32);
INSERT INTO versification_data VALUES (NULL, 8, 24, 37, 21);
INSERT INTO versification_data VALUES (NULL, 8, 24, 38, 28);
INSERT INTO versification_data VALUES (NULL, 8, 24, 39, 18);
INSERT INTO versification_data VALUES (NULL, 8, 24, 40, 16);
INSERT INTO versification_data VALUES (NULL, 8, 24, 41, 18);
INSERT INTO versification_data VALUES (NULL, 8, 24, 42, 22);
INSERT INTO versification_data VALUES (NULL, 8, 24, 43, 13);
INSERT INTO versification_data VALUES (NULL, 8, 24, 44, 30);
INSERT INTO versification_data VALUES (NULL, 8, 24, 45, 5);
INSERT INTO versification_data VALUES (NULL, 8, 24, 46, 28);
INSERT INTO versification_data VALUES (NULL, 8, 24, 47, 7);
INSERT INTO versification_data VALUES (NULL, 8, 24, 48, 47);
INSERT INTO versification_data VALUES (NULL, 8, 24, 49, 39);
INSERT INTO versification_data VALUES (NULL, 8, 24, 50, 46);
INSERT INTO versification_data VALUES (NULL, 8, 24, 51, 64);
INSERT INTO versification_data VALUES (NULL, 8, 24, 52, 34);
INSERT INTO versification_data VALUES (NULL, 8, 25, 1, 22);
INSERT INTO versification_data VALUES (NULL, 8, 25, 2, 22);
INSERT INTO versification_data VALUES (NULL, 8, 25, 3, 66);
INSERT INTO versification_data VALUES (NULL, 8, 25, 4, 22);
INSERT INTO versification_data VALUES (NULL, 8, 25, 5, 22);
INSERT INTO versification_data VALUES (NULL, 8, 26, 1, 28);
INSERT INTO versification_data VALUES (NULL, 8, 26, 2, 10);
INSERT INTO versification_data VALUES (NULL, 8, 26, 3, 27);
INSERT INTO versification_data VALUES (NULL, 8, 26, 4, 17);
INSERT INTO versification_data VALUES (NULL, 8, 26, 5, 17);
INSERT INTO versification_data VALUES (NULL, 8, 26, 6, 14);
INSERT INTO versification_data VALUES (NULL, 8, 26, 7, 27);
INSERT INTO versification_data VALUES (NULL, 8, 26, 8, 18);
INSERT INTO versification_data VALUES (NULL, 8, 26, 9, 11);
INSERT INTO versification_data VALUES (NULL, 8, 26, 10, 22);
INSERT INTO versification_data VALUES (NULL, 8, 26, 11, 25);
INSERT INTO versification_data VALUES (NULL, 8, 26, 12, 28);
INSERT INTO versification_data VALUES (NULL, 8, 26, 13, 23);
INSERT INTO versification_data VALUES (NULL, 8, 26, 14, 23);
INSERT INTO versification_data VALUES (NULL, 8, 26, 15, 8);
INSERT INTO versification_data VALUES (NULL, 8, 26, 16, 63);
INSERT INTO versification_data VALUES (NULL, 8, 26, 17, 24);
INSERT INTO versification_data VALUES (NULL, 8, 26, 18, 32);
INSERT INTO versification_data VALUES (NULL, 8, 26, 19, 14);
INSERT INTO versification_data VALUES (NULL, 8, 26, 20, 49);
INSERT INTO versification_data VALUES (NULL, 8, 26, 21, 32);
INSERT INTO versification_data VALUES (NULL, 8, 26, 22, 31);
INSERT INTO versification_data VALUES (NULL, 8, 26, 23, 49);
INSERT INTO versification_data VALUES (NULL, 8, 26, 24, 27);
INSERT INTO versification_data VALUES (NULL, 8, 26, 25, 17);
INSERT INTO versification_data VALUES (NULL, 8, 26, 26, 21);
INSERT INTO versification_data VALUES (NULL, 8, 26, 27, 36);
INSERT INTO versification_data VALUES (NULL, 8, 26, 28, 26);
INSERT INTO versification_data VALUES (NULL, 8, 26, 29, 21);
INSERT INTO versification_data VALUES (NULL, 8, 26, 30, 26);
INSERT INTO versification_data VALUES (NULL, 8, 26, 31, 18);
INSERT INTO versification_data VALUES (NULL, 8, 26, 32, 32);
INSERT INTO versification_data VALUES (NULL, 8, 26, 33, 33);
INSERT INTO versification_data VALUES (NULL, 8, 26, 34, 31);
INSERT INTO versification_data VALUES (NULL, 8, 26, 35, 15);
INSERT INTO versification_data VALUES (NULL, 8, 26, 36, 38);
INSERT INTO versification_data VALUES (NULL, 8, 26, 37, 28);
INSERT INTO versification_data VALUES (NULL, 8, 26, 38, 23);
INSERT INTO versification_data VALUES (NULL, 8, 26, 39, 29);
INSERT INTO versification_data VALUES (NULL, 8, 26, 40, 49);
INSERT INTO versification_data VALUES (NULL, 8, 26, 41, 26);
INSERT INTO versification_data VALUES (NULL, 8, 26, 42, 20);
INSERT INTO versification_data VALUES (NULL, 8, 26, 43, 27);
INSERT INTO versification_data VALUES (NULL, 8, 26, 44, 31);
INSERT INTO versification_data VALUES (NULL, 8, 26, 45, 25);
INSERT INTO versification_data VALUES (NULL, 8, 26, 46, 24);
INSERT INTO versification_data VALUES (NULL, 8, 26, 47, 23);
INSERT INTO versification_data VALUES (NULL, 8, 26, 48, 35);
INSERT INTO versification_data VALUES (NULL, 8, 27, 1, 21);
INSERT INTO versification_data VALUES (NULL, 8, 27, 2, 49);
INSERT INTO versification_data VALUES (NULL, 8, 27, 3, 30);
INSERT INTO versification_data VALUES (NULL, 8, 27, 4, 37);
INSERT INTO versification_data VALUES (NULL, 8, 27, 5, 31);
INSERT INTO versification_data VALUES (NULL, 8, 27, 6, 28);
INSERT INTO versification_data VALUES (NULL, 8, 27, 7, 28);
INSERT INTO versification_data VALUES (NULL, 8, 27, 8, 27);
INSERT INTO versification_data VALUES (NULL, 8, 27, 9, 27);
INSERT INTO versification_data VALUES (NULL, 8, 27, 10, 21);
INSERT INTO versification_data VALUES (NULL, 8, 27, 11, 45);
INSERT INTO versification_data VALUES (NULL, 8, 27, 12, 13);
INSERT INTO versification_data VALUES (NULL, 8, 28, 1, 11);
INSERT INTO versification_data VALUES (NULL, 8, 28, 2, 23);
INSERT INTO versification_data VALUES (NULL, 8, 28, 3, 5);
INSERT INTO versification_data VALUES (NULL, 8, 28, 4, 19);
INSERT INTO versification_data VALUES (NULL, 8, 28, 5, 15);
INSERT INTO versification_data VALUES (NULL, 8, 28, 6, 11);
INSERT INTO versification_data VALUES (NULL, 8, 28, 7, 16);
INSERT INTO versification_data VALUES (NULL, 8, 28, 8, 14);
INSERT INTO versification_data VALUES (NULL, 8, 28, 9, 17);
INSERT INTO versification_data VALUES (NULL, 8, 28, 10, 15);
INSERT INTO versification_data VALUES (NULL, 8, 28, 11, 12);
INSERT INTO versification_data VALUES (NULL, 8, 28, 12, 14);
INSERT INTO versification_data VALUES (NULL, 8, 28, 13, 16);
INSERT INTO versification_data VALUES (NULL, 8, 28, 14, 9);
INSERT INTO versification_data VALUES (NULL, 8, 29, 1, 20);
INSERT INTO versification_data VALUES (NULL, 8, 29, 2, 32);
INSERT INTO versification_data VALUES (NULL, 8, 29, 3, 21);
INSERT INTO versification_data VALUES (NULL, 8, 30, 1, 15);
INSERT INTO versification_data VALUES (NULL, 8, 30, 2, 16);
INSERT INTO versification_data VALUES (NULL, 8, 30, 3, 15);
INSERT INTO versification_data VALUES (NULL, 8, 30, 4, 13);
INSERT INTO versification_data VALUES (NULL, 8, 30, 5, 27);
INSERT INTO versification_data VALUES (NULL, 8, 30, 6, 14);
INSERT INTO versification_data VALUES (NULL, 8, 30, 7, 17);
INSERT INTO versification_data VALUES (NULL, 8, 30, 8, 14);
INSERT INTO versification_data VALUES (NULL, 8, 30, 9, 15);
INSERT INTO versification_data VALUES (NULL, 8, 31, 1, 21);
INSERT INTO versification_data VALUES (NULL, 8, 32, 1, 17);
INSERT INTO versification_data VALUES (NULL, 8, 32, 2, 10);
INSERT INTO versification_data VALUES (NULL, 8, 32, 3, 10);
INSERT INTO versification_data VALUES (NULL, 8, 32, 4, 11);
INSERT INTO versification_data VALUES (NULL, 8, 33, 1, 16);
INSERT INTO versification_data VALUES (NULL, 8, 33, 2, 13);
INSERT INTO versification_data VALUES (NULL, 8, 33, 3, 12);
INSERT INTO versification_data VALUES (NULL, 8, 33, 4, 13);
INSERT INTO versification_data VALUES (NULL, 8, 33, 5, 15);
INSERT INTO versification_data VALUES (NULL, 8, 33, 6, 16);
INSERT INTO versification_data VALUES (NULL, 8, 33, 7, 20);
INSERT INTO versification_data VALUES (NULL, 8, 34, 1, 15);
INSERT INTO versification_data VALUES (NULL, 8, 34, 2, 13);
INSERT INTO versification_data VALUES (NULL, 8, 34, 3, 19);
INSERT INTO versification_data VALUES (NULL, 8, 35, 1, 17);
INSERT INTO versification_data VALUES (NULL, 8, 35, 2, 20);
INSERT INTO versification_data VALUES (NULL, 8, 35, 3, 19);
INSERT INTO versification_data VALUES (NULL, 8, 36, 1, 18);
INSERT INTO versification_data VALUES (NULL, 8, 36, 2, 15);
INSERT INTO versification_data VALUES (NULL, 8, 36, 3, 20);
INSERT INTO versification_data VALUES (NULL, 8, 37, 1, 15);
INSERT INTO versification_data VALUES (NULL, 8, 37, 2, 23);
INSERT INTO versification_data VALUES (NULL, 8, 38, 1, 21);
INSERT INTO versification_data VALUES (NULL, 8, 38, 2, 13);
INSERT INTO versification_data VALUES (NULL, 8, 38, 3, 10);
INSERT INTO versification_data VALUES (NULL, 8, 38, 4, 14);
INSERT INTO versification_data VALUES (NULL, 8, 38, 5, 11);
INSERT INTO versification_data VALUES (NULL, 8, 38, 6, 15);
INSERT INTO versification_data VALUES (NULL, 8, 38, 7, 14);
INSERT INTO versification_data VALUES (NULL, 8, 38, 8, 23);
INSERT INTO versification_data VALUES (NULL, 8, 38, 9, 17);
INSERT INTO versification_data VALUES (NULL, 8, 38, 10, 12);
INSERT INTO versification_data VALUES (NULL, 8, 38, 11, 17);
INSERT INTO versification_data VALUES (NULL, 8, 38, 12, 14);
INSERT INTO versification_data VALUES (NULL, 8, 38, 13, 9);
INSERT INTO versification_data VALUES (NULL, 8, 38, 14, 21);
INSERT INTO versification_data VALUES (NULL, 8, 39, 1, 14);
INSERT INTO versification_data VALUES (NULL, 8, 39, 2, 17);
INSERT INTO versification_data VALUES (NULL, 8, 39, 3, 18);
INSERT INTO versification_data VALUES (NULL, 8, 39, 4, 6);
INSERT INTO versification_data VALUES (NULL, 8, 40, 1, 25);
INSERT INTO versification_data VALUES (NULL, 8, 40, 2, 23);
INSERT INTO versification_data VALUES (NULL, 8, 40, 3, 17);
INSERT INTO versification_data VALUES (NULL, 8, 40, 4, 25);
INSERT INTO versification_data VALUES (NULL, 8, 40, 5, 48);
INSERT INTO versification_data VALUES (NULL, 8, 40, 6, 34);
INSERT INTO versification_data VALUES (NULL, 8, 40, 7, 29);
INSERT INTO versification_data VALUES (NULL, 8, 40, 8, 34);
INSERT INTO versification_data VALUES (NULL, 8, 40, 9, 38);
INSERT INTO versification_data VALUES (NULL, 8, 40, 10, 42);
INSERT INTO versification_data VALUES (NULL, 8, 40, 11, 30);
INSERT INTO versification_data VALUES (NULL, 8, 40, 12, 50);
INSERT INTO versification_data VALUES (NULL, 8, 40, 13, 58);
INSERT INTO versification_data VALUES (NULL, 8, 40, 14, 36);
INSERT INTO versification_data VALUES (NULL, 8, 40, 15, 39);
INSERT INTO versification_data VALUES (NULL, 8, 40, 16, 28);
INSERT INTO versification_data VALUES (NULL, 8, 40, 17, 27);
INSERT INTO versification_data VALUES (NULL, 8, 40, 18, 35);
INSERT INTO versification_data VALUES (NULL, 8, 40, 19, 30);
INSERT INTO versification_data VALUES (NULL, 8, 40, 20, 34);
INSERT INTO versification_data VALUES (NULL, 8, 40, 21, 46);
INSERT INTO versification_data VALUES (NULL, 8, 40, 22, 46);
INSERT INTO versification_data VALUES (NULL, 8, 40, 23, 39);
INSERT INTO versification_data VALUES (NULL, 8, 40, 24, 51);
INSERT INTO versification_data VALUES (NULL, 8, 40, 25, 46);
INSERT INTO versification_data VALUES (NULL, 8, 40, 26, 75);
INSERT INTO versification_data VALUES (NULL, 8, 40, 27, 66);
INSERT INTO versification_data VALUES (NULL, 8, 40, 28, 20);
INSERT INTO versification_data VALUES (NULL, 8, 41, 1, 45);
INSERT INTO versification_data VALUES (NULL, 8, 41, 2, 28);
INSERT INTO versification_data VALUES (NULL, 8, 41, 3, 35);
INSERT INTO versification_data VALUES (NULL, 8, 41, 4, 41);
INSERT INTO versification_data VALUES (NULL, 8, 41, 5, 43);
INSERT INTO versification_data VALUES (NULL, 8, 41, 6, 56);
INSERT INTO versification_data VALUES (NULL, 8, 41, 7, 37);
INSERT INTO versification_data VALUES (NULL, 8, 41, 8, 38);
INSERT INTO versification_data VALUES (NULL, 8, 41, 9, 50);
INSERT INTO versification_data VALUES (NULL, 8, 41, 10, 52);
INSERT INTO versification_data VALUES (NULL, 8, 41, 11, 33);
INSERT INTO versification_data VALUES (NULL, 8, 41, 12, 44);
INSERT INTO versification_data VALUES (NULL, 8, 41, 13, 37);
INSERT INTO versification_data VALUES (NULL, 8, 41, 14, 72);
INSERT INTO versification_data VALUES (NULL, 8, 41, 15, 47);
INSERT INTO versification_data VALUES (NULL, 8, 41, 16, 20);
INSERT INTO versification_data VALUES (NULL, 8, 42, 1, 80);
INSERT INTO versification_data VALUES (NULL, 8, 42, 2, 52);
INSERT INTO versification_data VALUES (NULL, 8, 42, 3, 38);
INSERT INTO versification_data VALUES (NULL, 8, 42, 4, 44);
INSERT INTO versification_data VALUES (NULL, 8, 42, 5, 39);
INSERT INTO versification_data VALUES (NULL, 8, 42, 6, 49);
INSERT INTO versification_data VALUES (NULL, 8, 42, 7, 50);
INSERT INTO versification_data VALUES (NULL, 8, 42, 8, 56);
INSERT INTO versification_data VALUES (NULL, 8, 42, 9, 62);
INSERT INTO versification_data VALUES (NULL, 8, 42, 10, 42);
INSERT INTO versification_data VALUES (NULL, 8, 42, 11, 54);
INSERT INTO versification_data VALUES (NULL, 8, 42, 12, 59);
INSERT INTO versification_data VALUES (NULL, 8, 42, 13, 35);
INSERT INTO versification_data VALUES (NULL, 8, 42, 14, 35);
INSERT INTO versification_data VALUES (NULL, 8, 42, 15, 32);
INSERT INTO versification_data VALUES (NULL, 8, 42, 16, 31);
INSERT INTO versification_data VALUES (NULL, 8, 42, 17, 37);
INSERT INTO versification_data VALUES (NULL, 8, 42, 18, 43);
INSERT INTO versification_data VALUES (NULL, 8, 42, 19, 48);
INSERT INTO versification_data VALUES (NULL, 8, 42, 20, 47);
INSERT INTO versification_data VALUES (NULL, 8, 42, 21, 38);
INSERT INTO versification_data VALUES (NULL, 8, 42, 22, 71);
INSERT INTO versification_data VALUES (NULL, 8, 42, 23, 56);
INSERT INTO versification_data VALUES (NULL, 8, 42, 24, 53);
INSERT INTO versification_data VALUES (NULL, 8, 43, 1, 51);
INSERT INTO versification_data VALUES (NULL, 8, 43, 2, 25);
INSERT INTO versification_data VALUES (NULL, 8, 43, 3, 36);
INSERT INTO versification_data VALUES (NULL, 8, 43, 4, 54);
INSERT INTO versification_data VALUES (NULL, 8, 43, 5, 47);
INSERT INTO versification_data VALUES (NULL, 8, 43, 6, 71);
INSERT INTO versification_data VALUES (NULL, 8, 43, 7, 53);
INSERT INTO versification_data VALUES (NULL, 8, 43, 8, 59);
INSERT INTO versification_data VALUES (NULL, 8, 43, 9, 41);
INSERT INTO versification_data VALUES (NULL, 8, 43, 10, 42);
INSERT INTO versification_data VALUES (NULL, 8, 43, 11, 57);
INSERT INTO versification_data VALUES (NULL, 8, 43, 12, 50);
INSERT INTO versification_data VALUES (NULL, 8, 43, 13, 38);
INSERT INTO versification_data VALUES (NULL, 8, 43, 14, 31);
INSERT INTO versification_data VALUES (NULL, 8, 43, 15, 27);
INSERT INTO versification_data VALUES (NULL, 8, 43, 16, 33);
INSERT INTO versification_data VALUES (NULL, 8, 43, 17, 26);
INSERT INTO versification_data VALUES (NULL, 8, 43, 18, 40);
INSERT INTO versification_data VALUES (NULL, 8, 43, 19, 42);
INSERT INTO versification_data VALUES (NULL, 8, 43, 20, 31);
INSERT INTO versification_data VALUES (NULL, 8, 43, 21, 25);
INSERT INTO versification_data VALUES (NULL, 8, 44, 1, 26);
INSERT INTO versification_data VALUES (NULL, 8, 44, 2, 47);
INSERT INTO versification_data VALUES (NULL, 8, 44, 3, 26);
INSERT INTO versification_data VALUES (NULL, 8, 44, 4, 37);
INSERT INTO versification_data VALUES (NULL, 8, 44, 5, 42);
INSERT INTO versification_data VALUES (NULL, 8, 44, 6, 15);
INSERT INTO versification_data VALUES (NULL, 8, 44, 7, 60);
INSERT INTO versification_data VALUES (NULL, 8, 44, 8, 40);
INSERT INTO versification_data VALUES (NULL, 8, 44, 9, 43);
INSERT INTO versification_data VALUES (NULL, 8, 44, 10, 48);
INSERT INTO versification_data VALUES (NULL, 8, 44, 11, 30);
INSERT INTO versification_data VALUES (NULL, 8, 44, 12, 25);
INSERT INTO versification_data VALUES (NULL, 8, 44, 13, 52);
INSERT INTO versification_data VALUES (NULL, 8, 44, 14, 28);
INSERT INTO versification_data VALUES (NULL, 8, 44, 15, 41);
INSERT INTO versification_data VALUES (NULL, 8, 44, 16, 40);
INSERT INTO versification_data VALUES (NULL, 8, 44, 17, 34);
INSERT INTO versification_data VALUES (NULL, 8, 44, 18, 28);
INSERT INTO versification_data VALUES (NULL, 8, 44, 19, 41);
INSERT INTO versification_data VALUES (NULL, 8, 44, 20, 38);
INSERT INTO versification_data VALUES (NULL, 8, 44, 21, 40);
INSERT INTO versification_data VALUES (NULL, 8, 44, 22, 30);
INSERT INTO versification_data VALUES (NULL, 8, 44, 23, 35);
INSERT INTO versification_data VALUES (NULL, 8, 44, 24, 27);
INSERT INTO versification_data VALUES (NULL, 8, 44, 25, 27);
INSERT INTO versification_data VALUES (NULL, 8, 44, 26, 32);
INSERT INTO versification_data VALUES (NULL, 8, 44, 27, 44);
INSERT INTO versification_data VALUES (NULL, 8, 44, 28, 31);
INSERT INTO versification_data VALUES (NULL, 8, 45, 1, 32);
INSERT INTO versification_data VALUES (NULL, 8, 45, 2, 29);
INSERT INTO versification_data VALUES (NULL, 8, 45, 3, 31);
INSERT INTO versification_data VALUES (NULL, 8, 45, 4, 25);
INSERT INTO versification_data VALUES (NULL, 8, 45, 5, 21);
INSERT INTO versification_data VALUES (NULL, 8, 45, 6, 23);
INSERT INTO versification_data VALUES (NULL, 8, 45, 7, 25);
INSERT INTO versification_data VALUES (NULL, 8, 45, 8, 39);
INSERT INTO versification_data VALUES (NULL, 8, 45, 9, 33);
INSERT INTO versification_data VALUES (NULL, 8, 45, 10, 21);
INSERT INTO versification_data VALUES (NULL, 8, 45, 11, 36);
INSERT INTO versification_data VALUES (NULL, 8, 45, 12, 21);
INSERT INTO versification_data VALUES (NULL, 8, 45, 13, 14);
INSERT INTO versification_data VALUES (NULL, 8, 45, 14, 23);
INSERT INTO versification_data VALUES (NULL, 8, 45, 15, 33);
INSERT INTO versification_data VALUES (NULL, 8, 45, 16, 27);
INSERT INTO versification_data VALUES (NULL, 8, 46, 1, 31);
INSERT INTO versification_data VALUES (NULL, 8, 46, 2, 16);
INSERT INTO versification_data VALUES (NULL, 8, 46, 3, 23);
INSERT INTO versification_data VALUES (NULL, 8, 46, 4, 21);
INSERT INTO versification_data VALUES (NULL, 8, 46, 5, 13);
INSERT INTO versification_data VALUES (NULL, 8, 46, 6, 20);
INSERT INTO versification_data VALUES (NULL, 8, 46, 7, 40);
INSERT INTO versification_data VALUES (NULL, 8, 46, 8, 13);
INSERT INTO versification_data VALUES (NULL, 8, 46, 9, 27);
INSERT INTO versification_data VALUES (NULL, 8, 46, 10, 33);
INSERT INTO versification_data VALUES (NULL, 8, 46, 11, 34);
INSERT INTO versification_data VALUES (NULL, 8, 46, 12, 31);
INSERT INTO versification_data VALUES (NULL, 8, 46, 13, 13);
INSERT INTO versification_data VALUES (NULL, 8, 46, 14, 40);
INSERT INTO versification_data VALUES (NULL, 8, 46, 15, 58);
INSERT INTO versification_data VALUES (NULL, 8, 46, 16, 24);
INSERT INTO versification_data VALUES (NULL, 8, 47, 1, 24);
INSERT INTO versification_data VALUES (NULL, 8, 47, 2, 17);
INSERT INTO versification_data VALUES (NULL, 8, 47, 3, 18);
INSERT INTO versification_data VALUES (NULL, 8, 47, 4, 18);
INSERT INTO versification_data VALUES (NULL, 8, 47, 5, 21);
INSERT INTO versification_data VALUES (NULL, 8, 47, 6, 18);
INSERT INTO versification_data VALUES (NULL, 8, 47, 7, 16);
INSERT INTO versification_data VALUES (NULL, 8, 47, 8, 24);
INSERT INTO versification_data VALUES (NULL, 8, 47, 9, 15);
INSERT INTO versification_data VALUES (NULL, 8, 47, 10, 18);
INSERT INTO versification_data VALUES (NULL, 8, 47, 11, 33);
INSERT INTO versification_data VALUES (NULL, 8, 47, 12, 21);
INSERT INTO versification_data VALUES (NULL, 8, 47, 13, 13);
INSERT INTO versification_data VALUES (NULL, 8, 48, 1, 24);
INSERT INTO versification_data VALUES (NULL, 8, 48, 2, 21);
INSERT INTO versification_data VALUES (NULL, 8, 48, 3, 29);
INSERT INTO versification_data VALUES (NULL, 8, 48, 4, 31);
INSERT INTO versification_data VALUES (NULL, 8, 48, 5, 26);
INSERT INTO versification_data VALUES (NULL, 8, 48, 6, 18);
INSERT INTO versification_data VALUES (NULL, 8, 49, 1, 23);
INSERT INTO versification_data VALUES (NULL, 8, 49, 2, 22);
INSERT INTO versification_data VALUES (NULL, 8, 49, 3, 21);
INSERT INTO versification_data VALUES (NULL, 8, 49, 4, 32);
INSERT INTO versification_data VALUES (NULL, 8, 49, 5, 33);
INSERT INTO versification_data VALUES (NULL, 8, 49, 6, 24);
INSERT INTO versification_data VALUES (NULL, 8, 50, 1, 30);
INSERT INTO versification_data VALUES (NULL, 8, 50, 2, 30);
INSERT INTO versification_data VALUES (NULL, 8, 50, 3, 21);
INSERT INTO versification_data VALUES (NULL, 8, 50, 4, 23);
INSERT INTO versification_data VALUES (NULL, 8, 51, 1, 29);
INSERT INTO versification_data VALUES (NULL, 8, 51, 2, 23);
INSERT INTO versification_data VALUES (NULL, 8, 51, 3, 25);
INSERT INTO versification_data VALUES (NULL, 8, 51, 4, 18);
INSERT INTO versification_data VALUES (NULL, 8, 52, 1, 10);
INSERT INTO versification_data VALUES (NULL, 8, 52, 2, 20);
INSERT INTO versification_data VALUES (NULL, 8, 52, 3, 13);
INSERT INTO versification_data VALUES (NULL, 8, 52, 4, 18);
INSERT INTO versification_data VALUES (NULL, 8, 52, 5, 28);
INSERT INTO versification_data VALUES (NULL, 8, 53, 1, 12);
INSERT INTO versification_data VALUES (NULL, 8, 53, 2, 17);
INSERT INTO versification_data VALUES (NULL, 8, 53, 3, 18);
INSERT INTO versification_data VALUES (NULL, 8, 54, 1, 20);
INSERT INTO versification_data VALUES (NULL, 8, 54, 2, 15);
INSERT INTO versification_data VALUES (NULL, 8, 54, 3, 16);
INSERT INTO versification_data VALUES (NULL, 8, 54, 4, 16);
INSERT INTO versification_data VALUES (NULL, 8, 54, 5, 25);
INSERT INTO versification_data VALUES (NULL, 8, 54, 6, 21);
INSERT INTO versification_data VALUES (NULL, 8, 55, 1, 18);
INSERT INTO versification_data VALUES (NULL, 8, 55, 2, 26);
INSERT INTO versification_data VALUES (NULL, 8, 55, 3, 17);
INSERT INTO versification_data VALUES (NULL, 8, 55, 4, 22);
INSERT INTO versification_data VALUES (NULL, 8, 56, 1, 16);
INSERT INTO versification_data VALUES (NULL, 8, 56, 2, 15);
INSERT INTO versification_data VALUES (NULL, 8, 56, 3, 15);
INSERT INTO versification_data VALUES (NULL, 8, 57, 1, 25);
INSERT INTO versification_data VALUES (NULL, 8, 58, 1, 14);
INSERT INTO versification_data VALUES (NULL, 8, 58, 2, 18);
INSERT INTO versification_data VALUES (NULL, 8, 58, 3, 19);
INSERT INTO versification_data VALUES (NULL, 8, 58, 4, 16);
INSERT INTO versification_data VALUES (NULL, 8, 58, 5, 14);
INSERT INTO versification_data VALUES (NULL, 8, 58, 6, 20);
INSERT INTO versification_data VALUES (NULL, 8, 58, 7, 28);
INSERT INTO versification_data VALUES (NULL, 8, 58, 8, 13);
INSERT INTO versification_data VALUES (NULL, 8, 58, 9, 28);
INSERT INTO versification_data VALUES (NULL, 8, 58, 10, 39);
INSERT INTO versification_data VALUES (NULL, 8, 58, 11, 40);
INSERT INTO versification_data VALUES (NULL, 8, 58, 12, 29);
INSERT INTO versification_data VALUES (NULL, 8, 58, 13, 25);
INSERT INTO versification_data VALUES (NULL, 8, 59, 1, 27);
INSERT INTO versification_data VALUES (NULL, 8, 59, 2, 26);
INSERT INTO versification_data VALUES (NULL, 8, 59, 3, 18);
INSERT INTO versification_data VALUES (NULL, 8, 59, 4, 17);
INSERT INTO versification_data VALUES (NULL, 8, 59, 5, 20);
INSERT INTO versification_data VALUES (NULL, 8, 60, 1, 25);
INSERT INTO versification_data VALUES (NULL, 8, 60, 2, 25);
INSERT INTO versification_data VALUES (NULL, 8, 60, 3, 22);
INSERT INTO versification_data VALUES (NULL, 8, 60, 4, 19);
INSERT INTO versification_data VALUES (NULL, 8, 60, 5, 14);
INSERT INTO versification_data VALUES (NULL, 8, 61, 1, 21);
INSERT INTO versification_data VALUES (NULL, 8, 61, 2, 22);
INSERT INTO versification_data VALUES (NULL, 8, 61, 3, 18);
INSERT INTO versification_data VALUES (NULL, 8, 62, 1, 10);
INSERT INTO versification_data VALUES (NULL, 8, 62, 2, 29);
INSERT INTO versification_data VALUES (NULL, 8, 62, 3, 24);
INSERT INTO versification_data VALUES (NULL, 8, 62, 4, 21);
INSERT INTO versification_data VALUES (NULL, 8, 62, 5, 21);
INSERT INTO versification_data VALUES (NULL, 8, 63, 1, 13);
INSERT INTO versification_data VALUES (NULL, 8, 64, 1, 15);
INSERT INTO versification_data VALUES (NULL, 8, 65, 1, 25);
INSERT INTO versification_data VALUES (NULL, 8, 66, 1, 20);
INSERT INTO versification_data VALUES (NULL, 8, 66, 2, 29);
INSERT INTO versification_data VALUES (NULL, 8, 66, 3, 22);
INSERT INTO versification_data VALUES (NULL, 8, 66, 4, 11);
INSERT INTO versification_data VALUES (NULL, 8, 66, 5, 14);
INSERT INTO versification_data VALUES (NULL, 8, 66, 6, 17);
INSERT INTO versification_data VALUES (NULL, 8, 66, 7, 17);
INSERT INTO versification_data VALUES (NULL, 8, 66, 8, 13);
INSERT INTO versification_data VALUES (NULL, 8, 66, 9, 21);
INSERT INTO versification_data VALUES (NULL, 8, 66, 10, 11);
INSERT INTO versification_data VALUES (NULL, 8, 66, 11, 19);
INSERT INTO versification_data VALUES (NULL, 8, 66, 12, 18);
INSERT INTO versification_data VALUES (NULL, 8, 66, 13, 18);
INSERT INTO versification_data VALUES (NULL, 8, 66, 14, 20);
INSERT INTO versification_data VALUES (NULL, 8, 66, 15, 8);
INSERT INTO versification_data VALUES (NULL, 8, 66, 16, 21);
INSERT INTO versification_data VALUES (NULL, 8, 66, 17, 18);
INSERT INTO versification_data VALUES (NULL, 8, 66, 18, 24);
INSERT INTO versification_data VALUES (NULL, 8, 66, 19, 21);
INSERT INTO versification_data VALUES (NULL, 8, 66, 20, 15);
INSERT INTO versification_data VALUES (NULL, 8, 66, 21, 27);
INSERT INTO versification_data VALUES (NULL, 8, 66, 22, 21);

INSERT INTO versification_names VALUES (9, 'Original');

INSERT INTO versification_data VALUES (NULL, 9, 1, 1, 31);
INSERT INTO versification_data VALUES (NULL, 9, 1, 2, 25);
INSERT INTO versification_data VALUES (NULL, 9, 1, 3, 24);
INSERT INTO versification_data VALUES (NULL, 9, 1, 4, 26);
INSERT INTO versification_data VALUES (NULL, 9, 1, 5, 32);
INSERT INTO versification_data VALUES (NULL, 9, 1, 6, 22);
INSERT INTO versification_data VALUES (NULL, 9, 1, 7, 24);
INSERT INTO versification_data VALUES (NULL, 9, 1, 8, 22);
INSERT INTO versification_data VALUES (NULL, 9, 1, 9, 29);
INSERT INTO versification_data VALUES (NULL, 9, 1, 10, 32);
INSERT INTO versification_data VALUES (NULL, 9, 1, 11, 32);
INSERT INTO versification_data VALUES (NULL, 9, 1, 12, 20);
INSERT INTO versification_data VALUES (NULL, 9, 1, 13, 18);
INSERT INTO versification_data VALUES (NULL, 9, 1, 14, 24);
INSERT INTO versification_data VALUES (NULL, 9, 1, 15, 21);
INSERT INTO versification_data VALUES (NULL, 9, 1, 16, 16);
INSERT INTO versification_data VALUES (NULL, 9, 1, 17, 27);
INSERT INTO versification_data VALUES (NULL, 9, 1, 18, 33);
INSERT INTO versification_data VALUES (NULL, 9, 1, 19, 38);
INSERT INTO versification_data VALUES (NULL, 9, 1, 20, 18);
INSERT INTO versification_data VALUES (NULL, 9, 1, 21, 34);
INSERT INTO versification_data VALUES (NULL, 9, 1, 22, 24);
INSERT INTO versification_data VALUES (NULL, 9, 1, 23, 20);
INSERT INTO versification_data VALUES (NULL, 9, 1, 24, 67);
INSERT INTO versification_data VALUES (NULL, 9, 1, 25, 34);
INSERT INTO versification_data VALUES (NULL, 9, 1, 26, 35);
INSERT INTO versification_data VALUES (NULL, 9, 1, 27, 46);
INSERT INTO versification_data VALUES (NULL, 9, 1, 28, 22);
INSERT INTO versification_data VALUES (NULL, 9, 1, 29, 35);
INSERT INTO versification_data VALUES (NULL, 9, 1, 30, 43);
INSERT INTO versification_data VALUES (NULL, 9, 1, 31, 54);
INSERT INTO versification_data VALUES (NULL, 9, 1, 32, 33);
INSERT INTO versification_data VALUES (NULL, 9, 1, 33, 20);
INSERT INTO versification_data VALUES (NULL, 9, 1, 34, 31);
INSERT INTO versification_data VALUES (NULL, 9, 1, 35, 29);
INSERT INTO versification_data VALUES (NULL, 9, 1, 36, 43);
INSERT INTO versification_data VALUES (NULL, 9, 1, 37, 36);
INSERT INTO versification_data VALUES (NULL, 9, 1, 38, 30);
INSERT INTO versification_data VALUES (NULL, 9, 1, 39, 23);
INSERT INTO versification_data VALUES (NULL, 9, 1, 40, 23);
INSERT INTO versification_data VALUES (NULL, 9, 1, 41, 57);
INSERT INTO versification_data VALUES (NULL, 9, 1, 42, 38);
INSERT INTO versification_data VALUES (NULL, 9, 1, 43, 34);
INSERT INTO versification_data VALUES (NULL, 9, 1, 44, 34);
INSERT INTO versification_data VALUES (NULL, 9, 1, 45, 28);
INSERT INTO versification_data VALUES (NULL, 9, 1, 46, 34);
INSERT INTO versification_data VALUES (NULL, 9, 1, 47, 31);
INSERT INTO versification_data VALUES (NULL, 9, 1, 48, 22);
INSERT INTO versification_data VALUES (NULL, 9, 1, 49, 33);
INSERT INTO versification_data VALUES (NULL, 9, 1, 50, 26);
INSERT INTO versification_data VALUES (NULL, 9, 2, 1, 22);
INSERT INTO versification_data VALUES (NULL, 9, 2, 2, 25);
INSERT INTO versification_data VALUES (NULL, 9, 2, 3, 22);
INSERT INTO versification_data VALUES (NULL, 9, 2, 4, 31);
INSERT INTO versification_data VALUES (NULL, 9, 2, 5, 23);
INSERT INTO versification_data VALUES (NULL, 9, 2, 6, 30);
INSERT INTO versification_data VALUES (NULL, 9, 2, 7, 29);
INSERT INTO versification_data VALUES (NULL, 9, 2, 8, 28);
INSERT INTO versification_data VALUES (NULL, 9, 2, 9, 35);
INSERT INTO versification_data VALUES (NULL, 9, 2, 10, 29);
INSERT INTO versification_data VALUES (NULL, 9, 2, 11, 10);
INSERT INTO versification_data VALUES (NULL, 9, 2, 12, 51);
INSERT INTO versification_data VALUES (NULL, 9, 2, 13, 22);
INSERT INTO versification_data VALUES (NULL, 9, 2, 14, 31);
INSERT INTO versification_data VALUES (NULL, 9, 2, 15, 27);
INSERT INTO versification_data VALUES (NULL, 9, 2, 16, 36);
INSERT INTO versification_data VALUES (NULL, 9, 2, 17, 16);
INSERT INTO versification_data VALUES (NULL, 9, 2, 18, 27);
INSERT INTO versification_data VALUES (NULL, 9, 2, 19, 25);
INSERT INTO versification_data VALUES (NULL, 9, 2, 20, 26);
INSERT INTO versification_data VALUES (NULL, 9, 2, 21, 37);
INSERT INTO versification_data VALUES (NULL, 9, 2, 22, 30);
INSERT INTO versification_data VALUES (NULL, 9, 2, 23, 33);
INSERT INTO versification_data VALUES (NULL, 9, 2, 24, 18);
INSERT INTO versification_data VALUES (NULL, 9, 2, 25, 40);
INSERT INTO versification_data VALUES (NULL, 9, 2, 26, 37);
INSERT INTO versification_data VALUES (NULL, 9, 2, 27, 21);
INSERT INTO versification_data VALUES (NULL, 9, 2, 28, 43);
INSERT INTO versification_data VALUES (NULL, 9, 2, 29, 46);
INSERT INTO versification_data VALUES (NULL, 9, 2, 30, 38);
INSERT INTO versification_data VALUES (NULL, 9, 2, 31, 18);
INSERT INTO versification_data VALUES (NULL, 9, 2, 32, 35);
INSERT INTO versification_data VALUES (NULL, 9, 2, 33, 23);
INSERT INTO versification_data VALUES (NULL, 9, 2, 34, 35);
INSERT INTO versification_data VALUES (NULL, 9, 2, 35, 35);
INSERT INTO versification_data VALUES (NULL, 9, 2, 36, 38);
INSERT INTO versification_data VALUES (NULL, 9, 2, 37, 29);
INSERT INTO versification_data VALUES (NULL, 9, 2, 38, 31);
INSERT INTO versification_data VALUES (NULL, 9, 2, 39, 43);
INSERT INTO versification_data VALUES (NULL, 9, 2, 40, 38);
INSERT INTO versification_data VALUES (NULL, 9, 3, 1, 17);
INSERT INTO versification_data VALUES (NULL, 9, 3, 2, 16);
INSERT INTO versification_data VALUES (NULL, 9, 3, 3, 17);
INSERT INTO versification_data VALUES (NULL, 9, 3, 4, 35);
INSERT INTO versification_data VALUES (NULL, 9, 3, 5, 26);
INSERT INTO versification_data VALUES (NULL, 9, 3, 6, 23);
INSERT INTO versification_data VALUES (NULL, 9, 3, 7, 38);
INSERT INTO versification_data VALUES (NULL, 9, 3, 8, 36);
INSERT INTO versification_data VALUES (NULL, 9, 3, 9, 24);
INSERT INTO versification_data VALUES (NULL, 9, 3, 10, 20);
INSERT INTO versification_data VALUES (NULL, 9, 3, 11, 47);
INSERT INTO versification_data VALUES (NULL, 9, 3, 12, 8);
INSERT INTO versification_data VALUES (NULL, 9, 3, 13, 59);
INSERT INTO versification_data VALUES (NULL, 9, 3, 14, 57);
INSERT INTO versification_data VALUES (NULL, 9, 3, 15, 33);
INSERT INTO versification_data VALUES (NULL, 9, 3, 16, 34);
INSERT INTO versification_data VALUES (NULL, 9, 3, 17, 16);
INSERT INTO versification_data VALUES (NULL, 9, 3, 18, 30);
INSERT INTO versification_data VALUES (NULL, 9, 3, 19, 37);
INSERT INTO versification_data VALUES (NULL, 9, 3, 20, 27);
INSERT INTO versification_data VALUES (NULL, 9, 3, 21, 24);
INSERT INTO versification_data VALUES (NULL, 9, 3, 22, 33);
INSERT INTO versification_data VALUES (NULL, 9, 3, 23, 44);
INSERT INTO versification_data VALUES (NULL, 9, 3, 24, 23);
INSERT INTO versification_data VALUES (NULL, 9, 3, 25, 55);
INSERT INTO versification_data VALUES (NULL, 9, 3, 26, 46);
INSERT INTO versification_data VALUES (NULL, 9, 3, 27, 34);
INSERT INTO versification_data VALUES (NULL, 9, 4, 1, 54);
INSERT INTO versification_data VALUES (NULL, 9, 4, 2, 34);
INSERT INTO versification_data VALUES (NULL, 9, 4, 3, 51);
INSERT INTO versification_data VALUES (NULL, 9, 4, 4, 49);
INSERT INTO versification_data VALUES (NULL, 9, 4, 5, 31);
INSERT INTO versification_data VALUES (NULL, 9, 4, 6, 27);
INSERT INTO versification_data VALUES (NULL, 9, 4, 7, 89);
INSERT INTO versification_data VALUES (NULL, 9, 4, 8, 26);
INSERT INTO versification_data VALUES (NULL, 9, 4, 9, 23);
INSERT INTO versification_data VALUES (NULL, 9, 4, 10, 36);
INSERT INTO versification_data VALUES (NULL, 9, 4, 11, 35);
INSERT INTO versification_data VALUES (NULL, 9, 4, 12, 16);
INSERT INTO versification_data VALUES (NULL, 9, 4, 13, 33);
INSERT INTO versification_data VALUES (NULL, 9, 4, 14, 45);
INSERT INTO versification_data VALUES (NULL, 9, 4, 15, 41);
INSERT INTO versification_data VALUES (NULL, 9, 4, 16, 35);
INSERT INTO versification_data VALUES (NULL, 9, 4, 17, 28);
INSERT INTO versification_data VALUES (NULL, 9, 4, 18, 32);
INSERT INTO versification_data VALUES (NULL, 9, 4, 19, 22);
INSERT INTO versification_data VALUES (NULL, 9, 4, 20, 29);
INSERT INTO versification_data VALUES (NULL, 9, 4, 21, 35);
INSERT INTO versification_data VALUES (NULL, 9, 4, 22, 41);
INSERT INTO versification_data VALUES (NULL, 9, 4, 23, 30);
INSERT INTO versification_data VALUES (NULL, 9, 4, 24, 25);
INSERT INTO versification_data VALUES (NULL, 9, 4, 25, 19);
INSERT INTO versification_data VALUES (NULL, 9, 4, 26, 65);
INSERT INTO versification_data VALUES (NULL, 9, 4, 27, 23);
INSERT INTO versification_data VALUES (NULL, 9, 4, 28, 31);
INSERT INTO versification_data VALUES (NULL, 9, 4, 29, 39);
INSERT INTO versification_data VALUES (NULL, 9, 4, 30, 17);
INSERT INTO versification_data VALUES (NULL, 9, 4, 31, 54);
INSERT INTO versification_data VALUES (NULL, 9, 4, 32, 42);
INSERT INTO versification_data VALUES (NULL, 9, 4, 33, 56);
INSERT INTO versification_data VALUES (NULL, 9, 4, 34, 29);
INSERT INTO versification_data VALUES (NULL, 9, 4, 35, 34);
INSERT INTO versification_data VALUES (NULL, 9, 4, 36, 13);
INSERT INTO versification_data VALUES (NULL, 9, 5, 1, 46);
INSERT INTO versification_data VALUES (NULL, 9, 5, 2, 37);
INSERT INTO versification_data VALUES (NULL, 9, 5, 3, 29);
INSERT INTO versification_data VALUES (NULL, 9, 5, 4, 49);
INSERT INTO versification_data VALUES (NULL, 9, 5, 5, 33);
INSERT INTO versification_data VALUES (NULL, 9, 5, 6, 25);
INSERT INTO versification_data VALUES (NULL, 9, 5, 7, 26);
INSERT INTO versification_data VALUES (NULL, 9, 5, 8, 20);
INSERT INTO versification_data VALUES (NULL, 9, 5, 9, 29);
INSERT INTO versification_data VALUES (NULL, 9, 5, 10, 22);
INSERT INTO versification_data VALUES (NULL, 9, 5, 11, 32);
INSERT INTO versification_data VALUES (NULL, 9, 5, 12, 31);
INSERT INTO versification_data VALUES (NULL, 9, 5, 13, 19);
INSERT INTO versification_data VALUES (NULL, 9, 5, 14, 29);
INSERT INTO versification_data VALUES (NULL, 9, 5, 15, 23);
INSERT INTO versification_data VALUES (NULL, 9, 5, 16, 22);
INSERT INTO versification_data VALUES (NULL, 9, 5, 17, 20);
INSERT INTO versification_data VALUES (NULL, 9, 5, 18, 22);
INSERT INTO versification_data VALUES (NULL, 9, 5, 19, 21);
INSERT INTO versification_data VALUES (NULL, 9, 5, 20, 20);
INSERT INTO versification_data VALUES (NULL, 9, 5, 21, 23);
INSERT INTO versification_data VALUES (NULL, 9, 5, 22, 29);
INSERT INTO versification_data VALUES (NULL, 9, 5, 23, 26);
INSERT INTO versification_data VALUES (NULL, 9, 5, 24, 22);
INSERT INTO versification_data VALUES (NULL, 9, 5, 25, 19);
INSERT INTO versification_data VALUES (NULL, 9, 5, 26, 19);
INSERT INTO versification_data VALUES (NULL, 9, 5, 27, 26);
INSERT INTO versification_data VALUES (NULL, 9, 5, 28, 69);
INSERT INTO versification_data VALUES (NULL, 9, 5, 29, 28);
INSERT INTO versification_data VALUES (NULL, 9, 5, 30, 20);
INSERT INTO versification_data VALUES (NULL, 9, 5, 31, 30);
INSERT INTO versification_data VALUES (NULL, 9, 5, 32, 52);
INSERT INTO versification_data VALUES (NULL, 9, 5, 33, 29);
INSERT INTO versification_data VALUES (NULL, 9, 5, 34, 12);
INSERT INTO versification_data VALUES (NULL, 9, 6, 1, 18);
INSERT INTO versification_data VALUES (NULL, 9, 6, 2, 24);
INSERT INTO versification_data VALUES (NULL, 9, 6, 3, 17);
INSERT INTO versification_data VALUES (NULL, 9, 6, 4, 24);
INSERT INTO versification_data VALUES (NULL, 9, 6, 5, 15);
INSERT INTO versification_data VALUES (NULL, 9, 6, 6, 27);
INSERT INTO versification_data VALUES (NULL, 9, 6, 7, 26);
INSERT INTO versification_data VALUES (NULL, 9, 6, 8, 35);
INSERT INTO versification_data VALUES (NULL, 9, 6, 9, 27);
INSERT INTO versification_data VALUES (NULL, 9, 6, 10, 43);
INSERT INTO versification_data VALUES (NULL, 9, 6, 11, 23);
INSERT INTO versification_data VALUES (NULL, 9, 6, 12, 24);
INSERT INTO versification_data VALUES (NULL, 9, 6, 13, 33);
INSERT INTO versification_data VALUES (NULL, 9, 6, 14, 15);
INSERT INTO versification_data VALUES (NULL, 9, 6, 15, 63);
INSERT INTO versification_data VALUES (NULL, 9, 6, 16, 10);
INSERT INTO versification_data VALUES (NULL, 9, 6, 17, 18);
INSERT INTO versification_data VALUES (NULL, 9, 6, 18, 28);
INSERT INTO versification_data VALUES (NULL, 9, 6, 19, 51);
INSERT INTO versification_data VALUES (NULL, 9, 6, 20, 9);
INSERT INTO versification_data VALUES (NULL, 9, 6, 21, 45);
INSERT INTO versification_data VALUES (NULL, 9, 6, 22, 34);
INSERT INTO versification_data VALUES (NULL, 9, 6, 23, 16);
INSERT INTO versification_data VALUES (NULL, 9, 6, 24, 33);
INSERT INTO versification_data VALUES (NULL, 9, 7, 1, 36);
INSERT INTO versification_data VALUES (NULL, 9, 7, 2, 23);
INSERT INTO versification_data VALUES (NULL, 9, 7, 3, 31);
INSERT INTO versification_data VALUES (NULL, 9, 7, 4, 24);
INSERT INTO versification_data VALUES (NULL, 9, 7, 5, 31);
INSERT INTO versification_data VALUES (NULL, 9, 7, 6, 40);
INSERT INTO versification_data VALUES (NULL, 9, 7, 7, 25);
INSERT INTO versification_data VALUES (NULL, 9, 7, 8, 35);
INSERT INTO versification_data VALUES (NULL, 9, 7, 9, 57);
INSERT INTO versification_data VALUES (NULL, 9, 7, 10, 18);
INSERT INTO versification_data VALUES (NULL, 9, 7, 11, 40);
INSERT INTO versification_data VALUES (NULL, 9, 7, 12, 15);
INSERT INTO versification_data VALUES (NULL, 9, 7, 13, 25);
INSERT INTO versification_data VALUES (NULL, 9, 7, 14, 20);
INSERT INTO versification_data VALUES (NULL, 9, 7, 15, 20);
INSERT INTO versification_data VALUES (NULL, 9, 7, 16, 31);
INSERT INTO versification_data VALUES (NULL, 9, 7, 17, 13);
INSERT INTO versification_data VALUES (NULL, 9, 7, 18, 31);
INSERT INTO versification_data VALUES (NULL, 9, 7, 19, 30);
INSERT INTO versification_data VALUES (NULL, 9, 7, 20, 48);
INSERT INTO versification_data VALUES (NULL, 9, 7, 21, 25);
INSERT INTO versification_data VALUES (NULL, 9, 8, 1, 22);
INSERT INTO versification_data VALUES (NULL, 9, 8, 2, 23);
INSERT INTO versification_data VALUES (NULL, 9, 8, 3, 18);
INSERT INTO versification_data VALUES (NULL, 9, 8, 4, 22);
INSERT INTO versification_data VALUES (NULL, 9, 9, 1, 28);
INSERT INTO versification_data VALUES (NULL, 9, 9, 2, 36);
INSERT INTO versification_data VALUES (NULL, 9, 9, 3, 21);
INSERT INTO versification_data VALUES (NULL, 9, 9, 4, 22);
INSERT INTO versification_data VALUES (NULL, 9, 9, 5, 12);
INSERT INTO versification_data VALUES (NULL, 9, 9, 6, 21);
INSERT INTO versification_data VALUES (NULL, 9, 9, 7, 17);
INSERT INTO versification_data VALUES (NULL, 9, 9, 8, 22);
INSERT INTO versification_data VALUES (NULL, 9, 9, 9, 27);
INSERT INTO versification_data VALUES (NULL, 9, 9, 10, 27);
INSERT INTO versification_data VALUES (NULL, 9, 9, 11, 15);
INSERT INTO versification_data VALUES (NULL, 9, 9, 12, 25);
INSERT INTO versification_data VALUES (NULL, 9, 9, 13, 23);
INSERT INTO versification_data VALUES (NULL, 9, 9, 14, 52);
INSERT INTO versification_data VALUES (NULL, 9, 9, 15, 35);
INSERT INTO versification_data VALUES (NULL, 9, 9, 16, 23);
INSERT INTO versification_data VALUES (NULL, 9, 9, 17, 58);
INSERT INTO versification_data VALUES (NULL, 9, 9, 18, 30);
INSERT INTO versification_data VALUES (NULL, 9, 9, 19, 24);
INSERT INTO versification_data VALUES (NULL, 9, 9, 20, 42);
INSERT INTO versification_data VALUES (NULL, 9, 9, 21, 16);
INSERT INTO versification_data VALUES (NULL, 9, 9, 22, 23);
INSERT INTO versification_data VALUES (NULL, 9, 9, 23, 28);
INSERT INTO versification_data VALUES (NULL, 9, 9, 24, 23);
INSERT INTO versification_data VALUES (NULL, 9, 9, 25, 44);
INSERT INTO versification_data VALUES (NULL, 9, 9, 26, 25);
INSERT INTO versification_data VALUES (NULL, 9, 9, 27, 12);
INSERT INTO versification_data VALUES (NULL, 9, 9, 28, 25);
INSERT INTO versification_data VALUES (NULL, 9, 9, 29, 11);
INSERT INTO versification_data VALUES (NULL, 9, 9, 30, 31);
INSERT INTO versification_data VALUES (NULL, 9, 9, 31, 13);
INSERT INTO versification_data VALUES (NULL, 9, 10, 1, 27);
INSERT INTO versification_data VALUES (NULL, 9, 10, 2, 32);
INSERT INTO versification_data VALUES (NULL, 9, 10, 3, 39);
INSERT INTO versification_data VALUES (NULL, 9, 10, 4, 12);
INSERT INTO versification_data VALUES (NULL, 9, 10, 5, 25);
INSERT INTO versification_data VALUES (NULL, 9, 10, 6, 23);
INSERT INTO versification_data VALUES (NULL, 9, 10, 7, 29);
INSERT INTO versification_data VALUES (NULL, 9, 10, 8, 18);
INSERT INTO versification_data VALUES (NULL, 9, 10, 9, 13);
INSERT INTO versification_data VALUES (NULL, 9, 10, 10, 19);
INSERT INTO versification_data VALUES (NULL, 9, 10, 11, 27);
INSERT INTO versification_data VALUES (NULL, 9, 10, 12, 31);
INSERT INTO versification_data VALUES (NULL, 9, 10, 13, 39);
INSERT INTO versification_data VALUES (NULL, 9, 10, 14, 33);
INSERT INTO versification_data VALUES (NULL, 9, 10, 15, 37);
INSERT INTO versification_data VALUES (NULL, 9, 10, 16, 23);
INSERT INTO versification_data VALUES (NULL, 9, 10, 17, 29);
INSERT INTO versification_data VALUES (NULL, 9, 10, 18, 32);
INSERT INTO versification_data VALUES (NULL, 9, 10, 19, 44);
INSERT INTO versification_data VALUES (NULL, 9, 10, 20, 26);
INSERT INTO versification_data VALUES (NULL, 9, 10, 21, 22);
INSERT INTO versification_data VALUES (NULL, 9, 10, 22, 51);
INSERT INTO versification_data VALUES (NULL, 9, 10, 23, 39);
INSERT INTO versification_data VALUES (NULL, 9, 10, 24, 25);
INSERT INTO versification_data VALUES (NULL, 9, 11, 1, 53);
INSERT INTO versification_data VALUES (NULL, 9, 11, 2, 46);
INSERT INTO versification_data VALUES (NULL, 9, 11, 3, 28);
INSERT INTO versification_data VALUES (NULL, 9, 11, 4, 20);
INSERT INTO versification_data VALUES (NULL, 9, 11, 5, 32);
INSERT INTO versification_data VALUES (NULL, 9, 11, 6, 38);
INSERT INTO versification_data VALUES (NULL, 9, 11, 7, 51);
INSERT INTO versification_data VALUES (NULL, 9, 11, 8, 66);
INSERT INTO versification_data VALUES (NULL, 9, 11, 9, 28);
INSERT INTO versification_data VALUES (NULL, 9, 11, 10, 29);
INSERT INTO versification_data VALUES (NULL, 9, 11, 11, 43);
INSERT INTO versification_data VALUES (NULL, 9, 11, 12, 33);
INSERT INTO versification_data VALUES (NULL, 9, 11, 13, 34);
INSERT INTO versification_data VALUES (NULL, 9, 11, 14, 31);
INSERT INTO versification_data VALUES (NULL, 9, 11, 15, 34);
INSERT INTO versification_data VALUES (NULL, 9, 11, 16, 34);
INSERT INTO versification_data VALUES (NULL, 9, 11, 17, 24);
INSERT INTO versification_data VALUES (NULL, 9, 11, 18, 46);
INSERT INTO versification_data VALUES (NULL, 9, 11, 19, 21);
INSERT INTO versification_data VALUES (NULL, 9, 11, 20, 43);
INSERT INTO versification_data VALUES (NULL, 9, 11, 21, 29);
INSERT INTO versification_data VALUES (NULL, 9, 11, 22, 54);
INSERT INTO versification_data VALUES (NULL, 9, 12, 1, 18);
INSERT INTO versification_data VALUES (NULL, 9, 12, 2, 25);
INSERT INTO versification_data VALUES (NULL, 9, 12, 3, 27);
INSERT INTO versification_data VALUES (NULL, 9, 12, 4, 44);
INSERT INTO versification_data VALUES (NULL, 9, 12, 5, 27);
INSERT INTO versification_data VALUES (NULL, 9, 12, 6, 33);
INSERT INTO versification_data VALUES (NULL, 9, 12, 7, 20);
INSERT INTO versification_data VALUES (NULL, 9, 12, 8, 29);
INSERT INTO versification_data VALUES (NULL, 9, 12, 9, 37);
INSERT INTO versification_data VALUES (NULL, 9, 12, 10, 36);
INSERT INTO versification_data VALUES (NULL, 9, 12, 11, 20);
INSERT INTO versification_data VALUES (NULL, 9, 12, 12, 22);
INSERT INTO versification_data VALUES (NULL, 9, 12, 13, 25);
INSERT INTO versification_data VALUES (NULL, 9, 12, 14, 29);
INSERT INTO versification_data VALUES (NULL, 9, 12, 15, 38);
INSERT INTO versification_data VALUES (NULL, 9, 12, 16, 20);
INSERT INTO versification_data VALUES (NULL, 9, 12, 17, 41);
INSERT INTO versification_data VALUES (NULL, 9, 12, 18, 37);
INSERT INTO versification_data VALUES (NULL, 9, 12, 19, 37);
INSERT INTO versification_data VALUES (NULL, 9, 12, 20, 21);
INSERT INTO versification_data VALUES (NULL, 9, 12, 21, 26);
INSERT INTO versification_data VALUES (NULL, 9, 12, 22, 20);
INSERT INTO versification_data VALUES (NULL, 9, 12, 23, 37);
INSERT INTO versification_data VALUES (NULL, 9, 12, 24, 20);
INSERT INTO versification_data VALUES (NULL, 9, 12, 25, 30);
INSERT INTO versification_data VALUES (NULL, 9, 13, 1, 54);
INSERT INTO versification_data VALUES (NULL, 9, 13, 2, 55);
INSERT INTO versification_data VALUES (NULL, 9, 13, 3, 24);
INSERT INTO versification_data VALUES (NULL, 9, 13, 4, 43);
INSERT INTO versification_data VALUES (NULL, 9, 13, 5, 41);
INSERT INTO versification_data VALUES (NULL, 9, 13, 6, 66);
INSERT INTO versification_data VALUES (NULL, 9, 13, 7, 40);
INSERT INTO versification_data VALUES (NULL, 9, 13, 8, 40);
INSERT INTO versification_data VALUES (NULL, 9, 13, 9, 44);
INSERT INTO versification_data VALUES (NULL, 9, 13, 10, 14);
INSERT INTO versification_data VALUES (NULL, 9, 13, 11, 47);
INSERT INTO versification_data VALUES (NULL, 9, 13, 12, 41);
INSERT INTO versification_data VALUES (NULL, 9, 13, 13, 14);
INSERT INTO versification_data VALUES (NULL, 9, 13, 14, 17);
INSERT INTO versification_data VALUES (NULL, 9, 13, 15, 29);
INSERT INTO versification_data VALUES (NULL, 9, 13, 16, 43);
INSERT INTO versification_data VALUES (NULL, 9, 13, 17, 27);
INSERT INTO versification_data VALUES (NULL, 9, 13, 18, 17);
INSERT INTO versification_data VALUES (NULL, 9, 13, 19, 19);
INSERT INTO versification_data VALUES (NULL, 9, 13, 20, 8);
INSERT INTO versification_data VALUES (NULL, 9, 13, 21, 30);
INSERT INTO versification_data VALUES (NULL, 9, 13, 22, 19);
INSERT INTO versification_data VALUES (NULL, 9, 13, 23, 32);
INSERT INTO versification_data VALUES (NULL, 9, 13, 24, 31);
INSERT INTO versification_data VALUES (NULL, 9, 13, 25, 31);
INSERT INTO versification_data VALUES (NULL, 9, 13, 26, 32);
INSERT INTO versification_data VALUES (NULL, 9, 13, 27, 34);
INSERT INTO versification_data VALUES (NULL, 9, 13, 28, 21);
INSERT INTO versification_data VALUES (NULL, 9, 13, 29, 30);
INSERT INTO versification_data VALUES (NULL, 9, 14, 1, 18);
INSERT INTO versification_data VALUES (NULL, 9, 14, 2, 17);
INSERT INTO versification_data VALUES (NULL, 9, 14, 3, 17);
INSERT INTO versification_data VALUES (NULL, 9, 14, 4, 22);
INSERT INTO versification_data VALUES (NULL, 9, 14, 5, 14);
INSERT INTO versification_data VALUES (NULL, 9, 14, 6, 42);
INSERT INTO versification_data VALUES (NULL, 9, 14, 7, 22);
INSERT INTO versification_data VALUES (NULL, 9, 14, 8, 18);
INSERT INTO versification_data VALUES (NULL, 9, 14, 9, 31);
INSERT INTO versification_data VALUES (NULL, 9, 14, 10, 19);
INSERT INTO versification_data VALUES (NULL, 9, 14, 11, 23);
INSERT INTO versification_data VALUES (NULL, 9, 14, 12, 16);
INSERT INTO versification_data VALUES (NULL, 9, 14, 13, 23);
INSERT INTO versification_data VALUES (NULL, 9, 14, 14, 14);
INSERT INTO versification_data VALUES (NULL, 9, 14, 15, 19);
INSERT INTO versification_data VALUES (NULL, 9, 14, 16, 14);
INSERT INTO versification_data VALUES (NULL, 9, 14, 17, 19);
INSERT INTO versification_data VALUES (NULL, 9, 14, 18, 34);
INSERT INTO versification_data VALUES (NULL, 9, 14, 19, 11);
INSERT INTO versification_data VALUES (NULL, 9, 14, 20, 37);
INSERT INTO versification_data VALUES (NULL, 9, 14, 21, 20);
INSERT INTO versification_data VALUES (NULL, 9, 14, 22, 12);
INSERT INTO versification_data VALUES (NULL, 9, 14, 23, 21);
INSERT INTO versification_data VALUES (NULL, 9, 14, 24, 27);
INSERT INTO versification_data VALUES (NULL, 9, 14, 25, 28);
INSERT INTO versification_data VALUES (NULL, 9, 14, 26, 23);
INSERT INTO versification_data VALUES (NULL, 9, 14, 27, 9);
INSERT INTO versification_data VALUES (NULL, 9, 14, 28, 27);
INSERT INTO versification_data VALUES (NULL, 9, 14, 29, 36);
INSERT INTO versification_data VALUES (NULL, 9, 14, 30, 27);
INSERT INTO versification_data VALUES (NULL, 9, 14, 31, 21);
INSERT INTO versification_data VALUES (NULL, 9, 14, 32, 33);
INSERT INTO versification_data VALUES (NULL, 9, 14, 33, 25);
INSERT INTO versification_data VALUES (NULL, 9, 14, 34, 33);
INSERT INTO versification_data VALUES (NULL, 9, 14, 35, 27);
INSERT INTO versification_data VALUES (NULL, 9, 14, 36, 23);
INSERT INTO versification_data VALUES (NULL, 9, 15, 1, 11);
INSERT INTO versification_data VALUES (NULL, 9, 15, 2, 70);
INSERT INTO versification_data VALUES (NULL, 9, 15, 3, 13);
INSERT INTO versification_data VALUES (NULL, 9, 15, 4, 24);
INSERT INTO versification_data VALUES (NULL, 9, 15, 5, 17);
INSERT INTO versification_data VALUES (NULL, 9, 15, 6, 22);
INSERT INTO versification_data VALUES (NULL, 9, 15, 7, 28);
INSERT INTO versification_data VALUES (NULL, 9, 15, 8, 36);
INSERT INTO versification_data VALUES (NULL, 9, 15, 9, 15);
INSERT INTO versification_data VALUES (NULL, 9, 15, 10, 44);
INSERT INTO versification_data VALUES (NULL, 9, 16, 1, 11);
INSERT INTO versification_data VALUES (NULL, 9, 16, 2, 20);
INSERT INTO versification_data VALUES (NULL, 9, 16, 3, 38);
INSERT INTO versification_data VALUES (NULL, 9, 16, 4, 17);
INSERT INTO versification_data VALUES (NULL, 9, 16, 5, 19);
INSERT INTO versification_data VALUES (NULL, 9, 16, 6, 19);
INSERT INTO versification_data VALUES (NULL, 9, 16, 7, 72);
INSERT INTO versification_data VALUES (NULL, 9, 16, 8, 18);
INSERT INTO versification_data VALUES (NULL, 9, 16, 9, 37);
INSERT INTO versification_data VALUES (NULL, 9, 16, 10, 40);
INSERT INTO versification_data VALUES (NULL, 9, 16, 11, 36);
INSERT INTO versification_data VALUES (NULL, 9, 16, 12, 47);
INSERT INTO versification_data VALUES (NULL, 9, 16, 13, 31);
INSERT INTO versification_data VALUES (NULL, 9, 17, 1, 22);
INSERT INTO versification_data VALUES (NULL, 9, 17, 2, 23);
INSERT INTO versification_data VALUES (NULL, 9, 17, 3, 15);
INSERT INTO versification_data VALUES (NULL, 9, 17, 4, 17);
INSERT INTO versification_data VALUES (NULL, 9, 17, 5, 14);
INSERT INTO versification_data VALUES (NULL, 9, 17, 6, 14);
INSERT INTO versification_data VALUES (NULL, 9, 17, 7, 10);
INSERT INTO versification_data VALUES (NULL, 9, 17, 8, 17);
INSERT INTO versification_data VALUES (NULL, 9, 17, 9, 32);
INSERT INTO versification_data VALUES (NULL, 9, 17, 10, 3);
INSERT INTO versification_data VALUES (NULL, 9, 18, 1, 22);
INSERT INTO versification_data VALUES (NULL, 9, 18, 2, 13);
INSERT INTO versification_data VALUES (NULL, 9, 18, 3, 26);
INSERT INTO versification_data VALUES (NULL, 9, 18, 4, 21);
INSERT INTO versification_data VALUES (NULL, 9, 18, 5, 27);
INSERT INTO versification_data VALUES (NULL, 9, 18, 6, 30);
INSERT INTO versification_data VALUES (NULL, 9, 18, 7, 21);
INSERT INTO versification_data VALUES (NULL, 9, 18, 8, 22);
INSERT INTO versification_data VALUES (NULL, 9, 18, 9, 35);
INSERT INTO versification_data VALUES (NULL, 9, 18, 10, 22);
INSERT INTO versification_data VALUES (NULL, 9, 18, 11, 20);
INSERT INTO versification_data VALUES (NULL, 9, 18, 12, 25);
INSERT INTO versification_data VALUES (NULL, 9, 18, 13, 28);
INSERT INTO versification_data VALUES (NULL, 9, 18, 14, 22);
INSERT INTO versification_data VALUES (NULL, 9, 18, 15, 35);
INSERT INTO versification_data VALUES (NULL, 9, 18, 16, 22);
INSERT INTO versification_data VALUES (NULL, 9, 18, 17, 16);
INSERT INTO versification_data VALUES (NULL, 9, 18, 18, 21);
INSERT INTO versification_data VALUES (NULL, 9, 18, 19, 29);
INSERT INTO versification_data VALUES (NULL, 9, 18, 20, 29);
INSERT INTO versification_data VALUES (NULL, 9, 18, 21, 34);
INSERT INTO versification_data VALUES (NULL, 9, 18, 22, 30);
INSERT INTO versification_data VALUES (NULL, 9, 18, 23, 17);
INSERT INTO versification_data VALUES (NULL, 9, 18, 24, 25);
INSERT INTO versification_data VALUES (NULL, 9, 18, 25, 6);
INSERT INTO versification_data VALUES (NULL, 9, 18, 26, 14);
INSERT INTO versification_data VALUES (NULL, 9, 18, 27, 23);
INSERT INTO versification_data VALUES (NULL, 9, 18, 28, 28);
INSERT INTO versification_data VALUES (NULL, 9, 18, 29, 25);
INSERT INTO versification_data VALUES (NULL, 9, 18, 30, 31);
INSERT INTO versification_data VALUES (NULL, 9, 18, 31, 40);
INSERT INTO versification_data VALUES (NULL, 9, 18, 32, 22);
INSERT INTO versification_data VALUES (NULL, 9, 18, 33, 33);
INSERT INTO versification_data VALUES (NULL, 9, 18, 34, 37);
INSERT INTO versification_data VALUES (NULL, 9, 18, 35, 16);
INSERT INTO versification_data VALUES (NULL, 9, 18, 36, 33);
INSERT INTO versification_data VALUES (NULL, 9, 18, 37, 24);
INSERT INTO versification_data VALUES (NULL, 9, 18, 38, 41);
INSERT INTO versification_data VALUES (NULL, 9, 18, 39, 30);
INSERT INTO versification_data VALUES (NULL, 9, 18, 40, 32);
INSERT INTO versification_data VALUES (NULL, 9, 18, 41, 26);
INSERT INTO versification_data VALUES (NULL, 9, 18, 42, 17);
INSERT INTO versification_data VALUES (NULL, 9, 19, 1, 6);
INSERT INTO versification_data VALUES (NULL, 9, 19, 2, 12);
INSERT INTO versification_data VALUES (NULL, 9, 19, 3, 9);
INSERT INTO versification_data VALUES (NULL, 9, 19, 4, 9);
INSERT INTO versification_data VALUES (NULL, 9, 19, 5, 13);
INSERT INTO versification_data VALUES (NULL, 9, 19, 6, 11);
INSERT INTO versification_data VALUES (NULL, 9, 19, 7, 18);
INSERT INTO versification_data VALUES (NULL, 9, 19, 8, 10);
INSERT INTO versification_data VALUES (NULL, 9, 19, 9, 21);
INSERT INTO versification_data VALUES (NULL, 9, 19, 10, 18);
INSERT INTO versification_data VALUES (NULL, 9, 19, 11, 7);
INSERT INTO versification_data VALUES (NULL, 9, 19, 12, 9);
INSERT INTO versification_data VALUES (NULL, 9, 19, 13, 6);
INSERT INTO versification_data VALUES (NULL, 9, 19, 14, 7);
INSERT INTO versification_data VALUES (NULL, 9, 19, 15, 5);
INSERT INTO versification_data VALUES (NULL, 9, 19, 16, 11);
INSERT INTO versification_data VALUES (NULL, 9, 19, 17, 15);
INSERT INTO versification_data VALUES (NULL, 9, 19, 18, 51);
INSERT INTO versification_data VALUES (NULL, 9, 19, 19, 15);
INSERT INTO versification_data VALUES (NULL, 9, 19, 20, 10);
INSERT INTO versification_data VALUES (NULL, 9, 19, 21, 14);
INSERT INTO versification_data VALUES (NULL, 9, 19, 22, 32);
INSERT INTO versification_data VALUES (NULL, 9, 19, 23, 6);
INSERT INTO versification_data VALUES (NULL, 9, 19, 24, 10);
INSERT INTO versification_data VALUES (NULL, 9, 19, 25, 22);
INSERT INTO versification_data VALUES (NULL, 9, 19, 26, 12);
INSERT INTO versification_data VALUES (NULL, 9, 19, 27, 14);
INSERT INTO versification_data VALUES (NULL, 9, 19, 28, 9);
INSERT INTO versification_data VALUES (NULL, 9, 19, 29, 11);
INSERT INTO versification_data VALUES (NULL, 9, 19, 30, 13);
INSERT INTO versification_data VALUES (NULL, 9, 19, 31, 25);
INSERT INTO versification_data VALUES (NULL, 9, 19, 32, 11);
INSERT INTO versification_data VALUES (NULL, 9, 19, 33, 22);
INSERT INTO versification_data VALUES (NULL, 9, 19, 34, 23);
INSERT INTO versification_data VALUES (NULL, 9, 19, 35, 28);
INSERT INTO versification_data VALUES (NULL, 9, 19, 36, 13);
INSERT INTO versification_data VALUES (NULL, 9, 19, 37, 40);
INSERT INTO versification_data VALUES (NULL, 9, 19, 38, 23);
INSERT INTO versification_data VALUES (NULL, 9, 19, 39, 14);
INSERT INTO versification_data VALUES (NULL, 9, 19, 40, 18);
INSERT INTO versification_data VALUES (NULL, 9, 19, 41, 14);
INSERT INTO versification_data VALUES (NULL, 9, 19, 42, 12);
INSERT INTO versification_data VALUES (NULL, 9, 19, 43, 5);
INSERT INTO versification_data VALUES (NULL, 9, 19, 44, 27);
INSERT INTO versification_data VALUES (NULL, 9, 19, 45, 18);
INSERT INTO versification_data VALUES (NULL, 9, 19, 46, 12);
INSERT INTO versification_data VALUES (NULL, 9, 19, 47, 10);
INSERT INTO versification_data VALUES (NULL, 9, 19, 48, 15);
INSERT INTO versification_data VALUES (NULL, 9, 19, 49, 21);
INSERT INTO versification_data VALUES (NULL, 9, 19, 50, 23);
INSERT INTO versification_data VALUES (NULL, 9, 19, 51, 21);
INSERT INTO versification_data VALUES (NULL, 9, 19, 52, 11);
INSERT INTO versification_data VALUES (NULL, 9, 19, 53, 7);
INSERT INTO versification_data VALUES (NULL, 9, 19, 54, 9);
INSERT INTO versification_data VALUES (NULL, 9, 19, 55, 24);
INSERT INTO versification_data VALUES (NULL, 9, 19, 56, 14);
INSERT INTO versification_data VALUES (NULL, 9, 19, 57, 12);
INSERT INTO versification_data VALUES (NULL, 9, 19, 58, 12);
INSERT INTO versification_data VALUES (NULL, 9, 19, 59, 18);
INSERT INTO versification_data VALUES (NULL, 9, 19, 60, 14);
INSERT INTO versification_data VALUES (NULL, 9, 19, 61, 9);
INSERT INTO versification_data VALUES (NULL, 9, 19, 62, 13);
INSERT INTO versification_data VALUES (NULL, 9, 19, 63, 12);
INSERT INTO versification_data VALUES (NULL, 9, 19, 64, 11);
INSERT INTO versification_data VALUES (NULL, 9, 19, 65, 14);
INSERT INTO versification_data VALUES (NULL, 9, 19, 66, 20);
INSERT INTO versification_data VALUES (NULL, 9, 19, 67, 8);
INSERT INTO versification_data VALUES (NULL, 9, 19, 68, 36);
INSERT INTO versification_data VALUES (NULL, 9, 19, 69, 37);
INSERT INTO versification_data VALUES (NULL, 9, 19, 70, 6);
INSERT INTO versification_data VALUES (NULL, 9, 19, 71, 24);
INSERT INTO versification_data VALUES (NULL, 9, 19, 72, 20);
INSERT INTO versification_data VALUES (NULL, 9, 19, 73, 28);
INSERT INTO versification_data VALUES (NULL, 9, 19, 74, 23);
INSERT INTO versification_data VALUES (NULL, 9, 19, 75, 11);
INSERT INTO versification_data VALUES (NULL, 9, 19, 76, 13);
INSERT INTO versification_data VALUES (NULL, 9, 19, 77, 21);
INSERT INTO versification_data VALUES (NULL, 9, 19, 78, 72);
INSERT INTO versification_data VALUES (NULL, 9, 19, 79, 13);
INSERT INTO versification_data VALUES (NULL, 9, 19, 80, 20);
INSERT INTO versification_data VALUES (NULL, 9, 19, 81, 17);
INSERT INTO versification_data VALUES (NULL, 9, 19, 82, 8);
INSERT INTO versification_data VALUES (NULL, 9, 19, 83, 19);
INSERT INTO versification_data VALUES (NULL, 9, 19, 84, 13);
INSERT INTO versification_data VALUES (NULL, 9, 19, 85, 14);
INSERT INTO versification_data VALUES (NULL, 9, 19, 86, 17);
INSERT INTO versification_data VALUES (NULL, 9, 19, 87, 7);
INSERT INTO versification_data VALUES (NULL, 9, 19, 88, 19);
INSERT INTO versification_data VALUES (NULL, 9, 19, 89, 53);
INSERT INTO versification_data VALUES (NULL, 9, 19, 90, 17);
INSERT INTO versification_data VALUES (NULL, 9, 19, 91, 16);
INSERT INTO versification_data VALUES (NULL, 9, 19, 92, 16);
INSERT INTO versification_data VALUES (NULL, 9, 19, 93, 5);
INSERT INTO versification_data VALUES (NULL, 9, 19, 94, 23);
INSERT INTO versification_data VALUES (NULL, 9, 19, 95, 11);
INSERT INTO versification_data VALUES (NULL, 9, 19, 96, 13);
INSERT INTO versification_data VALUES (NULL, 9, 19, 97, 12);
INSERT INTO versification_data VALUES (NULL, 9, 19, 98, 9);
INSERT INTO versification_data VALUES (NULL, 9, 19, 99, 9);
INSERT INTO versification_data VALUES (NULL, 9, 19, 100, 5);
INSERT INTO versification_data VALUES (NULL, 9, 19, 101, 8);
INSERT INTO versification_data VALUES (NULL, 9, 19, 102, 29);
INSERT INTO versification_data VALUES (NULL, 9, 19, 103, 22);
INSERT INTO versification_data VALUES (NULL, 9, 19, 104, 35);
INSERT INTO versification_data VALUES (NULL, 9, 19, 105, 45);
INSERT INTO versification_data VALUES (NULL, 9, 19, 106, 48);
INSERT INTO versification_data VALUES (NULL, 9, 19, 107, 43);
INSERT INTO versification_data VALUES (NULL, 9, 19, 108, 14);
INSERT INTO versification_data VALUES (NULL, 9, 19, 109, 31);
INSERT INTO versification_data VALUES (NULL, 9, 19, 110, 7);
INSERT INTO versification_data VALUES (NULL, 9, 19, 111, 10);
INSERT INTO versification_data VALUES (NULL, 9, 19, 112, 10);
INSERT INTO versification_data VALUES (NULL, 9, 19, 113, 9);
INSERT INTO versification_data VALUES (NULL, 9, 19, 114, 8);
INSERT INTO versification_data VALUES (NULL, 9, 19, 115, 18);
INSERT INTO versification_data VALUES (NULL, 9, 19, 116, 19);
INSERT INTO versification_data VALUES (NULL, 9, 19, 117, 2);
INSERT INTO versification_data VALUES (NULL, 9, 19, 118, 29);
INSERT INTO versification_data VALUES (NULL, 9, 19, 119, 176);
INSERT INTO versification_data VALUES (NULL, 9, 19, 120, 7);
INSERT INTO versification_data VALUES (NULL, 9, 19, 121, 8);
INSERT INTO versification_data VALUES (NULL, 9, 19, 122, 9);
INSERT INTO versification_data VALUES (NULL, 9, 19, 123, 4);
INSERT INTO versification_data VALUES (NULL, 9, 19, 124, 8);
INSERT INTO versification_data VALUES (NULL, 9, 19, 125, 5);
INSERT INTO versification_data VALUES (NULL, 9, 19, 126, 6);
INSERT INTO versification_data VALUES (NULL, 9, 19, 127, 5);
INSERT INTO versification_data VALUES (NULL, 9, 19, 128, 6);
INSERT INTO versification_data VALUES (NULL, 9, 19, 129, 8);
INSERT INTO versification_data VALUES (NULL, 9, 19, 130, 8);
INSERT INTO versification_data VALUES (NULL, 9, 19, 131, 3);
INSERT INTO versification_data VALUES (NULL, 9, 19, 132, 18);
INSERT INTO versification_data VALUES (NULL, 9, 19, 133, 3);
INSERT INTO versification_data VALUES (NULL, 9, 19, 134, 3);
INSERT INTO versification_data VALUES (NULL, 9, 19, 135, 21);
INSERT INTO versification_data VALUES (NULL, 9, 19, 136, 26);
INSERT INTO versification_data VALUES (NULL, 9, 19, 137, 9);
INSERT INTO versification_data VALUES (NULL, 9, 19, 138, 8);
INSERT INTO versification_data VALUES (NULL, 9, 19, 139, 24);
INSERT INTO versification_data VALUES (NULL, 9, 19, 140, 14);
INSERT INTO versification_data VALUES (NULL, 9, 19, 141, 10);
INSERT INTO versification_data VALUES (NULL, 9, 19, 142, 8);
INSERT INTO versification_data VALUES (NULL, 9, 19, 143, 12);
INSERT INTO versification_data VALUES (NULL, 9, 19, 144, 15);
INSERT INTO versification_data VALUES (NULL, 9, 19, 145, 21);
INSERT INTO versification_data VALUES (NULL, 9, 19, 146, 10);
INSERT INTO versification_data VALUES (NULL, 9, 19, 147, 20);
INSERT INTO versification_data VALUES (NULL, 9, 19, 148, 14);
INSERT INTO versification_data VALUES (NULL, 9, 19, 149, 9);
INSERT INTO versification_data VALUES (NULL, 9, 19, 150, 6);
INSERT INTO versification_data VALUES (NULL, 9, 20, 1, 33);
INSERT INTO versification_data VALUES (NULL, 9, 20, 2, 22);
INSERT INTO versification_data VALUES (NULL, 9, 20, 3, 35);
INSERT INTO versification_data VALUES (NULL, 9, 20, 4, 27);
INSERT INTO versification_data VALUES (NULL, 9, 20, 5, 23);
INSERT INTO versification_data VALUES (NULL, 9, 20, 6, 35);
INSERT INTO versification_data VALUES (NULL, 9, 20, 7, 27);
INSERT INTO versification_data VALUES (NULL, 9, 20, 8, 36);
INSERT INTO versification_data VALUES (NULL, 9, 20, 9, 18);
INSERT INTO versification_data VALUES (NULL, 9, 20, 10, 32);
INSERT INTO versification_data VALUES (NULL, 9, 20, 11, 31);
INSERT INTO versification_data VALUES (NULL, 9, 20, 12, 28);
INSERT INTO versification_data VALUES (NULL, 9, 20, 13, 25);
INSERT INTO versification_data VALUES (NULL, 9, 20, 14, 35);
INSERT INTO versification_data VALUES (NULL, 9, 20, 15, 33);
INSERT INTO versification_data VALUES (NULL, 9, 20, 16, 33);
INSERT INTO versification_data VALUES (NULL, 9, 20, 17, 28);
INSERT INTO versification_data VALUES (NULL, 9, 20, 18, 24);
INSERT INTO versification_data VALUES (NULL, 9, 20, 19, 29);
INSERT INTO versification_data VALUES (NULL, 9, 20, 20, 30);
INSERT INTO versification_data VALUES (NULL, 9, 20, 21, 31);
INSERT INTO versification_data VALUES (NULL, 9, 20, 22, 29);
INSERT INTO versification_data VALUES (NULL, 9, 20, 23, 35);
INSERT INTO versification_data VALUES (NULL, 9, 20, 24, 34);
INSERT INTO versification_data VALUES (NULL, 9, 20, 25, 28);
INSERT INTO versification_data VALUES (NULL, 9, 20, 26, 28);
INSERT INTO versification_data VALUES (NULL, 9, 20, 27, 27);
INSERT INTO versification_data VALUES (NULL, 9, 20, 28, 28);
INSERT INTO versification_data VALUES (NULL, 9, 20, 29, 27);
INSERT INTO versification_data VALUES (NULL, 9, 20, 30, 33);
INSERT INTO versification_data VALUES (NULL, 9, 20, 31, 31);
INSERT INTO versification_data VALUES (NULL, 9, 21, 1, 18);
INSERT INTO versification_data VALUES (NULL, 9, 21, 2, 26);
INSERT INTO versification_data VALUES (NULL, 9, 21, 3, 22);
INSERT INTO versification_data VALUES (NULL, 9, 21, 4, 17);
INSERT INTO versification_data VALUES (NULL, 9, 21, 5, 19);
INSERT INTO versification_data VALUES (NULL, 9, 21, 6, 12);
INSERT INTO versification_data VALUES (NULL, 9, 21, 7, 29);
INSERT INTO versification_data VALUES (NULL, 9, 21, 8, 17);
INSERT INTO versification_data VALUES (NULL, 9, 21, 9, 18);
INSERT INTO versification_data VALUES (NULL, 9, 21, 10, 20);
INSERT INTO versification_data VALUES (NULL, 9, 21, 11, 10);
INSERT INTO versification_data VALUES (NULL, 9, 21, 12, 14);
INSERT INTO versification_data VALUES (NULL, 9, 22, 1, 17);
INSERT INTO versification_data VALUES (NULL, 9, 22, 2, 17);
INSERT INTO versification_data VALUES (NULL, 9, 22, 3, 11);
INSERT INTO versification_data VALUES (NULL, 9, 22, 4, 16);
INSERT INTO versification_data VALUES (NULL, 9, 22, 5, 16);
INSERT INTO versification_data VALUES (NULL, 9, 22, 6, 12);
INSERT INTO versification_data VALUES (NULL, 9, 22, 7, 14);
INSERT INTO versification_data VALUES (NULL, 9, 22, 8, 14);
INSERT INTO versification_data VALUES (NULL, 9, 23, 1, 31);
INSERT INTO versification_data VALUES (NULL, 9, 23, 2, 22);
INSERT INTO versification_data VALUES (NULL, 9, 23, 3, 26);
INSERT INTO versification_data VALUES (NULL, 9, 23, 4, 6);
INSERT INTO versification_data VALUES (NULL, 9, 23, 5, 30);
INSERT INTO versification_data VALUES (NULL, 9, 23, 6, 13);
INSERT INTO versification_data VALUES (NULL, 9, 23, 7, 25);
INSERT INTO versification_data VALUES (NULL, 9, 23, 8, 23);
INSERT INTO versification_data VALUES (NULL, 9, 23, 9, 20);
INSERT INTO versification_data VALUES (NULL, 9, 23, 10, 34);
INSERT INTO versification_data VALUES (NULL, 9, 23, 11, 16);
INSERT INTO versification_data VALUES (NULL, 9, 23, 12, 6);
INSERT INTO versification_data VALUES (NULL, 9, 23, 13, 22);
INSERT INTO versification_data VALUES (NULL, 9, 23, 14, 32);
INSERT INTO versification_data VALUES (NULL, 9, 23, 15, 9);
INSERT INTO versification_data VALUES (NULL, 9, 23, 16, 14);
INSERT INTO versification_data VALUES (NULL, 9, 23, 17, 14);
INSERT INTO versification_data VALUES (NULL, 9, 23, 18, 7);
INSERT INTO versification_data VALUES (NULL, 9, 23, 19, 25);
INSERT INTO versification_data VALUES (NULL, 9, 23, 20, 6);
INSERT INTO versification_data VALUES (NULL, 9, 23, 21, 17);
INSERT INTO versification_data VALUES (NULL, 9, 23, 22, 25);
INSERT INTO versification_data VALUES (NULL, 9, 23, 23, 18);
INSERT INTO versification_data VALUES (NULL, 9, 23, 24, 23);
INSERT INTO versification_data VALUES (NULL, 9, 23, 25, 12);
INSERT INTO versification_data VALUES (NULL, 9, 23, 26, 21);
INSERT INTO versification_data VALUES (NULL, 9, 23, 27, 13);
INSERT INTO versification_data VALUES (NULL, 9, 23, 28, 29);
INSERT INTO versification_data VALUES (NULL, 9, 23, 29, 24);
INSERT INTO versification_data VALUES (NULL, 9, 23, 30, 33);
INSERT INTO versification_data VALUES (NULL, 9, 23, 31, 9);
INSERT INTO versification_data VALUES (NULL, 9, 23, 32, 20);
INSERT INTO versification_data VALUES (NULL, 9, 23, 33, 24);
INSERT INTO versification_data VALUES (NULL, 9, 23, 34, 17);
INSERT INTO versification_data VALUES (NULL, 9, 23, 35, 10);
INSERT INTO versification_data VALUES (NULL, 9, 23, 36, 22);
INSERT INTO versification_data VALUES (NULL, 9, 23, 37, 38);
INSERT INTO versification_data VALUES (NULL, 9, 23, 38, 22);
INSERT INTO versification_data VALUES (NULL, 9, 23, 39, 8);
INSERT INTO versification_data VALUES (NULL, 9, 23, 40, 31);
INSERT INTO versification_data VALUES (NULL, 9, 23, 41, 29);
INSERT INTO versification_data VALUES (NULL, 9, 23, 42, 25);
INSERT INTO versification_data VALUES (NULL, 9, 23, 43, 28);
INSERT INTO versification_data VALUES (NULL, 9, 23, 44, 28);
INSERT INTO versification_data VALUES (NULL, 9, 23, 45, 25);
INSERT INTO versification_data VALUES (NULL, 9, 23, 46, 13);
INSERT INTO versification_data VALUES (NULL, 9, 23, 47, 15);
INSERT INTO versification_data VALUES (NULL, 9, 23, 48, 22);
INSERT INTO versification_data VALUES (NULL, 9, 23, 49, 26);
INSERT INTO versification_data VALUES (NULL, 9, 23, 50, 11);
INSERT INTO versification_data VALUES (NULL, 9, 23, 51, 23);
INSERT INTO versification_data VALUES (NULL, 9, 23, 52, 15);
INSERT INTO versification_data VALUES (NULL, 9, 23, 53, 12);
INSERT INTO versification_data VALUES (NULL, 9, 23, 54, 17);
INSERT INTO versification_data VALUES (NULL, 9, 23, 55, 13);
INSERT INTO versification_data VALUES (NULL, 9, 23, 56, 12);
INSERT INTO versification_data VALUES (NULL, 9, 23, 57, 21);
INSERT INTO versification_data VALUES (NULL, 9, 23, 58, 14);
INSERT INTO versification_data VALUES (NULL, 9, 23, 59, 21);
INSERT INTO versification_data VALUES (NULL, 9, 23, 60, 22);
INSERT INTO versification_data VALUES (NULL, 9, 23, 61, 11);
INSERT INTO versification_data VALUES (NULL, 9, 23, 62, 12);
INSERT INTO versification_data VALUES (NULL, 9, 23, 63, 19);
INSERT INTO versification_data VALUES (NULL, 9, 23, 64, 11);
INSERT INTO versification_data VALUES (NULL, 9, 23, 65, 25);
INSERT INTO versification_data VALUES (NULL, 9, 23, 66, 24);
INSERT INTO versification_data VALUES (NULL, 9, 24, 1, 19);
INSERT INTO versification_data VALUES (NULL, 9, 24, 2, 37);
INSERT INTO versification_data VALUES (NULL, 9, 24, 3, 25);
INSERT INTO versification_data VALUES (NULL, 9, 24, 4, 31);
INSERT INTO versification_data VALUES (NULL, 9, 24, 5, 31);
INSERT INTO versification_data VALUES (NULL, 9, 24, 6, 30);
INSERT INTO versification_data VALUES (NULL, 9, 24, 7, 34);
INSERT INTO versification_data VALUES (NULL, 9, 24, 8, 23);
INSERT INTO versification_data VALUES (NULL, 9, 24, 9, 25);
INSERT INTO versification_data VALUES (NULL, 9, 24, 10, 25);
INSERT INTO versification_data VALUES (NULL, 9, 24, 11, 23);
INSERT INTO versification_data VALUES (NULL, 9, 24, 12, 17);
INSERT INTO versification_data VALUES (NULL, 9, 24, 13, 27);
INSERT INTO versification_data VALUES (NULL, 9, 24, 14, 22);
INSERT INTO versification_data VALUES (NULL, 9, 24, 15, 21);
INSERT INTO versification_data VALUES (NULL, 9, 24, 16, 21);
INSERT INTO versification_data VALUES (NULL, 9, 24, 17, 27);
INSERT INTO versification_data VALUES (NULL, 9, 24, 18, 23);
INSERT INTO versification_data VALUES (NULL, 9, 24, 19, 15);
INSERT INTO versification_data VALUES (NULL, 9, 24, 20, 18);
INSERT INTO versification_data VALUES (NULL, 9, 24, 21, 14);
INSERT INTO versification_data VALUES (NULL, 9, 24, 22, 30);
INSERT INTO versification_data VALUES (NULL, 9, 24, 23, 40);
INSERT INTO versification_data VALUES (NULL, 9, 24, 24, 10);
INSERT INTO versification_data VALUES (NULL, 9, 24, 25, 38);
INSERT INTO versification_data VALUES (NULL, 9, 24, 26, 24);
INSERT INTO versification_data VALUES (NULL, 9, 24, 27, 22);
INSERT INTO versification_data VALUES (NULL, 9, 24, 28, 17);
INSERT INTO versification_data VALUES (NULL, 9, 24, 29, 32);
INSERT INTO versification_data VALUES (NULL, 9, 24, 30, 24);
INSERT INTO versification_data VALUES (NULL, 9, 24, 31, 40);
INSERT INTO versification_data VALUES (NULL, 9, 24, 32, 44);
INSERT INTO versification_data VALUES (NULL, 9, 24, 33, 26);
INSERT INTO versification_data VALUES (NULL, 9, 24, 34, 22);
INSERT INTO versification_data VALUES (NULL, 9, 24, 35, 19);
INSERT INTO versification_data VALUES (NULL, 9, 24, 36, 32);
INSERT INTO versification_data VALUES (NULL, 9, 24, 37, 21);
INSERT INTO versification_data VALUES (NULL, 9, 24, 38, 28);
INSERT INTO versification_data VALUES (NULL, 9, 24, 39, 18);
INSERT INTO versification_data VALUES (NULL, 9, 24, 40, 16);
INSERT INTO versification_data VALUES (NULL, 9, 24, 41, 18);
INSERT INTO versification_data VALUES (NULL, 9, 24, 42, 22);
INSERT INTO versification_data VALUES (NULL, 9, 24, 43, 13);
INSERT INTO versification_data VALUES (NULL, 9, 24, 44, 30);
INSERT INTO versification_data VALUES (NULL, 9, 24, 45, 5);
INSERT INTO versification_data VALUES (NULL, 9, 24, 46, 28);
INSERT INTO versification_data VALUES (NULL, 9, 24, 47, 7);
INSERT INTO versification_data VALUES (NULL, 9, 24, 48, 47);
INSERT INTO versification_data VALUES (NULL, 9, 24, 49, 39);
INSERT INTO versification_data VALUES (NULL, 9, 24, 50, 46);
INSERT INTO versification_data VALUES (NULL, 9, 24, 51, 64);
INSERT INTO versification_data VALUES (NULL, 9, 24, 52, 34);
INSERT INTO versification_data VALUES (NULL, 9, 25, 1, 22);
INSERT INTO versification_data VALUES (NULL, 9, 25, 2, 22);
INSERT INTO versification_data VALUES (NULL, 9, 25, 3, 66);
INSERT INTO versification_data VALUES (NULL, 9, 25, 4, 22);
INSERT INTO versification_data VALUES (NULL, 9, 25, 5, 22);
INSERT INTO versification_data VALUES (NULL, 9, 26, 1, 28);
INSERT INTO versification_data VALUES (NULL, 9, 26, 2, 10);
INSERT INTO versification_data VALUES (NULL, 9, 26, 3, 27);
INSERT INTO versification_data VALUES (NULL, 9, 26, 4, 17);
INSERT INTO versification_data VALUES (NULL, 9, 26, 5, 17);
INSERT INTO versification_data VALUES (NULL, 9, 26, 6, 14);
INSERT INTO versification_data VALUES (NULL, 9, 26, 7, 27);
INSERT INTO versification_data VALUES (NULL, 9, 26, 8, 18);
INSERT INTO versification_data VALUES (NULL, 9, 26, 9, 11);
INSERT INTO versification_data VALUES (NULL, 9, 26, 10, 22);
INSERT INTO versification_data VALUES (NULL, 9, 26, 11, 25);
INSERT INTO versification_data VALUES (NULL, 9, 26, 12, 28);
INSERT INTO versification_data VALUES (NULL, 9, 26, 13, 23);
INSERT INTO versification_data VALUES (NULL, 9, 26, 14, 23);
INSERT INTO versification_data VALUES (NULL, 9, 26, 15, 8);
INSERT INTO versification_data VALUES (NULL, 9, 26, 16, 63);
INSERT INTO versification_data VALUES (NULL, 9, 26, 17, 24);
INSERT INTO versification_data VALUES (NULL, 9, 26, 18, 32);
INSERT INTO versification_data VALUES (NULL, 9, 26, 19, 14);
INSERT INTO versification_data VALUES (NULL, 9, 26, 20, 44);
INSERT INTO versification_data VALUES (NULL, 9, 26, 21, 37);
INSERT INTO versification_data VALUES (NULL, 9, 26, 22, 31);
INSERT INTO versification_data VALUES (NULL, 9, 26, 23, 49);
INSERT INTO versification_data VALUES (NULL, 9, 26, 24, 27);
INSERT INTO versification_data VALUES (NULL, 9, 26, 25, 17);
INSERT INTO versification_data VALUES (NULL, 9, 26, 26, 21);
INSERT INTO versification_data VALUES (NULL, 9, 26, 27, 36);
INSERT INTO versification_data VALUES (NULL, 9, 26, 28, 26);
INSERT INTO versification_data VALUES (NULL, 9, 26, 29, 21);
INSERT INTO versification_data VALUES (NULL, 9, 26, 30, 26);
INSERT INTO versification_data VALUES (NULL, 9, 26, 31, 18);
INSERT INTO versification_data VALUES (NULL, 9, 26, 32, 32);
INSERT INTO versification_data VALUES (NULL, 9, 26, 33, 33);
INSERT INTO versification_data VALUES (NULL, 9, 26, 34, 31);
INSERT INTO versification_data VALUES (NULL, 9, 26, 35, 15);
INSERT INTO versification_data VALUES (NULL, 9, 26, 36, 38);
INSERT INTO versification_data VALUES (NULL, 9, 26, 37, 28);
INSERT INTO versification_data VALUES (NULL, 9, 26, 38, 23);
INSERT INTO versification_data VALUES (NULL, 9, 26, 39, 29);
INSERT INTO versification_data VALUES (NULL, 9, 26, 40, 49);
INSERT INTO versification_data VALUES (NULL, 9, 26, 41, 26);
INSERT INTO versification_data VALUES (NULL, 9, 26, 42, 20);
INSERT INTO versification_data VALUES (NULL, 9, 26, 43, 27);
INSERT INTO versification_data VALUES (NULL, 9, 26, 44, 31);
INSERT INTO versification_data VALUES (NULL, 9, 26, 45, 25);
INSERT INTO versification_data VALUES (NULL, 9, 26, 46, 24);
INSERT INTO versification_data VALUES (NULL, 9, 26, 47, 23);
INSERT INTO versification_data VALUES (NULL, 9, 26, 48, 35);
INSERT INTO versification_data VALUES (NULL, 9, 27, 1, 21);
INSERT INTO versification_data VALUES (NULL, 9, 27, 2, 49);
INSERT INTO versification_data VALUES (NULL, 9, 27, 3, 33);
INSERT INTO versification_data VALUES (NULL, 9, 27, 4, 34);
INSERT INTO versification_data VALUES (NULL, 9, 27, 5, 30);
INSERT INTO versification_data VALUES (NULL, 9, 27, 6, 29);
INSERT INTO versification_data VALUES (NULL, 9, 27, 7, 28);
INSERT INTO versification_data VALUES (NULL, 9, 27, 8, 27);
INSERT INTO versification_data VALUES (NULL, 9, 27, 9, 27);
INSERT INTO versification_data VALUES (NULL, 9, 27, 10, 21);
INSERT INTO versification_data VALUES (NULL, 9, 27, 11, 45);
INSERT INTO versification_data VALUES (NULL, 9, 27, 12, 13);
INSERT INTO versification_data VALUES (NULL, 9, 28, 1, 9);
INSERT INTO versification_data VALUES (NULL, 9, 28, 2, 25);
INSERT INTO versification_data VALUES (NULL, 9, 28, 3, 5);
INSERT INTO versification_data VALUES (NULL, 9, 28, 4, 19);
INSERT INTO versification_data VALUES (NULL, 9, 28, 5, 15);
INSERT INTO versification_data VALUES (NULL, 9, 28, 6, 11);
INSERT INTO versification_data VALUES (NULL, 9, 28, 7, 16);
INSERT INTO versification_data VALUES (NULL, 9, 28, 8, 14);
INSERT INTO versification_data VALUES (NULL, 9, 28, 9, 17);
INSERT INTO versification_data VALUES (NULL, 9, 28, 10, 15);
INSERT INTO versification_data VALUES (NULL, 9, 28, 11, 11);
INSERT INTO versification_data VALUES (NULL, 9, 28, 12, 15);
INSERT INTO versification_data VALUES (NULL, 9, 28, 13, 15);
INSERT INTO versification_data VALUES (NULL, 9, 28, 14, 10);
INSERT INTO versification_data VALUES (NULL, 9, 29, 1, 20);
INSERT INTO versification_data VALUES (NULL, 9, 29, 2, 27);
INSERT INTO versification_data VALUES (NULL, 9, 29, 3, 5);
INSERT INTO versification_data VALUES (NULL, 9, 29, 4, 21);
INSERT INTO versification_data VALUES (NULL, 9, 30, 1, 15);
INSERT INTO versification_data VALUES (NULL, 9, 30, 2, 16);
INSERT INTO versification_data VALUES (NULL, 9, 30, 3, 15);
INSERT INTO versification_data VALUES (NULL, 9, 30, 4, 13);
INSERT INTO versification_data VALUES (NULL, 9, 30, 5, 27);
INSERT INTO versification_data VALUES (NULL, 9, 30, 6, 14);
INSERT INTO versification_data VALUES (NULL, 9, 30, 7, 17);
INSERT INTO versification_data VALUES (NULL, 9, 30, 8, 14);
INSERT INTO versification_data VALUES (NULL, 9, 30, 9, 15);
INSERT INTO versification_data VALUES (NULL, 9, 31, 1, 21);
INSERT INTO versification_data VALUES (NULL, 9, 32, 1, 16);
INSERT INTO versification_data VALUES (NULL, 9, 32, 2, 11);
INSERT INTO versification_data VALUES (NULL, 9, 32, 3, 10);
INSERT INTO versification_data VALUES (NULL, 9, 32, 4, 11);
INSERT INTO versification_data VALUES (NULL, 9, 33, 1, 16);
INSERT INTO versification_data VALUES (NULL, 9, 33, 2, 13);
INSERT INTO versification_data VALUES (NULL, 9, 33, 3, 12);
INSERT INTO versification_data VALUES (NULL, 9, 33, 4, 14);
INSERT INTO versification_data VALUES (NULL, 9, 33, 5, 14);
INSERT INTO versification_data VALUES (NULL, 9, 33, 6, 16);
INSERT INTO versification_data VALUES (NULL, 9, 33, 7, 20);
INSERT INTO versification_data VALUES (NULL, 9, 34, 1, 14);
INSERT INTO versification_data VALUES (NULL, 9, 34, 2, 14);
INSERT INTO versification_data VALUES (NULL, 9, 34, 3, 19);
INSERT INTO versification_data VALUES (NULL, 9, 35, 1, 17);
INSERT INTO versification_data VALUES (NULL, 9, 35, 2, 20);
INSERT INTO versification_data VALUES (NULL, 9, 35, 3, 19);
INSERT INTO versification_data VALUES (NULL, 9, 36, 1, 18);
INSERT INTO versification_data VALUES (NULL, 9, 36, 2, 15);
INSERT INTO versification_data VALUES (NULL, 9, 36, 3, 20);
INSERT INTO versification_data VALUES (NULL, 9, 37, 1, 15);
INSERT INTO versification_data VALUES (NULL, 9, 37, 2, 23);
INSERT INTO versification_data VALUES (NULL, 9, 38, 1, 17);
INSERT INTO versification_data VALUES (NULL, 9, 38, 2, 17);
INSERT INTO versification_data VALUES (NULL, 9, 38, 3, 10);
INSERT INTO versification_data VALUES (NULL, 9, 38, 4, 14);
INSERT INTO versification_data VALUES (NULL, 9, 38, 5, 11);
INSERT INTO versification_data VALUES (NULL, 9, 38, 6, 15);
INSERT INTO versification_data VALUES (NULL, 9, 38, 7, 14);
INSERT INTO versification_data VALUES (NULL, 9, 38, 8, 23);
INSERT INTO versification_data VALUES (NULL, 9, 38, 9, 17);
INSERT INTO versification_data VALUES (NULL, 9, 38, 10, 12);
INSERT INTO versification_data VALUES (NULL, 9, 38, 11, 17);
INSERT INTO versification_data VALUES (NULL, 9, 38, 12, 14);
INSERT INTO versification_data VALUES (NULL, 9, 38, 13, 9);
INSERT INTO versification_data VALUES (NULL, 9, 38, 14, 21);
INSERT INTO versification_data VALUES (NULL, 9, 39, 1, 14);
INSERT INTO versification_data VALUES (NULL, 9, 39, 2, 17);
INSERT INTO versification_data VALUES (NULL, 9, 39, 3, 24);
INSERT INTO versification_data VALUES (NULL, 9, 40, 1, 25);
INSERT INTO versification_data VALUES (NULL, 9, 40, 2, 23);
INSERT INTO versification_data VALUES (NULL, 9, 40, 3, 17);
INSERT INTO versification_data VALUES (NULL, 9, 40, 4, 25);
INSERT INTO versification_data VALUES (NULL, 9, 40, 5, 48);
INSERT INTO versification_data VALUES (NULL, 9, 40, 6, 34);
INSERT INTO versification_data VALUES (NULL, 9, 40, 7, 29);
INSERT INTO versification_data VALUES (NULL, 9, 40, 8, 34);
INSERT INTO versification_data VALUES (NULL, 9, 40, 9, 38);
INSERT INTO versification_data VALUES (NULL, 9, 40, 10, 42);
INSERT INTO versification_data VALUES (NULL, 9, 40, 11, 30);
INSERT INTO versification_data VALUES (NULL, 9, 40, 12, 50);
INSERT INTO versification_data VALUES (NULL, 9, 40, 13, 58);
INSERT INTO versification_data VALUES (NULL, 9, 40, 14, 36);
INSERT INTO versification_data VALUES (NULL, 9, 40, 15, 39);
INSERT INTO versification_data VALUES (NULL, 9, 40, 16, 28);
INSERT INTO versification_data VALUES (NULL, 9, 40, 17, 27);
INSERT INTO versification_data VALUES (NULL, 9, 40, 18, 35);
INSERT INTO versification_data VALUES (NULL, 9, 40, 19, 30);
INSERT INTO versification_data VALUES (NULL, 9, 40, 20, 34);
INSERT INTO versification_data VALUES (NULL, 9, 40, 21, 46);
INSERT INTO versification_data VALUES (NULL, 9, 40, 22, 46);
INSERT INTO versification_data VALUES (NULL, 9, 40, 23, 39);
INSERT INTO versification_data VALUES (NULL, 9, 40, 24, 51);
INSERT INTO versification_data VALUES (NULL, 9, 40, 25, 46);
INSERT INTO versification_data VALUES (NULL, 9, 40, 26, 75);
INSERT INTO versification_data VALUES (NULL, 9, 40, 27, 66);
INSERT INTO versification_data VALUES (NULL, 9, 40, 28, 20);
INSERT INTO versification_data VALUES (NULL, 9, 41, 1, 45);
INSERT INTO versification_data VALUES (NULL, 9, 41, 2, 28);
INSERT INTO versification_data VALUES (NULL, 9, 41, 3, 35);
INSERT INTO versification_data VALUES (NULL, 9, 41, 4, 41);
INSERT INTO versification_data VALUES (NULL, 9, 41, 5, 43);
INSERT INTO versification_data VALUES (NULL, 9, 41, 6, 56);
INSERT INTO versification_data VALUES (NULL, 9, 41, 7, 37);
INSERT INTO versification_data VALUES (NULL, 9, 41, 8, 38);
INSERT INTO versification_data VALUES (NULL, 9, 41, 9, 50);
INSERT INTO versification_data VALUES (NULL, 9, 41, 10, 52);
INSERT INTO versification_data VALUES (NULL, 9, 41, 11, 33);
INSERT INTO versification_data VALUES (NULL, 9, 41, 12, 44);
INSERT INTO versification_data VALUES (NULL, 9, 41, 13, 37);
INSERT INTO versification_data VALUES (NULL, 9, 41, 14, 72);
INSERT INTO versification_data VALUES (NULL, 9, 41, 15, 47);
INSERT INTO versification_data VALUES (NULL, 9, 41, 16, 20);
INSERT INTO versification_data VALUES (NULL, 9, 42, 1, 80);
INSERT INTO versification_data VALUES (NULL, 9, 42, 2, 52);
INSERT INTO versification_data VALUES (NULL, 9, 42, 3, 38);
INSERT INTO versification_data VALUES (NULL, 9, 42, 4, 44);
INSERT INTO versification_data VALUES (NULL, 9, 42, 5, 39);
INSERT INTO versification_data VALUES (NULL, 9, 42, 6, 49);
INSERT INTO versification_data VALUES (NULL, 9, 42, 7, 50);
INSERT INTO versification_data VALUES (NULL, 9, 42, 8, 56);
INSERT INTO versification_data VALUES (NULL, 9, 42, 9, 62);
INSERT INTO versification_data VALUES (NULL, 9, 42, 10, 42);
INSERT INTO versification_data VALUES (NULL, 9, 42, 11, 54);
INSERT INTO versification_data VALUES (NULL, 9, 42, 12, 59);
INSERT INTO versification_data VALUES (NULL, 9, 42, 13, 35);
INSERT INTO versification_data VALUES (NULL, 9, 42, 14, 35);
INSERT INTO versification_data VALUES (NULL, 9, 42, 15, 32);
INSERT INTO versification_data VALUES (NULL, 9, 42, 16, 31);
INSERT INTO versification_data VALUES (NULL, 9, 42, 17, 37);
INSERT INTO versification_data VALUES (NULL, 9, 42, 18, 43);
INSERT INTO versification_data VALUES (NULL, 9, 42, 19, 48);
INSERT INTO versification_data VALUES (NULL, 9, 42, 20, 47);
INSERT INTO versification_data VALUES (NULL, 9, 42, 21, 38);
INSERT INTO versification_data VALUES (NULL, 9, 42, 22, 71);
INSERT INTO versification_data VALUES (NULL, 9, 42, 23, 56);
INSERT INTO versification_data VALUES (NULL, 9, 42, 24, 53);
INSERT INTO versification_data VALUES (NULL, 9, 43, 1, 51);
INSERT INTO versification_data VALUES (NULL, 9, 43, 2, 25);
INSERT INTO versification_data VALUES (NULL, 9, 43, 3, 36);
INSERT INTO versification_data VALUES (NULL, 9, 43, 4, 54);
INSERT INTO versification_data VALUES (NULL, 9, 43, 5, 47);
INSERT INTO versification_data VALUES (NULL, 9, 43, 6, 71);
INSERT INTO versification_data VALUES (NULL, 9, 43, 7, 53);
INSERT INTO versification_data VALUES (NULL, 9, 43, 8, 59);
INSERT INTO versification_data VALUES (NULL, 9, 43, 9, 41);
INSERT INTO versification_data VALUES (NULL, 9, 43, 10, 42);
INSERT INTO versification_data VALUES (NULL, 9, 43, 11, 57);
INSERT INTO versification_data VALUES (NULL, 9, 43, 12, 50);
INSERT INTO versification_data VALUES (NULL, 9, 43, 13, 38);
INSERT INTO versification_data VALUES (NULL, 9, 43, 14, 31);
INSERT INTO versification_data VALUES (NULL, 9, 43, 15, 27);
INSERT INTO versification_data VALUES (NULL, 9, 43, 16, 33);
INSERT INTO versification_data VALUES (NULL, 9, 43, 17, 26);
INSERT INTO versification_data VALUES (NULL, 9, 43, 18, 40);
INSERT INTO versification_data VALUES (NULL, 9, 43, 19, 42);
INSERT INTO versification_data VALUES (NULL, 9, 43, 20, 31);
INSERT INTO versification_data VALUES (NULL, 9, 43, 21, 25);
INSERT INTO versification_data VALUES (NULL, 9, 44, 1, 26);
INSERT INTO versification_data VALUES (NULL, 9, 44, 2, 47);
INSERT INTO versification_data VALUES (NULL, 9, 44, 3, 26);
INSERT INTO versification_data VALUES (NULL, 9, 44, 4, 37);
INSERT INTO versification_data VALUES (NULL, 9, 44, 5, 42);
INSERT INTO versification_data VALUES (NULL, 9, 44, 6, 15);
INSERT INTO versification_data VALUES (NULL, 9, 44, 7, 60);
INSERT INTO versification_data VALUES (NULL, 9, 44, 8, 40);
INSERT INTO versification_data VALUES (NULL, 9, 44, 9, 43);
INSERT INTO versification_data VALUES (NULL, 9, 44, 10, 48);
INSERT INTO versification_data VALUES (NULL, 9, 44, 11, 30);
INSERT INTO versification_data VALUES (NULL, 9, 44, 12, 25);
INSERT INTO versification_data VALUES (NULL, 9, 44, 13, 52);
INSERT INTO versification_data VALUES (NULL, 9, 44, 14, 28);
INSERT INTO versification_data VALUES (NULL, 9, 44, 15, 41);
INSERT INTO versification_data VALUES (NULL, 9, 44, 16, 40);
INSERT INTO versification_data VALUES (NULL, 9, 44, 17, 34);
INSERT INTO versification_data VALUES (NULL, 9, 44, 18, 28);
INSERT INTO versification_data VALUES (NULL, 9, 44, 19, 40);
INSERT INTO versification_data VALUES (NULL, 9, 44, 20, 38);
INSERT INTO versification_data VALUES (NULL, 9, 44, 21, 40);
INSERT INTO versification_data VALUES (NULL, 9, 44, 22, 30);
INSERT INTO versification_data VALUES (NULL, 9, 44, 23, 35);
INSERT INTO versification_data VALUES (NULL, 9, 44, 24, 27);
INSERT INTO versification_data VALUES (NULL, 9, 44, 25, 27);
INSERT INTO versification_data VALUES (NULL, 9, 44, 26, 32);
INSERT INTO versification_data VALUES (NULL, 9, 44, 27, 44);
INSERT INTO versification_data VALUES (NULL, 9, 44, 28, 31);
INSERT INTO versification_data VALUES (NULL, 9, 45, 1, 32);
INSERT INTO versification_data VALUES (NULL, 9, 45, 2, 29);
INSERT INTO versification_data VALUES (NULL, 9, 45, 3, 31);
INSERT INTO versification_data VALUES (NULL, 9, 45, 4, 25);
INSERT INTO versification_data VALUES (NULL, 9, 45, 5, 21);
INSERT INTO versification_data VALUES (NULL, 9, 45, 6, 23);
INSERT INTO versification_data VALUES (NULL, 9, 45, 7, 25);
INSERT INTO versification_data VALUES (NULL, 9, 45, 8, 39);
INSERT INTO versification_data VALUES (NULL, 9, 45, 9, 33);
INSERT INTO versification_data VALUES (NULL, 9, 45, 10, 21);
INSERT INTO versification_data VALUES (NULL, 9, 45, 11, 36);
INSERT INTO versification_data VALUES (NULL, 9, 45, 12, 21);
INSERT INTO versification_data VALUES (NULL, 9, 45, 13, 14);
INSERT INTO versification_data VALUES (NULL, 9, 45, 14, 23);
INSERT INTO versification_data VALUES (NULL, 9, 45, 15, 33);
INSERT INTO versification_data VALUES (NULL, 9, 45, 16, 27);
INSERT INTO versification_data VALUES (NULL, 9, 46, 1, 31);
INSERT INTO versification_data VALUES (NULL, 9, 46, 2, 16);
INSERT INTO versification_data VALUES (NULL, 9, 46, 3, 23);
INSERT INTO versification_data VALUES (NULL, 9, 46, 4, 21);
INSERT INTO versification_data VALUES (NULL, 9, 46, 5, 13);
INSERT INTO versification_data VALUES (NULL, 9, 46, 6, 20);
INSERT INTO versification_data VALUES (NULL, 9, 46, 7, 40);
INSERT INTO versification_data VALUES (NULL, 9, 46, 8, 13);
INSERT INTO versification_data VALUES (NULL, 9, 46, 9, 27);
INSERT INTO versification_data VALUES (NULL, 9, 46, 10, 33);
INSERT INTO versification_data VALUES (NULL, 9, 46, 11, 34);
INSERT INTO versification_data VALUES (NULL, 9, 46, 12, 31);
INSERT INTO versification_data VALUES (NULL, 9, 46, 13, 13);
INSERT INTO versification_data VALUES (NULL, 9, 46, 14, 40);
INSERT INTO versification_data VALUES (NULL, 9, 46, 15, 58);
INSERT INTO versification_data VALUES (NULL, 9, 46, 16, 24);
INSERT INTO versification_data VALUES (NULL, 9, 47, 1, 24);
INSERT INTO versification_data VALUES (NULL, 9, 47, 2, 17);
INSERT INTO versification_data VALUES (NULL, 9, 47, 3, 18);
INSERT INTO versification_data VALUES (NULL, 9, 47, 4, 18);
INSERT INTO versification_data VALUES (NULL, 9, 47, 5, 21);
INSERT INTO versification_data VALUES (NULL, 9, 47, 6, 18);
INSERT INTO versification_data VALUES (NULL, 9, 47, 7, 16);
INSERT INTO versification_data VALUES (NULL, 9, 47, 8, 24);
INSERT INTO versification_data VALUES (NULL, 9, 47, 9, 15);
INSERT INTO versification_data VALUES (NULL, 9, 47, 10, 18);
INSERT INTO versification_data VALUES (NULL, 9, 47, 11, 33);
INSERT INTO versification_data VALUES (NULL, 9, 47, 12, 21);
INSERT INTO versification_data VALUES (NULL, 9, 47, 13, 13);
INSERT INTO versification_data VALUES (NULL, 9, 48, 1, 24);
INSERT INTO versification_data VALUES (NULL, 9, 48, 2, 21);
INSERT INTO versification_data VALUES (NULL, 9, 48, 3, 29);
INSERT INTO versification_data VALUES (NULL, 9, 48, 4, 31);
INSERT INTO versification_data VALUES (NULL, 9, 48, 5, 26);
INSERT INTO versification_data VALUES (NULL, 9, 48, 6, 18);
INSERT INTO versification_data VALUES (NULL, 9, 49, 1, 23);
INSERT INTO versification_data VALUES (NULL, 9, 49, 2, 22);
INSERT INTO versification_data VALUES (NULL, 9, 49, 3, 21);
INSERT INTO versification_data VALUES (NULL, 9, 49, 4, 32);
INSERT INTO versification_data VALUES (NULL, 9, 49, 5, 33);
INSERT INTO versification_data VALUES (NULL, 9, 49, 6, 24);
INSERT INTO versification_data VALUES (NULL, 9, 50, 1, 30);
INSERT INTO versification_data VALUES (NULL, 9, 50, 2, 30);
INSERT INTO versification_data VALUES (NULL, 9, 50, 3, 21);
INSERT INTO versification_data VALUES (NULL, 9, 50, 4, 23);
INSERT INTO versification_data VALUES (NULL, 9, 51, 1, 29);
INSERT INTO versification_data VALUES (NULL, 9, 51, 2, 23);
INSERT INTO versification_data VALUES (NULL, 9, 51, 3, 25);
INSERT INTO versification_data VALUES (NULL, 9, 51, 4, 18);
INSERT INTO versification_data VALUES (NULL, 9, 52, 1, 10);
INSERT INTO versification_data VALUES (NULL, 9, 52, 2, 20);
INSERT INTO versification_data VALUES (NULL, 9, 52, 3, 13);
INSERT INTO versification_data VALUES (NULL, 9, 52, 4, 18);
INSERT INTO versification_data VALUES (NULL, 9, 52, 5, 28);
INSERT INTO versification_data VALUES (NULL, 9, 53, 1, 12);
INSERT INTO versification_data VALUES (NULL, 9, 53, 2, 17);
INSERT INTO versification_data VALUES (NULL, 9, 53, 3, 18);
INSERT INTO versification_data VALUES (NULL, 9, 54, 1, 20);
INSERT INTO versification_data VALUES (NULL, 9, 54, 2, 15);
INSERT INTO versification_data VALUES (NULL, 9, 54, 3, 16);
INSERT INTO versification_data VALUES (NULL, 9, 54, 4, 16);
INSERT INTO versification_data VALUES (NULL, 9, 54, 5, 25);
INSERT INTO versification_data VALUES (NULL, 9, 54, 6, 21);
INSERT INTO versification_data VALUES (NULL, 9, 55, 1, 18);
INSERT INTO versification_data VALUES (NULL, 9, 55, 2, 26);
INSERT INTO versification_data VALUES (NULL, 9, 55, 3, 17);
INSERT INTO versification_data VALUES (NULL, 9, 55, 4, 22);
INSERT INTO versification_data VALUES (NULL, 9, 56, 1, 16);
INSERT INTO versification_data VALUES (NULL, 9, 56, 2, 15);
INSERT INTO versification_data VALUES (NULL, 9, 56, 3, 15);
INSERT INTO versification_data VALUES (NULL, 9, 57, 1, 25);
INSERT INTO versification_data VALUES (NULL, 9, 58, 1, 14);
INSERT INTO versification_data VALUES (NULL, 9, 58, 2, 18);
INSERT INTO versification_data VALUES (NULL, 9, 58, 3, 19);
INSERT INTO versification_data VALUES (NULL, 9, 58, 4, 16);
INSERT INTO versification_data VALUES (NULL, 9, 58, 5, 14);
INSERT INTO versification_data VALUES (NULL, 9, 58, 6, 20);
INSERT INTO versification_data VALUES (NULL, 9, 58, 7, 28);
INSERT INTO versification_data VALUES (NULL, 9, 58, 8, 13);
INSERT INTO versification_data VALUES (NULL, 9, 58, 9, 28);
INSERT INTO versification_data VALUES (NULL, 9, 58, 10, 39);
INSERT INTO versification_data VALUES (NULL, 9, 58, 11, 40);
INSERT INTO versification_data VALUES (NULL, 9, 58, 12, 29);
INSERT INTO versification_data VALUES (NULL, 9, 58, 13, 25);
INSERT INTO versification_data VALUES (NULL, 9, 59, 1, 27);
INSERT INTO versification_data VALUES (NULL, 9, 59, 2, 26);
INSERT INTO versification_data VALUES (NULL, 9, 59, 3, 18);
INSERT INTO versification_data VALUES (NULL, 9, 59, 4, 17);
INSERT INTO versification_data VALUES (NULL, 9, 59, 5, 20);
INSERT INTO versification_data VALUES (NULL, 9, 60, 1, 25);
INSERT INTO versification_data VALUES (NULL, 9, 60, 2, 25);
INSERT INTO versification_data VALUES (NULL, 9, 60, 3, 22);
INSERT INTO versification_data VALUES (NULL, 9, 60, 4, 19);
INSERT INTO versification_data VALUES (NULL, 9, 60, 5, 14);
INSERT INTO versification_data VALUES (NULL, 9, 61, 1, 21);
INSERT INTO versification_data VALUES (NULL, 9, 61, 2, 22);
INSERT INTO versification_data VALUES (NULL, 9, 61, 3, 18);
INSERT INTO versification_data VALUES (NULL, 9, 62, 1, 10);
INSERT INTO versification_data VALUES (NULL, 9, 62, 2, 29);
INSERT INTO versification_data VALUES (NULL, 9, 62, 3, 24);
INSERT INTO versification_data VALUES (NULL, 9, 62, 4, 21);
INSERT INTO versification_data VALUES (NULL, 9, 62, 5, 21);
INSERT INTO versification_data VALUES (NULL, 9, 63, 1, 13);
INSERT INTO versification_data VALUES (NULL, 9, 64, 1, 15);
INSERT INTO versification_data VALUES (NULL, 9, 65, 1, 25);
INSERT INTO versification_data VALUES (NULL, 9, 66, 1, 20);
INSERT INTO versification_data VALUES (NULL, 9, 66, 2, 29);
INSERT INTO versification_data VALUES (NULL, 9, 66, 3, 22);
INSERT INTO versification_data VALUES (NULL, 9, 66, 4, 11);
INSERT INTO versification_data VALUES (NULL, 9, 66, 5, 14);
INSERT INTO versification_data VALUES (NULL, 9, 66, 6, 17);
INSERT INTO versification_data VALUES (NULL, 9, 66, 7, 17);
INSERT INTO versification_data VALUES (NULL, 9, 66, 8, 13);
INSERT INTO versification_data VALUES (NULL, 9, 66, 9, 21);
INSERT INTO versification_data VALUES (NULL, 9, 66, 10, 11);
INSERT INTO versification_data VALUES (NULL, 9, 66, 11, 19);
INSERT INTO versification_data VALUES (NULL, 9, 66, 12, 18);
INSERT INTO versification_data VALUES (NULL, 9, 66, 13, 18);
INSERT INTO versification_data VALUES (NULL, 9, 66, 14, 20);
INSERT INTO versification_data VALUES (NULL, 9, 66, 15, 8);
INSERT INTO versification_data VALUES (NULL, 9, 66, 16, 21);
INSERT INTO versification_data VALUES (NULL, 9, 66, 17, 18);
INSERT INTO versification_data VALUES (NULL, 9, 66, 18, 24);
INSERT INTO versification_data VALUES (NULL, 9, 66, 19, 21);
INSERT INTO versification_data VALUES (NULL, 9, 66, 20, 15);
INSERT INTO versification_data VALUES (NULL, 9, 66, 21, 27);
INSERT INTO versification_data VALUES (NULL, 9, 66, 22, 21);

INSERT INTO versification_names VALUES (10, 'Staten Bible');

INSERT INTO versification_data VALUES (NULL, 10, 1, 1, 31);
INSERT INTO versification_data VALUES (NULL, 10, 1, 2, 25);
INSERT INTO versification_data VALUES (NULL, 10, 1, 3, 24);
INSERT INTO versification_data VALUES (NULL, 10, 1, 4, 26);
INSERT INTO versification_data VALUES (NULL, 10, 1, 5, 32);
INSERT INTO versification_data VALUES (NULL, 10, 1, 6, 22);
INSERT INTO versification_data VALUES (NULL, 10, 1, 7, 24);
INSERT INTO versification_data VALUES (NULL, 10, 1, 8, 22);
INSERT INTO versification_data VALUES (NULL, 10, 1, 9, 29);
INSERT INTO versification_data VALUES (NULL, 10, 1, 10, 32);
INSERT INTO versification_data VALUES (NULL, 10, 1, 11, 32);
INSERT INTO versification_data VALUES (NULL, 10, 1, 12, 20);
INSERT INTO versification_data VALUES (NULL, 10, 1, 13, 18);
INSERT INTO versification_data VALUES (NULL, 10, 1, 14, 24);
INSERT INTO versification_data VALUES (NULL, 10, 1, 15, 21);
INSERT INTO versification_data VALUES (NULL, 10, 1, 16, 16);
INSERT INTO versification_data VALUES (NULL, 10, 1, 17, 27);
INSERT INTO versification_data VALUES (NULL, 10, 1, 18, 33);
INSERT INTO versification_data VALUES (NULL, 10, 1, 19, 38);
INSERT INTO versification_data VALUES (NULL, 10, 1, 20, 18);
INSERT INTO versification_data VALUES (NULL, 10, 1, 21, 34);
INSERT INTO versification_data VALUES (NULL, 10, 1, 22, 24);
INSERT INTO versification_data VALUES (NULL, 10, 1, 23, 20);
INSERT INTO versification_data VALUES (NULL, 10, 1, 24, 67);
INSERT INTO versification_data VALUES (NULL, 10, 1, 25, 34);
INSERT INTO versification_data VALUES (NULL, 10, 1, 26, 35);
INSERT INTO versification_data VALUES (NULL, 10, 1, 27, 46);
INSERT INTO versification_data VALUES (NULL, 10, 1, 28, 22);
INSERT INTO versification_data VALUES (NULL, 10, 1, 29, 35);
INSERT INTO versification_data VALUES (NULL, 10, 1, 30, 43);
INSERT INTO versification_data VALUES (NULL, 10, 1, 31, 55);
INSERT INTO versification_data VALUES (NULL, 10, 1, 32, 32);
INSERT INTO versification_data VALUES (NULL, 10, 1, 33, 20);
INSERT INTO versification_data VALUES (NULL, 10, 1, 34, 31);
INSERT INTO versification_data VALUES (NULL, 10, 1, 35, 29);
INSERT INTO versification_data VALUES (NULL, 10, 1, 36, 43);
INSERT INTO versification_data VALUES (NULL, 10, 1, 37, 36);
INSERT INTO versification_data VALUES (NULL, 10, 1, 38, 30);
INSERT INTO versification_data VALUES (NULL, 10, 1, 39, 23);
INSERT INTO versification_data VALUES (NULL, 10, 1, 40, 23);
INSERT INTO versification_data VALUES (NULL, 10, 1, 41, 57);
INSERT INTO versification_data VALUES (NULL, 10, 1, 42, 38);
INSERT INTO versification_data VALUES (NULL, 10, 1, 43, 34);
INSERT INTO versification_data VALUES (NULL, 10, 1, 44, 34);
INSERT INTO versification_data VALUES (NULL, 10, 1, 45, 28);
INSERT INTO versification_data VALUES (NULL, 10, 1, 46, 34);
INSERT INTO versification_data VALUES (NULL, 10, 1, 47, 31);
INSERT INTO versification_data VALUES (NULL, 10, 1, 48, 22);
INSERT INTO versification_data VALUES (NULL, 10, 1, 49, 33);
INSERT INTO versification_data VALUES (NULL, 10, 1, 50, 26);
INSERT INTO versification_data VALUES (NULL, 10, 2, 1, 22);
INSERT INTO versification_data VALUES (NULL, 10, 2, 2, 25);
INSERT INTO versification_data VALUES (NULL, 10, 2, 3, 22);
INSERT INTO versification_data VALUES (NULL, 10, 2, 4, 31);
INSERT INTO versification_data VALUES (NULL, 10, 2, 5, 24);
INSERT INTO versification_data VALUES (NULL, 10, 2, 6, 29);
INSERT INTO versification_data VALUES (NULL, 10, 2, 7, 25);
INSERT INTO versification_data VALUES (NULL, 10, 2, 8, 32);
INSERT INTO versification_data VALUES (NULL, 10, 2, 9, 35);
INSERT INTO versification_data VALUES (NULL, 10, 2, 10, 29);
INSERT INTO versification_data VALUES (NULL, 10, 2, 11, 10);
INSERT INTO versification_data VALUES (NULL, 10, 2, 12, 51);
INSERT INTO versification_data VALUES (NULL, 10, 2, 13, 22);
INSERT INTO versification_data VALUES (NULL, 10, 2, 14, 31);
INSERT INTO versification_data VALUES (NULL, 10, 2, 15, 27);
INSERT INTO versification_data VALUES (NULL, 10, 2, 16, 36);
INSERT INTO versification_data VALUES (NULL, 10, 2, 17, 16);
INSERT INTO versification_data VALUES (NULL, 10, 2, 18, 27);
INSERT INTO versification_data VALUES (NULL, 10, 2, 19, 25);
INSERT INTO versification_data VALUES (NULL, 10, 2, 20, 26);
INSERT INTO versification_data VALUES (NULL, 10, 2, 21, 36);
INSERT INTO versification_data VALUES (NULL, 10, 2, 22, 31);
INSERT INTO versification_data VALUES (NULL, 10, 2, 23, 33);
INSERT INTO versification_data VALUES (NULL, 10, 2, 24, 18);
INSERT INTO versification_data VALUES (NULL, 10, 2, 25, 40);
INSERT INTO versification_data VALUES (NULL, 10, 2, 26, 37);
INSERT INTO versification_data VALUES (NULL, 10, 2, 27, 21);
INSERT INTO versification_data VALUES (NULL, 10, 2, 28, 43);
INSERT INTO versification_data VALUES (NULL, 10, 2, 29, 46);
INSERT INTO versification_data VALUES (NULL, 10, 2, 30, 38);
INSERT INTO versification_data VALUES (NULL, 10, 2, 31, 18);
INSERT INTO versification_data VALUES (NULL, 10, 2, 32, 35);
INSERT INTO versification_data VALUES (NULL, 10, 2, 33, 23);
INSERT INTO versification_data VALUES (NULL, 10, 2, 34, 35);
INSERT INTO versification_data VALUES (NULL, 10, 2, 35, 35);
INSERT INTO versification_data VALUES (NULL, 10, 2, 36, 38);
INSERT INTO versification_data VALUES (NULL, 10, 2, 37, 29);
INSERT INTO versification_data VALUES (NULL, 10, 2, 38, 31);
INSERT INTO versification_data VALUES (NULL, 10, 2, 39, 43);
INSERT INTO versification_data VALUES (NULL, 10, 2, 40, 38);
INSERT INTO versification_data VALUES (NULL, 10, 3, 1, 17);
INSERT INTO versification_data VALUES (NULL, 10, 3, 2, 16);
INSERT INTO versification_data VALUES (NULL, 10, 3, 3, 17);
INSERT INTO versification_data VALUES (NULL, 10, 3, 4, 35);
INSERT INTO versification_data VALUES (NULL, 10, 3, 5, 19);
INSERT INTO versification_data VALUES (NULL, 10, 3, 6, 30);
INSERT INTO versification_data VALUES (NULL, 10, 3, 7, 38);
INSERT INTO versification_data VALUES (NULL, 10, 3, 8, 36);
INSERT INTO versification_data VALUES (NULL, 10, 3, 9, 24);
INSERT INTO versification_data VALUES (NULL, 10, 3, 10, 20);
INSERT INTO versification_data VALUES (NULL, 10, 3, 11, 47);
INSERT INTO versification_data VALUES (NULL, 10, 3, 12, 8);
INSERT INTO versification_data VALUES (NULL, 10, 3, 13, 59);
INSERT INTO versification_data VALUES (NULL, 10, 3, 14, 57);
INSERT INTO versification_data VALUES (NULL, 10, 3, 15, 33);
INSERT INTO versification_data VALUES (NULL, 10, 3, 16, 34);
INSERT INTO versification_data VALUES (NULL, 10, 3, 17, 16);
INSERT INTO versification_data VALUES (NULL, 10, 3, 18, 30);
INSERT INTO versification_data VALUES (NULL, 10, 3, 19, 37);
INSERT INTO versification_data VALUES (NULL, 10, 3, 20, 27);
INSERT INTO versification_data VALUES (NULL, 10, 3, 21, 24);
INSERT INTO versification_data VALUES (NULL, 10, 3, 22, 33);
INSERT INTO versification_data VALUES (NULL, 10, 3, 23, 44);
INSERT INTO versification_data VALUES (NULL, 10, 3, 24, 23);
INSERT INTO versification_data VALUES (NULL, 10, 3, 25, 55);
INSERT INTO versification_data VALUES (NULL, 10, 3, 26, 46);
INSERT INTO versification_data VALUES (NULL, 10, 3, 27, 34);
INSERT INTO versification_data VALUES (NULL, 10, 4, 1, 54);
INSERT INTO versification_data VALUES (NULL, 10, 4, 2, 34);
INSERT INTO versification_data VALUES (NULL, 10, 4, 3, 51);
INSERT INTO versification_data VALUES (NULL, 10, 4, 4, 49);
INSERT INTO versification_data VALUES (NULL, 10, 4, 5, 31);
INSERT INTO versification_data VALUES (NULL, 10, 4, 6, 27);
INSERT INTO versification_data VALUES (NULL, 10, 4, 7, 89);
INSERT INTO versification_data VALUES (NULL, 10, 4, 8, 26);
INSERT INTO versification_data VALUES (NULL, 10, 4, 9, 23);
INSERT INTO versification_data VALUES (NULL, 10, 4, 10, 36);
INSERT INTO versification_data VALUES (NULL, 10, 4, 11, 35);
INSERT INTO versification_data VALUES (NULL, 10, 4, 12, 16);
INSERT INTO versification_data VALUES (NULL, 10, 4, 13, 33);
INSERT INTO versification_data VALUES (NULL, 10, 4, 14, 45);
INSERT INTO versification_data VALUES (NULL, 10, 4, 15, 41);
INSERT INTO versification_data VALUES (NULL, 10, 4, 16, 50);
INSERT INTO versification_data VALUES (NULL, 10, 4, 17, 13);
INSERT INTO versification_data VALUES (NULL, 10, 4, 18, 32);
INSERT INTO versification_data VALUES (NULL, 10, 4, 19, 22);
INSERT INTO versification_data VALUES (NULL, 10, 4, 20, 29);
INSERT INTO versification_data VALUES (NULL, 10, 4, 21, 35);
INSERT INTO versification_data VALUES (NULL, 10, 4, 22, 41);
INSERT INTO versification_data VALUES (NULL, 10, 4, 23, 30);
INSERT INTO versification_data VALUES (NULL, 10, 4, 24, 25);
INSERT INTO versification_data VALUES (NULL, 10, 4, 25, 18);
INSERT INTO versification_data VALUES (NULL, 10, 4, 26, 65);
INSERT INTO versification_data VALUES (NULL, 10, 4, 27, 23);
INSERT INTO versification_data VALUES (NULL, 10, 4, 28, 31);
INSERT INTO versification_data VALUES (NULL, 10, 4, 29, 40);
INSERT INTO versification_data VALUES (NULL, 10, 4, 30, 16);
INSERT INTO versification_data VALUES (NULL, 10, 4, 31, 54);
INSERT INTO versification_data VALUES (NULL, 10, 4, 32, 42);
INSERT INTO versification_data VALUES (NULL, 10, 4, 33, 56);
INSERT INTO versification_data VALUES (NULL, 10, 4, 34, 29);
INSERT INTO versification_data VALUES (NULL, 10, 4, 35, 34);
INSERT INTO versification_data VALUES (NULL, 10, 4, 36, 13);
INSERT INTO versification_data VALUES (NULL, 10, 5, 1, 46);
INSERT INTO versification_data VALUES (NULL, 10, 5, 2, 37);
INSERT INTO versification_data VALUES (NULL, 10, 5, 3, 29);
INSERT INTO versification_data VALUES (NULL, 10, 5, 4, 49);
INSERT INTO versification_data VALUES (NULL, 10, 5, 5, 33);
INSERT INTO versification_data VALUES (NULL, 10, 5, 6, 25);
INSERT INTO versification_data VALUES (NULL, 10, 5, 7, 26);
INSERT INTO versification_data VALUES (NULL, 10, 5, 8, 20);
INSERT INTO versification_data VALUES (NULL, 10, 5, 9, 29);
INSERT INTO versification_data VALUES (NULL, 10, 5, 10, 22);
INSERT INTO versification_data VALUES (NULL, 10, 5, 11, 32);
INSERT INTO versification_data VALUES (NULL, 10, 5, 12, 32);
INSERT INTO versification_data VALUES (NULL, 10, 5, 13, 18);
INSERT INTO versification_data VALUES (NULL, 10, 5, 14, 29);
INSERT INTO versification_data VALUES (NULL, 10, 5, 15, 23);
INSERT INTO versification_data VALUES (NULL, 10, 5, 16, 22);
INSERT INTO versification_data VALUES (NULL, 10, 5, 17, 20);
INSERT INTO versification_data VALUES (NULL, 10, 5, 18, 22);
INSERT INTO versification_data VALUES (NULL, 10, 5, 19, 21);
INSERT INTO versification_data VALUES (NULL, 10, 5, 20, 20);
INSERT INTO versification_data VALUES (NULL, 10, 5, 21, 23);
INSERT INTO versification_data VALUES (NULL, 10, 5, 22, 30);
INSERT INTO versification_data VALUES (NULL, 10, 5, 23, 25);
INSERT INTO versification_data VALUES (NULL, 10, 5, 24, 22);
INSERT INTO versification_data VALUES (NULL, 10, 5, 25, 19);
INSERT INTO versification_data VALUES (NULL, 10, 5, 26, 19);
INSERT INTO versification_data VALUES (NULL, 10, 5, 27, 26);
INSERT INTO versification_data VALUES (NULL, 10, 5, 28, 68);
INSERT INTO versification_data VALUES (NULL, 10, 5, 29, 29);
INSERT INTO versification_data VALUES (NULL, 10, 5, 30, 20);
INSERT INTO versification_data VALUES (NULL, 10, 5, 31, 30);
INSERT INTO versification_data VALUES (NULL, 10, 5, 32, 52);
INSERT INTO versification_data VALUES (NULL, 10, 5, 33, 29);
INSERT INTO versification_data VALUES (NULL, 10, 5, 34, 12);
INSERT INTO versification_data VALUES (NULL, 10, 6, 1, 18);
INSERT INTO versification_data VALUES (NULL, 10, 6, 2, 24);
INSERT INTO versification_data VALUES (NULL, 10, 6, 3, 17);
INSERT INTO versification_data VALUES (NULL, 10, 6, 4, 24);
INSERT INTO versification_data VALUES (NULL, 10, 6, 5, 15);
INSERT INTO versification_data VALUES (NULL, 10, 6, 6, 27);
INSERT INTO versification_data VALUES (NULL, 10, 6, 7, 26);
INSERT INTO versification_data VALUES (NULL, 10, 6, 8, 35);
INSERT INTO versification_data VALUES (NULL, 10, 6, 9, 27);
INSERT INTO versification_data VALUES (NULL, 10, 6, 10, 43);
INSERT INTO versification_data VALUES (NULL, 10, 6, 11, 23);
INSERT INTO versification_data VALUES (NULL, 10, 6, 12, 24);
INSERT INTO versification_data VALUES (NULL, 10, 6, 13, 33);
INSERT INTO versification_data VALUES (NULL, 10, 6, 14, 15);
INSERT INTO versification_data VALUES (NULL, 10, 6, 15, 63);
INSERT INTO versification_data VALUES (NULL, 10, 6, 16, 10);
INSERT INTO versification_data VALUES (NULL, 10, 6, 17, 18);
INSERT INTO versification_data VALUES (NULL, 10, 6, 18, 28);
INSERT INTO versification_data VALUES (NULL, 10, 6, 19, 51);
INSERT INTO versification_data VALUES (NULL, 10, 6, 20, 9);
INSERT INTO versification_data VALUES (NULL, 10, 6, 21, 45);
INSERT INTO versification_data VALUES (NULL, 10, 6, 22, 34);
INSERT INTO versification_data VALUES (NULL, 10, 6, 23, 16);
INSERT INTO versification_data VALUES (NULL, 10, 6, 24, 33);
INSERT INTO versification_data VALUES (NULL, 10, 7, 1, 36);
INSERT INTO versification_data VALUES (NULL, 10, 7, 2, 23);
INSERT INTO versification_data VALUES (NULL, 10, 7, 3, 31);
INSERT INTO versification_data VALUES (NULL, 10, 7, 4, 24);
INSERT INTO versification_data VALUES (NULL, 10, 7, 5, 31);
INSERT INTO versification_data VALUES (NULL, 10, 7, 6, 40);
INSERT INTO versification_data VALUES (NULL, 10, 7, 7, 25);
INSERT INTO versification_data VALUES (NULL, 10, 7, 8, 35);
INSERT INTO versification_data VALUES (NULL, 10, 7, 9, 57);
INSERT INTO versification_data VALUES (NULL, 10, 7, 10, 18);
INSERT INTO versification_data VALUES (NULL, 10, 7, 11, 40);
INSERT INTO versification_data VALUES (NULL, 10, 7, 12, 15);
INSERT INTO versification_data VALUES (NULL, 10, 7, 13, 25);
INSERT INTO versification_data VALUES (NULL, 10, 7, 14, 20);
INSERT INTO versification_data VALUES (NULL, 10, 7, 15, 20);
INSERT INTO versification_data VALUES (NULL, 10, 7, 16, 31);
INSERT INTO versification_data VALUES (NULL, 10, 7, 17, 13);
INSERT INTO versification_data VALUES (NULL, 10, 7, 18, 31);
INSERT INTO versification_data VALUES (NULL, 10, 7, 19, 30);
INSERT INTO versification_data VALUES (NULL, 10, 7, 20, 48);
INSERT INTO versification_data VALUES (NULL, 10, 7, 21, 25);
INSERT INTO versification_data VALUES (NULL, 10, 8, 1, 22);
INSERT INTO versification_data VALUES (NULL, 10, 8, 2, 23);
INSERT INTO versification_data VALUES (NULL, 10, 8, 3, 18);
INSERT INTO versification_data VALUES (NULL, 10, 8, 4, 22);
INSERT INTO versification_data VALUES (NULL, 10, 9, 1, 28);
INSERT INTO versification_data VALUES (NULL, 10, 9, 2, 36);
INSERT INTO versification_data VALUES (NULL, 10, 9, 3, 21);
INSERT INTO versification_data VALUES (NULL, 10, 9, 4, 22);
INSERT INTO versification_data VALUES (NULL, 10, 9, 5, 12);
INSERT INTO versification_data VALUES (NULL, 10, 9, 6, 21);
INSERT INTO versification_data VALUES (NULL, 10, 9, 7, 17);
INSERT INTO versification_data VALUES (NULL, 10, 9, 8, 22);
INSERT INTO versification_data VALUES (NULL, 10, 9, 9, 27);
INSERT INTO versification_data VALUES (NULL, 10, 9, 10, 27);
INSERT INTO versification_data VALUES (NULL, 10, 9, 11, 15);
INSERT INTO versification_data VALUES (NULL, 10, 9, 12, 25);
INSERT INTO versification_data VALUES (NULL, 10, 9, 13, 23);
INSERT INTO versification_data VALUES (NULL, 10, 9, 14, 52);
INSERT INTO versification_data VALUES (NULL, 10, 9, 15, 35);
INSERT INTO versification_data VALUES (NULL, 10, 9, 16, 23);
INSERT INTO versification_data VALUES (NULL, 10, 9, 17, 58);
INSERT INTO versification_data VALUES (NULL, 10, 9, 18, 30);
INSERT INTO versification_data VALUES (NULL, 10, 9, 19, 24);
INSERT INTO versification_data VALUES (NULL, 10, 9, 20, 43);
INSERT INTO versification_data VALUES (NULL, 10, 9, 21, 15);
INSERT INTO versification_data VALUES (NULL, 10, 9, 22, 23);
INSERT INTO versification_data VALUES (NULL, 10, 9, 23, 28);
INSERT INTO versification_data VALUES (NULL, 10, 9, 24, 23);
INSERT INTO versification_data VALUES (NULL, 10, 9, 25, 44);
INSERT INTO versification_data VALUES (NULL, 10, 9, 26, 25);
INSERT INTO versification_data VALUES (NULL, 10, 9, 27, 12);
INSERT INTO versification_data VALUES (NULL, 10, 9, 28, 25);
INSERT INTO versification_data VALUES (NULL, 10, 9, 29, 11);
INSERT INTO versification_data VALUES (NULL, 10, 9, 30, 31);
INSERT INTO versification_data VALUES (NULL, 10, 9, 31, 13);
INSERT INTO versification_data VALUES (NULL, 10, 10, 1, 27);
INSERT INTO versification_data VALUES (NULL, 10, 10, 2, 32);
INSERT INTO versification_data VALUES (NULL, 10, 10, 3, 39);
INSERT INTO versification_data VALUES (NULL, 10, 10, 4, 12);
INSERT INTO versification_data VALUES (NULL, 10, 10, 5, 25);
INSERT INTO versification_data VALUES (NULL, 10, 10, 6, 23);
INSERT INTO versification_data VALUES (NULL, 10, 10, 7, 29);
INSERT INTO versification_data VALUES (NULL, 10, 10, 8, 18);
INSERT INTO versification_data VALUES (NULL, 10, 10, 9, 13);
INSERT INTO versification_data VALUES (NULL, 10, 10, 10, 19);
INSERT INTO versification_data VALUES (NULL, 10, 10, 11, 27);
INSERT INTO versification_data VALUES (NULL, 10, 10, 12, 31);
INSERT INTO versification_data VALUES (NULL, 10, 10, 13, 39);
INSERT INTO versification_data VALUES (NULL, 10, 10, 14, 33);
INSERT INTO versification_data VALUES (NULL, 10, 10, 15, 37);
INSERT INTO versification_data VALUES (NULL, 10, 10, 16, 23);
INSERT INTO versification_data VALUES (NULL, 10, 10, 17, 29);
INSERT INTO versification_data VALUES (NULL, 10, 10, 18, 33);
INSERT INTO versification_data VALUES (NULL, 10, 10, 19, 43);
INSERT INTO versification_data VALUES (NULL, 10, 10, 20, 26);
INSERT INTO versification_data VALUES (NULL, 10, 10, 21, 22);
INSERT INTO versification_data VALUES (NULL, 10, 10, 22, 51);
INSERT INTO versification_data VALUES (NULL, 10, 10, 23, 39);
INSERT INTO versification_data VALUES (NULL, 10, 10, 24, 25);
INSERT INTO versification_data VALUES (NULL, 10, 11, 1, 53);
INSERT INTO versification_data VALUES (NULL, 10, 11, 2, 46);
INSERT INTO versification_data VALUES (NULL, 10, 11, 3, 28);
INSERT INTO versification_data VALUES (NULL, 10, 11, 4, 34);
INSERT INTO versification_data VALUES (NULL, 10, 11, 5, 18);
INSERT INTO versification_data VALUES (NULL, 10, 11, 6, 38);
INSERT INTO versification_data VALUES (NULL, 10, 11, 7, 51);
INSERT INTO versification_data VALUES (NULL, 10, 11, 8, 66);
INSERT INTO versification_data VALUES (NULL, 10, 11, 9, 28);
INSERT INTO versification_data VALUES (NULL, 10, 11, 10, 29);
INSERT INTO versification_data VALUES (NULL, 10, 11, 11, 43);
INSERT INTO versification_data VALUES (NULL, 10, 11, 12, 33);
INSERT INTO versification_data VALUES (NULL, 10, 11, 13, 34);
INSERT INTO versification_data VALUES (NULL, 10, 11, 14, 31);
INSERT INTO versification_data VALUES (NULL, 10, 11, 15, 34);
INSERT INTO versification_data VALUES (NULL, 10, 11, 16, 34);
INSERT INTO versification_data VALUES (NULL, 10, 11, 17, 24);
INSERT INTO versification_data VALUES (NULL, 10, 11, 18, 46);
INSERT INTO versification_data VALUES (NULL, 10, 11, 19, 21);
INSERT INTO versification_data VALUES (NULL, 10, 11, 20, 43);
INSERT INTO versification_data VALUES (NULL, 10, 11, 21, 29);
INSERT INTO versification_data VALUES (NULL, 10, 11, 22, 54);
INSERT INTO versification_data VALUES (NULL, 10, 12, 1, 18);
INSERT INTO versification_data VALUES (NULL, 10, 12, 2, 25);
INSERT INTO versification_data VALUES (NULL, 10, 12, 3, 27);
INSERT INTO versification_data VALUES (NULL, 10, 12, 4, 44);
INSERT INTO versification_data VALUES (NULL, 10, 12, 5, 27);
INSERT INTO versification_data VALUES (NULL, 10, 12, 6, 33);
INSERT INTO versification_data VALUES (NULL, 10, 12, 7, 20);
INSERT INTO versification_data VALUES (NULL, 10, 12, 8, 29);
INSERT INTO versification_data VALUES (NULL, 10, 12, 9, 37);
INSERT INTO versification_data VALUES (NULL, 10, 12, 10, 36);
INSERT INTO versification_data VALUES (NULL, 10, 12, 11, 21);
INSERT INTO versification_data VALUES (NULL, 10, 12, 12, 21);
INSERT INTO versification_data VALUES (NULL, 10, 12, 13, 25);
INSERT INTO versification_data VALUES (NULL, 10, 12, 14, 29);
INSERT INTO versification_data VALUES (NULL, 10, 12, 15, 38);
INSERT INTO versification_data VALUES (NULL, 10, 12, 16, 20);
INSERT INTO versification_data VALUES (NULL, 10, 12, 17, 41);
INSERT INTO versification_data VALUES (NULL, 10, 12, 18, 37);
INSERT INTO versification_data VALUES (NULL, 10, 12, 19, 37);
INSERT INTO versification_data VALUES (NULL, 10, 12, 20, 21);
INSERT INTO versification_data VALUES (NULL, 10, 12, 21, 26);
INSERT INTO versification_data VALUES (NULL, 10, 12, 22, 20);
INSERT INTO versification_data VALUES (NULL, 10, 12, 23, 37);
INSERT INTO versification_data VALUES (NULL, 10, 12, 24, 20);
INSERT INTO versification_data VALUES (NULL, 10, 12, 25, 30);
INSERT INTO versification_data VALUES (NULL, 10, 13, 1, 54);
INSERT INTO versification_data VALUES (NULL, 10, 13, 2, 55);
INSERT INTO versification_data VALUES (NULL, 10, 13, 3, 24);
INSERT INTO versification_data VALUES (NULL, 10, 13, 4, 43);
INSERT INTO versification_data VALUES (NULL, 10, 13, 5, 26);
INSERT INTO versification_data VALUES (NULL, 10, 13, 6, 81);
INSERT INTO versification_data VALUES (NULL, 10, 13, 7, 40);
INSERT INTO versification_data VALUES (NULL, 10, 13, 8, 40);
INSERT INTO versification_data VALUES (NULL, 10, 13, 9, 44);
INSERT INTO versification_data VALUES (NULL, 10, 13, 10, 14);
INSERT INTO versification_data VALUES (NULL, 10, 13, 11, 47);
INSERT INTO versification_data VALUES (NULL, 10, 13, 12, 40);
INSERT INTO versification_data VALUES (NULL, 10, 13, 13, 14);
INSERT INTO versification_data VALUES (NULL, 10, 13, 14, 17);
INSERT INTO versification_data VALUES (NULL, 10, 13, 15, 29);
INSERT INTO versification_data VALUES (NULL, 10, 13, 16, 43);
INSERT INTO versification_data VALUES (NULL, 10, 13, 17, 27);
INSERT INTO versification_data VALUES (NULL, 10, 13, 18, 17);
INSERT INTO versification_data VALUES (NULL, 10, 13, 19, 19);
INSERT INTO versification_data VALUES (NULL, 10, 13, 20, 8);
INSERT INTO versification_data VALUES (NULL, 10, 13, 21, 30);
INSERT INTO versification_data VALUES (NULL, 10, 13, 22, 19);
INSERT INTO versification_data VALUES (NULL, 10, 13, 23, 32);
INSERT INTO versification_data VALUES (NULL, 10, 13, 24, 31);
INSERT INTO versification_data VALUES (NULL, 10, 13, 25, 31);
INSERT INTO versification_data VALUES (NULL, 10, 13, 26, 32);
INSERT INTO versification_data VALUES (NULL, 10, 13, 27, 34);
INSERT INTO versification_data VALUES (NULL, 10, 13, 28, 21);
INSERT INTO versification_data VALUES (NULL, 10, 13, 29, 30);
INSERT INTO versification_data VALUES (NULL, 10, 14, 1, 17);
INSERT INTO versification_data VALUES (NULL, 10, 14, 2, 18);
INSERT INTO versification_data VALUES (NULL, 10, 14, 3, 17);
INSERT INTO versification_data VALUES (NULL, 10, 14, 4, 22);
INSERT INTO versification_data VALUES (NULL, 10, 14, 5, 14);
INSERT INTO versification_data VALUES (NULL, 10, 14, 6, 42);
INSERT INTO versification_data VALUES (NULL, 10, 14, 7, 22);
INSERT INTO versification_data VALUES (NULL, 10, 14, 8, 18);
INSERT INTO versification_data VALUES (NULL, 10, 14, 9, 31);
INSERT INTO versification_data VALUES (NULL, 10, 14, 10, 19);
INSERT INTO versification_data VALUES (NULL, 10, 14, 11, 23);
INSERT INTO versification_data VALUES (NULL, 10, 14, 12, 16);
INSERT INTO versification_data VALUES (NULL, 10, 14, 13, 22);
INSERT INTO versification_data VALUES (NULL, 10, 14, 14, 15);
INSERT INTO versification_data VALUES (NULL, 10, 14, 15, 19);
INSERT INTO versification_data VALUES (NULL, 10, 14, 16, 14);
INSERT INTO versification_data VALUES (NULL, 10, 14, 17, 19);
INSERT INTO versification_data VALUES (NULL, 10, 14, 18, 34);
INSERT INTO versification_data VALUES (NULL, 10, 14, 19, 11);
INSERT INTO versification_data VALUES (NULL, 10, 14, 20, 37);
INSERT INTO versification_data VALUES (NULL, 10, 14, 21, 20);
INSERT INTO versification_data VALUES (NULL, 10, 14, 22, 12);
INSERT INTO versification_data VALUES (NULL, 10, 14, 23, 21);
INSERT INTO versification_data VALUES (NULL, 10, 14, 24, 27);
INSERT INTO versification_data VALUES (NULL, 10, 14, 25, 28);
INSERT INTO versification_data VALUES (NULL, 10, 14, 26, 23);
INSERT INTO versification_data VALUES (NULL, 10, 14, 27, 9);
INSERT INTO versification_data VALUES (NULL, 10, 14, 28, 27);
INSERT INTO versification_data VALUES (NULL, 10, 14, 29, 36);
INSERT INTO versification_data VALUES (NULL, 10, 14, 30, 27);
INSERT INTO versification_data VALUES (NULL, 10, 14, 31, 21);
INSERT INTO versification_data VALUES (NULL, 10, 14, 32, 33);
INSERT INTO versification_data VALUES (NULL, 10, 14, 33, 25);
INSERT INTO versification_data VALUES (NULL, 10, 14, 34, 33);
INSERT INTO versification_data VALUES (NULL, 10, 14, 35, 27);
INSERT INTO versification_data VALUES (NULL, 10, 14, 36, 23);
INSERT INTO versification_data VALUES (NULL, 10, 15, 1, 11);
INSERT INTO versification_data VALUES (NULL, 10, 15, 2, 70);
INSERT INTO versification_data VALUES (NULL, 10, 15, 3, 13);
INSERT INTO versification_data VALUES (NULL, 10, 15, 4, 24);
INSERT INTO versification_data VALUES (NULL, 10, 15, 5, 17);
INSERT INTO versification_data VALUES (NULL, 10, 15, 6, 22);
INSERT INTO versification_data VALUES (NULL, 10, 15, 7, 28);
INSERT INTO versification_data VALUES (NULL, 10, 15, 8, 36);
INSERT INTO versification_data VALUES (NULL, 10, 15, 9, 15);
INSERT INTO versification_data VALUES (NULL, 10, 15, 10, 44);
INSERT INTO versification_data VALUES (NULL, 10, 16, 1, 11);
INSERT INTO versification_data VALUES (NULL, 10, 16, 2, 20);
INSERT INTO versification_data VALUES (NULL, 10, 16, 3, 32);
INSERT INTO versification_data VALUES (NULL, 10, 16, 4, 23);
INSERT INTO versification_data VALUES (NULL, 10, 16, 5, 19);
INSERT INTO versification_data VALUES (NULL, 10, 16, 6, 19);
INSERT INTO versification_data VALUES (NULL, 10, 16, 7, 72);
INSERT INTO versification_data VALUES (NULL, 10, 16, 8, 19);
INSERT INTO versification_data VALUES (NULL, 10, 16, 9, 38);
INSERT INTO versification_data VALUES (NULL, 10, 16, 10, 39);
INSERT INTO versification_data VALUES (NULL, 10, 16, 11, 36);
INSERT INTO versification_data VALUES (NULL, 10, 16, 12, 47);
INSERT INTO versification_data VALUES (NULL, 10, 16, 13, 31);
INSERT INTO versification_data VALUES (NULL, 10, 17, 1, 22);
INSERT INTO versification_data VALUES (NULL, 10, 17, 2, 23);
INSERT INTO versification_data VALUES (NULL, 10, 17, 3, 15);
INSERT INTO versification_data VALUES (NULL, 10, 17, 4, 17);
INSERT INTO versification_data VALUES (NULL, 10, 17, 5, 14);
INSERT INTO versification_data VALUES (NULL, 10, 17, 6, 14);
INSERT INTO versification_data VALUES (NULL, 10, 17, 7, 10);
INSERT INTO versification_data VALUES (NULL, 10, 17, 8, 17);
INSERT INTO versification_data VALUES (NULL, 10, 17, 9, 32);
INSERT INTO versification_data VALUES (NULL, 10, 17, 10, 3);
INSERT INTO versification_data VALUES (NULL, 10, 18, 1, 22);
INSERT INTO versification_data VALUES (NULL, 10, 18, 2, 13);
INSERT INTO versification_data VALUES (NULL, 10, 18, 3, 26);
INSERT INTO versification_data VALUES (NULL, 10, 18, 4, 21);
INSERT INTO versification_data VALUES (NULL, 10, 18, 5, 27);
INSERT INTO versification_data VALUES (NULL, 10, 18, 6, 30);
INSERT INTO versification_data VALUES (NULL, 10, 18, 7, 21);
INSERT INTO versification_data VALUES (NULL, 10, 18, 8, 22);
INSERT INTO versification_data VALUES (NULL, 10, 18, 9, 35);
INSERT INTO versification_data VALUES (NULL, 10, 18, 10, 22);
INSERT INTO versification_data VALUES (NULL, 10, 18, 11, 20);
INSERT INTO versification_data VALUES (NULL, 10, 18, 12, 25);
INSERT INTO versification_data VALUES (NULL, 10, 18, 13, 28);
INSERT INTO versification_data VALUES (NULL, 10, 18, 14, 22);
INSERT INTO versification_data VALUES (NULL, 10, 18, 15, 35);
INSERT INTO versification_data VALUES (NULL, 10, 18, 16, 22);
INSERT INTO versification_data VALUES (NULL, 10, 18, 17, 16);
INSERT INTO versification_data VALUES (NULL, 10, 18, 18, 21);
INSERT INTO versification_data VALUES (NULL, 10, 18, 19, 29);
INSERT INTO versification_data VALUES (NULL, 10, 18, 20, 29);
INSERT INTO versification_data VALUES (NULL, 10, 18, 21, 34);
INSERT INTO versification_data VALUES (NULL, 10, 18, 22, 30);
INSERT INTO versification_data VALUES (NULL, 10, 18, 23, 17);
INSERT INTO versification_data VALUES (NULL, 10, 18, 24, 25);
INSERT INTO versification_data VALUES (NULL, 10, 18, 25, 6);
INSERT INTO versification_data VALUES (NULL, 10, 18, 26, 14);
INSERT INTO versification_data VALUES (NULL, 10, 18, 27, 23);
INSERT INTO versification_data VALUES (NULL, 10, 18, 28, 28);
INSERT INTO versification_data VALUES (NULL, 10, 18, 29, 25);
INSERT INTO versification_data VALUES (NULL, 10, 18, 30, 31);
INSERT INTO versification_data VALUES (NULL, 10, 18, 31, 40);
INSERT INTO versification_data VALUES (NULL, 10, 18, 32, 22);
INSERT INTO versification_data VALUES (NULL, 10, 18, 33, 33);
INSERT INTO versification_data VALUES (NULL, 10, 18, 34, 37);
INSERT INTO versification_data VALUES (NULL, 10, 18, 35, 16);
INSERT INTO versification_data VALUES (NULL, 10, 18, 36, 33);
INSERT INTO versification_data VALUES (NULL, 10, 18, 37, 24);
INSERT INTO versification_data VALUES (NULL, 10, 18, 38, 38);
INSERT INTO versification_data VALUES (NULL, 10, 18, 39, 38);
INSERT INTO versification_data VALUES (NULL, 10, 18, 40, 28);
INSERT INTO versification_data VALUES (NULL, 10, 18, 41, 25);
INSERT INTO versification_data VALUES (NULL, 10, 18, 42, 17);
INSERT INTO versification_data VALUES (NULL, 10, 19, 1, 6);
INSERT INTO versification_data VALUES (NULL, 10, 19, 2, 12);
INSERT INTO versification_data VALUES (NULL, 10, 19, 3, 9);
INSERT INTO versification_data VALUES (NULL, 10, 19, 4, 9);
INSERT INTO versification_data VALUES (NULL, 10, 19, 5, 13);
INSERT INTO versification_data VALUES (NULL, 10, 19, 6, 11);
INSERT INTO versification_data VALUES (NULL, 10, 19, 7, 18);
INSERT INTO versification_data VALUES (NULL, 10, 19, 8, 10);
INSERT INTO versification_data VALUES (NULL, 10, 19, 9, 21);
INSERT INTO versification_data VALUES (NULL, 10, 19, 10, 18);
INSERT INTO versification_data VALUES (NULL, 10, 19, 11, 7);
INSERT INTO versification_data VALUES (NULL, 10, 19, 12, 9);
INSERT INTO versification_data VALUES (NULL, 10, 19, 13, 6);
INSERT INTO versification_data VALUES (NULL, 10, 19, 14, 7);
INSERT INTO versification_data VALUES (NULL, 10, 19, 15, 5);
INSERT INTO versification_data VALUES (NULL, 10, 19, 16, 11);
INSERT INTO versification_data VALUES (NULL, 10, 19, 17, 15);
INSERT INTO versification_data VALUES (NULL, 10, 19, 18, 51);
INSERT INTO versification_data VALUES (NULL, 10, 19, 19, 15);
INSERT INTO versification_data VALUES (NULL, 10, 19, 20, 10);
INSERT INTO versification_data VALUES (NULL, 10, 19, 21, 14);
INSERT INTO versification_data VALUES (NULL, 10, 19, 22, 32);
INSERT INTO versification_data VALUES (NULL, 10, 19, 23, 6);
INSERT INTO versification_data VALUES (NULL, 10, 19, 24, 10);
INSERT INTO versification_data VALUES (NULL, 10, 19, 25, 22);
INSERT INTO versification_data VALUES (NULL, 10, 19, 26, 12);
INSERT INTO versification_data VALUES (NULL, 10, 19, 27, 14);
INSERT INTO versification_data VALUES (NULL, 10, 19, 28, 9);
INSERT INTO versification_data VALUES (NULL, 10, 19, 29, 11);
INSERT INTO versification_data VALUES (NULL, 10, 19, 30, 13);
INSERT INTO versification_data VALUES (NULL, 10, 19, 31, 25);
INSERT INTO versification_data VALUES (NULL, 10, 19, 32, 11);
INSERT INTO versification_data VALUES (NULL, 10, 19, 33, 22);
INSERT INTO versification_data VALUES (NULL, 10, 19, 34, 23);
INSERT INTO versification_data VALUES (NULL, 10, 19, 35, 28);
INSERT INTO versification_data VALUES (NULL, 10, 19, 36, 13);
INSERT INTO versification_data VALUES (NULL, 10, 19, 37, 40);
INSERT INTO versification_data VALUES (NULL, 10, 19, 38, 23);
INSERT INTO versification_data VALUES (NULL, 10, 19, 39, 14);
INSERT INTO versification_data VALUES (NULL, 10, 19, 40, 18);
INSERT INTO versification_data VALUES (NULL, 10, 19, 41, 14);
INSERT INTO versification_data VALUES (NULL, 10, 19, 42, 12);
INSERT INTO versification_data VALUES (NULL, 10, 19, 43, 5);
INSERT INTO versification_data VALUES (NULL, 10, 19, 44, 27);
INSERT INTO versification_data VALUES (NULL, 10, 19, 45, 18);
INSERT INTO versification_data VALUES (NULL, 10, 19, 46, 12);
INSERT INTO versification_data VALUES (NULL, 10, 19, 47, 10);
INSERT INTO versification_data VALUES (NULL, 10, 19, 48, 15);
INSERT INTO versification_data VALUES (NULL, 10, 19, 49, 21);
INSERT INTO versification_data VALUES (NULL, 10, 19, 50, 23);
INSERT INTO versification_data VALUES (NULL, 10, 19, 51, 21);
INSERT INTO versification_data VALUES (NULL, 10, 19, 52, 11);
INSERT INTO versification_data VALUES (NULL, 10, 19, 53, 7);
INSERT INTO versification_data VALUES (NULL, 10, 19, 54, 9);
INSERT INTO versification_data VALUES (NULL, 10, 19, 55, 24);
INSERT INTO versification_data VALUES (NULL, 10, 19, 56, 14);
INSERT INTO versification_data VALUES (NULL, 10, 19, 57, 12);
INSERT INTO versification_data VALUES (NULL, 10, 19, 58, 12);
INSERT INTO versification_data VALUES (NULL, 10, 19, 59, 18);
INSERT INTO versification_data VALUES (NULL, 10, 19, 60, 14);
INSERT INTO versification_data VALUES (NULL, 10, 19, 61, 9);
INSERT INTO versification_data VALUES (NULL, 10, 19, 62, 13);
INSERT INTO versification_data VALUES (NULL, 10, 19, 63, 12);
INSERT INTO versification_data VALUES (NULL, 10, 19, 64, 11);
INSERT INTO versification_data VALUES (NULL, 10, 19, 65, 14);
INSERT INTO versification_data VALUES (NULL, 10, 19, 66, 20);
INSERT INTO versification_data VALUES (NULL, 10, 19, 67, 8);
INSERT INTO versification_data VALUES (NULL, 10, 19, 68, 36);
INSERT INTO versification_data VALUES (NULL, 10, 19, 69, 37);
INSERT INTO versification_data VALUES (NULL, 10, 19, 70, 6);
INSERT INTO versification_data VALUES (NULL, 10, 19, 71, 24);
INSERT INTO versification_data VALUES (NULL, 10, 19, 72, 20);
INSERT INTO versification_data VALUES (NULL, 10, 19, 73, 28);
INSERT INTO versification_data VALUES (NULL, 10, 19, 74, 23);
INSERT INTO versification_data VALUES (NULL, 10, 19, 75, 11);
INSERT INTO versification_data VALUES (NULL, 10, 19, 76, 13);
INSERT INTO versification_data VALUES (NULL, 10, 19, 77, 21);
INSERT INTO versification_data VALUES (NULL, 10, 19, 78, 72);
INSERT INTO versification_data VALUES (NULL, 10, 19, 79, 13);
INSERT INTO versification_data VALUES (NULL, 10, 19, 80, 20);
INSERT INTO versification_data VALUES (NULL, 10, 19, 81, 17);
INSERT INTO versification_data VALUES (NULL, 10, 19, 82, 8);
INSERT INTO versification_data VALUES (NULL, 10, 19, 83, 19);
INSERT INTO versification_data VALUES (NULL, 10, 19, 84, 13);
INSERT INTO versification_data VALUES (NULL, 10, 19, 85, 14);
INSERT INTO versification_data VALUES (NULL, 10, 19, 86, 17);
INSERT INTO versification_data VALUES (NULL, 10, 19, 87, 7);
INSERT INTO versification_data VALUES (NULL, 10, 19, 88, 19);
INSERT INTO versification_data VALUES (NULL, 10, 19, 89, 53);
INSERT INTO versification_data VALUES (NULL, 10, 19, 90, 17);
INSERT INTO versification_data VALUES (NULL, 10, 19, 91, 16);
INSERT INTO versification_data VALUES (NULL, 10, 19, 92, 16);
INSERT INTO versification_data VALUES (NULL, 10, 19, 93, 5);
INSERT INTO versification_data VALUES (NULL, 10, 19, 94, 23);
INSERT INTO versification_data VALUES (NULL, 10, 19, 95, 11);
INSERT INTO versification_data VALUES (NULL, 10, 19, 96, 13);
INSERT INTO versification_data VALUES (NULL, 10, 19, 97, 12);
INSERT INTO versification_data VALUES (NULL, 10, 19, 98, 9);
INSERT INTO versification_data VALUES (NULL, 10, 19, 99, 9);
INSERT INTO versification_data VALUES (NULL, 10, 19, 100, 5);
INSERT INTO versification_data VALUES (NULL, 10, 19, 101, 8);
INSERT INTO versification_data VALUES (NULL, 10, 19, 102, 29);
INSERT INTO versification_data VALUES (NULL, 10, 19, 103, 22);
INSERT INTO versification_data VALUES (NULL, 10, 19, 104, 35);
INSERT INTO versification_data VALUES (NULL, 10, 19, 105, 45);
INSERT INTO versification_data VALUES (NULL, 10, 19, 106, 48);
INSERT INTO versification_data VALUES (NULL, 10, 19, 107, 43);
INSERT INTO versification_data VALUES (NULL, 10, 19, 108, 14);
INSERT INTO versification_data VALUES (NULL, 10, 19, 109, 31);
INSERT INTO versification_data VALUES (NULL, 10, 19, 110, 7);
INSERT INTO versification_data VALUES (NULL, 10, 19, 111, 10);
INSERT INTO versification_data VALUES (NULL, 10, 19, 112, 10);
INSERT INTO versification_data VALUES (NULL, 10, 19, 113, 9);
INSERT INTO versification_data VALUES (NULL, 10, 19, 114, 8);
INSERT INTO versification_data VALUES (NULL, 10, 19, 115, 18);
INSERT INTO versification_data VALUES (NULL, 10, 19, 116, 19);
INSERT INTO versification_data VALUES (NULL, 10, 19, 117, 2);
INSERT INTO versification_data VALUES (NULL, 10, 19, 118, 29);
INSERT INTO versification_data VALUES (NULL, 10, 19, 119, 176);
INSERT INTO versification_data VALUES (NULL, 10, 19, 120, 7);
INSERT INTO versification_data VALUES (NULL, 10, 19, 121, 8);
INSERT INTO versification_data VALUES (NULL, 10, 19, 122, 9);
INSERT INTO versification_data VALUES (NULL, 10, 19, 123, 4);
INSERT INTO versification_data VALUES (NULL, 10, 19, 124, 8);
INSERT INTO versification_data VALUES (NULL, 10, 19, 125, 5);
INSERT INTO versification_data VALUES (NULL, 10, 19, 126, 6);
INSERT INTO versification_data VALUES (NULL, 10, 19, 127, 5);
INSERT INTO versification_data VALUES (NULL, 10, 19, 128, 6);
INSERT INTO versification_data VALUES (NULL, 10, 19, 129, 8);
INSERT INTO versification_data VALUES (NULL, 10, 19, 130, 8);
INSERT INTO versification_data VALUES (NULL, 10, 19, 131, 3);
INSERT INTO versification_data VALUES (NULL, 10, 19, 132, 18);
INSERT INTO versification_data VALUES (NULL, 10, 19, 133, 3);
INSERT INTO versification_data VALUES (NULL, 10, 19, 134, 3);
INSERT INTO versification_data VALUES (NULL, 10, 19, 135, 21);
INSERT INTO versification_data VALUES (NULL, 10, 19, 136, 26);
INSERT INTO versification_data VALUES (NULL, 10, 19, 137, 9);
INSERT INTO versification_data VALUES (NULL, 10, 19, 138, 8);
INSERT INTO versification_data VALUES (NULL, 10, 19, 139, 24);
INSERT INTO versification_data VALUES (NULL, 10, 19, 140, 14);
INSERT INTO versification_data VALUES (NULL, 10, 19, 141, 10);
INSERT INTO versification_data VALUES (NULL, 10, 19, 142, 8);
INSERT INTO versification_data VALUES (NULL, 10, 19, 143, 12);
INSERT INTO versification_data VALUES (NULL, 10, 19, 144, 15);
INSERT INTO versification_data VALUES (NULL, 10, 19, 145, 21);
INSERT INTO versification_data VALUES (NULL, 10, 19, 146, 10);
INSERT INTO versification_data VALUES (NULL, 10, 19, 147, 20);
INSERT INTO versification_data VALUES (NULL, 10, 19, 148, 14);
INSERT INTO versification_data VALUES (NULL, 10, 19, 149, 9);
INSERT INTO versification_data VALUES (NULL, 10, 19, 150, 6);
INSERT INTO versification_data VALUES (NULL, 10, 20, 1, 33);
INSERT INTO versification_data VALUES (NULL, 10, 20, 2, 22);
INSERT INTO versification_data VALUES (NULL, 10, 20, 3, 35);
INSERT INTO versification_data VALUES (NULL, 10, 20, 4, 27);
INSERT INTO versification_data VALUES (NULL, 10, 20, 5, 23);
INSERT INTO versification_data VALUES (NULL, 10, 20, 6, 35);
INSERT INTO versification_data VALUES (NULL, 10, 20, 7, 27);
INSERT INTO versification_data VALUES (NULL, 10, 20, 8, 36);
INSERT INTO versification_data VALUES (NULL, 10, 20, 9, 18);
INSERT INTO versification_data VALUES (NULL, 10, 20, 10, 32);
INSERT INTO versification_data VALUES (NULL, 10, 20, 11, 31);
INSERT INTO versification_data VALUES (NULL, 10, 20, 12, 28);
INSERT INTO versification_data VALUES (NULL, 10, 20, 13, 25);
INSERT INTO versification_data VALUES (NULL, 10, 20, 14, 35);
INSERT INTO versification_data VALUES (NULL, 10, 20, 15, 33);
INSERT INTO versification_data VALUES (NULL, 10, 20, 16, 33);
INSERT INTO versification_data VALUES (NULL, 10, 20, 17, 28);
INSERT INTO versification_data VALUES (NULL, 10, 20, 18, 24);
INSERT INTO versification_data VALUES (NULL, 10, 20, 19, 29);
INSERT INTO versification_data VALUES (NULL, 10, 20, 20, 30);
INSERT INTO versification_data VALUES (NULL, 10, 20, 21, 31);
INSERT INTO versification_data VALUES (NULL, 10, 20, 22, 29);
INSERT INTO versification_data VALUES (NULL, 10, 20, 23, 35);
INSERT INTO versification_data VALUES (NULL, 10, 20, 24, 34);
INSERT INTO versification_data VALUES (NULL, 10, 20, 25, 28);
INSERT INTO versification_data VALUES (NULL, 10, 20, 26, 28);
INSERT INTO versification_data VALUES (NULL, 10, 20, 27, 27);
INSERT INTO versification_data VALUES (NULL, 10, 20, 28, 28);
INSERT INTO versification_data VALUES (NULL, 10, 20, 29, 27);
INSERT INTO versification_data VALUES (NULL, 10, 20, 30, 33);
INSERT INTO versification_data VALUES (NULL, 10, 20, 31, 31);
INSERT INTO versification_data VALUES (NULL, 10, 21, 1, 18);
INSERT INTO versification_data VALUES (NULL, 10, 21, 2, 26);
INSERT INTO versification_data VALUES (NULL, 10, 21, 3, 22);
INSERT INTO versification_data VALUES (NULL, 10, 21, 4, 17);
INSERT INTO versification_data VALUES (NULL, 10, 21, 5, 19);
INSERT INTO versification_data VALUES (NULL, 10, 21, 6, 12);
INSERT INTO versification_data VALUES (NULL, 10, 21, 7, 29);
INSERT INTO versification_data VALUES (NULL, 10, 21, 8, 17);
INSERT INTO versification_data VALUES (NULL, 10, 21, 9, 18);
INSERT INTO versification_data VALUES (NULL, 10, 21, 10, 20);
INSERT INTO versification_data VALUES (NULL, 10, 21, 11, 10);
INSERT INTO versification_data VALUES (NULL, 10, 21, 12, 14);
INSERT INTO versification_data VALUES (NULL, 10, 22, 1, 17);
INSERT INTO versification_data VALUES (NULL, 10, 22, 2, 17);
INSERT INTO versification_data VALUES (NULL, 10, 22, 3, 11);
INSERT INTO versification_data VALUES (NULL, 10, 22, 4, 16);
INSERT INTO versification_data VALUES (NULL, 10, 22, 5, 16);
INSERT INTO versification_data VALUES (NULL, 10, 22, 6, 13);
INSERT INTO versification_data VALUES (NULL, 10, 22, 7, 13);
INSERT INTO versification_data VALUES (NULL, 10, 22, 8, 14);
INSERT INTO versification_data VALUES (NULL, 10, 23, 1, 31);
INSERT INTO versification_data VALUES (NULL, 10, 23, 2, 22);
INSERT INTO versification_data VALUES (NULL, 10, 23, 3, 26);
INSERT INTO versification_data VALUES (NULL, 10, 23, 4, 6);
INSERT INTO versification_data VALUES (NULL, 10, 23, 5, 30);
INSERT INTO versification_data VALUES (NULL, 10, 23, 6, 13);
INSERT INTO versification_data VALUES (NULL, 10, 23, 7, 25);
INSERT INTO versification_data VALUES (NULL, 10, 23, 8, 23);
INSERT INTO versification_data VALUES (NULL, 10, 23, 9, 20);
INSERT INTO versification_data VALUES (NULL, 10, 23, 10, 34);
INSERT INTO versification_data VALUES (NULL, 10, 23, 11, 16);
INSERT INTO versification_data VALUES (NULL, 10, 23, 12, 6);
INSERT INTO versification_data VALUES (NULL, 10, 23, 13, 22);
INSERT INTO versification_data VALUES (NULL, 10, 23, 14, 32);
INSERT INTO versification_data VALUES (NULL, 10, 23, 15, 9);
INSERT INTO versification_data VALUES (NULL, 10, 23, 16, 14);
INSERT INTO versification_data VALUES (NULL, 10, 23, 17, 14);
INSERT INTO versification_data VALUES (NULL, 10, 23, 18, 7);
INSERT INTO versification_data VALUES (NULL, 10, 23, 19, 25);
INSERT INTO versification_data VALUES (NULL, 10, 23, 20, 6);
INSERT INTO versification_data VALUES (NULL, 10, 23, 21, 17);
INSERT INTO versification_data VALUES (NULL, 10, 23, 22, 25);
INSERT INTO versification_data VALUES (NULL, 10, 23, 23, 18);
INSERT INTO versification_data VALUES (NULL, 10, 23, 24, 23);
INSERT INTO versification_data VALUES (NULL, 10, 23, 25, 12);
INSERT INTO versification_data VALUES (NULL, 10, 23, 26, 21);
INSERT INTO versification_data VALUES (NULL, 10, 23, 27, 13);
INSERT INTO versification_data VALUES (NULL, 10, 23, 28, 29);
INSERT INTO versification_data VALUES (NULL, 10, 23, 29, 24);
INSERT INTO versification_data VALUES (NULL, 10, 23, 30, 33);
INSERT INTO versification_data VALUES (NULL, 10, 23, 31, 9);
INSERT INTO versification_data VALUES (NULL, 10, 23, 32, 20);
INSERT INTO versification_data VALUES (NULL, 10, 23, 33, 24);
INSERT INTO versification_data VALUES (NULL, 10, 23, 34, 17);
INSERT INTO versification_data VALUES (NULL, 10, 23, 35, 10);
INSERT INTO versification_data VALUES (NULL, 10, 23, 36, 22);
INSERT INTO versification_data VALUES (NULL, 10, 23, 37, 38);
INSERT INTO versification_data VALUES (NULL, 10, 23, 38, 22);
INSERT INTO versification_data VALUES (NULL, 10, 23, 39, 8);
INSERT INTO versification_data VALUES (NULL, 10, 23, 40, 31);
INSERT INTO versification_data VALUES (NULL, 10, 23, 41, 29);
INSERT INTO versification_data VALUES (NULL, 10, 23, 42, 25);
INSERT INTO versification_data VALUES (NULL, 10, 23, 43, 28);
INSERT INTO versification_data VALUES (NULL, 10, 23, 44, 28);
INSERT INTO versification_data VALUES (NULL, 10, 23, 45, 25);
INSERT INTO versification_data VALUES (NULL, 10, 23, 46, 13);
INSERT INTO versification_data VALUES (NULL, 10, 23, 47, 15);
INSERT INTO versification_data VALUES (NULL, 10, 23, 48, 22);
INSERT INTO versification_data VALUES (NULL, 10, 23, 49, 26);
INSERT INTO versification_data VALUES (NULL, 10, 23, 50, 11);
INSERT INTO versification_data VALUES (NULL, 10, 23, 51, 23);
INSERT INTO versification_data VALUES (NULL, 10, 23, 52, 15);
INSERT INTO versification_data VALUES (NULL, 10, 23, 53, 12);
INSERT INTO versification_data VALUES (NULL, 10, 23, 54, 17);
INSERT INTO versification_data VALUES (NULL, 10, 23, 55, 13);
INSERT INTO versification_data VALUES (NULL, 10, 23, 56, 12);
INSERT INTO versification_data VALUES (NULL, 10, 23, 57, 21);
INSERT INTO versification_data VALUES (NULL, 10, 23, 58, 14);
INSERT INTO versification_data VALUES (NULL, 10, 23, 59, 21);
INSERT INTO versification_data VALUES (NULL, 10, 23, 60, 22);
INSERT INTO versification_data VALUES (NULL, 10, 23, 61, 11);
INSERT INTO versification_data VALUES (NULL, 10, 23, 62, 12);
INSERT INTO versification_data VALUES (NULL, 10, 23, 63, 19);
INSERT INTO versification_data VALUES (NULL, 10, 23, 64, 12);
INSERT INTO versification_data VALUES (NULL, 10, 23, 65, 25);
INSERT INTO versification_data VALUES (NULL, 10, 23, 66, 24);
INSERT INTO versification_data VALUES (NULL, 10, 24, 1, 19);
INSERT INTO versification_data VALUES (NULL, 10, 24, 2, 37);
INSERT INTO versification_data VALUES (NULL, 10, 24, 3, 25);
INSERT INTO versification_data VALUES (NULL, 10, 24, 4, 31);
INSERT INTO versification_data VALUES (NULL, 10, 24, 5, 31);
INSERT INTO versification_data VALUES (NULL, 10, 24, 6, 30);
INSERT INTO versification_data VALUES (NULL, 10, 24, 7, 34);
INSERT INTO versification_data VALUES (NULL, 10, 24, 8, 22);
INSERT INTO versification_data VALUES (NULL, 10, 24, 9, 26);
INSERT INTO versification_data VALUES (NULL, 10, 24, 10, 25);
INSERT INTO versification_data VALUES (NULL, 10, 24, 11, 23);
INSERT INTO versification_data VALUES (NULL, 10, 24, 12, 17);
INSERT INTO versification_data VALUES (NULL, 10, 24, 13, 27);
INSERT INTO versification_data VALUES (NULL, 10, 24, 14, 22);
INSERT INTO versification_data VALUES (NULL, 10, 24, 15, 21);
INSERT INTO versification_data VALUES (NULL, 10, 24, 16, 21);
INSERT INTO versification_data VALUES (NULL, 10, 24, 17, 27);
INSERT INTO versification_data VALUES (NULL, 10, 24, 18, 23);
INSERT INTO versification_data VALUES (NULL, 10, 24, 19, 15);
INSERT INTO versification_data VALUES (NULL, 10, 24, 20, 18);
INSERT INTO versification_data VALUES (NULL, 10, 24, 21, 14);
INSERT INTO versification_data VALUES (NULL, 10, 24, 22, 30);
INSERT INTO versification_data VALUES (NULL, 10, 24, 23, 40);
INSERT INTO versification_data VALUES (NULL, 10, 24, 24, 10);
INSERT INTO versification_data VALUES (NULL, 10, 24, 25, 38);
INSERT INTO versification_data VALUES (NULL, 10, 24, 26, 24);
INSERT INTO versification_data VALUES (NULL, 10, 24, 27, 22);
INSERT INTO versification_data VALUES (NULL, 10, 24, 28, 17);
INSERT INTO versification_data VALUES (NULL, 10, 24, 29, 32);
INSERT INTO versification_data VALUES (NULL, 10, 24, 30, 24);
INSERT INTO versification_data VALUES (NULL, 10, 24, 31, 40);
INSERT INTO versification_data VALUES (NULL, 10, 24, 32, 44);
INSERT INTO versification_data VALUES (NULL, 10, 24, 33, 26);
INSERT INTO versification_data VALUES (NULL, 10, 24, 34, 22);
INSERT INTO versification_data VALUES (NULL, 10, 24, 35, 19);
INSERT INTO versification_data VALUES (NULL, 10, 24, 36, 32);
INSERT INTO versification_data VALUES (NULL, 10, 24, 37, 21);
INSERT INTO versification_data VALUES (NULL, 10, 24, 38, 28);
INSERT INTO versification_data VALUES (NULL, 10, 24, 39, 18);
INSERT INTO versification_data VALUES (NULL, 10, 24, 40, 16);
INSERT INTO versification_data VALUES (NULL, 10, 24, 41, 18);
INSERT INTO versification_data VALUES (NULL, 10, 24, 42, 22);
INSERT INTO versification_data VALUES (NULL, 10, 24, 43, 13);
INSERT INTO versification_data VALUES (NULL, 10, 24, 44, 30);
INSERT INTO versification_data VALUES (NULL, 10, 24, 45, 5);
INSERT INTO versification_data VALUES (NULL, 10, 24, 46, 28);
INSERT INTO versification_data VALUES (NULL, 10, 24, 47, 7);
INSERT INTO versification_data VALUES (NULL, 10, 24, 48, 47);
INSERT INTO versification_data VALUES (NULL, 10, 24, 49, 39);
INSERT INTO versification_data VALUES (NULL, 10, 24, 50, 46);
INSERT INTO versification_data VALUES (NULL, 10, 24, 51, 64);
INSERT INTO versification_data VALUES (NULL, 10, 24, 52, 34);
INSERT INTO versification_data VALUES (NULL, 10, 25, 1, 22);
INSERT INTO versification_data VALUES (NULL, 10, 25, 2, 22);
INSERT INTO versification_data VALUES (NULL, 10, 25, 3, 66);
INSERT INTO versification_data VALUES (NULL, 10, 25, 4, 22);
INSERT INTO versification_data VALUES (NULL, 10, 25, 5, 22);
INSERT INTO versification_data VALUES (NULL, 10, 26, 1, 28);
INSERT INTO versification_data VALUES (NULL, 10, 26, 2, 10);
INSERT INTO versification_data VALUES (NULL, 10, 26, 3, 27);
INSERT INTO versification_data VALUES (NULL, 10, 26, 4, 17);
INSERT INTO versification_data VALUES (NULL, 10, 26, 5, 17);
INSERT INTO versification_data VALUES (NULL, 10, 26, 6, 14);
INSERT INTO versification_data VALUES (NULL, 10, 26, 7, 27);
INSERT INTO versification_data VALUES (NULL, 10, 26, 8, 18);
INSERT INTO versification_data VALUES (NULL, 10, 26, 9, 11);
INSERT INTO versification_data VALUES (NULL, 10, 26, 10, 22);
INSERT INTO versification_data VALUES (NULL, 10, 26, 11, 25);
INSERT INTO versification_data VALUES (NULL, 10, 26, 12, 28);
INSERT INTO versification_data VALUES (NULL, 10, 26, 13, 23);
INSERT INTO versification_data VALUES (NULL, 10, 26, 14, 23);
INSERT INTO versification_data VALUES (NULL, 10, 26, 15, 8);
INSERT INTO versification_data VALUES (NULL, 10, 26, 16, 63);
INSERT INTO versification_data VALUES (NULL, 10, 26, 17, 24);
INSERT INTO versification_data VALUES (NULL, 10, 26, 18, 32);
INSERT INTO versification_data VALUES (NULL, 10, 26, 19, 14);
INSERT INTO versification_data VALUES (NULL, 10, 26, 20, 49);
INSERT INTO versification_data VALUES (NULL, 10, 26, 21, 32);
INSERT INTO versification_data VALUES (NULL, 10, 26, 22, 31);
INSERT INTO versification_data VALUES (NULL, 10, 26, 23, 49);
INSERT INTO versification_data VALUES (NULL, 10, 26, 24, 27);
INSERT INTO versification_data VALUES (NULL, 10, 26, 25, 17);
INSERT INTO versification_data VALUES (NULL, 10, 26, 26, 21);
INSERT INTO versification_data VALUES (NULL, 10, 26, 27, 36);
INSERT INTO versification_data VALUES (NULL, 10, 26, 28, 26);
INSERT INTO versification_data VALUES (NULL, 10, 26, 29, 21);
INSERT INTO versification_data VALUES (NULL, 10, 26, 30, 26);
INSERT INTO versification_data VALUES (NULL, 10, 26, 31, 18);
INSERT INTO versification_data VALUES (NULL, 10, 26, 32, 32);
INSERT INTO versification_data VALUES (NULL, 10, 26, 33, 33);
INSERT INTO versification_data VALUES (NULL, 10, 26, 34, 31);
INSERT INTO versification_data VALUES (NULL, 10, 26, 35, 15);
INSERT INTO versification_data VALUES (NULL, 10, 26, 36, 38);
INSERT INTO versification_data VALUES (NULL, 10, 26, 37, 28);
INSERT INTO versification_data VALUES (NULL, 10, 26, 38, 23);
INSERT INTO versification_data VALUES (NULL, 10, 26, 39, 29);
INSERT INTO versification_data VALUES (NULL, 10, 26, 40, 49);
INSERT INTO versification_data VALUES (NULL, 10, 26, 41, 26);
INSERT INTO versification_data VALUES (NULL, 10, 26, 42, 20);
INSERT INTO versification_data VALUES (NULL, 10, 26, 43, 27);
INSERT INTO versification_data VALUES (NULL, 10, 26, 44, 31);
INSERT INTO versification_data VALUES (NULL, 10, 26, 45, 25);
INSERT INTO versification_data VALUES (NULL, 10, 26, 46, 24);
INSERT INTO versification_data VALUES (NULL, 10, 26, 47, 23);
INSERT INTO versification_data VALUES (NULL, 10, 26, 48, 35);
INSERT INTO versification_data VALUES (NULL, 10, 27, 1, 21);
INSERT INTO versification_data VALUES (NULL, 10, 27, 2, 49);
INSERT INTO versification_data VALUES (NULL, 10, 27, 3, 30);
INSERT INTO versification_data VALUES (NULL, 10, 27, 4, 37);
INSERT INTO versification_data VALUES (NULL, 10, 27, 5, 30);
INSERT INTO versification_data VALUES (NULL, 10, 27, 6, 29);
INSERT INTO versification_data VALUES (NULL, 10, 27, 7, 28);
INSERT INTO versification_data VALUES (NULL, 10, 27, 8, 27);
INSERT INTO versification_data VALUES (NULL, 10, 27, 9, 27);
INSERT INTO versification_data VALUES (NULL, 10, 27, 10, 21);
INSERT INTO versification_data VALUES (NULL, 10, 27, 11, 45);
INSERT INTO versification_data VALUES (NULL, 10, 27, 12, 13);
INSERT INTO versification_data VALUES (NULL, 10, 28, 1, 12);
INSERT INTO versification_data VALUES (NULL, 10, 28, 2, 22);
INSERT INTO versification_data VALUES (NULL, 10, 28, 3, 5);
INSERT INTO versification_data VALUES (NULL, 10, 28, 4, 19);
INSERT INTO versification_data VALUES (NULL, 10, 28, 5, 15);
INSERT INTO versification_data VALUES (NULL, 10, 28, 6, 11);
INSERT INTO versification_data VALUES (NULL, 10, 28, 7, 16);
INSERT INTO versification_data VALUES (NULL, 10, 28, 8, 14);
INSERT INTO versification_data VALUES (NULL, 10, 28, 9, 17);
INSERT INTO versification_data VALUES (NULL, 10, 28, 10, 15);
INSERT INTO versification_data VALUES (NULL, 10, 28, 11, 11);
INSERT INTO versification_data VALUES (NULL, 10, 28, 12, 15);
INSERT INTO versification_data VALUES (NULL, 10, 28, 13, 15);
INSERT INTO versification_data VALUES (NULL, 10, 28, 14, 10);
INSERT INTO versification_data VALUES (NULL, 10, 29, 1, 20);
INSERT INTO versification_data VALUES (NULL, 10, 29, 2, 32);
INSERT INTO versification_data VALUES (NULL, 10, 29, 3, 21);
INSERT INTO versification_data VALUES (NULL, 10, 30, 1, 15);
INSERT INTO versification_data VALUES (NULL, 10, 30, 2, 16);
INSERT INTO versification_data VALUES (NULL, 10, 30, 3, 15);
INSERT INTO versification_data VALUES (NULL, 10, 30, 4, 13);
INSERT INTO versification_data VALUES (NULL, 10, 30, 5, 27);
INSERT INTO versification_data VALUES (NULL, 10, 30, 6, 14);
INSERT INTO versification_data VALUES (NULL, 10, 30, 7, 17);
INSERT INTO versification_data VALUES (NULL, 10, 30, 8, 14);
INSERT INTO versification_data VALUES (NULL, 10, 30, 9, 15);
INSERT INTO versification_data VALUES (NULL, 10, 31, 1, 21);
INSERT INTO versification_data VALUES (NULL, 10, 32, 1, 17);
INSERT INTO versification_data VALUES (NULL, 10, 32, 2, 10);
INSERT INTO versification_data VALUES (NULL, 10, 32, 3, 10);
INSERT INTO versification_data VALUES (NULL, 10, 32, 4, 11);
INSERT INTO versification_data VALUES (NULL, 10, 33, 1, 16);
INSERT INTO versification_data VALUES (NULL, 10, 33, 2, 13);
INSERT INTO versification_data VALUES (NULL, 10, 33, 3, 12);
INSERT INTO versification_data VALUES (NULL, 10, 33, 4, 14);
INSERT INTO versification_data VALUES (NULL, 10, 33, 5, 14);
INSERT INTO versification_data VALUES (NULL, 10, 33, 6, 16);
INSERT INTO versification_data VALUES (NULL, 10, 33, 7, 20);
INSERT INTO versification_data VALUES (NULL, 10, 34, 1, 15);
INSERT INTO versification_data VALUES (NULL, 10, 34, 2, 13);
INSERT INTO versification_data VALUES (NULL, 10, 34, 3, 19);
INSERT INTO versification_data VALUES (NULL, 10, 35, 1, 17);
INSERT INTO versification_data VALUES (NULL, 10, 35, 2, 20);
INSERT INTO versification_data VALUES (NULL, 10, 35, 3, 19);
INSERT INTO versification_data VALUES (NULL, 10, 36, 1, 18);
INSERT INTO versification_data VALUES (NULL, 10, 36, 2, 15);
INSERT INTO versification_data VALUES (NULL, 10, 36, 3, 20);
INSERT INTO versification_data VALUES (NULL, 10, 37, 1, 14);
INSERT INTO versification_data VALUES (NULL, 10, 37, 2, 24);
INSERT INTO versification_data VALUES (NULL, 10, 38, 1, 21);
INSERT INTO versification_data VALUES (NULL, 10, 38, 2, 13);
INSERT INTO versification_data VALUES (NULL, 10, 38, 3, 10);
INSERT INTO versification_data VALUES (NULL, 10, 38, 4, 14);
INSERT INTO versification_data VALUES (NULL, 10, 38, 5, 11);
INSERT INTO versification_data VALUES (NULL, 10, 38, 6, 15);
INSERT INTO versification_data VALUES (NULL, 10, 38, 7, 14);
INSERT INTO versification_data VALUES (NULL, 10, 38, 8, 23);
INSERT INTO versification_data VALUES (NULL, 10, 38, 9, 17);
INSERT INTO versification_data VALUES (NULL, 10, 38, 10, 12);
INSERT INTO versification_data VALUES (NULL, 10, 38, 11, 17);
INSERT INTO versification_data VALUES (NULL, 10, 38, 12, 14);
INSERT INTO versification_data VALUES (NULL, 10, 38, 13, 9);
INSERT INTO versification_data VALUES (NULL, 10, 38, 14, 21);
INSERT INTO versification_data VALUES (NULL, 10, 39, 1, 14);
INSERT INTO versification_data VALUES (NULL, 10, 39, 2, 17);
INSERT INTO versification_data VALUES (NULL, 10, 39, 3, 18);
INSERT INTO versification_data VALUES (NULL, 10, 39, 4, 6);
INSERT INTO versification_data VALUES (NULL, 10, 40, 1, 25);
INSERT INTO versification_data VALUES (NULL, 10, 40, 2, 23);
INSERT INTO versification_data VALUES (NULL, 10, 40, 3, 17);
INSERT INTO versification_data VALUES (NULL, 10, 40, 4, 25);
INSERT INTO versification_data VALUES (NULL, 10, 40, 5, 48);
INSERT INTO versification_data VALUES (NULL, 10, 40, 6, 34);
INSERT INTO versification_data VALUES (NULL, 10, 40, 7, 29);
INSERT INTO versification_data VALUES (NULL, 10, 40, 8, 34);
INSERT INTO versification_data VALUES (NULL, 10, 40, 9, 38);
INSERT INTO versification_data VALUES (NULL, 10, 40, 10, 42);
INSERT INTO versification_data VALUES (NULL, 10, 40, 11, 30);
INSERT INTO versification_data VALUES (NULL, 10, 40, 12, 50);
INSERT INTO versification_data VALUES (NULL, 10, 40, 13, 58);
INSERT INTO versification_data VALUES (NULL, 10, 40, 14, 36);
INSERT INTO versification_data VALUES (NULL, 10, 40, 15, 39);
INSERT INTO versification_data VALUES (NULL, 10, 40, 16, 28);
INSERT INTO versification_data VALUES (NULL, 10, 40, 17, 27);
INSERT INTO versification_data VALUES (NULL, 10, 40, 18, 35);
INSERT INTO versification_data VALUES (NULL, 10, 40, 19, 30);
INSERT INTO versification_data VALUES (NULL, 10, 40, 20, 34);
INSERT INTO versification_data VALUES (NULL, 10, 40, 21, 46);
INSERT INTO versification_data VALUES (NULL, 10, 40, 22, 46);
INSERT INTO versification_data VALUES (NULL, 10, 40, 23, 39);
INSERT INTO versification_data VALUES (NULL, 10, 40, 24, 51);
INSERT INTO versification_data VALUES (NULL, 10, 40, 25, 46);
INSERT INTO versification_data VALUES (NULL, 10, 40, 26, 75);
INSERT INTO versification_data VALUES (NULL, 10, 40, 27, 66);
INSERT INTO versification_data VALUES (NULL, 10, 40, 28, 20);
INSERT INTO versification_data VALUES (NULL, 10, 41, 1, 45);
INSERT INTO versification_data VALUES (NULL, 10, 41, 2, 28);
INSERT INTO versification_data VALUES (NULL, 10, 41, 3, 35);
INSERT INTO versification_data VALUES (NULL, 10, 41, 4, 41);
INSERT INTO versification_data VALUES (NULL, 10, 41, 5, 43);
INSERT INTO versification_data VALUES (NULL, 10, 41, 6, 56);
INSERT INTO versification_data VALUES (NULL, 10, 41, 7, 37);
INSERT INTO versification_data VALUES (NULL, 10, 41, 8, 38);
INSERT INTO versification_data VALUES (NULL, 10, 41, 9, 50);
INSERT INTO versification_data VALUES (NULL, 10, 41, 10, 52);
INSERT INTO versification_data VALUES (NULL, 10, 41, 11, 33);
INSERT INTO versification_data VALUES (NULL, 10, 41, 12, 44);
INSERT INTO versification_data VALUES (NULL, 10, 41, 13, 37);
INSERT INTO versification_data VALUES (NULL, 10, 41, 14, 72);
INSERT INTO versification_data VALUES (NULL, 10, 41, 15, 47);
INSERT INTO versification_data VALUES (NULL, 10, 41, 16, 20);
INSERT INTO versification_data VALUES (NULL, 10, 42, 1, 80);
INSERT INTO versification_data VALUES (NULL, 10, 42, 2, 52);
INSERT INTO versification_data VALUES (NULL, 10, 42, 3, 38);
INSERT INTO versification_data VALUES (NULL, 10, 42, 4, 44);
INSERT INTO versification_data VALUES (NULL, 10, 42, 5, 39);
INSERT INTO versification_data VALUES (NULL, 10, 42, 6, 49);
INSERT INTO versification_data VALUES (NULL, 10, 42, 7, 50);
INSERT INTO versification_data VALUES (NULL, 10, 42, 8, 56);
INSERT INTO versification_data VALUES (NULL, 10, 42, 9, 62);
INSERT INTO versification_data VALUES (NULL, 10, 42, 10, 42);
INSERT INTO versification_data VALUES (NULL, 10, 42, 11, 54);
INSERT INTO versification_data VALUES (NULL, 10, 42, 12, 59);
INSERT INTO versification_data VALUES (NULL, 10, 42, 13, 35);
INSERT INTO versification_data VALUES (NULL, 10, 42, 14, 35);
INSERT INTO versification_data VALUES (NULL, 10, 42, 15, 32);
INSERT INTO versification_data VALUES (NULL, 10, 42, 16, 31);
INSERT INTO versification_data VALUES (NULL, 10, 42, 17, 37);
INSERT INTO versification_data VALUES (NULL, 10, 42, 18, 43);
INSERT INTO versification_data VALUES (NULL, 10, 42, 19, 48);
INSERT INTO versification_data VALUES (NULL, 10, 42, 20, 47);
INSERT INTO versification_data VALUES (NULL, 10, 42, 21, 38);
INSERT INTO versification_data VALUES (NULL, 10, 42, 22, 71);
INSERT INTO versification_data VALUES (NULL, 10, 42, 23, 56);
INSERT INTO versification_data VALUES (NULL, 10, 42, 24, 53);
INSERT INTO versification_data VALUES (NULL, 10, 43, 1, 52);
INSERT INTO versification_data VALUES (NULL, 10, 43, 2, 25);
INSERT INTO versification_data VALUES (NULL, 10, 43, 3, 36);
INSERT INTO versification_data VALUES (NULL, 10, 43, 4, 54);
INSERT INTO versification_data VALUES (NULL, 10, 43, 5, 47);
INSERT INTO versification_data VALUES (NULL, 10, 43, 6, 71);
INSERT INTO versification_data VALUES (NULL, 10, 43, 7, 53);
INSERT INTO versification_data VALUES (NULL, 10, 43, 8, 59);
INSERT INTO versification_data VALUES (NULL, 10, 43, 9, 41);
INSERT INTO versification_data VALUES (NULL, 10, 43, 10, 42);
INSERT INTO versification_data VALUES (NULL, 10, 43, 11, 57);
INSERT INTO versification_data VALUES (NULL, 10, 43, 12, 50);
INSERT INTO versification_data VALUES (NULL, 10, 43, 13, 38);
INSERT INTO versification_data VALUES (NULL, 10, 43, 14, 31);
INSERT INTO versification_data VALUES (NULL, 10, 43, 15, 27);
INSERT INTO versification_data VALUES (NULL, 10, 43, 16, 33);
INSERT INTO versification_data VALUES (NULL, 10, 43, 17, 26);
INSERT INTO versification_data VALUES (NULL, 10, 43, 18, 40);
INSERT INTO versification_data VALUES (NULL, 10, 43, 19, 42);
INSERT INTO versification_data VALUES (NULL, 10, 43, 20, 31);
INSERT INTO versification_data VALUES (NULL, 10, 43, 21, 25);
INSERT INTO versification_data VALUES (NULL, 10, 44, 1, 26);
INSERT INTO versification_data VALUES (NULL, 10, 44, 2, 47);
INSERT INTO versification_data VALUES (NULL, 10, 44, 3, 26);
INSERT INTO versification_data VALUES (NULL, 10, 44, 4, 37);
INSERT INTO versification_data VALUES (NULL, 10, 44, 5, 42);
INSERT INTO versification_data VALUES (NULL, 10, 44, 6, 15);
INSERT INTO versification_data VALUES (NULL, 10, 44, 7, 60);
INSERT INTO versification_data VALUES (NULL, 10, 44, 8, 40);
INSERT INTO versification_data VALUES (NULL, 10, 44, 9, 43);
INSERT INTO versification_data VALUES (NULL, 10, 44, 10, 48);
INSERT INTO versification_data VALUES (NULL, 10, 44, 11, 30);
INSERT INTO versification_data VALUES (NULL, 10, 44, 12, 25);
INSERT INTO versification_data VALUES (NULL, 10, 44, 13, 52);
INSERT INTO versification_data VALUES (NULL, 10, 44, 14, 28);
INSERT INTO versification_data VALUES (NULL, 10, 44, 15, 41);
INSERT INTO versification_data VALUES (NULL, 10, 44, 16, 40);
INSERT INTO versification_data VALUES (NULL, 10, 44, 17, 34);
INSERT INTO versification_data VALUES (NULL, 10, 44, 18, 28);
INSERT INTO versification_data VALUES (NULL, 10, 44, 19, 40);
INSERT INTO versification_data VALUES (NULL, 10, 44, 20, 38);
INSERT INTO versification_data VALUES (NULL, 10, 44, 21, 40);
INSERT INTO versification_data VALUES (NULL, 10, 44, 22, 30);
INSERT INTO versification_data VALUES (NULL, 10, 44, 23, 35);
INSERT INTO versification_data VALUES (NULL, 10, 44, 24, 27);
INSERT INTO versification_data VALUES (NULL, 10, 44, 25, 27);
INSERT INTO versification_data VALUES (NULL, 10, 44, 26, 32);
INSERT INTO versification_data VALUES (NULL, 10, 44, 27, 44);
INSERT INTO versification_data VALUES (NULL, 10, 44, 28, 31);
INSERT INTO versification_data VALUES (NULL, 10, 45, 1, 32);
INSERT INTO versification_data VALUES (NULL, 10, 45, 2, 29);
INSERT INTO versification_data VALUES (NULL, 10, 45, 3, 31);
INSERT INTO versification_data VALUES (NULL, 10, 45, 4, 25);
INSERT INTO versification_data VALUES (NULL, 10, 45, 5, 21);
INSERT INTO versification_data VALUES (NULL, 10, 45, 6, 23);
INSERT INTO versification_data VALUES (NULL, 10, 45, 7, 26);
INSERT INTO versification_data VALUES (NULL, 10, 45, 8, 39);
INSERT INTO versification_data VALUES (NULL, 10, 45, 9, 33);
INSERT INTO versification_data VALUES (NULL, 10, 45, 10, 21);
INSERT INTO versification_data VALUES (NULL, 10, 45, 11, 36);
INSERT INTO versification_data VALUES (NULL, 10, 45, 12, 21);
INSERT INTO versification_data VALUES (NULL, 10, 45, 13, 14);
INSERT INTO versification_data VALUES (NULL, 10, 45, 14, 23);
INSERT INTO versification_data VALUES (NULL, 10, 45, 15, 33);
INSERT INTO versification_data VALUES (NULL, 10, 45, 16, 27);
INSERT INTO versification_data VALUES (NULL, 10, 46, 1, 31);
INSERT INTO versification_data VALUES (NULL, 10, 46, 2, 16);
INSERT INTO versification_data VALUES (NULL, 10, 46, 3, 23);
INSERT INTO versification_data VALUES (NULL, 10, 46, 4, 21);
INSERT INTO versification_data VALUES (NULL, 10, 46, 5, 13);
INSERT INTO versification_data VALUES (NULL, 10, 46, 6, 20);
INSERT INTO versification_data VALUES (NULL, 10, 46, 7, 40);
INSERT INTO versification_data VALUES (NULL, 10, 46, 8, 13);
INSERT INTO versification_data VALUES (NULL, 10, 46, 9, 27);
INSERT INTO versification_data VALUES (NULL, 10, 46, 10, 33);
INSERT INTO versification_data VALUES (NULL, 10, 46, 11, 34);
INSERT INTO versification_data VALUES (NULL, 10, 46, 12, 31);
INSERT INTO versification_data VALUES (NULL, 10, 46, 13, 13);
INSERT INTO versification_data VALUES (NULL, 10, 46, 14, 40);
INSERT INTO versification_data VALUES (NULL, 10, 46, 15, 58);
INSERT INTO versification_data VALUES (NULL, 10, 46, 16, 24);
INSERT INTO versification_data VALUES (NULL, 10, 47, 1, 24);
INSERT INTO versification_data VALUES (NULL, 10, 47, 2, 17);
INSERT INTO versification_data VALUES (NULL, 10, 47, 3, 18);
INSERT INTO versification_data VALUES (NULL, 10, 47, 4, 18);
INSERT INTO versification_data VALUES (NULL, 10, 47, 5, 21);
INSERT INTO versification_data VALUES (NULL, 10, 47, 6, 18);
INSERT INTO versification_data VALUES (NULL, 10, 47, 7, 16);
INSERT INTO versification_data VALUES (NULL, 10, 47, 8, 24);
INSERT INTO versification_data VALUES (NULL, 10, 47, 9, 15);
INSERT INTO versification_data VALUES (NULL, 10, 47, 10, 18);
INSERT INTO versification_data VALUES (NULL, 10, 47, 11, 33);
INSERT INTO versification_data VALUES (NULL, 10, 47, 12, 21);
INSERT INTO versification_data VALUES (NULL, 10, 47, 13, 13);
INSERT INTO versification_data VALUES (NULL, 10, 48, 1, 24);
INSERT INTO versification_data VALUES (NULL, 10, 48, 2, 21);
INSERT INTO versification_data VALUES (NULL, 10, 48, 3, 29);
INSERT INTO versification_data VALUES (NULL, 10, 48, 4, 31);
INSERT INTO versification_data VALUES (NULL, 10, 48, 5, 26);
INSERT INTO versification_data VALUES (NULL, 10, 48, 6, 18);
INSERT INTO versification_data VALUES (NULL, 10, 49, 1, 23);
INSERT INTO versification_data VALUES (NULL, 10, 49, 2, 22);
INSERT INTO versification_data VALUES (NULL, 10, 49, 3, 21);
INSERT INTO versification_data VALUES (NULL, 10, 49, 4, 32);
INSERT INTO versification_data VALUES (NULL, 10, 49, 5, 33);
INSERT INTO versification_data VALUES (NULL, 10, 49, 6, 24);
INSERT INTO versification_data VALUES (NULL, 10, 50, 1, 30);
INSERT INTO versification_data VALUES (NULL, 10, 50, 2, 30);
INSERT INTO versification_data VALUES (NULL, 10, 50, 3, 21);
INSERT INTO versification_data VALUES (NULL, 10, 50, 4, 23);
INSERT INTO versification_data VALUES (NULL, 10, 51, 1, 29);
INSERT INTO versification_data VALUES (NULL, 10, 51, 2, 23);
INSERT INTO versification_data VALUES (NULL, 10, 51, 3, 25);
INSERT INTO versification_data VALUES (NULL, 10, 51, 4, 18);
INSERT INTO versification_data VALUES (NULL, 10, 52, 1, 10);
INSERT INTO versification_data VALUES (NULL, 10, 52, 2, 20);
INSERT INTO versification_data VALUES (NULL, 10, 52, 3, 13);
INSERT INTO versification_data VALUES (NULL, 10, 52, 4, 18);
INSERT INTO versification_data VALUES (NULL, 10, 52, 5, 28);
INSERT INTO versification_data VALUES (NULL, 10, 53, 1, 12);
INSERT INTO versification_data VALUES (NULL, 10, 53, 2, 17);
INSERT INTO versification_data VALUES (NULL, 10, 53, 3, 18);
INSERT INTO versification_data VALUES (NULL, 10, 54, 1, 20);
INSERT INTO versification_data VALUES (NULL, 10, 54, 2, 15);
INSERT INTO versification_data VALUES (NULL, 10, 54, 3, 16);
INSERT INTO versification_data VALUES (NULL, 10, 54, 4, 16);
INSERT INTO versification_data VALUES (NULL, 10, 54, 5, 25);
INSERT INTO versification_data VALUES (NULL, 10, 54, 6, 21);
INSERT INTO versification_data VALUES (NULL, 10, 55, 1, 18);
INSERT INTO versification_data VALUES (NULL, 10, 55, 2, 26);
INSERT INTO versification_data VALUES (NULL, 10, 55, 3, 17);
INSERT INTO versification_data VALUES (NULL, 10, 55, 4, 22);
INSERT INTO versification_data VALUES (NULL, 10, 56, 1, 16);
INSERT INTO versification_data VALUES (NULL, 10, 56, 2, 15);
INSERT INTO versification_data VALUES (NULL, 10, 56, 3, 15);
INSERT INTO versification_data VALUES (NULL, 10, 57, 1, 25);
INSERT INTO versification_data VALUES (NULL, 10, 58, 1, 14);
INSERT INTO versification_data VALUES (NULL, 10, 58, 2, 18);
INSERT INTO versification_data VALUES (NULL, 10, 58, 3, 19);
INSERT INTO versification_data VALUES (NULL, 10, 58, 4, 16);
INSERT INTO versification_data VALUES (NULL, 10, 58, 5, 14);
INSERT INTO versification_data VALUES (NULL, 10, 58, 6, 20);
INSERT INTO versification_data VALUES (NULL, 10, 58, 7, 28);
INSERT INTO versification_data VALUES (NULL, 10, 58, 8, 13);
INSERT INTO versification_data VALUES (NULL, 10, 58, 9, 28);
INSERT INTO versification_data VALUES (NULL, 10, 58, 10, 39);
INSERT INTO versification_data VALUES (NULL, 10, 58, 11, 40);
INSERT INTO versification_data VALUES (NULL, 10, 58, 12, 29);
INSERT INTO versification_data VALUES (NULL, 10, 58, 13, 25);
INSERT INTO versification_data VALUES (NULL, 10, 59, 1, 27);
INSERT INTO versification_data VALUES (NULL, 10, 59, 2, 26);
INSERT INTO versification_data VALUES (NULL, 10, 59, 3, 18);
INSERT INTO versification_data VALUES (NULL, 10, 59, 4, 17);
INSERT INTO versification_data VALUES (NULL, 10, 59, 5, 20);
INSERT INTO versification_data VALUES (NULL, 10, 60, 1, 25);
INSERT INTO versification_data VALUES (NULL, 10, 60, 2, 25);
INSERT INTO versification_data VALUES (NULL, 10, 60, 3, 22);
INSERT INTO versification_data VALUES (NULL, 10, 60, 4, 19);
INSERT INTO versification_data VALUES (NULL, 10, 60, 5, 14);
INSERT INTO versification_data VALUES (NULL, 10, 61, 1, 21);
INSERT INTO versification_data VALUES (NULL, 10, 61, 2, 22);
INSERT INTO versification_data VALUES (NULL, 10, 61, 3, 18);
INSERT INTO versification_data VALUES (NULL, 10, 62, 1, 10);
INSERT INTO versification_data VALUES (NULL, 10, 62, 2, 29);
INSERT INTO versification_data VALUES (NULL, 10, 62, 3, 24);
INSERT INTO versification_data VALUES (NULL, 10, 62, 4, 21);
INSERT INTO versification_data VALUES (NULL, 10, 62, 5, 21);
INSERT INTO versification_data VALUES (NULL, 10, 63, 1, 13);
INSERT INTO versification_data VALUES (NULL, 10, 64, 1, 15);
INSERT INTO versification_data VALUES (NULL, 10, 65, 1, 25);
INSERT INTO versification_data VALUES (NULL, 10, 66, 1, 20);
INSERT INTO versification_data VALUES (NULL, 10, 66, 2, 29);
INSERT INTO versification_data VALUES (NULL, 10, 66, 3, 22);
INSERT INTO versification_data VALUES (NULL, 10, 66, 4, 11);
INSERT INTO versification_data VALUES (NULL, 10, 66, 5, 14);
INSERT INTO versification_data VALUES (NULL, 10, 66, 6, 17);
INSERT INTO versification_data VALUES (NULL, 10, 66, 7, 17);
INSERT INTO versification_data VALUES (NULL, 10, 66, 8, 13);
INSERT INTO versification_data VALUES (NULL, 10, 66, 9, 21);
INSERT INTO versification_data VALUES (NULL, 10, 66, 10, 11);
INSERT INTO versification_data VALUES (NULL, 10, 66, 11, 19);
INSERT INTO versification_data VALUES (NULL, 10, 66, 12, 18);
INSERT INTO versification_data VALUES (NULL, 10, 66, 13, 18);
INSERT INTO versification_data VALUES (NULL, 10, 66, 14, 20);
INSERT INTO versification_data VALUES (NULL, 10, 66, 15, 8);
INSERT INTO versification_data VALUES (NULL, 10, 66, 16, 21);
INSERT INTO versification_data VALUES (NULL, 10, 66, 17, 18);
INSERT INTO versification_data VALUES (NULL, 10, 66, 18, 24);
INSERT INTO versification_data VALUES (NULL, 10, 66, 19, 21);
INSERT INTO versification_data VALUES (NULL, 10, 66, 20, 15);
INSERT INTO versification_data VALUES (NULL, 10, 66, 21, 27);
INSERT INTO versification_data VALUES (NULL, 10, 66, 22, 21);

CREATE TABLE IF NOT EXISTS styles (
  id int auto_increment primary key,
  sheet varchar(256),
  marker varchar(10),
  name varchar(256),
  info text,
  category varchar(10),
  type int,
  subtype int,
  fontsize float,
  italic int,
  bold int,
  underline int,
  smallcaps int,
  superscript int,
  justification int,
  spacebefore float,
  spaceafter float,
  leftmargin float,
  rightmargin float,
  firstlineindent float,
  spancolumns int,
  color varchar(6),
  print int,
  userbool1 int,
  userbool2 int,
  userbool3 int,
  userint1 int,
  userint2 int,
  userint3 int,
  userstring1 varchar (512),
  userstring2 varchar (512),
  userstring3 varchar (512)
);

UPDATE styles SET leftmargin = 5 WHERE (marker = 'ft' OR marker = 'xt') AND leftmargin = 0;

UPDATE styles SET firstlineindent = -5 WHERE (marker = 'ft' OR marker = 'xt') AND firstlineindent = 0;

CREATE TABLE IF NOT EXISTS config_user (
  id int auto_increment primary key,
  username varchar(30),
  bible varchar(256),
  ident varchar(100) not null,
  value varchar(1000),
  offset int not null
);

CREATE TABLE IF NOT EXISTS bible_names (
  id int auto_increment primary key,
  bible int,
  name varchar(256),
  versification varchar(256)
);

CREATE TABLE IF NOT EXISTS bible_data (
  id int auto_increment primary key,
  bible int,
  book int,
  chapter int,
  data text
);

CREATE TABLE IF NOT EXISTS bible_diff (
  id int auto_increment primary key,
  bible int,
  book int,
  chapter int,
  data text
);

CREATE TABLE IF NOT EXISTS snapshots (
  id int auto_increment primary key,
  bible int,
  book int,
  chapter int,
  data text,
  seconds int,
  persistent int
);

CREATE TABLE IF NOT EXISTS ipc (
  id int auto_increment primary key,
  channel varchar(256),
  command varchar(30),
  message text
);

CREATE TABLE IF NOT EXISTS sessions (
  id int,
  timestamp int,
  identifier varchar(256),
  value varchar(256)
);

CREATE TABLE IF NOT EXISTS notes (
  id int auto_increment primary key,
  identifier int NOT NULL,
  modified int NOT NULL,
  assigned text,
  bible varchar (256),
  passage text,
  status varchar (256),
  severity int,
  private tinyint,
  summary varchar (256),
  contents text
) ENGINE = MyISAM;

CREATE TABLE IF NOT EXISTS shell (
  name varchar(256), 
  pid varchar (256), 
  output varchar (1024), 
  run boolean
) ENGINE = MEMORY;

CREATE TABLE IF NOT EXISTS git (
  directory varchar(1024), output varchar (1024)
);

DROP PROCEDURE IF EXISTS upgrades;
DELIMITER ;;
CREATE PROCEDURE upgrades ()
BEGIN
  DECLARE CONTINUE HANDLER FOR 1060 BEGIN END;
  DECLARE CONTINUE HANDLER FOR 1061 BEGIN END;
  DECLARE CONTINUE HANDLER FOR 1091 BEGIN END;
  ALTER TABLE logs ADD level int AFTER timestamp;
  ALTER TABLE ipc ADD user varchar(30) AFTER id;
  UPDATE ipc SET user = '';
  # Table update. Subscriptions: Contains users subscribed to this note.
  ALTER TABLE notes ADD subscriptions text AFTER assigned;
  # Table update. Allow full text search on summary and contents.
  # First drop the fulltext index. If this were not done, it would create multiple indexes.
  ALTER TABLE notes DROP INDEX summary;
  ALTER TABLE notes ADD FULLTEXT(summary, contents);
  # Table update. Create index on identifier for much faster lookup.
  # This makes a huge difference if the number of notes climbs above the, say, 1000.
  CREATE INDEX id_index ON notes (identifier);
  # The table for the emails needs a bigger body size than 65535, so change the column type to MEDIUMTEXT
  ALTER TABLE mail MODIFY body MEDIUMTEXT;
END;;
CALL upgrades();;
DROP PROCEDURE upgrades;


