<h1><?php echo gettext ("Open network repository setup") ?></h1>
<?php if ($this->object == "consultationnotes") { ?>
<p><?php echo gettext ("Consultation Notes") ?></p>
<?php } else { ?>
<p><?php echo gettext ("Bible") ?>: <?php echo $this->object ?></p>
<?php } ?>
<p><?php echo gettext ("In this tutorial you are going to set up an open repository on the network.") ?></p>
<p><?php echo gettext ("You need a server to run this repository. Any of your Linux computers attached to your network will do. In this tutorial we assume that the computer is accessible from the network through IP address 192.168.0.1. The user of this computer will be Jim.") ?></p>
<p><?php echo gettext ("To create the repository, login as user jim. Then open a terminal. The repository is going to be in Jim's home directory. In the terminal type the following:") ?></p>
<pre>
cd
mkdir -p git/repository
cd git/repository
git --bare init --shared
</pre>
<p><?php echo gettext ("The repository is now there, but it is not yet accessible from the network.") ?></p>
<p><?php echo gettext ("To make the repository available to the network, type:") ?></p>
<pre>git daemon --export-all --base-path=/home/jim/git --detach --enable=receive-pack</pre>
<p><?php echo gettext ("Each time the server boots, it is necessary to execute the above command again. It would be easier to put the command in the boot script. Then it will automatically be started after boot.") ?></p>
<p><?php echo gettext ("To test access to the new repository from another computer on the network, type:") ?></p>
<pre>git ls-remote git://192.168.0.1/repository</pre>
<p><?php echo gettext ("If everything is fine, no errors will occur.") ?></p>

<a name="url"></a>
<h1><?php echo gettext ("Repository URL") ?></h1>
<p><?php echo gettext ("The repository that was created in this tutorial has the following URL:") ?></p>
<pre>git://192.168.0.1/repository</pre>
<p><?php echo gettext ("Your own repository that you have created has a URL too, the one that will be used from now on. Please enter it below, and press the Submit button to save it.") ?></p>
<form action="collaboration_open_network_setup.php?object=<?php echo $this->object ?>#url" name="url" method="post">
  <p><input type="text" name="urlvalue" value="<?php echo $this->url ?>" /></p>
  <p><input type="submit" name="url" value=<?php echo gettext ("Submit") ?> /></p>
</form>

<h2><a href="collaboration_repo_read.php?object=<?php echo $this->object ?>"><?php echo gettext ("Next page") ?></a></h2>
