<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ("../bootstrap/bootstrap.php");
page_access_level (CONSULTANT_LEVEL);


$database_config_user = Database_Config_User::getInstance ();


@$workbench = $_GET ['workbench'];
if (isset ($workbench)) {
  $workbenches = Workbench_Logic::getWorkbenches ();
  $workbench = $workbenches [$workbench];
  $database_config_user->setActiveWorkbench ($workbench);
  header ("Location: index.php");
  die;
}


$header = new Assets_Header (gettext ("Settings"));
$header->run ();
$view = new Assets_View (__FILE__);


@$delete = $_GET ['delete'];
if (isset ($delete)) {
  Workbench_Logic::deleteWorkbench ($delete);
}


if (isset ($_POST ['save'])) {
  $preset = $_POST ['preset'];
  $urls = array ();
  $widths = array ();
  $heights = array ();
  for ($row = 1; $row <= 3; $row++) {
    for ($column = 1; $column <= 5; $column++) {
      $urls [] = $_POST ["url$row$column"];
      $widths [] = $_POST ["width$row$column"];
    }
    $heights [] = Filter_Numeric::integer_in_string ($_POST ["height$row"]);
  }
  $database_config_user->setActiveWorkbench ($preset);
  Workbench_Logic::setURLs ($urls);
  Workbench_Logic::setWidths ($widths);
  Workbench_Logic::setHeights ($heights);
}


$urls = Workbench_Logic::getURLs (false);
$widths = Workbench_Logic::getWidths ();
foreach ($urls as $key => $url) {
  $row = intval ($key / 5) + 1;
  $column = $key % 5 + 1;
  $variable = "url" . $row . $column;
  $view->view->$variable = $url;
  $variable = "width" . $row . $column;
  $view->view->$variable = $widths [$key];
}


$heights = Workbench_Logic::getHeights ();
foreach ($heights as $key => $height) {
  $row = $key + 1;
  $variable = "height" . $row;
  $view->view->$variable = $height;
}


$preset = Workbench_Logic::getActiveWorkbench ();
$view->view->preset = $preset;


$workbenches = Workbench_Logic::getWorkbenches ();
$view->view->workbenches = $workbenches;


$view->render ("settings.php");


Assets_Page::footer ();


?>
