<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


class Database_History
{

  private static $instance;
  private function __construct () {
  } 
  public static function getInstance () 
  {
    if (empty (self::$instance)) {
      self::$instance = new Database_History ();
    }
    return self::$instance;
  }


  public function optimize ()
  {
    $database_instance = Database_Instance::getInstance();
    $database_instance->runQuery ("REPAIR TABLE history;");
    $database_instance->runQuery ("OPTIMIZE TABLE history;");
  }


  public function trim ()
  {
    $database_instance = Database_Instance::getInstance();
    // Delete older items.
    $time = strtotime ("-6 months");
    $query = "DELETE FROM history WHERE timestamp < $time;";
    $database_instance->runQuery ($query);

  }   


  public function record ($timestamp, $author, $bible, $book, $chapter, $verse, $oldtext, $modification, $newtext)
  {
    $timestamp = Database_SQLInjection::no ($timestamp);
    $author = Database_SQLInjection::no ($author);
    $bible = Database_SQLInjection::no ($bible);
    $book = Database_SQLInjection::no ($book);
    $chapter = Database_SQLInjection::no ($chapter);
    $verse = Database_SQLInjection::no ($verse);
    $oldtext = Database_SQLInjection::no ($oldtext);
    $modification = Database_SQLInjection::no ($modification);
    $newtext = Database_SQLInjection::no ($newtext);
    $database_instance = Database_Instance::getInstance();
    $query = "INSERT INTO history VALUES (NULL, $timestamp, '$author', '$bible', $book, $chapter, $verse, '$oldtext', '$modification', '$newtext');";
    $result = $database_instance->runQuery ($query);
  }


  public function count ($author, $bible, $book, $chapter, $verse)
  {
    $database_instance = Database_Instance::getInstance();
    $query = $this->query ($author, $bible, $book, $chapter, $verse, true);
    $result = $database_instance->runQuery ($query);
    if ($result->num_rows > 0) {
      $row = $result->fetch_row ();
      return $row [0];
    }
    return 0;
  }


  public function get ($author, $bible, $book, $chapter, $verse, $start)
  {
    $data = array ();
    $database_instance = Database_Instance::getInstance();
    $query = $this->query ($author, $bible, $book, $chapter, $verse, false, $start);
    $result = $database_instance->runQuery ($query);
    for ($i = 0; $i < $result->num_rows; $i++) {
      $row = $result->fetch_assoc ();
      $data [] = $row;
    }
    return $data;
  }
  
  
  private function query ($author, $bible, $book, $chapter, $verse, $count = false, $start = NULL)
  {
    $query = array ();
    $query [] = "SELECT";
    if ($count) $query [] = "COUNT(*)";
    else $query [] = "timestamp, author, bible, book, chapter, verse, oldtext, modification, newtext";
    $query [] = "FROM history WHERE TRUE";
    if ($author != "") {
      $author = Database_SQLInjection::no ($author);
      $query [] = "AND author = '$author'";
    }
    if ($bible != "") {
      $bible = Database_SQLInjection::no ($bible);
      $query [] = "AND bible = '$bible'";
    }
    if (is_numeric ($book)) {
      $book = Database_SQLInjection::no ($book);
      $query [] = "AND book = $book";
    }
    if (is_numeric ($chapter)) {
      $chapter = Database_SQLInjection::no ($chapter);
      $query [] = "AND chapter = $chapter";
    }
    if (is_numeric ($verse)) {
      $verse = Database_SQLInjection::no ($verse);
      $query [] = "AND verse = $verse";
    }
    if (!$count) $query [] = "ORDER BY timestamp DESC";
    if (is_numeric ($start)) {
      if ($start < 0) $start = 0;
      $start = Database_SQLInjection::no ($start);
      $query [] = "LIMIT $start, 50";
    }
    $query [] = ";";
    $query = implode (" ", $query);
    return $query;
  }


  // This function returns an array of authors in the history database.
  // They are sorted by the number of modifications made by them.
  public function authors ()
  {
    $authors = array ();
    $database_instance = Database_Instance::getInstance();
    $query = "SELECT author, COUNT(*) as count FROM history GROUP BY author ORDER BY count DESC;";
    $result = $database_instance->runQuery ($query);
    for ($i = 0; $i < $result->num_rows; $i++) {
      $row = $result->fetch_row ();
      $authors [] = $row [0];
    }
    return $authors;
  }
  
  
}



?>
