<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ("../bootstrap/bootstrap.php");
page_access_level ((Filter_Roles::MANAGER_LEVEL));


Assets_Page::header (gettext ("Users"));


$database_users = Database_Users::getInstance();


// New user creation.
if (isset ($_GET['new'])) {
  $dialog_entry = new Dialog_Entry ("", gettext ("Please enter a name for the new user"), "", "new", "");
  die;
}
if (isset($_POST['new'])) {
  $user = $_POST['entry'];
  if ($database_users->usernameExists ($user)) {
    Assets_Page::error (gettext ("User already exists"));
  } else {
    $database_users->addNewUser($user, $user, Filter_Roles::MEMBER_LEVEL, "");
    Assets_Page::success (gettext ("User created"));
  }
}


// Whether to delete a user.
if (isset ($_GET['delete'])) {
  $name = $_GET['delete'];
  @$confirm = $_GET['confirm'];
  if ($confirm == "") {
    $dialog_yes = new Dialog_Yes (NULL, gettext ("Would you like to delete") . " $name?", "delete");
    die;
  } else {
    $database_users->removeUser($name);
  }
}


// The user's role.
@$user =  $_GET['user'];
@$level = $_GET['level'];
if (isset ($user) || isset ($level)) {
  if (($user == "") || ($level == "")) {
    $dialog_list = new Dialog_List (NULL, gettext ("Would you like to change the role given to user $user?"), "", "");
    for ($i = Filter_Roles::lowest (); $i <= Filter_Roles::highest (); $i++) {
      $parameter = "?user=$user&level=$i";
      $dialog_list->add_row (Filter_Roles::text ($i), $parameter);
    }
    $dialog_list->run ();
    die;
  } else {
    $database_users->updateUserLevel($user, $level);
    $database_mail = Database_Mail::getInstance ();
    $database_mail->send ($user, gettext ("Access level change"), gettext ("Your access level was updated"));
  }
}


// User's email address.
if (isset ($_GET['username'])) {
  $dialog_entry = new Dialog_Entry (array ("usernamemail" => $_GET['username']), gettext ("Please enter an email address for the user"), $database_users->getUserToEmail ($_GET['username']), "email", "");
  die;
}
if (isset($_POST['email'])) {
  $email = $_POST['entry'];
  $validator = new Zend_Validate_EmailAddress ();
  if ($validator->isValid ($email)) {
    Assets_Page::success (gettext ("Email address was updated"));
    $database_users->updateUserEmail ($_GET['usernamemail'], $email);
  } else {
    Assets_Page::error (gettext ("The email address is not valid"));
  }
}


$view = new Assets_View (__FILE__);


// Get the level (= role) of the person that works on this page.
// This is to ensure that no users of a higher level will be listed.
// E.g. if the team manager goes to this page to manage users, the site admin will not be displayed.
$session_logic = Session_Logic::getInstance ();
$mylevel = $session_logic->currentLevel ();


$usernames = array ();
$named_roles = array ();
$emails = array ();
$users = $database_users->getUsers ();
sort ($users);
foreach ($users as $user) {
  $level = $database_users->getUserLevel ($user);
  if ($mylevel >= $level) {
    $usernames [] = $user;
    $named_roles [] = Filter_Roles::text ($level);
    $emails [] = $database_users->getUserToEmail ($user);
  }
}


$view->view->usernames = $usernames;
$view->view->levels = $named_roles;
$view->view->emails = $emails;
$view->render ("users.php");


Assets_Page::footer ();


?>
