<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


// Security: The script runs from the cli SAPI only.
if (php_sapi_name () != "cli") die;


require_once ("../bootstrap/bootstrap.php");


$database_logs = Database_Logs::getInstance ();
$database_bibles = Database_Bibles::getInstance ();
$database_config_bible = Database_Config_Bible::getInstance ();


// Go through all sub directories of the exports directory.
// Remove ones no longer relevant.
// This occurs when a Bible is no longer there or no longer being exported.
$directory = Export_Logic::mainDirectory ();
foreach (new DirectoryIterator ($directory) as $fileInfo) {
  if ($fileInfo->isDot ()) continue;
  if ($fileInfo->isDir ()) {
    $bible = $fileInfo->getFilename ();
    if ($database_config_bible->getExportDuringNight ($bible)) continue;
    $path = $fileInfo->getPathname ();
    Filter_Rmdir::rmdir ($path);
    $database_logs->log ("Removing exported Bible $bible in $path", Filter_Roles::ADMIN_LEVEL);
  }
}


// Schedule the relevant Bibles for export.
$bibles = $database_bibles->getBibles ();
foreach ($bibles as $bible) {
  if ($database_config_bible->getExportDuringNight ($bible)) {
    Export_Logic::scheduleBibleAndUSFM ($bible);
  }
}


?>
