<?php
/*
Copyright (©) 2003-2013 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


require_once ("../bootstrap/bootstrap.php");
page_access_level (Filter_Roles::TRANSLATOR_LEVEL);


$database_logs = Database_Logs::getInstance();


$session_logic = Session_Logic::getInstance ();
$userLevel = $session_logic->currentLevel ();


// Deal with AJAX call for a possible new logbook entry.
@$size = $_GET['size'];
if (isset ($size)) {
  $result = $database_logs->getNext ($size);
  if ($result) {
    $output = array ();
    $output [] = array_shift ($result);
    $result = $result [0];
    foreach ($result as $line) {
      $entryLevel = (integer) $line;
      if ($entryLevel > $userLevel) continue;
      $line = substr ($line, 2);
      $seconds = (integer) $line;
      $line = substr ($line, 10);
      $timestamp = date ('g:i:s a', $seconds);
      $event = Filter_Html::sanitize ($line);
      $output [] = "$timestamp | $event";
    }
    echo implode ("\n", $output);
  }
  die;
}


$header = new Assets_Header (gettext ("Journal"));
$header->run ();


$view = new Assets_View (__FILE__);


@$day = $_GET['day'];
if (!isset ($day)) {
  $day = 0;
}
$day = (int) $day;


$today = strtotime ("today");
$date = $today - ($day * 86400);
$date =  date ('j F Y', $date);
$view->view->date = $date;


$data = $database_logs->get ($day);
$filesize = $data [0];
$entries = $data [1];


$lines = array ();
foreach ($entries as $entry) {
  $entryLevel = (integer) $entry;
  if ($entryLevel > $userLevel) continue;
  $entry = substr ($entry, 2);
  $seconds = (integer) $entry;
  $entry = substr ($entry, 10);
  $timestamp = date ('g:i:s a', $seconds);
  $event = Filter_Html::sanitize ($entry);
  $lines [] = "$timestamp | $event";
}
$view->view->lines = $lines;


// Pass the current filesize to javascript for use by the AJAX calls for getting subsequent logbook entries.
$script = <<<EOD
var filesize = $filesize;
EOD;
// The AJAX calls for getting more logbook entries only runs when displaying
// items for 'today', not for 'yesterday' and other days.
if ($day != 0) $script = "";
$view->view->script = $script;


$view->render ("index.php");
Assets_Page::footer ();


?>
