<?php
/*
Copyright (©) 2003-2014 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/
?>
<h1><?php echo Locale_Translate::_("Discussions") ?></h1>
<p>
  <?php echo Locale_Translate::_("It is important that the more difficult or important passages of the translation are discussed by the Translation Team.") ?>
  <?php echo Locale_Translate::_("All the members of the Translation Team have the intention to produce a reliable translation.") ?>
  <?php echo Locale_Translate::_("But the views of the members about how to best put this reliable translation into words may differ.") ?>
  <?php echo Locale_Translate::_("All members will listen to each other's arguments, bring their own arguments, and come to a conclusion.") ?>
  <?php echo Locale_Translate::_("The conclusion can be reached because everybody agrees, or it can be reached by vote, or by consulting others, or a combination of this.") ?>
</p>
<br>
<p><?php echo Locale_Translate::_("Discussions shall be guided by the following rules:") ?></p>
<ol>
<li>
  <?php echo Locale_Translate::_("If a member of the Team wishes to raise an issue for discussion, that member shall create a consultation note for the team.") ?>
  <?php echo Locale_Translate::_("The consultation note will be distributed to all members of the team.") ?>
  <?php echo Locale_Translate::_("To give members time to think about the issues, and thus make the discussion more productive, the consultation note shall not be discussed immediately, but after a day or more.") ?>
</li>
<li>
  <?php echo Locale_Translate::_("The consultation note clearly describes the issue or question.") ?>
  <?php echo Locale_Translate::_("If the member desires a change, the member shall include a clear suggestion for change in the consultation note.") ?>
</li>
<li>
  <?php echo Locale_Translate::_("The members of the team shall choose a chair person.") ?>
  <?php echo Locale_Translate::_("The chair person leads the discussions, keeps the discussions on topic, ensures that procedures are followed, and keeps the time.") ?>
</li>
<li>
  <?php echo Locale_Translate::_("The members of the team are all busy and their time is valuable.") ?>
  <?php echo Locale_Translate::_("Therefore discussions should be kept short and to the point.") ?>
  <?php echo Locale_Translate::_("Personal reflections and deliberations about a passage shall not be done in the team, while others are held in suspense.") ?>
  <?php echo Locale_Translate::_("Everybody shall hold such deliberations in his own time without disturbing others.") ?>
</li>
<li>
  <?php echo Locale_Translate::_("If discussion of a consultation note is dragging on, let's say for more than 5 minutes, a vote shall be taken so as to arrive at a decision.") ?>
</li>
<li>
  <?php echo Locale_Translate::_("If a member is not satisfied with the outcome of a discussion, that member can forward the consultation note to other appropriate bodies who are able to advise the translation team.") ?>
  <?php echo Locale_Translate::_("If the matter concerns the original language, then it will be forwarded to the Bible Society.") ?>
  <?php echo Locale_Translate::_("If the matter concerns the local language, the matter should be forwarded to the group of language scholars.") ?>
  <?php echo Locale_Translate::_("If the answer from the scholars does not satisfy any member of the team, the matter can be forwarded to the panel consisting of local Church leaders and scholars.") ?>
</li>
<li>
  <?php echo Locale_Translate::_("If a consultation notes has gone through the advising bodies, and a rendering is arrived at by the majority of the members of the translation team, and this rendering does not satisfy a team member, that member can ask the matter to be forwarded to three able Church leaders.") ?>
  <?php echo Locale_Translate::_("Those able Church leaders have knowledge of Hebrew and Greek, of good commentaries and other reference materials.") ?>
  <?php echo Locale_Translate::_("The questions sent to them should be worded such that it places a low demand on their time.") ?>
  <?php echo Locale_Translate::_("The matter shall include the discussions of the translation team, the answer given by the Bible Society, shall state the rendering chosen by the majority of the team, and the alternate rendering.") ?>
  <?php echo Locale_Translate::_("The able Church leaders shall be asked whether they choose the majority rendering or the alternate.") ?>
  <?php echo Locale_Translate::_("They shall be informed that their choice defaults to the majority if no response has been received by the translation team within a month.") ?>
  <?php echo Locale_Translate::_("A vote shall be taken from the answers given by the Bible Society and each of the able Church leaders.") ?>
  <?php echo Locale_Translate::_("If the vote needs to be split, equal votes will be given to each of the members of the translation team.") ?>
</li>
</ol>
