<?xml version="1.0" encoding="iso-8859-1"?>
<!--
 * This file is part of BibORB
 * 
 * Copyright (C) 2003  Guillaume Gardey
 * 
 * BibORB is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * BibORB is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
-->
<!--
 * File: delete.xsl
 * Author: Guillaume Gardey (ggardey@club-internet.fr)
 * Year: 2003
 * Licence: GPL
 *
 * Description:
 *
 *    Delete entries in the bibliography
 *
-->
<xsl:stylesheet 
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:bibtex="http://bibtexml.sf.net/"
  version="1.0">

  <xsl:param name="id"/>

  <xsl:output method="xml" indent="yes" encoding="iso-8859-1"/>

  <!-- something i do not understand, copy-of do not copy namespace-->
  <!-- so i do it manually-->
  <xsl:template match="/">
    <xsl:element name="bibtex:file">
      <xsl:attribute name="name"><xsl:value-of select="bibtex:file/@name"/></xsl:attribute>
      <xsl:for-each select="//bibtex:entry[@id!=$id]">
        <xsl:call-template name="entry"/>
      </xsl:for-each>
    </xsl:element>
  </xsl:template>

  <xsl:template name="entry">
    <xsl:element name="bibtex:entry">
      <xsl:attribute name="id">
        <xsl:value-of select="@id"/>
      </xsl:attribute>
      <xsl:element name="bibtex:{local-name(./*[position() = 1])}">
        <xsl:for-each select="./*[position() = 1]/*">
          <xsl:element name="bibtex:{local-name(.)}">
            <xsl:value-of select="current()"/>
          </xsl:element>
        </xsl:for-each>
      </xsl:element>
    </xsl:element>
  </xsl:template>

</xsl:stylesheet>
