package Bibulus::da;

use strict;
use warnings;
use Carp;

sub populate {
  my $self = shift;

  $self->{LANGTEXT}{da}{and} ||= 'og';
  $self->{LANGTEXT}{da}{chapter}{abbr} ||= 'kap.';
  $self->{LANGTEXT}{da}{chapter}{full} ||= 'kapitel';
  $self->{LANGTEXT}{da}{comma} ||= ', ';
  $self->{LANGTEXT}{da}{edby} ||= 'redigeret af';
  $self->{LANGTEXT}{da}{edition} ||= 'udgave';
  $self->{LANGTEXT}{da}{edition}{abbr} ||= 'udg.';
  $self->{LANGTEXT}{da}{edition}{full} ||= 'udgave';
  $self->{LANGTEXT}{da}{editors}{abbr} ||= 'red.';
  $self->{LANGTEXT}{da}{editors}{full} ||= 'redaktører';
  $self->{LANGTEXT}{da}{editor}{abbr} ||= 'red.';
  $self->{LANGTEXT}{da}{editor}{full} ||= 'redaktør';
  $self->{LANGTEXT}{da}{eidpp} ||= 'sider';
  $self->{LANGTEXT}{da}{etal} ||= 'o.' . $self->nobrekspace . 'a.';
  $self->{LANGTEXT}{da}{fullstop} ||= '. ';
  $self->{LANGTEXT}{da}{in} ||= 'i';
  $self->{LANGTEXT}{da}{month}{10}{full} ||= 'oktober';
  $self->{LANGTEXT}{da}{month}{11}{full} ||= 'november';
  $self->{LANGTEXT}{da}{month}{12}{full} ||= 'december';
  $self->{LANGTEXT}{da}{month}{1}{full} ||= 'januar';
  $self->{LANGTEXT}{da}{month}{2}{full} ||= 'februar';
  $self->{LANGTEXT}{da}{month}{3}{full} ||= 'marts';
  $self->{LANGTEXT}{da}{month}{4}{full} ||= 'april';
  $self->{LANGTEXT}{da}{month}{5}{full} ||= 'maj';
  $self->{LANGTEXT}{da}{month}{6}{full} ||= 'juni';
  $self->{LANGTEXT}{da}{month}{7}{full} ||= 'juli';
  $self->{LANGTEXT}{da}{month}{8}{full} ||= 'august';
  $self->{LANGTEXT}{da}{month}{9}{full} ||= 'september';
  $self->{LANGTEXT}{da}{mthesis} ||= 'speciale';
  $self->{LANGTEXT}{da}{nr} ||= 'nr.';
  $self->{LANGTEXT}{da}{numberabbr} ||= 'nr.';
  $self->{LANGTEXT}{da}{number} ||= 'nummer';
  $self->{LANGTEXT}{da}{number}{abbr} ||= 'nr.';
  $self->{LANGTEXT}{da}{number}{full} ||= 'nummer';
  $self->{LANGTEXT}{da}{of} ||= 'af';
  $self->{LANGTEXT}{da}{page}{abbr} ||= 'p.';
  $self->{LANGTEXT}{da}{pages}{abbr} ||= 'pp.';
  $self->{LANGTEXT}{da}{page}{full} ||= 'side';
  $self->{LANGTEXT}{da}{pages}{full} ||= 'side'; # side 200-300, ikke sider...
  $self->{LANGTEXT}{da}{phdthesis} ||= 'ph.d.-afhandling';
  $self->{LANGTEXT}{da}{techrep}{abbr} ||= 'tekn. rap.';
  $self->{LANGTEXT}{da}{techrep}{full} ||= 'teknisk rapport';
  $self->{LANGTEXT}{da}{th} ||= '.';
  $self->{LANGTEXT}{da}{volume} ||= 'bind';
  $self->{LANGTEXT}{da}{volume}{abbr} ||= 'bd.';
  $self->{LANGTEXT}{da}{volume}{full} ||= 'bind';

  # The following are unique to da.pm:
  $self->{LANGTEXT}{da}{ordinal}{1} ||= 'første';
  $self->{LANGTEXT}{da}{ordinal}{2} ||= 'anden';
  $self->{LANGTEXT}{da}{ordinal}{3} ||= 'tredie';
  $self->{LANGTEXT}{da}{ordinal}{4} ||= 'fjerde';
  $self->{LANGTEXT}{da}{ordinal}{5} ||= 'femte';
  $self->{LANGTEXT}{da}{ordinal}{6} ||= 'sjette';
  $self->{LANGTEXT}{da}{ordinal}{7} ||= 'syvende';
  $self->{LANGTEXT}{da}{ordinal}{8} ||= 'ottende';
  $self->{LANGTEXT}{da}{ordinal}{9} ||= 'niende';
  $self->{LANGTEXT}{da}{ordinal}{10} ||= 'tiende';
  $self->{LANGTEXT}{da}{ordinal}{11} ||= 'elvte';
  $self->{LANGTEXT}{da}{ordinal}{12} ||= 'tolvte';
  $self->{LANGTEXT}{da}{ordinal}{13} ||= 'trettende';
  $self->{LANGTEXT}{da}{ordinal}{14} ||= 'fjortende';
  $self->{LANGTEXT}{da}{ordinal}{15} ||= 'femtende';
  $self->{LANGTEXT}{da}{ordinal}{16} ||= 'sekstende';
  $self->{LANGTEXT}{da}{ordinal}{17} ||= 'syttende';
  $self->{LANGTEXT}{da}{ordinal}{18} ||= 'attende';
  $self->{LANGTEXT}{da}{ordinal}{19} ||= 'nittende';
  $self->{LANGTEXT}{da}{cardinaland}{0} ||= '';
  $self->{LANGTEXT}{da}{cardinaland}{1} ||= 'enog';
  $self->{LANGTEXT}{da}{cardinaland}{2} ||= 'toog';
  $self->{LANGTEXT}{da}{cardinaland}{3} ||= 'treog';
  $self->{LANGTEXT}{da}{cardinaland}{4} ||= 'fireog';
  $self->{LANGTEXT}{da}{cardinaland}{5} ||= 'femog';
  $self->{LANGTEXT}{da}{cardinaland}{6} ||= 'seksog';
  $self->{LANGTEXT}{da}{cardinaland}{7} ||= 'syvog';
  $self->{LANGTEXT}{da}{cardinaland}{8} ||= 'otteog';
  $self->{LANGTEXT}{da}{cardinaland}{9} ||= 'niog';
  $self->{LANGTEXT}{da}{ordinal}{20} ||= 'tyvende';
  $self->{LANGTEXT}{da}{ordinal}{30} ||= 'tredivte';
  $self->{LANGTEXT}{da}{ordinal}{40} ||= 'fyrretyvende';
  $self->{LANGTEXT}{da}{ordinal}{50} ||= 'halvtredsindstyvende';
  $self->{LANGTEXT}{da}{ordinal}{60} ||= 'tresindstyvende';
  $self->{LANGTEXT}{da}{ordinal}{70} ||= 'halvfjerdsindstyvende';
  $self->{LANGTEXT}{da}{ordinal}{80} ||= 'firsindstyvende';
  $self->{LANGTEXT}{da}{ordinal}{90} ||= 'halvfemsindstyvende';

  $self->{LANGINIT}{da} = 1;
}

sub ordinal {
  my $self = shift;
  my ($number) = @_;

  unless ($number =~ /^\d+$/) {
    $self->warning("$number is not numeric");
    return $number;
  }

  if ($self->{STYLE}{abbrordinals}) {
    return $number . '.';
  }

  if ($number < 20) {
    return $self->{LANGTEXT}{da}{ordinal}{$number};
  } elsif ($number < 100) {
    my ($ten, $one) = (10*int($number / 10), $number % 10);
    my $res;
    $res = $self->{LANGTEXT}{da}{cardinaland}{$one};
    return $res . $self->{LANGTEXT}{da}{ordinal}{$ten};
  } else {
    warn "I don't know how to say $number"."th in Danish";
    return $number . '.';
  }
}

1;
__END__

=head1 NAME

Bibulus::Lang::da - Bibulus support for Danish

=head2 EXPORT

None.

=head1 SEE ALSO

F<Bibulus>, F<Bibulus::lang>.

The homepage is
L<http://www.nongnu.org/bibulus/>.

=head1 AUTHOR

Thomas M. Widmann, L<twid@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by Thomas M. Widmann

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
