package Bibulus::de;

use strict;
use warnings;
use Carp;

sub populate {
  my $self = shift;
  $self->{LANGTEXT}{de}{and} ||= 'und';
  $self->{LANGTEXT}{de}{etal} ||= 'et al.';
  $self->{LANGTEXT}{de}{editors}{full} ||= 'Herausgeber';
  $self->{LANGTEXT}{de}{editors}{abbr} ||= 'Hg.';
  $self->{LANGTEXT}{de}{editor}{full} ||= 'Herausgeber';
  $self->{LANGTEXT}{de}{editor}{abbr} ||= 'Hg.';
  $self->{LANGTEXT}{de}{edby} ||= 'herausgegeben von';
  $self->{LANGTEXT}{de}{edition}{full} ||= 'Auflage';
  $self->{LANGTEXT}{de}{edition}{abbr} ||= 'Aufl.';
  $self->{LANGTEXT}{de}{volume}{full} ||= 'Band';
  $self->{LANGTEXT}{de}{volume}{abbr} ||= 'Bd.';
  $self->{LANGTEXT}{de}{of} ||= 'von';
  $self->{LANGTEXT}{de}{number}{full} ||= 'Nummer';
  $self->{LANGTEXT}{de}{number}{abbr} ||= 'Nr.';
  $self->{LANGTEXT}{de}{nr} ||= 'Nr.';
  $self->{LANGTEXT}{de}{in} ||= 'in';
  $self->{LANGTEXT}{de}{pages}{full} ||= 'Seiten';
  $self->{LANGTEXT}{de}{pages}{abbr} ||= 'S.';
  $self->{LANGTEXT}{de}{page}{full} ||= 'Seite';
  $self->{LANGTEXT}{de}{page}{abbr} ||= 'S.';
  $self->{LANGTEXT}{de}{eidpp} ||= 'Seiten';
  $self->{LANGTEXT}{de}{chapter}{full} ||= 'Kapitel';
  $self->{LANGTEXT}{de}{chapter}{abbr} ||= 'Kap.';
  $self->{LANGTEXT}{de}{techrep}{full} ||= 'Technischer Bericht';
  $self->{LANGTEXT}{de}{techrep}{abbr} ||= 'Techn. Ber.';
  $self->{LANGTEXT}{de}{mthesis} ||= 'Diplomarbeit';
  $self->{LANGTEXT}{de}{phdthesis} ||= 'Doktorarbeit';
  $self->{LANGTEXT}{de}{edno}{1}{full} ||= 'Erste';
  $self->{LANGTEXT}{de}{edno}{1}{abbr} ||= '1.';
  $self->{LANGTEXT}{de}{edno}{2}{full} ||= 'Zweite';
  $self->{LANGTEXT}{de}{edno}{2}{abbr} ||= '2.';
  $self->{LANGTEXT}{de}{edno}{3}{full} ||= 'Dritte';
  $self->{LANGTEXT}{de}{edno}{3}{abbr} ||= '3.';
  $self->{LANGTEXT}{de}{edno}{4}{full} ||= 'Vierte';
  $self->{LANGTEXT}{de}{edno}{4}{abbr} ||= '4.';
  $self->{LANGTEXT}{de}{edno}{5}{full} ||= 'Fünfte';
  $self->{LANGTEXT}{de}{edno}{5}{abbr} ||= '5.';
  $self->{LANGTEXT}{de}{th} ||= '.';
  $self->{LANGTEXT}{de}{month}{1}{full} ||= 'Januar';
  $self->{LANGTEXT}{de}{month}{2}{full} ||= 'Februar';
  $self->{LANGTEXT}{de}{month}{3}{full} ||= 'März';
  $self->{LANGTEXT}{de}{month}{4}{full} ||= 'April';
  $self->{LANGTEXT}{de}{month}{5}{full} ||= 'Mai';
  $self->{LANGTEXT}{de}{month}{6}{full} ||= 'Juni';
  $self->{LANGTEXT}{de}{month}{7}{full} ||= 'Juli';
  $self->{LANGTEXT}{de}{month}{8}{full} ||= 'August';
  $self->{LANGTEXT}{de}{month}{9}{full} ||= 'September';
  $self->{LANGTEXT}{de}{month}{10}{full} ||= 'Oktober';
  $self->{LANGTEXT}{de}{month}{11}{full} ||= 'November';
  $self->{LANGTEXT}{de}{month}{12}{full} ||= 'Dezember';
  $self->{LANGTEXT}{de}{month}{1}{abbr} ||= 'Jan.';
  $self->{LANGTEXT}{de}{month}{2}{abbr} ||= 'Febr.';
  $self->{LANGTEXT}{de}{month}{3}{abbr} ||= 'März';
  $self->{LANGTEXT}{de}{month}{4}{abbr} ||= 'Apr.';
  $self->{LANGTEXT}{de}{month}{5}{abbr} ||= 'Mai';
  $self->{LANGTEXT}{de}{month}{6}{abbr} ||= 'Juni';
  $self->{LANGTEXT}{de}{month}{7}{abbr} ||= 'Juli';
  $self->{LANGTEXT}{de}{month}{8}{abbr} ||= 'Aug.';
  $self->{LANGTEXT}{de}{month}{9}{abbr} ||= 'Sept.';
  $self->{LANGTEXT}{de}{month}{10}{abbr} ||= 'Okt.';
  $self->{LANGTEXT}{de}{month}{11}{abbr} ||= 'Nov.';
  $self->{LANGTEXT}{de}{month}{12}{abbr} ||= 'Dez.';

  $self->{LANGINIT}{de} = 1;
}

1;
__END__

=head1 NAME

Bibulus::Lang::de - Bibulus support for German

=head2 EXPORT

None.

=head1 SEE ALSO

F<Bibulus>, F<Bibulus::lang>.

The homepage is
L<http://www.nongnu.org/bibulus/>.

=head1 AUTHOR

Thomas M. Widmann, L<twid@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by Thomas M. Widmann

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
