package Bibulus::eo;

use strict;
use warnings;
use Carp;

sub populate {
  my $self = shift;
  $self->{LANGTEXT}{eo}{and} ||= 'kaj';
  $self->{LANGTEXT}{eo}{etal} ||= 'kaj al.';
  $self->{LANGTEXT}{eo}{editors}{full} ||= 'redaktoroj';
  $self->{LANGTEXT}{eo}{editors}{abbr} ||= 'red-oj';
  $self->{LANGTEXT}{eo}{editor}{full} ||= 'redaktoro';
  $self->{LANGTEXT}{eo}{editor}{abbr} ||= 'red-o';
  $self->{LANGTEXT}{eo}{edby}{full} ||= 'redaktita de';
  $self->{LANGTEXT}{eo}{edby}{abbr} ||= 'red-ita de';
  $self->{LANGTEXT}{eo}{edition}{full} ||= 'eldono';
  $self->{LANGTEXT}{eo}{edition}{abbr} ||= 'eld-o';
  $self->{LANGTEXT}{eo}{volume}{full} ||= 'volumo';
  $self->{LANGTEXT}{eo}{volume}{abbr} ||= 'vol-o';
  $self->{LANGTEXT}{eo}{of} ||= 'el';
  $self->{LANGTEXT}{eo}{number}{full} ||= 'numero';
  $self->{LANGTEXT}{eo}{number}{abbr} ||= 'n-ro';
  $self->{LANGTEXT}{eo}{nr} ||= 'n-ro';
  $self->{LANGTEXT}{eo}{in} ||= 'en';
  $self->{LANGTEXT}{eo}{pages}{full} ||= 'paĝoj';
  $self->{LANGTEXT}{eo}{pages}{abbr} ||= 'pĝ.';
  $self->{LANGTEXT}{eo}{page}{full} ||= 'paĝo';
  $self->{LANGTEXT}{eo}{page}{abbr} ||= 'pĝ.';
  $self->{LANGTEXT}{eo}{eidpp} ||= 'paĝoj';
  $self->{LANGTEXT}{eo}{chapter}{full} ||= 'ĉapitro';
  $self->{LANGTEXT}{eo}{chapter}{abbr} ||= 'ĉap-o';
  $self->{LANGTEXT}{eo}{techrep}{full} ||= 'Teknika Raporto';
  $self->{LANGTEXT}{eo}{techrep}{abbr} ||= 'Tek-a Rap-o';
  $self->{LANGTEXT}{eo}{mthesis} ||= 'Magistra tezo';
  $self->{LANGTEXT}{eo}{phdthesis} ||= 'Doktora tezo';
  $self->{LANGTEXT}{eo}{th} ||= '-a';
  $self->{LANGTEXT}{eo}{number}{1} ||= 'unu';
  $self->{LANGTEXT}{eo}{number}{2} ||= 'du';
  $self->{LANGTEXT}{eo}{number}{3} ||= 'tri';
  $self->{LANGTEXT}{eo}{number}{4} ||= 'kvar';
  $self->{LANGTEXT}{eo}{number}{5} ||= 'kvin';
  $self->{LANGTEXT}{eo}{number}{6} ||= 'ses';
  $self->{LANGTEXT}{eo}{number}{7} ||= 'sep';
  $self->{LANGTEXT}{eo}{number}{8} ||= 'ok';
  $self->{LANGTEXT}{eo}{number}{9} ||= 'naŭ';
  $self->{LANGTEXT}{eo}{number}{10} ||= 'dek';
  $self->{LANGTEXT}{eo}{number}{100} ||= 'cent';
  $self->{LANGTEXT}{eo}{month}{1}{full} ||= 'januaro';
  $self->{LANGTEXT}{eo}{month}{2}{full} ||= 'februaro';
  $self->{LANGTEXT}{eo}{month}{3}{full} ||= 'marto';
  $self->{LANGTEXT}{eo}{month}{4}{full} ||= 'aprilo';
  $self->{LANGTEXT}{eo}{month}{5}{full} ||= 'majo';
  $self->{LANGTEXT}{eo}{month}{6}{full} ||= 'junio';
  $self->{LANGTEXT}{eo}{month}{7}{full} ||= 'julio';
  $self->{LANGTEXT}{eo}{month}{8}{full} ||= 'aŭgusto';
  $self->{LANGTEXT}{eo}{month}{9}{full} ||= 'septembro';
  $self->{LANGTEXT}{eo}{month}{10}{full} ||= 'oktobro';
  $self->{LANGTEXT}{eo}{month}{11}{full} ||= 'novembro';
  $self->{LANGTEXT}{eo}{month}{12}{full} ||= 'decembro';

  $self->{LANGINIT}{eo} = 1;
}

sub datemonth {
  my $self = shift;
  my $year = shift;
  my $month = shift;
  my $day; @_ and $day = shift;

  my $r = $year;

  $month or warn "No month given\n", return $r;

  $r = "$month $year";

  $

sub month {
  my $self = shift;
  my $month = shift;
  if (!$self->{ABBR}{MONTH}) {
    return $self->{LANGTEXT}{eo}{month}{$month}{full};
  } else {
    return substr($self->{LANGTEXT}{eo}{month}{$month}{full}, 0, 3) . '.';
  }
}

1;
__END__

=head1 NAME

Bibulus::Lang::eo - Bibulus support for Esperanto

=head2 EXPORT

None.

=head1 SEE ALSO

F<Bibulus>, F<Bibulus::lang>.

The homepage is
L<http://www.nongnu.org/bibulus/>.

=head1 AUTHOR

Thomas M. Widmann, L<twid@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by Thomas M. Widmann

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
