package Bibulus;

# This file is part of Bibulus.
# For copyright and license, please refer to ../Bibulus.pm

sub formatauthors {
  my $self = shift;


  my $i = $self->{CUREL}->first_child('author');
  unless (defined($i)) {
    $self->warning("No <author>");
    return;
  }

  $self->outputtext($self->formatnames($i));
}

sub returneditors {
  my $self = shift;

  my $i = $self->{CUREL}->first_child('editor');
  unless (defined($i)) {
    $self->warning("No <editor>");
    return;
  }

  return $self->formatnames($i) . ' (editor)';
}

sub formateditors {
  my $self = shift;

  $self->outputtext($self->returneditors);
}

sub formatnames {
  my $self = shift;

  my $authed = shift;

  my @r;
  my @d = $authed->descendants('name');
  foreach my $i (0 .. $#d) {
    push @r, $self->formatname($d[$i], $i);
  }

  return $self->andlist(@r);
}

sub formatname {
  my $self = shift;

  my $name = shift;
  my $pos = shift;

  my ($given, $von, $family, $extrafamily, $jr)
    = (perhapstext($name->first_child('given')),
       perhapstext($name->first_child('von')),
       perhapstext($name->first_child('family')),
       perhapstext($name->first_child('extrafamily')),
       perhapstext($name->first_child('jr')));

  my $r = $family;

  defined($extrafamily) and $r .= ' ' . $extrafamily;

  defined($von) and $self->{STYLE}{vonbefore}
    and $r = "$von $r";

  defined($given) and $self->{STYLE}{givenbefore}
    and $r = "$given $r";

  defined($given) and !$self->{STYLE}{givenbefore}
    and $r .= ", $given";

  defined($jr) and $r .= ", $von";

  return $r;
}

# if the text field is defined, then return it else undef
sub perhapstext {
  my $e = shift;
  if (defined($e)) {
    return $e->text;
  } else {
    return undef;
  }
}

sub formatnewblock {
  my $self = shift;

  $self->getstate ne 'beforeall'
    and $self->setstate('afterblock');

  $self->{DIDWRITESOMETHING} = 0;
}

sub newsentence {
  my $self = shift;

  $self->getstate ne 'afterblock'
    and $self->getstate ne 'beforeall'
      and $self->setstate('aftersentence');
  $self->{DIDWRITESOMETHING} = 0;
}

sub finentry {
  my $self = shift;

  $self->{CURR} .= $self->fullstop . "\n";
}

# Taken from BibTeX:
sub output {
  my $self = shift;
  my $s = shift;
  $s and $self->outputnonnull($s);
}

sub outputcheck {
  my $self = shift;
  my $f = shift;
  my $s = $self->getfield($f);
  if ($s) {
    $self->outputnonnull($s);
  } else {
    warn("Empty <$f>");
  }
}

sub outputnonnull {
  my $self = shift;

  print STDERR "State is ", $self->getstate, ".\n" if $DEBUG;
  print STDERR "CURR is <<$self->{CURR}>>.\n" if $DEBUG;

  if ($self->getstate eq 'midsentence') {
    $self->{CURR} .= $self->comma if $self->{DIDWRITESOMETHING};
  } else {
    if ($self->getstate eq 'afterblock') {
      $self->{CURR} .= $self->fullstop if $self->canaddperiod;
      $self->{CURR} .= $self->newblock;
    } else {
      if ($self->getstate ne 'beforeall') {
	$self->{CURR} .= $self->fullstop if $self->canaddperiod;
      }
    }
    $self->setstate('midsentence');
  }
}

# Return true if CURR doesn't end in a period or similar already
sub canaddperiod {
  my $self = shift;
  if ($self->{CURR} =~ /[\.\?\!]\W*$/) {
    return 0;
  } else {
    return 1;
  }
}

sub formattitle {
  my $self = shift;
  my $type = shift;

  my $t = $self->getfield('title', 1);

  $t = $self->language($self->{CUREL}->inherit_att('xml:lang'), $t);

  # This approach:
  defined($type) and $type eq 'emph' and $t = $self->emph($t);
  # conflicts with this one:
  if (defined($self->{STYLE}{titlefont})) {
    if ($self->{STYLE}{titlefont} eq 'emph') {
      $t = $self->emph($t);
    } elsif ($self->{STYLE}{titlefont} eq 'bold') {
      $t = $self->bold($t);
    }
  }

  $self->outputtext($t);
}

sub formatjournal {
  my $self = shift;
  my $type = shift;


  my $t = $self->getfield('journal', 1);

  $t = $self->emph($t);

  $self->outputtext($t);
}

sub formatinstitution {
  my $self = shift;

  my $inst = $self->getfield('institution');

  $self->outputtext($inst);
}

sub formatpublisher {
  my $self = shift;

  my $publ = $self->getfield('publisher');

  $self->outputtext($publ);
}

sub formatvolnumpages {
  my $self = shift;


  my $volume = $self->getfield('volume');
  my $number = $self->getfield('number');
  my $pages = $self->getfield('pages');

  my $t = '';
  $t .= $volume if $volume;

  if ($number) {
    $t .= "($number)";
    $volume or $self->warning("There's a <number> but no <volume>");
  }

  if ($pages) {
    if ($t) {
      $t .= ":$pages";
    } else {
      $t = $pages;
    }
  }
  $self->outputtext($t);
}

sub formatnumberseries {
  my $self = shift;

  $self->getfield('volume') and return; # Skip if there's a volume

  my $number = $self->getfield('number');
  my $series = $self->getfield('series');

  my $t = '';

  if (!$number) {
    $t = $series;
  } else {
    $self->warning("There's a <number> but no <series>") unless $series;
    $t .= $self->numberseries($number, $series);
  }

  $self->outputtext($t);
}

sub outputtext {
  my $self = shift;
  my $t = shift;
  if ($t) {
    # Upcase first letter if necessary (will this work for all languages?):
    $self->getstate eq 'midsentence' or $t = "\u$t";

    # Output punctuation and change state:
    $self->outputnonnull;

    # Output the text:
    $self->{CURR} .= $t;
    $self->{DIDWRITESOMETHING} = 1;
  }
}

sub formatvolume {
  my $self = shift;

  my $t = $self->getfield('volume', 1);

  $t and $t = "volume $t";

  $self->outputtext($t);
}

sub formatinedbooktitle {
  my $self = shift;

  my $t = '';
  my $title = $self->getfield('booktitle');
  my $editor = $self->getfield('editor');

  if ($title) {
    $t = 'In ';
    if ($editor) {
      $t .= $self->returneditors . $self->comma;
    }
    $t .= $self->emph($title);
  }

  $self->outputtext($t);
}

sub formatbvolume {
  my $self = shift;

  my $t = '';
  my $volume = $self->getfield('volume');
  my $series = $self->getfield('series');
  my $number = $self->getfield('number'); # only needed for validation!

  if ($volume) {
    $t = $self->volume($volume, $series && $self->emph($series));
    if ($number) {
      $self->warning("Can't use both <volume> and <number> fields");
    }
  }

  $self->outputtext($t);
}

sub formatthesistype {
  my $self = shift;

  my $type = $self->getatt('type');

  $self->outputtext($self->thesis($type));
}

sub formatdateasyear {
  my $self = shift;

  my $t = $self->getfield('year', 1);

  $self->outputtext($t);
}

sub formathowpublished {
  my $self = shift;

  my $t = $self->getfield('howpublished');

  $self->outputtext($t);
}

sub formatedition {
  my $self = shift;


  my $t = $self->getfield('edition');

  $t and $t = $self->edition($t);

  $self->outputtext($t);
}

sub formatpublisheraddress {
  my $self = shift;

  my $t = $self->getfield('publisher');
  $self->outputtext($t);

  $t = $self->getfield('place');
  $self->outputtext($t);
}

sub formataddress {
  my $self = shift;

  my $t = $self->getfield('place');
  $self->outputtext($t);
}

sub formatcrossref {
  my $self = shift;

  my $i = $self->{CUREL}->first_child('crossref');
  unless (defined($i)) {
    $self->warning("No <crossref>");
    return;
  }

  my $t = $i->atts->{id};

  $self->outputtext($self->in($self->outputcite($t)));
}

sub formatchapterpages {
  my $self = shift;

  my $pages = $self->getfield('pages');
  my $chapter = $self->getfield('chapter');

  if (!$chapter) {
    $self->formatpages;
  } else {
    # TYPE has been eliminated -- might come in again as attribute
    my $t = $self->chapter($chapter);
    $pages and $t .= ", $pages";
    $self->outputtext($t);
  }
}

sub formattrnumber {
  my $self = shift;

  my $number = $self->getfield('number');

  # TYPE has been eliminated -- might come in again as attribute
  my $t = $self->technicalreport($number);
  $self->outputtext($t);
}

sub formatpages {
  my $self = shift;

  my $t = $self->getfield('pages', 1);

  $self->outputtext($t);
}

sub formatrest {
  my $self = shift;

  # handle notes, annotations, ISBN & ISSN numbers etc. here

  my $i = $self->{CUREL}->first_child('note');
  if (defined($i)) {
    my $t = $i->text;
    $self->outputtext($t);
  }
}

1;
