package Bibulus::en;

use strict;
use warnings;
use Carp;

sub populate {
  my $self = shift;
  $self->{LANGTEXT}{en}{and} ||= 'and';
  $self->{LANGTEXT}{en}{comma} ||= ', ';
  $self->{LANGTEXT}{en}{fullstop} ||= '. ';
  $self->{LANGTEXT}{en}{in} ||= 'in';
  $self->{LANGTEXT}{en}{technicalreport} ||= 'Technical Report';
  $self->{LANGTEXT}{en}{numberabbr} ||= 'no.';
  $self->{LANGTEXT}{en}{of} ||= 'of';

  $self->{LANGTEXT}{en}{etal} ||= 'et al.';
  $self->{LANGTEXT}{en}{editors}{full} ||= 'editors';
  $self->{LANGTEXT}{en}{editors}{abbr} ||= 'eds.';
  $self->{LANGTEXT}{en}{editor}{full} ||= 'editor';
  $self->{LANGTEXT}{en}{editor}{abbr} ||= 'ed.';
  $self->{LANGTEXT}{en}{edby} ||= 'edited by';
  $self->{LANGTEXT}{en}{edition}{full} ||= 'edition';
  $self->{LANGTEXT}{en}{edition}{abbr} ||= 'edn.';
  $self->{LANGTEXT}{en}{volume}{full} ||= 'volume';
  $self->{LANGTEXT}{en}{volume}{abbr} ||= 'vol.';
  $self->{LANGTEXT}{en}{number}{full} ||= 'number';
  $self->{LANGTEXT}{en}{number}{abbr} ||= 'no.';
  $self->{LANGTEXT}{en}{nr} ||= 'no.';
  $self->{LANGTEXT}{en}{pages}{full} ||= 'pages';
  $self->{LANGTEXT}{en}{pages}{abbr} ||= 'pp.';
  $self->{LANGTEXT}{en}{page}{full} ||= 'page';
  $self->{LANGTEXT}{en}{page}{abbr} ||= 'p.';
  $self->{LANGTEXT}{en}{eidpp} ||= 'pages';
  $self->{LANGTEXT}{en}{chapter}{full} ||= 'chapter';
  $self->{LANGTEXT}{en}{chapter}{abbr} ||= 'chap.';
  $self->{LANGTEXT}{en}{techrep}{full} ||= 'Technical Report';
  $self->{LANGTEXT}{en}{techrep}{abbr} ||= 'Tech. Rep.';
  $self->{LANGTEXT}{en}{master} ||= 'Master\'s thesis';
  $self->{LANGTEXT}{en}{phd} ||= 'Ph.D. thesis';
  $self->{LANGTEXT}{en}{doctor} ||= 'Doctoral thesis';
  $self->{LANGTEXT}{en}{bachelor} ||= 'Bachelor project';

  $self->{LANGTEXT}{en}{edno}{1}{full} ||= 'First';
  $self->{LANGTEXT}{en}{edno}{1}{abbr} ||= '1st';
  $self->{LANGTEXT}{en}{edno}{2}{full} ||= 'Second';
  $self->{LANGTEXT}{en}{edno}{2}{abbr} ||= '2nd';
  $self->{LANGTEXT}{en}{edno}{3}{full} ||= 'Third';
  $self->{LANGTEXT}{en}{edno}{3}{abbr} ||= '3rd';
  $self->{LANGTEXT}{en}{edno}{4}{full} ||= 'Fourth';
  $self->{LANGTEXT}{en}{edno}{4}{abbr} ||= '4th';
  $self->{LANGTEXT}{en}{edno}{5}{full} ||= 'Fifth';
  $self->{LANGTEXT}{en}{edno}{5}{abbr} ||= '5th';
  $self->{LANGTEXT}{en}{st} ||= 'st';
  $self->{LANGTEXT}{en}{nd} ||= 'nd';
  $self->{LANGTEXT}{en}{rd} ||= 'rd';
  $self->{LANGTEXT}{en}{th} ||= 'th';

  $self->{LANGTEXT}{en}{month1}{full} ||= 'January';
  $self->{LANGTEXT}{en}{month2}{full} ||= 'February';
  $self->{LANGTEXT}{en}{month3}{full} ||= 'March';
  $self->{LANGTEXT}{en}{month4}{full} ||= 'April';
  $self->{LANGTEXT}{en}{month5}{full} ||= 'May';
  $self->{LANGTEXT}{en}{month6}{full} ||= 'June';
  $self->{LANGTEXT}{en}{month7}{full} ||= 'July';
  $self->{LANGTEXT}{en}{month8}{full} ||= 'August';
  $self->{LANGTEXT}{en}{month9}{full} ||= 'September';
  $self->{LANGTEXT}{en}{month10}{full} ||= 'October';
  $self->{LANGTEXT}{en}{month11}{full} ||= 'November';
  $self->{LANGTEXT}{en}{month12}{full} ||= 'December';
  $self->{LANGTEXT}{en}{month1}{abbr} ||= 'Jan.';
  $self->{LANGTEXT}{en}{month2}{abbr} ||= 'Feb.';
  $self->{LANGTEXT}{en}{month3}{abbr} ||= 'Mar.';
  $self->{LANGTEXT}{en}{month4}{abbr} ||= 'Apr.';
  $self->{LANGTEXT}{en}{month5}{abbr} ||= 'May';
  $self->{LANGTEXT}{en}{month6}{abbr} ||= 'Jun.';
  $self->{LANGTEXT}{en}{month7}{abbr} ||= 'Jul.';
  $self->{LANGTEXT}{en}{month8}{abbr} ||= 'Aug.';
  $self->{LANGTEXT}{en}{month9}{abbr} ||= 'Sep.';
  $self->{LANGTEXT}{en}{month10}{abbr} ||= 'Oct.';
  $self->{LANGTEXT}{en}{month11}{abbr} ||= 'Nov.';
  $self->{LANGTEXT}{en}{month12}{abbr} ||= 'Dec.';

  $self->{LANGTEXT}{en}{city}{"'s Gravenhage"} ||= 'The Hague';
  $self->{LANGTEXT}{en}{city}{Braunschweig} ||= 'Brunswick';
  $self->{LANGTEXT}{en}{city}{"København"} ||= 'Copenhagen';
  $self->{LANGTEXT}{en}{city}{"Köln"} ||= 'Cologne';
  $self->{LANGTEXT}{en}{city}{Milano} ||= 'Milan';
  $self->{LANGTEXT}{en}{city}{"München"} ||= 'Munich';
  $self->{LANGTEXT}{en}{city}{Praha} ||= 'Prague';
  $self->{LANGTEXT}{en}{city}{Roma} ||= 'Rome';
  $self->{LANGTEXT}{en}{city}{Sevilla} ||= 'Seville';
  $self->{LANGTEXT}{en}{city}{Torino} ||= 'Turin';
  $self->{LANGTEXT}{en}{city}{Wien} ||= 'Vienna';

  # The following are unique to en.pm:
  $self->{LANGTEXT}{en}{ordinal}{1} ||= 'first';
  $self->{LANGTEXT}{en}{ordinal}{2} ||= 'second';
  $self->{LANGTEXT}{en}{ordinal}{3} ||= 'third';
  $self->{LANGTEXT}{en}{ordinal}{4} ||= 'forth';
  $self->{LANGTEXT}{en}{ordinal}{5} ||= 'fifth';
  $self->{LANGTEXT}{en}{ordinal}{6} ||= 'sixth';
  $self->{LANGTEXT}{en}{ordinal}{7} ||= 'seventh';
  $self->{LANGTEXT}{en}{ordinal}{8} ||= 'eighth';
  $self->{LANGTEXT}{en}{ordinal}{9} ||= 'ninth';
  $self->{LANGTEXT}{en}{ordinal}{10} ||= 'tenth';
  $self->{LANGTEXT}{en}{ordinal}{11} ||= 'eleventh';
  $self->{LANGTEXT}{en}{ordinal}{12} ||= 'twelfth';
  $self->{LANGTEXT}{en}{ordinal}{13} ||= 'thirteenth';
  $self->{LANGTEXT}{en}{ordinal}{14} ||= 'fourteenth';
  $self->{LANGTEXT}{en}{ordinal}{15} ||= 'fifteenth';
  $self->{LANGTEXT}{en}{ordinal}{16} ||= 'sixteenth';
  $self->{LANGTEXT}{en}{ordinal}{17} ||= 'seventeenth';
  $self->{LANGTEXT}{en}{ordinal}{18} ||= 'eighteenth';
  $self->{LANGTEXT}{en}{ordinal}{19} ||= 'nineteenth';
  $self->{LANGTEXT}{en}{cardinal}{20} ||= 'twenty';
  $self->{LANGTEXT}{en}{cardinal}{30} ||= 'thirty';
  $self->{LANGTEXT}{en}{cardinal}{40} ||= 'forty';
  $self->{LANGTEXT}{en}{cardinal}{50} ||= 'fifty';
  $self->{LANGTEXT}{en}{cardinal}{60} ||= 'sixty';
  $self->{LANGTEXT}{en}{cardinal}{70} ||= 'seventy';
  $self->{LANGTEXT}{en}{cardinal}{80} ||= 'eighty';
  $self->{LANGTEXT}{en}{cardinal}{90} ||= 'ninety';

  $self->{LANGINIT}{en} = 1;
}

sub ordinal {
  my $self = shift;
  my ($number) = @_;

  unless ($number =~ /^\d+$/) {
    $self->warning("$number is not numeric");
    return $number;
  }

  if ($self->{ORDABBR}) {
    return $number . '.';
  }

  if ($number < 20) {
    return $self->{LANGTEXT}{ordinal}{$number};
  } elsif ($number < 100) {
    my ($ten, $one) = (10*int($number / 10), $number % 10);
    if ($one == 0) {
      my $res = $self->{LANGTEXT}{cardinal}{$ten};
      $res =~ s/y$/ieth/;
      return $res;
    } else {
      return $self->{LANGTEXT}{cardinal}{$ten}
	. '-' . $self->{LANGTEXT}{ordinal}{$one};
    }
  } else {
    $self->warning("I don't know how to say number $number in English");
    return $number . 'th';
  }
}

1;
__END__

=head1 NAME

Bibulus::Lang::en - Bibulus support for English

=head2 EXPORT

None.

=head1 SEE ALSO

F<Bibulus>, F<Bibulus::lang>.

The homepage is
L<http://www.nongnu.org/bibulus/>.

=head1 AUTHOR

Thomas M. Widmann, L<twid@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by Thomas M. Widmann

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
