package Bibulus;

# This file is part of Bibulus.
# For copyright and license, please refer to ../Bibulus.pm

sub formatentry {
  my $self = shift;
  my ($e) = @_;
  my $t;

  my $attr = $e->atts;

  print "formatentry(", $e->tag, ")\n" if $DEBUG;

  # necessary to handle punctuation
  $self->setstate('beforeall');
  $self->{DIDWRITESOMETHING} = 0;

  # this should never happen, but check
  unless (defined($attr->{id})) {  # an entry must have an id
    warn "No ID for entry.\n";
    return;
  }

  # save a couple of useful variables in the tree
  $self->{CUREL} = $e;
  $self->{CURR} = $self->item_start($attr->{id}, $e->field('label'));

  # do some transformations
  $self->transform($e);

  $e->print if $DEBUG;
  print "\n" if $DEBUG;

  # calculate positions for everything using the l_ functions
  my @res;
  foreach my $i ($e->children) {
    my $type = $i->tag;
    my $locfunc = "l_$type";
    print "Hand over item of type $type to $locfunc.\n" if $DEBUG;
    my $loc = $self->$locfunc($i);
    $loc > 0 and push @res, [$loc, $i];  # 0 means 'not for output'
  }

  # sort the elements
  @res = sort {$a->[0] <=> $b->[0]} @res;

  # now traverse elements to add punctuation and format
  for (my $i = 0; $i <= $#res; ++$i) {
    my $prev; $prev = $res[$i - 1][1] if $i > 0;
    my $next; $next = $res[$i + 1][1] if $i < $#res;
    my $type = $res[$i][1]->tag;

    # first call punctuation functions
    if (defined($prev)) {
      my $func = "po_" . $prev->tag;
      print "Hand over item of type $type to $func.\n" if $DEBUG;
      $self->$func($prev, $prev->tag, $type);
      $func = "pr_$type";
      print "Hand over item of type $type to $func.\n" if $DEBUG;
      $self->$func($res[$i][1], $prev->tag, $type);
    }

    # and finally format the current element using the f_ functions
    my $func = "f_$type";
    print "Hand over item of type $type to $func.\n" if $DEBUG;
    $self->$func($res[$i][1]);
  }

  # that's it!  End the entry
  $self->finentry;
  $self->{CURR} .= $self->item_end;
}


sub transform {  # do some transformation of the XML tree before formatting
  my $self = shift;
  my $e = shift;

  # Insert the 'T' word. ;-)
  if ($e->tag eq 'thesis') {
    my $type = $e->att('type');
    my $w = $e->new('thesisword');
    $w->paste('last_child', $e->root);
    $w->suffix($self->getword($type));

  }

  # Group volume, number and pages if all are defined
  if (defined($e->first_child('volume')) and
      defined($e->first_child('number')) and
      defined($e->first_child('pages'))) {
    my $v = $e->first_child('volume')->cut;
    my $n = $e->first_child('number')->cut;
    my $p = $e->first_child('pages')->cut;
    my $vnp = $e->new('volnumpages');
    $vnp->paste('last_child', $e->root);
    $v->paste('last_child', $vnp);
    $n->paste('last_child', $vnp);
    $p->paste('last_child', $vnp);
  }

  # Group volume and series
  if (defined($e->first_child('volume')) and
      defined($e->first_child('series'))) {
    my $v = $e->first_child('volume')->cut;
    my $s = $e->first_child('series')->cut;
    my $vs = $e->new('volseries');
    $vs->paste('last_child', $e->root);
    $v->paste('last_child', $vs);
    $s->paste('last_child', $vs);
  }
}

1;
