package Bibulus::pt;

use strict;
use warnings;
use Carp;

sub populate {
  my $self = shift;
  $self->{LANGTEXT}{pt}{and} ||= 'e';
  $self->{LANGTEXT}{pt}{etal} ||= 'et al.';
  $self->{LANGTEXT}{pt}{editors}{full} ||= 'editores';
  $self->{LANGTEXT}{pt}{editors}{abbr} ||= 'eds.';
  $self->{LANGTEXT}{pt}{editor}{full} ||= 'editor';
  $self->{LANGTEXT}{pt}{editor}{abbr} ||= 'ed.';
  $self->{LANGTEXT}{pt}{edby} ||= 'editado por';
  $self->{LANGTEXT}{pt}{edition}{full} ||= 'edição';
  $self->{LANGTEXT}{pt}{edition}{abbr} ||= 'ed.';
  $self->{LANGTEXT}{pt}{volume} ||= 'volume';
  $self->{LANGTEXT}{pt}{of} ||= 'de';
  $self->{LANGTEXT}{pt}{number}{full} ||= 'número';
  $self->{LANGTEXT}{pt}{number}{abbr} ||= 'nº';
  $self->{LANGTEXT}{pt}{nr} ||= 'nº';
  $self->{LANGTEXT}{pt}{in} ||= 'in';
  $self->{LANGTEXT}{pt}{pages}{full} ||= 'páginas';
  $self->{LANGTEXT}{pt}{pages}{abbr} ||= 'págs.';
  $self->{LANGTEXT}{pt}{page}{full} ||= 'página';
  $self->{LANGTEXT}{pt}{page}{abbr} ||= 'pág.';
  $self->{LANGTEXT}{pt}{eidpp} ||= 'páginas';
  $self->{LANGTEXT}{pt}{chapter}{full} ||= 'capítulo';
  $self->{LANGTEXT}{pt}{chapter}{abbr} ||= 'cap.';
  $self->{LANGTEXT}{pt}{techrep}{full} ||= 'Relatório Técnico';
  $self->{LANGTEXT}{pt}{techrep}{abbr} ||= 'Rel. Téc.';
  $self->{LANGTEXT}{pt}{mthesis} ||= 'Tese de Mestrado';
  $self->{LANGTEXT}{pt}{phdthesis} ||= 'Tese de Doutoramento';
  $self->{LANGTEXT}{pt}{edno}{1}{full} ||= 'primeira';
  $self->{LANGTEXT}{pt}{edno}{1}{abbr} ||= '1ª';
  $self->{LANGTEXT}{pt}{edno}{2}{full} ||= 'segunda';
  $self->{LANGTEXT}{pt}{edno}{2}{abbr} ||= '2ª';
  $self->{LANGTEXT}{pt}{edno}{3}{full} ||= 'terceira';
  $self->{LANGTEXT}{pt}{edno}{3}{abbr} ||= '3ª';
  $self->{LANGTEXT}{pt}{edno}{4}{full} ||= 'quarta';
  $self->{LANGTEXT}{pt}{edno}{4}{abbr} ||= '4ª';
  $self->{LANGTEXT}{pt}{edno}{5}{full} ||= 'quinta';
  $self->{LANGTEXT}{pt}{edno}{5}{abbr} ||= '5ª';
  $self->{LANGTEXT}{pt}{th} ||= 'ª';
  $self->{LANGTEXT}{pt}{month1}{full} ||= 'janeiro';
  $self->{LANGTEXT}{pt}{month2}{full} ||= 'fevereiro';
  $self->{LANGTEXT}{pt}{month3}{full} ||= 'março';
  $self->{LANGTEXT}{pt}{month4}{full} ||= 'abril';
  $self->{LANGTEXT}{pt}{month5}{full} ||= 'maio';
  $self->{LANGTEXT}{pt}{month6}{full} ||= 'junho';
  $self->{LANGTEXT}{pt}{month7}{full} ||= 'julho';
  $self->{LANGTEXT}{pt}{month8}{full} ||= 'agosto';
  $self->{LANGTEXT}{pt}{month9}{full} ||= 'setembro';
  $self->{LANGTEXT}{pt}{month10}{full} ||= 'outubro';
  $self->{LANGTEXT}{pt}{month11}{full} ||= 'novembro';
  $self->{LANGTEXT}{pt}{month12}{full} ||= 'dezembro';
  $self->{LANGTEXT}{pt}{month1}{abbr} ||= 'jan.';
  $self->{LANGTEXT}{pt}{month2}{abbr} ||= 'fev.';
  $self->{LANGTEXT}{pt}{month3}{abbr} ||= 'mar.';
  $self->{LANGTEXT}{pt}{month4}{abbr} ||= 'abr.';
  $self->{LANGTEXT}{pt}{month5}{abbr} ||= 'maio';
  $self->{LANGTEXT}{pt}{month6}{abbr} ||= 'jun.';
  $self->{LANGTEXT}{pt}{month7}{abbr} ||= 'jul.';
  $self->{LANGTEXT}{pt}{month8}{abbr} ||= 'ago.';
  $self->{LANGTEXT}{pt}{month9}{abbr} ||= 'set.';
  $self->{LANGTEXT}{pt}{month10}{abbr} ||= 'out.';
  $self->{LANGTEXT}{pt}{month11}{abbr} ||= 'nov.';
  $self->{LANGTEXT}{pt}{month12}{abbr} ||= 'dez.';

  $self->{LANGINIT}{pt} = 1;
}

1;
__END__

=head1 NAME

Bibulus::Lang::pt - Bibulus support for Portuguese

=head2 EXPORT

None.

=head1 SEE ALSO

F<Bibulus>, F<Bibulus::lang>.

The homepage is
L<http://www.nongnu.org/bibulus/>.

=head1 AUTHOR

Thomas M. Widmann, L<twid@cpan.org>

=head1 COPYRIGHT AND LICENSE

Copyright 2003 by Thomas M. Widmann

This module is free software; you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation; either version 2 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
USA.

=cut
