package Bibulus;

# This file is part of Bibulus.
# For copyright and license, please refer to ../Bibulus.pm

# This file contains punctuation functions.

sub pr_author {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_author {
  my $self = shift;
  my ($i, $nexttype) = @_;

  $self->formatnewblock;
}

sub pr_editor {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_editor {
  my $self = shift;
  my ($i, $nexttype) = @_;

  $self->formatnewblock;
}

sub pr_title {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_title {
  my $self = shift;
  my ($i, $nexttype) = @_;

  $self->formatnewblock;
}

sub pr_thesisword {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_thesisword {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_chapter {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_chapter {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_howpublished {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_howpublished {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_key {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_key {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_journal {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_journal {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_volnumpages {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_volnumpages {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_volume {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_volume {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_number {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_number {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_crossref {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_crossref {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_pages {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_pages {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_year {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_year {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_publisher {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_publisher {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_institution {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_institution {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_issn {
  my $self = shift;
  my ($i, $prevtype) = @_;

  $self->formatnewblock;
}

sub po_issn {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_url {
  my $self = shift;
  my ($i, $prevtype) = @_;

  $self->formatnewblock;
}

sub po_url {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_place {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_place {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_series {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_series {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_volseries {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_volseries {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_edition {
  my $self = shift;
  my ($i, $prevtype) = @_;

#  $self->formatnewblock;
}

sub po_edition {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}

sub pr_note {
  my $self = shift;
  my ($i, $prevtype) = @_;

  $self->formatnewblock;
}

sub po_note {
  my $self = shift;
  my ($i, $nexttype) = @_;

#  $self->formatnewblock;
}


###################################################
# Functions that deal with punctuation and output #
###################################################

# Put a new block here.
sub formatnewblock {
  my $self = shift;

  $self->getstate ne 'beforeall'
    and $self->setstate('afterblock');

  $self->{DIDWRITESOMETHING} = 0;
}

# Put a new sentence here.
sub newsentence {
  my $self = shift;

  $self->getstate ne 'afterblock'
    and $self->getstate ne 'beforeall'
      and $self->setstate('aftersentence');
  $self->{DIDWRITESOMETHING} = 0;
}

sub finentry {
  my $self = shift;

  $self->{CURR} .= $self->fullstop . "\n";
}

sub output {
  my $self = shift;
  my $s = shift;
  $s and $self->outputnonnull($s);
}

sub outputcheck {
  my $self = shift;
  my $f = shift;
  my $s = $self->getfield($f);
  if ($s) {
    $self->outputnonnull($s);
  } else {
    warn("Empty <$f>");
  }
}

sub outputnonnull {
  my $self = shift;

  print STDERR "State is ", $self->getstate, ".\n" if $DEBUG;
  print STDERR "CURR is <<$self->{CURR}>>.\n" if $DEBUG;

  if ($self->getstate eq 'midsentence') {
    $self->{CURR} .= $self->comma if $self->{DIDWRITESOMETHING};
  } elsif ($self->getstate eq 'afterblock') {
    $self->{CURR} .= $self->fullstop if $self->canaddperiod;
    $self->{CURR} .= $self->newblock;
  } elsif ($self->getstate ne 'beforeall') {
    $self->{CURR} .= $self->fullstop if $self->canaddperiod;
  }
  $self->setstate('midsentence');
}

# Return true if CURR doesn't end in a period or similar already
sub canaddperiod {
  my $self = shift;
  if ($self->{CURR} =~ /[\.\?\!]\W*$/) {
    return 0;
  } else {
    return 1;
  }
}

sub outputtext {
  my $self = shift;
  my $t = shift;
  if ($t) {
    # Upcase first letter if necessary (will this work for all languages?):
    $self->getstate eq 'midsentence' or $t = "\u$t";

    # Output punctuation and change state:
    $self->outputnonnull;

    # Output the text:
    $self->{CURR} .= $t;
    $self->{DIDWRITESOMETHING} = 1;
  }
}

# set state equivalent to BibTeX's output.state:
sub setstate {
  my $self = shift;
  my $state = shift;

  if ($state eq 'beforeall' or
      $state eq 'midsentence' or
      $state eq 'aftersentence' or
      $state eq 'afterblock') {
    $self->{STATE} = $state;
  } else {
    croak "Unknown state $state.\n";
  }
}

# return state equivalent to BibTeX's output.state:
sub getstate {
  my $self = shift;
  return $self->{STATE};
}

1;
