-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.


local game = string.format("%d count", billiards.distance)

if billiards.cushion then
   game = game .. string.format (", %d-cushion", billiards.cushions)
end

if billiards.balkline then
   game = game .. string.format (", %d.%d balkline",
				 100 * billiards.balkspacing,
				 billiards.allowedcounts)
end

if not billiards.cushion and not billiards.balkline then
   game = game .. " straight rail billiards"
else
   game = game .. " billiards"
end

graph.display = widgets.display {
   position = {0.5, 0.5, 0},
   background = {0.28, 0.24, 0.55},

   lowerright = widgets.row {
      size = {0, 0.93},
      align = -1,
      
      widgets.column {
	 size = {0.95, 0},
	 align = 1
      }
   },

   lowerleft = widgets.row {
      size = {0, 0.93},
      align = -1,
      
      widgets.column {
	 size = {0.95, 0},
	 align = -1,

	 faces.small (string.format("Try connecting to http://127.0.0.1:%d " ..
				    "with your browser.", network.port)) {
	    opacity = 5
	 }
      }
   },

   upperright = widgets.row {
      size = {0, 0.93},
      align = 1,
      
      widgets.column {
	 size = {0.95, 0},
	 align = 1,

	 faces.small (game) {}
      }
   },

   upperleft = widgets.row {
      size = {0, 0.95},
      align = 1,
      
      widgets.column {
	 size = {0.95, 0},
	 align = -1,
	 padding = {0, 0.01},
	 
	 -- The score board
	 
	 widgets.frame {
	    color = {0.93, 0.77, 0.56},
	    thickness = 1.6,
	    opacity = 0.2,

	    cells = widgets.row {
	       widgets.column {
		  size = {0.3, 0},
		  padding = {0.01, 0.01},
		  align = -1,
	       },
	       
	       widgets.column {
		  padding = {0.01, 0.01},
	       }
	    }
	 },
	 
	 -- Shot parameters

	 widgets.frame {
	    color = {0.93, 0.77, 0.56},
	    thickness = 1.6,
	    opacity = 0.2,

	    cells = widgets.row {
	       widgets.column {
		  padding = {0.007, 0.007},
		  align = -1,
		  
		  faces.small "Sidespin" {},
		  faces.small "Topspin" {},
		  faces.small "Elevation" {}
	       },
	       
	       widgets.column {
		  size = {0.07, 0},
		  align = 1,
		  padding = {0.007, 0.007},
	       }
	    }
	 }
      }
   }
}

score = graph.display.upperleft[1][1]
info = graph.display.upperleft[1][2]
misc = graph.display.lowerright[1]
event = graph.display.lowerleft[1]
title = graph.display.upperright[1]

graph.fader = frames.timer {
   period = 0,

   transform = function (tick, delta, elapsed)
		  if event[1] then
		     event[1].opacity = event[1].opacity - delta
		 
		     if event[1].opacity <= 0.01 then
			event[1] = nil
		     end
		  end
	       end
}

billiards.adjusting.display = function ()
   local r = 100 / billiards.ballradius

   info.cells[2][3] = faces.small (string.format ("%2d", cue.elevation)) {}
   info.cells[2][1] = faces.small (string.format("%2d%%", r * cue.english[1])) {}
   info.cells[2][2] = faces.small (string.format("%2d%%", r * cue.english[2])) {}
end

billiards.newshot.display = function ()
   -- Update the displays.

   for i = 1, billiards.players do
      score.cells[1][i] = faces.regular (balls[i].name) {}
      score.cells[2][i] = faces.regular (string.format ("% d  % d",
							balls[i].counts,
							balls[i].games)) {}
   end

   info.cells[2][1] = faces.small "0%" {}
   info.cells[2][2] = faces.small "0%" {}
   info.cells[2][3] = faces.small "0" {}
end