-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.


local z = 0.7 * billiards.tablewidth
local w = 0.5 * billiards.tablewidth + 0.25
local h = 0.5 * billiards.tableheight + 0.25

graph.observer.lamp = shading.light {
   position = {0, 0, z},
   orientation = transforms.euler (180, 0, 0),

   intensity = imagery.spot,
   attenuation = {1.1, 0, 0},
   
   offset = {0, 2},
   size = {1024, 512},
   volume = {-0.5 * w, 0.5 * w, -0.5 * h, 0.5 * h, 0.5 * z, 2 * z}
}

graph.observer.bouncedlight = shading.ambient {
   intensity = imagery.roomambience
}

graph.observer.fog = shading.fog {
   quadratic = 0.04,
   offset = 3,
   color = graphics.canvas
}

graph.observer.floor = shading.phong {
   position = {0, 0, -0.866},

   diffuse = imagery.parquet.diffuse,
   specular = imagery.parquet.specular,
   parameter = 64,

   geometry.floor {}
}

graph.observer.table = shading.phong {
   diffuse = imagery.table.diffuse,
   specular = imagery.table.specular,
   parameter = 32,

   geometry.table(),
}

graph.observer.diamonds = shading.phong {
   position = {0, 0, 1e-4},
   diffuse = {0.97, 0.87, 0.72},
   specular = {0.45, 0.435 , 0.425},
   parameter = 16,

   geometry.diamonds(),
}

graph.observer.cloth = shading.oren {
   diffuse = imagery.cloth,
   parameter = 3.2,
   
   geometry.cloth(),
}

graph.observer.gear.bouncedlight = shading.ambient {
   orientation = transforms.euler (0, 0, 0),
   intensity = imagery.tableambience,
}     

graph.observer.gear.cue.surface = shading.phong {
   diffuse = imagery.cue,
   specular = {0.7, 0.7, 0.7},
   parameter = 64,
   
   geometry = geometry.cue()
}

graph.observer.gear.whiteball.surface = shading.phong {
   diffuse = {0.97, 0.97, 0.82},
   specular = {0.5, 0.5, 0.5},
   parameter = 32,

   geometry = geometry.sphere()
}

	 
graph.observer.gear.yellowball.surface = shading.phong {
   diffuse = {0.92, 0.66, 0.18},
   specular = {0.7, 0.7, 0.7},
   parameter = 32,
	    
   geometry = geometry.sphere()
}
	 
graph.observer.gear.redball.surface = shading.phong {
   diffuse = {0.35, 0.1, 0.09},
   specular = {0.7, 0.7, 0.7},
   parameter = 32,

   geometry = geometry.sphere()
}
