-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.


local w = billiards.tablewidth
local h = billiards.tableheight
local r = billiards.ballradius
local h_0 = billiards.cushionheight

graph.gauge = frames.timer {
   period = 1,

   link = function ()
	      graphics.oldframes = graphics.frames
	   end,

   traverse = function (n, delta, elapsed)
		 local rate = (graphics.frames - graphics.oldframes) / delta
		 misc[1] = faces.regular (string.format ("%.1f", rate)) {}

		 graphics.oldframes = graphics.frames
	      end
}

graph.camera = bodies.system {
   eye = bodies.body {
      mass = physics.spheremass (1e-5, 1)
   },

   torso = bodies.body {
      mass = physics.spheremass (1e-5, 1)
   },
}

graph.observer = frames.observer {
   position = {0, 0, -2},
   node = graph.camera.eye
}

graph.observer.gear = bodies.system {
   static = bodies.environment {
      bed = bodies.box {
	 position = {0, 0, -0.05},
	 size = {w, h, 0.1},
      },

      westcushion = bodies.capsule {
	 orientation = transforms.euler (0, 90, 0),
	 radius = 0.0005,
	 length = w,
	 position = {0, 0.5 * h, h_0}
      },

      eastcushion = bodies.capsule {
	 orientation = transforms.euler (0, 90, 0),
	 radius = 0.0005,
	 length = w,
	 position = {0, -0.5 * h, h_0}
      },

      northcushion = bodies.capsule {
	 orientation = transforms.euler (90, 0, 0),
	 radius = 0.0005,
	 length = h,
	 position = {0.5 * w, 0, h_0}
      },

      southcushion = bodies.capsule {
	 orientation = transforms.euler (90, 0, 0),
	 radius = 0.0005,
	 length = h,
	 position = {-0.5 * w, 0, h_0}
      },

      floor = bodies.plane {
	 position = {0, 0, -0.866}
      }
   },

   cue = bodies.capsule {
      length = 0.6 * billiards.cuelength,
      radius = 0,
      mass =  {billiards.cuemass,
	       {0, 0, 0},
	       {billiards.cueinertia, 0, 0,
		0, billiards.cueinertia, 0,
		0, 0, 9.13e-6}},
   },

   whiteball = bodies.billiard {
      radius = billiards.ballradius,
      mass = physics.spheremass (3 * billiards.ballmass /
				 (4 * math.pi *
				  billiards.ballradius^3),
			      billiards.ballradius),

      friction = {
	 billiards.rollingfriction,
	 billiards.spinningfriction
      },

      name = billiards.firstname,
      counts = 0,
      games = 0,

      bounces = {}
   },

   yellowball = bodies.billiard {
      radius = billiards.ballradius,
      mass = physics.spheremass (3 * billiards.ballmass /
				 (4 * math.pi *
				  billiards.ballradius^3),
			      billiards.ballradius),

      friction = {
	 billiards.rollingfriction,
	 billiards.spinningfriction
      },

      name = billiards.secondname,
      counts = 0,
      games = 0,

      bounces = {}
   },
   
   redball = bodies.billiard {
      radius = billiards.ballradius,
      mass = physics.spheremass (3 * billiards.ballmass /
				 (4 * math.pi *
				  billiards.ballradius^3),
			      billiards.ballradius),
      
      friction = {
	 billiards.rollingfriction,
	 billiards.spinningfriction
      },

      bounces = {}
   }
}

eye = graph.camera.eye
torso = graph.camera.torso

observer = graph.observer
cue = graph.observer.gear.cue

floor = graph.observer.gear.static.floor
bed = graph.observer.gear.static.bed
westcushion = graph.observer.gear.static.westcushion
eastcushion = graph.observer.gear.static.eastcushion
northcushion = graph.observer.gear.static.northcushion
southcushion = graph.observer.gear.static.southcushion

balls = {
   graph.observer.gear.whiteball,
   graph.observer.gear.yellowball,
   graph.observer.gear.redball
}

cueball = graph.observer.gear.whiteball
objectball = graph.observer.gear.yellowball
redball = graph.observer.gear.redball

waist = joints.universal {
   bodies = {torso, nil}
}

neck = joints.slider {
   bodies = {torso, eye}
}

hand = joints.slider {
   bodies = {cue, nil},
   motor = {0, billiards.cueforce},
   stops = {{-0.1, 0.4}, {0, 0}, 0}
}
