-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.


local function enumerate(n)
   if n == 1 then
      return "1st"
   elseif n == 2 then
      return "2nd"
   else
      return tostring(n) .. "th"
   end
end

local function default (page, arguments)
   local content

   if arguments.newgame then
      for key, value in pairs(arguments) do
	 if key == "firstname" or key == "secondname" then
	    billiards[key] = tostring(value)
	 else
	    billiards[key] = tonumber(value)
	 end
      end
   
      billiards.balkline = arguments.game == "balkline"
      billiards.cushion = arguments.game == "cushion"
      billiards.straight = arguments.game == "straight"

      billiards.drawtrajectories = arguments.drawtrajectories ~= nil
      billiards.drawvectors = arguments.drawvectors ~= nil
      billiards.drawcenterline = arguments.drawcenterline ~= nil
      billiards.drawsidelines = arguments.drawsidelines ~= nil

      dofile "scripts/reset.lua"
   end

   if arguments.setsystemoptions then
      graphics.window = {tonumber(arguments.width),
			 tonumber(arguments.height)}
      graphics.field = tonumber(arguments.field)
      
      simulator.stepsize = tonumber(arguments.stepsize)
      simulator.iterations = tonumber(arguments.iterations)
   end

   content = [[
<head>
<title>Billiards</title>
<link rel="stylesheet" href="stylesheet" type="text/css">
</head>

<body>
<hr> 
<h1><iframe style="width : 8em ; height : 3em"
            frameborder="0" src="logo">Billiards
</iframe></h1>
<a href="/newgame">new game</a>
&middot;
<a href="/system">system options</a>
&middot;
<a href="/shots">shot history</a>
<hr> 

<p>
Hello and welcome to Billiards, the free billiards simulator. Use the links at the top to start a new game, review the current game or to change system options like window size etc.  Although it's probably easy to figure out how to play Billiards yourself, there are features that are not so obvious so be sure to read the manual if you haven't done so allready.
</p>

<p>
If you want to save the current configuration as the default click <a href="/writeoptions">this</a> link and until there's a dedicated page for recording video and stills you can also follow <a href="/screenshot">this</a> link to take a screenshot.
</p>
      ]]

   if billiards.players > 1 then
      content = content .. string.format([[
<p>There's currently a match in progress between <b>%s</b> and <b>%s</b>.  This is the <b>%s game</b> of the match and
					 ]],
				      billiards.firstname,
				      billiards.secondname,
				      enumerate(balls[1].games +
						balls[2].games + 1))
      
      if balls[1].counts ~= balls[2].counts then
	 local difference = balls[1].counts - balls[2].counts

	 content = content .. string.format([[
<b>%s</b> leads by <b>%d</b> count%s.</p>
					    ]],
					 difference > 0 and
					    balls[1].name or balls[2].name,
					 math.abs(difference),
					 math.abs(difference) ~= 1 and "s" or "")
      else
	 content = content .. string.format([[
the players are tied at <b>%d</b> count%s.
					    ]],
					    balls[1].counts,
					    balls[1].counts ~= 1 and "s" or "")
      end
   else
      content = content .. string.format([[
<p>There's currently a practice match in progress.  This is the <b>%s game</b> of the match and <b>%s</b> has scored <b>%d</b> counts so far.</p>
				      ]],
				   enumerate(balls[1].games + 1),
				   billiards.firstname,
				   balls[1].counts)
   end
   
   return content .. [[
</body>
      ]]
end

network.pages["/"] = default
network.mime["/"] = "text/html"