-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.


local function options (page, arguments)
   local content

   content = string.format ([[
<head>

<title>New game</title>
<link rel="stylesheet" href="stylesheet">

<style type="text/css">
  col.first {width : 12em;}
  col.second {width : 7em ;}
</style>

</head>

<hr> 

<h1>
<iframe style="width : 8em ; height : 3em"
        frameborder="0" src="logo">Billiards
</iframe>
</h1>

<a href="javascript:document.forms[0].submit()">done</a>
&middot;
<a href="javascript:document.forms[0].reset()">reset</a>
&middot;
<a href = "/">cancel</a>

<hr>

<p>
You can set various system options with this form.
</p>

<p>
<form action="/" method="get">
<table>

<tr><th colspan="3">Graphics
<tr class="odd"><td>Window width:
<td><input type="text" name="width" maxlength="7" size="7" value="%d"
<td>The width of the window in pixels.
<tr class="even"><td>Window height:
<td><input type="text" name="height" maxlength="7" size="7" value="%d"
<td>The height of the window in pixels.
<tr class="odd"><td>Field of view:
<td><input type="text" name="field" maxlength="3" size="7" value="%d"
<td>The camera's field of view in degrees.

<tr><th colspan="3">Simulator
<tr class="odd"><td>Step size:
<td><input type="text" name="stepsize" maxlength="7" size="7" value="%f"
<td>The size of the steps taken by the simulator in seconds.  The rule
    of thumb is: the smaller, the better, the slower.
<tr class="even"><td>Iterations:
<td><input type="text" name="iterations" maxlength="7" size="7" value="%d"
<td>Setting this to a non-zero value chooses a faster, but also less accurate,
    iterative solver.
<tr><td colspan="3">
<input name="setsystemoptions" type="hidden" value="yes"/>
</table>
</p>
</form>
			    ]],
			 graphics.window[1], graphics.window[2],
			 graphics.field, simulator.stepsize,
			 simulator.iterations)

   return content
end

network.mime["/system"] = "text/html"
network.pages["/system"] = options