/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <GL/glu.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "capsule.h"

@implementation Capsule

-(Capsule *) init
{
    [super init];

    self->quadric = gluNewQuadric();
    gluQuadricDrawStyle(self->quadric, GLU_LINE);
    gluQuadricNormals(self->quadric, GLU_NONE);

    self->geom = dCreateCapsule (NULL, 1, 1);
    self->radius = 1;
    self->length = 1;
    
    dGeomSetBody ([self geom], [self body]);
    
    return self;
}

-(dReal) radius
{
    return self->radius;
}

-(dReal) length
{
    return self->length;
}

-(void) get: (lua_State *)L
{
    const char *k;
    
    k = lua_tostring(L, -1);

    if (!strcmp(k, "radius")) {
	lua_pushnumber(L, [self radius]);
    } else if (!strcmp(k, "length")) {
	lua_pushnumber(L, [self length]);
    } else {
	[super get: L];
    }
}

-(void) set: (lua_State *)L
{
    const char *k;

    k = lua_tostring(L, -2);

    if (!strcmp(k, "radius")) {
	radius = lua_tonumber(L, 3);

	dGeomCapsuleSetParams ([self geom], [self radius], [self length]);
    } else if (!strcmp(k, "length")) {
	length = lua_tonumber(L, 3);

	dGeomCapsuleSetParams ([self geom], [self radius], [self length]);
    } else {
	[super set: L];
    }
}

#if 0
-(void) traverse: (lua_State *)L
{
    GLfloat *r, *R;

    glUseProgramObjectARB(0);

    r = [self translation];
    R = [self rotation];

    glMatrixMode (GL_MODELVIEW);
    glPushMatrix();
    glMultMatrixf ((GLfloat[16]) {R[0], R[3], R[6], 0,
		                  R[1], R[4], R[7], 0,
		                  R[2], R[5], R[8], 0,
		                  r[0], r[1], r[2], 1});

    glEnable (GL_DEPTH_TEST);

    glColor3f (1, 0, 0);
    glTranslatef (0, 0, -0.5 * self->length);
    gluCylinder (self->quadric, self->radius, self->radius,
		 self->length, 16, 1);
    
    glDisable (GL_DEPTH_TEST);

    glPopMatrix();

    [super traverse: L];
}
#endif

@end
