/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>

#include "column.h"

@implementation Column

-(void) transform: (lua_State *)L
{
    id child;

    [super transform: L];
    
    self->allocated[0] = 2 * self->padding[0];
    self->allocated[1] = self->padding[1];
    
    for(child = [self children] ; child ; child = [child sister]) {
	float w;

	w = [child width] + 2 * self->padding[0];
	
	self->allocated[0] = w > self->allocated[0] ? w : self->allocated[0];
	self->allocated[1] += [child height] + self->padding[1];
    }

    self->allocated[0] = self->allocated[0] > self->requested[0] ?
	              self->allocated[0] : self->requested[0];
    self->allocated[1] = self->allocated[1] > self->requested[1] ?
	              self->allocated[1] : self->requested[1];
}

-(void) cleanup: (lua_State *)L
{
    id child;
    
    glMatrixMode (GL_MODELVIEW);
    glPushMatrix();
    glTranslatef (0, self->allocated[1] / 2, 0);

    for(child = [self children] ; child ; child = [child sister]) {
	glTranslatef (0, - [child height] / 2 - self->padding[1], 0);

	glPushMatrix();
	if (self->align < 0) {
	    glTranslatef ([child width] / 2 - self->allocated[0] / 2 +
			  self->padding[0], 0, 0);
	} else if (self->align > 0) {
	    glTranslatef (self->allocated[0] / 2 - [child width] / 2 -
			  self->padding[0], 0, 0);
	}
	
	[child cleanup: L];

	glMatrixMode (GL_MODELVIEW);
	glPopMatrix();
	
	glTranslatef (0, - [child height] / 2, 0);
    }

    glPopMatrix();
}

@end

