/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _HEIGHTFIELD_H_
#define _HEIGHTFIELD_H_

#include <lua.h>
#include <GL/gl.h>
#include "body.h"

@interface Heightfield: Body {
    dHeightfieldDataID data;
    int width, height;
}

-(Heightfield *) initWithFloats: (float *) floats
                         ofSize: (int[2]) size
		       spanning: (float[2]) area
		       scaledBy: (float) scale
		       offsetBy: (float) offset
		       andThickenedBy: (float) thickness;
-(int) width;
-(int) height;
-(dHeightfieldDataID) data;

@end

#endif
