/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef _NODE_H_
#define _NODE_H_

#include <lua.h>
#include <GL/gl.h>
#include <ode/ode.h>
#include "item.h"

@interface Node: Item {
    int linked;
    int link, unlink, prepare, transform, traverse, cleanup;
   
    GLfloat position[3], orientation[9];
    GLfloat translation[3], rotation[9];
}

-(int) linked;
-(GLfloat *) position;
-(GLfloat *) orientation;
-(GLfloat *) translation;
-(GLfloat *) rotation;

-(dWorldID) world;
-(dJointGroupID) group;
-(dSpaceID) space;

-(void) toggle: (lua_State *)L;
-(void) transform: (lua_State *)L;
-(void) prepare: (lua_State *)L;
-(void) traverse: (lua_State *)L;
-(void) cleanup: (lua_State *)L;
-(void) get: (lua_State *)L;
-(void) set: (lua_State *)L;

@end

#endif
