/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "ray.h"

@implementation Ray

-(Ray *) init
{
    [super init];

    self->geom = dCreateRay (NULL, 1);
    self->length = 1;
    
    dGeomSetBody ([self geom], [self body]);
    
    return self;
}

-(void) get: (lua_State *)L
{
    const char *k;
    
    k = lua_tostring(L, -1);

    if (!strcmp(k, "length")) {
	lua_pushnumber(L, self->length);
    } else {
	[super get: L];
    }
}

-(void) set: (lua_State *)L
{
    const char *k;

    k = lua_tostring(L, -2);

    if (!strcmp(k, "length")) {
	self->length = lua_tonumber(L, 3);

	dGeomRaySetLength ([self geom], self->length);
    } else {
	[super set: L];
    }
}

/* -(void) traverse: (lua_State *)L */
/* { */
/*     GLfloat *r, *R; */

/*     r = [self translation]; */
/*     R = [self rotation]; */
 
/*     glMatrixMode (GL_MODELVIEW); */
/*     glPushMatrix(); */
/*     glMultMatrixf ((GLfloat[16]) {R[0], R[3], R[6], 0, */
/* 		                  R[1], R[4], R[7], 0, */
/* 		                  R[2], R[5], R[8], 0, */
/* 		                  r[0], r[1], r[2], 1}); */

/*     glUseProgramObjectARB(0); */
/*     glLineWidth(3); */
/*     glColor3f(1, 0, 0); */

/*     glBegin(GL_LINES); */
/*     glVertex3f(0, 0, 0); */
/*     glVertex3f(0, 0, 1); */
/*     glEnd(); */

/*     glPointSize(3); */
/*     glColor3f(0, 0, 1); */

/*     glBegin(GL_POINTS); */
/*     glVertex3f(0, 0, 0); */
/*     glEnd(); */

/*     glPopMatrix(); */

/*     [super traverse: L]; */
/* } */

@end
