/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "slider.h"
#include "body.h"

@implementation Slider

-(Joint *) init
{
    [super init];

    self->joint = dJointCreateSlider ([self world], NULL);

    self->stops[0] = -dInfinity;
    self->stops[1] = dInfinity;

    self->axis[0] = 0;
    self->axis[1] = 0;
    self->axis[2] = 1;

    return self;
}

-(void) get: (lua_State *)L
{
    const char *k;
    int i;
    
    k = lua_tostring(L, -1);

    if (!strcmp(k, "axis")) {
        lua_newtable(L);
        
        for(i = 0; i < 3; i += 1) {
            lua_pushnumber(L, self->axis[i]);
            lua_rawseti(L, -2, i + 1);
        }
    } else if (!strcmp(k, "motor")) {
        lua_newtable(L);
        
        for(i = 0; i < 2; i += 1) {
            lua_pushnumber(L, self->motor[i]);
            lua_rawseti(L, -2, i + 1);
        }
    } else if (!strcmp(k, "stops")) {
        lua_newtable(L);

        lua_newtable(L);
        for(i = 0; i < 2; i += 1) {
            lua_pushnumber(L, self->stops[i]);
            lua_rawseti(L, -2, i + 1);
        }
	lua_rawseti(L, -2, 1);
	
        lua_newtable(L);
        for(i = 0; i < 2; i += 1) {
            lua_pushnumber(L, self->hardness[i]);
            lua_rawseti(L, -2, i + 1);
        }
	lua_rawseti(L, -2, 2);

	lua_pushnumber(L, self->bounce);
	lua_rawseti(L, -2, 3);
    } else if (!strcmp(k, "tolerance")) {
	lua_pushnumber(L, self->tolerance);
    } else if (!strcmp(k, "state")) {
	dReal state[2];

	if ([self joint]) {
	    state[0] = dJointGetSliderPosition ([self joint]);
	    state[1] = dJointGetSliderPositionRate ([self joint]);

	    lua_newtable(L);
        
	    for(i = 0 ; i < 2 ; i += 1) {
		lua_pushnumber(L, state[i]);
		
		lua_rawseti(L, -2, i + 1);
	    }
	} else {
	    lua_pushnil(L);
	}
    } else {
	[super get: L];
    }
}

-(void) set: (lua_State *)L
{
    const char *k;
    int i;

    k = lua_tostring(L, -2);

    if (!strcmp(k, "axis")) {
        if(lua_istable(L, 3)) {
            for(i = 0 ; i < 3 ; i += 1) {
                lua_rawgeti(L, 3, i + 1);
                self->axis[i] = lua_tonumber(L, -1);
                
                lua_pop(L, 1);
            }

	    if(dJointGetBody([self joint], 0) ||
	       dJointGetBody([self joint], 1)) {
		dJointSetSliderAxis ([self joint],
				     self->axis[0],
				     self->axis[1],
				     self->axis[2]);
	    }
        }
    } else if (!strcmp(k, "motor")) {
        if(lua_istable(L, 3)) {
            for(i = 0 ; i < 2 ; i += 1) {
                lua_rawgeti(L, 3, i + 1);
                self->motor[i] = lua_tonumber(L, -1);
                
                lua_pop(L, 1);
            }

	    dJointSetSliderParam ([self joint], dParamVel, self->motor[0]);
	    dJointSetSliderParam ([self joint], dParamFMax, self->motor[1]);
	}
    } else if (!strcmp(k, "stops")) {
        if(lua_istable(L, 3)) {
	    lua_rawgeti(L, 3, 1);
	    for(i = 0 ; i < 2 ; i += 1) {
		lua_rawgeti(L, -1, i + 1);
		
		self->stops[i] = lua_tonumber(L, -1);
		
		lua_pop(L, 1);
	    }
	    lua_pop(L, 1);

	    lua_rawgeti(L, 3, 2);
	    for(i = 0 ; i < 2 ; i += 1) {
		lua_rawgeti(L, -1, i + 1);

		self->hardness[i] = lua_tonumber(L, -1);

		lua_pop(L, 1);
	    }
	    lua_pop(L, 1);
	
	    lua_rawgeti(L, 3, 3);
	    self->bounce = lua_tonumber(L, -1);
	    lua_pop(L, 1);

	    /* Resetting the stops makes sure that lo remains
	       smaller than hi between calls. */
	
	    dJointSetSliderParam ([self joint], dParamLoStop, -dInfinity);
	    dJointSetSliderParam ([self joint], dParamHiStop, dInfinity);

	    dJointSetSliderParam ([self joint], dParamLoStop,
				  self->stops[0]);
	    dJointSetSliderParam ([self joint], dParamHiStop,
				  self->stops[1]);
	    dJointSetSliderParam ([self joint], dParamStopCFM,
				  self->hardness[0]);
	    dJointSetSliderParam ([self joint], dParamStopERP,
				  self->hardness[1]);
	    dJointSetSliderParam ([self joint], dParamBounce, self->bounce);
	}
    } else if (!strcmp(k, "tolerance")) {
	self->tolerance = lua_tonumber(L, 3);

	dJointSetSliderParam ([self joint], dParamCFM, self->tolerance);
    } else if (!strcmp(k, "bodies")) {
	[super set: L];

	/* Reset the axis to update the initial
	   sider position. */
	
	if(dJointGetBody([self joint], 0) ||
	   dJointGetBody([self joint], 1)) {
	    dJointSetSliderAxis ([self joint],
				 self->axis[0],
				 self->axis[1],
				 self->axis[2]);
	}
    }
}

@end
