/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <math.h>
#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include "static.h"

#define USE_VBO

@implementation Static

-(Static *) initWithVertices: (GLfloat *)floats
		  andIndices: (GLushort *)shorts
		      ofSize: (int[2]) n
{
    unsigned int b[2];
    float r, d;
    int i;
    
    [super init];
    
    /* Calculate the radius of the mesh's bounding sphere. */
    
    for (i = 0, r = 0 ; i < n[0] ; i += 1, r = r < d ? d : r) {
	GLfloat *v;

	v = floats + 8 * i;
	d = v[0] * v[0] + v[1] * v[1] + v[2] * v[2];
    }

    /* Create the buffer objects. */

    glGenBuffersARB(2, b);
    
    glBindBufferARB(GL_ARRAY_BUFFER, b[0]);
    glBufferDataARB(GL_ARRAY_BUFFER, n[0] * 8 * sizeof(GLfloat),
		 floats, GL_STATIC_DRAW);
	

    glBindBufferARB(GL_ELEMENT_ARRAY_BUFFER, b[1]);
    glBufferDataARB(GL_ELEMENT_ARRAY_BUFFER, n[1] * sizeof(GLushort),
		 shorts, GL_STATIC_DRAW);

    self->buffers[0] = b[0];
    self->buffers[1] = b[1];
    
    self->size[0] = n[0];
    self->size[1] = n[1];

    self->bound = sqrt(r);

    return self;
}

-(void) freeBuffers
{
    glDeleteBuffersARB(2, self->buffers);
}

-(int) vertices
{
    return self->size[0];
}

-(int) indices
{
    return self->size[1];
}

-(float) bound
{
    return self->bound;
}

-(void) draw
{
    GLfloat *r, *R;

    r = [self translation];
    R = [self rotation];
 
    glMatrixMode (GL_MODELVIEW);
    glPushMatrix();
    glMultMatrixf ((GLfloat[16]) {R[0], R[3], R[6], 0,
		                  R[1], R[4], R[7], 0,
		                  R[2], R[5], R[8], 0,
		                  r[0], r[1], r[2], 1});

/*     glPolygonMode (GL_FRONT_AND_BACK, GL_LINE); */
    
    glClientActiveTexture (GL_TEXTURE0);
    glEnableClientState(GL_VERTEX_ARRAY);
    glEnableClientState(GL_NORMAL_ARRAY);
    glEnableClientState(GL_TEXTURE_COORD_ARRAY);

    glBindBufferARB(GL_ARRAY_BUFFER, self->buffers[0]);

    glVertexPointer(3, GL_FLOAT, 32, (void *)0);
    glNormalPointer(GL_FLOAT, 32, (void *)(3 * sizeof(GLfloat)));
    glTexCoordPointer(2, GL_FLOAT, 32, (void *)(6 * sizeof(GLfloat)));

    glBindBufferARB(GL_ELEMENT_ARRAY_BUFFER, self->buffers[1]);
    glDrawElements(GL_TRIANGLES, self->size[1], GL_UNSIGNED_SHORT, (void *)0);

    glBindBufferARB(GL_ARRAY_BUFFER, 0);
    glBindBufferARB(GL_ELEMENT_ARRAY_BUFFER, 0);

    glDisableClientState(GL_VERTEX_ARRAY);
    glDisableClientState(GL_NORMAL_ARRAY);
    glDisableClientState(GL_TEXTURE_COORD_ARRAY);

    glPopMatrix();

    [super draw];
}

@end
