/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include <GL/glu.h>

#include "string.h"

@implementation String
-(String *)initFromPixels: (unsigned char *) pixels
           ofSize: (int[2]) size
{
    int v[4];

    [super init];
    
    glActiveTexture(GL_TEXTURE0);
    glGenTextures(1, &self->texture);
    glBindTexture(GL_TEXTURE_2D, self->texture);
	
    glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
    glPixelStorei(GL_UNPACK_ROW_LENGTH, size[0]);
    
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

    glTexImage2D(GL_TEXTURE_2D, 0, 
		 GL_ALPHA,
		 size[0],
		 size[1],
		 0, 
		 GL_ALPHA,
		 GL_UNSIGNED_BYTE,
		 pixels);

    glPixelStorei(GL_UNPACK_ROW_LENGTH, 0);
    glPixelStorei(GL_UNPACK_ALIGNMENT, 4);

    glGetIntegerv(GL_VIEWPORT, v);
    
    self->minimum[0] = size[0];
    self->minimum[1] = size[1];

    self->allocated[0] = self->minimum[0] / v[2];
    self->allocated[1] = self->minimum[1] / v[3];

    return self;
}

-(void) freeTexture
{
    glDeleteTextures(1, &self->texture);
}

-(void)transform: (lua_State *)L
{
    GLint v[4];

    [super transform: L];

    glGetIntegerv(GL_VIEWPORT, v);

    self->allocated[0] = self->minimum[0] / v[2];
    self->allocated[1] = self->minimum[1] / v[3];

    self->allocated[0] = self->allocated[0] > self->requested[0] ?
	                 self->allocated[0] : self->requested[0];
    self->allocated[1] = self->allocated[1] > self->requested[1] ?
	                 self->allocated[1] : self->requested[1];
}

-(void)cleanup: (lua_State *)L
{
    GLfloat *r, *R;

    r = [self translation];
    R = [self rotation];

    glMatrixMode (GL_MODELVIEW);
    glPushMatrix();
    glMultMatrixf ((GLfloat[16]) {R[0], R[3], R[6], 0,
		                  R[1], R[4], R[7], 0,
		                  R[2], R[5], R[8], 0,
		                  r[0] - self->allocated[0] / 2,
		                  r[1] - self->allocated[1] / 2,
		                  r[2], 1});
    
    glColor4fv (self->color);
    
    glActiveTexture(GL_TEXTURE0);
    glEnable(GL_TEXTURE_2D);
    glBindTexture(GL_TEXTURE_2D, self->texture);

    glDepthMask (GL_FALSE);
    glDisable(GL_DEPTH_TEST);

    glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_BLEND);

    glBegin(GL_QUADS);
    glTexCoord2f(0, 0);
    glVertex2f(0, 0);
    glTexCoord2f(1, 0);
    glVertex2f(self->allocated[0], 0);
    glTexCoord2f(1, 1);
    glVertex2f(self->allocated[0], self->allocated[1]);
    glTexCoord2f(0, 1);
    glVertex2f(0, self->allocated[1]);
    glEnd();

    glDepthMask (GL_TRUE);

    glDisable(GL_BLEND);
    glDisable(GL_TEXTURE_2D);
    glEnable(GL_DEPTH_TEST);
    
    glMatrixMode (GL_MODELVIEW);
    glPopMatrix();

    [super cleanup: L];
}
@end


