/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <GL/gl.h>
#include "dashed.h"

@implementation Dashed

-(Dashed *)init
{
    [super init];
    
    self->factor = 1;

    return self;
}

-(void) get
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "factor")) {
	lua_pushnumber (_L, self->factor);
    } else {
	[super get];
    }
}

-(void) set
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "factor")) {
	self->factor = lua_tonumber (_L, 3);
    } else {
	[super set];
    }
}

-(void) cleanup
{
    glLineStipple(self->factor, 0x5555);
    glEnable (GL_LINE_STIPPLE);
  
    [super cleanup];

    glDisable (GL_LINE_STIPPLE);
}

@end
