/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "plane.h"

@implementation Plane

-(Plane *) init
{
    self->geom = dCreatePlane (NULL, 0, 0, 1, 0);
    
    [super init];

    return self;
}

-(void) set
{
    const char *k;
    
    [super set];

    k = lua_tostring (_L, -2);

    if (!xstrcmp(k, "position") || !xstrcmp(k, "orientation")) {
	float *r, *R;

	r = [self position];
	R = [self orientation];
	    
	dGeomPlaneSetParams (self->geom,
			     R[2], R[5], R[8],
			     r[0] * R[2] +
			     r[1] * R[5] +
			     r[2] * R[8]);
    }
}

@end
