-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

require "widgets"
require "morewidgets"

widgets.small = widgets.face "Sans-14"
widgets.regular = widgets.face "Sans-20"

graph.message = widgets.display {
   background = {0.28, 0.24, 0.55},
   size = {1, 1},
   padding = {0.03, 0.03},
   align = {-1, -1},

   lines = widgets.column {}
}

graph.framerate = options.framerate and widgets.display {
   background = {0.28, 0.24, 0.55},
   size = {1, 1},
   padding = {0.03, 0.03},
   align = {1, 1},

   label = widgets.regular {
      frames.timer {
	 period = 1,

	 link = function ()
		   graphics.oldframes = graphics.frames
		end,

	 tick = function (self, n, delta, elapsed)
		   self.parent.text = string.format ("%.1f",
						     (graphics.frames -
						      graphics.oldframes) /
						     delta)

		   graphics.oldframes = graphics.frames
		end
      }
   }
}

local meta = getmetatable (graph.message.lines)
local oldindex = meta.__index
local oldnewindex = meta.__newindex

meta.__index = function (self, key)
		  local widget

		  key = tonumber(key)
		  widget = oldindex (self, key)

		  if key then
		     if widget then
			return widget.text
		     else
			return nil
		     end
		  else
		     return oldindex (self, key)
		  end
	       end

meta.__newindex = function (self, key, value)
		     local widget

		     key = tonumber(key)
		     widget = oldindex (self, key)

		     if key then
			if not value then
			   oldnewindex(self, key, nil)
			else
			   if not widget then
			      widget = widgets.small {
				 size = {0.9, 0},
				 align = {-1, 0},

				 fader = frames.timer {
				    period = 0,
				    timeout = 5,
				    
				    tick = function (self, n, delta, elapsed)
				       self.parent.opacity = self.timeout -
						             elapsed
					      
				       if elapsed >= self.timeout then
					  self.parent.parent = nil
				       end
				    end
				 }
			      }

			      oldnewindex (self, key, widget)
			   end
			   
			   widget.text = tostring(value)
			end
		     else
			oldnewindex(self, key, value)
		     end
		  end
