-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

if options.slow then
   billiards.cuecollision.experiment = function ()
					  dynamics.timescale = 0.125
				       end

   billiards.looking.experiment = function ()
					  dynamics.timescale = 1
				       end
end
 
if options.experiment then
   billiards.opening[1] = {0.25 * billiards.tablewidth,
			   0,
			   billiards.ballradius}
      
   billiards.aiming.experiment = function ()
      bodies.cue.sidespin = 0
      bodies.cue.elevation = math.rad(25)
      bodies.cue.follow = 0.004

      bodies.observer.radius = 0.4
      bodies.observer.elevation = math.pi / 2 -
				  bodies.cue.elevation -
				  math.rad (10)
   end

   if options.squirt then
      billiards.ballradius = 50.3e-3 / 2
      billiards.ballmass = 120e-3

      billiards.cueinertia = 0.0014
      billiards.cuemass = 186e-3

      billiards.staticfriction = 0
      billiards.slidingfriction = 0
      billiards.rollingfriction = 0
      billiards.spinningfriction = 0
      billiards.strikingfriction = 0.8
      
      billiards.aiming.experiment = function ()
         bodies.cue.sidespin = 13e-3
         bodies.cue.elevation = 0
         bodies.cue.follow = 0

         bodies.observer.radius = 0.4
         bodies.observer.elevation = math.pi / 2 -
			             bodies.cue.elevation -
			             math.rad (10)
      end

      dynamics.collision.experiment = function (a, b)
         local ball, other

         ball = a.isball and a or b
         other = a.isball and b or a

         if other.iscushion then
	    print (math.deg(math.atan2(ball.position[2],-ball.position[1])))
	    common.iterate = false
	 end
      end
   end
end
