/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <ode/ode.h>
#include <lua.h>
#include <lualib.h>
#include <lauxlib.h>

#include "ball.h"

@implementation Ball

-(Ball *) init
{
    self->geom = dCreateSphere (NULL, 1);
    self->radius = 1;

    dGeomSetData (self->geom, self);
      
    [super init];
  
    return self;
}

-(void) get
{
    const char *k;
    
    k = lua_tostring (_L, -1);

    if (!xstrcmp(k, "radius")) {
	lua_pushnumber (_L, self->radius);
    } else {
	[super get];
    }
}

-(void) set
{
    const char *k;

    k = lua_tostring (_L, -2);

    if (!xstrcmp(k, "radius")) {
	self->radius = lua_tonumber (_L, 3);

	dGeomSphereSetRadius ([self geom], self->radius);
    } else {
	[super set];
    }
}

@end
