/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include <ode/ode.h>
#include "convex.h"

@implementation Convex

-(Convex *) init
{
    self->geom = dCreateConvex (NULL,
				self->planes, self->size[1],
				self->points, self->size[0],
				self->polygons);

    dGeomSetData (self->geom, self);
  
    [super init];

    return self;
}

-(void) freeData
{
    free (self->planes);
    free (self->points);
    free (self->polygons);
}

-(Convex *) initWith: (int) n planes: (dReal *) reals
                 and: (int) m points: (dReal *) morereals
	 andPolygons: (unsigned int *) unsigneds
{
    [super init];

    self->size[0] = m;
    self->size[1] = n;

    self->planes = reals;
    self->points = morereals;
    self->polygons = unsigneds;

    return self;
}

-(int) planes
{
    return self->size[0];
}

-(int) points
{
    return self->size[1];
}

#if 1
-(void) traverse
{
    int i, j, k;

    glUseProgramObjectARB(0);

    glMatrixMode (GL_MODELVIEW);
    glPushMatrix();
    glMultMatrixf ([self homogenous]);

    glPolygonMode (GL_FRONT_AND_BACK, GL_LINE);
    glEnable (GL_DEPTH_TEST);

    glColor3f (1, 0, 0);
    glLineWidth (1);
    
    for (i = 0, j = 0;
	 i < self->size[1];
	 i += 1, j += self->polygons[j] + 1) {
	
	glBegin (GL_POLYGON);

	for (k = 0 ; k < self->polygons[j] ; k += 1) {
	    glVertex3dv (&self->points[3 * self->polygons[j + k + 1]]);
	}
	
	glEnd();
    }

    glDisable (GL_DEPTH_TEST);
    glPolygonMode (GL_FRONT_AND_BACK, GL_FILL);

    glPopMatrix();

    [super traverse];
}
#endif

@end
