/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <lua.h>
#include <lauxlib.h>
#include <png.h>

static int reference;

static void writedata(png_structp png, png_bytep data, png_size_t length)
{
    luaL_addlstring ((luaL_Buffer *) png_get_io_ptr (png),
		     (const char *) data,
		     (size_t) length);
}

static int savescreen (lua_State *L)
{
    luaL_Buffer buffer;
    png_structp png;
    png_infop info;
    png_bytep *rows;
    int width, height, i;
    unsigned char *pixels;
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "screenshot")) {
	png = png_create_write_struct (PNG_LIBPNG_VER_STRING, NULL, NULL, NULL);
	info = png_create_info_struct(png);

	if (!png) {
	    return 0;
	}

	if (!info) {
	    png_destroy_write_struct(&png, NULL);
       
	    return 0;
	}
    
	if (setjmp(png_jmpbuf(png))) {
	    png_destroy_write_struct(&png, &info);

	    return 0;
	}

	png_set_write_fn (png, (png_voidp)&buffer, writedata, NULL);	

	lua_getglobal (_L, "graphics");
	lua_getfield (_L, -1, "window");

	lua_rawgeti (L, -1, 1);
	width = lua_tonumber (L, -1);
	lua_pop (L, 1);

	lua_rawgeti (L, -1, 2);
	height = lua_tonumber (L, -1);
	lua_pop (L, 1);

	lua_getglobal (L, "graphics");
	lua_getfield (L, -1, "colorbuffer");

	pixels = (unsigned char *) lua_tostring (L, -1);
	rows = png_malloc(png, height * png_sizeof(png_bytep));

	for (i = 0; i < height ; i += 1) {
	    rows[height - i - 1] = pixels + i * width * 3;
	}
    
	png_set_rows(png, info, rows);
	png_set_IHDR (png, info, width, height, 8,
		      PNG_COLOR_TYPE_RGB, PNG_INTERLACE_NONE,
		      PNG_COMPRESSION_TYPE_DEFAULT, PNG_FILTER_TYPE_DEFAULT);

	lua_settop (L, 0);
	luaL_buffinit (L, &buffer);

	png_write_png(png, info, PNG_TRANSFORM_IDENTITY, NULL);
	png_write_end (png, NULL);
    
	luaL_pushresult(&buffer);
    
	png_free_data (png, info, PNG_FREE_ALL, -1);
	png_destroy_write_struct(&png, &info);
    } else {
	lua_rawgeti (L, LUA_REGISTRYINDEX, reference);
	lua_insert (L, 1);
	lua_call (L, 2, 1);
    }

    return 1;
}

int luaopen_screenshot (lua_State *L)
{
    lua_getglobal (L, "graphics");
    lua_getmetatable (L, -1);
    lua_getfield (L, -1, "__index");
    reference = luaL_ref (L, LUA_REGISTRYINDEX);

    lua_pushcfunction (L, savescreen);
    lua_setfield (L, -2, "__index");

    return 0;
}
