/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <GL/glu.h>
#include "transition.h"

@implementation Transition

-(Transition *) init
{
    self = [super init];
    
    self->texture = 0;
    self->duration = 1;
    
    return self;
}

-(void) toggle
{
    clock_gettime (CLOCK_REALTIME, &self->start);
    
    [super toggle];

    if (!self->linked) {
	glDeleteTextures (1, &self->texture);
	self->texture = 0;
    }
}
    
-(void) get
{
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "duration")) {
	lua_pushnumber (_L, self->duration);
    } else {
	[super get];
    }
}

-(void) set
{    
    const char *k;

    k = lua_tostring (_L, 2);

    if (!xstrcmp(k, "duration")) {
	self->duration = lua_tonumber (_L, -1);
    } else {
	[super set];
    }
}

-(void) cleanup
{
    struct timespec time;
    
    if (!self->texture) {
	int viewport[4];
	GLenum error;
	
	glGetIntegerv (GL_VIEWPORT, viewport);
	
	glGetError();
	glActiveTexture(GL_TEXTURE0);
	glGenTextures(1, &self->texture);
	glBindTexture(GL_TEXTURE_2D, self->texture);
    
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);

	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);

	glReadBuffer (GL_BACK);
	glCopyTexImage2D (GL_TEXTURE_2D,
			  0, GL_RGB,
			  viewport[0], viewport[1],
			  viewport[2], viewport[3],
			  0);
	glReadBuffer (GL_FRONT);
		
	error = glGetError();
	if(error != GL_NO_ERROR) {
	    printf ("Could not create transition texture (%s)\n",
		    (char *)gluErrorString(error));
	}
    }

    clock_gettime (CLOCK_REALTIME, &time);   

    self->delta = time.tv_sec - self->start.tv_sec +
	          (time.tv_nsec - self->start.tv_nsec) * 1e-9;


    [super cleanup];
}

@end
