/* Copyright (C) 2008 Papavasileiou Dimitris                             
 *                                                                      
 * This program is free software: you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation, either version 3 of the License, or    
 * (at your option) any later version.                                  
 *                                                                      
 * This program is distributed in the hope that it will be useful,      
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
 * GNU General Public License for more details.                         
 *                                                                      
 * You should have received a copy of the GNU General Public License    
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <lua.h>
#include <lauxlib.h>
#include "gimbal.h"

@implementation Gimbal

-(void) transform
{
    GLfloat *R;

    R = [[self parent] orientation];
	
    self->orientation[0] = R[0];
    self->orientation[1] = R[3];
    self->orientation[2] = R[6];

    self->orientation[3] = R[1];
    self->orientation[4] = R[4];
    self->orientation[5] = R[7];

    self->orientation[6] = R[2];
    self->orientation[7] = R[5];
    self->orientation[8] = R[8];
    
    [super transform];
}

@end
