-- Copyright (C) 2008 Papavasileiou Dimitris                             
--                                                                      
-- This program is free software: you can redistribute it and/or modify 
-- it under the terms of the GNU General Public License as published by 
-- the Free Software Foundation, either version 3 of the License, or    
-- (at your option) any later version.                                  
--                                                                      
-- This program is distributed in the hope that it will be useful,      
-- but WITHOUT ANY WARRANTY; without even the implied warranty of       
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
-- GNU General Public License for more details.                         
--                                                                      
-- You should have received a copy of the GNU General Public License    
-- along with this program.  If not, see <http://www.gnu.org/licenses/>.

local threshold = 1e-3

require "dynamics"
require "physics"
require "moremath"

bodies.simpleball = bodies.simpleball or bodies.ball

function bodies.ball (values)
   local meta, self

   self = bodies.simpleball {
--       logger = frames.timer {
-- 	 period = 0,
	 
-- 	 link = function (self)
-- 		   speed = io.open ("SPEED", "w+")
-- 		   spin = io.open ("SPIN", "w+")
-- 		end,

-- 	 transform = function (self, n, delta, elapsed)
-- 	    if not self.isresting and self.parent == cueball  then
-- 	       local u = self.parent.velocity
-- 	       local v = math.cross (self.parent.spin, {0, 0, self.parent.radius})

--  	       speed:write (string.format ("%.5f %.5e\n",
-- 					   elapsed,
-- 					   math.length (u)))
-- --					   math.length (math.subtract (u, v))))
-- 	    end
-- 	 end
--       },

      linear = motors.linear {
	 motor = {{0, billiards.rollingfriction * billiards.ballmass *
		   math.abs(dynamics.gravity[3])}}
      },

      angular = motors.angular {
	 motor = {{0, 0.4 * billiards.rollingfriction * billiards.ballmass *
		   billiards.ballradius * math.abs(dynamics.gravity[3])},
	          {0, billiards.spinningfriction * billiards.ballmass *
		   math.abs(dynamics.gravity[3])}}
      },

      link = function (self)
		self.linear.bodies = {nil, self}
		self.angular.bodies = {nil, self}
	     end,

      transform = function (self)
         if self.home then
	    physics.addforce (self,
			      {100 * (self.home[1] - self.position[1]) -
			       35 * self.velocity[1],
			       100 * (self.home[2] - self.position[2]) -
			       35 * self.velocity[2],
			       2000 * (self.home[3] - self.position[3]) -
			       150 * self.velocity[3]})
	 end
      end,

      step = function (self)
		local u = math.normalize(self.velocity)
		local v = {-u[2], u[1], u[3]}
		     
		self.linear.axes = {u}
		self.angular.axes = {v, {0, 0, 1}}
	     end,

      unlink = function (self)
		  self.linear.bodies = {nil, nil}
		  self.angular.bodies = {nil, nil}
	       end
   }

   meta = getmetatable (self)
   meta.oldindex = meta.__index
   meta.oldnewindex = meta.__newindex

   meta.__index = function (self, key)
      local meta = getmetatable(self)

      if key == "isout" then
	 return -- math.abs(self.position[1]) > 0.5 * billiards.tablewidth + 0.3 or
-- 	        math.abs(self.position[2]) > 0.5 * billiards.tableheight + 0.3 or
	        self.position[3] < -0.5
      elseif key == "ispocketed" then
	 return math.abs(self.position[1]) < 0.5 * billiards.tablewidth + 0.15 and
	        math.abs(self.position[2]) < 0.5 * billiards.tableheight + 0.15 and
	        self.position[3] < -billiards.ballradius
      elseif key == "isresting" then
	 return math.length (self.velocity) < threshold and
	        math.length2 (self.spin) < threshold
      elseif key == "isrolling" then
	 local u = self.velocity
	 local v = math.cross (self.spin, {0, 0, self.radius})

	 return math.length (math.subtract (u, v)) < threshold and
	        not self.isresting
      else
	 return meta.oldindex (self, key)
      end
   end

   meta.__newindex = function (self, key, value)
      local meta = getmetatable(self)

      if key == "isout" then
      elseif key == "ispocketed" then
      elseif key == "isresting" then
      elseif key == "isrolling" then
      else
	 meta.oldnewindex(self, key, value)
      end
   end

   meta.__tostring = function(self)
			 return "Billiard"
		      end

   for key, value in pairs(values) do
      self[key] = value
   end

   return self
end
