<!--
    Copyright (C) 2008 Papavasileiou Dimitris                             
                                                                     
    This program is free software: you can redistribute it and/or modify 
    it under the terms of the GNU General Public License as published by 
    the Free Software Foundation, either version 3 of the License, or    
    (at your option) any later version.                                  
    
    This program is distributed in the hope that it will be useful,      
    but WITHOUT ANY WARRANTY; without even the implied warranty of       
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        
    GNU General Public License for more details.                         
                                                                     
    You should have received a copy of the GNU General Public License    
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->

<head>

  <title>Game</title>
  <link rel="stylesheet" href="stylesheet">

    <style type="text/css">
      col.first {width : 12em;}
      col.second {width : 7em ;}
    </style>
</head>

<body>

  <hr> 
  <h1>
    <image type="image/svg+xml" src="/logo"/>
  </h1>
  
  <a href = "/">back</a>
  <hr> 

  <p>You can use the following links to start a new game.  Note that
    this only selects the proper table type and sets up the balls
    according to the specified game's opening positions. No rule checking
    or enforcement is implied.  Games which share the same opening setup
    (e.g. straight rail and cushion billiards) are therefore grouped
    together.
  </p>

  <p>Currently the following games are available:</p>

  <ul>
    <li> Pocket games
      <ul>
	<li>
	  <a href="/newgame?newgame=true&options.eightball=true&options.pool=true">
	    Eight-ball
	  </a>
	<li>
	  <a href="/newgame?newgame=true&options.nineball=true&options.pool=true">
	    Nine-ball
	  </a>
      </ul>
    <li> Pocketless games
      <ul>
	<li>
	  <a href="/newgame?newgame=true&options.carom=true&options.billiards=true">
	    Billiards
	  </a>
      </ul>
  </ul>

  <p>
    <form action="/newgame" enctype="multipart/form-data" method="post">
      <input type="hidden" name="importgame" value="true" />
      You can also select a game that has been exported to a file: <input type="file" name="file" /> and <a href="javascript:document.forms[0].submit();">import</a> it.
    </form>
  </p>

  <?lua
    if query.newgame then
       billiards.history = {}

       billiards.opening = nil
       billiards.decals = nil

       options.eightball = false
       options.nineball = false
       options.carom = false

       options.pool = false
       options.billiards = false

       for key, value in pairs (query) do
	  assert (loadstring(key .. "=" .. value))()
       end

       resources.dofile "billiards/restart.lua"
    end

    if query.importgame and #query.file[3] > 0 then
       restoregame = loadstring(query.file[3])

       if restoregame then
	  restoregame()
	  resources.dofile "billiards/restart.lua"
       end
    end
  ?>

  </table>
  <hr> 
  
</body>
