
/* This file is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2, or (at your option) */
/* any later version. */

/* This file is distributed in the hope that it will be useful, */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the */
/* GNU General Public License for more details. */

/* You should have received a copy of the GNU General Public License */
/* along with GNU Emacs; see the file COPYING.  If not, write to */
/* the Free Software Foundation, Inc., 59 Temple Place - Suite 330, */
/* Boston, MA 02111-1307, USA. */

/* Copyright (C) 2004 Ian Zimmerman */

/* $Id: error.c,v 1.4 2004/04/29 22:51:19 summerisle Exp $ */


#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <stdlib.h>
#include <stdarg.h>

void
error (int status, int errnum, const char *format, ...)
{
  int len;

  fprintf (stderr, "biosconfig: ");
  if (errnum != 0)
    {
      fprintf (stderr, "%s: ", strerror (errnum));
    }
  {
    va_list ap;

    va_start (ap, format);
    vfprintf (stderr, format, ap);
    va_end (ap);
  }
  len = strlen (format);
  if (len == 0 || format[len - 1] != '\n')
    fprintf (stderr, "\n");
  if (status != 0) exit (status);
}

void
error_at_line (int status, int errnum, const char *fname,
               unsigned int lineno, const char *format, ...)
{
  int len;

  fprintf (stderr, "biosconfig: %s: %d: ", fname, lineno);
  if (errnum != 0)
    {
      fprintf (stderr, "%s: ", strerror (errnum));
    }
  {
    va_list ap;

    va_start (ap, format);
    vfprintf (stderr, format, ap);
    va_end (ap);
  }
  len = strlen (format);
  if (len == 0 || format[len - 1] != '\n')
    fprintf (stderr, "\n");
  if (status != 0) exit (status);
}
